/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.TimeAnimator;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import org.json.JSONObject;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PlatLogoActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    FrameLayout layout;
    TimeAnimator anim;
    PBackground bg;

    private void $$robo$$com_android_internal_app_PlatLogoActivity$__constructor__() {
    }

    private final void $$robo$$com_android_internal_app_PlatLogoActivity$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.layout = new FrameLayout(this);
        this.setContentView(this.layout);
        this.bg = new PBackground(this);
        this.layout.setBackground(this.bg);
        ContentResolver cr = this.getContentResolver();
        this.layout.setOnTouchListener(new View.OnTouchListener(this, cr){
            public transient /* synthetic */ Object __robo_data__;
            String TOUCH_STATS = "touch.stats";
            MotionEvent.PointerCoords pc0;
            MotionEvent.PointerCoords pc1;
            double pressure_min;
            double pressure_max;
            int maxPointers;
            int tapCount;
            /* synthetic */ ContentResolver val$cr;
            /* synthetic */ PlatLogoActivity this$0;

            private void $$robo$$com_android_internal_app_PlatLogoActivity_1$__constructor__(PlatLogoActivity this$0, ContentResolver contentResolver) {
                this.TOUCH_STATS = "touch.stats";
                this.pc0 = new MotionEvent.PointerCoords();
                this.pc1 = new MotionEvent.PointerCoords();
            }

            private final boolean $$robo$$com_android_internal_app_PlatLogoActivity_1$onTouch(View v, MotionEvent event) {
                float pressure = event.getPressure();
                switch (event.getActionMasked()) {
                    case 0: {
                        this.pressure_min = this.pressure_max = (double)pressure;
                    }
                    case 2: {
                        int pc;
                        if ((double)pressure < this.pressure_min) {
                            this.pressure_min = pressure;
                        }
                        if ((double)pressure > this.pressure_max) {
                            this.pressure_max = pressure;
                        }
                        if ((pc = event.getPointerCount()) > this.maxPointers) {
                            this.maxPointers = pc;
                        }
                        if (pc <= 1) break;
                        event.getPointerCoords(0, this.pc0);
                        event.getPointerCoords(1, this.pc1);
                        this.this$0.bg.setRadius((float)Math.hypot(this.pc0.x - this.pc1.x, this.pc0.y - this.pc1.y) / 2.0f);
                        break;
                    }
                    case 1: 
                    case 3: {
                        try {
                            String touchDataJson = Settings.System.getString(this.val$cr, "touch.stats");
                            JSONObject touchData = new JSONObject(touchDataJson != null ? touchDataJson : "{}");
                            if (touchData.has("min")) {
                                this.pressure_min = Math.min(this.pressure_min, touchData.getDouble("min"));
                            }
                            if (touchData.has("max")) {
                                this.pressure_max = Math.max(this.pressure_max, touchData.getDouble("max"));
                            }
                            touchData.put("min", this.pressure_min);
                            touchData.put("max", this.pressure_max);
                            Settings.System.putString(this.val$cr, "touch.stats", touchData.toString());
                        }
                        catch (Exception e) {
                            Log.e("PlatLogoActivity", "Can't write touch settings", e);
                        }
                        if (this.maxPointers == 1) {
                            ++this.tapCount;
                            if (this.tapCount < 7) {
                                this.this$0.bg.randomizePalette();
                            } else {
                                this.this$0.launchNextStage();
                            }
                        } else {
                            this.tapCount = 0;
                        }
                        this.maxPointers = 0;
                    }
                }
                return true;
            }

            private void __constructor__(PlatLogoActivity platLogoActivity, ContentResolver contentResolver) {
                this.$$robo$$com_android_internal_app_PlatLogoActivity_1$__constructor__(platLogoActivity, contentResolver);
            }
            {
                this.this$0 = platLogoActivity;
                this.val$cr = contentResolver;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_PlatLogoActivity_1$__constructor__(com.android.internal.app.PlatLogoActivity android.content.ContentResolver ), 0, this, platLogoActivity, contentResolver);
            }

            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$com_android_internal_app_PlatLogoActivity_1$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_app_PlatLogoActivity$launchNextStage() {
        ContentResolver cr = this.getContentResolver();
        if (Settings.System.getLong(cr, "egg_mode", 0L) == 0L) {
            try {
                Settings.System.putLong(cr, "egg_mode", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
            }
            catch (RuntimeException e) {
                Log.e("PlatLogoActivity", "Can't write settings", e);
            }
        }
        try {
            this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10008000).addCategory("com.android.internal.category.PLATLOGO"));
        }
        catch (ActivityNotFoundException ex) {
            Log.e("PlatLogoActivity", "No more eggs.");
        }
        this.finish();
    }

    private final void $$robo$$com_android_internal_app_PlatLogoActivity$onStart() {
        super.onStart();
        this.bg.randomizePalette();
        this.anim = new TimeAnimator();
        this.anim.setTimeListener(new TimeAnimator.TimeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PlatLogoActivity this$0;

            private void $$robo$$com_android_internal_app_PlatLogoActivity_2$__constructor__(PlatLogoActivity this$0) {
            }

            private final void $$robo$$com_android_internal_app_PlatLogoActivity_2$onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
                this.this$0.bg.setOffset((float)totalTime / 60000.0f);
                this.this$0.bg.invalidateSelf();
            }

            private void __constructor__(PlatLogoActivity platLogoActivity) {
                this.$$robo$$com_android_internal_app_PlatLogoActivity_2$__constructor__(platLogoActivity);
            }
            {
                this.this$0 = platLogoActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_PlatLogoActivity_2$__constructor__(com.android.internal.app.PlatLogoActivity ), 0, this, platLogoActivity);
            }

            @Override
            public void onTimeUpdate(TimeAnimator timeAnimator, long l, long l2) {
                InvokeDynamicSupport.bootstrap("onTimeUpdate", $$robo$$com_android_internal_app_PlatLogoActivity_2$onTimeUpdate(android.animation.TimeAnimator long long ), 0, this, timeAnimator, l, l2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.anim.start();
    }

    private final void $$robo$$com_android_internal_app_PlatLogoActivity$onStop() {
        if (this.anim != null) {
            this.anim.cancel();
            this.anim = null;
        }
        super.onStop();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_PlatLogoActivity$__constructor__();
    }

    public PlatLogoActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_PlatLogoActivity$__constructor__(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_PlatLogoActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private void launchNextStage() {
        InvokeDynamicSupport.bootstrap("launchNextStage", $$robo$$com_android_internal_app_PlatLogoActivity$launchNextStage(), 0, this);
    }

    @Override
    public void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$com_android_internal_app_PlatLogoActivity$onStart(), 0, this);
    }

    @Override
    public void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$com_android_internal_app_PlatLogoActivity$onStop(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlatLogoActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PBackground
    extends Drawable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float maxRadius;
        private float radius;
        private float x;
        private float y;
        private float dp;
        private int[] palette;
        private int darkest;
        private float offset;
        /* synthetic */ PlatLogoActivity this$0;

        private void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$__constructor__(PlatLogoActivity platLogoActivity) {
            this.randomizePalette();
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setRadius(float r) {
            this.radius = Math.max(48.0f * this.dp, r);
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setOffset(float o) {
            this.offset = o;
        }

        private final float $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$lum(int rgb) {
            return ((float)Color.red(rgb) * 299.0f + (float)Color.green(rgb) * 587.0f + (float)Color.blue(rgb) * 114.0f) / 1000.0f;
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$randomizePalette() {
            int slots = 2 + (int)(Math.random() * 2.0);
            float[] color2 = new float[]{(float)Math.random() * 360.0f, 1.0f, 1.0f};
            this.palette = new int[slots];
            this.darkest = 0;
            for (int i = 0; i < slots; ++i) {
                this.palette[i] = Color.HSVToColor(color2);
                color2[0] = (color2[0] + 360.0f / (float)slots) % 360.0f;
                if (!(this.lum(this.palette[i]) < this.lum(this.palette[this.darkest]))) continue;
                this.darkest = i;
            }
            StringBuilder str = new StringBuilder();
            for (int c : this.palette) {
                str.append(String.format("#%08x ", c));
            }
            Log.v("PlatLogoActivity", "color palette: " + str);
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$draw(Canvas canvas) {
            if (this.dp == 0.0f) {
                this.dp = this.this$0.getResources().getDisplayMetrics().density;
            }
            float width = canvas.getWidth();
            float height = canvas.getHeight();
            if (this.radius == 0.0f) {
                this.setPosition(width / 2.0f, height / 2.0f);
                this.setRadius(width / 6.0f);
            }
            float inner_w = this.radius * 0.667f;
            Paint paint = new Paint();
            paint.setStrokeCap(Paint.Cap.BUTT);
            canvas.translate(this.x, this.y);
            Path p = new Path();
            p.moveTo(-this.radius, height);
            p.lineTo(-this.radius, 0.0f);
            p.arcTo(-this.radius, -this.radius, this.radius, this.radius, -180.0f, 270.0f, false);
            p.lineTo(-this.radius, this.radius);
            float w = (float)Math.max(canvas.getWidth(), canvas.getHeight()) * 1.414f;
            paint.setStyle(Paint.Style.FILL);
            int i = 0;
            while (w > this.radius * 2.0f + inner_w * 2.0f) {
                paint.setColor(0xFF000000 | this.palette[i % this.palette.length]);
                canvas.drawOval(-w / 2.0f, -w / 2.0f, w / 2.0f, w / 2.0f, paint);
                w = (float)((double)w - (double)inner_w * ((double)1.1f + Math.sin(((float)i / 20.0f + this.offset) * 3.14159f)));
                ++i;
            }
            paint.setColor(0xFF000000 | this.palette[(this.darkest + 1) % this.palette.length]);
            canvas.drawOval(-this.radius, -this.radius, this.radius, this.radius, paint);
            p.reset();
            p.moveTo(-this.radius, height);
            p.lineTo(-this.radius, 0.0f);
            p.arcTo(-this.radius, -this.radius, this.radius, this.radius, -180.0f, 270.0f, false);
            p.lineTo(-this.radius + inner_w, this.radius);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(inner_w * 2.0f);
            paint.setColor(this.palette[this.darkest]);
            canvas.drawPath(p, paint);
            paint.setStrokeWidth(inner_w);
            paint.setColor(-1);
            canvas.drawPath(p, paint);
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setAlpha(int alpha) {
        }

        private final void $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setColorFilter(ColorFilter colorFilter) {
        }

        private final int $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$getOpacity() {
            return 0;
        }

        private void __constructor__(PlatLogoActivity platLogoActivity) {
            this.$$robo$$com_android_internal_app_PlatLogoActivity_PBackground$__constructor__(platLogoActivity);
        }

        public PBackground(PlatLogoActivity platLogoActivity) {
            this.this$0 = platLogoActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$__constructor__(com.android.internal.app.PlatLogoActivity ), 0, this, platLogoActivity);
        }

        public void setRadius(float f) {
            InvokeDynamicSupport.bootstrap("setRadius", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setRadius(float ), 0, this, f);
        }

        public void setPosition(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setPosition", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setPosition(float float ), 0, this, f, f2);
        }

        public void setOffset(float f) {
            InvokeDynamicSupport.bootstrap("setOffset", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setOffset(float ), 0, this, f);
        }

        public float lum(int n) {
            return (float)InvokeDynamicSupport.bootstrap("lum", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$lum(int ), 0, this, n);
        }

        public void randomizePalette() {
            InvokeDynamicSupport.bootstrap("randomizePalette", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$randomizePalette(), 0, this);
        }

        @Override
        public void draw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$draw(android.graphics.Canvas ), 0, this, canvas);
        }

        @Override
        public void setAlpha(int n) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setAlpha(int ), 0, this, n);
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            InvokeDynamicSupport.bootstrap("setColorFilter", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$setColorFilter(android.graphics.ColorFilter ), 0, this, colorFilter);
        }

        @Override
        public int getOpacity() {
            return (int)InvokeDynamicSupport.bootstrap("getOpacity", $$robo$$com_android_internal_app_PlatLogoActivity_PBackground$getOpacity(), 0, this);
        }

        public /* synthetic */ PBackground() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PBackground)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

