/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.VoiceInteractor;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.IconDrawableFactory;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverListController;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.widget.ResolverDrawerLayout;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected ResolveListAdapter mAdapter;
    private boolean mSafeForwardingMode;
    private AbsListView mAdapterView;
    private Button mAlwaysButton;
    private Button mOnceButton;
    private View mProfileView;
    private int mIconDpi;
    private int mLastSelected;
    private boolean mResolvingHome;
    private int mProfileSwitchMessageId;
    private int mLayoutId;
    private ArrayList<Intent> mIntents;
    private PickTargetOptionRequest mPickOptionRequest;
    private String mReferrerPackage;
    private CharSequence mTitle;
    private int mDefaultTitleResId;
    private boolean mSupportsAlwaysUseOption;
    protected ResolverDrawerLayout mResolverDrawerLayout;
    protected PackageManager mPm;
    protected int mLaunchedFromUid;
    private static String TAG = "ResolverActivity";
    private static boolean DEBUG = false;
    private Runnable mPostListReadyRunnable;
    private boolean mRegistered;
    private boolean mRetainInOnStop;
    IconDrawableFactory mIconFactory;
    private PackageMonitor mPackageMonitor;

    private void $$robo$$com_android_internal_app_ResolverActivity$__constructor__() {
        this.mLastSelected = -1;
        this.mResolvingHome = false;
        this.mProfileSwitchMessageId = -1;
        this.mIntents = new ArrayList();
        this.mPackageMonitor = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ResolverActivity this$0;

            private void $$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(ResolverActivity this$0) {
            }

            private final void $$robo$$com_android_internal_app_ResolverActivity_1$onSomePackagesChanged() {
                this.this$0.mAdapter.handlePackagesChanged();
                if (this.this$0.mProfileView != null) {
                    this.this$0.bindProfileView();
                }
            }

            private final boolean $$robo$$com_android_internal_app_ResolverActivity_1$onPackageChanged(String packageName, int uid, String[] components) {
                return true;
            }

            private void __constructor__(ResolverActivity resolverActivity) {
                this.$$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(resolverActivity);
            }
            {
                this.this$0 = resolverActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
            }

            @Override
            public void onSomePackagesChanged() {
                InvokeDynamicSupport.bootstrap("onSomePackagesChanged", $$robo$$com_android_internal_app_ResolverActivity_1$onSomePackagesChanged(), 0, this);
            }

            @Override
            public boolean onPackageChanged(String string2, int n, String[] stringArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$com_android_internal_app_ResolverActivity_1$onPackageChanged(java.lang.String int java.lang.String[] ), 0, this, string2, n, stringArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static final int $$robo$$com_android_internal_app_ResolverActivity$getLabelRes(String action) {
        return ActionTitle.forAction((String)action).labelRes;
    }

    private final Intent $$robo$$com_android_internal_app_ResolverActivity$makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(savedInstanceState, intent, null, 0, null, null, true);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.onCreate(savedInstanceState, intent, title, 0, initialIntents, rList, supportsAlwaysUseOption);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, int defaultTitleRes, Intent[] initialIntents, List<ResolveInfo> rList, boolean supportsAlwaysUseOption) {
        this.setTheme(16974790);
        super.onCreate(savedInstanceState);
        this.setProfileSwitchMessageId(intent.getContentUserHint());
        try {
            this.mLaunchedFromUid = ActivityManager.getService().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException e) {
            this.mLaunchedFromUid = -1;
        }
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        this.mPm = this.getPackageManager();
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        this.mReferrerPackage = this.getReferrerPackageName();
        this.mSupportsAlwaysUseOption = supportsAlwaysUseOption;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mIntents.add(0, new Intent(intent));
        this.mTitle = title;
        this.mDefaultTitleResId = defaultTitleRes;
        if (this.configureContentView(this.mIntents, initialIntents, rList)) {
            return;
        }
        ResolverDrawerLayout rdl = (ResolverDrawerLayout)this.findViewById(16908813);
        if (rdl != null) {
            rdl.setOnDismissedListener(new ResolverDrawerLayout.OnDismissedListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ResolverActivity this$0;

                private void $$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(ResolverActivity this$0) {
                }

                private final void $$robo$$com_android_internal_app_ResolverActivity_2$onDismissed() {
                    this.this$0.finish();
                }

                private void __constructor__(ResolverActivity resolverActivity) {
                    this.$$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(resolverActivity);
                }
                {
                    this.this$0 = resolverActivity;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
                }

                @Override
                public void onDismissed() {
                    InvokeDynamicSupport.bootstrap("onDismissed", $$robo$$com_android_internal_app_ResolverActivity_2$onDismissed(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            if (this.isVoiceInteraction()) {
                rdl.setCollapsed(false);
            }
            this.mResolverDrawerLayout = rdl;
        }
        this.mProfileView = this.findViewById(16909203);
        if (this.mProfileView != null) {
            this.mProfileView.setOnClickListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ResolverActivity this$0;

                private void $$robo$$com_android_internal_app_ResolverActivity_3$__constructor__(ResolverActivity this$0) {
                }

                private final void $$robo$$com_android_internal_app_ResolverActivity_3$onClick(View v) {
                    DisplayResolveInfo dri = this.this$0.mAdapter.getOtherProfile();
                    if (dri == null) {
                        return;
                    }
                    this.this$0.mProfileSwitchMessageId = -1;
                    this.this$0.onTargetSelected(dri, false);
                    this.this$0.finish();
                }

                private void __constructor__(ResolverActivity resolverActivity) {
                    this.$$robo$$com_android_internal_app_ResolverActivity_3$__constructor__(resolverActivity);
                }
                {
                    this.this$0 = resolverActivity;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_3$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_ResolverActivity_3$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.bindProfileView();
        }
        if (this.isVoiceInteraction()) {
            this.onSetupVoiceInteraction();
        }
        Set<String> categories = intent.getCategories();
        MetricsLogger.action((Context)this, this.mAdapter.hasFilteredItem() ? 451 : 453, intent.getAction() + ":" + intent.getType() + ":" + (categories != null ? Arrays.toString(categories.toArray()) : ""));
        this.mIconFactory = IconDrawableFactory.newInstance(this, true);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mAdapter.handlePackagesChanged();
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onSetupVoiceInteraction() {
        this.sendVoiceChoicesIfNeeded();
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$sendVoiceChoicesIfNeeded() {
        if (!this.isVoiceInteraction()) {
            return;
        }
        VoiceInteractor.PickOptionRequest.Option[] options = new VoiceInteractor.PickOptionRequest.Option[this.mAdapter.getCount()];
        int N = options.length;
        for (int i = 0; i < N; ++i) {
            options[i] = this.optionForChooserTarget((TargetInfo)this.mAdapter.getItem(i), i);
        }
        this.mPickOptionRequest = new PickTargetOptionRequest(new VoiceInteractor.Prompt(this.getTitle()), options, null);
        this.getVoiceInteractor().submitRequest(this.mPickOptionRequest);
    }

    private final VoiceInteractor.PickOptionRequest.Option $$robo$$com_android_internal_app_ResolverActivity$optionForChooserTarget(TargetInfo target, int index) {
        return new VoiceInteractor.PickOptionRequest.Option(target.getDisplayLabel(), index);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setAdditionalTargets(Intent[] intents) {
        if (intents != null) {
            for (Intent intent : intents) {
                this.mIntents.add(intent);
            }
        }
    }

    private final Intent $$robo$$com_android_internal_app_ResolverActivity$getTargetIntent() {
        return this.mIntents.isEmpty() ? null : this.mIntents.get(0);
    }

    private final String $$robo$$com_android_internal_app_ResolverActivity$getReferrerPackageName() {
        Uri referrer = this.getReferrer();
        if (referrer != null && "android-app".equals(referrer.getScheme())) {
            return referrer.getHost();
        }
        return null;
    }

    private final int $$robo$$com_android_internal_app_ResolverActivity$getLayoutResource() {
        return 17367251;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$bindProfileView() {
        DisplayResolveInfo dri = this.mAdapter.getOtherProfile();
        if (dri != null) {
            this.mProfileView.setVisibility(0);
            Object text = this.mProfileView.findViewById(16909203);
            if (!(text instanceof TextView)) {
                text = this.mProfileView.findViewById(16908308);
            }
            ((TextView)text).setText(dri.getDisplayLabel());
        } else {
            this.mProfileView.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setProfileSwitchMessageId(int contentUserHint) {
        if (contentUserHint != -2 && contentUserHint != UserHandle.myUserId()) {
            UserManager userManager = (UserManager)this.getSystemService("user");
            UserInfo originUserInfo = userManager.getUserInfo(contentUserHint);
            boolean originIsManaged = originUserInfo != null ? originUserInfo.isManagedProfile() : false;
            boolean targetIsManaged = userManager.isManagedProfile();
            if (originIsManaged && !targetIsManaged) {
                this.mProfileSwitchMessageId = 17039937;
            } else if (!originIsManaged && targetIsManaged) {
                this.mProfileSwitchMessageId = 17039938;
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setSafeForwardingMode(boolean safeForwarding) {
        this.mSafeForwardingMode = safeForwarding;
    }

    private final CharSequence $$robo$$com_android_internal_app_ResolverActivity$getTitleForAction(String action, int defaultTitleRes) {
        boolean named;
        ActionTitle title = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(action);
        boolean bl = named = this.mAdapter.getFilteredPosition() >= 0;
        if (title == ActionTitle.DEFAULT && defaultTitleRes != 0) {
            return this.getString(defaultTitleRes);
        }
        return named ? this.getString(title.namedTitleRes, this.mAdapter.getFilteredItem().getDisplayLabel()) : this.getString(title.titleRes);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    private final Drawable $$robo$$com_android_internal_app_ResolverActivity$getIcon(Resources res, int resId) {
        Drawable result;
        try {
            result = res.getDrawableForDensity(resId, this.mIconDpi);
        }
        catch (Resources.NotFoundException e) {
            result = null;
        }
        return result;
    }

    private final Drawable $$robo$$com_android_internal_app_ResolverActivity$loadIconForResolveInfo(ResolveInfo ri) {
        try {
            Drawable dr;
            if (ri.resolvePackageName != null && ri.icon != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.resolvePackageName), ri.icon)) != null) {
                return this.mIconFactory.getShadowedIcon(dr);
            }
            int iconRes = ri.getIconResource();
            if (iconRes != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.activityInfo.packageName), iconRes)) != null) {
                return this.mIconFactory.getShadowedIcon(dr);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("ResolverActivity", "Couldn't find resources for package", e);
        }
        return this.mIconFactory.getBadgedIcon(ri.activityInfo.applicationInfo);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
        if (this.mProfileView != null) {
            this.bindProfileView();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onStop() {
        Intent intent;
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if (!(((intent = this.getIntent()).getFlags() & 0x10000000) == 0 || this.isVoiceInteraction() || this.mResolvingHome || this.mRetainInOnStop || this.isChangingConfigurations())) {
            this.finish();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onDestroy() {
        super.onDestroy();
        if (!this.isChangingConfigurations() && this.mPickOptionRequest != null) {
            this.mPickOptionRequest.cancel();
        }
        if (this.mPostListReadyRunnable != null) {
            this.getMainThreadHandler().removeCallbacks(this.mPostListReadyRunnable);
            this.mPostListReadyRunnable = null;
        }
        if (this.mAdapter != null && this.mAdapter.mResolverListController != null) {
            this.mAdapter.mResolverListController.destroy();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.resetAlwaysOrOnceButtonBar();
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) {
            return false;
        }
        try {
            List<UserInfo> profiles = userManager.getProfiles(this.getUserId());
            for (UserInfo userInfo : profiles) {
                if (userInfo == null || !userInfo.isManagedProfile()) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(resolveInfo.activityInfo.packageName, 0);
            return appInfo.targetSdkVersion >= 21;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setAlwaysButtonEnabled(boolean hasValidSelection, int checkedPos, boolean filtered) {
        boolean enabled = false;
        if (hasValidSelection) {
            ResolveInfo ri = this.mAdapter.resolveInfoForPosition(checkedPos, filtered);
            if (ri == null) {
                Log.e("ResolverActivity", "Invalid position supplied to setAlwaysButtonEnabled");
                return;
            }
            if (ri.targetUserId != -2) {
                Log.e("ResolverActivity", "Attempted to set selection to resolve info for another user");
                return;
            }
            enabled = true;
        }
        this.mAlwaysButton.setEnabled(enabled);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onButtonClick(View v) {
        int id2 = v.getId();
        this.startSelected(this.mAdapter.hasFilteredItem() ? this.mAdapter.getFilteredPosition() : this.mAdapterView.getCheckedItemPosition(), id2 == 16908767, !this.mAdapter.hasFilteredItem());
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$startSelected(int which, boolean always, boolean hasIndexBeenFiltered) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which, hasIndexBeenFiltered);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(ri)) {
            Toast.makeText((Context)this, String.format(this.getResources().getString(17039440), ri.activityInfo.loadLabel(this.getPackageManager()).toString()), 1).show();
            return;
        }
        TargetInfo target = this.mAdapter.targetInfoForPosition(which, hasIndexBeenFiltered);
        if (target == null) {
            return;
        }
        if (this.onTargetSelected(target, always)) {
            if (always && this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 455);
            } else if (this.mSupportsAlwaysUseOption) {
                MetricsLogger.action(this, 456);
            } else {
                MetricsLogger.action(this, 457);
            }
            MetricsLogger.action(this, this.mAdapter.hasFilteredItem() ? 452 : 454);
            this.finish();
        }
    }

    private final Intent $$robo$$com_android_internal_app_ResolverActivity$getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        return defIntent;
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$onTargetSelected(TargetInfo target, boolean alwaysCheck) {
        Intent intent;
        ResolveInfo ri = target.getResolveInfo();
        Intent intent2 = intent = target != null ? target.getResolvedIntent() : null;
        if (intent != null && (this.mSupportsAlwaysUseOption || this.mAdapter.hasFilteredItem()) && this.mAdapter.mUnfilteredResolveList != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            Intent filterIntent = intent.getSelector() != null ? intent.getSelector() : intent;
            String action = filterIntent.getAction();
            if (action != null) {
                filter.addAction(action);
            }
            if ((categories = filterIntent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = filterIntent.getData();
            if (cat == 0x600000 && (mimeType = filterIntent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w("ResolverActivity", e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mUnfilteredResolveList.size();
                boolean needToAddBackProfileForwardingComponent = this.mAdapter.mOtherProfile != null;
                ComponentName[] set = !needToAddBackProfileForwardingComponent ? new ComponentName[N] : new ComponentName[N + 1];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mAdapter.mUnfilteredResolveList.get(i).getResolveInfoAt(0);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (needToAddBackProfileForwardingComponent) {
                    set[N] = this.mAdapter.mOtherProfile.getResolvedComponentName();
                    int otherProfileMatch = ((ResolveListAdapter)this.mAdapter).mOtherProfile.getResolveInfo().match;
                    if (otherProfileMatch > bestMatch) {
                        bestMatch = otherProfileMatch;
                    }
                }
                if (alwaysCheck) {
                    int userId = this.getUserId();
                    PackageManager pm = this.getPackageManager();
                    pm.addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                    if (ri.handleAllWebDataURI) {
                        String packageName = pm.getDefaultBrowserPackageNameAsUser(userId);
                        if (TextUtils.isEmpty(packageName)) {
                            pm.setDefaultBrowserPackageNameAsUser(ri.activityInfo.packageName, userId);
                        }
                    } else {
                        boolean hasCategoryBrowsable;
                        ComponentName cn = intent.getComponent();
                        String packageName = cn.getPackageName();
                        String dataScheme = data != null ? data.getScheme() : null;
                        boolean isHttpOrHttps = dataScheme != null && (dataScheme.equals("http") || dataScheme.equals("https"));
                        boolean isViewAction = action != null && action.equals("android.intent.action.VIEW");
                        boolean bl = hasCategoryBrowsable = categories != null && categories.contains("android.intent.category.BROWSABLE");
                        if (isHttpOrHttps && isViewAction && hasCategoryBrowsable) {
                            pm.updateIntentVerificationStatusAsUser(packageName, 2, userId);
                        }
                    }
                } else {
                    try {
                        this.mAdapter.mResolverListController.setLastChosen(intent, filter, bestMatch);
                    }
                    catch (RemoteException re) {
                        Log.d("ResolverActivity", "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (target != null) {
            this.safelyStartActivity(target);
        }
        return true;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivity(TargetInfo cti) {
        StrictMode.disableDeathOnFileUriExposure();
        try {
            this.safelyStartActivityInternal(cti);
        }
        finally {
            StrictMode.enableDeathOnFileUriExposure();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivityInternal(TargetInfo cti) {
        if (this.mProfileSwitchMessageId != -1) {
            Toast.makeText((Context)this, this.getString(this.mProfileSwitchMessageId), 1).show();
        }
        if (!this.mSafeForwardingMode) {
            if (cti.start(this, null)) {
                this.onActivityStarted(cti);
            }
            return;
        }
        try {
            if (cti.startAsCaller(this, null, -10000)) {
                this.onActivityStarted(cti);
            }
        }
        catch (RuntimeException e) {
            String launchedFromPackage;
            try {
                launchedFromPackage = ActivityManager.getService().getLaunchedFromPackage(this.getActivityToken());
            }
            catch (RemoteException e2) {
                launchedFromPackage = "??";
            }
            Slog.wtf("ResolverActivity", "Unable to launch as uid " + this.mLaunchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onActivityStarted(TargetInfo cti) {
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$shouldGetActivityMetadata() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$shouldAutoLaunchSingleChoice(TargetInfo target) {
        return true;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$showTargetDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    private final ResolveListAdapter $$robo$$com_android_internal_app_ResolverActivity$createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        return new ResolveListAdapter(this, context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed, this.createListController());
    }

    @VisibleForTesting
    private final ResolverListController $$robo$$com_android_internal_app_ResolverActivity$createListController() {
        return new ResolverListController(this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid);
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$configureContentView(List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList) {
        TargetInfo target;
        this.mAdapter = this.createAdapter(this, payloadIntents, initialIntents, rList, this.mLaunchedFromUid, this.mSupportsAlwaysUseOption && !this.isVoiceInteraction());
        boolean rebuildCompleted = this.mAdapter.rebuildList();
        this.mLayoutId = this.useLayoutWithDefault() ? 17367252 : this.getLayoutResource();
        this.setContentView(this.mLayoutId);
        int count = this.mAdapter.getUnfilteredCount();
        if (rebuildCompleted && count == 1 && this.mAdapter.getOtherProfile() == null && this.shouldAutoLaunchSingleChoice(target = this.mAdapter.targetInfoForPosition(0, false))) {
            this.safelyStartActivity(target);
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
            this.finish();
            return true;
        }
        this.mAdapterView = (AbsListView)this.findViewById(16909230);
        if (count == 0 && this.mAdapter.mPlaceholderCount == 0) {
            TextView emptyView = (TextView)this.findViewById(16908292);
            emptyView.setVisibility(0);
            this.mAdapterView.setVisibility(8);
        } else {
            this.mAdapterView.setVisibility(0);
            this.onPrepareAdapterView(this.mAdapterView, this.mAdapter);
        }
        return false;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onPrepareAdapterView(AbsListView adapterView, ResolveListAdapter adapter) {
        boolean useHeader = adapter.hasFilteredItem();
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        adapterView.setAdapter(this.mAdapter);
        ItemClickListener listener = new ItemClickListener(this);
        adapterView.setOnItemClickListener(listener);
        adapterView.setOnItemLongClickListener(listener);
        if (this.mSupportsAlwaysUseOption) {
            listView.setChoiceMode(1);
        }
        if (useHeader && listView != null && listView.getHeaderViewsCount() == 0) {
            listView.addHeaderView(LayoutInflater.from(this).inflate(17367250, (ViewGroup)listView, false));
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setTitleAndIcon() {
        CharSequence title;
        TextView titleView;
        if (this.mAdapter.getCount() == 0 && this.mAdapter.mPlaceholderCount == 0 && (titleView = (TextView)this.findViewById(16908310)) != null) {
            titleView.setVisibility(8);
        }
        CharSequence charSequence = title = this.mTitle != null ? this.mTitle : this.getTitleForAction(this.getTargetIntent().getAction(), this.mDefaultTitleResId);
        if (!TextUtils.isEmpty(title)) {
            TextView titleView2 = (TextView)this.findViewById(16908310);
            if (titleView2 != null) {
                titleView2.setText(title);
            }
            this.setTitle(title);
            ImageView titleIcon = (ImageView)this.findViewById(16909416);
            if (titleIcon != null) {
                ApplicationInfo ai = null;
                try {
                    if (!TextUtils.isEmpty(this.mReferrerPackage)) {
                        ai = this.mPm.getApplicationInfo(this.mReferrerPackage, 0);
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e("ResolverActivity", "Could not find referrer package " + this.mReferrerPackage);
                }
                if (ai != null) {
                    titleIcon.setImageDrawable(ai.loadIcon(this.mPm));
                }
            }
        }
        ImageView iconView = (ImageView)this.findViewById(16908294);
        DisplayResolveInfo iconInfo = this.mAdapter.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new LoadIconIntoViewTask(this, iconInfo, iconView).execute(new Void[0]);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$resetAlwaysOrOnceButtonBar() {
        if (this.mSupportsAlwaysUseOption) {
            ViewGroup buttonLayout = (ViewGroup)this.findViewById(16908768);
            if (buttonLayout != null) {
                buttonLayout.setVisibility(0);
                this.mAlwaysButton = (Button)buttonLayout.findViewById(16908767);
                this.mOnceButton = (Button)buttonLayout.findViewById(16908769);
            } else {
                Log.e("ResolverActivity", "Layout unexpectedly does not have a button bar");
            }
        }
        if (this.useLayoutWithDefault() && this.mAdapter.getFilteredPosition() != -1) {
            this.setAlwaysButtonEnabled(true, this.mAdapter.getFilteredPosition(), false);
            this.mOnceButton.setEnabled(true);
            return;
        }
        if (this.mAdapterView != null && this.mAdapterView.getCheckedItemPosition() != -1) {
            this.setAlwaysButtonEnabled(true, this.mAdapterView.getCheckedItemPosition(), true);
            this.mOnceButton.setEnabled(true);
        }
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$useLayoutWithDefault() {
        return this.mSupportsAlwaysUseOption && this.mAdapter.hasFilteredItem();
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setRetainInOnStop(boolean retainInOnStop) {
        this.mRetainInOnStop = retainInOnStop;
    }

    private static final boolean $$robo$$com_android_internal_app_ResolverActivity$resolveInfoMatch(ResolveInfo lhs, ResolveInfo rhs) {
        return lhs == null ? rhs == null : (lhs.activityInfo == null ? rhs.activityInfo == null : Objects.equals(lhs.activityInfo.name, rhs.activityInfo.name) && Objects.equals(lhs.activityInfo.packageName, rhs.activityInfo.packageName));
    }

    private static final boolean $$robo$$com_android_internal_app_ResolverActivity$isSpecificUriMatch(int match) {
        return (match &= 0xFFF0000) >= 0x300000 && match <= 0x500000;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_ResolverActivity$__constructor__();
    }

    public ResolverActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity$__constructor__(), 0, this);
    }

    public static int getLabelRes(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLabelRes", $$robo$$com_android_internal_app_ResolverActivity$getLabelRes(java.lang.String ), 0, (String)string2);
    }

    private Intent makeMyIntent() {
        return InvokeDynamicSupport.bootstrap("makeMyIntent", $$robo$$com_android_internal_app_ResolverActivity$makeMyIntent(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle android.content.Intent java.lang.CharSequence android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> boolean ), 0, this, bundle, intent, charSequence, intentArray, list, bl);
    }

    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, int n, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle android.content.Intent java.lang.CharSequence int android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> boolean ), 0, this, bundle, intent, charSequence, n, intentArray, list, bl);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_app_ResolverActivity$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    public void onSetupVoiceInteraction() {
        InvokeDynamicSupport.bootstrap("onSetupVoiceInteraction", $$robo$$com_android_internal_app_ResolverActivity$onSetupVoiceInteraction(), 0, this);
    }

    public void sendVoiceChoicesIfNeeded() {
        InvokeDynamicSupport.bootstrap("sendVoiceChoicesIfNeeded", $$robo$$com_android_internal_app_ResolverActivity$sendVoiceChoicesIfNeeded(), 0, this);
    }

    VoiceInteractor.PickOptionRequest.Option optionForChooserTarget(TargetInfo targetInfo, int n) {
        return InvokeDynamicSupport.bootstrap("optionForChooserTarget", $$robo$$com_android_internal_app_ResolverActivity$optionForChooserTarget(com.android.internal.app.ResolverActivity$TargetInfo int ), 0, this, targetInfo, n);
    }

    protected void setAdditionalTargets(Intent[] intentArray) {
        InvokeDynamicSupport.bootstrap("setAdditionalTargets", $$robo$$com_android_internal_app_ResolverActivity$setAdditionalTargets(android.content.Intent[] ), 0, this, intentArray);
    }

    public Intent getTargetIntent() {
        return InvokeDynamicSupport.bootstrap("getTargetIntent", $$robo$$com_android_internal_app_ResolverActivity$getTargetIntent(), 0, this);
    }

    protected String getReferrerPackageName() {
        return InvokeDynamicSupport.bootstrap("getReferrerPackageName", $$robo$$com_android_internal_app_ResolverActivity$getReferrerPackageName(), 0, this);
    }

    public int getLayoutResource() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutResource", $$robo$$com_android_internal_app_ResolverActivity$getLayoutResource(), 0, this);
    }

    void bindProfileView() {
        InvokeDynamicSupport.bootstrap("bindProfileView", $$robo$$com_android_internal_app_ResolverActivity$bindProfileView(), 0, this);
    }

    private void setProfileSwitchMessageId(int n) {
        InvokeDynamicSupport.bootstrap("setProfileSwitchMessageId", $$robo$$com_android_internal_app_ResolverActivity$setProfileSwitchMessageId(int ), 0, this, n);
    }

    public void setSafeForwardingMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSafeForwardingMode", $$robo$$com_android_internal_app_ResolverActivity$setSafeForwardingMode(boolean ), 0, this, bl);
    }

    protected CharSequence getTitleForAction(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getTitleForAction", $$robo$$com_android_internal_app_ResolverActivity$getTitleForAction(java.lang.String int ), 0, this, string2, n);
    }

    void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_app_ResolverActivity$dismiss(), 0, this);
    }

    Drawable getIcon(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$com_android_internal_app_ResolverActivity$getIcon(android.content.res.Resources int ), 0, this, resources, n);
    }

    Drawable loadIconForResolveInfo(ResolveInfo resolveInfo) {
        return InvokeDynamicSupport.bootstrap("loadIconForResolveInfo", $$robo$$com_android_internal_app_ResolverActivity$loadIconForResolveInfo(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    @Override
    protected void onRestart() {
        InvokeDynamicSupport.bootstrap("onRestart", $$robo$$com_android_internal_app_ResolverActivity$onRestart(), 0, this);
    }

    @Override
    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$com_android_internal_app_ResolverActivity$onStop(), 0, this);
    }

    @Override
    protected void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$com_android_internal_app_ResolverActivity$onDestroy(), 0, this);
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_app_ResolverActivity$onRestoreInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    private boolean hasManagedProfile() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasManagedProfile", $$robo$$com_android_internal_app_ResolverActivity$hasManagedProfile(), 0, this);
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsManagedProfiles", $$robo$$com_android_internal_app_ResolverActivity$supportsManagedProfiles(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    private void setAlwaysButtonEnabled(boolean bl, int n, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setAlwaysButtonEnabled", $$robo$$com_android_internal_app_ResolverActivity$setAlwaysButtonEnabled(boolean int boolean ), 0, this, bl, n, bl2);
    }

    public void onButtonClick(View view) {
        InvokeDynamicSupport.bootstrap("onButtonClick", $$robo$$com_android_internal_app_ResolverActivity$onButtonClick(android.view.View ), 0, this, view);
    }

    public void startSelected(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("startSelected", $$robo$$com_android_internal_app_ResolverActivity$startSelected(int boolean boolean ), 0, this, n, bl, bl2);
    }

    public Intent getReplacementIntent(ActivityInfo activityInfo, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getReplacementIntent", $$robo$$com_android_internal_app_ResolverActivity$getReplacementIntent(android.content.pm.ActivityInfo android.content.Intent ), 0, this, activityInfo, intent);
    }

    protected boolean onTargetSelected(TargetInfo targetInfo, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTargetSelected", $$robo$$com_android_internal_app_ResolverActivity$onTargetSelected(com.android.internal.app.ResolverActivity$TargetInfo boolean ), 0, this, targetInfo, bl);
    }

    public void safelyStartActivity(TargetInfo targetInfo) {
        InvokeDynamicSupport.bootstrap("safelyStartActivity", $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivity(com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, targetInfo);
    }

    private void safelyStartActivityInternal(TargetInfo targetInfo) {
        InvokeDynamicSupport.bootstrap("safelyStartActivityInternal", $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivityInternal(com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, targetInfo);
    }

    public void onActivityStarted(TargetInfo targetInfo) {
        InvokeDynamicSupport.bootstrap("onActivityStarted", $$robo$$com_android_internal_app_ResolverActivity$onActivityStarted(com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, targetInfo);
    }

    public boolean shouldGetActivityMetadata() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldGetActivityMetadata", $$robo$$com_android_internal_app_ResolverActivity$shouldGetActivityMetadata(), 0, this);
    }

    public boolean shouldAutoLaunchSingleChoice(TargetInfo targetInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAutoLaunchSingleChoice", $$robo$$com_android_internal_app_ResolverActivity$shouldAutoLaunchSingleChoice(com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, targetInfo);
    }

    public void showTargetDetails(ResolveInfo resolveInfo) {
        InvokeDynamicSupport.bootstrap("showTargetDetails", $$robo$$com_android_internal_app_ResolverActivity$showTargetDetails(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    public ResolveListAdapter createAdapter(Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createAdapter", $$robo$$com_android_internal_app_ResolverActivity$createAdapter(android.content.Context java.util.List<android.content.Intent> android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> int boolean ), 0, this, context, list, intentArray, list2, n, bl);
    }

    protected ResolverListController createListController() {
        return InvokeDynamicSupport.bootstrap("createListController", $$robo$$com_android_internal_app_ResolverActivity$createListController(), 0, this);
    }

    public boolean configureContentView(List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2) {
        return (boolean)InvokeDynamicSupport.bootstrap("configureContentView", $$robo$$com_android_internal_app_ResolverActivity$configureContentView(java.util.List<android.content.Intent> android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> ), 0, this, list, intentArray, list2);
    }

    public void onPrepareAdapterView(AbsListView absListView, ResolveListAdapter resolveListAdapter) {
        InvokeDynamicSupport.bootstrap("onPrepareAdapterView", $$robo$$com_android_internal_app_ResolverActivity$onPrepareAdapterView(android.widget.AbsListView com.android.internal.app.ResolverActivity$ResolveListAdapter ), 0, this, absListView, resolveListAdapter);
    }

    public void setTitleAndIcon() {
        InvokeDynamicSupport.bootstrap("setTitleAndIcon", $$robo$$com_android_internal_app_ResolverActivity$setTitleAndIcon(), 0, this);
    }

    public void resetAlwaysOrOnceButtonBar() {
        InvokeDynamicSupport.bootstrap("resetAlwaysOrOnceButtonBar", $$robo$$com_android_internal_app_ResolverActivity$resetAlwaysOrOnceButtonBar(), 0, this);
    }

    private boolean useLayoutWithDefault() {
        return (boolean)InvokeDynamicSupport.bootstrap("useLayoutWithDefault", $$robo$$com_android_internal_app_ResolverActivity$useLayoutWithDefault(), 0, this);
    }

    protected void setRetainInOnStop(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRetainInOnStop", $$robo$$com_android_internal_app_ResolverActivity$setRetainInOnStop(boolean ), 0, this, bl);
    }

    static boolean resolveInfoMatch(ResolveInfo resolveInfo, ResolveInfo resolveInfo2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resolveInfoMatch", $$robo$$com_android_internal_app_ResolverActivity$resolveInfoMatch(android.content.pm.ResolveInfo android.content.pm.ResolveInfo ), 0, (ResolveInfo)resolveInfo, (ResolveInfo)resolveInfo2);
    }

    static boolean isSpecificUriMatch(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSpecificUriMatch", $$robo$$com_android_internal_app_ResolverActivity$isSpecificUriMatch(int ), 0, (int)n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PickTargetOptionRequest
    extends VoiceInteractor.PickOptionRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$__constructor__(VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] options, Bundle extras) {
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$onCancel() {
            super.onCancel();
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$onPickOptionResult(boolean finished, VoiceInteractor.PickOptionRequest.Option[] selections, Bundle result) {
            Object ti;
            super.onPickOptionResult(finished, selections, result);
            if (selections.length != 1) {
                return;
            }
            ResolverActivity ra = (ResolverActivity)this.getActivity();
            if (ra != null && ra.onTargetSelected((TargetInfo)(ti = ra.mAdapter.getItem(selections[0].getIndex())), false)) {
                ra.mPickOptionRequest = null;
                ra.finish();
            }
        }

        private void __constructor__(VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] optionArray, Bundle bundle) {
            this.$$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$__constructor__(prompt, optionArray, bundle);
        }

        public PickTargetOptionRequest(VoiceInteractor.Prompt prompt, VoiceInteractor.PickOptionRequest.Option[] optionArray, Bundle bundle) {
            super(prompt, optionArray, bundle);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$__constructor__(android.app.VoiceInteractor$Prompt android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), 0, this, prompt, optionArray, bundle);
        }

        @Override
        public void onCancel() {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$onCancel(), 0, this);
        }

        @Override
        public void onPickOptionResult(boolean bl, VoiceInteractor.PickOptionRequest.Option[] optionArray, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onPickOptionResult", $$robo$$com_android_internal_app_ResolverActivity_PickTargetOptionRequest$onPickOptionResult(boolean android.app.VoiceInteractor$PickOptionRequest$Option[] android.os.Bundle ), 0, this, bl, optionArray, bundle);
        }

        public /* synthetic */ PickTargetOptionRequest() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PickTargetOptionRequest)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LoadIconIntoViewTask
    extends LoadIconTask
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ImageView mTargetView;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(ResolverActivity this$0, DisplayResolveInfo dri, ImageView target) {
            this.mTargetView = target;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$onPostExecute(Drawable d) {
            super.onPostExecute(d);
            this.mTargetView.setImageDrawable(d);
        }

        private void __constructor__(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo, ImageView imageView) {
            this.$$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(resolverActivity, displayResolveInfo, imageView);
        }

        public LoadIconIntoViewTask(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo, ImageView imageView) {
            this.this$0 = resolverActivity;
            super(resolverActivity, displayResolveInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(com.android.internal.app.ResolverActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo android.widget.ImageView ), 0, this, resolverActivity, displayResolveInfo, imageView);
        }

        @Override
        protected void onPostExecute(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$onPostExecute(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        public /* synthetic */ LoadIconIntoViewTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadIconIntoViewTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LoadAdapterIconTask
    extends LoadIconTask
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_LoadAdapterIconTask$__constructor__(ResolverActivity this$0, DisplayResolveInfo dri) {
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_LoadAdapterIconTask$onPostExecute(Drawable d) {
            super.onPostExecute(d);
            if (this.this$0.mProfileView != null && this.this$0.mAdapter.getOtherProfile() == this.mDisplayResolveInfo) {
                this.this$0.bindProfileView();
            }
            this.this$0.mAdapter.notifyDataSetChanged();
        }

        private void __constructor__(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo) {
            this.$$robo$$com_android_internal_app_ResolverActivity_LoadAdapterIconTask$__constructor__(resolverActivity, displayResolveInfo);
        }

        public LoadAdapterIconTask(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo) {
            this.this$0 = resolverActivity;
            super(resolverActivity, displayResolveInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_LoadAdapterIconTask$__constructor__(com.android.internal.app.ResolverActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, resolverActivity, displayResolveInfo);
        }

        @Override
        protected void onPostExecute(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_LoadAdapterIconTask$onPostExecute(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        public /* synthetic */ LoadAdapterIconTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadAdapterIconTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public abstract class LoadIconTask
    extends AsyncTask<Void, Void, Drawable> {
        public transient /* synthetic */ Object __robo_data__;
        protected DisplayResolveInfo mDisplayResolveInfo;
        private ResolveInfo mResolveInfo;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(ResolverActivity this$0, DisplayResolveInfo dri) {
            this.mDisplayResolveInfo = dri;
            this.mResolveInfo = dri.getResolveInfo();
        }

        private final Drawable $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$doInBackground(Void ... params) {
            return this.this$0.loadIconForResolveInfo(this.mResolveInfo);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$onPostExecute(Drawable d) {
            this.mDisplayResolveInfo.setDisplayIcon(d);
        }

        private void __constructor__(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo) {
            this.$$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(resolverActivity, displayResolveInfo);
        }

        public LoadIconTask(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(com.android.internal.app.ResolverActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, resolverActivity, displayResolveInfo);
        }

        protected Drawable doInBackground(Void ... voidArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$doInBackground(java.lang.Void[] ), 0, this, voidArray);
        }

        @Override
        protected void onPostExecute(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$onPostExecute(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        public /* synthetic */ LoadIconTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadIconTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ItemClickListener
    implements AdapterView.OnItemClickListener,
    AdapterView.OnItemLongClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$__constructor__(ResolverActivity this$0) {
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            boolean hasValidSelection;
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return;
            }
            if (this.this$0.mAdapter.resolveInfoForPosition(position, true) == null) {
                return;
            }
            int checkedPos = this.this$0.mAdapterView.getCheckedItemPosition();
            boolean bl = hasValidSelection = checkedPos != -1;
            if (!(this.this$0.useLayoutWithDefault() || hasValidSelection && this.this$0.mLastSelected == checkedPos || this.this$0.mAlwaysButton == null)) {
                this.this$0.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
                this.this$0.mOnceButton.setEnabled(hasValidSelection);
                if (hasValidSelection) {
                    this.this$0.mAdapterView.smoothScrollToPosition(checkedPos);
                }
                this.this$0.mLastSelected = checkedPos;
            } else {
                this.this$0.startSelected(position, false, true);
            }
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            ListView listView;
            ListView listView2 = listView = parent instanceof ListView ? (ListView)parent : null;
            if (listView != null) {
                position -= listView.getHeaderViewsCount();
            }
            if (position < 0) {
                return false;
            }
            ResolveInfo ri = this.this$0.mAdapter.resolveInfoForPosition(position, true);
            this.this$0.showTargetDetails(ri);
            return true;
        }

        private void __constructor__(ResolverActivity resolverActivity) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$__constructor__(resolverActivity);
        }

        ItemClickListener(ResolverActivity resolverActivity) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
        }

        @Override
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("onItemLongClick", $$robo$$com_android_internal_app_ResolverActivity_ItemClickListener$onItemLongClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        public /* synthetic */ ItemClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ViewHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public TextView text;
        public TextView text2;
        public ImageView icon;
        public ImageView badge;

        private void $$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(View view) {
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
            this.badge = (ImageView)view.findViewById(16909373);
        }

        private void __constructor__(View view) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(view);
        }

        public ViewHolder(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(android.view.View ), 0, this, view);
        }

        public /* synthetic */ ViewHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    @VisibleForTesting
    public static final class ResolvedComponentInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ComponentName name;
        private boolean mPinned;
        private List<Intent> mIntents;
        private List<ResolveInfo> mResolveInfos;

        private void $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$__constructor__(ComponentName name, Intent intent, ResolveInfo info) {
            this.mIntents = new ArrayList<Intent>();
            this.mResolveInfos = new ArrayList<ResolveInfo>();
            this.name = name;
            this.add(intent, info);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$add(Intent intent, ResolveInfo info) {
            this.mIntents.add(intent);
            this.mResolveInfos.add(info);
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getCount() {
            return this.mIntents.size();
        }

        private final Intent $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getIntentAt(int index) {
            return index >= 0 ? this.mIntents.get(index) : null;
        }

        private final ResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getResolveInfoAt(int index) {
            return index >= 0 ? this.mResolveInfos.get(index) : null;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$findIntent(Intent intent) {
            int N = this.mIntents.size();
            for (int i = 0; i < N; ++i) {
                if (!intent.equals(this.mIntents.get(i))) continue;
                return i;
            }
            return -1;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$findResolveInfo(ResolveInfo info) {
            int N = this.mResolveInfos.size();
            for (int i = 0; i < N; ++i) {
                if (!info.equals(this.mResolveInfos.get(i))) continue;
                return i;
            }
            return -1;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$isPinned() {
            return this.mPinned;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$setPinned(boolean pinned) {
            this.mPinned = pinned;
        }

        private void __constructor__(ComponentName componentName, Intent intent, ResolveInfo resolveInfo) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$__constructor__(componentName, intent, resolveInfo);
        }

        public ResolvedComponentInfo(ComponentName componentName, Intent intent, ResolveInfo resolveInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$__constructor__(android.content.ComponentName android.content.Intent android.content.pm.ResolveInfo ), 0, this, componentName, intent, resolveInfo);
        }

        public void add(Intent intent, ResolveInfo resolveInfo) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$add(android.content.Intent android.content.pm.ResolveInfo ), 0, this, intent, resolveInfo);
        }

        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getCount(), 0, this);
        }

        public Intent getIntentAt(int n) {
            return InvokeDynamicSupport.bootstrap("getIntentAt", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getIntentAt(int ), 0, this, n);
        }

        public ResolveInfo getResolveInfoAt(int n) {
            return InvokeDynamicSupport.bootstrap("getResolveInfoAt", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$getResolveInfoAt(int ), 0, this, n);
        }

        public int findIntent(Intent intent) {
            return (int)InvokeDynamicSupport.bootstrap("findIntent", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$findIntent(android.content.Intent ), 0, this, intent);
        }

        public int findResolveInfo(ResolveInfo resolveInfo) {
            return (int)InvokeDynamicSupport.bootstrap("findResolveInfo", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$findResolveInfo(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
        }

        public boolean isPinned() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPinned", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$isPinned(), 0, this);
        }

        public void setPinned(boolean bl) {
            InvokeDynamicSupport.bootstrap("setPinned", $$robo$$com_android_internal_app_ResolverActivity_ResolvedComponentInfo$setPinned(boolean ), 0, this, bl);
        }

        public /* synthetic */ ResolvedComponentInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolvedComponentInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ResolveListAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<Intent> mIntents;
        private Intent[] mInitialIntents;
        private List<ResolveInfo> mBaseResolveList;
        protected ResolveInfo mLastChosen;
        private DisplayResolveInfo mOtherProfile;
        private boolean mHasExtendedInfo;
        private ResolverListController mResolverListController;
        private int mPlaceholderCount;
        protected LayoutInflater mInflater;
        List<DisplayResolveInfo> mDisplayList;
        List<ResolvedComponentInfo> mUnfilteredResolveList;
        private int mLastChosenPosition;
        private boolean mFilterLastUsed;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(ResolverActivity this$0, Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed, ResolverListController resolverListController) {
            this.mLastChosenPosition = -1;
            this.mIntents = payloadIntents;
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            this$0.mLaunchedFromUid = launchedFromUid;
            this.mInflater = LayoutInflater.from(context);
            this.mDisplayList = new ArrayList<DisplayResolveInfo>();
            this.mFilterLastUsed = filterLastUsed;
            this.mResolverListController = resolverListController;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$handlePackagesChanged() {
            this.rebuildList();
            if (this.getCount() == 0) {
                this.this$0.finish();
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$setPlaceholderCount(int count) {
            this.mPlaceholderCount = count;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getPlaceholderCount() {
            return this.mPlaceholderCount;
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredItem() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mDisplayList.get(this.mLastChosenPosition);
            }
            return null;
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getOtherProfile() {
            return this.mOtherProfile;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredPosition() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mLastChosenPosition;
            }
            return -1;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasFilteredItem() {
            return this.mFilterLastUsed && this.mLastChosen != null;
        }

        private final float $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getScore(DisplayResolveInfo target) {
            return this.mResolverListController.getScore(target);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateModel(ComponentName componentName) {
            this.mResolverListController.updateModel(componentName);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateChooserCounts(String packageName, int userId, String action) {
            this.mResolverListController.updateChooserCounts(packageName, userId, action);
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$rebuildList() {
            int N;
            List<ResolvedComponentInfo> currentResolveList = null;
            this.mOtherProfile = null;
            this.mLastChosen = null;
            this.mLastChosenPosition = -1;
            this.mDisplayList.clear();
            if (this.mBaseResolveList != null) {
                this.mUnfilteredResolveList = new ArrayList<ResolvedComponentInfo>();
                currentResolveList = this.mUnfilteredResolveList;
                this.mResolverListController.addResolveListDedupe(currentResolveList, this.this$0.getTargetIntent(), this.mBaseResolveList);
            } else {
                this.mUnfilteredResolveList = this.mResolverListController.getResolversForIntent(this.shouldGetResolvedFilter(), this.this$0.shouldGetActivityMetadata(), this.mIntents);
                currentResolveList = this.mUnfilteredResolveList;
                if (currentResolveList == null) {
                    this.processSortedList(currentResolveList);
                    return true;
                }
                ArrayList<ResolvedComponentInfo> originalList = this.mResolverListController.filterIneligibleActivities(currentResolveList, true);
                if (originalList != null) {
                    this.mUnfilteredResolveList = originalList;
                }
            }
            for (ResolvedComponentInfo info : currentResolveList) {
                if (info.getResolveInfoAt((int)0).targetUserId == -2) continue;
                this.mOtherProfile = new DisplayResolveInfo(this.this$0, info.getIntentAt(0), info.getResolveInfoAt(0), info.getResolveInfoAt(0).loadLabel(this.this$0.mPm), info.getResolveInfoAt(0).loadLabel(this.this$0.mPm), this.this$0.getReplacementIntent(info.getResolveInfoAt((int)0).activityInfo, info.getIntentAt(0)));
                currentResolveList.remove(info);
                break;
            }
            if (this.mOtherProfile == null) {
                try {
                    this.mLastChosen = this.mResolverListController.getLastChosen();
                }
                catch (RemoteException re) {
                    Log.d("ResolverActivity", "Error calling getLastChosenActivity\n" + re);
                }
            }
            if (currentResolveList != null && (N = currentResolveList.size()) > 0) {
                ArrayList<ResolvedComponentInfo> originalList = this.mResolverListController.filterLowPriority(currentResolveList, this.mUnfilteredResolveList == currentResolveList);
                if (originalList != null) {
                    this.mUnfilteredResolveList = originalList;
                }
                if (currentResolveList.size() > 1) {
                    int placeholderCount = currentResolveList.size();
                    if (this.this$0.useLayoutWithDefault()) {
                        --placeholderCount;
                    }
                    this.setPlaceholderCount(placeholderCount);
                    AsyncTask<List<ResolvedComponentInfo>, Void, List<ResolvedComponentInfo>> sortingTask = new AsyncTask<List<ResolvedComponentInfo>, Void, List<ResolvedComponentInfo>>(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ ResolveListAdapter this$1;

                        private void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$__constructor__(ResolveListAdapter this$1) {
                        }

                        private final List<ResolvedComponentInfo> $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$doInBackground(List<ResolvedComponentInfo> ... params) {
                            this.this$1.mResolverListController.sort(params[0]);
                            return params[0];
                        }

                        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$onPostExecute(List<ResolvedComponentInfo> sortedComponents) {
                            this.this$1.processSortedList(sortedComponents);
                            if (this.this$1.this$0.mProfileView != null) {
                                this.this$1.this$0.bindProfileView();
                            }
                            this.this$1.notifyDataSetChanged();
                        }

                        private void __constructor__(ResolveListAdapter resolveListAdapter) {
                            this.$$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$__constructor__(resolveListAdapter);
                        }
                        {
                            this.this$1 = resolveListAdapter;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$__constructor__(com.android.internal.app.ResolverActivity$ResolveListAdapter ), 0, this, resolveListAdapter);
                        }

                        protected List<ResolvedComponentInfo> doInBackground(List<ResolvedComponentInfo> ... listArray) {
                            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$doInBackground(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo>[] ), 0, this, listArray);
                        }

                        @Override
                        protected void onPostExecute(List<ResolvedComponentInfo> list) {
                            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_1$onPostExecute(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> ), 0, this, list);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    sortingTask.execute(currentResolveList);
                    this.postListReadyRunnable();
                    return false;
                }
                this.processSortedList(currentResolveList);
                return true;
            }
            this.processSortedList(currentResolveList);
            return true;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processSortedList(List<ResolvedComponentInfo> sortedComponents) {
            int N;
            if (sortedComponents != null && (N = sortedComponents.size()) != 0) {
                if (this.mInitialIntents != null) {
                    for (int i = 0; i < this.mInitialIntents.length; ++i) {
                        Intent ii = this.mInitialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(this.this$0.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w("ResolverActivity", "No activity found for " + ii);
                            continue;
                        }
                        ResolveInfo ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        UserManager userManager = (UserManager)this.this$0.getSystemService("user");
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.iconResourceId = ri.icon = li.getIconResource();
                        }
                        if (userManager.isManagedProfile()) {
                            ri.noResourceId = true;
                            ri.icon = 0;
                        }
                        this.addResolveInfo(new DisplayResolveInfo(this.this$0, ii, ri, ri.loadLabel(this.this$0.getPackageManager()), null, ii));
                    }
                }
                ResolvedComponentInfo rci0 = sortedComponents.get(0);
                ResolveInfo r0 = rci0.getResolveInfoAt(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(this.this$0.mPm);
                this.mHasExtendedInfo = false;
                for (int i = 1; i < N; ++i) {
                    ResolvedComponentInfo rci;
                    ResolveInfo ri;
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = (rci = sortedComponents.get(i)).getResolveInfoAt(0)).loadLabel(this.this$0.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(sortedComponents, start, i - 1, rci0, r0Label);
                    rci0 = rci;
                    r0 = ri;
                    r0Label = riLabel;
                    start = i;
                }
                this.processGroup(sortedComponents, start, N - 1, rci0, r0Label);
            }
            this.postListReadyRunnable();
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$postListReadyRunnable() {
            if (this.this$0.mPostListReadyRunnable == null) {
                this.this$0.mPostListReadyRunnable = new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ResolveListAdapter this$1;

                    private void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_2$__constructor__(ResolveListAdapter this$1) {
                    }

                    private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_2$run() {
                        this.this$1.this$0.setTitleAndIcon();
                        this.this$1.this$0.resetAlwaysOrOnceButtonBar();
                        this.this$1.onListRebuilt();
                        this.this$1.this$0.mPostListReadyRunnable = null;
                    }

                    private void __constructor__(ResolveListAdapter resolveListAdapter) {
                        this.$$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_2$__constructor__(resolveListAdapter);
                    }
                    {
                        this.this$1 = resolveListAdapter;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_2$__constructor__(com.android.internal.app.ResolverActivity$ResolveListAdapter ), 0, this, resolveListAdapter);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                this.this$0.getMainThreadHandler().post(this.this$0.mPostListReadyRunnable);
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onListRebuilt() {
            TargetInfo target;
            int count = this.getUnfilteredCount();
            if (count == 1 && this.getOtherProfile() == null && this.this$0.shouldAutoLaunchSingleChoice(target = this.targetInfoForPosition(0, false))) {
                this.this$0.safelyStartActivity(target);
                this.this$0.finish();
            }
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$shouldGetResolvedFilter() {
            return this.mFilterLastUsed;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processGroup(List<ResolvedComponentInfo> rList, int start, int end, ResolvedComponentInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                this.addResolveInfoWithAlternates(ro, null, roLabel);
            } else {
                this.mHasExtendedInfo = true;
                boolean usePkg = false;
                ApplicationInfo ai = ro.getResolveInfoAt((int)0).activityInfo.applicationInfo;
                CharSequence startApp = ai.loadLabel(this.this$0.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j).getResolveInfoAt(0);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(this.this$0.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolvedComponentInfo rci = rList.get(k);
                    ResolveInfo add = rci.getResolveInfoAt(0);
                    CharSequence extraInfo = usePkg ? add.activityInfo.packageName : add.activityInfo.applicationInfo.loadLabel(this.this$0.mPm);
                    this.addResolveInfoWithAlternates(rci, extraInfo, roLabel);
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$addResolveInfoWithAlternates(ResolvedComponentInfo rci, CharSequence extraInfo, CharSequence roLabel) {
            int count = rci.getCount();
            Intent intent = rci.getIntentAt(0);
            ResolveInfo add = rci.getResolveInfoAt(0);
            Intent replaceIntent = this.this$0.getReplacementIntent(add.activityInfo, intent);
            DisplayResolveInfo dri = new DisplayResolveInfo(this.this$0, intent, add, roLabel, extraInfo, replaceIntent);
            dri.setPinned(rci.isPinned());
            this.addResolveInfo(dri);
            if (replaceIntent == intent) {
                int N = count;
                for (int i = 1; i < N; ++i) {
                    Intent altIntent = rci.getIntentAt(i);
                    dri.addAlternateSourceIntent(altIntent);
                }
            }
            this.updateLastChosenPosition(add);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateLastChosenPosition(ResolveInfo info) {
            if (this.mOtherProfile != null) {
                this.mLastChosenPosition = -1;
                return;
            }
            if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(info.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(info.activityInfo.name)) {
                this.mLastChosenPosition = this.mDisplayList.size() - 1;
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$addResolveInfo(DisplayResolveInfo dri) {
            if (dri != null && dri.mResolveInfo != null && ((DisplayResolveInfo)dri).mResolveInfo.targetUserId == -2) {
                for (DisplayResolveInfo existingInfo : this.mDisplayList) {
                    if (!ResolverActivity.resolveInfoMatch(dri.mResolveInfo, existingInfo.mResolveInfo)) continue;
                    return;
                }
                this.mDisplayList.add(dri);
            }
        }

        private final ResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$resolveInfoForPosition(int position, boolean filtered) {
            TargetInfo target = this.targetInfoForPosition(position, filtered);
            if (target != null) {
                return target.getResolveInfo();
            }
            return null;
        }

        private final TargetInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$targetInfoForPosition(int position, boolean filtered) {
            if (filtered) {
                return this.getItem(position);
            }
            if (this.mDisplayList.size() > position) {
                return this.mDisplayList.get(position);
            }
            return null;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getCount() {
            int totalSize;
            int n = totalSize = this.mDisplayList == null || this.mDisplayList.isEmpty() ? this.mPlaceholderCount : this.mDisplayList.size();
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                --totalSize;
            }
            return totalSize;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getUnfilteredCount() {
            return this.mDisplayList.size();
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayInfoCount() {
            return this.mDisplayList.size();
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayInfoAt(int index) {
            return this.mDisplayList.get(index);
        }

        private final TargetInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItem(int position) {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
                ++position;
            }
            if (this.mDisplayList.size() > position) {
                return this.mDisplayList.get(position);
            }
            return null;
        }

        private final long $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItemId(int position) {
            return position;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasExtendedInfo() {
            return this.mHasExtendedInfo;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasResolvedTarget(ResolveInfo info) {
            int N = this.mDisplayList.size();
            for (int i = 0; i < N; ++i) {
                if (!ResolverActivity.resolveInfoMatch(info, this.mDisplayList.get(i).getResolveInfo())) continue;
                return true;
            }
            return false;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayResolveInfoCount() {
            return this.mDisplayList.size();
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayResolveInfo(int index) {
            return this.mDisplayList.get(index);
        }

        private final View $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.createView(parent);
            }
            this.onBindView(view, (TargetInfo)this.getItem(position));
            return view;
        }

        private final View $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$createView(ViewGroup parent) {
            View view = this.onCreateView(parent);
            ViewHolder holder = new ViewHolder(view);
            view.setTag(holder);
            return view;
        }

        private final View $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367249, parent, false);
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$showsExtendedInfo(TargetInfo info) {
            return !TextUtils.isEmpty(info.getExtendedInfo());
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$isComponentPinned(ComponentName name) {
            return false;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$bindView(int position, View view) {
            this.onBindView(view, (TargetInfo)this.getItem(position));
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onBindView(View view, TargetInfo info) {
            ViewHolder holder = (ViewHolder)view.getTag();
            if (info == null) {
                holder.icon.setImageDrawable(this.this$0.getDrawable(17303313));
                return;
            }
            CharSequence label = info.getDisplayLabel();
            if (!TextUtils.equals(holder.text.getText(), label)) {
                holder.text.setText(info.getDisplayLabel());
            }
            if (this.showsExtendedInfo(info)) {
                holder.text2.setVisibility(0);
                holder.text2.setText(info.getExtendedInfo());
            } else {
                holder.text2.setVisibility(8);
            }
            if (info instanceof DisplayResolveInfo && !((DisplayResolveInfo)info).hasDisplayIcon()) {
                new LoadAdapterIconTask(this.this$0, (DisplayResolveInfo)info).execute(new Void[0]);
            }
            holder.icon.setImageDrawable(info.getDisplayIcon());
            if (holder.badge != null) {
                Drawable badge = info.getBadgeIcon();
                if (badge != null) {
                    holder.badge.setImageDrawable(badge);
                    holder.badge.setContentDescription(info.getBadgeContentDescription());
                    holder.badge.setVisibility(0);
                } else {
                    holder.badge.setVisibility(8);
                }
            }
        }

        private void __constructor__(ResolverActivity resolverActivity, Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl, ResolverListController resolverListController) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(resolverActivity, context, list, intentArray, list2, n, bl, resolverListController);
        }

        public ResolveListAdapter(ResolverActivity resolverActivity, Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl, ResolverListController resolverListController) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(com.android.internal.app.ResolverActivity android.content.Context java.util.List<android.content.Intent> android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> int boolean com.android.internal.app.ResolverListController ), 0, this, resolverActivity, context, list, intentArray, list2, n, bl, resolverListController);
        }

        public void handlePackagesChanged() {
            InvokeDynamicSupport.bootstrap("handlePackagesChanged", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$handlePackagesChanged(), 0, this);
        }

        public void setPlaceholderCount(int n) {
            InvokeDynamicSupport.bootstrap("setPlaceholderCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$setPlaceholderCount(int ), 0, this, n);
        }

        public int getPlaceholderCount() {
            return (int)InvokeDynamicSupport.bootstrap("getPlaceholderCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getPlaceholderCount(), 0, this);
        }

        public DisplayResolveInfo getFilteredItem() {
            return InvokeDynamicSupport.bootstrap("getFilteredItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredItem(), 0, this);
        }

        public DisplayResolveInfo getOtherProfile() {
            return InvokeDynamicSupport.bootstrap("getOtherProfile", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getOtherProfile(), 0, this);
        }

        public int getFilteredPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getFilteredPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredPosition(), 0, this);
        }

        public boolean hasFilteredItem() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFilteredItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasFilteredItem(), 0, this);
        }

        public float getScore(DisplayResolveInfo displayResolveInfo) {
            return (float)InvokeDynamicSupport.bootstrap("getScore", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getScore(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, displayResolveInfo);
        }

        public void updateModel(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("updateModel", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateModel(android.content.ComponentName ), 0, this, componentName);
        }

        public void updateChooserCounts(String string2, int n, String string3) {
            InvokeDynamicSupport.bootstrap("updateChooserCounts", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateChooserCounts(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
        }

        protected boolean rebuildList() {
            return (boolean)InvokeDynamicSupport.bootstrap("rebuildList", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$rebuildList(), 0, this);
        }

        private void processSortedList(List<ResolvedComponentInfo> list) {
            InvokeDynamicSupport.bootstrap("processSortedList", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processSortedList(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> ), 0, this, list);
        }

        private void postListReadyRunnable() {
            InvokeDynamicSupport.bootstrap("postListReadyRunnable", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$postListReadyRunnable(), 0, this);
        }

        public void onListRebuilt() {
            InvokeDynamicSupport.bootstrap("onListRebuilt", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onListRebuilt(), 0, this);
        }

        public boolean shouldGetResolvedFilter() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldGetResolvedFilter", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$shouldGetResolvedFilter(), 0, this);
        }

        private void processGroup(List<ResolvedComponentInfo> list, int n, int n2, ResolvedComponentInfo resolvedComponentInfo, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("processGroup", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processGroup(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> int int com.android.internal.app.ResolverActivity$ResolvedComponentInfo java.lang.CharSequence ), 0, this, list, n, n2, resolvedComponentInfo, charSequence);
        }

        private void addResolveInfoWithAlternates(ResolvedComponentInfo resolvedComponentInfo, CharSequence charSequence, CharSequence charSequence2) {
            InvokeDynamicSupport.bootstrap("addResolveInfoWithAlternates", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$addResolveInfoWithAlternates(com.android.internal.app.ResolverActivity$ResolvedComponentInfo java.lang.CharSequence java.lang.CharSequence ), 0, this, resolvedComponentInfo, charSequence, charSequence2);
        }

        private void updateLastChosenPosition(ResolveInfo resolveInfo) {
            InvokeDynamicSupport.bootstrap("updateLastChosenPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$updateLastChosenPosition(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
        }

        private void addResolveInfo(DisplayResolveInfo displayResolveInfo) {
            InvokeDynamicSupport.bootstrap("addResolveInfo", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$addResolveInfo(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, displayResolveInfo);
        }

        public ResolveInfo resolveInfoForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("resolveInfoForPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$resolveInfoForPosition(int boolean ), 0, this, n, bl);
        }

        public TargetInfo targetInfoForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("targetInfoForPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$targetInfoForPosition(int boolean ), 0, this, n, bl);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getCount(), 0, this);
        }

        public int getUnfilteredCount() {
            return (int)InvokeDynamicSupport.bootstrap("getUnfilteredCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getUnfilteredCount(), 0, this);
        }

        public int getDisplayInfoCount() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayInfoCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayInfoCount(), 0, this);
        }

        public DisplayResolveInfo getDisplayInfoAt(int n) {
            return InvokeDynamicSupport.bootstrap("getDisplayInfoAt", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayInfoAt(int ), 0, this, n);
        }

        @Override
        public TargetInfo getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItemId(int ), 0, this, n);
        }

        public boolean hasExtendedInfo() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasExtendedInfo", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasExtendedInfo(), 0, this);
        }

        public boolean hasResolvedTarget(ResolveInfo resolveInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasResolvedTarget", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasResolvedTarget(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
        }

        public int getDisplayResolveInfoCount() {
            return (int)InvokeDynamicSupport.bootstrap("getDisplayResolveInfoCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayResolveInfoCount(), 0, this);
        }

        public DisplayResolveInfo getDisplayResolveInfo(int n) {
            return InvokeDynamicSupport.bootstrap("getDisplayResolveInfo", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getDisplayResolveInfo(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        public View createView(ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("createView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$createView(android.view.ViewGroup ), 0, this, viewGroup);
        }

        public View onCreateView(ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("onCreateView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onCreateView(android.view.ViewGroup ), 0, this, viewGroup);
        }

        public boolean showsExtendedInfo(TargetInfo targetInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("showsExtendedInfo", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$showsExtendedInfo(com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, targetInfo);
        }

        public boolean isComponentPinned(ComponentName componentName) {
            return (boolean)InvokeDynamicSupport.bootstrap("isComponentPinned", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$isComponentPinned(android.content.ComponentName ), 0, this, componentName);
        }

        public void bindView(int n, View view) {
            InvokeDynamicSupport.bootstrap("bindView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$bindView(int android.view.View ), 0, this, n, view);
        }

        private void onBindView(View view, TargetInfo targetInfo) {
            InvokeDynamicSupport.bootstrap("onBindView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$onBindView(android.view.View com.android.internal.app.ResolverActivity$TargetInfo ), 0, this, view, targetInfo);
        }

        public /* synthetic */ ResolveListAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolveListAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TargetInfo
    extends InstrumentedInterface {
        public Intent getResolvedIntent();

        public ComponentName getResolvedComponentName();

        public boolean start(Activity var1, Bundle var2);

        public boolean startAsCaller(Activity var1, Bundle var2, int var3);

        public boolean startAsUser(Activity var1, Bundle var2, UserHandle var3);

        public ResolveInfo getResolveInfo();

        public CharSequence getDisplayLabel();

        public CharSequence getExtendedInfo();

        public Drawable getDisplayIcon();

        public Drawable getBadgeIcon();

        public CharSequence getBadgeContentDescription();

        public TargetInfo cloneFilledIn(Intent var1, int var2);

        public List<Intent> getAllSourceIntents();

        public boolean isPinned();
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class DisplayResolveInfo
    implements TargetInfo,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ResolveInfo mResolveInfo;
        private CharSequence mDisplayLabel;
        private Drawable mDisplayIcon;
        private Drawable mBadge;
        private CharSequence mExtendedInfo;
        private Intent mResolvedIntent;
        private List<Intent> mSourceIntents;
        private boolean mPinned;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(ResolverActivity this$0, Intent originalIntent, ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.mSourceIntents = new ArrayList<Intent>();
            this.mSourceIntents.add(originalIntent);
            this.mResolveInfo = pri;
            this.mDisplayLabel = pLabel;
            this.mExtendedInfo = pInfo;
            Intent intent = new Intent(pOrigIntent != null ? pOrigIntent : this$0.getReplacementIntent(pri.activityInfo, this$0.getTargetIntent()));
            intent.addFlags(0x3000000);
            ActivityInfo ai = this.mResolveInfo.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            this.mResolvedIntent = intent;
        }

        private void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(ResolverActivity this$0, DisplayResolveInfo other, Intent fillInIntent, int flags) {
            this.mSourceIntents = new ArrayList<Intent>();
            this.mSourceIntents.addAll(other.getAllSourceIntents());
            this.mResolveInfo = other.mResolveInfo;
            this.mDisplayLabel = other.mDisplayLabel;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mExtendedInfo = other.mExtendedInfo;
            this.mResolvedIntent = new Intent(other.mResolvedIntent);
            this.mResolvedIntent.fillIn(fillInIntent, flags);
            this.mPinned = other.mPinned;
        }

        private final ResolveInfo $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolveInfo() {
            return this.mResolveInfo;
        }

        private final CharSequence $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getDisplayLabel() {
            return this.mDisplayLabel;
        }

        private final Drawable $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getDisplayIcon() {
            return this.mDisplayIcon;
        }

        private final Drawable $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getBadgeIcon() {
            if (TextUtils.isEmpty(this.getExtendedInfo())) {
                return null;
            }
            if (this.mBadge == null && this.mResolveInfo != null && this.mResolveInfo.activityInfo != null && this.mResolveInfo.activityInfo.applicationInfo != null) {
                if (this.mResolveInfo.activityInfo.icon == 0 || this.mResolveInfo.activityInfo.icon == this.mResolveInfo.activityInfo.applicationInfo.icon) {
                    return null;
                }
                this.mBadge = this.mResolveInfo.activityInfo.applicationInfo.loadIcon(this.this$0.mPm);
            }
            return this.mBadge;
        }

        private final CharSequence $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getBadgeContentDescription() {
            return null;
        }

        private final TargetInfo $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$cloneFilledIn(Intent fillInIntent, int flags) {
            return new DisplayResolveInfo(this.this$0, this, fillInIntent, flags);
        }

        private final List<Intent> $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getAllSourceIntents() {
            return this.mSourceIntents;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$addAlternateSourceIntent(Intent alt) {
            this.mSourceIntents.add(alt);
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$setDisplayIcon(Drawable icon) {
            this.mDisplayIcon = icon;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$hasDisplayIcon() {
            return this.mDisplayIcon != null;
        }

        private final CharSequence $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getExtendedInfo() {
            return this.mExtendedInfo;
        }

        private final Intent $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolvedIntent() {
            return this.mResolvedIntent;
        }

        private final ComponentName $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolvedComponentName() {
            return new ComponentName(this.mResolveInfo.activityInfo.packageName, this.mResolveInfo.activityInfo.name);
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$start(Activity activity, Bundle options) {
            activity.startActivity(this.mResolvedIntent, options);
            return true;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$startAsCaller(Activity activity, Bundle options, int userId) {
            activity.startActivityAsCaller(this.mResolvedIntent, options, false, userId);
            return true;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$startAsUser(Activity activity, Bundle options, UserHandle user) {
            activity.startActivityAsUser(this.mResolvedIntent, options, user);
            return false;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$isPinned() {
            return this.mPinned;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$setPinned(boolean pinned) {
            this.mPinned = pinned;
        }

        private void __constructor__(ResolverActivity resolverActivity, Intent intent, ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent2) {
            this.$$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(resolverActivity, intent, resolveInfo, charSequence, charSequence2, intent2);
        }

        public DisplayResolveInfo(ResolverActivity resolverActivity, Intent intent, ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent2) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(com.android.internal.app.ResolverActivity android.content.Intent android.content.pm.ResolveInfo java.lang.CharSequence java.lang.CharSequence android.content.Intent ), 0, this, resolverActivity, intent, resolveInfo, charSequence, charSequence2, intent2);
        }

        private void __constructor__(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo, Intent intent, int n) {
            this.$$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(resolverActivity, displayResolveInfo, intent, n);
        }

        private DisplayResolveInfo(ResolverActivity resolverActivity, DisplayResolveInfo displayResolveInfo, Intent intent, int n) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(com.android.internal.app.ResolverActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo android.content.Intent int ), 0, this, resolverActivity, displayResolveInfo, intent, n);
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return InvokeDynamicSupport.bootstrap("getResolveInfo", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolveInfo(), 0, this);
        }

        @Override
        public CharSequence getDisplayLabel() {
            return InvokeDynamicSupport.bootstrap("getDisplayLabel", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getDisplayLabel(), 0, this);
        }

        @Override
        public Drawable getDisplayIcon() {
            return InvokeDynamicSupport.bootstrap("getDisplayIcon", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getDisplayIcon(), 0, this);
        }

        @Override
        public Drawable getBadgeIcon() {
            return InvokeDynamicSupport.bootstrap("getBadgeIcon", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getBadgeIcon(), 0, this);
        }

        @Override
        public CharSequence getBadgeContentDescription() {
            return InvokeDynamicSupport.bootstrap("getBadgeContentDescription", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getBadgeContentDescription(), 0, this);
        }

        @Override
        public TargetInfo cloneFilledIn(Intent intent, int n) {
            return InvokeDynamicSupport.bootstrap("cloneFilledIn", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$cloneFilledIn(android.content.Intent int ), 0, this, intent, n);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            return InvokeDynamicSupport.bootstrap("getAllSourceIntents", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getAllSourceIntents(), 0, this);
        }

        public void addAlternateSourceIntent(Intent intent) {
            InvokeDynamicSupport.bootstrap("addAlternateSourceIntent", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$addAlternateSourceIntent(android.content.Intent ), 0, this, intent);
        }

        public void setDisplayIcon(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("setDisplayIcon", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$setDisplayIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        public boolean hasDisplayIcon() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasDisplayIcon", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$hasDisplayIcon(), 0, this);
        }

        @Override
        public CharSequence getExtendedInfo() {
            return InvokeDynamicSupport.bootstrap("getExtendedInfo", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getExtendedInfo(), 0, this);
        }

        @Override
        public Intent getResolvedIntent() {
            return InvokeDynamicSupport.bootstrap("getResolvedIntent", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolvedIntent(), 0, this);
        }

        @Override
        public ComponentName getResolvedComponentName() {
            return InvokeDynamicSupport.bootstrap("getResolvedComponentName", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$getResolvedComponentName(), 0, this);
        }

        @Override
        public boolean start(Activity activity, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$start(android.app.Activity android.os.Bundle ), 0, this, activity, bundle);
        }

        @Override
        public boolean startAsCaller(Activity activity, Bundle bundle, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("startAsCaller", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$startAsCaller(android.app.Activity android.os.Bundle int ), 0, this, activity, bundle, n);
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle bundle, UserHandle userHandle) {
            return (boolean)InvokeDynamicSupport.bootstrap("startAsUser", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$startAsUser(android.app.Activity android.os.Bundle android.os.UserHandle ), 0, this, activity, bundle, userHandle);
        }

        @Override
        public boolean isPinned() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPinned", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$isPinned(), 0, this);
        }

        public void setPinned(boolean bl) {
            InvokeDynamicSupport.bootstrap("setPinned", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$setPinned(boolean ), 0, this, bl);
        }

        public /* synthetic */ DisplayResolveInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayResolveInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ActionTitle
    extends Enum<ActionTitle> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ActionTitle VIEW;
        public static /* enum */ ActionTitle EDIT;
        public static /* enum */ ActionTitle SEND;
        public static /* enum */ ActionTitle SENDTO;
        public static /* enum */ ActionTitle SEND_MULTIPLE;
        public static /* enum */ ActionTitle CAPTURE_IMAGE;
        public static /* enum */ ActionTitle DEFAULT;
        public static /* enum */ ActionTitle HOME;
        public String action;
        public int titleRes;
        public int namedTitleRes;
        public int labelRes;
        private static /* synthetic */ ActionTitle[] $VALUES;

        private static final ActionTitle[] $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$values() {
            return (ActionTitle[])$VALUES.clone();
        }

        private static final ActionTitle $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$valueOf(String name) {
            return Enum.valueOf(ActionTitle.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(String string2, int n, String action, int titleRes, int namedTitleRes, int labelRes) {
            this.action = action;
            this.titleRes = titleRes;
            this.namedTitleRes = namedTitleRes;
            this.labelRes = labelRes;
        }

        private static final ActionTitle $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$forAction(String action) {
            for (ActionTitle title : ActionTitle.values()) {
                if (title == HOME || action == null || !action.equals(title.action)) continue;
                return title;
            }
            return DEFAULT;
        }

        static void __staticInitializer__() {
            VIEW = new ActionTitle("android.intent.action.VIEW", 17041085, 17041087, 17041086);
            EDIT = new ActionTitle("android.intent.action.EDIT", 17041070, 17041072, 17041071);
            SEND = new ActionTitle("android.intent.action.SEND", 17041079, 17041081, 17041080);
            SENDTO = new ActionTitle("android.intent.action.SENDTO", 17041082, 17041084, 17041083);
            SEND_MULTIPLE = new ActionTitle("android.intent.action.SEND_MULTIPLE", 17041079, 17041081, 17041080);
            CAPTURE_IMAGE = new ActionTitle("android.media.action.IMAGE_CAPTURE", 17041076, 17041078, 17041077);
            DEFAULT = new ActionTitle(null, 17041067, 17041069, 17041068);
            HOME = new ActionTitle("android.intent.action.MAIN", 17041073, 17041075, 17041074);
            $VALUES = new ActionTitle[]{VIEW, EDIT, SEND, SENDTO, SEND_MULTIPLE, CAPTURE_IMAGE, DEFAULT, HOME};
        }

        public static ActionTitle[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$values(), 0);
        }

        public static ActionTitle valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3, int n2, int n3, int n4) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(string2, n, string3, n2, n3, n4);
        }

        private ActionTitle(String string3, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(java.lang.String int java.lang.String int int int ), 0, this, string2, n, string3, n2, n3, n4);
        }

        public static ActionTitle forAction(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("forAction", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$forAction(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(ActionTitle.class);
        }

        public /* synthetic */ ActionTitle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionTitle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

