/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverComparator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverListController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mContext;
    private PackageManager mpm;
    private int mLaunchedFromUid;
    private Intent mTargetIntent;
    private String mReferrerPackage;
    private static String TAG = "ResolverListController";
    private static boolean DEBUG = false;
    private ResolverComparator mResolverComparator;
    private boolean isComputed;

    private void $$robo$$com_android_internal_app_ResolverListController$__constructor__(Context context, PackageManager pm, Intent targetIntent, String referrerPackage, int launchedFromUid) {
        this.isComputed = false;
        this.mContext = context;
        this.mpm = pm;
        this.mLaunchedFromUid = launchedFromUid;
        this.mTargetIntent = targetIntent;
        this.mReferrerPackage = referrerPackage;
        this.mResolverComparator = new ResolverComparator(this.mContext, this.mTargetIntent, this.mReferrerPackage, null);
    }

    @VisibleForTesting
    private final ResolveInfo $$robo$$com_android_internal_app_ResolverListController$getLastChosen() throws RemoteException {
        return AppGlobals.getPackageManager().getLastChosenActivity(this.mTargetIntent, this.mTargetIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536);
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_app_ResolverListController$setLastChosen(Intent intent, IntentFilter filter, int match) throws RemoteException {
        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveType(this.mContext.getContentResolver()), 65536, filter, match, intent.getComponent());
    }

    @VisibleForTesting
    private final List<ResolverActivity.ResolvedComponentInfo> $$robo$$com_android_internal_app_ResolverListController$getResolversForIntent(boolean shouldGetResolvedFilter, boolean shouldGetActivityMetadata, List<Intent> intents) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> resolvedComponents = null;
        int N = intents.size();
        for (int i = 0; i < N; ++i) {
            Intent intent = intents.get(i);
            int flags = 0x10000 | (shouldGetResolvedFilter ? 64 : 0) | (shouldGetActivityMetadata ? 128 : 0);
            if (intent.isWebIntent() || (intent.getFlags() & 0x800) != 0) {
                flags |= 0x800000;
            }
            List<ResolveInfo> infos = this.mpm.queryIntentActivities(intent, flags);
            int totalSize = infos.size();
            for (int j = totalSize - 1; j >= 0; --j) {
                ResolveInfo info = infos.get(j);
                if (info.activityInfo == null || info.activityInfo.exported) continue;
                infos.remove(j);
            }
            if (infos == null) continue;
            if (resolvedComponents == null) {
                resolvedComponents = new ArrayList<ResolverActivity.ResolvedComponentInfo>();
            }
            this.addResolveListDedupe(resolvedComponents, intent, infos);
        }
        return resolvedComponents;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_app_ResolverListController$addResolveListDedupe(List<ResolverActivity.ResolvedComponentInfo> into, Intent intent, List<ResolveInfo> from) {
        int fromCount = from.size();
        int intoCount = into.size();
        for (int i = 0; i < fromCount; ++i) {
            ResolverActivity.ResolvedComponentInfo rci;
            ResolveInfo newInfo = from.get(i);
            boolean found = false;
            for (int j = 0; j < intoCount; ++j) {
                rci = into.get(j);
                if (!ResolverListController.isSameResolvedComponent(newInfo, rci)) continue;
                found = true;
                rci.add(intent, newInfo);
                break;
            }
            if (found) continue;
            ComponentName name = new ComponentName(newInfo.activityInfo.packageName, newInfo.activityInfo.name);
            rci = new ResolverActivity.ResolvedComponentInfo(name, intent, newInfo);
            rci.setPinned(this.isComponentPinned(name));
            into.add(rci);
        }
    }

    @VisibleForTesting
    private final ArrayList<ResolverActivity.ResolvedComponentInfo> $$robo$$com_android_internal_app_ResolverListController$filterIneligibleActivities(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        for (int i = inputList.size() - 1; i >= 0; --i) {
            boolean suspended;
            ActivityInfo ai = inputList.get((int)i).getResolveInfoAt((int)0).activityInfo;
            int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
            boolean bl = suspended = (ai.applicationInfo.flags & 0x40000000) != 0;
            if (granted == 0 && !suspended && !this.isComponentFiltered(ai.getComponentName())) continue;
            if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
            }
            inputList.remove(i);
        }
        return listToReturn;
    }

    @VisibleForTesting
    private final ArrayList<ResolverActivity.ResolvedComponentInfo> $$robo$$com_android_internal_app_ResolverListController$filterLowPriority(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        ResolverActivity.ResolvedComponentInfo rci0 = inputList.get(0);
        ResolveInfo r0 = rci0.getResolveInfoAt(0);
        int N = inputList.size();
        for (int i = 1; i < N; ++i) {
            ResolveInfo ri = inputList.get(i).getResolveInfoAt(0);
            if (r0.priority == ri.priority && r0.isDefault == ri.isDefault) continue;
            while (i < N) {
                if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                    listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
                }
                inputList.remove(i);
                --N;
            }
        }
        return listToReturn;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_app_ResolverListController$sort(List<ResolverActivity.ResolvedComponentInfo> inputList) {
        if (this.mResolverComparator == null) {
            Log.d("ResolverListController", "Comparator has already been destroyed; skipped.");
            return;
        }
        try {
            CallSite beforeRank = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            if (!this.isComputed) {
                CountDownLatch finishComputeSignal = new CountDownLatch(1);
                ComputeCallback callback = new ComputeCallback(this, finishComputeSignal);
                this.mResolverComparator.setCallBack(callback);
                this.mResolverComparator.compute(inputList);
                finishComputeSignal.await();
                this.isComputed = true;
            }
            Collections.sort(inputList, this.mResolverComparator);
            CallSite callSite = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        catch (InterruptedException e) {
            Log.e("ResolverListController", "Compute & Sort was interrupted: " + e);
        }
    }

    private static final boolean $$robo$$com_android_internal_app_ResolverListController$isSameResolvedComponent(ResolveInfo a, ResolverActivity.ResolvedComponentInfo b) {
        ActivityInfo ai = a.activityInfo;
        return ai.packageName.equals(b.name.getPackageName()) && ai.name.equals(b.name.getClassName());
    }

    private final boolean $$robo$$com_android_internal_app_ResolverListController$isComponentPinned(ComponentName name) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_app_ResolverListController$isComponentFiltered(ComponentName componentName) {
        return false;
    }

    @VisibleForTesting
    private final float $$robo$$com_android_internal_app_ResolverListController$getScore(ResolverActivity.DisplayResolveInfo target) {
        return this.mResolverComparator.getScore(target.getResolvedComponentName());
    }

    private final void $$robo$$com_android_internal_app_ResolverListController$updateModel(ComponentName componentName) {
        this.mResolverComparator.updateModel(componentName);
    }

    private final void $$robo$$com_android_internal_app_ResolverListController$updateChooserCounts(String packageName, int userId, String action) {
        this.mResolverComparator.updateChooserCounts(packageName, userId, action);
    }

    private final void $$robo$$com_android_internal_app_ResolverListController$destroy() {
        this.mResolverComparator.destroy();
    }

    private void __constructor__(Context context, PackageManager packageManager, Intent intent, String string2, int n) {
        this.$$robo$$com_android_internal_app_ResolverListController$__constructor__(context, packageManager, intent, string2, n);
    }

    public ResolverListController(Context context, PackageManager packageManager, Intent intent, String string2, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverListController$__constructor__(android.content.Context android.content.pm.PackageManager android.content.Intent java.lang.String int ), 0, this, context, packageManager, intent, string2, n);
    }

    public ResolveInfo getLastChosen() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getLastChosen", $$robo$$com_android_internal_app_ResolverListController$getLastChosen(), 0, this);
    }

    public void setLastChosen(Intent intent, IntentFilter intentFilter, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("setLastChosen", $$robo$$com_android_internal_app_ResolverListController$setLastChosen(android.content.Intent android.content.IntentFilter int ), 0, this, intent, intentFilter, n);
    }

    public List<ResolverActivity.ResolvedComponentInfo> getResolversForIntent(boolean bl, boolean bl2, List<Intent> list) {
        return InvokeDynamicSupport.bootstrap("getResolversForIntent", $$robo$$com_android_internal_app_ResolverListController$getResolversForIntent(boolean boolean java.util.List<android.content.Intent> ), 0, this, bl, bl2, list);
    }

    public void addResolveListDedupe(List<ResolverActivity.ResolvedComponentInfo> list, Intent intent, List<ResolveInfo> list2) {
        InvokeDynamicSupport.bootstrap("addResolveListDedupe", $$robo$$com_android_internal_app_ResolverListController$addResolveListDedupe(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> android.content.Intent java.util.List<android.content.pm.ResolveInfo> ), 0, this, list, intent, list2);
    }

    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterIneligibleActivities(List<ResolverActivity.ResolvedComponentInfo> list, boolean bl) {
        return InvokeDynamicSupport.bootstrap("filterIneligibleActivities", $$robo$$com_android_internal_app_ResolverListController$filterIneligibleActivities(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> boolean ), 0, this, list, bl);
    }

    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterLowPriority(List<ResolverActivity.ResolvedComponentInfo> list, boolean bl) {
        return InvokeDynamicSupport.bootstrap("filterLowPriority", $$robo$$com_android_internal_app_ResolverListController$filterLowPriority(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> boolean ), 0, this, list, bl);
    }

    public void sort(List<ResolverActivity.ResolvedComponentInfo> list) {
        InvokeDynamicSupport.bootstrap("sort", $$robo$$com_android_internal_app_ResolverListController$sort(java.util.List<com.android.internal.app.ResolverActivity$ResolvedComponentInfo> ), 0, this, list);
    }

    private static boolean isSameResolvedComponent(ResolveInfo resolveInfo, ResolverActivity.ResolvedComponentInfo resolvedComponentInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSameResolvedComponent", $$robo$$com_android_internal_app_ResolverListController$isSameResolvedComponent(android.content.pm.ResolveInfo com.android.internal.app.ResolverActivity$ResolvedComponentInfo ), 0, (ResolveInfo)resolveInfo, (ResolverActivity.ResolvedComponentInfo)resolvedComponentInfo);
    }

    boolean isComponentPinned(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isComponentPinned", $$robo$$com_android_internal_app_ResolverListController$isComponentPinned(android.content.ComponentName ), 0, this, componentName);
    }

    boolean isComponentFiltered(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isComponentFiltered", $$robo$$com_android_internal_app_ResolverListController$isComponentFiltered(android.content.ComponentName ), 0, this, componentName);
    }

    public float getScore(ResolverActivity.DisplayResolveInfo displayResolveInfo) {
        return (float)InvokeDynamicSupport.bootstrap("getScore", $$robo$$com_android_internal_app_ResolverListController$getScore(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, displayResolveInfo);
    }

    public void updateModel(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("updateModel", $$robo$$com_android_internal_app_ResolverListController$updateModel(android.content.ComponentName ), 0, this, componentName);
    }

    public void updateChooserCounts(String string2, int n, String string3) {
        InvokeDynamicSupport.bootstrap("updateChooserCounts", $$robo$$com_android_internal_app_ResolverListController$updateChooserCounts(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_app_ResolverListController$destroy(), 0, this);
    }

    public /* synthetic */ ResolverListController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverListController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ComputeCallback
    implements ResolverComparator.AfterCompute,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CountDownLatch mFinishComputeSignal;
        /* synthetic */ ResolverListController this$0;

        private void $$robo$$com_android_internal_app_ResolverListController_ComputeCallback$__constructor__(ResolverListController resolverListController, CountDownLatch finishComputeSignal) {
            this.mFinishComputeSignal = finishComputeSignal;
        }

        private final void $$robo$$com_android_internal_app_ResolverListController_ComputeCallback$afterCompute() {
            this.mFinishComputeSignal.countDown();
        }

        private void __constructor__(ResolverListController resolverListController, CountDownLatch countDownLatch) {
            this.$$robo$$com_android_internal_app_ResolverListController_ComputeCallback$__constructor__(resolverListController, countDownLatch);
        }

        public ComputeCallback(ResolverListController resolverListController, CountDownLatch countDownLatch) {
            this.this$0 = resolverListController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverListController_ComputeCallback$__constructor__(com.android.internal.app.ResolverListController java.util.concurrent.CountDownLatch ), 0, this, resolverListController, countDownLatch);
        }

        @Override
        public void afterCompute() {
            InvokeDynamicSupport.bootstrap("afterCompute", $$robo$$com_android_internal_app_ResolverListController_ComputeCallback$afterCompute(), 0, this);
        }

        public /* synthetic */ ComputeCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ComputeCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

