/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SuspendedAppActivity
extends AlertActivity
implements DialogInterface.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SuspendedAppActivity";
    public static String EXTRA_SUSPENDED_PACKAGE = "SuspendedAppActivity.extra.SUSPENDED_PACKAGE";
    public static String EXTRA_SUSPENDING_PACKAGE = "SuspendedAppActivity.extra.SUSPENDING_PACKAGE";
    public static String EXTRA_DIALOG_MESSAGE = "SuspendedAppActivity.extra.DIALOG_MESSAGE";
    private Intent mMoreDetailsIntent;
    private int mUserId;
    private PackageManager mPm;

    private void $$robo$$com_android_internal_app_SuspendedAppActivity$__constructor__() {
    }

    private final CharSequence $$robo$$com_android_internal_app_SuspendedAppActivity$getAppLabel(String packageName) {
        try {
            return this.mPm.getApplicationInfoAsUser(packageName, 0, this.mUserId).loadLabel(this.mPm);
        }
        catch (PackageManager.NameNotFoundException ne) {
            Slog.e("SuspendedAppActivity", "Package " + packageName + " not found", ne);
            return packageName;
        }
    }

    private final Intent $$robo$$com_android_internal_app_SuspendedAppActivity$getMoreDetailsActivity(String suspendingPackage, String suspendedPackage, int userId) {
        Intent moreDetailsIntent = new Intent("android.intent.action.SHOW_SUSPENDED_APP_DETAILS").setPackage(suspendingPackage);
        String requiredPermission = "android.permission.SEND_SHOW_SUSPENDED_APP_DETAILS";
        ResolveInfo resolvedInfo = this.mPm.resolveActivityAsUser(moreDetailsIntent, 0, userId);
        if (resolvedInfo != null && resolvedInfo.activityInfo != null && "android.permission.SEND_SHOW_SUSPENDED_APP_DETAILS".equals(resolvedInfo.activityInfo.permission)) {
            moreDetailsIntent.putExtra("android.intent.extra.PACKAGE_NAME", suspendedPackage).setFlags(0x14000000);
            return moreDetailsIntent;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_app_SuspendedAppActivity$onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mPm = this.getPackageManager();
        this.getWindow().setType(2008);
        Intent intent = this.getIntent();
        this.mUserId = intent.getIntExtra("android.intent.extra.USER_ID", -1);
        if (this.mUserId < 0) {
            Slog.wtf("SuspendedAppActivity", "Invalid user: " + this.mUserId);
            this.finish();
            return;
        }
        String suppliedMessage = intent.getStringExtra("SuspendedAppActivity.extra.DIALOG_MESSAGE");
        String suspendedPackage = intent.getStringExtra("SuspendedAppActivity.extra.SUSPENDED_PACKAGE");
        String suspendingPackage = intent.getStringExtra("SuspendedAppActivity.extra.SUSPENDING_PACKAGE");
        CharSequence suspendedAppLabel = this.getAppLabel(suspendedPackage);
        String dialogMessage = suppliedMessage == null ? this.getString(17039497, suspendedAppLabel, this.getAppLabel(suspendingPackage)) : String.format(this.getResources().getConfiguration().getLocales().get(0), suppliedMessage, suspendedAppLabel);
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = this.getString(17039499);
        ap.mMessage = dialogMessage;
        ap.mPositiveButtonText = this.getString(17039370);
        this.mMoreDetailsIntent = this.getMoreDetailsActivity(suspendingPackage, suspendedPackage, this.mUserId);
        if (this.mMoreDetailsIntent != null) {
            ap.mNeutralButtonText = this.getString(17039498);
        }
        ap.mPositiveButtonListener = ap.mNeutralButtonListener = this;
        this.setupAlert();
    }

    private final void $$robo$$com_android_internal_app_SuspendedAppActivity$onClick(DialogInterface dialog, int which) {
        switch (which) {
            case -3: {
                this.startActivityAsUser(this.mMoreDetailsIntent, UserHandle.of(this.mUserId));
                Slog.i("SuspendedAppActivity", "Started more details activity");
            }
        }
        this.finish();
    }

    private static final Intent $$robo$$com_android_internal_app_SuspendedAppActivity$createSuspendedAppInterceptIntent(String suspendedPackage, String suspendingPackage, String dialogMessage, int userId) {
        return new Intent().setClassName("android", SuspendedAppActivity.class.getName()).putExtra("SuspendedAppActivity.extra.SUSPENDED_PACKAGE", suspendedPackage).putExtra("SuspendedAppActivity.extra.DIALOG_MESSAGE", dialogMessage).putExtra("SuspendedAppActivity.extra.SUSPENDING_PACKAGE", suspendingPackage).putExtra("android.intent.extra.USER_ID", userId).setFlags(0x10800000);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_SuspendedAppActivity$__constructor__();
    }

    public SuspendedAppActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_SuspendedAppActivity$__constructor__(), 0, this);
    }

    private CharSequence getAppLabel(String string2) {
        return InvokeDynamicSupport.bootstrap("getAppLabel", $$robo$$com_android_internal_app_SuspendedAppActivity$getAppLabel(java.lang.String ), 0, this, string2);
    }

    private Intent getMoreDetailsActivity(String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrap("getMoreDetailsActivity", $$robo$$com_android_internal_app_SuspendedAppActivity$getMoreDetailsActivity(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_SuspendedAppActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_SuspendedAppActivity$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
    }

    public static Intent createSuspendedAppInterceptIntent(String string2, String string3, String string4, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createSuspendedAppInterceptIntent", $$robo$$com_android_internal_app_SuspendedAppActivity$createSuspendedAppInterceptIntent(java.lang.String java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (String)string4, (int)n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SuspendedAppActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

