/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.dex.DexMetadataHelper;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PackageHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int RECOMMEND_INSTALL_INTERNAL = 1;
    public static int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static int RECOMMEND_INSTALL_EPHEMERAL = 3;
    public static int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static int RECOMMEND_FAILED_INVALID_APK = -2;
    public static int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static int RECOMMEND_FAILED_INVALID_URI = -6;
    public static int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static String TAG = "PackageHelper";
    public static int APP_INSTALL_AUTO = 0;
    public static int APP_INSTALL_INTERNAL = 1;
    public static int APP_INSTALL_EXTERNAL = 2;
    private static TestableInterface sDefaultTestableInterface;

    private void $$robo$$com_android_internal_content_PackageHelper$__constructor__() {
    }

    private static final IStorageManager $$robo$$com_android_internal_content_PackageHelper$getStorageManager() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IStorageManager.Stub.asInterface(service);
        }
        Log.e("PackageHelper", "Can't get storagemanager service");
        throw new RemoteException("Could not contact storagemanager service");
    }

    private static final synchronized TestableInterface $$robo$$com_android_internal_content_PackageHelper$getDefaultTestableInterface() {
        if (sDefaultTestableInterface == null) {
            sDefaultTestableInterface = new ShadowedObject(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_content_PackageHelper_1$__constructor__() {
                }

                private final StorageManager $$robo$$com_android_internal_content_PackageHelper_1$getStorageManager(Context context) {
                    return context.getSystemService(StorageManager.class);
                }

                private final boolean $$robo$$com_android_internal_content_PackageHelper_1$getForceAllowOnExternalSetting(Context context) {
                    return Settings.Global.getInt(context.getContentResolver(), "force_allow_on_external", 0) != 0;
                }

                private final boolean $$robo$$com_android_internal_content_PackageHelper_1$getAllow3rdPartyOnInternalConfig(Context context) {
                    return context.getResources().getBoolean(17956869);
                }

                private final ApplicationInfo $$robo$$com_android_internal_content_PackageHelper_1$getExistingAppInfo(Context context, String packageName) {
                    ApplicationInfo existingInfo = null;
                    try {
                        existingInfo = context.getPackageManager().getApplicationInfo(packageName, 0x400000);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    return existingInfo;
                }

                private final File $$robo$$com_android_internal_content_PackageHelper_1$getDataDirectory() {
                    return Environment.getDataDirectory();
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_content_PackageHelper_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_PackageHelper_1$__constructor__(), 0, this);
                }

                @Override
                public StorageManager getStorageManager(Context context) {
                    return InvokeDynamicSupport.bootstrap("getStorageManager", $$robo$$com_android_internal_content_PackageHelper_1$getStorageManager(android.content.Context ), 0, this, context);
                }

                @Override
                public boolean getForceAllowOnExternalSetting(Context context) {
                    return (boolean)InvokeDynamicSupport.bootstrap("getForceAllowOnExternalSetting", $$robo$$com_android_internal_content_PackageHelper_1$getForceAllowOnExternalSetting(android.content.Context ), 0, this, context);
                }

                @Override
                public boolean getAllow3rdPartyOnInternalConfig(Context context) {
                    return (boolean)InvokeDynamicSupport.bootstrap("getAllow3rdPartyOnInternalConfig", $$robo$$com_android_internal_content_PackageHelper_1$getAllow3rdPartyOnInternalConfig(android.content.Context ), 0, this, context);
                }

                @Override
                public ApplicationInfo getExistingAppInfo(Context context, String string2) {
                    return InvokeDynamicSupport.bootstrap("getExistingAppInfo", $$robo$$com_android_internal_content_PackageHelper_1$getExistingAppInfo(android.content.Context java.lang.String ), 0, this, context, string2);
                }

                @Override
                public File getDataDirectory() {
                    return InvokeDynamicSupport.bootstrap("getDataDirectory", $$robo$$com_android_internal_content_PackageHelper_1$getDataDirectory(), 0, this);
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return sDefaultTestableInterface;
    }

    @Deprecated
    @VisibleForTesting
    private static final String $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(Context context, String packageName, int installLocation, long sizeBytes, TestableInterface testInterface) throws IOException {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        return PackageHelper.resolveInstallVolume(context, params, testInterface);
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(Context context, PackageInstaller.SessionParams params) throws IOException {
        TestableInterface testableInterface = PackageHelper.getDefaultTestableInterface();
        return PackageHelper.resolveInstallVolume(context, params.appPackageName, params.installLocation, params.sizeBytes, testableInterface);
    }

    @VisibleForTesting
    private static final String $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(Context context, PackageInstaller.SessionParams params, TestableInterface testInterface) throws IOException {
        StorageManager storageManager = testInterface.getStorageManager(context);
        boolean forceAllowOnExternal = testInterface.getForceAllowOnExternalSetting(context);
        boolean allow3rdPartyOnInternal = testInterface.getAllow3rdPartyOnInternalConfig(context);
        ApplicationInfo existingInfo = testInterface.getExistingAppInfo(context, params.appPackageName);
        ArraySet<String> allCandidates = new ArraySet<String>();
        boolean fitsOnInternal = false;
        VolumeInfo bestCandidate = null;
        long bestCandidateAvailBytes = Long.MIN_VALUE;
        for (VolumeInfo vol : storageManager.getVolumes()) {
            if (vol.type != 1 || !vol.isMountedWritable()) continue;
            boolean isInternalStorage = "private".equals(vol.id);
            UUID target = storageManager.getUuidForPath(new File(vol.path));
            long availBytes = storageManager.getAllocatableBytes(target, PackageHelper.translateAllocateFlags(params.installFlags));
            if (isInternalStorage) {
                boolean bl = fitsOnInternal = params.sizeBytes <= availBytes;
            }
            if (isInternalStorage && !allow3rdPartyOnInternal) continue;
            if (availBytes >= params.sizeBytes) {
                allCandidates.add(vol.fsUuid);
            }
            if (availBytes < bestCandidateAvailBytes) continue;
            bestCandidate = vol;
            bestCandidateAvailBytes = availBytes;
        }
        if (existingInfo != null && existingInfo.isSystemApp()) {
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for system app " + params.appPackageName + " upgrade");
        }
        if (!forceAllowOnExternal && params.installLocation == 1) {
            if (existingInfo != null && !Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL)) {
                throw new IOException("Cannot automatically move " + params.appPackageName + " from " + existingInfo.volumeUuid + " to internal storage");
            }
            if (!allow3rdPartyOnInternal) {
                throw new IOException("Not allowed to install non-system apps on internal storage");
            }
            if (fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            throw new IOException("Requested internal only, but not enough space");
        }
        if (existingInfo != null) {
            if (Objects.equals(existingInfo.volumeUuid, StorageManager.UUID_PRIVATE_INTERNAL) && fitsOnInternal) {
                return StorageManager.UUID_PRIVATE_INTERNAL;
            }
            if (allCandidates.contains(existingInfo.volumeUuid)) {
                return existingInfo.volumeUuid;
            }
            throw new IOException("Not enough space on existing volume " + existingInfo.volumeUuid + " for " + params.appPackageName + " upgrade");
        }
        if (bestCandidate != null) {
            return bestCandidate.fsUuid;
        }
        throw new IOException("No special requests, but no room on allowed volumes.  allow3rdPartyOnInternal? " + allow3rdPartyOnInternal);
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$fitsOnInternal(Context context, PackageInstaller.SessionParams params) throws IOException {
        UUID target;
        StorageManager storage = context.getSystemService(StorageManager.class);
        return params.sizeBytes <= storage.getAllocatableBytes(target = storage.getUuidForPath(Environment.getDataDirectory()), PackageHelper.translateAllocateFlags(params.installFlags));
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$fitsOnExternal(Context context, PackageInstaller.SessionParams params) {
        StorageManager storage = context.getSystemService(StorageManager.class);
        StorageVolume primary = storage.getPrimaryVolume();
        return params.sizeBytes > 0L && !primary.isEmulated() && "mounted".equals(primary.getState()) && params.sizeBytes <= storage.getStorageBytesUntilLow(primary.getPathFile());
    }

    @Deprecated
    private static final int $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(Context context, String packageName, int installLocation, long sizeBytes, int installFlags) {
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.appPackageName = packageName;
        params.installLocation = installLocation;
        params.sizeBytes = sizeBytes;
        params.installFlags = installFlags;
        try {
            return PackageHelper.resolveInstallLocation(context, params);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final int $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(Context context, PackageInstaller.SessionParams params) throws IOException {
        boolean checkBoth;
        int prefer;
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(params.appPackageName, 0x400000);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        boolean ephemeral = false;
        if ((params.installFlags & 0x800) != 0) {
            prefer = 1;
            ephemeral = true;
            checkBoth = false;
        } else if ((params.installFlags & 0x10) != 0) {
            prefer = 1;
            checkBoth = false;
        } else if ((params.installFlags & 8) != 0) {
            prefer = 2;
            checkBoth = false;
        } else if (params.installLocation == 1) {
            prefer = 1;
            checkBoth = false;
        } else if (params.installLocation == 2) {
            prefer = 2;
            checkBoth = true;
        } else if (params.installLocation == 0) {
            prefer = existingInfo != null ? ((existingInfo.flags & 0x40000) != 0 ? 2 : 1) : 1;
            checkBoth = true;
        } else {
            prefer = 1;
            checkBoth = false;
        }
        boolean fitsOnInternal = false;
        if (checkBoth || prefer == 1) {
            fitsOnInternal = PackageHelper.fitsOnInternal(context, params);
        }
        boolean fitsOnExternal = false;
        if (checkBoth || prefer == 2) {
            fitsOnExternal = PackageHelper.fitsOnExternal(context, params);
        }
        if (prefer == 1) {
            if (fitsOnInternal) {
                return ephemeral ? 3 : 1;
            }
        } else if (prefer == 2 && fitsOnExternal) {
            return 2;
        }
        if (checkBoth) {
            if (fitsOnInternal) {
                return 1;
            }
            if (fitsOnExternal) {
                return 2;
            }
        }
        return -1;
    }

    @Deprecated
    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, abiOverride);
    }

    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, abiOverride, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, String abiOverride, FileDescriptor fd) throws IOException {
        long l;
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = fd != null ? NativeLibraryHelper.Handle.createFd(pkg, fd) : NativeLibraryHelper.Handle.create(pkg);
            l = PackageHelper.calculateInstalledSize(pkg, handle, abiOverride);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(handle);
            throw throwable;
        }
        IoUtils.closeQuietly(handle);
        return l;
    }

    @Deprecated
    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, NativeLibraryHelper.Handle handle, String abiOverride) throws IOException {
        return PackageHelper.calculateInstalledSize(pkg, handle, abiOverride);
    }

    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, NativeLibraryHelper.Handle handle, String abiOverride) throws IOException {
        long sizeBytes = 0L;
        for (String codePath : pkg.getAllCodePaths()) {
            File codeFile = new File(codePath);
            sizeBytes += codeFile.length();
        }
        sizeBytes += DexMetadataHelper.getPackageDexMetadataSize(pkg);
        return sizeBytes += NativeLibraryHelper.sumNativeBinariesWithOverride(handle, abiOverride);
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$replaceEnd(String str, String before, String after) {
        if (!str.endsWith(before)) {
            throw new IllegalArgumentException("Expected " + str + " to end with " + before);
        }
        return str.substring(0, str.length() - before.length()) + after;
    }

    private static final int $$robo$$com_android_internal_content_PackageHelper$translateAllocateFlags(int installFlags) {
        if ((installFlags & 0x8000) != 0) {
            return 1;
        }
        return 0;
    }

    static void __staticInitializer__() {
        sDefaultTestableInterface = null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_content_PackageHelper$__constructor__();
    }

    public PackageHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_PackageHelper$__constructor__(), 0, this);
    }

    public static IStorageManager getStorageManager() throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("getStorageManager", $$robo$$com_android_internal_content_PackageHelper$getStorageManager(), 0);
    }

    private static synchronized TestableInterface getDefaultTestableInterface() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultTestableInterface", $$robo$$com_android_internal_content_PackageHelper$getDefaultTestableInterface(), 0);
    }

    @Deprecated
    public static String resolveInstallVolume(Context context, String string2, int n, long l, TestableInterface testableInterface) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("resolveInstallVolume", $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(android.content.Context java.lang.String int long com.android.internal.content.PackageHelper$TestableInterface ), 0, (Context)context, (String)string2, (int)n, (long)l, (TestableInterface)testableInterface);
    }

    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams sessionParams) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("resolveInstallVolume", $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(android.content.Context android.content.pm.PackageInstaller$SessionParams ), 0, (Context)context, (PackageInstaller.SessionParams)sessionParams);
    }

    public static String resolveInstallVolume(Context context, PackageInstaller.SessionParams sessionParams, TestableInterface testableInterface) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("resolveInstallVolume", $$robo$$com_android_internal_content_PackageHelper$resolveInstallVolume(android.content.Context android.content.pm.PackageInstaller$SessionParams com.android.internal.content.PackageHelper$TestableInterface ), 0, (Context)context, (PackageInstaller.SessionParams)sessionParams, (TestableInterface)testableInterface);
    }

    public static boolean fitsOnInternal(Context context, PackageInstaller.SessionParams sessionParams) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fitsOnInternal", $$robo$$com_android_internal_content_PackageHelper$fitsOnInternal(android.content.Context android.content.pm.PackageInstaller$SessionParams ), 0, (Context)context, (PackageInstaller.SessionParams)sessionParams);
    }

    public static boolean fitsOnExternal(Context context, PackageInstaller.SessionParams sessionParams) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fitsOnExternal", $$robo$$com_android_internal_content_PackageHelper$fitsOnExternal(android.content.Context android.content.pm.PackageInstaller$SessionParams ), 0, (Context)context, (PackageInstaller.SessionParams)sessionParams);
    }

    @Deprecated
    public static int resolveInstallLocation(Context context, String string2, int n, long l, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveInstallLocation", $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(android.content.Context java.lang.String int long int ), 0, (Context)context, (String)string2, (int)n, (long)l, (int)n2);
    }

    public static int resolveInstallLocation(Context context, PackageInstaller.SessionParams sessionParams) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveInstallLocation", $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(android.content.Context android.content.pm.PackageInstaller$SessionParams ), 0, (Context)context, (PackageInstaller.SessionParams)sessionParams);
    }

    @Deprecated
    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, boolean bl, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite boolean java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (boolean)bl, (String)string2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (String)string2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, String string2, FileDescriptor fileDescriptor) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite java.lang.String java.io.FileDescriptor ), 0, (PackageParser.PackageLite)packageLite, (String)string2, (FileDescriptor)fileDescriptor);
    }

    @Deprecated
    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, boolean bl, NativeLibraryHelper.Handle handle, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite boolean com.android.internal.content.NativeLibraryHelper$Handle java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (boolean)bl, (NativeLibraryHelper.Handle)handle, (String)string2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, NativeLibraryHelper.Handle handle, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite com.android.internal.content.NativeLibraryHelper$Handle java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (NativeLibraryHelper.Handle)handle, (String)string2);
    }

    public static String replaceEnd(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("replaceEnd", $$robo$$com_android_internal_content_PackageHelper$replaceEnd(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static int translateAllocateFlags(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("translateAllocateFlags", $$robo$$com_android_internal_content_PackageHelper$translateAllocateFlags(int ), 0, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(PackageHelper.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class TestableInterface
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_content_PackageHelper_TestableInterface$__constructor__() {
        }

        public abstract StorageManager getStorageManager(Context var1);

        public abstract boolean getForceAllowOnExternalSetting(Context var1);

        public abstract boolean getAllow3rdPartyOnInternalConfig(Context var1);

        public abstract ApplicationInfo getExistingAppInfo(Context var1, String var2);

        public abstract File getDataDirectory();

        private void __constructor__() {
            this.$$robo$$com_android_internal_content_PackageHelper_TestableInterface$__constructor__();
        }

        public TestableInterface() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_PackageHelper_TestableInterface$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TestableInterface)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

