/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.util.TimingLogger;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.ColorCutQuantizer;
import com.android.internal.graphics.palette.Quantizer;
import com.android.internal.graphics.palette.Target;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Palette
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int DEFAULT_RESIZE_BITMAP_AREA = 12544;
    static int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    static float MIN_CONTRAST_TITLE_TEXT = 3.0f;
    static float MIN_CONTRAST_BODY_TEXT = 4.5f;
    static String LOG_TAG = "Palette";
    static boolean LOG_TIMINGS = false;
    private List<Swatch> mSwatches;
    private List<Target> mTargets;
    private Map<Target, Swatch> mSelectedSwatches;
    private SparseBooleanArray mUsedColors;
    private Swatch mDominantSwatch;
    static Filter DEFAULT_FILTER;

    private static final Builder $$robo$$com_android_internal_graphics_palette_Palette$from(Bitmap bitmap) {
        return new Builder(bitmap);
    }

    private static final Palette $$robo$$com_android_internal_graphics_palette_Palette$from(List<Swatch> swatches) {
        return new Builder(swatches).generate();
    }

    @Deprecated
    private static final Palette $$robo$$com_android_internal_graphics_palette_Palette$generate(Bitmap bitmap) {
        return Palette.from(bitmap).generate();
    }

    @Deprecated
    private static final Palette $$robo$$com_android_internal_graphics_palette_Palette$generate(Bitmap bitmap, int numColors) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate();
    }

    @Deprecated
    private static final AsyncTask<Bitmap, Void, Palette> $$robo$$com_android_internal_graphics_palette_Palette$generateAsync(Bitmap bitmap, PaletteAsyncListener listener) {
        return Palette.from(bitmap).generate(listener);
    }

    @Deprecated
    private static final AsyncTask<Bitmap, Void, Palette> $$robo$$com_android_internal_graphics_palette_Palette$generateAsync(Bitmap bitmap, int numColors, PaletteAsyncListener listener) {
        return Palette.from(bitmap).maximumColorCount(numColors).generate(listener);
    }

    private void $$robo$$com_android_internal_graphics_palette_Palette$__constructor__(List<Swatch> swatches, List<Target> targets) {
        this.mSwatches = swatches;
        this.mTargets = targets;
        this.mUsedColors = new SparseBooleanArray();
        this.mSelectedSwatches = new ArrayMap<Target, Swatch>();
        this.mDominantSwatch = this.findDominantSwatch();
    }

    private final List<Swatch> $$robo$$com_android_internal_graphics_palette_Palette$getSwatches() {
        return Collections.unmodifiableList(this.mSwatches);
    }

    private final List<Target> $$robo$$com_android_internal_graphics_palette_Palette$getTargets() {
        return Collections.unmodifiableList(this.mTargets);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getVibrantSwatch() {
        return this.getSwatchForTarget(Target.VIBRANT);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getLightVibrantSwatch() {
        return this.getSwatchForTarget(Target.LIGHT_VIBRANT);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getDarkVibrantSwatch() {
        return this.getSwatchForTarget(Target.DARK_VIBRANT);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getMutedSwatch() {
        return this.getSwatchForTarget(Target.MUTED);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getLightMutedSwatch() {
        return this.getSwatchForTarget(Target.LIGHT_MUTED);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getDarkMutedSwatch() {
        return this.getSwatchForTarget(Target.DARK_MUTED);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.VIBRANT, defaultColor);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getLightVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.LIGHT_VIBRANT, defaultColor);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getDarkVibrantColor(int defaultColor) {
        return this.getColorForTarget(Target.DARK_VIBRANT, defaultColor);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.MUTED, defaultColor);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getLightMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.LIGHT_MUTED, defaultColor);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getDarkMutedColor(int defaultColor) {
        return this.getColorForTarget(Target.DARK_MUTED, defaultColor);
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getSwatchForTarget(Target target) {
        return this.mSelectedSwatches.get(target);
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getColorForTarget(Target target, int defaultColor) {
        Swatch swatch = this.getSwatchForTarget(target);
        return swatch != null ? swatch.getRgb() : defaultColor;
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getDominantSwatch() {
        return this.mDominantSwatch;
    }

    private final int $$robo$$com_android_internal_graphics_palette_Palette$getDominantColor(int defaultColor) {
        return this.mDominantSwatch != null ? this.mDominantSwatch.getRgb() : defaultColor;
    }

    private final void $$robo$$com_android_internal_graphics_palette_Palette$generate() {
        int count = this.mTargets.size();
        for (int i = 0; i < count; ++i) {
            Target target = this.mTargets.get(i);
            target.normalizeWeights();
            this.mSelectedSwatches.put(target, this.generateScoredTarget(target));
        }
        this.mUsedColors.clear();
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$generateScoredTarget(Target target) {
        Swatch maxScoreSwatch = this.getMaxScoredSwatchForTarget(target);
        if (maxScoreSwatch != null && target.isExclusive()) {
            this.mUsedColors.append(maxScoreSwatch.getRgb(), true);
        }
        return maxScoreSwatch;
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$getMaxScoredSwatchForTarget(Target target) {
        float maxScore = 0.0f;
        Swatch maxScoreSwatch = null;
        int count = this.mSwatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.mSwatches.get(i);
            if (!this.shouldBeScoredForTarget(swatch, target)) continue;
            float score = this.generateScore(swatch, target);
            if (maxScoreSwatch != null && !(score > maxScore)) continue;
            maxScoreSwatch = swatch;
            maxScore = score;
        }
        return maxScoreSwatch;
    }

    private final boolean $$robo$$com_android_internal_graphics_palette_Palette$shouldBeScoredForTarget(Swatch swatch, Target target) {
        float[] hsl = swatch.getHsl();
        return hsl[1] >= target.getMinimumSaturation() && hsl[1] <= target.getMaximumSaturation() && hsl[2] >= target.getMinimumLightness() && hsl[2] <= target.getMaximumLightness() && !this.mUsedColors.get(swatch.getRgb());
    }

    private final float $$robo$$com_android_internal_graphics_palette_Palette$generateScore(Swatch swatch, Target target) {
        int maxPopulation;
        float[] hsl = swatch.getHsl();
        float saturationScore = 0.0f;
        float luminanceScore = 0.0f;
        float populationScore = 0.0f;
        int n = maxPopulation = this.mDominantSwatch != null ? this.mDominantSwatch.getPopulation() : 1;
        if (target.getSaturationWeight() > 0.0f) {
            saturationScore = target.getSaturationWeight() * (1.0f - Math.abs(hsl[1] - target.getTargetSaturation()));
        }
        if (target.getLightnessWeight() > 0.0f) {
            luminanceScore = target.getLightnessWeight() * (1.0f - Math.abs(hsl[2] - target.getTargetLightness()));
        }
        if (target.getPopulationWeight() > 0.0f) {
            populationScore = target.getPopulationWeight() * ((float)swatch.getPopulation() / (float)maxPopulation);
        }
        return saturationScore + luminanceScore + populationScore;
    }

    private final Swatch $$robo$$com_android_internal_graphics_palette_Palette$findDominantSwatch() {
        int maxPop = Integer.MIN_VALUE;
        Swatch maxSwatch = null;
        int count = this.mSwatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.mSwatches.get(i);
            if (swatch.getPopulation() <= maxPop) continue;
            maxSwatch = swatch;
            maxPop = swatch.getPopulation();
        }
        return maxSwatch;
    }

    private static final float[] $$robo$$com_android_internal_graphics_palette_Palette$copyHslValues(Swatch color2) {
        float[] newHsl = new float[3];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)color2.getHsl(), (int)0, (Object)newHsl, (int)0, (int)3);
        return newHsl;
    }

    static void __staticInitializer__() {
        DEFAULT_FILTER = new Filter(){
            public transient /* synthetic */ Object __robo_data__;
            private static float BLACK_MAX_LIGHTNESS = 0.05f;
            private static float WHITE_MIN_LIGHTNESS = 0.95f;

            private void $$robo$$com_android_internal_graphics_palette_Palette_1$__constructor__() {
            }

            private final boolean $$robo$$com_android_internal_graphics_palette_Palette_1$isAllowed(int rgb, float[] hsl) {
                return !this.isWhite(hsl) && !this.isBlack(hsl) && !this.isNearRedILine(hsl);
            }

            private final boolean $$robo$$com_android_internal_graphics_palette_Palette_1$isBlack(float[] hslColor) {
                return hslColor[2] <= 0.05f;
            }

            private final boolean $$robo$$com_android_internal_graphics_palette_Palette_1$isWhite(float[] hslColor) {
                return hslColor[2] >= 0.95f;
            }

            private final boolean $$robo$$com_android_internal_graphics_palette_Palette_1$isNearRedILine(float[] hslColor) {
                return hslColor[0] >= 10.0f && hslColor[0] <= 37.0f && hslColor[1] <= 0.82f;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_graphics_palette_Palette_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_1$__constructor__(), 0, this);
            }

            @Override
            public boolean isAllowed(int n, float[] fArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isAllowed", $$robo$$com_android_internal_graphics_palette_Palette_1$isAllowed(int float[] ), 0, this, n, fArray);
            }

            private boolean isBlack(float[] fArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isBlack", $$robo$$com_android_internal_graphics_palette_Palette_1$isBlack(float[] ), 0, this, fArray);
            }

            private boolean isWhite(float[] fArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isWhite", $$robo$$com_android_internal_graphics_palette_Palette_1$isWhite(float[] ), 0, this, fArray);
            }

            private boolean isNearRedILine(float[] fArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("isNearRedILine", $$robo$$com_android_internal_graphics_palette_Palette_1$isNearRedILine(float[] ), 0, this, fArray);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static Builder from(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$com_android_internal_graphics_palette_Palette$from(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    public static Palette from(List<Swatch> list) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$com_android_internal_graphics_palette_Palette$from(java.util.List<com.android.internal.graphics.palette.Palette$Swatch> ), 0, list);
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("generate", $$robo$$com_android_internal_graphics_palette_Palette$generate(android.graphics.Bitmap ), 0, (Bitmap)bitmap);
    }

    @Deprecated
    public static Palette generate(Bitmap bitmap, int n) {
        return InvokeDynamicSupport.bootstrapStatic("generate", $$robo$$com_android_internal_graphics_palette_Palette$generate(android.graphics.Bitmap int ), 0, (Bitmap)bitmap, (int)n);
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, PaletteAsyncListener paletteAsyncListener) {
        return InvokeDynamicSupport.bootstrapStatic("generateAsync", $$robo$$com_android_internal_graphics_palette_Palette$generateAsync(android.graphics.Bitmap com.android.internal.graphics.palette.Palette$PaletteAsyncListener ), 0, (Bitmap)bitmap, (PaletteAsyncListener)paletteAsyncListener);
    }

    @Deprecated
    public static AsyncTask<Bitmap, Void, Palette> generateAsync(Bitmap bitmap, int n, PaletteAsyncListener paletteAsyncListener) {
        return InvokeDynamicSupport.bootstrapStatic("generateAsync", $$robo$$com_android_internal_graphics_palette_Palette$generateAsync(android.graphics.Bitmap int com.android.internal.graphics.palette.Palette$PaletteAsyncListener ), 0, (Bitmap)bitmap, (int)n, (PaletteAsyncListener)paletteAsyncListener);
    }

    private void __constructor__(List<Swatch> list, List<Target> list2) {
        this.$$robo$$com_android_internal_graphics_palette_Palette$__constructor__(list, list2);
    }

    Palette(List<Swatch> list, List<Target> list2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette$__constructor__(java.util.List<com.android.internal.graphics.palette.Palette$Swatch> java.util.List<com.android.internal.graphics.palette.Target> ), 0, this, list, list2);
    }

    public List<Swatch> getSwatches() {
        return InvokeDynamicSupport.bootstrap("getSwatches", $$robo$$com_android_internal_graphics_palette_Palette$getSwatches(), 0, this);
    }

    public List<Target> getTargets() {
        return InvokeDynamicSupport.bootstrap("getTargets", $$robo$$com_android_internal_graphics_palette_Palette$getTargets(), 0, this);
    }

    public Swatch getVibrantSwatch() {
        return InvokeDynamicSupport.bootstrap("getVibrantSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getVibrantSwatch(), 0, this);
    }

    public Swatch getLightVibrantSwatch() {
        return InvokeDynamicSupport.bootstrap("getLightVibrantSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getLightVibrantSwatch(), 0, this);
    }

    public Swatch getDarkVibrantSwatch() {
        return InvokeDynamicSupport.bootstrap("getDarkVibrantSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getDarkVibrantSwatch(), 0, this);
    }

    public Swatch getMutedSwatch() {
        return InvokeDynamicSupport.bootstrap("getMutedSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getMutedSwatch(), 0, this);
    }

    public Swatch getLightMutedSwatch() {
        return InvokeDynamicSupport.bootstrap("getLightMutedSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getLightMutedSwatch(), 0, this);
    }

    public Swatch getDarkMutedSwatch() {
        return InvokeDynamicSupport.bootstrap("getDarkMutedSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getDarkMutedSwatch(), 0, this);
    }

    public int getVibrantColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVibrantColor", $$robo$$com_android_internal_graphics_palette_Palette$getVibrantColor(int ), 0, this, n);
    }

    public int getLightVibrantColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLightVibrantColor", $$robo$$com_android_internal_graphics_palette_Palette$getLightVibrantColor(int ), 0, this, n);
    }

    public int getDarkVibrantColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDarkVibrantColor", $$robo$$com_android_internal_graphics_palette_Palette$getDarkVibrantColor(int ), 0, this, n);
    }

    public int getMutedColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMutedColor", $$robo$$com_android_internal_graphics_palette_Palette$getMutedColor(int ), 0, this, n);
    }

    public int getLightMutedColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLightMutedColor", $$robo$$com_android_internal_graphics_palette_Palette$getLightMutedColor(int ), 0, this, n);
    }

    public int getDarkMutedColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDarkMutedColor", $$robo$$com_android_internal_graphics_palette_Palette$getDarkMutedColor(int ), 0, this, n);
    }

    public Swatch getSwatchForTarget(Target target) {
        return InvokeDynamicSupport.bootstrap("getSwatchForTarget", $$robo$$com_android_internal_graphics_palette_Palette$getSwatchForTarget(com.android.internal.graphics.palette.Target ), 0, this, target);
    }

    public int getColorForTarget(Target target, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getColorForTarget", $$robo$$com_android_internal_graphics_palette_Palette$getColorForTarget(com.android.internal.graphics.palette.Target int ), 0, this, target, n);
    }

    public Swatch getDominantSwatch() {
        return InvokeDynamicSupport.bootstrap("getDominantSwatch", $$robo$$com_android_internal_graphics_palette_Palette$getDominantSwatch(), 0, this);
    }

    public int getDominantColor(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDominantColor", $$robo$$com_android_internal_graphics_palette_Palette$getDominantColor(int ), 0, this, n);
    }

    void generate() {
        InvokeDynamicSupport.bootstrap("generate", $$robo$$com_android_internal_graphics_palette_Palette$generate(), 0, this);
    }

    private Swatch generateScoredTarget(Target target) {
        return InvokeDynamicSupport.bootstrap("generateScoredTarget", $$robo$$com_android_internal_graphics_palette_Palette$generateScoredTarget(com.android.internal.graphics.palette.Target ), 0, this, target);
    }

    private Swatch getMaxScoredSwatchForTarget(Target target) {
        return InvokeDynamicSupport.bootstrap("getMaxScoredSwatchForTarget", $$robo$$com_android_internal_graphics_palette_Palette$getMaxScoredSwatchForTarget(com.android.internal.graphics.palette.Target ), 0, this, target);
    }

    private boolean shouldBeScoredForTarget(Swatch swatch, Target target) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldBeScoredForTarget", $$robo$$com_android_internal_graphics_palette_Palette$shouldBeScoredForTarget(com.android.internal.graphics.palette.Palette$Swatch com.android.internal.graphics.palette.Target ), 0, this, swatch, target);
    }

    private float generateScore(Swatch swatch, Target target) {
        return (float)InvokeDynamicSupport.bootstrap("generateScore", $$robo$$com_android_internal_graphics_palette_Palette$generateScore(com.android.internal.graphics.palette.Palette$Swatch com.android.internal.graphics.palette.Target ), 0, this, swatch, target);
    }

    private Swatch findDominantSwatch() {
        return InvokeDynamicSupport.bootstrap("findDominantSwatch", $$robo$$com_android_internal_graphics_palette_Palette$findDominantSwatch(), 0, this);
    }

    private static float[] copyHslValues(Swatch swatch) {
        return InvokeDynamicSupport.bootstrapStatic("copyHslValues", $$robo$$com_android_internal_graphics_palette_Palette$copyHslValues(com.android.internal.graphics.palette.Palette$Swatch ), 0, (Swatch)swatch);
    }

    static {
        RobolectricInternals.classInitializing(Palette.class);
    }

    public /* synthetic */ Palette() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Palette)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Filter
    extends InstrumentedInterface {
        public boolean isAllowed(int var1, float[] var2);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<Swatch> mSwatches;
        private Bitmap mBitmap;
        private List<Target> mTargets;
        private int mMaxColors;
        private int mResizeArea;
        private int mResizeMaxDimension;
        private List<Filter> mFilters;
        private Rect mRegion;
        private Quantizer mQuantizer;

        private void $$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(Bitmap bitmap) {
            this.mTargets = new ArrayList<Target>();
            this.mMaxColors = 16;
            this.mResizeArea = 12544;
            this.mResizeMaxDimension = -1;
            this.mFilters = new ArrayList<Filter>();
            if (bitmap == null || bitmap.isRecycled()) {
                throw new IllegalArgumentException("Bitmap is not valid");
            }
            this.mFilters.add(DEFAULT_FILTER);
            this.mBitmap = bitmap;
            this.mSwatches = null;
            this.mTargets.add(Target.LIGHT_VIBRANT);
            this.mTargets.add(Target.VIBRANT);
            this.mTargets.add(Target.DARK_VIBRANT);
            this.mTargets.add(Target.LIGHT_MUTED);
            this.mTargets.add(Target.MUTED);
            this.mTargets.add(Target.DARK_MUTED);
        }

        private void $$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(List<Swatch> swatches) {
            this.mTargets = new ArrayList<Target>();
            this.mMaxColors = 16;
            this.mResizeArea = 12544;
            this.mResizeMaxDimension = -1;
            this.mFilters = new ArrayList<Filter>();
            if (swatches == null || swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.mFilters.add(DEFAULT_FILTER);
            this.mSwatches = swatches;
            this.mBitmap = null;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$maximumColorCount(int colors) {
            this.mMaxColors = colors;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$resizeBitmapSize(int maxDimension) {
            this.mResizeMaxDimension = maxDimension;
            this.mResizeArea = -1;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$resizeBitmapArea(int area) {
            this.mResizeArea = area;
            this.mResizeMaxDimension = -1;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearFilters() {
            this.mFilters.clear();
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$addFilter(Filter filter) {
            if (filter != null) {
                this.mFilters.add(filter);
            }
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$setQuantizer(Quantizer quantizer) {
            this.mQuantizer = quantizer;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$setRegion(int left, int top, int right, int bottom) {
            if (this.mBitmap != null) {
                if (this.mRegion == null) {
                    this.mRegion = new Rect();
                }
                this.mRegion.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                if (!this.mRegion.intersect(left, top, right, bottom)) {
                    throw new IllegalArgumentException("The given region must intersect with the Bitmap's dimensions.");
                }
            }
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearRegion() {
            this.mRegion = null;
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$addTarget(Target target) {
            if (!this.mTargets.contains(target)) {
                this.mTargets.add(target);
            }
            return this;
        }

        private final Builder $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearTargets() {
            if (this.mTargets != null) {
                this.mTargets.clear();
            }
            return this;
        }

        private final Palette $$robo$$com_android_internal_graphics_palette_Palette_Builder$generate() {
            List<Swatch> swatches;
            TimingLogger logger = null;
            if (this.mBitmap != null) {
                Bitmap bitmap = this.scaleBitmapDown(this.mBitmap);
                if (logger != null) {
                    logger.addSplit("Processed Bitmap");
                }
                Rect region = this.mRegion;
                if (bitmap != this.mBitmap && region != null) {
                    double scale = (double)bitmap.getWidth() / (double)this.mBitmap.getWidth();
                    region.left = (int)Math.floor((double)region.left * scale);
                    region.top = (int)Math.floor((double)region.top * scale);
                    region.right = Math.min((int)Math.ceil((double)region.right * scale), bitmap.getWidth());
                    region.bottom = Math.min((int)Math.ceil((double)region.bottom * scale), bitmap.getHeight());
                }
                if (this.mQuantizer == null) {
                    this.mQuantizer = new ColorCutQuantizer();
                }
                this.mQuantizer.quantize(this.getPixelsFromBitmap(bitmap), this.mMaxColors, this.mFilters.isEmpty() ? null : this.mFilters.toArray(new Filter[this.mFilters.size()]));
                if (bitmap != this.mBitmap) {
                    bitmap.recycle();
                }
                swatches = this.mQuantizer.getQuantizedColors();
                if (logger != null) {
                    logger.addSplit("Color quantization completed");
                }
            } else {
                swatches = this.mSwatches;
            }
            Palette p = new Palette(swatches, this.mTargets);
            p.generate();
            if (logger != null) {
                logger.addSplit("Created Palette");
                logger.dumpToLog();
            }
            return p;
        }

        private final AsyncTask<Bitmap, Void, Palette> $$robo$$com_android_internal_graphics_palette_Palette_Builder$generate(PaletteAsyncListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener can not be null");
            }
            return new AsyncTask<Bitmap, Void, Palette>(this, listener){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ PaletteAsyncListener val$listener;
                /* synthetic */ Builder this$0;

                private void $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$__constructor__(Builder this$0, PaletteAsyncListener paletteAsyncListener) {
                }

                private final Palette $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$doInBackground(Bitmap ... params) {
                    try {
                        return this.this$0.generate();
                    }
                    catch (Exception e) {
                        Log.e("Palette", "Exception thrown during async generate", e);
                        return null;
                    }
                }

                private final void $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$onPostExecute(Palette colorExtractor) {
                    this.val$listener.onGenerated(colorExtractor);
                }

                private void __constructor__(Builder builder, PaletteAsyncListener paletteAsyncListener) {
                    this.$$robo$$com_android_internal_graphics_palette_Palette_Builder_1$__constructor__(builder, paletteAsyncListener);
                }
                {
                    this.this$0 = builder;
                    this.val$listener = paletteAsyncListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$__constructor__(com.android.internal.graphics.palette.Palette$Builder com.android.internal.graphics.palette.Palette$PaletteAsyncListener ), 0, this, builder, paletteAsyncListener);
                }

                protected Palette doInBackground(Bitmap ... bitmapArray) {
                    return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$doInBackground(android.graphics.Bitmap[] ), 0, this, bitmapArray);
                }

                @Override
                protected void onPostExecute(Palette palette) {
                    InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_graphics_palette_Palette_Builder_1$onPostExecute(com.android.internal.graphics.palette.Palette ), 0, this, palette);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, this.mBitmap);
        }

        private final int[] $$robo$$com_android_internal_graphics_palette_Palette_Builder$getPixelsFromBitmap(Bitmap bitmap) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            int[] pixels = new int[bitmapWidth * bitmapHeight];
            bitmap.getPixels(pixels, 0, bitmapWidth, 0, 0, bitmapWidth, bitmapHeight);
            if (this.mRegion == null) {
                return pixels;
            }
            int regionWidth = this.mRegion.width();
            int regionHeight = this.mRegion.height();
            int[] subsetPixels = new int[regionWidth * regionHeight];
            for (int row = 0; row < regionHeight; ++row) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)pixels, (int)((row + this.mRegion.top) * bitmapWidth + this.mRegion.left), (Object)subsetPixels, (int)(row * regionWidth), (int)regionWidth);
            }
            return subsetPixels;
        }

        private final Bitmap $$robo$$com_android_internal_graphics_palette_Palette_Builder$scaleBitmapDown(Bitmap bitmap) {
            int maxDimension;
            double scaleRatio = -1.0;
            if (this.mResizeArea > 0) {
                int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
                if (bitmapArea > this.mResizeArea) {
                    scaleRatio = Math.sqrt((double)this.mResizeArea / (double)bitmapArea);
                }
            } else if (this.mResizeMaxDimension > 0 && (maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight())) > this.mResizeMaxDimension) {
                scaleRatio = (double)this.mResizeMaxDimension / (double)maxDimension;
            }
            if (scaleRatio <= 0.0) {
                return bitmap;
            }
            return Bitmap.createScaledBitmap(bitmap, (int)Math.ceil((double)bitmap.getWidth() * scaleRatio), (int)Math.ceil((double)bitmap.getHeight() * scaleRatio), false);
        }

        private void __constructor__(Bitmap bitmap) {
            this.$$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(bitmap);
        }

        public Builder(Bitmap bitmap) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(android.graphics.Bitmap ), 0, this, bitmap);
        }

        private void __constructor__(List<Swatch> list) {
            this.$$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(list);
        }

        public Builder(List<Swatch> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Builder$__constructor__(java.util.List<com.android.internal.graphics.palette.Palette$Swatch> ), 0, this, list);
        }

        public Builder maximumColorCount(int n) {
            return InvokeDynamicSupport.bootstrap("maximumColorCount", $$robo$$com_android_internal_graphics_palette_Palette_Builder$maximumColorCount(int ), 0, this, n);
        }

        @Deprecated
        public Builder resizeBitmapSize(int n) {
            return InvokeDynamicSupport.bootstrap("resizeBitmapSize", $$robo$$com_android_internal_graphics_palette_Palette_Builder$resizeBitmapSize(int ), 0, this, n);
        }

        public Builder resizeBitmapArea(int n) {
            return InvokeDynamicSupport.bootstrap("resizeBitmapArea", $$robo$$com_android_internal_graphics_palette_Palette_Builder$resizeBitmapArea(int ), 0, this, n);
        }

        public Builder clearFilters() {
            return InvokeDynamicSupport.bootstrap("clearFilters", $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearFilters(), 0, this);
        }

        public Builder addFilter(Filter filter) {
            return InvokeDynamicSupport.bootstrap("addFilter", $$robo$$com_android_internal_graphics_palette_Palette_Builder$addFilter(com.android.internal.graphics.palette.Palette$Filter ), 0, this, filter);
        }

        public Builder setQuantizer(Quantizer quantizer) {
            return InvokeDynamicSupport.bootstrap("setQuantizer", $$robo$$com_android_internal_graphics_palette_Palette_Builder$setQuantizer(com.android.internal.graphics.palette.Quantizer ), 0, this, quantizer);
        }

        public Builder setRegion(int n, int n2, int n3, int n4) {
            return InvokeDynamicSupport.bootstrap("setRegion", $$robo$$com_android_internal_graphics_palette_Palette_Builder$setRegion(int int int int ), 0, this, n, n2, n3, n4);
        }

        public Builder clearRegion() {
            return InvokeDynamicSupport.bootstrap("clearRegion", $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearRegion(), 0, this);
        }

        public Builder addTarget(Target target) {
            return InvokeDynamicSupport.bootstrap("addTarget", $$robo$$com_android_internal_graphics_palette_Palette_Builder$addTarget(com.android.internal.graphics.palette.Target ), 0, this, target);
        }

        public Builder clearTargets() {
            return InvokeDynamicSupport.bootstrap("clearTargets", $$robo$$com_android_internal_graphics_palette_Palette_Builder$clearTargets(), 0, this);
        }

        public Palette generate() {
            return InvokeDynamicSupport.bootstrap("generate", $$robo$$com_android_internal_graphics_palette_Palette_Builder$generate(), 0, this);
        }

        public AsyncTask<Bitmap, Void, Palette> generate(PaletteAsyncListener paletteAsyncListener) {
            return InvokeDynamicSupport.bootstrap("generate", $$robo$$com_android_internal_graphics_palette_Palette_Builder$generate(com.android.internal.graphics.palette.Palette$PaletteAsyncListener ), 0, this, paletteAsyncListener);
        }

        private int[] getPixelsFromBitmap(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("getPixelsFromBitmap", $$robo$$com_android_internal_graphics_palette_Palette_Builder$getPixelsFromBitmap(android.graphics.Bitmap ), 0, this, bitmap);
        }

        private Bitmap scaleBitmapDown(Bitmap bitmap) {
            return InvokeDynamicSupport.bootstrap("scaleBitmapDown", $$robo$$com_android_internal_graphics_palette_Palette_Builder$scaleBitmapDown(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Swatch
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mRed;
        private int mGreen;
        private int mBlue;
        private int mRgb;
        private int mPopulation;
        private boolean mGeneratedTextColors;
        private int mTitleTextColor;
        private int mBodyTextColor;
        private float[] mHsl;

        private void $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(int color2, int population) {
            this.mRed = Color.red(color2);
            this.mGreen = Color.green(color2);
            this.mBlue = Color.blue(color2);
            this.mRgb = color2;
            this.mPopulation = population;
        }

        private void $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(int red, int green, int blue, int population) {
            this.mRed = red;
            this.mGreen = green;
            this.mBlue = blue;
            this.mRgb = Color.rgb(red, green, blue);
            this.mPopulation = population;
        }

        private void $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(float[] hsl, int population) {
            this.mHsl = hsl;
        }

        private final int $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getRgb() {
            return this.mRgb;
        }

        private final float[] $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getHsl() {
            if (this.mHsl == null) {
                this.mHsl = new float[3];
            }
            ColorUtils.RGBToHSL(this.mRed, this.mGreen, this.mBlue, this.mHsl);
            return this.mHsl;
        }

        private final int $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getPopulation() {
            return this.mPopulation;
        }

        private final int $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getTitleTextColor() {
            this.ensureTextColorsGenerated();
            return this.mTitleTextColor;
        }

        private final int $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getBodyTextColor() {
            this.ensureTextColorsGenerated();
            return this.mBodyTextColor;
        }

        private final void $$robo$$com_android_internal_graphics_palette_Palette_Swatch$ensureTextColorsGenerated() {
            if (!this.mGeneratedTextColors) {
                int lightBodyAlpha = ColorUtils.calculateMinimumAlpha(-1, this.mRgb, 4.5f);
                int lightTitleAlpha = ColorUtils.calculateMinimumAlpha(-1, this.mRgb, 3.0f);
                if (lightBodyAlpha != -1 && lightTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent(-1, lightBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent(-1, lightTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                int darkBodyAlpha = ColorUtils.calculateMinimumAlpha(-16777216, this.mRgb, 4.5f);
                int darkTitleAlpha = ColorUtils.calculateMinimumAlpha(-16777216, this.mRgb, 3.0f);
                if (darkBodyAlpha != -1 && darkTitleAlpha != -1) {
                    this.mBodyTextColor = ColorUtils.setAlphaComponent(-16777216, darkBodyAlpha);
                    this.mTitleTextColor = ColorUtils.setAlphaComponent(-16777216, darkTitleAlpha);
                    this.mGeneratedTextColors = true;
                    return;
                }
                this.mBodyTextColor = lightBodyAlpha != -1 ? ColorUtils.setAlphaComponent(-1, lightBodyAlpha) : ColorUtils.setAlphaComponent(-16777216, darkBodyAlpha);
                this.mTitleTextColor = lightTitleAlpha != -1 ? ColorUtils.setAlphaComponent(-1, lightTitleAlpha) : ColorUtils.setAlphaComponent(-16777216, darkTitleAlpha);
                this.mGeneratedTextColors = true;
            }
        }

        private final String $$robo$$com_android_internal_graphics_palette_Palette_Swatch$toString() {
            return this.getClass().getSimpleName() + " [RGB: #" + Integer.toHexString(this.getRgb()) + ']' + " [HSL: " + Arrays.toString(this.getHsl()) + ']' + " [Population: " + this.mPopulation + ']' + " [Title Text: #" + Integer.toHexString(this.getTitleTextColor()) + ']' + " [Body Text: #" + Integer.toHexString(this.getBodyTextColor()) + ']';
        }

        private final boolean $$robo$$com_android_internal_graphics_palette_Palette_Swatch$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Swatch swatch = (Swatch)o;
            return this.mPopulation == swatch.mPopulation && this.mRgb == swatch.mRgb;
        }

        private final int $$robo$$com_android_internal_graphics_palette_Palette_Swatch$hashCode() {
            return 31 * this.mRgb + this.mPopulation;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(n, n2);
        }

        public Swatch(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(n, n2, n3, n4);
        }

        Swatch(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        private void __constructor__(float[] fArray, int n) {
            this.$$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(fArray, n);
        }

        Swatch(float[] fArray, int n) {
            this(ColorUtils.HSLToColor(fArray), n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$__constructor__(float[] int ), 0, this, fArray, n);
        }

        public int getRgb() {
            return (int)InvokeDynamicSupport.bootstrap("getRgb", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getRgb(), 0, this);
        }

        public float[] getHsl() {
            return InvokeDynamicSupport.bootstrap("getHsl", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getHsl(), 0, this);
        }

        public int getPopulation() {
            return (int)InvokeDynamicSupport.bootstrap("getPopulation", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getPopulation(), 0, this);
        }

        public int getTitleTextColor() {
            return (int)InvokeDynamicSupport.bootstrap("getTitleTextColor", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getTitleTextColor(), 0, this);
        }

        public int getBodyTextColor() {
            return (int)InvokeDynamicSupport.bootstrap("getBodyTextColor", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$getBodyTextColor(), 0, this);
        }

        private void ensureTextColorsGenerated() {
            InvokeDynamicSupport.bootstrap("ensureTextColorsGenerated", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$ensureTextColorsGenerated(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$toString(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_graphics_palette_Palette_Swatch$hashCode(), 0, this);
        }

        public /* synthetic */ Swatch() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Swatch)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PaletteAsyncListener
    extends InstrumentedInterface {
        public void onGenerated(Palette var1);
    }
}

