/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.ml.clustering;

import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KMeans
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "KMeans";
    private Random mRandomState;
    private int mMaxIterations;
    private float mSqConvergenceEpsilon;

    private void $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__() {
    }

    private void $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(Random random) {
    }

    private void $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(Random random, int maxIterations, float convergenceEpsilon) {
        this.mRandomState = random;
        this.mMaxIterations = maxIterations;
        this.mSqConvergenceEpsilon = convergenceEpsilon * convergenceEpsilon;
    }

    private final List<Mean> $$robo$$com_android_internal_ml_clustering_KMeans$predict(int k, float[][] inputData) {
        this.checkDataSetSanity(inputData);
        int dimension = inputData[0].length;
        ArrayList<Mean> means = new ArrayList<Mean>();
        for (int i = 0; i < k; ++i) {
            Mean m = new Mean(dimension);
            for (int j = 0; j < dimension; ++j) {
                m.mCentroid[j] = this.mRandomState.nextFloat();
            }
            means.add(m);
        }
        boolean converged = false;
        for (int i = 0; i < this.mMaxIterations && !(converged = this.step(means, inputData)); ++i) {
        }
        if (!converged) {
            // empty if block
        }
        return means;
    }

    private static final double $$robo$$com_android_internal_ml_clustering_KMeans$score(List<Mean> means) {
        double score = 0.0;
        int meansSize = means.size();
        for (int i = 0; i < meansSize; ++i) {
            Mean mean = means.get(i);
            for (int j = 0; j < meansSize; ++j) {
                Mean compareTo = means.get(j);
                if (mean == compareTo) continue;
                double distance = Math.sqrt(KMeans.sqDistance(mean.mCentroid, compareTo.mCentroid));
                score += distance;
            }
        }
        return score;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_ml_clustering_KMeans$checkDataSetSanity(float[][] inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException("Data set is null.");
        }
        if (inputData.length == 0) {
            throw new IllegalArgumentException("Data set is empty.");
        }
        if (inputData[0] == null) {
            throw new IllegalArgumentException("Bad data set format.");
        }
        int dimension = inputData[0].length;
        int length = inputData.length;
        for (int i = 1; i < length; ++i) {
            if (inputData[i] != null && inputData[i].length == dimension) continue;
            throw new IllegalArgumentException("Bad data set format.");
        }
    }

    private final boolean $$robo$$com_android_internal_ml_clustering_KMeans$step(ArrayList<Mean> means, float[][] inputData) {
        int i;
        for (i = means.size() - 1; i >= 0; --i) {
            Mean mean = means.get(i);
            mean.mClosestItems.clear();
        }
        for (i = inputData.length - 1; i >= 0; --i) {
            float[] current = inputData[i];
            Mean nearest = KMeans.nearestMean(current, means);
            nearest.mClosestItems.add(current);
        }
        boolean converged = true;
        for (int i2 = means.size() - 1; i2 >= 0; --i2) {
            int j;
            Mean mean = means.get(i2);
            if (mean.mClosestItems.size() == 0) continue;
            float[] oldCentroid = mean.mCentroid;
            mean.mCentroid = new float[oldCentroid.length];
            for (j = 0; j < mean.mClosestItems.size(); ++j) {
                for (int p = 0; p < mean.mCentroid.length; ++p) {
                    int n = p;
                    mean.mCentroid[n] = mean.mCentroid[n] + mean.mClosestItems.get(j)[p];
                }
            }
            j = 0;
            while (j < mean.mCentroid.length) {
                int n = j++;
                mean.mCentroid[n] = mean.mCentroid[n] / (float)mean.mClosestItems.size();
            }
            if (!(KMeans.sqDistance(oldCentroid, mean.mCentroid) > this.mSqConvergenceEpsilon)) continue;
            converged = false;
        }
        return converged;
    }

    @VisibleForTesting
    private static final Mean $$robo$$com_android_internal_ml_clustering_KMeans$nearestMean(float[] point, List<Mean> means) {
        Mean nearest = null;
        float nearestDistance = Float.MAX_VALUE;
        int meanCount = means.size();
        for (int i = 0; i < meanCount; ++i) {
            Mean next = means.get(i);
            float nextDistance = KMeans.sqDistance(point, next.mCentroid);
            if (!(nextDistance < nearestDistance)) continue;
            nearest = next;
            nearestDistance = nextDistance;
        }
        return nearest;
    }

    @VisibleForTesting
    private static final float $$robo$$com_android_internal_ml_clustering_KMeans$sqDistance(float[] a, float[] b) {
        float dist = 0.0f;
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            dist += (a[i] - b[i]) * (a[i] - b[i]);
        }
        return dist;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_ml_clustering_KMeans$__constructor__();
    }

    public KMeans() {
        this(new Random());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(), 0, this);
    }

    private void __constructor__(Random random) {
        this.$$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(random);
    }

    public KMeans(Random random) {
        this(random, 30, 0.005f);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(java.util.Random ), 0, this, random);
    }

    private void __constructor__(Random random, int n, float f) {
        this.$$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(random, n, f);
    }

    public KMeans(Random random, int n, float f) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_ml_clustering_KMeans$__constructor__(java.util.Random int float ), 0, this, random, n, f);
    }

    public List<Mean> predict(int n, float[][] fArray) {
        return InvokeDynamicSupport.bootstrap("predict", $$robo$$com_android_internal_ml_clustering_KMeans$predict(int float[][] ), 0, this, n, fArray);
    }

    public static double score(List<Mean> list) {
        return (double)InvokeDynamicSupport.bootstrapStatic("score", $$robo$$com_android_internal_ml_clustering_KMeans$score(java.util.List<com.android.internal.ml.clustering.KMeans$Mean> ), 0, list);
    }

    public void checkDataSetSanity(float[][] fArray) {
        InvokeDynamicSupport.bootstrap("checkDataSetSanity", $$robo$$com_android_internal_ml_clustering_KMeans$checkDataSetSanity(float[][] ), 0, this, fArray);
    }

    private boolean step(ArrayList<Mean> arrayList, float[][] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("step", $$robo$$com_android_internal_ml_clustering_KMeans$step(java.util.ArrayList<com.android.internal.ml.clustering.KMeans$Mean> float[][] ), 0, this, arrayList, fArray);
    }

    public static Mean nearestMean(float[] fArray, List<Mean> list) {
        return InvokeDynamicSupport.bootstrapStatic("nearestMean", $$robo$$com_android_internal_ml_clustering_KMeans$nearestMean(float[] java.util.List<com.android.internal.ml.clustering.KMeans$Mean> ), 0, (float[])fArray, list);
    }

    public static float sqDistance(float[] fArray, float[] fArray2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("sqDistance", $$robo$$com_android_internal_ml_clustering_KMeans$sqDistance(float[] float[] ), 0, (float[])fArray, (float[])fArray2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KMeans)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Mean
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float[] mCentroid;
        ArrayList<float[]> mClosestItems;

        private void $$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(int dimension) {
            this.mClosestItems = new ArrayList();
            this.mCentroid = new float[dimension];
        }

        private void $$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(float ... centroid) {
            this.mClosestItems = new ArrayList();
            this.mCentroid = centroid;
        }

        private final float[] $$robo$$com_android_internal_ml_clustering_KMeans_Mean$getCentroid() {
            return this.mCentroid;
        }

        private final List<float[]> $$robo$$com_android_internal_ml_clustering_KMeans_Mean$getItems() {
            return this.mClosestItems;
        }

        private final String $$robo$$com_android_internal_ml_clustering_KMeans_Mean$toString() {
            return "Mean(centroid: " + Arrays.toString(this.mCentroid) + ", size: " + this.mClosestItems.size() + ")";
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(n);
        }

        public Mean(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(float ... fArray) {
            this.$$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(fArray);
        }

        public Mean(float ... fArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_ml_clustering_KMeans_Mean$__constructor__(float[] ), 0, this, fArray);
        }

        public float[] getCentroid() {
            return InvokeDynamicSupport.bootstrap("getCentroid", $$robo$$com_android_internal_ml_clustering_KMeans_Mean$getCentroid(), 0, this);
        }

        public List<float[]> getItems() {
            return InvokeDynamicSupport.bootstrap("getItems", $$robo$$com_android_internal_ml_clustering_KMeans_Mean$getItems(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_ml_clustering_KMeans_Mean$toString(), 0, this);
        }

        public /* synthetic */ Mean() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mean)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

