/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VpnConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.net.VpnService";
    public static String DIALOGS_PACKAGE = "com.android.vpndialogs";
    public static String LEGACY_VPN = "[Legacy VPN]";
    public String user;
    public String interfaze;
    public String session;
    public int mtu;
    public List<LinkAddress> addresses;
    public List<RouteInfo> routes;
    public List<String> dnsServers;
    public List<String> searchDomains;
    public List<String> allowedApplications;
    public List<String> disallowedApplications;
    public PendingIntent configureIntent;
    public long startTime;
    public boolean legacy;
    public boolean blocking;
    public boolean allowBypass;
    public boolean allowIPv4;
    public boolean allowIPv6;
    public Network[] underlyingNetworks;
    public static Parcelable.Creator<VpnConfig> CREATOR;

    private void $$robo$$com_android_internal_net_VpnConfig$__constructor__() {
        this.mtu = -1;
        this.addresses = new ArrayList<LinkAddress>();
        this.routes = new ArrayList<RouteInfo>();
        this.startTime = -1L;
    }

    private static final Intent $$robo$$com_android_internal_net_VpnConfig$getIntentForConfirmation() {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039646));
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        return intent;
    }

    private static final PendingIntent $$robo$$com_android_internal_net_VpnConfig$getIntentForStatusPanel(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.android.vpndialogs", "com.android.vpndialogs.ManageDialog");
        intent.addFlags(0x50800000);
        return PendingIntent.getActivityAsUser(context, 0, intent, 0, null, UserHandle.CURRENT);
    }

    private static final CharSequence $$robo$$com_android_internal_net_VpnConfig$getVpnLabel(Context context, String packageName) throws PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent("android.net.VpnService");
        intent.setPackage(packageName);
        List<ResolveInfo> services = pm.queryIntentServices(intent, 0);
        if (services != null && services.size() == 1) {
            return services.get(0).loadLabel(pm);
        }
        return pm.getApplicationInfo(packageName, 0).loadLabel(pm);
    }

    private final void $$robo$$com_android_internal_net_VpnConfig$updateAllowedFamilies(InetAddress address) {
        if (address instanceof Inet4Address) {
            this.allowIPv4 = true;
        } else {
            this.allowIPv6 = true;
        }
    }

    private final void $$robo$$com_android_internal_net_VpnConfig$addLegacyRoutes(String routesStr) {
        String[] routes;
        if (routesStr.trim().equals("")) {
            return;
        }
        for (String route : routes = routesStr.trim().split(" ")) {
            RouteInfo info = new RouteInfo(new IpPrefix(route), null);
            this.routes.add(info);
            this.updateAllowedFamilies(info.getDestination().getAddress());
        }
    }

    private final void $$robo$$com_android_internal_net_VpnConfig$addLegacyAddresses(String addressesStr) {
        String[] addresses;
        if (addressesStr.trim().equals("")) {
            return;
        }
        for (String address : addresses = addressesStr.trim().split(" ")) {
            LinkAddress addr = new LinkAddress(address);
            this.addresses.add(addr);
            this.updateAllowedFamilies(addr.getAddress());
        }
    }

    private final int $$robo$$com_android_internal_net_VpnConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_net_VpnConfig$writeToParcel(Parcel out, int flags) {
        out.writeString(this.user);
        out.writeString(this.interfaze);
        out.writeString(this.session);
        out.writeInt(this.mtu);
        out.writeTypedList(this.addresses);
        out.writeTypedList(this.routes);
        out.writeStringList(this.dnsServers);
        out.writeStringList(this.searchDomains);
        out.writeStringList(this.allowedApplications);
        out.writeStringList(this.disallowedApplications);
        out.writeParcelable(this.configureIntent, flags);
        out.writeLong(this.startTime);
        out.writeInt(this.legacy ? 1 : 0);
        out.writeInt(this.blocking ? 1 : 0);
        out.writeInt(this.allowBypass ? 1 : 0);
        out.writeInt(this.allowIPv4 ? 1 : 0);
        out.writeInt(this.allowIPv6 ? 1 : 0);
        out.writeTypedArray(this.underlyingNetworks, flags);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<VpnConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_net_VpnConfig_1$__constructor__() {
            }

            private final VpnConfig $$robo$$com_android_internal_net_VpnConfig_1$createFromParcel(Parcel in) {
                VpnConfig config = new VpnConfig();
                config.user = in.readString();
                config.interfaze = in.readString();
                config.session = in.readString();
                config.mtu = in.readInt();
                in.readTypedList(config.addresses, LinkAddress.CREATOR);
                in.readTypedList(config.routes, RouteInfo.CREATOR);
                config.dnsServers = in.createStringArrayList();
                config.searchDomains = in.createStringArrayList();
                config.allowedApplications = in.createStringArrayList();
                config.disallowedApplications = in.createStringArrayList();
                config.configureIntent = (PendingIntent)in.readParcelable(null);
                config.startTime = in.readLong();
                config.legacy = in.readInt() != 0;
                config.blocking = in.readInt() != 0;
                config.allowBypass = in.readInt() != 0;
                config.allowIPv4 = in.readInt() != 0;
                config.allowIPv6 = in.readInt() != 0;
                config.underlyingNetworks = in.createTypedArray(Network.CREATOR);
                return config;
            }

            private final VpnConfig[] $$robo$$com_android_internal_net_VpnConfig_1$newArray(int size) {
                return new VpnConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_net_VpnConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_net_VpnConfig_1$__constructor__(), 0, this);
            }

            @Override
            public VpnConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_net_VpnConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public VpnConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_net_VpnConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_net_VpnConfig$__constructor__();
    }

    public VpnConfig() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_net_VpnConfig$__constructor__(), 0, this);
    }

    public static Intent getIntentForConfirmation() {
        return InvokeDynamicSupport.bootstrapStatic("getIntentForConfirmation", $$robo$$com_android_internal_net_VpnConfig$getIntentForConfirmation(), 0);
    }

    public static PendingIntent getIntentForStatusPanel(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getIntentForStatusPanel", $$robo$$com_android_internal_net_VpnConfig$getIntentForStatusPanel(android.content.Context ), 0, (Context)context);
    }

    public static CharSequence getVpnLabel(Context context, String string2) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getVpnLabel", $$robo$$com_android_internal_net_VpnConfig$getVpnLabel(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public void updateAllowedFamilies(InetAddress inetAddress) {
        InvokeDynamicSupport.bootstrap("updateAllowedFamilies", $$robo$$com_android_internal_net_VpnConfig$updateAllowedFamilies(java.net.InetAddress ), 0, this, inetAddress);
    }

    public void addLegacyRoutes(String string2) {
        InvokeDynamicSupport.bootstrap("addLegacyRoutes", $$robo$$com_android_internal_net_VpnConfig$addLegacyRoutes(java.lang.String ), 0, this, string2);
    }

    public void addLegacyAddresses(String string2) {
        InvokeDynamicSupport.bootstrap("addLegacyAddresses", $$robo$$com_android_internal_net_VpnConfig$addLegacyAddresses(java.lang.String ), 0, this, string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_net_VpnConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_net_VpnConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(VpnConfig.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VpnConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

