/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ProxyFileDescriptorCallback;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.FuseUnavailableMountException;
import com.android.internal.util.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FuseAppLoop
implements Handler.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FuseAppLoop";
    private static boolean DEBUG;
    public static int ROOT_INODE = 1;
    private static int MIN_INODE = 2;
    private static ThreadFactory sDefaultThreadFactory;
    private static int FUSE_OK = 0;
    private static int ARGS_POOL_SIZE = 50;
    private Object mLock;
    private int mMountPointId;
    private Thread mThread;
    @GuardedBy(value="mLock")
    private SparseArray<CallbackEntry> mCallbackMap;
    @GuardedBy(value="mLock")
    private BytesMap mBytesMap;
    @GuardedBy(value="mLock")
    private LinkedList<Args> mArgsPool;
    @GuardedBy(value="mLock")
    private int mNextInode;
    @GuardedBy(value="mLock")
    private long mInstance;
    private static int FUSE_LOOKUP = 1;
    private static int FUSE_GETATTR = 3;
    private static int FUSE_OPEN = 14;
    private static int FUSE_READ = 15;
    private static int FUSE_WRITE = 16;
    private static int FUSE_RELEASE = 18;
    private static int FUSE_FSYNC = 20;
    private static int FUSE_MAX_WRITE = 131072;

    private void $$robo$$com_android_internal_os_FuseAppLoop$__constructor__(int mountPointId, ParcelFileDescriptor fd, ThreadFactory factory) {
        this.mLock = new Object();
        this.mCallbackMap = new SparseArray();
        this.mBytesMap = new BytesMap();
        this.mArgsPool = new LinkedList();
        this.mNextInode = 2;
        this.mMountPointId = mountPointId;
        if (factory == null) {
            factory = sDefaultThreadFactory;
        }
        this.mInstance = this.native_new(fd.detachFd());
        this.mThread = factory.newThread(() -> {
            this.native_start(this.mInstance);
            Object object = this.mLock;
            synchronized (object) {
                this.native_delete(this.mInstance);
                this.mInstance = 0L;
                this.mBytesMap.clear();
            }
        });
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_os_FuseAppLoop$registerCallback(ProxyFileDescriptorCallback callback, Handler handler) throws FuseUnavailableMountException {
        Object object = this.mLock;
        synchronized (object) {
            int id2;
            Preconditions.checkNotNull(callback);
            Preconditions.checkNotNull(handler);
            Preconditions.checkState(this.mCallbackMap.size() < 0x7FFFFFFD, "Too many opened files.");
            Preconditions.checkArgument(Thread.currentThread().getId() != handler.getLooper().getThread().getId(), "Handler must be different from the current thread");
            if (this.mInstance == 0L) {
                throw new FuseUnavailableMountException(this.mMountPointId);
            }
            do {
                id2 = this.mNextInode++;
                if (this.mNextInode >= 0) continue;
                this.mNextInode = 2;
            } while (this.mCallbackMap.get(id2) != null);
            this.mCallbackMap.put(id2, new CallbackEntry(callback, new Handler(handler.getLooper(), this)));
            return id2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_FuseAppLoop$unregisterCallback(int id2) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackMap.remove(id2);
        }
    }

    private final int $$robo$$com_android_internal_os_FuseAppLoop$getMountPointId() {
        return this.mMountPointId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_os_FuseAppLoop$handleMessage(Message msg) {
        Args args = (Args)msg.obj;
        CallbackEntry entry = args.entry;
        long inode = args.inode;
        long unique = args.unique;
        int size = args.size;
        long offset = args.offset;
        byte[] data = args.data;
        try {
            switch (msg.what) {
                case 1: {
                    long fileSize = entry.callback.onGetSize();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyLookup(this.mInstance, unique, inode, fileSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 3: {
                    long fileSize = entry.callback.onGetSize();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyGetAttr(this.mInstance, unique, inode, fileSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 15: {
                    int readSize = entry.callback.onRead(offset, size, data);
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyRead(this.mInstance, unique, readSize, data);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 16: {
                    int writeSize = entry.callback.onWrite(offset, size, data);
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replyWrite(this.mInstance, unique, writeSize);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 20: {
                    entry.callback.onFsync();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replySimple(this.mInstance, unique, 0);
                        }
                        this.recycleLocked(args);
                        break;
                    }
                }
                case 18: {
                    entry.callback.onRelease();
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mInstance != 0L) {
                            this.native_replySimple(this.mInstance, unique, 0);
                        }
                        this.mBytesMap.stopUsing(entry.getThreadId());
                        this.recycleLocked(args);
                        break;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown FUSE command: " + msg.what);
                }
            }
        }
        catch (Exception error) {
            Object object = this.mLock;
            synchronized (object) {
                Log.e("FuseAppLoop", "", error);
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
                this.recycleLocked(args);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_FuseAppLoop$onCommand(int command, long unique, long inode, long offset, int size, byte[] data) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                Args args = this.mArgsPool.size() == 0 ? new Args() : this.mArgsPool.pop();
                args.unique = unique;
                args.inode = inode;
                args.offset = offset;
                args.size = size;
                args.data = data;
                args.entry = this.getCallbackEntryOrThrowLocked(inode);
                if (!args.entry.handler.sendMessage(Message.obtain(args.entry.handler, command, 0, 0, args))) {
                    throw new ErrnoException("onCommand", OsConstants.EBADF);
                }
            }
            catch (Exception error) {
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] $$robo$$com_android_internal_os_FuseAppLoop$onOpen(long unique, long inode) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                CallbackEntry entry = this.getCallbackEntryOrThrowLocked(inode);
                if (entry.opened) {
                    throw new ErrnoException("onOpen", OsConstants.EMFILE);
                }
                if (this.mInstance != 0L) {
                    this.native_replyOpen(this.mInstance, unique, inode);
                    entry.opened = true;
                    return this.mBytesMap.startUsing(entry.getThreadId());
                }
            }
            catch (ErrnoException error) {
                this.replySimpleLocked(unique, FuseAppLoop.getError(error));
            }
            return null;
        }
    }

    private static final int $$robo$$com_android_internal_os_FuseAppLoop$getError(Exception error) {
        int errno;
        if (error instanceof ErrnoException && (errno = ((ErrnoException)error).errno) != OsConstants.ENOSYS) {
            return -errno;
        }
        return -OsConstants.EBADF;
    }

    @GuardedBy(value="mLock")
    private final CallbackEntry $$robo$$com_android_internal_os_FuseAppLoop$getCallbackEntryOrThrowLocked(long inode) throws ErrnoException {
        CallbackEntry entry = this.mCallbackMap.get(FuseAppLoop.checkInode(inode));
        if (entry == null) {
            throw new ErrnoException("getCallbackEntryOrThrowLocked", OsConstants.ENOENT);
        }
        return entry;
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$com_android_internal_os_FuseAppLoop$recycleLocked(Args args) {
        if (this.mArgsPool.size() < 50) {
            this.mArgsPool.add(args);
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$com_android_internal_os_FuseAppLoop$replySimpleLocked(long unique, int result) {
        if (this.mInstance != 0L) {
            this.native_replySimple(this.mInstance, unique, result);
        }
    }

    private final long $$robo$$com_android_internal_os_FuseAppLoop$native_new(int n) {
        return 0L;
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_delete(long l) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_start(long l) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replySimple(long l, long l2, int n) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replyOpen(long l, long l2, long l3) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replyLookup(long l, long l2, long l3, long l4) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replyGetAttr(long l, long l2, long l3, long l4) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replyWrite(long l, long l2, int n) {
    }

    private final void $$robo$$com_android_internal_os_FuseAppLoop$native_replyRead(long l, long l2, int n, byte[] byArray) {
    }

    private static final int $$robo$$com_android_internal_os_FuseAppLoop$checkInode(long inode) {
        Preconditions.checkArgumentInRange(inode, 2L, Integer.MAX_VALUE, "checkInode");
        return (int)inode;
    }

    static void __staticInitializer__() {
        DEBUG = Log.isLoggable("FuseAppLoop", 3);
        sDefaultThreadFactory = new ThreadFactory(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_os_FuseAppLoop_1$__constructor__() {
            }

            private final Thread $$robo$$com_android_internal_os_FuseAppLoop_1$newThread(Runnable r) {
                return new Thread(r, "FuseAppLoop");
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_os_FuseAppLoop_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_1$__constructor__(), 0, this);
            }

            @Override
            public Thread newThread(Runnable runnable) {
                return InvokeDynamicSupport.bootstrap("newThread", $$robo$$com_android_internal_os_FuseAppLoop_1$newThread(java.lang.Runnable ), 0, this, runnable);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, ParcelFileDescriptor parcelFileDescriptor, ThreadFactory threadFactory) {
        this.$$robo$$com_android_internal_os_FuseAppLoop$__constructor__(n, parcelFileDescriptor, threadFactory);
    }

    public FuseAppLoop(int n, ParcelFileDescriptor parcelFileDescriptor, ThreadFactory threadFactory) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop$__constructor__(int android.os.ParcelFileDescriptor java.util.concurrent.ThreadFactory ), 0, this, n, parcelFileDescriptor, threadFactory);
    }

    public int registerCallback(ProxyFileDescriptorCallback proxyFileDescriptorCallback, Handler handler) throws FuseUnavailableMountException {
        return (int)InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$com_android_internal_os_FuseAppLoop$registerCallback(android.os.ProxyFileDescriptorCallback android.os.Handler ), 0, this, proxyFileDescriptorCallback, handler);
    }

    public void unregisterCallback(int n) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$com_android_internal_os_FuseAppLoop$unregisterCallback(int ), 0, this, n);
    }

    public int getMountPointId() {
        return (int)InvokeDynamicSupport.bootstrap("getMountPointId", $$robo$$com_android_internal_os_FuseAppLoop$getMountPointId(), 0, this);
    }

    @Override
    public boolean handleMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_os_FuseAppLoop$handleMessage(android.os.Message ), 0, this, message);
    }

    private void onCommand(int n, long l, long l2, long l3, int n2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("onCommand", $$robo$$com_android_internal_os_FuseAppLoop$onCommand(int long long long int byte[] ), 0, this, n, l, l2, l3, n2, byArray);
    }

    private byte[] onOpen(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("onOpen", $$robo$$com_android_internal_os_FuseAppLoop$onOpen(long long ), 0, this, l, l2);
    }

    private static int getError(Exception exception) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getError", $$robo$$com_android_internal_os_FuseAppLoop$getError(java.lang.Exception ), 0, (Exception)exception);
    }

    private CallbackEntry getCallbackEntryOrThrowLocked(long l) throws ErrnoException {
        return InvokeDynamicSupport.bootstrap("getCallbackEntryOrThrowLocked", $$robo$$com_android_internal_os_FuseAppLoop$getCallbackEntryOrThrowLocked(long ), 0, this, l);
    }

    private void recycleLocked(Args args) {
        InvokeDynamicSupport.bootstrap("recycleLocked", $$robo$$com_android_internal_os_FuseAppLoop$recycleLocked(com.android.internal.os.FuseAppLoop$Args ), 0, this, args);
    }

    private void replySimpleLocked(long l, int n) {
        InvokeDynamicSupport.bootstrap("replySimpleLocked", $$robo$$com_android_internal_os_FuseAppLoop$replySimpleLocked(long int ), 0, this, l, n);
    }

    private final native /* synthetic */ long $$robo$$native_new$nativeBinding(int var1);

    long native_new(int n) {
        return (long)InvokeDynamicSupport.bootstrap("native_new", $$robo$$com_android_internal_os_FuseAppLoop$native_new(int ), 1, this, n);
    }

    private final native /* synthetic */ void $$robo$$native_delete$nativeBinding(long var1);

    void native_delete(long l) {
        InvokeDynamicSupport.bootstrap("native_delete", $$robo$$com_android_internal_os_FuseAppLoop$native_delete(long ), 1, this, l);
    }

    private final native /* synthetic */ void $$robo$$native_start$nativeBinding(long var1);

    void native_start(long l) {
        InvokeDynamicSupport.bootstrap("native_start", $$robo$$com_android_internal_os_FuseAppLoop$native_start(long ), 1, this, l);
    }

    private final native /* synthetic */ void $$robo$$native_replySimple$nativeBinding(long var1, long var3, int var5);

    void native_replySimple(long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("native_replySimple", $$robo$$com_android_internal_os_FuseAppLoop$native_replySimple(long long int ), 1, this, l, l2, n);
    }

    private final native /* synthetic */ void $$robo$$native_replyOpen$nativeBinding(long var1, long var3, long var5);

    void native_replyOpen(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrap("native_replyOpen", $$robo$$com_android_internal_os_FuseAppLoop$native_replyOpen(long long long ), 1, this, l, l2, l3);
    }

    private final native /* synthetic */ void $$robo$$native_replyLookup$nativeBinding(long var1, long var3, long var5, long var7);

    void native_replyLookup(long l, long l2, long l3, long l4) {
        InvokeDynamicSupport.bootstrap("native_replyLookup", $$robo$$com_android_internal_os_FuseAppLoop$native_replyLookup(long long long long ), 1, this, l, l2, l3, l4);
    }

    private final native /* synthetic */ void $$robo$$native_replyGetAttr$nativeBinding(long var1, long var3, long var5, long var7);

    void native_replyGetAttr(long l, long l2, long l3, long l4) {
        InvokeDynamicSupport.bootstrap("native_replyGetAttr", $$robo$$com_android_internal_os_FuseAppLoop$native_replyGetAttr(long long long long ), 1, this, l, l2, l3, l4);
    }

    private final native /* synthetic */ void $$robo$$native_replyWrite$nativeBinding(long var1, long var3, int var5);

    void native_replyWrite(long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("native_replyWrite", $$robo$$com_android_internal_os_FuseAppLoop$native_replyWrite(long long int ), 1, this, l, l2, n);
    }

    private final native /* synthetic */ void $$robo$$native_replyRead$nativeBinding(long var1, long var3, int var5, byte[] var6);

    void native_replyRead(long l, long l2, int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("native_replyRead", $$robo$$com_android_internal_os_FuseAppLoop$native_replyRead(long long int byte[] ), 1, this, l, l2, n, byArray);
    }

    private static int checkInode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkInode", $$robo$$com_android_internal_os_FuseAppLoop$checkInode(long ), 0, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(FuseAppLoop.class);
    }

    public /* synthetic */ FuseAppLoop() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FuseAppLoop)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Args
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long unique;
        long inode;
        long offset;
        int size;
        byte[] data;
        CallbackEntry entry;

        private void $$robo$$com_android_internal_os_FuseAppLoop_Args$__constructor__() {
        }

        private /* synthetic */ void $$robo$$com_android_internal_os_FuseAppLoop_Args$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_FuseAppLoop_Args$__constructor__();
        }

        private Args() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_Args$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_os_FuseAppLoop_Args$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Args)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class BytesMap
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Map<Long, BytesMapEntry> mEntries;

        private void $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$__constructor__() {
            this.mEntries = new HashMap<Long, BytesMapEntry>();
        }

        private final byte[] $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$startUsing(long threadId) {
            BytesMapEntry entry = this.mEntries.get(threadId);
            if (entry == null) {
                entry = new BytesMapEntry();
                this.mEntries.put(threadId, entry);
            }
            ++entry.counter;
            return entry.bytes;
        }

        private final void $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$stopUsing(long threadId) {
            BytesMapEntry entry = this.mEntries.get(threadId);
            Preconditions.checkNotNull(entry);
            --entry.counter;
            if (entry.counter <= 0) {
                this.mEntries.remove(threadId);
            }
        }

        private final void $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$clear() {
            this.mEntries.clear();
        }

        private /* synthetic */ void $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_FuseAppLoop_BytesMap$__constructor__();
        }

        private BytesMap() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$__constructor__(), 0, this);
        }

        byte[] startUsing(long l) {
            return InvokeDynamicSupport.bootstrap("startUsing", $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$startUsing(long ), 0, this, l);
        }

        void stopUsing(long l) {
            InvokeDynamicSupport.bootstrap("stopUsing", $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$stopUsing(long ), 0, this, l);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_os_FuseAppLoop_BytesMap$clear(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_os_FuseAppLoop_BytesMap$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class BytesMapEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int counter;
        byte[] bytes;

        private void $$robo$$com_android_internal_os_FuseAppLoop_BytesMapEntry$__constructor__() {
            this.counter = 0;
            this.bytes = new byte[131072];
        }

        private /* synthetic */ void $$robo$$com_android_internal_os_FuseAppLoop_BytesMapEntry$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_FuseAppLoop_BytesMapEntry$__constructor__();
        }

        private BytesMapEntry() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_BytesMapEntry$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_os_FuseAppLoop_BytesMapEntry$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BytesMapEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CallbackEntry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ProxyFileDescriptorCallback callback;
        Handler handler;
        boolean opened;

        private void $$robo$$com_android_internal_os_FuseAppLoop_CallbackEntry$__constructor__(ProxyFileDescriptorCallback callback, Handler handler) {
            this.callback = Preconditions.checkNotNull(callback);
            this.handler = Preconditions.checkNotNull(handler);
        }

        private final long $$robo$$com_android_internal_os_FuseAppLoop_CallbackEntry$getThreadId() {
            return this.handler.getLooper().getThread().getId();
        }

        private void __constructor__(ProxyFileDescriptorCallback proxyFileDescriptorCallback, Handler handler) {
            this.$$robo$$com_android_internal_os_FuseAppLoop_CallbackEntry$__constructor__(proxyFileDescriptorCallback, handler);
        }

        CallbackEntry(ProxyFileDescriptorCallback proxyFileDescriptorCallback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_CallbackEntry$__constructor__(android.os.ProxyFileDescriptorCallback android.os.Handler ), 0, this, proxyFileDescriptorCallback, handler);
        }

        long getThreadId() {
            return (long)InvokeDynamicSupport.bootstrap("getThreadId", $$robo$$com_android_internal_os_FuseAppLoop_CallbackEntry$getThreadId(), 0, this);
        }

        public /* synthetic */ CallbackEntry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackEntry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UnmountedException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_os_FuseAppLoop_UnmountedException$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_os_FuseAppLoop_UnmountedException$__constructor__();
        }

        public UnmountedException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_FuseAppLoop_UnmountedException$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnmountedException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

