/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuProcReader;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class KernelUidCpuActiveTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private KernelCpuProcReader mProcReader;
    private SparseArray<Double> mLastUidCpuActiveTimeMs;
    private int mCores;

    private void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__() {
        this.mLastUidCpuActiveTimeMs = new SparseArray();
        this.mProcReader = KernelCpuProcReader.getActiveTimeReaderInstance();
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__(KernelCpuProcReader procReader) {
        this.mLastUidCpuActiveTimeMs = new SparseArray();
        this.mProcReader = procReader;
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readDeltaImpl(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double activeTime = this.sumActiveTime((IntBuffer)buf);
            if (activeTime > 0.0) {
                double delta = activeTime - this.mLastUidCpuActiveTimeMs.get(uid, 0.0);
                if (delta > 0.0) {
                    this.mLastUidCpuActiveTimeMs.put(uid, activeTime);
                    if (callback != null) {
                        callback.onUidCpuActiveTime(uid, (long)delta);
                    }
                } else if (delta < 0.0) {
                    Slog.e(TAG, "Negative delta from active time proc: " + delta);
                }
            }
        });
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readAbsolute(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double activeTime = this.sumActiveTime((IntBuffer)buf);
            if (activeTime > 0.0) {
                callback.onUidCpuActiveTime(uid, (long)activeTime);
            }
        });
    }

    private final double $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$sumActiveTime(IntBuffer buffer) {
        double sum = 0.0;
        boolean corrupted = false;
        for (int j = 1; j <= this.mCores; ++j) {
            int time = buffer.get();
            if (time < 0) {
                Slog.e(TAG, "Negative time from active time proc: " + time);
                corrupted = true;
                continue;
            }
            sum += (double)time * 10.0 / (double)j;
        }
        return corrupted ? -1.0 : sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readImpl(Consumer<IntBuffer> processUid) {
        KernelCpuProcReader kernelCpuProcReader = this.mProcReader;
        synchronized (kernelCpuProcReader) {
            ByteBuffer bytes = this.mProcReader.readBytes();
            if (bytes == null || bytes.remaining() <= 4) {
                return;
            }
            if ((bytes.remaining() & 3) != 0) {
                Slog.wtf(TAG, "Cannot parse active time proc bytes to int: " + bytes.remaining());
                return;
            }
            IntBuffer buf = bytes.asIntBuffer();
            int cores = buf.get();
            if (this.mCores != 0 && cores != this.mCores) {
                Slog.wtf(TAG, "Cpu active time wrong # cores: " + cores);
                return;
            }
            this.mCores = cores;
            if (cores <= 0 || buf.remaining() % (cores + 1) != 0) {
                Slog.wtf(TAG, "Cpu active time format error: " + buf.remaining() + " / " + (cores + 1));
                return;
            }
            int numUids = buf.remaining() / (cores + 1);
            for (int i = 0; i < numUids; ++i) {
                processUid.accept(buf);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$removeUid(int uid) {
        this.mLastUidCpuActiveTimeMs.delete(uid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$removeUidsInRange(int startUid, int endUid) {
        this.mLastUidCpuActiveTimeMs.put(startUid, null);
        this.mLastUidCpuActiveTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuActiveTimeMs.indexOfKey(endUid);
        this.mLastUidCpuActiveTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    static void __staticInitializer__() {
        TAG = KernelUidCpuActiveTimeReader.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__();
    }

    public KernelUidCpuActiveTimeReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__(), 0, this);
    }

    private void __constructor__(KernelCpuProcReader kernelCpuProcReader) {
        this.$$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__(kernelCpuProcReader);
    }

    public KernelUidCpuActiveTimeReader(KernelCpuProcReader kernelCpuProcReader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$__constructor__(com.android.internal.os.KernelCpuProcReader ), 0, this, kernelCpuProcReader);
    }

    @Override
    protected void readDeltaImpl(Callback callback) {
        InvokeDynamicSupport.bootstrap("readDeltaImpl", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readDeltaImpl(com.android.internal.os.KernelUidCpuActiveTimeReader$Callback ), 0, this, callback);
    }

    public void readAbsolute(Callback callback) {
        InvokeDynamicSupport.bootstrap("readAbsolute", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readAbsolute(com.android.internal.os.KernelUidCpuActiveTimeReader$Callback ), 0, this, callback);
    }

    private double sumActiveTime(IntBuffer intBuffer) {
        return (double)InvokeDynamicSupport.bootstrap("sumActiveTime", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$sumActiveTime(java.nio.IntBuffer ), 0, this, intBuffer);
    }

    private void readImpl(Consumer<IntBuffer> consumer) {
        InvokeDynamicSupport.bootstrap("readImpl", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$readImpl(java.util.function.Consumer<java.nio.IntBuffer> ), 0, this, consumer);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$removeUid(int ), 0, this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelUidCpuActiveTimeReader$removeUidsInRange(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(KernelUidCpuActiveTimeReader.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelUidCpuActiveTimeReader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback,
    InstrumentedInterface {
        public void onUidCpuActiveTime(int var1, long var2);
    }
}

