/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuProcReader;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class KernelUidCpuClusterTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private KernelCpuProcReader mProcReader;
    private SparseArray<double[]> mLastUidPolicyTimeMs;
    private int mNumClusters;
    private int mNumCores;
    private int[] mNumCoresOnCluster;
    private double[] mCurTime;
    private long[] mDeltaTime;
    private long[] mCurTimeRounded;

    private void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__() {
        this.mLastUidPolicyTimeMs = new SparseArray();
        this.mNumClusters = -1;
        this.mProcReader = KernelCpuProcReader.getClusterTimeReaderInstance();
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__(KernelCpuProcReader procReader) {
        this.mLastUidPolicyTimeMs = new SparseArray();
        this.mNumClusters = -1;
        this.mProcReader = procReader;
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readDeltaImpl(Callback cb) {
        this.readImpl(buf -> {
            int uid = buf.get();
            double[] lastTimes = this.mLastUidPolicyTimeMs.get(uid);
            if (lastTimes == null) {
                lastTimes = new double[this.mNumClusters];
                this.mLastUidPolicyTimeMs.put(uid, lastTimes);
            }
            if (!this.sumClusterTime((IntBuffer)buf, this.mCurTime)) {
                return;
            }
            boolean valid = true;
            boolean notify = false;
            for (int i = 0; i < this.mNumClusters; ++i) {
                this.mDeltaTime[i] = (long)(this.mCurTime[i] - lastTimes[i]);
                if (this.mDeltaTime[i] < 0L) {
                    Slog.e(TAG, "Negative delta from cluster time proc: " + this.mDeltaTime[i]);
                    valid = false;
                }
                notify |= this.mDeltaTime[i] > 0L;
            }
            if (notify && valid) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mCurTime, (int)0, (Object)lastTimes, (int)0, (int)this.mNumClusters);
                if (cb != null) {
                    cb.onUidCpuPolicyTime(uid, this.mDeltaTime);
                }
            }
        });
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readAbsolute(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            if (this.sumClusterTime((IntBuffer)buf, this.mCurTime)) {
                for (int i = 0; i < this.mNumClusters; ++i) {
                    this.mCurTimeRounded[i] = (long)this.mCurTime[i];
                }
                callback.onUidCpuPolicyTime(uid, this.mCurTimeRounded);
            }
        });
    }

    private final boolean $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$sumClusterTime(IntBuffer buffer, double[] clusterTime) {
        boolean valid = true;
        for (int i = 0; i < this.mNumClusters; ++i) {
            clusterTime[i] = 0.0;
            for (int j = 1; j <= this.mNumCoresOnCluster[i]; ++j) {
                int time = buffer.get();
                if (time < 0) {
                    Slog.e(TAG, "Negative time from cluster time proc: " + time);
                    valid = false;
                }
                int n = i;
                clusterTime[n] = clusterTime[n] + (double)time * 10.0 / (double)j;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readImpl(Consumer<IntBuffer> processUid) {
        KernelCpuProcReader kernelCpuProcReader = this.mProcReader;
        synchronized (kernelCpuProcReader) {
            ByteBuffer bytes = this.mProcReader.readBytes();
            if (bytes == null || bytes.remaining() <= 4) {
                return;
            }
            if ((bytes.remaining() & 3) != 0) {
                Slog.wtf(TAG, "Cannot parse cluster time proc bytes to int: " + bytes.remaining());
                return;
            }
            IntBuffer buf = bytes.asIntBuffer();
            int numClusters = buf.get();
            if (numClusters <= 0) {
                Slog.wtf(TAG, "Cluster time format error: " + numClusters);
                return;
            }
            if (this.mNumClusters == -1) {
                this.mNumClusters = numClusters;
            }
            if (buf.remaining() < numClusters) {
                Slog.wtf(TAG, "Too few data left in the buffer: " + buf.remaining());
                return;
            }
            if (this.mNumCores <= 0) {
                if (!this.readCoreInfo(buf, numClusters)) {
                    return;
                }
            } else {
                buf.position(buf.position() + numClusters);
            }
            if (buf.remaining() % (this.mNumCores + 1) != 0) {
                Slog.wtf(TAG, "Cluster time format error: " + buf.remaining() + " / " + (this.mNumCores + 1));
                return;
            }
            int numUids = buf.remaining() / (this.mNumCores + 1);
            for (int i = 0; i < numUids; ++i) {
                processUid.accept(buf);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readCoreInfo(IntBuffer buf, int numClusters) {
        int numCores = 0;
        int[] numCoresOnCluster = new int[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            numCoresOnCluster[i] = buf.get();
            numCores += numCoresOnCluster[i];
        }
        if (numCores <= 0) {
            Slog.e(TAG, "Invalid # cores from cluster time proc file: " + numCores);
            return false;
        }
        this.mNumCores = numCores;
        this.mNumCoresOnCluster = numCoresOnCluster;
        this.mCurTime = new double[numClusters];
        this.mDeltaTime = new long[numClusters];
        this.mCurTimeRounded = new long[numClusters];
        return true;
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$removeUid(int uid) {
        this.mLastUidPolicyTimeMs.delete(uid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$removeUidsInRange(int startUid, int endUid) {
        this.mLastUidPolicyTimeMs.put(startUid, null);
        this.mLastUidPolicyTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidPolicyTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidPolicyTimeMs.indexOfKey(endUid);
        this.mLastUidPolicyTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    static void __staticInitializer__() {
        TAG = KernelUidCpuClusterTimeReader.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__();
    }

    public KernelUidCpuClusterTimeReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__(), 0, this);
    }

    private void __constructor__(KernelCpuProcReader kernelCpuProcReader) {
        this.$$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__(kernelCpuProcReader);
    }

    public KernelUidCpuClusterTimeReader(KernelCpuProcReader kernelCpuProcReader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$__constructor__(com.android.internal.os.KernelCpuProcReader ), 0, this, kernelCpuProcReader);
    }

    @Override
    protected void readDeltaImpl(Callback callback) {
        InvokeDynamicSupport.bootstrap("readDeltaImpl", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readDeltaImpl(com.android.internal.os.KernelUidCpuClusterTimeReader$Callback ), 0, this, callback);
    }

    public void readAbsolute(Callback callback) {
        InvokeDynamicSupport.bootstrap("readAbsolute", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readAbsolute(com.android.internal.os.KernelUidCpuClusterTimeReader$Callback ), 0, this, callback);
    }

    private boolean sumClusterTime(IntBuffer intBuffer, double[] dArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("sumClusterTime", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$sumClusterTime(java.nio.IntBuffer double[] ), 0, this, intBuffer, dArray);
    }

    private void readImpl(Consumer<IntBuffer> consumer) {
        InvokeDynamicSupport.bootstrap("readImpl", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readImpl(java.util.function.Consumer<java.nio.IntBuffer> ), 0, this, consumer);
    }

    private boolean readCoreInfo(IntBuffer intBuffer, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("readCoreInfo", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$readCoreInfo(java.nio.IntBuffer int ), 0, this, intBuffer, n);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$removeUid(int ), 0, this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelUidCpuClusterTimeReader$removeUidsInRange(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(KernelUidCpuClusterTimeReader.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelUidCpuClusterTimeReader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback,
    InstrumentedInterface {
        public void onUidCpuPolicyTime(int var1, long[] var2);
    }
}

