/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class KernelUidCpuTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static String sProcFile = "/proc/uid_cputime/show_uid_stat";
    private static String sRemoveUidProcFile = "/proc/uid_cputime/remove_uid_range";
    private SparseLongArray mLastUserTimeUs;
    private SparseLongArray mLastSystemTimeUs;
    private long mLastTimeReadUs;

    private void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__() {
        this.mLastUserTimeUs = new SparseLongArray();
        this.mLastSystemTimeUs = new SparseLongArray();
        this.mLastTimeReadUs = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readDeltaImpl(Callback callback) {
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        long nowUs = SystemClock.elapsedRealtime() * 1000L;
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/uid_cputime/show_uid_stat"));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            while ((line = reader.readLine()) != null) {
                splitter.setString(line);
                Object uidStr = splitter.next();
                int uid = Integer.parseInt(((String)uidStr).substring(0, ((String)uidStr).length() - 1), 10);
                long userTimeUs = Long.parseLong((String)splitter.next(), 10);
                long systemTimeUs = Long.parseLong((String)splitter.next(), 10);
                boolean notifyCallback = false;
                long userTimeDeltaUs = userTimeUs;
                long systemTimeDeltaUs = systemTimeUs;
                if (callback != null && this.mLastTimeReadUs != 0L) {
                    int index = this.mLastUserTimeUs.indexOfKey(uid);
                    if (index >= 0) {
                        long timeDiffUs = nowUs - this.mLastTimeReadUs;
                        if ((userTimeDeltaUs -= this.mLastUserTimeUs.valueAt(index)) < 0L || (systemTimeDeltaUs -= this.mLastSystemTimeUs.valueAt(index)) < 0L) {
                            StringBuilder sb = new StringBuilder("Malformed cpu data for UID=");
                            sb.append(uid).append("!\n");
                            sb.append("Time between reads: ");
                            TimeUtils.formatDuration(timeDiffUs / 1000L, sb);
                            sb.append("\n");
                            sb.append("Previous times: u=");
                            TimeUtils.formatDuration(this.mLastUserTimeUs.valueAt(index) / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(this.mLastSystemTimeUs.valueAt(index) / 1000L, sb);
                            sb.append("\nCurrent times: u=");
                            TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                            sb.append("\nDelta: u=");
                            TimeUtils.formatDuration(userTimeDeltaUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeDeltaUs / 1000L, sb);
                            Slog.e(TAG, sb.toString());
                            userTimeDeltaUs = 0L;
                            systemTimeDeltaUs = 0L;
                        }
                    }
                    notifyCallback = userTimeDeltaUs != 0L || systemTimeDeltaUs != 0L;
                }
                this.mLastUserTimeUs.put(uid, userTimeUs);
                this.mLastSystemTimeUs.put(uid, systemTimeUs);
                if (!notifyCallback) continue;
                callback.onUidCpuTime(uid, userTimeDeltaUs, systemTimeDeltaUs);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read uid_cputime: " + e.getMessage());
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
        this.mLastTimeReadUs = nowUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readAbsolute(Callback callback) {
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/uid_cputime/show_uid_stat"));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            while ((line = reader.readLine()) != null) {
                splitter.setString(line);
                Object uidStr = splitter.next();
                int uid = Integer.parseInt(((String)uidStr).substring(0, ((String)uidStr).length() - 1), 10);
                long userTimeUs = Long.parseLong((String)splitter.next(), 10);
                long systemTimeUs = Long.parseLong((String)splitter.next(), 10);
                callback.onUidCpuTime(uid, userTimeUs, systemTimeUs);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read uid_cputime: " + e.getMessage());
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUid(int uid) {
        int index = this.mLastSystemTimeUs.indexOfKey(uid);
        if (index >= 0) {
            this.mLastSystemTimeUs.removeAt(index);
            this.mLastUserTimeUs.removeAt(index);
        }
        this.removeUidsFromKernelModule(uid, uid);
    }

    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        this.mLastSystemTimeUs.put(startUid, 0L);
        this.mLastUserTimeUs.put(startUid, 0L);
        this.mLastSystemTimeUs.put(endUid, 0L);
        this.mLastUserTimeUs.put(endUid, 0L);
        int startIndex = this.mLastSystemTimeUs.indexOfKey(startUid);
        int endIndex = this.mLastSystemTimeUs.indexOfKey(endUid);
        this.mLastSystemTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.mLastUserTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.removeUidsFromKernelModule(startUid, endUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsFromKernelModule(int startUid, int endUid) {
        Slog.d(TAG, "Removing uids " + startUid + "-" + endUid);
        int oldMask = StrictMode.allowThreadDiskWritesMask();
        try (FileWriter writer = new FileWriter("/proc/uid_cputime/remove_uid_range");){
            writer.write(startUid + "-" + endUid);
            writer.flush();
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to remove uids " + startUid + " - " + endUid + " from uid_cputime module", e);
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    static void __staticInitializer__() {
        TAG = KernelUidCpuTimeReader.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__();
    }

    public KernelUidCpuTimeReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$__constructor__(), 0, this);
    }

    @Override
    protected void readDeltaImpl(Callback callback) {
        InvokeDynamicSupport.bootstrap("readDeltaImpl", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readDeltaImpl(com.android.internal.os.KernelUidCpuTimeReader$Callback ), 0, this, callback);
    }

    public void readAbsolute(Callback callback) {
        InvokeDynamicSupport.bootstrap("readAbsolute", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$readAbsolute(com.android.internal.os.KernelUidCpuTimeReader$Callback ), 0, this, callback);
    }

    public void removeUid(int n) {
        InvokeDynamicSupport.bootstrap("removeUid", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUid(int ), 0, this, n);
    }

    public void removeUidsInRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsInRange", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsInRange(int int ), 0, this, n, n2);
    }

    private void removeUidsFromKernelModule(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeUidsFromKernelModule", $$robo$$com_android_internal_os_KernelUidCpuTimeReader$removeUidsFromKernelModule(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(KernelUidCpuTimeReader.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelUidCpuTimeReader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback,
    InstrumentedInterface {
        public void onUidCpuTime(int var1, long var2, long var4);
    }
}

