/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String POWER_CPU_SUSPEND = "cpu.suspend";
    public static String POWER_CPU_IDLE = "cpu.idle";
    public static String POWER_CPU_ACTIVE = "cpu.active";
    public static String POWER_WIFI_SCAN = "wifi.scan";
    public static String POWER_WIFI_ON = "wifi.on";
    public static String POWER_WIFI_ACTIVE = "wifi.active";
    public static String POWER_WIFI_CONTROLLER_IDLE = "wifi.controller.idle";
    public static String POWER_WIFI_CONTROLLER_RX = "wifi.controller.rx";
    public static String POWER_WIFI_CONTROLLER_TX = "wifi.controller.tx";
    public static String POWER_WIFI_CONTROLLER_TX_LEVELS = "wifi.controller.tx_levels";
    public static String POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE = "wifi.controller.voltage";
    public static String POWER_BLUETOOTH_CONTROLLER_IDLE = "bluetooth.controller.idle";
    public static String POWER_BLUETOOTH_CONTROLLER_RX = "bluetooth.controller.rx";
    public static String POWER_BLUETOOTH_CONTROLLER_TX = "bluetooth.controller.tx";
    public static String POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE = "bluetooth.controller.voltage";
    public static String POWER_MODEM_CONTROLLER_SLEEP = "modem.controller.sleep";
    public static String POWER_MODEM_CONTROLLER_IDLE = "modem.controller.idle";
    public static String POWER_MODEM_CONTROLLER_RX = "modem.controller.rx";
    public static String POWER_MODEM_CONTROLLER_TX = "modem.controller.tx";
    public static String POWER_MODEM_CONTROLLER_OPERATING_VOLTAGE = "modem.controller.voltage";
    public static String POWER_GPS_ON = "gps.on";
    public static String POWER_GPS_SIGNAL_QUALITY_BASED = "gps.signalqualitybased";
    public static String POWER_GPS_OPERATING_VOLTAGE = "gps.voltage";
    @Deprecated
    public static String POWER_BLUETOOTH_ON = "bluetooth.on";
    @Deprecated
    public static String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    @Deprecated
    public static String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static String POWER_AMBIENT_DISPLAY = "ambient.on";
    public static String POWER_SCREEN_ON = "screen.on";
    public static String POWER_RADIO_ON = "radio.on";
    public static String POWER_RADIO_SCANNING = "radio.scanning";
    public static String POWER_RADIO_ACTIVE = "radio.active";
    public static String POWER_SCREEN_FULL = "screen.full";
    public static String POWER_AUDIO = "audio";
    public static String POWER_VIDEO = "video";
    public static String POWER_FLASHLIGHT = "camera.flashlight";
    public static String POWER_MEMORY = "memory.bandwidths";
    public static String POWER_CAMERA = "camera.avg";
    public static String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static String POWER_BATTERY_CAPACITY = "battery.capacity";
    static HashMap<String, Double> sPowerItemMap;
    static HashMap<String, Double[]> sPowerArrayMap;
    private static String TAG_DEVICE = "device";
    private static String TAG_ITEM = "item";
    private static String TAG_ARRAY = "array";
    private static String TAG_ARRAYITEM = "value";
    private static String ATTR_NAME = "name";
    private static Object sLock;
    private CpuClusterKey[] mCpuClusters;
    private static String CPU_PER_CLUSTER_CORE_COUNT = "cpu.clusters.cores";
    private static String CPU_CLUSTER_POWER_COUNT = "cpu.cluster_power.cluster";
    private static String CPU_CORE_SPEED_PREFIX = "cpu.core_speeds.cluster";
    private static String CPU_CORE_POWER_PREFIX = "cpu.core_power.cluster";

    @VisibleForTesting
    private void $$robo$$com_android_internal_os_PowerProfile$__constructor__(Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private void $$robo$$com_android_internal_os_PowerProfile$__constructor__(Context context, boolean forTest) {
        Object object = sLock;
        synchronized (object) {
            if (sPowerItemMap.size() == 0 && sPowerArrayMap.size() == 0) {
                this.readPowerValuesFromXml(context, forTest);
            }
            this.initCpuClusters();
        }
    }

    private final void $$robo$$com_android_internal_os_PowerProfile$readPowerValuesFromXml(Context context, boolean forTest) {
        int id2 = forTest ? 18284562 : 0x1170011;
        Resources resources = context.getResources();
        XmlResourceParser parser = resources.getXml(id2);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, "device");
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals("value")) {
                    sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals("array")) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, "name");
                    continue;
                }
                if (!element.equals("item") && !element.equals("value")) continue;
                String name = null;
                if (!parsingArray) {
                    name = parser.getAttributeValue(null, "name");
                }
                if (parser.next() != 4) continue;
                String power = parser.getText();
                double value = 0.0;
                try {
                    value = Double.valueOf(power);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (element.equals("item")) {
                    sPowerItemMap.put(name, value);
                    continue;
                }
                if (!parsingArray) continue;
                array2.add(value);
            }
            if (parsingArray) {
                sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
        int[] configResIds = new int[]{17694738, 17694743, 17694744, 17694742};
        String[] configResIdKeys = new String[]{"bluetooth.controller.idle", "bluetooth.controller.rx", "bluetooth.controller.tx", "bluetooth.controller.voltage"};
        for (int i = 0; i < configResIds.length; ++i) {
            int value;
            String key = configResIdKeys[i];
            if (sPowerItemMap.containsKey(key) && sPowerItemMap.get(key) > 0.0 || (value = resources.getInteger(configResIds[i])) <= 0) continue;
            sPowerItemMap.put(key, Double.valueOf(value));
        }
    }

    private final void $$robo$$com_android_internal_os_PowerProfile$initCpuClusters() {
        if (sPowerArrayMap.containsKey("cpu.clusters.cores")) {
            Double[] data = sPowerArrayMap.get("cpu.clusters.cores");
            this.mCpuClusters = new CpuClusterKey[data.length];
            for (int cluster = 0; cluster < data.length; ++cluster) {
                int numCpusInCluster = (int)Math.round(data[cluster]);
                this.mCpuClusters[cluster] = new CpuClusterKey("cpu.core_speeds.cluster" + cluster, "cpu.cluster_power.cluster" + cluster, "cpu.core_power.cluster" + cluster, numCpusInCluster);
            }
        } else {
            this.mCpuClusters = new CpuClusterKey[1];
            int numCpus = 1;
            if (sPowerItemMap.containsKey("cpu.clusters.cores")) {
                numCpus = (int)Math.round(sPowerItemMap.get("cpu.clusters.cores"));
            }
            this.mCpuClusters[0] = new CpuClusterKey("cpu.core_speeds.cluster0", "cpu.cluster_power.cluster0", "cpu.core_power.cluster0", numCpus);
        }
    }

    private final int $$robo$$com_android_internal_os_PowerProfile$getNumCpuClusters() {
        return this.mCpuClusters.length;
    }

    private final int $$robo$$com_android_internal_os_PowerProfile$getNumCoresInCpuCluster(int cluster) {
        return this.mCpuClusters[cluster].numCpus;
    }

    private final int $$robo$$com_android_internal_os_PowerProfile$getNumSpeedStepsInCpuCluster(int cluster) {
        if (cluster < 0 || cluster >= this.mCpuClusters.length) {
            return 0;
        }
        if (sPowerArrayMap.containsKey(this.mCpuClusters[cluster].freqKey)) {
            return sPowerArrayMap.get(this.mCpuClusters[cluster].freqKey).length;
        }
        return 1;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePowerForCpuCluster(int cluster) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].clusterPowerKey);
        }
        return 0.0;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePowerForCpuCore(int cluster, int step) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].corePowerKey, step);
        }
        return 0.0;
    }

    private final int $$robo$$com_android_internal_os_PowerProfile$getNumElements(String key) {
        if (sPowerItemMap.containsKey(key)) {
            return 1;
        }
        if (sPowerArrayMap.containsKey(key)) {
            return sPowerArrayMap.get(key).length;
        }
        return 0;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePowerOrDefault(String type, double defaultValue) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            return sPowerArrayMap.get(type)[0];
        }
        return defaultValue;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePower(String type) {
        return this.getAveragePowerOrDefault(type, 0.0);
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePower(String type, int level) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            Double[] values = sPowerArrayMap.get(type);
            if (values.length > level && level >= 0) {
                return values[level];
            }
            if (level < 0 || values.length == 0) {
                return 0.0;
            }
            return values[values.length - 1];
        }
        return 0.0;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getBatteryCapacity() {
        return this.getAveragePower("battery.capacity");
    }

    static void __staticInitializer__() {
        sPowerItemMap = new HashMap();
        sPowerArrayMap = new HashMap();
        sLock = new Object();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_os_PowerProfile$__constructor__(context);
    }

    public PowerProfile(Context context) {
        this(context, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_PowerProfile$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$com_android_internal_os_PowerProfile$__constructor__(context, bl);
    }

    public PowerProfile(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_PowerProfile$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    private void readPowerValuesFromXml(Context context, boolean bl) {
        InvokeDynamicSupport.bootstrap("readPowerValuesFromXml", $$robo$$com_android_internal_os_PowerProfile$readPowerValuesFromXml(android.content.Context boolean ), 0, this, context, bl);
    }

    private void initCpuClusters() {
        InvokeDynamicSupport.bootstrap("initCpuClusters", $$robo$$com_android_internal_os_PowerProfile$initCpuClusters(), 0, this);
    }

    public int getNumCpuClusters() {
        return (int)InvokeDynamicSupport.bootstrap("getNumCpuClusters", $$robo$$com_android_internal_os_PowerProfile$getNumCpuClusters(), 0, this);
    }

    public int getNumCoresInCpuCluster(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNumCoresInCpuCluster", $$robo$$com_android_internal_os_PowerProfile$getNumCoresInCpuCluster(int ), 0, this, n);
    }

    public int getNumSpeedStepsInCpuCluster(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNumSpeedStepsInCpuCluster", $$robo$$com_android_internal_os_PowerProfile$getNumSpeedStepsInCpuCluster(int ), 0, this, n);
    }

    public double getAveragePowerForCpuCluster(int n) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePowerForCpuCluster", $$robo$$com_android_internal_os_PowerProfile$getAveragePowerForCpuCluster(int ), 0, this, n);
    }

    public double getAveragePowerForCpuCore(int n, int n2) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePowerForCpuCore", $$robo$$com_android_internal_os_PowerProfile$getAveragePowerForCpuCore(int int ), 0, this, n, n2);
    }

    public int getNumElements(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getNumElements", $$robo$$com_android_internal_os_PowerProfile$getNumElements(java.lang.String ), 0, this, string2);
    }

    public double getAveragePowerOrDefault(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePowerOrDefault", $$robo$$com_android_internal_os_PowerProfile$getAveragePowerOrDefault(java.lang.String double ), 0, this, string2, d);
    }

    public double getAveragePower(String string2) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePower", $$robo$$com_android_internal_os_PowerProfile$getAveragePower(java.lang.String ), 0, this, string2);
    }

    public double getAveragePower(String string2, int n) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePower", $$robo$$com_android_internal_os_PowerProfile$getAveragePower(java.lang.String int ), 0, this, string2, n);
    }

    public double getBatteryCapacity() {
        return (double)InvokeDynamicSupport.bootstrap("getBatteryCapacity", $$robo$$com_android_internal_os_PowerProfile$getBatteryCapacity(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PowerProfile.class);
    }

    public /* synthetic */ PowerProfile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PowerProfile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class CpuClusterKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String freqKey;
        private String clusterPowerKey;
        private String corePowerKey;
        private int numCpus;

        private void $$robo$$com_android_internal_os_PowerProfile_CpuClusterKey$__constructor__(String freqKey, String clusterPowerKey, String corePowerKey, int numCpus) {
            this.freqKey = freqKey;
            this.clusterPowerKey = clusterPowerKey;
            this.corePowerKey = corePowerKey;
            this.numCpus = numCpus;
        }

        private /* synthetic */ void $$robo$$com_android_internal_os_PowerProfile_CpuClusterKey$__constructor__(String x0, String x1, String x2, int x3, 1 x4) {
        }

        private void __constructor__(String string2, String string3, String string4, int n) {
            this.$$robo$$com_android_internal_os_PowerProfile_CpuClusterKey$__constructor__(string2, string3, string4, n);
        }

        private CpuClusterKey(String string2, String string3, String string4, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_PowerProfile_CpuClusterKey$__constructor__(java.lang.String java.lang.String java.lang.String int ), 0, this, string2, string3, string4, n);
        }

        private /* synthetic */ void __constructor__(String string2, String string3, String string4, int n, 1 var5_5) {
            this.$$robo$$com_android_internal_os_PowerProfile_CpuClusterKey$__constructor__(string2, string3, string4, n, var5_5);
        }

        public /* synthetic */ CpuClusterKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CpuClusterKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

