/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.session.MediaController;
import android.media.session.MediaSessionManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AndroidRuntimeException;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.policy.DecorContext;
import com.android.internal.policy.DecorView;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.IconMenuPresenter;
import com.android.internal.view.menu.ListMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.widget.DecorContentParent;
import com.android.internal.widget.SwipeDismissLayout;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneWindow
extends Window
implements MenuBuilder.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PhoneWindow";
    private static boolean DEBUG = false;
    private static int DEFAULT_BACKGROUND_FADE_DURATION_MS = 300;
    private static int CUSTOM_TITLE_COMPATIBLE_FEATURES = 13505;
    private static Transition USE_DEFAULT_TRANSITION;
    PhoneWindowMenuCallback mContextMenuCallback;
    TypedValue mMinWidthMajor;
    TypedValue mMinWidthMinor;
    TypedValue mFixedWidthMajor;
    TypedValue mFixedWidthMinor;
    TypedValue mFixedHeightMajor;
    TypedValue mFixedHeightMinor;
    private DecorView mDecor;
    private boolean mForceDecorInstall;
    ViewGroup mContentParent;
    private boolean mContentParentExplicitlySet;
    SurfaceHolder.Callback2 mTakeSurfaceCallback;
    InputQueue.Callback mTakeInputQueueCallback;
    boolean mIsFloating;
    private boolean mIsTranslucent;
    private LayoutInflater mLayoutInflater;
    private TextView mTitleView;
    DecorContentParent mDecorContentParent;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    private TransitionManager mTransitionManager;
    private Scene mContentScene;
    static int FLAG_RESOURCE_SET_ICON = 1;
    static int FLAG_RESOURCE_SET_LOGO = 2;
    static int FLAG_RESOURCE_SET_ICON_FALLBACK = 4;
    int mResourcesSetFlags;
    int mIconRes;
    int mLogoRes;
    private DrawableFeatureState[] mDrawables;
    private PanelFeatureState[] mPanels;
    PanelFeatureState mPreparedPanel;
    int mPanelChordingKey;
    private boolean mSupportsPictureInPicture;
    private ImageView mLeftIconView;
    private ImageView mRightIconView;
    private ProgressBar mCircularProgressBar;
    private ProgressBar mHorizontalProgressBar;
    int mBackgroundResource;
    int mBackgroundFallbackResource;
    private Drawable mBackgroundDrawable;
    private boolean mLoadElevation;
    private float mElevation;
    private boolean mClipToOutline;
    private int mFrameResource;
    private int mTextColor;
    int mStatusBarColor;
    int mNavigationBarColor;
    int mNavigationBarDividerColor;
    private boolean mForcedStatusBarColor;
    private boolean mForcedNavigationBarColor;
    private CharSequence mTitle;
    private int mTitleColor;
    private boolean mAlwaysReadCloseOnTouchAttr;
    ContextMenuBuilder mContextMenu;
    MenuHelper mContextMenuHelper;
    private boolean mClosingActionMenu;
    private int mVolumeControlStreamType;
    private MediaController mMediaController;
    private AudioManager mAudioManager;
    private KeyguardManager mKeyguardManager;
    private MediaSessionManager mMediaSessionManager;
    private int mUiOptions;
    private boolean mInvalidatePanelMenuPosted;
    private int mInvalidatePanelMenuFeatures;
    private Runnable mInvalidatePanelMenuRunnable;
    private Transition mEnterTransition;
    private Transition mReturnTransition;
    private Transition mExitTransition;
    private Transition mReenterTransition;
    private Transition mSharedElementEnterTransition;
    private Transition mSharedElementReturnTransition;
    private Transition mSharedElementExitTransition;
    private Transition mSharedElementReenterTransition;
    private Boolean mAllowReturnTransitionOverlap;
    private Boolean mAllowEnterTransitionOverlap;
    private long mBackgroundFadeDurationMillis;
    private Boolean mSharedElementsUseOverlay;
    private boolean mIsStartingWindow;
    private int mTheme;
    private int mDecorCaptionShade;
    private boolean mUseDecorContext;
    private ViewRootImpl.ActivityConfigCallback mActivityConfigCallback;
    static RotationWatcher sRotationWatcher;
    private static String FOCUSED_ID_TAG = "android:focusedViewId";
    private static String VIEWS_TAG = "android:views";
    private static String PANELS_TAG = "android:Panels";
    private static String ACTION_BAR_TAG = "android:ActionBar";

    private void $$robo$$com_android_internal_policy_PhoneWindow$__constructor__(Context context) {
        this.mContextMenuCallback = new PhoneWindowMenuCallback(this);
        this.mMinWidthMajor = new TypedValue();
        this.mMinWidthMinor = new TypedValue();
        this.mForceDecorInstall = false;
        this.mContentParentExplicitlySet = false;
        this.mBackgroundResource = 0;
        this.mBackgroundFallbackResource = 0;
        this.mLoadElevation = true;
        this.mFrameResource = 0;
        this.mTextColor = 0;
        this.mStatusBarColor = 0;
        this.mNavigationBarColor = 0;
        this.mNavigationBarDividerColor = 0;
        this.mForcedStatusBarColor = false;
        this.mForcedNavigationBarColor = false;
        this.mTitle = null;
        this.mTitleColor = 0;
        this.mAlwaysReadCloseOnTouchAttr = false;
        this.mVolumeControlStreamType = Integer.MIN_VALUE;
        this.mUiOptions = 0;
        this.mInvalidatePanelMenuRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneWindow this$0;

            private void $$robo$$com_android_internal_policy_PhoneWindow_1$__constructor__(PhoneWindow this$0) {
            }

            private final void $$robo$$com_android_internal_policy_PhoneWindow_1$run() {
                for (int i = 0; i <= 13; ++i) {
                    if ((this.this$0.mInvalidatePanelMenuFeatures & 1 << i) == 0) continue;
                    this.this$0.doInvalidatePanelMenu(i);
                }
                this.this$0.mInvalidatePanelMenuPosted = false;
                this.this$0.mInvalidatePanelMenuFeatures = 0;
            }

            private void __constructor__(PhoneWindow phoneWindow) {
                this.$$robo$$com_android_internal_policy_PhoneWindow_1$__constructor__(phoneWindow);
            }
            {
                this.this$0 = phoneWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_1$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_PhoneWindow_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mEnterTransition = null;
        this.mReturnTransition = USE_DEFAULT_TRANSITION;
        this.mExitTransition = null;
        this.mReenterTransition = USE_DEFAULT_TRANSITION;
        this.mSharedElementEnterTransition = null;
        this.mSharedElementReturnTransition = USE_DEFAULT_TRANSITION;
        this.mSharedElementExitTransition = null;
        this.mSharedElementReenterTransition = USE_DEFAULT_TRANSITION;
        this.mBackgroundFadeDurationMillis = -1L;
        this.mTheme = -1;
        this.mDecorCaptionShade = 0;
        this.mUseDecorContext = false;
        this.mLayoutInflater = LayoutInflater.from(context);
    }

    private void $$robo$$com_android_internal_policy_PhoneWindow$__constructor__(Context context, Window preservedWindow, ViewRootImpl.ActivityConfigCallback activityConfigCallback) {
        this.mUseDecorContext = true;
        if (preservedWindow != null) {
            this.mDecor = (DecorView)preservedWindow.getDecorView();
            this.mElevation = preservedWindow.getElevation();
            this.mLoadElevation = false;
            this.mForceDecorInstall = true;
            this.getAttributes().token = preservedWindow.getAttributes().token;
        }
        boolean forceResizable = Settings.Global.getInt(context.getContentResolver(), "force_resizable_activities", 0) != 0;
        this.mSupportsPictureInPicture = forceResizable || context.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
        this.mActivityConfigCallback = activityConfigCallback;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setContainer(Window container) {
        super.setContainer(container);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$requestFeature(int featureId) {
        if (this.mContentParentExplicitlySet) {
            throw new AndroidRuntimeException("requestFeature() must be called before adding content");
        }
        int features = this.getFeatures();
        int newFeatures = features | 1 << featureId;
        if ((newFeatures & 0x80) != 0 && (newFeatures & 0xFFFFCB3E) != 0) {
            throw new AndroidRuntimeException("You cannot combine custom titles with other title features");
        }
        if ((features & 2) != 0 && featureId == 8) {
            return false;
        }
        if ((features & 0x100) != 0 && featureId == 1) {
            this.removeFeature(8);
        }
        if ((features & 0x100) != 0 && featureId == 11) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if ((features & 0x800) != 0 && featureId == 8) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if (featureId == 5 && this.getContext().getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
            throw new AndroidRuntimeException("You cannot use indeterminate progress on a watch.");
        }
        return super.requestFeature(featureId);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setUiOptions(int uiOptions) {
        this.mUiOptions = uiOptions;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setUiOptions(int uiOptions, int mask) {
        this.mUiOptions = this.mUiOptions & ~mask | uiOptions & mask;
    }

    private final TransitionManager $$robo$$com_android_internal_policy_PhoneWindow$getTransitionManager() {
        return this.mTransitionManager;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTransitionManager(TransitionManager tm) {
        this.mTransitionManager = tm;
    }

    private final Scene $$robo$$com_android_internal_policy_PhoneWindow$getContentScene() {
        return this.mContentScene;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setContentView(int layoutResID) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            Scene newScene = Scene.getSceneForLayout(this.mContentParent, layoutResID, this.getContext());
            this.transitionTo(newScene);
        } else {
            this.mLayoutInflater.inflate(layoutResID, this.mContentParent);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
        this.mContentParentExplicitlySet = true;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            view.setLayoutParams(params);
            Scene newScene = new Scene(this.mContentParent, view);
            this.transitionTo(newScene);
        } else {
            this.mContentParent.addView(view, params);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
        this.mContentParentExplicitlySet = true;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        }
        if (this.hasFeature(12)) {
            Log.v("PhoneWindow", "addContentView does not support content transitions");
        }
        this.mContentParent.addView(view, params);
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$clearContentView() {
        if (this.mDecor != null) {
            this.mDecor.clearContentView();
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$transitionTo(Scene scene) {
        if (this.mContentScene == null) {
            scene.enter();
        } else {
            this.mTransitionManager.transitionTo(scene);
        }
        this.mContentScene = scene;
    }

    private final View $$robo$$com_android_internal_policy_PhoneWindow$getCurrentFocus() {
        return this.mDecor != null ? this.mDecor.findFocus() : null;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$takeSurface(SurfaceHolder.Callback2 callback) {
        this.mTakeSurfaceCallback = callback;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$takeInputQueue(InputQueue.Callback callback) {
        this.mTakeInputQueueCallback = callback;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isFloating() {
        return this.mIsFloating;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isTranslucent() {
        return this.mIsTranslucent;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isShowingWallpaper() {
        return (this.getAttributes().flags & 0x100000) != 0;
    }

    private final LayoutInflater $$robo$$com_android_internal_policy_PhoneWindow$getLayoutInflater() {
        return this.mLayoutInflater;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTitle(CharSequence title) {
        this.setTitle(title, true);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTitle(CharSequence title, boolean updateAccessibilityTitle) {
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        } else if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setWindowTitle(title);
        }
        this.mTitle = title;
        if (updateAccessibilityTitle) {
            WindowManager.LayoutParams params = this.getAttributes();
            if (!TextUtils.equals(title, params.accessibilityTitle)) {
                ViewRootImpl vr;
                params.accessibilityTitle = TextUtils.stringOrSpannedString(title);
                if (this.mDecor != null && (vr = this.mDecor.getViewRootImpl()) != null) {
                    vr.onWindowTitleChanged();
                }
                this.dispatchWindowAttributesChanged(this.getAttributes());
            }
        }
    }

    @Deprecated
    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTitleColor(int textColor) {
        if (this.mTitleView != null) {
            this.mTitleView.setTextColor(textColor);
        }
        this.mTitleColor = textColor;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$preparePanel(PanelFeatureState st, KeyEvent event) {
        boolean isActionBarMenu;
        Window.Callback cb;
        if (this.isDestroyed()) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        if ((cb = this.getCallback()) != null) {
            st.createdPanelView = cb.onCreatePanelView(st.featureId);
        }
        boolean bl = isActionBarMenu = st.featureId == 0 || st.featureId == 8;
        if (isActionBarMenu && this.mDecorContentParent != null) {
            this.mDecorContentParent.setMenuPrepared();
        }
        if (st.createdPanelView == null) {
            if (st.menu == null || st.refreshMenuContent) {
                if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                    return false;
                }
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback(this);
                    }
                    this.mDecorContentParent.setMenu(st.menu, this.mActionMenuPresenterCallback);
                }
                st.menu.stopDispatchingItemsChanged();
                if (cb == null || !cb.onCreatePanelMenu(st.featureId, st.menu)) {
                    st.setMenu(null);
                    if (isActionBarMenu && this.mDecorContentParent != null) {
                        this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                st.refreshMenuContent = false;
            }
            st.menu.stopDispatchingItemsChanged();
            if (st.frozenActionViewState != null) {
                st.menu.restoreActionViewStates(st.frozenActionViewState);
                st.frozenActionViewState = null;
            }
            if (!cb.onPreparePanel(st.featureId, st.createdPanelView, st.menu)) {
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                }
                st.menu.startDispatchingItemsChanged();
                return false;
            }
            KeyCharacterMap kmap = KeyCharacterMap.load(event != null ? event.getDeviceId() : -1);
            st.qwertyMode = kmap.getKeyboardType() != 1;
            st.menu.setQwertyMode(st.qwertyMode);
            st.menu.startDispatchingItemsChanged();
        }
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onConfigurationChanged(Configuration newConfig) {
        PanelFeatureState st;
        if (this.mDecorContentParent == null && (st = this.getPanelState(0, false)) != null && st.menu != null) {
            if (st.isOpen) {
                Bundle state = new Bundle();
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.saveHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.saveHierarchyState(state);
                }
                PhoneWindow.clearMenuViews(st);
                this.reopenMenu(false);
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.restoreHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.restoreHierarchyState(state);
                }
            } else {
                PhoneWindow.clearMenuViews(st);
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onMultiWindowModeChanged() {
        if (this.mDecor != null) {
            this.mDecor.onConfigurationChanged(this.getContext().getResources().getConfiguration());
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        if (this.mDecor != null) {
            this.mDecor.updatePictureInPictureOutlineProvider(isInPictureInPictureMode);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$reportActivityRelaunched() {
        if (this.mDecor != null && this.mDecor.getViewRootImpl() != null) {
            this.mDecor.getViewRootImpl().reportActivityRelaunched();
        }
    }

    private static final void $$robo$$com_android_internal_policy_PhoneWindow$clearMenuViews(PanelFeatureState st) {
        st.createdPanelView = null;
        st.refreshDecorView = true;
        st.clearMenuPresenters();
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$openPanel(int featureId, KeyEvent event) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.showOverflowMenu();
        } else {
            this.openPanel(this.getPanelState(featureId, true), event);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$openPanel(PanelFeatureState st, KeyEvent event) {
        ViewGroup.LayoutParams lp;
        Window.Callback cb;
        if (st.isOpen || this.isDestroyed()) {
            return;
        }
        if (st.featureId == 0) {
            boolean isHoneycombApp;
            Context context = this.getContext();
            Configuration config = context.getResources().getConfiguration();
            boolean isXLarge = (config.screenLayout & 0xF) == 4;
            boolean bl = isHoneycombApp = context.getApplicationInfo().targetSdkVersion >= 11;
            if (isXLarge && isHoneycombApp) {
                return;
            }
        }
        if ((cb = this.getCallback()) != null && !cb.onMenuOpened(st.featureId, st.menu)) {
            this.closePanel(st, true);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        int width = -2;
        if (st.decorView == null || st.refreshDecorView) {
            int backgroundResId;
            if (st.decorView == null) {
                if (!this.initializePanelDecor(st) || st.decorView == null) {
                    return;
                }
            } else if (st.refreshDecorView && st.decorView.getChildCount() > 0) {
                st.decorView.removeAllViews();
            }
            if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
                return;
            }
            ViewGroup.LayoutParams lp2 = st.shownPanelView.getLayoutParams();
            if (lp2 == null) {
                lp2 = new ViewGroup.LayoutParams(-2, -2);
            }
            if (lp2.width == -1) {
                backgroundResId = st.fullBackground;
                width = -1;
            } else {
                backgroundResId = st.background;
            }
            st.decorView.setWindowBackground(this.getContext().getDrawable(backgroundResId));
            ViewParent shownPanelParent = st.shownPanelView.getParent();
            if (shownPanelParent != null && shownPanelParent instanceof ViewGroup) {
                ((ViewGroup)shownPanelParent).removeView(st.shownPanelView);
            }
            st.decorView.addView(st.shownPanelView, lp2);
            if (!st.shownPanelView.hasFocus()) {
                st.shownPanelView.requestFocus();
            }
        } else if (!st.isInListMode()) {
            width = -1;
        } else if (st.createdPanelView != null && (lp = st.createdPanelView.getLayoutParams()) != null && lp.width == -1) {
            width = -1;
        }
        st.isHandled = false;
        WindowManager.LayoutParams lp2 = new WindowManager.LayoutParams(width, -2, st.x, st.y, 1003, 0x820000, st.decorView.mDefaultOpacity);
        if (st.isCompact) {
            lp2.gravity = this.getOptionsPanelGravity();
            sRotationWatcher.addWindow(this);
        } else {
            lp2.gravity = st.gravity;
        }
        lp2.windowAnimations = st.windowAnimations;
        wm.addView(st.decorView, lp2);
        st.isOpen = true;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$closePanel(int featureId) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.hideOverflowMenu();
        } else if (featureId == 6) {
            this.closeContextMenu();
        } else {
            this.closePanel(this.getPanelState(featureId, true), true);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(st.menu);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm != null && st.isOpen) {
            if (st.decorView != null) {
                wm.removeView(st.decorView);
                if (st.isCompact) {
                    sRotationWatcher.removeWindow(this);
                }
            }
            if (doCallback) {
                this.callOnPanelClosed(st.featureId, st, null);
            }
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        if (st.isInExpandedMode) {
            st.refreshDecorView = true;
            st.isInExpandedMode = false;
        }
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
            this.mPanelChordingKey = 0;
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$checkCloseActionMenu(Menu menu2) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onPanelClosed(8, menu2);
        }
        this.mClosingActionMenu = false;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$togglePanel(int featureId, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (st.isOpen) {
            this.closePanel(st, true);
        } else {
            this.openPanel(st, event);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$invalidatePanelMenu(int featureId) {
        this.mInvalidatePanelMenuFeatures |= 1 << featureId;
        if (!this.mInvalidatePanelMenuPosted && this.mDecor != null) {
            this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$doPendingInvalidatePanelMenu() {
        if (this.mInvalidatePanelMenuPosted) {
            this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuRunnable.run();
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$doInvalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, false);
        if (st == null) {
            return;
        }
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 8 || featureId == 0) && this.mDecorContentParent != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$onKeyDownPanel(int featureId, KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getRepeatCount() == 0) {
            this.mPanelChordingKey = keyCode;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (st != null && !st.isOpen) {
                return this.preparePanel(st, event);
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onKeyUpPanel(int featureId, KeyEvent event) {
        if (this.mPanelChordingKey != 0) {
            this.mPanelChordingKey = 0;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (event.isCanceled() || this.mDecor != null && this.mDecor.mPrimaryActionMode != null || st == null) {
                return;
            }
            boolean playSoundEffect = false;
            if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
                if (!this.mDecorContentParent.isOverflowMenuShowing()) {
                    if (!this.isDestroyed() && this.preparePanel(st, event)) {
                        playSoundEffect = this.mDecorContentParent.showOverflowMenu();
                    }
                } else {
                    playSoundEffect = this.mDecorContentParent.hideOverflowMenu();
                }
            } else if (st.isOpen || st.isHandled) {
                playSoundEffect = st.isOpen;
                this.closePanel(st, true);
            } else if (st.isPrepared) {
                boolean show = true;
                if (st.refreshMenuContent) {
                    st.isPrepared = false;
                    show = this.preparePanel(st, event);
                }
                if (show) {
                    EventLog.writeEvent(50001, 0);
                    this.openPanel(st, event);
                    playSoundEffect = true;
                }
            }
            if (playSoundEffect) {
                AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
                if (audioManager != null) {
                    audioManager.playSoundEffect(0);
                } else {
                    Log.w("PhoneWindow", "Couldn't get audio manager");
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$closeAllPanels() {
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null) continue;
            this.closePanel(panel, true);
        }
        this.closeContextMenu();
    }

    private final synchronized void $$robo$$com_android_internal_policy_PhoneWindow$closeContextMenu() {
        if (this.mContextMenu != null) {
            this.mContextMenu.close();
            this.dismissContextMenu();
        }
    }

    private final synchronized void $$robo$$com_android_internal_policy_PhoneWindow$dismissContextMenu() {
        this.mContextMenu = null;
        if (this.mContextMenuHelper != null) {
            this.mContextMenuHelper.dismiss();
            this.mContextMenuHelper = null;
        }
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$performPanelShortcut(int featureId, int keyCode, KeyEvent event, int flags) {
        return this.performPanelShortcut(this.getPanelState(featureId, false), keyCode, event, flags);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem() || st == null) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled) {
            st.isHandled = true;
            if ((flags & 1) == 0 && this.mDecorContentParent == null) {
                this.closePanel(st, true);
            }
        }
        return handled;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$performPanelIdentifierAction(int featureId, int id2, int flags) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (!this.preparePanel(st, new KeyEvent(0, 82))) {
            return false;
        }
        if (st.menu == null) {
            return false;
        }
        boolean res = st.menu.performIdentifierAction(id2, flags);
        if (this.mDecorContentParent == null) {
            this.closePanel(st, true);
        }
        return res;
    }

    private final PanelFeatureState $$robo$$com_android_internal_policy_PhoneWindow$findMenuPanel(Menu menu2) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu2) continue;
            return panel;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        PanelFeatureState panel;
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed() && (panel = this.findMenuPanel(menu2.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onMenuModeChange(MenuBuilder menu2) {
        this.reopenMenu(true);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$reopenMenu(boolean toggleMenuMode) {
        if (this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && (!ViewConfiguration.get(this.getContext()).hasPermanentMenuKey() || this.mDecorContentParent.isOverflowMenuShowPending())) {
            Window.Callback cb = this.getCallback();
            if (!this.mDecorContentParent.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.isDestroyed()) {
                    PanelFeatureState st;
                    if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                        this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
                        this.mInvalidatePanelMenuRunnable.run();
                    }
                    if ((st = this.getPanelState(0, false)) != null && st.menu != null && !st.refreshMenuContent && cb.onPreparePanel(0, st.createdPanelView, st.menu)) {
                        cb.onMenuOpened(8, st.menu);
                        this.mDecorContentParent.showOverflowMenu();
                    }
                }
            } else {
                this.mDecorContentParent.hideOverflowMenu();
                PanelFeatureState st = this.getPanelState(0, false);
                if (st != null && cb != null && !this.isDestroyed()) {
                    cb.onPanelClosed(8, st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        boolean newExpandedMode = toggleMenuMode ? !st.isInExpandedMode : st.isInExpandedMode;
        st.refreshDecorView = true;
        this.closePanel(st, false);
        st.isInExpandedMode = newExpandedMode;
        this.openPanel(st, null);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$initializePanelMenu(PanelFeatureState st) {
        Context context = this.getContext();
        if ((st.featureId == 0 || st.featureId == 8) && this.mDecorContentParent != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme baseTheme = context.getTheme();
            baseTheme.resolveAttribute(16843825, outValue, true);
            Resources.Theme widgetTheme = null;
            if (outValue.resourceId != 0) {
                widgetTheme = context.getResources().newTheme();
                widgetTheme.setTo(baseTheme);
                widgetTheme.applyStyle(outValue.resourceId, true);
                widgetTheme.resolveAttribute(16843671, outValue, true);
            } else {
                baseTheme.resolveAttribute(16843671, outValue, true);
            }
            if (outValue.resourceId != 0) {
                if (widgetTheme == null) {
                    widgetTheme = context.getResources().newTheme();
                    widgetTheme.setTo(baseTheme);
                }
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            if (widgetTheme != null) {
                context = new ContextThemeWrapper(context, 0);
                context.getTheme().setTo(widgetTheme);
            }
        }
        MenuBuilder menu2 = new MenuBuilder(context);
        menu2.setCallback(this);
        st.setMenu(menu2);
        return true;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$initializePanelDecor(PanelFeatureState st) {
        st.decorView = this.generateDecor(st.featureId);
        st.gravity = 81;
        st.setStyle(this.getContext());
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.Window, 0, st.listPresenterTheme);
        float elevation = a.getDimension(38, 0.0f);
        if (elevation != 0.0f) {
            st.decorView.setElevation(elevation);
        }
        a.recycle();
        return true;
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getOptionsPanelGravity() {
        try {
            return WindowManagerHolder.sWindowManager.getPreferredOptionsPanelGravity();
        }
        catch (RemoteException ex) {
            Log.e("PhoneWindow", "Couldn't getOptionsPanelGravity; using default", ex);
            return 81;
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onOptionsPanelRotationChanged() {
        WindowManager.LayoutParams lp;
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = lp = st.decorView != null ? (WindowManager.LayoutParams)st.decorView.getLayoutParams() : null;
        if (lp != null) {
            lp.gravity = this.getOptionsPanelGravity();
            WindowManager wm = this.getWindowManager();
            if (wm != null) {
                wm.updateViewLayout(st.decorView, lp);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$initializePanelContent(PanelFeatureState st) {
        if (st.createdPanelView != null) {
            st.shownPanelView = st.createdPanelView;
            return true;
        }
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback(this);
        }
        MenuView menuView = st.isInListMode() ? st.getListMenuView(this.getContext(), this.mPanelMenuPresenterCallback) : st.getIconMenuView(this.getContext(), this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)((Object)menuView);
        if (st.shownPanelView != null) {
            int defaultAnimations = menuView.getWindowAnimations();
            if (defaultAnimations != 0) {
                st.windowAnimations = defaultAnimations;
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$performContextMenuIdentifierAction(int id2, int flags) {
        return this.mContextMenu != null ? this.mContextMenu.performIdentifierAction(id2, flags) : false;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setElevation(float elevation) {
        this.mElevation = elevation;
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (this.mDecor != null) {
            this.mDecor.setElevation(elevation);
            attrs.setSurfaceInsets(this.mDecor, true, false);
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    private final float $$robo$$com_android_internal_policy_PhoneWindow$getElevation() {
        return this.mElevation;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setClipToOutline(boolean clipToOutline) {
        this.mClipToOutline = clipToOutline;
        if (this.mDecor != null) {
            this.mDecor.setClipToOutline(clipToOutline);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != this.mBackgroundDrawable || this.mBackgroundResource != 0) {
            this.mBackgroundResource = 0;
            this.mBackgroundDrawable = drawable2;
            if (this.mDecor != null) {
                this.mDecor.setWindowBackground(drawable2);
            }
            if (this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(drawable2 != null ? 0 : this.mBackgroundFallbackResource);
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableResource(int featureId, int resId) {
        if (resId != 0) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.resid != resId) {
                st.resid = resId;
                st.uri = null;
                st.local = this.getContext().getDrawable(resId);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableUri(int featureId, Uri uri) {
        if (uri != null) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.uri == null || !st.uri.equals(uri)) {
                st.resid = 0;
                st.uri = uri;
                st.local = this.loadImageURI(uri);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.resid = 0;
        st.uri = null;
        if (st.local != drawable2) {
            st.local = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableAlpha(int featureId, int alpha) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.alpha != alpha) {
            st.alpha = alpha;
            this.updateDrawable(featureId, st, false);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDefaultDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.def != drawable2) {
            st.def = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setFeatureInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$updateDrawable(int featureId, boolean fromActive) {
        DrawableFeatureState st = this.getDrawableState(featureId, false);
        if (st != null) {
            this.updateDrawable(featureId, st, fromActive);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onDrawableChanged(int featureId, Drawable drawable2, int alpha) {
        ImageView view;
        if (featureId == 3) {
            view = this.getLeftIconView();
        } else if (featureId == 4) {
            view = this.getRightIconView();
        } else {
            return;
        }
        if (drawable2 != null) {
            drawable2.setAlpha(alpha);
            view.setImageDrawable(drawable2);
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onIntChanged(int featureId, int value) {
        FrameLayout titleContainer;
        if (featureId == 2 || featureId == 5) {
            this.updateProgressBars(value);
        } else if (featureId == 7 && (titleContainer = (FrameLayout)this.findViewById(16909415)) != null) {
            this.mLayoutInflater.inflate(value, (ViewGroup)titleContainer);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$updateProgressBars(int value) {
        ProgressBar circularProgressBar = this.getCircularProgressBar(true);
        ProgressBar horizontalProgressBar = this.getHorizontalProgressBar(true);
        int features = this.getLocalFeatures();
        if (value == -1) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    int level = horizontalProgressBar.getProgress();
                    int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                    horizontalProgressBar.setVisibility(visibility);
                } else {
                    Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(0);
                } else {
                    Log.e("PhoneWindow", "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -2) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    horizontalProgressBar.setVisibility(8);
                } else {
                    Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(8);
                } else {
                    Log.e("PhoneWindow", "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -3) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(true);
            } else {
                Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
            }
        } else if (value == -4) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(false);
            } else {
                Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
            }
        } else if (0 <= value && value <= 10000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setProgress(value - 0);
            } else {
                Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
            }
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        } else if (20000 <= value && value <= 30000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setSecondaryProgress(value - 20000);
            } else {
                Log.e("PhoneWindow", "Horizontal progress bar not located in current window decor");
            }
            this.showProgressBars(horizontalProgressBar, circularProgressBar);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$showProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$hideProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        Animation anim2 = AnimationUtils.loadAnimation(this.getContext(), 0x10A0001);
        anim2.setDuration(1000L);
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.startAnimation(anim2);
            spinnyProgressBar.setVisibility(4);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.startAnimation(anim2);
            horizontalProgressBar.setVisibility(4);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setIcon(int resId) {
        this.mIconRes = resId;
        this.mResourcesSetFlags |= 1;
        this.mResourcesSetFlags &= 0xFFFFFFFB;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setIcon(resId);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setDefaultIcon(int resId) {
        if ((this.mResourcesSetFlags & 1) != 0) {
            return;
        }
        this.mIconRes = resId;
        if (!(this.mDecorContentParent == null || this.mDecorContentParent.hasIcon() && (this.mResourcesSetFlags & 4) == 0)) {
            if (resId != 0) {
                this.mDecorContentParent.setIcon(resId);
                this.mResourcesSetFlags &= 0xFFFFFFFB;
            } else {
                this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                this.mResourcesSetFlags |= 4;
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setLogo(int resId) {
        this.mLogoRes = resId;
        this.mResourcesSetFlags |= 2;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setDefaultLogo(int resId) {
        if ((this.mResourcesSetFlags & 2) != 0) {
            return;
        }
        this.mLogoRes = resId;
        if (this.mDecorContentParent != null && !this.mDecorContentParent.hasLogo()) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setLocalFocus(boolean hasFocus, boolean inTouchMode) {
        this.getViewRootImpl().windowFocusChanged(hasFocus, inTouchMode);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$injectInputEvent(InputEvent event) {
        this.getViewRootImpl().dispatchInputEvent(event);
    }

    private final ViewRootImpl $$robo$$com_android_internal_policy_PhoneWindow$getViewRootImpl() {
        ViewRootImpl viewRootImpl;
        if (this.mDecor != null && (viewRootImpl = this.mDecor.getViewRootImpl()) != null) {
            return viewRootImpl;
        }
        throw new IllegalStateException("view not added");
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$takeKeyEvents(boolean get) {
        this.mDecor.setFocusable(get);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$superDispatchKeyEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$superDispatchKeyShortcutEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyShortcutEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$superDispatchTouchEvent(MotionEvent event) {
        return this.mDecor.superDispatchTouchEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$superDispatchTrackballEvent(MotionEvent event) {
        return this.mDecor.superDispatchTrackballEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$superDispatchGenericMotionEvent(MotionEvent event) {
        return this.mDecor.superDispatchGenericMotionEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$onKeyDown(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (this.mMediaController != null) {
                    this.mMediaController.dispatchVolumeButtonEventAsSystemService(event);
                } else {
                    this.getMediaSessionManager().dispatchVolumeKeyEventAsSystemService(event, this.mVolumeControlStreamType);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEventAsSystemService(event);
            }
            case 82: {
                this.onKeyDownPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                if (event.getRepeatCount() > 0 || featureId < 0) break;
                if (dispatcher != null) {
                    dispatcher.startTracking(event, this);
                }
                return true;
            }
        }
        return false;
    }

    private final KeyguardManager $$robo$$com_android_internal_policy_PhoneWindow$getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    private final AudioManager $$robo$$com_android_internal_policy_PhoneWindow$getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private final MediaSessionManager $$robo$$com_android_internal_policy_PhoneWindow$getMediaSessionManager() {
        if (this.mMediaSessionManager == null) {
            this.mMediaSessionManager = (MediaSessionManager)this.getContext().getSystemService("media_session");
        }
        return this.mMediaSessionManager;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$onKeyUp(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher;
        KeyEvent.DispatcherState dispatcherState = dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: {
                if (this.mMediaController != null) {
                    this.mMediaController.dispatchVolumeButtonEventAsSystemService(event);
                } else {
                    this.getMediaSessionManager().dispatchVolumeKeyEventAsSystemService(event, this.mVolumeControlStreamType);
                }
                return true;
            }
            case 164: {
                this.getMediaSessionManager().dispatchVolumeKeyEventAsSystemService(event, Integer.MIN_VALUE);
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEventAsSystemService(event);
            }
            case 82: {
                this.onKeyUpPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                PanelFeatureState st;
                if (featureId < 0 || !event.isTracking() || event.isCanceled()) break;
                if (featureId == 0 && (st = this.getPanelState(featureId, false)) != null && st.isInExpandedMode) {
                    this.reopenMenu(true);
                    return true;
                }
                this.closePanel(featureId);
                return true;
            }
            case 84: {
                if (this.isNotInstantAppAndKeyguardRestricted() || (this.getContext().getResources().getConfiguration().uiMode & 0xF) == 6) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.launchDefaultSearch(event);
                }
                return true;
            }
            case 171: {
                if (this.mSupportsPictureInPicture && !event.isCanceled()) {
                    this.getWindowControllerCallback().enterPictureInPictureModeIfPossible();
                }
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isNotInstantAppAndKeyguardRestricted() {
        return !this.getContext().getPackageManager().isInstantApp() && this.getKeyguardManager().inKeyguardRestrictedInputMode();
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onActive() {
    }

    private final View $$robo$$com_android_internal_policy_PhoneWindow$getDecorView() {
        if (this.mDecor == null || this.mForceDecorInstall) {
            this.installDecor();
        }
        return this.mDecor;
    }

    private final View $$robo$$com_android_internal_policy_PhoneWindow$peekDecorView() {
        return this.mDecor;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$onViewRootImplSet(ViewRootImpl viewRoot) {
        viewRoot.setActivityConfigCallback(this.mActivityConfigCallback);
    }

    private final Bundle $$robo$$com_android_internal_policy_PhoneWindow$saveHierarchyState() {
        Bundle outState = new Bundle();
        if (this.mContentParent == null) {
            return outState;
        }
        SparseArray<Parcelable> states = new SparseArray<Parcelable>();
        this.mContentParent.saveHierarchyState(states);
        outState.putSparseParcelableArray("android:views", states);
        View focusedView = this.mContentParent.findFocus();
        if (focusedView != null && focusedView.getId() != -1) {
            outState.putInt("android:focusedViewId", focusedView.getId());
        }
        SparseArray<Parcelable> panelStates = new SparseArray<Parcelable>();
        this.savePanelState(panelStates);
        if (panelStates.size() > 0) {
            outState.putSparseParcelableArray("android:Panels", panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = new SparseArray<Parcelable>();
            this.mDecorContentParent.saveToolbarHierarchyState(actionBarStates);
            outState.putSparseParcelableArray("android:ActionBar", actionBarStates);
        }
        return outState;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$restoreHierarchyState(Bundle savedInstanceState) {
        SparseArray<Parcelable> panelStates;
        int focusedViewId;
        if (this.mContentParent == null) {
            return;
        }
        SparseArray<Parcelable> savedStates = savedInstanceState.getSparseParcelableArray("android:views");
        if (savedStates != null) {
            this.mContentParent.restoreHierarchyState(savedStates);
        }
        if ((focusedViewId = savedInstanceState.getInt("android:focusedViewId", -1)) != -1) {
            Object needsFocus = this.mContentParent.findViewById(focusedViewId);
            if (needsFocus != null) {
                ((View)needsFocus).requestFocus();
            } else {
                Log.w("PhoneWindow", "Previously focused view reported id " + focusedViewId + " during save, but can't be found during restore.");
            }
        }
        if ((panelStates = savedInstanceState.getSparseParcelableArray("android:Panels")) != null) {
            this.restorePanelState(panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = savedInstanceState.getSparseParcelableArray("android:ActionBar");
            if (actionBarStates != null) {
                this.doPendingInvalidatePanelMenu();
                this.mDecorContentParent.restoreToolbarHierarchyState(actionBarStates);
            } else {
                Log.w("PhoneWindow", "Missing saved instance states for action bar views! State will not be restored.");
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$savePanelState(SparseArray<Parcelable> icicles) {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int curFeatureId = panels.length - 1; curFeatureId >= 0; --curFeatureId) {
            if (panels[curFeatureId] == null) continue;
            icicles.put(curFeatureId, panels[curFeatureId].onSaveInstanceState());
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$restorePanelState(SparseArray<Parcelable> icicles) {
        for (int i = icicles.size() - 1; i >= 0; --i) {
            int curFeatureId = icicles.keyAt(i);
            PanelFeatureState st = this.getPanelState(curFeatureId, false);
            if (st == null) continue;
            st.onRestoreInstanceState(icicles.get(curFeatureId));
            this.invalidatePanelMenu(curFeatureId);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$openPanelsAfterRestore() {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int i = panels.length - 1; i >= 0; --i) {
            PanelFeatureState st = panels[i];
            if (st == null) continue;
            st.applyFrozenState();
            if (st.isOpen || !st.wasLastOpen) continue;
            st.isInExpandedMode = st.wasLastExpanded;
            this.openPanel(st, null);
        }
    }

    private final DecorView $$robo$$com_android_internal_policy_PhoneWindow$generateDecor(int featureId) {
        Context context;
        if (this.mUseDecorContext) {
            Context applicationContext = this.getContext().getApplicationContext();
            if (applicationContext == null) {
                context = this.getContext();
            } else {
                context = new DecorContext(applicationContext, this.getContext());
                if (this.mTheme != -1) {
                    context.setTheme(this.mTheme);
                }
            }
        } else {
            context = this.getContext();
        }
        return new DecorView(context, featureId, this, this.getAttributes());
    }

    private final ViewGroup $$robo$$com_android_internal_policy_PhoneWindow$generateLayout(DecorView decor) {
        ProgressBar progress;
        TypedValue res;
        int layoutResource;
        int features;
        boolean noActionBar;
        TypedArray a = this.getWindowStyle();
        this.mIsFloating = a.getBoolean(4, false);
        int flagsToUpdate = 0x10100 & ~this.getForcedWindowFlags();
        if (this.mIsFloating) {
            this.setLayout(-2, -2);
            this.setFlags(0, flagsToUpdate);
        } else {
            this.setFlags(65792, flagsToUpdate);
        }
        if (a.getBoolean(3, false)) {
            this.requestFeature(1);
        } else if (a.getBoolean(15, false)) {
            this.requestFeature(8);
        }
        if (a.getBoolean(17, false)) {
            this.requestFeature(9);
        }
        if (a.getBoolean(16, false)) {
            this.requestFeature(10);
        }
        if (a.getBoolean(25, false)) {
            this.requestFeature(11);
        }
        if (a.getBoolean(9, false)) {
            this.setFlags(1024, 0x400 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(23, false)) {
            this.setFlags(0x4000000, 0x4000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(24, false)) {
            this.setFlags(0x8000000, 0x8000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(22, false)) {
            this.setFlags(0x2000000, 0x2000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(14, false)) {
            this.setFlags(0x100000, 0x100000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(18, this.getContext().getApplicationInfo().targetSdkVersion >= 11)) {
            this.setFlags(0x800000, 0x800000 & ~this.getForcedWindowFlags());
        }
        a.getValue(19, this.mMinWidthMajor);
        a.getValue(20, this.mMinWidthMinor);
        if (a.hasValue(55)) {
            if (this.mFixedWidthMajor == null) {
                this.mFixedWidthMajor = new TypedValue();
            }
            a.getValue(55, this.mFixedWidthMajor);
        }
        if (a.hasValue(56)) {
            if (this.mFixedWidthMinor == null) {
                this.mFixedWidthMinor = new TypedValue();
            }
            a.getValue(56, this.mFixedWidthMinor);
        }
        if (a.hasValue(53)) {
            if (this.mFixedHeightMajor == null) {
                this.mFixedHeightMajor = new TypedValue();
            }
            a.getValue(53, this.mFixedHeightMajor);
        }
        if (a.hasValue(54)) {
            if (this.mFixedHeightMinor == null) {
                this.mFixedHeightMinor = new TypedValue();
            }
            a.getValue(54, this.mFixedHeightMinor);
        }
        if (a.getBoolean(26, false)) {
            this.requestFeature(12);
        }
        if (a.getBoolean(45, false)) {
            this.requestFeature(13);
        }
        this.mIsTranslucent = a.getBoolean(5, false);
        Context context = this.getContext();
        int targetSdk = context.getApplicationInfo().targetSdkVersion;
        boolean targetPreHoneycomb = targetSdk < 11;
        boolean targetPreIcs = targetSdk < 14;
        boolean targetPreL = targetSdk < 21;
        boolean targetHcNeedsOptions = context.getResources().getBoolean(17957115);
        boolean bl = noActionBar = !this.hasFeature(8) || this.hasFeature(1);
        if (targetPreHoneycomb || targetPreIcs && targetHcNeedsOptions && noActionBar) {
            this.setNeedsMenuKey(1);
        } else {
            this.setNeedsMenuKey(2);
        }
        if (!this.mForcedStatusBarColor) {
            this.mStatusBarColor = a.getColor(35, -16777216);
        }
        if (!this.mForcedNavigationBarColor) {
            this.mNavigationBarColor = a.getColor(36, -16777216);
            this.mNavigationBarDividerColor = a.getColor(50, 0);
        }
        WindowManager.LayoutParams params = this.getAttributes();
        if (!this.mIsFloating) {
            if (!targetPreL && a.getBoolean(34, false)) {
                this.setFlags(Integer.MIN_VALUE, Integer.MIN_VALUE & ~this.getForcedWindowFlags());
            }
            if (this.mDecor.mForceWindowDrawsStatusBarBackground) {
                params.privateFlags |= 0x20000;
            }
        }
        if (a.getBoolean(46, false)) {
            decor.setSystemUiVisibility(decor.getSystemUiVisibility() | 0x2000);
        }
        if (a.getBoolean(49, false)) {
            decor.setSystemUiVisibility(decor.getSystemUiVisibility() | 0x10);
        }
        if (a.hasValue(51)) {
            int mode = a.getInt(51, -1);
            if (mode < 0 || mode > 2) {
                throw new UnsupportedOperationException("Unknown windowLayoutInDisplayCutoutMode: " + a.getString(51));
            }
            params.layoutInDisplayCutoutMode = mode;
        }
        if ((this.mAlwaysReadCloseOnTouchAttr || this.getContext().getApplicationInfo().targetSdkVersion >= 11) && a.getBoolean(21, false)) {
            this.setCloseOnTouchOutsideIfNotSet(true);
        }
        if (!this.hasSoftInputMode()) {
            params.softInputMode = a.getInt(13, params.softInputMode);
        }
        if (a.getBoolean(11, this.mIsFloating)) {
            if ((this.getForcedWindowFlags() & 2) == 0) {
                params.flags |= 2;
            }
            if (!this.haveDimAmount()) {
                params.dimAmount = a.getFloat(0, 0.5f);
            }
        }
        if (params.windowAnimations == 0) {
            params.windowAnimations = a.getResourceId(8, 0);
        }
        if (this.getContainer() == null) {
            if (this.mBackgroundDrawable == null) {
                if (this.mBackgroundResource == 0) {
                    this.mBackgroundResource = a.getResourceId(1, 0);
                }
                if (this.mFrameResource == 0) {
                    this.mFrameResource = a.getResourceId(2, 0);
                }
                this.mBackgroundFallbackResource = a.getResourceId(47, 0);
            }
            if (this.mLoadElevation) {
                this.mElevation = a.getDimension(38, 0.0f);
            }
            this.mClipToOutline = a.getBoolean(39, false);
            this.mTextColor = a.getColor(7, 0);
        }
        if (((features = this.getLocalFeatures()) & 0x800) != 0) {
            layoutResource = 17367262;
            this.setCloseOnSwipeEnabled(true);
        } else if ((features & 0x18) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891366, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367264;
            }
            this.removeFeature(8);
        } else if ((features & 0x24) != 0 && (features & 0x100) == 0) {
            layoutResource = 17367259;
        } else if ((features & 0x80) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891363, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367258;
            }
            this.removeFeature(8);
        } else if ((features & 2) == 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891365, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = (features & 0x100) != 0 ? a.getResourceId(52, 17367257) : 17367263;
            }
        } else {
            layoutResource = (features & 0x400) != 0 ? 17367261 : 17367260;
        }
        this.mDecor.startChanging();
        this.mDecor.onResourcesLoaded(this.mLayoutInflater, layoutResource);
        ViewGroup contentParent = (ViewGroup)this.findViewById(0x1020002);
        if (contentParent == null) {
            throw new RuntimeException("Window couldn't find content container view");
        }
        if ((features & 0x20) != 0 && (progress = this.getCircularProgressBar(false)) != null) {
            progress.setIndeterminate(true);
        }
        if ((features & 0x800) != 0) {
            this.registerSwipeCallbacks(contentParent);
        }
        if (this.getContainer() == null) {
            Drawable background = this.mBackgroundResource != 0 ? this.getContext().getDrawable(this.mBackgroundResource) : this.mBackgroundDrawable;
            this.mDecor.setWindowBackground(background);
            Drawable frame = this.mFrameResource != 0 ? this.getContext().getDrawable(this.mFrameResource) : null;
            this.mDecor.setWindowFrame(frame);
            this.mDecor.setElevation(this.mElevation);
            this.mDecor.setClipToOutline(this.mClipToOutline);
            if (this.mTitle != null) {
                this.setTitle(this.mTitle);
            }
            if (this.mTitleColor == 0) {
                this.mTitleColor = this.mTextColor;
            }
            this.setTitleColor(this.mTitleColor);
        }
        this.mDecor.finishChanging();
        return contentParent;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$alwaysReadCloseOnTouchAttr() {
        this.mAlwaysReadCloseOnTouchAttr = true;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$installDecor() {
        this.mForceDecorInstall = false;
        if (this.mDecor == null) {
            this.mDecor = this.generateDecor(-1);
            this.mDecor.setDescendantFocusability(262144);
            this.mDecor.setIsRootNamespace(true);
            if (!this.mInvalidatePanelMenuPosted && this.mInvalidatePanelMenuFeatures != 0) {
                this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            }
        } else {
            this.mDecor.setWindow(this);
        }
        if (this.mContentParent == null) {
            this.mContentParent = this.generateLayout(this.mDecor);
            this.mDecor.makeOptionalFitsSystemWindows();
            DecorContentParent decorContentParent = (DecorContentParent)this.mDecor.findViewById(16908835);
            if (decorContentParent != null) {
                this.mDecorContentParent = decorContentParent;
                this.mDecorContentParent.setWindowCallback(this.getCallback());
                if (this.mDecorContentParent.getTitle() == null) {
                    this.mDecorContentParent.setWindowTitle(this.mTitle);
                }
                int localFeatures = this.getLocalFeatures();
                for (int i = 0; i < 13; ++i) {
                    if ((localFeatures & 1 << i) == 0) continue;
                    this.mDecorContentParent.initFeature(i);
                }
                this.mDecorContentParent.setUiOptions(this.mUiOptions);
                if ((this.mResourcesSetFlags & 1) != 0 || this.mIconRes != 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.mIconRes);
                } else if ((this.mResourcesSetFlags & 1) == 0 && this.mIconRes == 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                    this.mResourcesSetFlags |= 4;
                }
                if ((this.mResourcesSetFlags & 2) != 0 || this.mLogoRes != 0 && !this.mDecorContentParent.hasLogo()) {
                    this.mDecorContentParent.setLogo(this.mLogoRes);
                }
                PanelFeatureState st = this.getPanelState(0, false);
                if (!(this.isDestroyed() || st != null && st.menu != null || this.mIsStartingWindow)) {
                    this.invalidatePanelMenu(8);
                }
            } else {
                this.mTitleView = (TextView)this.findViewById(16908310);
                if (this.mTitleView != null) {
                    if ((this.getLocalFeatures() & 2) != 0) {
                        Object titleContainer = this.findViewById(16909415);
                        if (titleContainer != null) {
                            ((View)titleContainer).setVisibility(8);
                        } else {
                            this.mTitleView.setVisibility(8);
                        }
                        this.mContentParent.setForeground(null);
                    } else {
                        this.mTitleView.setText(this.mTitle);
                    }
                }
            }
            if (this.mDecor.getBackground() == null && this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(this.mBackgroundFallbackResource);
            }
            if (this.hasFeature(13)) {
                if (this.mTransitionManager == null) {
                    int transitionRes = this.getWindowStyle().getResourceId(27, 0);
                    if (transitionRes != 0) {
                        TransitionInflater inflater = TransitionInflater.from(this.getContext());
                        this.mTransitionManager = inflater.inflateTransitionManager(transitionRes, this.mContentParent);
                    } else {
                        this.mTransitionManager = new TransitionManager();
                    }
                }
                this.mEnterTransition = this.getTransition(this.mEnterTransition, null, 28);
                this.mReturnTransition = this.getTransition(this.mReturnTransition, USE_DEFAULT_TRANSITION, 40);
                this.mExitTransition = this.getTransition(this.mExitTransition, null, 29);
                this.mReenterTransition = this.getTransition(this.mReenterTransition, USE_DEFAULT_TRANSITION, 41);
                this.mSharedElementEnterTransition = this.getTransition(this.mSharedElementEnterTransition, null, 30);
                this.mSharedElementReturnTransition = this.getTransition(this.mSharedElementReturnTransition, USE_DEFAULT_TRANSITION, 42);
                this.mSharedElementExitTransition = this.getTransition(this.mSharedElementExitTransition, null, 31);
                this.mSharedElementReenterTransition = this.getTransition(this.mSharedElementReenterTransition, USE_DEFAULT_TRANSITION, 43);
                if (this.mAllowEnterTransitionOverlap == null) {
                    this.mAllowEnterTransitionOverlap = this.getWindowStyle().getBoolean(33, true);
                }
                if (this.mAllowReturnTransitionOverlap == null) {
                    this.mAllowReturnTransitionOverlap = this.getWindowStyle().getBoolean(32, true);
                }
                if (this.mBackgroundFadeDurationMillis < 0L) {
                    this.mBackgroundFadeDurationMillis = this.getWindowStyle().getInteger(37, 300);
                }
                if (this.mSharedElementsUseOverlay == null) {
                    this.mSharedElementsUseOverlay = this.getWindowStyle().getBoolean(44, true);
                }
            }
        }
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getTransition(Transition currentValue, Transition defaultValue, int id2) {
        TransitionInflater inflater;
        if (currentValue != defaultValue) {
            return currentValue;
        }
        int transitionId = this.getWindowStyle().getResourceId(id2, -1);
        Transition transition2 = defaultValue;
        if (transitionId != -1 && transitionId != 0x10F0000 && (transition2 = (inflater = TransitionInflater.from(this.getContext())).inflateTransition(transitionId)) instanceof TransitionSet && ((TransitionSet)transition2).getTransitionCount() == 0) {
            transition2 = null;
        }
        return transition2;
    }

    private final Drawable $$robo$$com_android_internal_policy_PhoneWindow$loadImageURI(Uri uri) {
        try {
            return Drawable.createFromStream(this.getContext().getContentResolver().openInputStream(uri), null);
        }
        catch (Exception e) {
            Log.w("PhoneWindow", "Unable to open content: " + uri);
            return null;
        }
    }

    private final DrawableFeatureState $$robo$$com_android_internal_policy_PhoneWindow$getDrawableState(int featureId, boolean required) {
        DrawableFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        DrawableFeatureState[] ar = this.mDrawables;
        if (this.mDrawables == null || ar.length <= featureId) {
            DrawableFeatureState[] nar = new DrawableFeatureState[featureId + 1];
            if (ar != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ar, (int)0, (Object)nar, (int)0, (int)ar.length);
            }
            ar = nar;
            this.mDrawables = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new DrawableFeatureState(featureId);
        }
        return st;
    }

    private final PanelFeatureState $$robo$$com_android_internal_policy_PhoneWindow$getPanelState(int featureId, boolean required) {
        return this.getPanelState(featureId, required, null);
    }

    private final PanelFeatureState $$robo$$com_android_internal_policy_PhoneWindow$getPanelState(int featureId, boolean required, PanelFeatureState convertPanelState) {
        PanelFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)ar, (int)0, (Object)nar, (int)0, (int)ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            st = convertPanelState != null ? convertPanelState : new PanelFeatureState(featureId);
            ar[featureId] = st;
        }
        return st;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setChildDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.child = drawable2;
        this.updateDrawable(featureId, st, false);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setChildInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isShortcutKey(int keyCode, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(0, false);
        return st != null && st.menu != null && st.menu.isShortcutKey(keyCode, event);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$updateDrawable(int featureId, DrawableFeatureState st, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        Drawable drawable2 = null;
        if (st != null) {
            drawable2 = st.child;
            if (drawable2 == null) {
                drawable2 = st.local;
            }
            if (drawable2 == null) {
                drawable2 = st.def;
            }
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null && (this.isActive() || fromResume)) {
                this.getContainer().setChildDrawable(featureId, drawable2);
            }
        } else if (st != null && (st.cur != drawable2 || st.curAlpha != st.alpha)) {
            st.cur = drawable2;
            st.curAlpha = st.alpha;
            this.onDrawableChanged(featureId, drawable2, st.alpha);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$updateInt(int featureId, int value, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null) {
                this.getContainer().setChildInt(featureId, value);
            }
        } else {
            this.onIntChanged(featureId, value);
        }
    }

    private final ImageView $$robo$$com_android_internal_policy_PhoneWindow$getLeftIconView() {
        if (this.mLeftIconView != null) {
            return this.mLeftIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mLeftIconView = (ImageView)this.findViewById(16909024);
        return this.mLeftIconView;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$dispatchWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        super.dispatchWindowAttributesChanged(attrs);
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, true);
        }
    }

    private final ProgressBar $$robo$$com_android_internal_policy_PhoneWindow$getCircularProgressBar(boolean shouldInstallDecor) {
        if (this.mCircularProgressBar != null) {
            return this.mCircularProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mCircularProgressBar = (ProgressBar)this.findViewById(16909205);
        if (this.mCircularProgressBar != null) {
            this.mCircularProgressBar.setVisibility(4);
        }
        return this.mCircularProgressBar;
    }

    private final ProgressBar $$robo$$com_android_internal_policy_PhoneWindow$getHorizontalProgressBar(boolean shouldInstallDecor) {
        if (this.mHorizontalProgressBar != null) {
            return this.mHorizontalProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mHorizontalProgressBar = (ProgressBar)this.findViewById(16909206);
        if (this.mHorizontalProgressBar != null) {
            this.mHorizontalProgressBar.setVisibility(4);
        }
        return this.mHorizontalProgressBar;
    }

    private final ImageView $$robo$$com_android_internal_policy_PhoneWindow$getRightIconView() {
        if (this.mRightIconView != null) {
            return this.mRightIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mRightIconView = (ImageView)this.findViewById(16909239);
        return this.mRightIconView;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$registerSwipeCallbacks(ViewGroup contentParent) {
        if (!(contentParent instanceof SwipeDismissLayout)) {
            Log.w("PhoneWindow", "contentParent is not a SwipeDismissLayout: " + contentParent);
            return;
        }
        SwipeDismissLayout swipeDismiss = (SwipeDismissLayout)contentParent;
        swipeDismiss.setOnDismissedListener(new SwipeDismissLayout.OnDismissedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneWindow this$0;

            private void $$robo$$com_android_internal_policy_PhoneWindow_2$__constructor__(PhoneWindow this$0) {
            }

            private final void $$robo$$com_android_internal_policy_PhoneWindow_2$onDismissed(SwipeDismissLayout layout2) {
                this.this$0.dispatchOnWindowSwipeDismissed();
                this.this$0.dispatchOnWindowDismissed(false, true);
            }

            private void __constructor__(PhoneWindow phoneWindow) {
                this.$$robo$$com_android_internal_policy_PhoneWindow_2$__constructor__(phoneWindow);
            }
            {
                this.this$0 = phoneWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_2$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
            }

            @Override
            public void onDismissed(SwipeDismissLayout swipeDismissLayout) {
                InvokeDynamicSupport.bootstrap("onDismissed", $$robo$$com_android_internal_policy_PhoneWindow_2$onDismissed(com.android.internal.widget.SwipeDismissLayout ), 0, this, swipeDismissLayout);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        swipeDismiss.setOnSwipeProgressChangedListener(new SwipeDismissLayout.OnSwipeProgressChangedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneWindow this$0;

            private void $$robo$$com_android_internal_policy_PhoneWindow_3$__constructor__(PhoneWindow this$0) {
            }

            private final void $$robo$$com_android_internal_policy_PhoneWindow_3$onSwipeProgressChanged(SwipeDismissLayout layout2, float alpha, float translate) {
                WindowManager.LayoutParams newParams = this.this$0.getAttributes();
                newParams.x = (int)translate;
                newParams.alpha = alpha;
                this.this$0.setAttributes(newParams);
                int flags = 0;
                flags = newParams.x == 0 ? 1024 : 512;
                this.this$0.setFlags(flags, 1536);
            }

            private final void $$robo$$com_android_internal_policy_PhoneWindow_3$onSwipeCancelled(SwipeDismissLayout layout2) {
                WindowManager.LayoutParams newParams = this.this$0.getAttributes();
                if (newParams.x != 0 || newParams.alpha != 1.0f) {
                    newParams.x = 0;
                    newParams.alpha = 1.0f;
                    this.this$0.setAttributes(newParams);
                    this.this$0.setFlags(1024, 1536);
                }
            }

            private void __constructor__(PhoneWindow phoneWindow) {
                this.$$robo$$com_android_internal_policy_PhoneWindow_3$__constructor__(phoneWindow);
            }
            {
                this.this$0 = phoneWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_3$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
            }

            @Override
            public void onSwipeProgressChanged(SwipeDismissLayout swipeDismissLayout, float f, float f2) {
                InvokeDynamicSupport.bootstrap("onSwipeProgressChanged", $$robo$$com_android_internal_policy_PhoneWindow_3$onSwipeProgressChanged(com.android.internal.widget.SwipeDismissLayout float float ), 0, this, swipeDismissLayout, f, f2);
            }

            @Override
            public void onSwipeCancelled(SwipeDismissLayout swipeDismissLayout) {
                InvokeDynamicSupport.bootstrap("onSwipeCancelled", $$robo$$com_android_internal_policy_PhoneWindow_3$onSwipeCancelled(com.android.internal.widget.SwipeDismissLayout ), 0, this, swipeDismissLayout);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setCloseOnSwipeEnabled(boolean closeOnSwipeEnabled) {
        if (this.hasFeature(11) && this.mContentParent instanceof SwipeDismissLayout) {
            ((SwipeDismissLayout)this.mContentParent).setDismissable(closeOnSwipeEnabled);
        }
        super.setCloseOnSwipeEnabled(closeOnSwipeEnabled);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu2) {
        Window.Callback cb = this.getCallback();
        if (cb == null) {
            return;
        }
        if (menu2 == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu2 = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        if (!this.isDestroyed()) {
            cb.onPanelClosed(featureId, menu2);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$isTvUserSetupComplete() {
        boolean isTvSetupComplete = Settings.Secure.getInt(this.getContext().getContentResolver(), "user_setup_complete", 0) != 0;
        return isTvSetupComplete &= Settings.Secure.getInt(this.getContext().getContentResolver(), "tv_user_setup_complete", 0) != 0;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$launchDefaultSearch(KeyEvent event) {
        boolean result;
        if (this.getContext().getPackageManager().hasSystemFeature("android.software.leanback") && !this.isTvUserSetupComplete()) {
            return false;
        }
        Window.Callback cb = this.getCallback();
        if (cb == null || this.isDestroyed()) {
            result = false;
        } else {
            this.sendCloseSystemWindows("search");
            int deviceId = event.getDeviceId();
            SearchEvent searchEvent = null;
            if (deviceId != 0) {
                searchEvent = new SearchEvent(InputDevice.getDevice(deviceId));
            }
            try {
                result = cb.onSearchRequested(searchEvent);
            }
            catch (AbstractMethodError e) {
                Log.e("PhoneWindow", "WindowCallback " + cb.getClass().getName() + " does not implement method onSearchRequested(SearchEvent); fa", e);
                result = cb.onSearchRequested();
            }
        }
        if (!result && (this.getContext().getResources().getConfiguration().uiMode & 0xF) == 4) {
            Bundle args = new Bundle();
            args.putInt("android.intent.extra.ASSIST_INPUT_DEVICE_ID", event.getDeviceId());
            return ((SearchManager)this.getContext().getSystemService("search")).launchLegacyAssist(null, this.getContext().getUserId(), args);
        }
        return result;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setVolumeControlStream(int streamType) {
        this.mVolumeControlStreamType = streamType;
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getVolumeControlStream() {
        return this.mVolumeControlStreamType;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setMediaController(MediaController controller) {
        this.mMediaController = controller;
    }

    private final MediaController $$robo$$com_android_internal_policy_PhoneWindow$getMediaController() {
        return this.mMediaController;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setEnterTransition(Transition enterTransition) {
        this.mEnterTransition = enterTransition;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setReturnTransition(Transition transition2) {
        this.mReturnTransition = transition2;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setExitTransition(Transition exitTransition) {
        this.mExitTransition = exitTransition;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setReenterTransition(Transition transition2) {
        this.mReenterTransition = transition2;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementEnterTransition(Transition sharedElementEnterTransition) {
        this.mSharedElementEnterTransition = sharedElementEnterTransition;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementReturnTransition(Transition transition2) {
        this.mSharedElementReturnTransition = transition2;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementExitTransition(Transition sharedElementExitTransition) {
        this.mSharedElementExitTransition = sharedElementExitTransition;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementReenterTransition(Transition transition2) {
        this.mSharedElementReenterTransition = transition2;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getEnterTransition() {
        return this.mEnterTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getReturnTransition() {
        return this.mReturnTransition == USE_DEFAULT_TRANSITION ? this.getEnterTransition() : this.mReturnTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getExitTransition() {
        return this.mExitTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getReenterTransition() {
        return this.mReenterTransition == USE_DEFAULT_TRANSITION ? this.getExitTransition() : this.mReenterTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementEnterTransition() {
        return this.mSharedElementEnterTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementReturnTransition() {
        return this.mSharedElementReturnTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementEnterTransition() : this.mSharedElementReturnTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementExitTransition() {
        return this.mSharedElementExitTransition;
    }

    private final Transition $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementReenterTransition() {
        return this.mSharedElementReenterTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementExitTransition() : this.mSharedElementReenterTransition;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setAllowEnterTransitionOverlap(boolean allow) {
        this.mAllowEnterTransitionOverlap = allow;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$getAllowEnterTransitionOverlap() {
        return this.mAllowEnterTransitionOverlap == null ? true : this.mAllowEnterTransitionOverlap;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setAllowReturnTransitionOverlap(boolean allowExitTransitionOverlap) {
        this.mAllowReturnTransitionOverlap = allowExitTransitionOverlap;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$getAllowReturnTransitionOverlap() {
        return this.mAllowReturnTransitionOverlap == null ? true : this.mAllowReturnTransitionOverlap;
    }

    private final long $$robo$$com_android_internal_policy_PhoneWindow$getTransitionBackgroundFadeDuration() {
        return this.mBackgroundFadeDurationMillis < 0L ? 300L : this.mBackgroundFadeDurationMillis;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTransitionBackgroundFadeDuration(long fadeDurationMillis) {
        if (fadeDurationMillis < 0L) {
            throw new IllegalArgumentException("negative durations are not allowed");
        }
        this.mBackgroundFadeDurationMillis = fadeDurationMillis;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementsUseOverlay(boolean sharedElementsUseOverlay) {
        this.mSharedElementsUseOverlay = sharedElementsUseOverlay;
    }

    private final boolean $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementsUseOverlay() {
        return this.mSharedElementsUseOverlay == null ? true : this.mSharedElementsUseOverlay;
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getLocalFeaturesPrivate() {
        return super.getLocalFeatures();
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setDefaultWindowFormat(int format) {
        super.setDefaultWindowFormat(format);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), null);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows(String reason) {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), reason);
    }

    private static final void $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows(Context context, String reason) {
        if (ActivityManager.isSystemReady()) {
            try {
                ActivityManager.getService().closeSystemDialogs(reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getStatusBarColor() {
        return this.mStatusBarColor;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setStatusBarColor(int color2) {
        this.mStatusBarColor = color2;
        this.mForcedStatusBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getNavigationBarColor() {
        return this.mNavigationBarColor;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setNavigationBarColor(int color2) {
        this.mNavigationBarColor = color2;
        this.mForcedNavigationBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setNavigationBarDividerColor(int navigationBarDividerColor) {
        this.mNavigationBarDividerColor = navigationBarDividerColor;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getNavigationBarDividerColor() {
        return this.mNavigationBarDividerColor;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setIsStartingWindow(boolean isStartingWindow) {
        this.mIsStartingWindow = isStartingWindow;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setTheme(int resid) {
        Context context;
        this.mTheme = resid;
        if (this.mDecor != null && (context = this.mDecor.getContext()) instanceof DecorContext) {
            context.setTheme(resid);
        }
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setResizingCaptionDrawable(Drawable drawable2) {
        this.mDecor.setUserCaptionBackgroundDrawable(drawable2);
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setDecorCaptionShade(int decorCaptionShade) {
        this.mDecorCaptionShade = decorCaptionShade;
        if (this.mDecor != null) {
            this.mDecor.updateDecorCaptionShade();
        }
    }

    private final int $$robo$$com_android_internal_policy_PhoneWindow$getDecorCaptionShade() {
        return this.mDecorCaptionShade;
    }

    private final void $$robo$$com_android_internal_policy_PhoneWindow$setAttributes(WindowManager.LayoutParams params) {
        super.setAttributes(params);
        if (this.mDecor != null) {
            this.mDecor.updateLogTag(params);
        }
    }

    static void __staticInitializer__() {
        USE_DEFAULT_TRANSITION = new TransitionSet();
        sRotationWatcher = new RotationWatcher();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_policy_PhoneWindow$__constructor__(context);
    }

    public PhoneWindow(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, Window window, ViewRootImpl.ActivityConfigCallback activityConfigCallback) {
        this.$$robo$$com_android_internal_policy_PhoneWindow$__constructor__(context, window, activityConfigCallback);
    }

    public PhoneWindow(Context context, Window window, ViewRootImpl.ActivityConfigCallback activityConfigCallback) {
        this(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow$__constructor__(android.content.Context android.view.Window android.view.ViewRootImpl$ActivityConfigCallback ), 0, this, context, window, activityConfigCallback);
    }

    @Override
    public void setContainer(Window window) {
        InvokeDynamicSupport.bootstrap("setContainer", $$robo$$com_android_internal_policy_PhoneWindow$setContainer(android.view.Window ), 0, this, window);
    }

    @Override
    public boolean requestFeature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestFeature", $$robo$$com_android_internal_policy_PhoneWindow$requestFeature(int ), 0, this, n);
    }

    @Override
    public void setUiOptions(int n) {
        InvokeDynamicSupport.bootstrap("setUiOptions", $$robo$$com_android_internal_policy_PhoneWindow$setUiOptions(int ), 0, this, n);
    }

    @Override
    public void setUiOptions(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setUiOptions", $$robo$$com_android_internal_policy_PhoneWindow$setUiOptions(int int ), 0, this, n, n2);
    }

    @Override
    public TransitionManager getTransitionManager() {
        return InvokeDynamicSupport.bootstrap("getTransitionManager", $$robo$$com_android_internal_policy_PhoneWindow$getTransitionManager(), 0, this);
    }

    @Override
    public void setTransitionManager(TransitionManager transitionManager) {
        InvokeDynamicSupport.bootstrap("setTransitionManager", $$robo$$com_android_internal_policy_PhoneWindow$setTransitionManager(android.transition.TransitionManager ), 0, this, transitionManager);
    }

    @Override
    public Scene getContentScene() {
        return InvokeDynamicSupport.bootstrap("getContentScene", $$robo$$com_android_internal_policy_PhoneWindow$getContentScene(), 0, this);
    }

    @Override
    public void setContentView(int n) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$com_android_internal_policy_PhoneWindow$setContentView(int ), 0, this, n);
    }

    @Override
    public void setContentView(View view) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$com_android_internal_policy_PhoneWindow$setContentView(android.view.View ), 0, this, view);
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$com_android_internal_policy_PhoneWindow$setContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addContentView", $$robo$$com_android_internal_policy_PhoneWindow$addContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    @Override
    public void clearContentView() {
        InvokeDynamicSupport.bootstrap("clearContentView", $$robo$$com_android_internal_policy_PhoneWindow$clearContentView(), 0, this);
    }

    private void transitionTo(Scene scene) {
        InvokeDynamicSupport.bootstrap("transitionTo", $$robo$$com_android_internal_policy_PhoneWindow$transitionTo(android.transition.Scene ), 0, this, scene);
    }

    @Override
    public View getCurrentFocus() {
        return InvokeDynamicSupport.bootstrap("getCurrentFocus", $$robo$$com_android_internal_policy_PhoneWindow$getCurrentFocus(), 0, this);
    }

    @Override
    public void takeSurface(SurfaceHolder.Callback2 callback2) {
        InvokeDynamicSupport.bootstrap("takeSurface", $$robo$$com_android_internal_policy_PhoneWindow$takeSurface(android.view.SurfaceHolder$Callback2 ), 0, this, callback2);
    }

    @Override
    public void takeInputQueue(InputQueue.Callback callback) {
        InvokeDynamicSupport.bootstrap("takeInputQueue", $$robo$$com_android_internal_policy_PhoneWindow$takeInputQueue(android.view.InputQueue$Callback ), 0, this, callback);
    }

    @Override
    public boolean isFloating() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFloating", $$robo$$com_android_internal_policy_PhoneWindow$isFloating(), 0, this);
    }

    public boolean isTranslucent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTranslucent", $$robo$$com_android_internal_policy_PhoneWindow$isTranslucent(), 0, this);
    }

    boolean isShowingWallpaper() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingWallpaper", $$robo$$com_android_internal_policy_PhoneWindow$isShowingWallpaper(), 0, this);
    }

    @Override
    public LayoutInflater getLayoutInflater() {
        return InvokeDynamicSupport.bootstrap("getLayoutInflater", $$robo$$com_android_internal_policy_PhoneWindow$getLayoutInflater(), 0, this);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_policy_PhoneWindow$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setTitle(CharSequence charSequence, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_policy_PhoneWindow$setTitle(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    @Override
    @Deprecated
    public void setTitleColor(int n) {
        InvokeDynamicSupport.bootstrap("setTitleColor", $$robo$$com_android_internal_policy_PhoneWindow$setTitleColor(int ), 0, this, n);
    }

    public boolean preparePanel(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("preparePanel", $$robo$$com_android_internal_policy_PhoneWindow$preparePanel(com.android.internal.policy.PhoneWindow$PanelFeatureState android.view.KeyEvent ), 0, this, panelFeatureState, keyEvent);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_policy_PhoneWindow$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public void onMultiWindowModeChanged() {
        InvokeDynamicSupport.bootstrap("onMultiWindowModeChanged", $$robo$$com_android_internal_policy_PhoneWindow$onMultiWindowModeChanged(), 0, this);
    }

    @Override
    public void onPictureInPictureModeChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onPictureInPictureModeChanged", $$robo$$com_android_internal_policy_PhoneWindow$onPictureInPictureModeChanged(boolean ), 0, this, bl);
    }

    @Override
    public void reportActivityRelaunched() {
        InvokeDynamicSupport.bootstrap("reportActivityRelaunched", $$robo$$com_android_internal_policy_PhoneWindow$reportActivityRelaunched(), 0, this);
    }

    private static void clearMenuViews(PanelFeatureState panelFeatureState) {
        InvokeDynamicSupport.bootstrapStatic("clearMenuViews", $$robo$$com_android_internal_policy_PhoneWindow$clearMenuViews(com.android.internal.policy.PhoneWindow$PanelFeatureState ), 0, (PanelFeatureState)panelFeatureState);
    }

    @Override
    public void openPanel(int n, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("openPanel", $$robo$$com_android_internal_policy_PhoneWindow$openPanel(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private void openPanel(PanelFeatureState panelFeatureState, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("openPanel", $$robo$$com_android_internal_policy_PhoneWindow$openPanel(com.android.internal.policy.PhoneWindow$PanelFeatureState android.view.KeyEvent ), 0, this, panelFeatureState, keyEvent);
    }

    @Override
    public void closePanel(int n) {
        InvokeDynamicSupport.bootstrap("closePanel", $$robo$$com_android_internal_policy_PhoneWindow$closePanel(int ), 0, this, n);
    }

    public void closePanel(PanelFeatureState panelFeatureState, boolean bl) {
        InvokeDynamicSupport.bootstrap("closePanel", $$robo$$com_android_internal_policy_PhoneWindow$closePanel(com.android.internal.policy.PhoneWindow$PanelFeatureState boolean ), 0, this, panelFeatureState, bl);
    }

    void checkCloseActionMenu(Menu menu2) {
        InvokeDynamicSupport.bootstrap("checkCloseActionMenu", $$robo$$com_android_internal_policy_PhoneWindow$checkCloseActionMenu(android.view.Menu ), 0, this, menu2);
    }

    @Override
    public void togglePanel(int n, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("togglePanel", $$robo$$com_android_internal_policy_PhoneWindow$togglePanel(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public void invalidatePanelMenu(int n) {
        InvokeDynamicSupport.bootstrap("invalidatePanelMenu", $$robo$$com_android_internal_policy_PhoneWindow$invalidatePanelMenu(int ), 0, this, n);
    }

    void doPendingInvalidatePanelMenu() {
        InvokeDynamicSupport.bootstrap("doPendingInvalidatePanelMenu", $$robo$$com_android_internal_policy_PhoneWindow$doPendingInvalidatePanelMenu(), 0, this);
    }

    void doInvalidatePanelMenu(int n) {
        InvokeDynamicSupport.bootstrap("doInvalidatePanelMenu", $$robo$$com_android_internal_policy_PhoneWindow$doInvalidatePanelMenu(int ), 0, this, n);
    }

    public boolean onKeyDownPanel(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDownPanel", $$robo$$com_android_internal_policy_PhoneWindow$onKeyDownPanel(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public void onKeyUpPanel(int n, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("onKeyUpPanel", $$robo$$com_android_internal_policy_PhoneWindow$onKeyUpPanel(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public void closeAllPanels() {
        InvokeDynamicSupport.bootstrap("closeAllPanels", $$robo$$com_android_internal_policy_PhoneWindow$closeAllPanels(), 0, this);
    }

    private synchronized void closeContextMenu() {
        InvokeDynamicSupport.bootstrap("closeContextMenu", $$robo$$com_android_internal_policy_PhoneWindow$closeContextMenu(), 0, this);
    }

    private synchronized void dismissContextMenu() {
        InvokeDynamicSupport.bootstrap("dismissContextMenu", $$robo$$com_android_internal_policy_PhoneWindow$dismissContextMenu(), 0, this);
    }

    @Override
    public boolean performPanelShortcut(int n, int n2, KeyEvent keyEvent, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPanelShortcut", $$robo$$com_android_internal_policy_PhoneWindow$performPanelShortcut(int int android.view.KeyEvent int ), 0, this, n, n2, keyEvent, n3);
    }

    boolean performPanelShortcut(PanelFeatureState panelFeatureState, int n, KeyEvent keyEvent, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPanelShortcut", $$robo$$com_android_internal_policy_PhoneWindow$performPanelShortcut(com.android.internal.policy.PhoneWindow$PanelFeatureState int android.view.KeyEvent int ), 0, this, panelFeatureState, n, keyEvent, n2);
    }

    @Override
    public boolean performPanelIdentifierAction(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPanelIdentifierAction", $$robo$$com_android_internal_policy_PhoneWindow$performPanelIdentifierAction(int int int ), 0, this, n, n2, n3);
    }

    public PanelFeatureState findMenuPanel(Menu menu2) {
        return InvokeDynamicSupport.bootstrap("findMenuPanel", $$robo$$com_android_internal_policy_PhoneWindow$findMenuPanel(android.view.Menu ), 0, this, menu2);
    }

    @Override
    public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$com_android_internal_policy_PhoneWindow$onMenuItemSelected(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
    }

    @Override
    public void onMenuModeChange(MenuBuilder menuBuilder) {
        InvokeDynamicSupport.bootstrap("onMenuModeChange", $$robo$$com_android_internal_policy_PhoneWindow$onMenuModeChange(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
    }

    private void reopenMenu(boolean bl) {
        InvokeDynamicSupport.bootstrap("reopenMenu", $$robo$$com_android_internal_policy_PhoneWindow$reopenMenu(boolean ), 0, this, bl);
    }

    protected boolean initializePanelMenu(PanelFeatureState panelFeatureState) {
        return (boolean)InvokeDynamicSupport.bootstrap("initializePanelMenu", $$robo$$com_android_internal_policy_PhoneWindow$initializePanelMenu(com.android.internal.policy.PhoneWindow$PanelFeatureState ), 0, this, panelFeatureState);
    }

    protected boolean initializePanelDecor(PanelFeatureState panelFeatureState) {
        return (boolean)InvokeDynamicSupport.bootstrap("initializePanelDecor", $$robo$$com_android_internal_policy_PhoneWindow$initializePanelDecor(com.android.internal.policy.PhoneWindow$PanelFeatureState ), 0, this, panelFeatureState);
    }

    private int getOptionsPanelGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getOptionsPanelGravity", $$robo$$com_android_internal_policy_PhoneWindow$getOptionsPanelGravity(), 0, this);
    }

    void onOptionsPanelRotationChanged() {
        InvokeDynamicSupport.bootstrap("onOptionsPanelRotationChanged", $$robo$$com_android_internal_policy_PhoneWindow$onOptionsPanelRotationChanged(), 0, this);
    }

    protected boolean initializePanelContent(PanelFeatureState panelFeatureState) {
        return (boolean)InvokeDynamicSupport.bootstrap("initializePanelContent", $$robo$$com_android_internal_policy_PhoneWindow$initializePanelContent(com.android.internal.policy.PhoneWindow$PanelFeatureState ), 0, this, panelFeatureState);
    }

    @Override
    public boolean performContextMenuIdentifierAction(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("performContextMenuIdentifierAction", $$robo$$com_android_internal_policy_PhoneWindow$performContextMenuIdentifierAction(int int ), 0, this, n, n2);
    }

    @Override
    public void setElevation(float f) {
        InvokeDynamicSupport.bootstrap("setElevation", $$robo$$com_android_internal_policy_PhoneWindow$setElevation(float ), 0, this, f);
    }

    @Override
    public float getElevation() {
        return (float)InvokeDynamicSupport.bootstrap("getElevation", $$robo$$com_android_internal_policy_PhoneWindow$getElevation(), 0, this);
    }

    @Override
    public void setClipToOutline(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipToOutline", $$robo$$com_android_internal_policy_PhoneWindow$setClipToOutline(boolean ), 0, this, bl);
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$com_android_internal_policy_PhoneWindow$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setFeatureDrawableResource(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableResource", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableResource(int int ), 0, this, n, n2);
    }

    @Override
    public void setFeatureDrawableUri(int n, Uri uri) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableUri", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableUri(int android.net.Uri ), 0, this, n, uri);
    }

    @Override
    public void setFeatureDrawable(int n, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawable", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawable(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    @Override
    public void setFeatureDrawableAlpha(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFeatureDrawableAlpha", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDrawableAlpha(int int ), 0, this, n, n2);
    }

    protected void setFeatureDefaultDrawable(int n, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setFeatureDefaultDrawable", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureDefaultDrawable(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    @Override
    public void setFeatureInt(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setFeatureInt", $$robo$$com_android_internal_policy_PhoneWindow$setFeatureInt(int int ), 0, this, n, n2);
    }

    protected void updateDrawable(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateDrawable", $$robo$$com_android_internal_policy_PhoneWindow$updateDrawable(int boolean ), 0, this, n, bl);
    }

    protected void onDrawableChanged(int n, Drawable drawable2, int n2) {
        InvokeDynamicSupport.bootstrap("onDrawableChanged", $$robo$$com_android_internal_policy_PhoneWindow$onDrawableChanged(int android.graphics.drawable.Drawable int ), 0, this, n, drawable2, n2);
    }

    protected void onIntChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onIntChanged", $$robo$$com_android_internal_policy_PhoneWindow$onIntChanged(int int ), 0, this, n, n2);
    }

    private void updateProgressBars(int n) {
        InvokeDynamicSupport.bootstrap("updateProgressBars", $$robo$$com_android_internal_policy_PhoneWindow$updateProgressBars(int ), 0, this, n);
    }

    private void showProgressBars(ProgressBar progressBar, ProgressBar progressBar2) {
        InvokeDynamicSupport.bootstrap("showProgressBars", $$robo$$com_android_internal_policy_PhoneWindow$showProgressBars(android.widget.ProgressBar android.widget.ProgressBar ), 0, this, progressBar, progressBar2);
    }

    private void hideProgressBars(ProgressBar progressBar, ProgressBar progressBar2) {
        InvokeDynamicSupport.bootstrap("hideProgressBars", $$robo$$com_android_internal_policy_PhoneWindow$hideProgressBars(android.widget.ProgressBar android.widget.ProgressBar ), 0, this, progressBar, progressBar2);
    }

    @Override
    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_policy_PhoneWindow$setIcon(int ), 0, this, n);
    }

    @Override
    public void setDefaultIcon(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultIcon", $$robo$$com_android_internal_policy_PhoneWindow$setDefaultIcon(int ), 0, this, n);
    }

    @Override
    public void setLogo(int n) {
        InvokeDynamicSupport.bootstrap("setLogo", $$robo$$com_android_internal_policy_PhoneWindow$setLogo(int ), 0, this, n);
    }

    @Override
    public void setDefaultLogo(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultLogo", $$robo$$com_android_internal_policy_PhoneWindow$setDefaultLogo(int ), 0, this, n);
    }

    @Override
    public void setLocalFocus(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setLocalFocus", $$robo$$com_android_internal_policy_PhoneWindow$setLocalFocus(boolean boolean ), 0, this, bl, bl2);
    }

    @Override
    public void injectInputEvent(InputEvent inputEvent) {
        InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$com_android_internal_policy_PhoneWindow$injectInputEvent(android.view.InputEvent ), 0, this, inputEvent);
    }

    private ViewRootImpl getViewRootImpl() {
        return InvokeDynamicSupport.bootstrap("getViewRootImpl", $$robo$$com_android_internal_policy_PhoneWindow$getViewRootImpl(), 0, this);
    }

    @Override
    public void takeKeyEvents(boolean bl) {
        InvokeDynamicSupport.bootstrap("takeKeyEvents", $$robo$$com_android_internal_policy_PhoneWindow$takeKeyEvents(boolean ), 0, this, bl);
    }

    @Override
    public boolean superDispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchKeyEvent", $$robo$$com_android_internal_policy_PhoneWindow$superDispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean superDispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchKeyShortcutEvent", $$robo$$com_android_internal_policy_PhoneWindow$superDispatchKeyShortcutEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean superDispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchTouchEvent", $$robo$$com_android_internal_policy_PhoneWindow$superDispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean superDispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchTrackballEvent", $$robo$$com_android_internal_policy_PhoneWindow$superDispatchTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean superDispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchGenericMotionEvent", $$robo$$com_android_internal_policy_PhoneWindow$superDispatchGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    protected boolean onKeyDown(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_policy_PhoneWindow$onKeyDown(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    private KeyguardManager getKeyguardManager() {
        return InvokeDynamicSupport.bootstrap("getKeyguardManager", $$robo$$com_android_internal_policy_PhoneWindow$getKeyguardManager(), 0, this);
    }

    AudioManager getAudioManager() {
        return InvokeDynamicSupport.bootstrap("getAudioManager", $$robo$$com_android_internal_policy_PhoneWindow$getAudioManager(), 0, this);
    }

    private MediaSessionManager getMediaSessionManager() {
        return InvokeDynamicSupport.bootstrap("getMediaSessionManager", $$robo$$com_android_internal_policy_PhoneWindow$getMediaSessionManager(), 0, this);
    }

    protected boolean onKeyUp(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_policy_PhoneWindow$onKeyUp(int int android.view.KeyEvent ), 0, this, n, n2, keyEvent);
    }

    private boolean isNotInstantAppAndKeyguardRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotInstantAppAndKeyguardRestricted", $$robo$$com_android_internal_policy_PhoneWindow$isNotInstantAppAndKeyguardRestricted(), 0, this);
    }

    @Override
    protected void onActive() {
        InvokeDynamicSupport.bootstrap("onActive", $$robo$$com_android_internal_policy_PhoneWindow$onActive(), 0, this);
    }

    @Override
    public View getDecorView() {
        return InvokeDynamicSupport.bootstrap("getDecorView", $$robo$$com_android_internal_policy_PhoneWindow$getDecorView(), 0, this);
    }

    @Override
    public View peekDecorView() {
        return InvokeDynamicSupport.bootstrap("peekDecorView", $$robo$$com_android_internal_policy_PhoneWindow$peekDecorView(), 0, this);
    }

    void onViewRootImplSet(ViewRootImpl viewRootImpl) {
        InvokeDynamicSupport.bootstrap("onViewRootImplSet", $$robo$$com_android_internal_policy_PhoneWindow$onViewRootImplSet(android.view.ViewRootImpl ), 0, this, viewRootImpl);
    }

    @Override
    public Bundle saveHierarchyState() {
        return InvokeDynamicSupport.bootstrap("saveHierarchyState", $$robo$$com_android_internal_policy_PhoneWindow$saveHierarchyState(), 0, this);
    }

    @Override
    public void restoreHierarchyState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("restoreHierarchyState", $$robo$$com_android_internal_policy_PhoneWindow$restoreHierarchyState(android.os.Bundle ), 0, this, bundle);
    }

    private void savePanelState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("savePanelState", $$robo$$com_android_internal_policy_PhoneWindow$savePanelState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    private void restorePanelState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("restorePanelState", $$robo$$com_android_internal_policy_PhoneWindow$restorePanelState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    void openPanelsAfterRestore() {
        InvokeDynamicSupport.bootstrap("openPanelsAfterRestore", $$robo$$com_android_internal_policy_PhoneWindow$openPanelsAfterRestore(), 0, this);
    }

    protected DecorView generateDecor(int n) {
        return InvokeDynamicSupport.bootstrap("generateDecor", $$robo$$com_android_internal_policy_PhoneWindow$generateDecor(int ), 0, this, n);
    }

    protected ViewGroup generateLayout(DecorView decorView) {
        return InvokeDynamicSupport.bootstrap("generateLayout", $$robo$$com_android_internal_policy_PhoneWindow$generateLayout(com.android.internal.policy.DecorView ), 0, this, decorView);
    }

    @Override
    public void alwaysReadCloseOnTouchAttr() {
        InvokeDynamicSupport.bootstrap("alwaysReadCloseOnTouchAttr", $$robo$$com_android_internal_policy_PhoneWindow$alwaysReadCloseOnTouchAttr(), 0, this);
    }

    private void installDecor() {
        InvokeDynamicSupport.bootstrap("installDecor", $$robo$$com_android_internal_policy_PhoneWindow$installDecor(), 0, this);
    }

    private Transition getTransition(Transition transition2, Transition transition3, int n) {
        return InvokeDynamicSupport.bootstrap("getTransition", $$robo$$com_android_internal_policy_PhoneWindow$getTransition(android.transition.Transition android.transition.Transition int ), 0, this, transition2, transition3, n);
    }

    private Drawable loadImageURI(Uri uri) {
        return InvokeDynamicSupport.bootstrap("loadImageURI", $$robo$$com_android_internal_policy_PhoneWindow$loadImageURI(android.net.Uri ), 0, this, uri);
    }

    private DrawableFeatureState getDrawableState(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getDrawableState", $$robo$$com_android_internal_policy_PhoneWindow$getDrawableState(int boolean ), 0, this, n, bl);
    }

    PanelFeatureState getPanelState(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPanelState", $$robo$$com_android_internal_policy_PhoneWindow$getPanelState(int boolean ), 0, this, n, bl);
    }

    private PanelFeatureState getPanelState(int n, boolean bl, PanelFeatureState panelFeatureState) {
        return InvokeDynamicSupport.bootstrap("getPanelState", $$robo$$com_android_internal_policy_PhoneWindow$getPanelState(int boolean com.android.internal.policy.PhoneWindow$PanelFeatureState ), 0, this, n, bl, panelFeatureState);
    }

    @Override
    public void setChildDrawable(int n, Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setChildDrawable", $$robo$$com_android_internal_policy_PhoneWindow$setChildDrawable(int android.graphics.drawable.Drawable ), 0, this, n, drawable2);
    }

    @Override
    public void setChildInt(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setChildInt", $$robo$$com_android_internal_policy_PhoneWindow$setChildInt(int int ), 0, this, n, n2);
    }

    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("isShortcutKey", $$robo$$com_android_internal_policy_PhoneWindow$isShortcutKey(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private void updateDrawable(int n, DrawableFeatureState drawableFeatureState, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateDrawable", $$robo$$com_android_internal_policy_PhoneWindow$updateDrawable(int com.android.internal.policy.PhoneWindow$DrawableFeatureState boolean ), 0, this, n, drawableFeatureState, bl);
    }

    private void updateInt(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateInt", $$robo$$com_android_internal_policy_PhoneWindow$updateInt(int int boolean ), 0, this, n, n2, bl);
    }

    private ImageView getLeftIconView() {
        return InvokeDynamicSupport.bootstrap("getLeftIconView", $$robo$$com_android_internal_policy_PhoneWindow$getLeftIconView(), 0, this);
    }

    @Override
    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("dispatchWindowAttributesChanged", $$robo$$com_android_internal_policy_PhoneWindow$dispatchWindowAttributesChanged(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    private ProgressBar getCircularProgressBar(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getCircularProgressBar", $$robo$$com_android_internal_policy_PhoneWindow$getCircularProgressBar(boolean ), 0, this, bl);
    }

    private ProgressBar getHorizontalProgressBar(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getHorizontalProgressBar", $$robo$$com_android_internal_policy_PhoneWindow$getHorizontalProgressBar(boolean ), 0, this, bl);
    }

    private ImageView getRightIconView() {
        return InvokeDynamicSupport.bootstrap("getRightIconView", $$robo$$com_android_internal_policy_PhoneWindow$getRightIconView(), 0, this);
    }

    private void registerSwipeCallbacks(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("registerSwipeCallbacks", $$robo$$com_android_internal_policy_PhoneWindow$registerSwipeCallbacks(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    public void setCloseOnSwipeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCloseOnSwipeEnabled", $$robo$$com_android_internal_policy_PhoneWindow$setCloseOnSwipeEnabled(boolean ), 0, this, bl);
    }

    private void callOnPanelClosed(int n, PanelFeatureState panelFeatureState, Menu menu2) {
        InvokeDynamicSupport.bootstrap("callOnPanelClosed", $$robo$$com_android_internal_policy_PhoneWindow$callOnPanelClosed(int com.android.internal.policy.PhoneWindow$PanelFeatureState android.view.Menu ), 0, this, n, panelFeatureState, menu2);
    }

    private boolean isTvUserSetupComplete() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTvUserSetupComplete", $$robo$$com_android_internal_policy_PhoneWindow$isTvUserSetupComplete(), 0, this);
    }

    private boolean launchDefaultSearch(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("launchDefaultSearch", $$robo$$com_android_internal_policy_PhoneWindow$launchDefaultSearch(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public void setVolumeControlStream(int n) {
        InvokeDynamicSupport.bootstrap("setVolumeControlStream", $$robo$$com_android_internal_policy_PhoneWindow$setVolumeControlStream(int ), 0, this, n);
    }

    @Override
    public int getVolumeControlStream() {
        return (int)InvokeDynamicSupport.bootstrap("getVolumeControlStream", $$robo$$com_android_internal_policy_PhoneWindow$getVolumeControlStream(), 0, this);
    }

    @Override
    public void setMediaController(MediaController mediaController) {
        InvokeDynamicSupport.bootstrap("setMediaController", $$robo$$com_android_internal_policy_PhoneWindow$setMediaController(android.media.session.MediaController ), 0, this, mediaController);
    }

    @Override
    public MediaController getMediaController() {
        return InvokeDynamicSupport.bootstrap("getMediaController", $$robo$$com_android_internal_policy_PhoneWindow$getMediaController(), 0, this);
    }

    @Override
    public void setEnterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setEnterTransition", $$robo$$com_android_internal_policy_PhoneWindow$setEnterTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setReturnTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setReturnTransition", $$robo$$com_android_internal_policy_PhoneWindow$setReturnTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setExitTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setExitTransition", $$robo$$com_android_internal_policy_PhoneWindow$setExitTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setReenterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setReenterTransition", $$robo$$com_android_internal_policy_PhoneWindow$setReenterTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setSharedElementEnterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementEnterTransition", $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementEnterTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setSharedElementReturnTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementReturnTransition", $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementReturnTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setSharedElementExitTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementExitTransition", $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementExitTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public void setSharedElementReenterTransition(Transition transition2) {
        InvokeDynamicSupport.bootstrap("setSharedElementReenterTransition", $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementReenterTransition(android.transition.Transition ), 0, this, transition2);
    }

    @Override
    public Transition getEnterTransition() {
        return InvokeDynamicSupport.bootstrap("getEnterTransition", $$robo$$com_android_internal_policy_PhoneWindow$getEnterTransition(), 0, this);
    }

    @Override
    public Transition getReturnTransition() {
        return InvokeDynamicSupport.bootstrap("getReturnTransition", $$robo$$com_android_internal_policy_PhoneWindow$getReturnTransition(), 0, this);
    }

    @Override
    public Transition getExitTransition() {
        return InvokeDynamicSupport.bootstrap("getExitTransition", $$robo$$com_android_internal_policy_PhoneWindow$getExitTransition(), 0, this);
    }

    @Override
    public Transition getReenterTransition() {
        return InvokeDynamicSupport.bootstrap("getReenterTransition", $$robo$$com_android_internal_policy_PhoneWindow$getReenterTransition(), 0, this);
    }

    @Override
    public Transition getSharedElementEnterTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementEnterTransition", $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementEnterTransition(), 0, this);
    }

    @Override
    public Transition getSharedElementReturnTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementReturnTransition", $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementReturnTransition(), 0, this);
    }

    @Override
    public Transition getSharedElementExitTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementExitTransition", $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementExitTransition(), 0, this);
    }

    @Override
    public Transition getSharedElementReenterTransition() {
        return InvokeDynamicSupport.bootstrap("getSharedElementReenterTransition", $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementReenterTransition(), 0, this);
    }

    @Override
    public void setAllowEnterTransitionOverlap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowEnterTransitionOverlap", $$robo$$com_android_internal_policy_PhoneWindow$setAllowEnterTransitionOverlap(boolean ), 0, this, bl);
    }

    @Override
    public boolean getAllowEnterTransitionOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowEnterTransitionOverlap", $$robo$$com_android_internal_policy_PhoneWindow$getAllowEnterTransitionOverlap(), 0, this);
    }

    @Override
    public void setAllowReturnTransitionOverlap(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowReturnTransitionOverlap", $$robo$$com_android_internal_policy_PhoneWindow$setAllowReturnTransitionOverlap(boolean ), 0, this, bl);
    }

    @Override
    public boolean getAllowReturnTransitionOverlap() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAllowReturnTransitionOverlap", $$robo$$com_android_internal_policy_PhoneWindow$getAllowReturnTransitionOverlap(), 0, this);
    }

    @Override
    public long getTransitionBackgroundFadeDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getTransitionBackgroundFadeDuration", $$robo$$com_android_internal_policy_PhoneWindow$getTransitionBackgroundFadeDuration(), 0, this);
    }

    @Override
    public void setTransitionBackgroundFadeDuration(long l) {
        InvokeDynamicSupport.bootstrap("setTransitionBackgroundFadeDuration", $$robo$$com_android_internal_policy_PhoneWindow$setTransitionBackgroundFadeDuration(long ), 0, this, l);
    }

    @Override
    public void setSharedElementsUseOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSharedElementsUseOverlay", $$robo$$com_android_internal_policy_PhoneWindow$setSharedElementsUseOverlay(boolean ), 0, this, bl);
    }

    @Override
    public boolean getSharedElementsUseOverlay() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSharedElementsUseOverlay", $$robo$$com_android_internal_policy_PhoneWindow$getSharedElementsUseOverlay(), 0, this);
    }

    int getLocalFeaturesPrivate() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalFeaturesPrivate", $$robo$$com_android_internal_policy_PhoneWindow$getLocalFeaturesPrivate(), 0, this);
    }

    @Override
    protected void setDefaultWindowFormat(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultWindowFormat", $$robo$$com_android_internal_policy_PhoneWindow$setDefaultWindowFormat(int ), 0, this, n);
    }

    void sendCloseSystemWindows() {
        InvokeDynamicSupport.bootstrap("sendCloseSystemWindows", $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows(), 0, this);
    }

    void sendCloseSystemWindows(String string2) {
        InvokeDynamicSupport.bootstrap("sendCloseSystemWindows", $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows(java.lang.String ), 0, this, string2);
    }

    public static void sendCloseSystemWindows(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("sendCloseSystemWindows", $$robo$$com_android_internal_policy_PhoneWindow$sendCloseSystemWindows(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    @Override
    public int getStatusBarColor() {
        return (int)InvokeDynamicSupport.bootstrap("getStatusBarColor", $$robo$$com_android_internal_policy_PhoneWindow$getStatusBarColor(), 0, this);
    }

    @Override
    public void setStatusBarColor(int n) {
        InvokeDynamicSupport.bootstrap("setStatusBarColor", $$robo$$com_android_internal_policy_PhoneWindow$setStatusBarColor(int ), 0, this, n);
    }

    @Override
    public int getNavigationBarColor() {
        return (int)InvokeDynamicSupport.bootstrap("getNavigationBarColor", $$robo$$com_android_internal_policy_PhoneWindow$getNavigationBarColor(), 0, this);
    }

    @Override
    public void setNavigationBarColor(int n) {
        InvokeDynamicSupport.bootstrap("setNavigationBarColor", $$robo$$com_android_internal_policy_PhoneWindow$setNavigationBarColor(int ), 0, this, n);
    }

    @Override
    public void setNavigationBarDividerColor(int n) {
        InvokeDynamicSupport.bootstrap("setNavigationBarDividerColor", $$robo$$com_android_internal_policy_PhoneWindow$setNavigationBarDividerColor(int ), 0, this, n);
    }

    @Override
    public int getNavigationBarDividerColor() {
        return (int)InvokeDynamicSupport.bootstrap("getNavigationBarDividerColor", $$robo$$com_android_internal_policy_PhoneWindow$getNavigationBarDividerColor(), 0, this);
    }

    public void setIsStartingWindow(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsStartingWindow", $$robo$$com_android_internal_policy_PhoneWindow$setIsStartingWindow(boolean ), 0, this, bl);
    }

    @Override
    public void setTheme(int n) {
        InvokeDynamicSupport.bootstrap("setTheme", $$robo$$com_android_internal_policy_PhoneWindow$setTheme(int ), 0, this, n);
    }

    @Override
    public void setResizingCaptionDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setResizingCaptionDrawable", $$robo$$com_android_internal_policy_PhoneWindow$setResizingCaptionDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setDecorCaptionShade(int n) {
        InvokeDynamicSupport.bootstrap("setDecorCaptionShade", $$robo$$com_android_internal_policy_PhoneWindow$setDecorCaptionShade(int ), 0, this, n);
    }

    int getDecorCaptionShade() {
        return (int)InvokeDynamicSupport.bootstrap("getDecorCaptionShade", $$robo$$com_android_internal_policy_PhoneWindow$getDecorCaptionShade(), 0, this);
    }

    @Override
    public void setAttributes(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setAttributes", $$robo$$com_android_internal_policy_PhoneWindow$setAttributes(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    static {
        RobolectricInternals.classInitializing(PhoneWindow.class);
    }

    public /* synthetic */ PhoneWindow() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneWindow)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PhoneWindowMenuCallback
    implements MenuBuilder.Callback,
    MenuPresenter.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int FEATURE_ID = 6;
        private PhoneWindow mWindow;
        private MenuDialogHelper mSubMenuHelper;
        private boolean mShowDialogForSubmenu;

        private void $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$__constructor__(PhoneWindow window) {
            this.mWindow = window;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            if (menu2.getRootMenu() != menu2) {
                this.onCloseSubMenu(menu2);
            }
            if (allMenusAreClosing) {
                Window.Callback callback = this.mWindow.getCallback();
                if (callback != null && !this.mWindow.isDestroyed()) {
                    callback.onPanelClosed(6, menu2);
                }
                if (menu2 == this.mWindow.mContextMenu) {
                    this.mWindow.dismissContextMenu();
                }
                if (this.mSubMenuHelper != null) {
                    this.mSubMenuHelper.dismiss();
                    this.mSubMenuHelper = null;
                }
            }
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onCloseSubMenu(MenuBuilder menu2) {
            Window.Callback callback = this.mWindow.getCallback();
            if (callback != null && !this.mWindow.isDestroyed()) {
                callback.onPanelClosed(6, menu2.getRootMenu());
            }
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            Window.Callback callback = this.mWindow.getCallback();
            return callback != null && !this.mWindow.isDestroyed() && callback.onMenuItemSelected(6, item);
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onMenuModeChange(MenuBuilder menu2) {
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            subMenu.setCallback(this);
            if (this.mShowDialogForSubmenu) {
                this.mSubMenuHelper = new MenuDialogHelper(subMenu);
                this.mSubMenuHelper.show(null);
                return true;
            }
            return false;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$setShowDialogForSubmenu(boolean enabled) {
            this.mShowDialogForSubmenu = enabled;
        }

        private void __constructor__(PhoneWindow phoneWindow) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$__constructor__(phoneWindow);
        }

        public PhoneWindowMenuCallback(PhoneWindow phoneWindow) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
        }

        private void onCloseSubMenu(MenuBuilder menuBuilder) {
            InvokeDynamicSupport.bootstrap("onCloseSubMenu", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onCloseSubMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onMenuItemSelected(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            InvokeDynamicSupport.bootstrap("onMenuModeChange", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onMenuModeChange(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        public void setShowDialogForSubmenu(boolean bl) {
            InvokeDynamicSupport.bootstrap("setShowDialogForSubmenu", $$robo$$com_android_internal_policy_PhoneWindow_PhoneWindowMenuCallback$setShowDialogForSubmenu(boolean ), 0, this, bl);
        }

        public /* synthetic */ PhoneWindowMenuCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneWindowMenuCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RotationWatcher
    extends IRotationWatcher.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private Runnable mRotationChanged;
        private ArrayList<WeakReference<PhoneWindow>> mWindows;
        private boolean mIsWatching;

        private void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$__constructor__() {
            this.mRotationChanged = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ RotationWatcher this$0;

                private void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher_1$__constructor__(RotationWatcher this$0) {
                }

                private final void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher_1$run() {
                    this.this$0.dispatchRotationChanged();
                }

                private void __constructor__(RotationWatcher rotationWatcher) {
                    this.$$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher_1$__constructor__(rotationWatcher);
                }
                {
                    this.this$0 = rotationWatcher;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher_1$__constructor__(com.android.internal.policy.PhoneWindow$RotationWatcher ), 0, this, rotationWatcher);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mWindows = new ArrayList();
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$onRotationChanged(int rotation) throws RemoteException {
            this.mHandler.post(this.mRotationChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$addWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                if (!this.mIsWatching) {
                    try {
                        WindowManagerHolder.sWindowManager.watchRotation(this, phoneWindow.getContext().getDisplay().getDisplayId());
                        this.mHandler = new Handler();
                        this.mIsWatching = true;
                    }
                    catch (RemoteException ex) {
                        Log.e("PhoneWindow", "Couldn't start watching for device rotation", ex);
                    }
                }
                this.mWindows.add(new WeakReference<PhoneWindow>(phoneWindow));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$removeWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win == null || win == phoneWindow) {
                        this.mWindows.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$dispatchRotationChanged() {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win != null) {
                        win.onOptionsPanelRotationChanged();
                        ++i;
                        continue;
                    }
                    this.mWindows.remove(i);
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$__constructor__();
        }

        RotationWatcher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$__constructor__(), 0, this);
        }

        @Override
        public void onRotationChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onRotationChanged", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$onRotationChanged(int ), 0, this, n);
        }

        public void addWindow(PhoneWindow phoneWindow) {
            InvokeDynamicSupport.bootstrap("addWindow", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$addWindow(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
        }

        public void removeWindow(PhoneWindow phoneWindow) {
            InvokeDynamicSupport.bootstrap("removeWindow", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$removeWindow(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
        }

        void dispatchRotationChanged() {
            InvokeDynamicSupport.bootstrap("dispatchRotationChanged", $$robo$$com_android_internal_policy_PhoneWindow_RotationWatcher$dispatchRotationChanged(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotationWatcher)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PanelFeatureState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int featureId;
        int background;
        int fullBackground;
        int gravity;
        int x;
        int y;
        int windowAnimations;
        DecorView decorView;
        View createdPanelView;
        View shownPanelView;
        MenuBuilder menu;
        IconMenuPresenter iconMenuPresenter;
        ListMenuPresenter listMenuPresenter;
        boolean isCompact;
        int listPresenterTheme;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        boolean isInExpandedMode;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        boolean wasLastExpanded;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        private void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$__constructor__(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$isInListMode() {
            return this.isInExpandedMode || this.isCompact;
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            if (this.isCompact || this.isInExpandedMode) {
                return this.listMenuPresenter.getAdapter().getCount() > 0;
            }
            return ((ViewGroup)this.shownPanelView).getChildCount() > 0;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.iconMenuPresenter = null;
            this.listMenuPresenter = null;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$setStyle(Context context) {
            TypedArray a = context.obtainStyledAttributes(R.styleable.Theme);
            this.background = a.getResourceId(46, 0);
            this.fullBackground = a.getResourceId(47, 0);
            this.windowAnimations = a.getResourceId(93, 0);
            this.isCompact = a.getBoolean(309, false);
            this.listPresenterTheme = a.getResourceId(310, 16974810);
            a.recycle();
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$setMenu(MenuBuilder menu2) {
            if (menu2 == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.menu = menu2;
            if (menu2 != null) {
                if (this.iconMenuPresenter != null) {
                    menu2.addMenuPresenter(this.iconMenuPresenter);
                }
                if (this.listMenuPresenter != null) {
                    menu2.addMenuPresenter(this.listMenuPresenter);
                }
            }
        }

        private final MenuView $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$getListMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (!this.isCompact) {
                this.getIconMenuView(context, cb);
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(17367170, this.listPresenterTheme);
                this.listMenuPresenter.setCallback(cb);
                this.listMenuPresenter.setId(16909033);
                this.menu.addMenuPresenter(this.listMenuPresenter);
            }
            if (this.iconMenuPresenter != null) {
                this.listMenuPresenter.setItemIndexOffset(this.iconMenuPresenter.getNumActualItemsShown());
            }
            MenuView result = this.listMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        private final MenuView $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$getIconMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.iconMenuPresenter == null) {
                this.iconMenuPresenter = new IconMenuPresenter(context);
                this.iconMenuPresenter.setCallback(cb);
                this.iconMenuPresenter.setId(16908957);
                this.menu.addMenuPresenter(this.iconMenuPresenter);
            }
            MenuView result = this.iconMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        private final Parcelable $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            savedState.isInExpandedMode = this.isInExpandedMode;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.wasLastExpanded = savedState.isInExpandedMode;
            this.frozenMenuState = savedState.menuState;
            this.createdPanelView = null;
            this.shownPanelView = null;
            this.decorView = null;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$__constructor__(n);
        }

        PanelFeatureState(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$__constructor__(int ), 0, this, n);
        }

        public boolean isInListMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInListMode", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$isInListMode(), 0, this);
        }

        public boolean hasPanelItems() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasPanelItems", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$hasPanelItems(), 0, this);
        }

        public void clearMenuPresenters() {
            InvokeDynamicSupport.bootstrap("clearMenuPresenters", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$clearMenuPresenters(), 0, this);
        }

        void setStyle(Context context) {
            InvokeDynamicSupport.bootstrap("setStyle", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$setStyle(android.content.Context ), 0, this, context);
        }

        void setMenu(MenuBuilder menuBuilder) {
            InvokeDynamicSupport.bootstrap("setMenu", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$setMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        MenuView getListMenuView(Context context, MenuPresenter.Callback callback) {
            return InvokeDynamicSupport.bootstrap("getListMenuView", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$getListMenuView(android.content.Context com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, context, callback);
        }

        MenuView getIconMenuView(Context context, MenuPresenter.Callback callback) {
            return InvokeDynamicSupport.bootstrap("getIconMenuView", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$getIconMenuView(android.content.Context com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, context, callback);
        }

        Parcelable onSaveInstanceState() {
            return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$onSaveInstanceState(), 0, this);
        }

        void onRestoreInstanceState(Parcelable parcelable) {
            InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
        }

        void applyFrozenState() {
            InvokeDynamicSupport.bootstrap("applyFrozenState", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState$applyFrozenState(), 0, this);
        }

        public /* synthetic */ PanelFeatureState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PanelFeatureState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class SavedState
        implements Parcelable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            int featureId;
            boolean isOpen;
            boolean isInExpandedMode;
            Bundle menuState;
            public static Parcelable.Creator<SavedState> CREATOR;

            private void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$__constructor__() {
            }

            private final int $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$describeContents() {
                return 0;
            }

            private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                dest.writeInt(this.isInExpandedMode ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            private static final SavedState $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$readFromParcel(Parcel source) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                savedState.isOpen = source.readInt() == 1;
                boolean bl = savedState.isInExpandedMode = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle();
                }
                return savedState;
            }

            private /* synthetic */ void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$__constructor__(1 x0) {
            }

            static void __staticInitializer__() {
                CREATOR = new Parcelable.Creator<SavedState>(){
                    public transient /* synthetic */ Object __robo_data__;

                    private void $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$__constructor__() {
                    }

                    private final SavedState $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$createFromParcel(Parcel in) {
                        return SavedState.readFromParcel(in);
                    }

                    private final SavedState[] $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$newArray(int size) {
                        return new SavedState[size];
                    }

                    private void __constructor__() {
                        this.$$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$__constructor__();
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$__constructor__(), 0, this);
                    }

                    @Override
                    public SavedState createFromParcel(Parcel parcel) {
                        return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                    }

                    public SavedState[] newArray(int n) {
                        return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState_1$newArray(int ), 0, this, n);
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$__constructor__();
            }

            private SavedState() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$__constructor__(), 0, this);
            }

            @Override
            public int describeContents() {
                return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$describeContents(), 0, this);
            }

            @Override
            public void writeToParcel(Parcel parcel, int n) {
                InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
            }

            private static SavedState readFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrapStatic("readFromParcel", $$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$readFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
            }

            private /* synthetic */ void __constructor__(1 var1_1) {
                this.$$robo$$com_android_internal_policy_PhoneWindow_PanelFeatureState_SavedState$__constructor__(var1_1);
            }

            static {
                RobolectricInternals.classInitializing(SavedState.class);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class DrawableFeatureState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int featureId;
        int resid;
        Uri uri;
        Drawable local;
        Drawable child;
        Drawable def;
        Drawable cur;
        int alpha;
        int curAlpha;

        private void $$robo$$com_android_internal_policy_PhoneWindow_DrawableFeatureState$__constructor__(int _featureId) {
            this.alpha = 255;
            this.curAlpha = 255;
            this.featureId = _featureId;
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_DrawableFeatureState$__constructor__(n);
        }

        DrawableFeatureState(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_DrawableFeatureState$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ DrawableFeatureState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DrawableFeatureState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ PhoneWindow this$0;

        private void $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$__constructor__(PhoneWindow phoneWindow) {
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb = this.this$0.getCallback();
            if (cb != null) {
                cb.onMenuOpened(8, subMenu);
                return true;
            }
            return false;
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            this.this$0.checkCloseActionMenu(menu2);
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$__constructor__(PhoneWindow x0, 1 x1) {
        }

        private void __constructor__(PhoneWindow phoneWindow) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$__constructor__(phoneWindow);
        }

        private ActionMenuPresenterCallback(PhoneWindow phoneWindow) {
            this.this$0 = phoneWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
        }

        private /* synthetic */ void __constructor__(PhoneWindow phoneWindow, 1 var2_2) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_ActionMenuPresenterCallback$__constructor__(phoneWindow, var2_2);
        }

        public /* synthetic */ ActionMenuPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PanelMenuPresenterCallback
    implements MenuPresenter.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ PhoneWindow this$0;

        private void $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$__constructor__(PhoneWindow phoneWindow) {
        }

        private final void $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu2.getRootMenu();
            boolean isSubMenu = parentMenu != menu2;
            PanelFeatureState panel = this.this$0.findMenuPanel(isSubMenu ? parentMenu : menu2);
            if (panel != null) {
                if (isSubMenu) {
                    this.this$0.callOnPanelClosed(panel.featureId, panel, parentMenu);
                    this.this$0.closePanel(panel, true);
                } else {
                    this.this$0.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        private final boolean $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb;
            if (subMenu == null && this.this$0.hasFeature(8) && (cb = this.this$0.getCallback()) != null && !this.this$0.isDestroyed()) {
                cb.onMenuOpened(8, subMenu);
            }
            return true;
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$__constructor__(PhoneWindow x0, 1 x1) {
        }

        private void __constructor__(PhoneWindow phoneWindow) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$__constructor__(phoneWindow);
        }

        private PanelMenuPresenterCallback(PhoneWindow phoneWindow) {
            this.this$0 = phoneWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$__constructor__(com.android.internal.policy.PhoneWindow ), 0, this, phoneWindow);
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCloseMenu", $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$onCloseMenu(com.android.internal.view.menu.MenuBuilder boolean ), 0, this, menuBuilder, bl);
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return (boolean)InvokeDynamicSupport.bootstrap("onOpenSubMenu", $$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$onOpenSubMenu(com.android.internal.view.menu.MenuBuilder ), 0, this, menuBuilder);
        }

        private /* synthetic */ void __constructor__(PhoneWindow phoneWindow, 1 var2_2) {
            this.$$robo$$com_android_internal_policy_PhoneWindow_PanelMenuPresenterCallback$__constructor__(phoneWindow, var2_2);
        }

        public /* synthetic */ PanelMenuPresenterCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PanelMenuPresenterCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WindowManagerHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static IWindowManager sWindowManager;

        private void $$robo$$com_android_internal_policy_PhoneWindow_WindowManagerHolder$__constructor__() {
        }

        static void __staticInitializer__() {
            sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_policy_PhoneWindow_WindowManagerHolder$__constructor__();
        }

        WindowManagerHolder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_PhoneWindow_WindowManagerHolder$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(WindowManagerHolder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowManagerHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

