/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CallerInfoAsyncQuery
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String LOG_TAG = "CallerInfoAsyncQuery";
    private static int EVENT_NEW_QUERY = 1;
    private static int EVENT_ADD_LISTENER = 2;
    private static int EVENT_END_OF_QUEUE = 3;
    private static int EVENT_EMERGENCY_NUMBER = 4;
    private static int EVENT_VOICEMAIL_NUMBER = 5;
    private static int EVENT_GET_GEO_DESCRIPTION = 6;
    private CallerInfoAsyncQueryHandler mHandler;
    private static boolean ENABLE_UNKNOWN_NUMBER_GEO_DESCRIPTION = true;

    private static final ContentResolver $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$getCurrentProfileContentResolver(Context context) {
        int currentUser = ActivityManager.getCurrentUser();
        int myUser = UserManager.get(context).getUserHandle();
        if (myUser != currentUser) {
            try {
                Context otherContext = context.createPackageContextAsUser(context.getPackageName(), 0, new UserHandle(currentUser));
                return otherContext.getContentResolver();
            }
            catch (PackageManager.NameNotFoundException e) {
                Rlog.e("CallerInfoAsyncQuery", "Can't find self package", e);
            }
        }
        return context.getContentResolver();
    }

    private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$__constructor__() {
    }

    private static final CallerInfoAsyncQuery $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int token, Context context, Uri contactRef, OnQueryCompleteListener listener, Object cookie) {
        CallerInfoAsyncQuery c = new CallerInfoAsyncQuery();
        c.allocate(context, contactRef);
        CookieWrapper cw = new CookieWrapper();
        cw.listener = listener;
        cw.cookie = cookie;
        cw.event = 1;
        c.mHandler.startQuery(token, cw, contactRef, null, null, null, null);
        return c;
    }

    private static final CallerInfoAsyncQuery $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int token, Context context, String number, OnQueryCompleteListener listener, Object cookie) {
        int subId = SubscriptionManager.getDefaultSubscriptionId();
        return CallerInfoAsyncQuery.startQuery(token, context, number, listener, cookie, subId);
    }

    private static final CallerInfoAsyncQuery $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int token, Context context, String number, OnQueryCompleteListener listener, Object cookie, int subId) {
        Uri contactRef = ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI.buildUpon().appendPath(number).appendQueryParameter("sip", String.valueOf(PhoneNumberUtils.isUriNumber(number))).build();
        CallerInfoAsyncQuery c = new CallerInfoAsyncQuery();
        c.allocate(context, contactRef);
        CookieWrapper cw = new CookieWrapper();
        cw.listener = listener;
        cw.cookie = cookie;
        cw.number = number;
        cw.subId = subId;
        cw.event = PhoneNumberUtils.isLocalEmergencyNumber(context, number) ? 4 : (PhoneNumberUtils.isVoiceMailNumber(context, subId, number) ? 5 : 1);
        c.mHandler.startQuery(token, cw, contactRef, null, null, null, null);
        return c;
    }

    private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$addQueryListener(int token, OnQueryCompleteListener listener, Object cookie) {
        CookieWrapper cw = new CookieWrapper();
        cw.listener = listener;
        cw.cookie = cookie;
        cw.event = 2;
        this.mHandler.startQuery(token, cw, null, null, null, null, null);
    }

    private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$allocate(Context context, Uri contactRef) {
        if (context == null || contactRef == null) {
            throw new QueryPoolException("Bad context or query uri.");
        }
        this.mHandler = new CallerInfoAsyncQueryHandler(this, context);
        this.mHandler.mQueryUri = contactRef;
    }

    private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$release() {
        this.mHandler.mContext = null;
        this.mHandler.mQueryUri = null;
        this.mHandler.mCallerInfo = null;
        this.mHandler = null;
    }

    private static final String $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$sanitizeUriToString(Uri uri) {
        if (uri != null) {
            String uriString = uri.toString();
            int indexOfLastSlash = uriString.lastIndexOf(47);
            if (indexOfLastSlash > 0) {
                return uriString.substring(0, indexOfLastSlash) + "/xxxxxxx";
            }
            return uriString;
        }
        return "";
    }

    static ContentResolver getCurrentProfileContentResolver(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentProfileContentResolver", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$getCurrentProfileContentResolver(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$__constructor__();
    }

    private CallerInfoAsyncQuery() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$__constructor__(), 0, this);
    }

    public static CallerInfoAsyncQuery startQuery(int n, Context context, Uri uri, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("startQuery", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int android.content.Context android.net.Uri com.android.internal.telephony.CallerInfoAsyncQuery$OnQueryCompleteListener java.lang.Object ), 0, (int)n, (Context)context, (Uri)uri, (OnQueryCompleteListener)onQueryCompleteListener, (Object)object);
    }

    public static CallerInfoAsyncQuery startQuery(int n, Context context, String string2, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("startQuery", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int android.content.Context java.lang.String com.android.internal.telephony.CallerInfoAsyncQuery$OnQueryCompleteListener java.lang.Object ), 0, (int)n, (Context)context, (String)string2, (OnQueryCompleteListener)onQueryCompleteListener, (Object)object);
    }

    public static CallerInfoAsyncQuery startQuery(int n, Context context, String string2, OnQueryCompleteListener onQueryCompleteListener, Object object, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("startQuery", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$startQuery(int android.content.Context java.lang.String com.android.internal.telephony.CallerInfoAsyncQuery$OnQueryCompleteListener java.lang.Object int ), 0, (int)n, (Context)context, (String)string2, (OnQueryCompleteListener)onQueryCompleteListener, (Object)object, (int)n2);
    }

    public void addQueryListener(int n, OnQueryCompleteListener onQueryCompleteListener, Object object) {
        InvokeDynamicSupport.bootstrap("addQueryListener", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$addQueryListener(int com.android.internal.telephony.CallerInfoAsyncQuery$OnQueryCompleteListener java.lang.Object ), 0, this, n, onQueryCompleteListener, object);
    }

    private void allocate(Context context, Uri uri) {
        InvokeDynamicSupport.bootstrap("allocate", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$allocate(android.content.Context android.net.Uri ), 0, this, context, uri);
    }

    private void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$release(), 0, this);
    }

    private static String sanitizeUriToString(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("sanitizeUriToString", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery$sanitizeUriToString(android.net.Uri ), 0, (Uri)uri);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallerInfoAsyncQuery)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallerInfoAsyncQueryHandler
    extends AsyncQueryHandler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private Uri mQueryUri;
        private CallerInfo mCallerInfo;
        private List<Runnable> mPendingListenerCallbacks;
        /* synthetic */ CallerInfoAsyncQuery this$0;

        private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$__constructor__(CallerInfoAsyncQuery callerInfoAsyncQuery, Context context) {
            this.mPendingListenerCallbacks = new ArrayList<Runnable>();
            this.mContext = context;
        }

        private final Handler $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$createHandler(Looper looper) {
            return new CallerInfoWorkerHandler(this, looper);
        }

        private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$onQueryComplete(int token, Object cookie, Cursor cursor) {
            CookieWrapper endMarker;
            Rlog.d("CallerInfoAsyncQuery", "##### onQueryComplete() #####   query complete for token: " + token);
            CookieWrapper cw = (CookieWrapper)cookie;
            if (cw == null) {
                Rlog.i("CallerInfoAsyncQuery", "Cookie is null, ignoring onQueryComplete() request.");
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cw.event == 3) {
                for (Runnable r : this.mPendingListenerCallbacks) {
                    r.run();
                }
                this.mPendingListenerCallbacks.clear();
                this.this$0.release();
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            if (cw.event == 6) {
                if (this.mCallerInfo != null) {
                    this.mCallerInfo.geoDescription = cw.geoDescription;
                }
                endMarker = new CookieWrapper();
                endMarker.event = 3;
                this.startQuery(token, endMarker, null, null, null, null, null);
            }
            if (this.mCallerInfo == null) {
                if (this.mContext == null || this.mQueryUri == null) {
                    throw new QueryPoolException("Bad context or query uri, or CallerInfoAsyncQuery already released.");
                }
                if (cw.event == 4) {
                    this.mCallerInfo = new CallerInfo().markAsEmergency(this.mContext);
                } else if (cw.event == 5) {
                    this.mCallerInfo = new CallerInfo().markAsVoiceMail(cw.subId);
                } else {
                    this.mCallerInfo = CallerInfo.getCallerInfo(this.mContext, this.mQueryUri, cursor);
                    CallerInfo newCallerInfo = CallerInfo.doSecondaryLookupIfNecessary(this.mContext, cw.number, this.mCallerInfo);
                    if (newCallerInfo != this.mCallerInfo) {
                        this.mCallerInfo = newCallerInfo;
                    }
                    if (!TextUtils.isEmpty(cw.number)) {
                        this.mCallerInfo.phoneNumber = PhoneNumberUtils.formatNumber(cw.number, this.mCallerInfo.normalizedNumber, CallerInfo.getCurrentCountryIso(this.mContext));
                    }
                    if (TextUtils.isEmpty(this.mCallerInfo.name)) {
                        cw.event = 6;
                        this.startQuery(token, cw, null, null, null, null, null);
                        return;
                    }
                }
                endMarker = new CookieWrapper();
                endMarker.event = 3;
                this.startQuery(token, endMarker, null, null, null, null, null);
            }
            if (cw.listener != null) {
                this.mPendingListenerCallbacks.add(new Runnable(this, cw, token){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ CookieWrapper val$cw;
                    /* synthetic */ int val$token;
                    /* synthetic */ CallerInfoAsyncQueryHandler this$1;

                    private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_1$__constructor__(CallerInfoAsyncQueryHandler this$1, CookieWrapper cookieWrapper, int n) {
                    }

                    private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_1$run() {
                        this.val$cw.listener.onQueryComplete(this.val$token, this.val$cw.cookie, this.this$1.mCallerInfo);
                    }

                    private void __constructor__(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, CookieWrapper cookieWrapper, int n) {
                        this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_1$__constructor__(callerInfoAsyncQueryHandler, cookieWrapper, n);
                    }
                    {
                        this.this$1 = callerInfoAsyncQueryHandler;
                        this.val$cw = cookieWrapper;
                        this.val$token = n;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_1$__constructor__(com.android.internal.telephony.CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler com.android.internal.telephony.CallerInfoAsyncQuery$CookieWrapper int ), 0, this, callerInfoAsyncQueryHandler, cookieWrapper, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else {
                Rlog.w("CallerInfoAsyncQuery", "There is no listener to notify for this query.");
            }
            if (cursor != null) {
                cursor.close();
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$__constructor__(CallerInfoAsyncQuery x0, Context x1, 1 x2) {
        }

        private void __constructor__(CallerInfoAsyncQuery callerInfoAsyncQuery, Context context) {
            this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$__constructor__(callerInfoAsyncQuery, context);
        }

        private CallerInfoAsyncQueryHandler(CallerInfoAsyncQuery callerInfoAsyncQuery, Context context) {
            this.this$0 = callerInfoAsyncQuery;
            super(CallerInfoAsyncQuery.getCurrentProfileContentResolver(context));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$__constructor__(com.android.internal.telephony.CallerInfoAsyncQuery android.content.Context ), 0, this, callerInfoAsyncQuery, context);
        }

        @Override
        protected Handler createHandler(Looper looper) {
            return InvokeDynamicSupport.bootstrap("createHandler", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$createHandler(android.os.Looper ), 0, this, looper);
        }

        @Override
        protected void onQueryComplete(int n, Object object, Cursor cursor) {
            InvokeDynamicSupport.bootstrap("onQueryComplete", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$onQueryComplete(int java.lang.Object android.database.Cursor ), 0, this, n, object, cursor);
        }

        private /* synthetic */ void __constructor__(CallerInfoAsyncQuery callerInfoAsyncQuery, Context context, 1 var3_3) {
            this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler$__constructor__(callerInfoAsyncQuery, context, var3_3);
        }

        public /* synthetic */ CallerInfoAsyncQueryHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallerInfoAsyncQueryHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        protected class CallerInfoWorkerHandler
        extends AsyncQueryHandler.WorkerHandler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CallerInfoAsyncQueryHandler this$1;

            private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$__constructor__(CallerInfoAsyncQueryHandler this$1, Looper looper) {
            }

            private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$handleMessage(Message msg) {
                AsyncQueryHandler.WorkerArgs args = (AsyncQueryHandler.WorkerArgs)msg.obj;
                CookieWrapper cw = (CookieWrapper)args.cookie;
                if (cw == null) {
                    Rlog.i("CallerInfoAsyncQuery", "Unexpected command (CookieWrapper is null): " + msg.what + " ignored by CallerInfoWorkerHandler, passing onto parent.");
                    super.handleMessage(msg);
                } else {
                    Rlog.d("CallerInfoAsyncQuery", "Processing event: " + cw.event + " token (arg1): " + msg.arg1 + " command: " + msg.what + " query URI: " + CallerInfoAsyncQuery.sanitizeUriToString(args.uri));
                    switch (cw.event) {
                        case 1: {
                            super.handleMessage(msg);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            Message reply = args.handler.obtainMessage(msg.what);
                            reply.obj = args;
                            reply.arg1 = msg.arg1;
                            reply.sendToTarget();
                            break;
                        }
                        case 6: {
                            this.handleGeoDescription(msg);
                            break;
                        }
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$handleGeoDescription(Message msg) {
                AsyncQueryHandler.WorkerArgs args = (AsyncQueryHandler.WorkerArgs)msg.obj;
                CookieWrapper cw = (CookieWrapper)args.cookie;
                if (!TextUtils.isEmpty(cw.number) && cw.cookie != null && this.this$1.mContext != null) {
                    long startTimeMillis = SystemClock.elapsedRealtime();
                    cw.geoDescription = CallerInfo.getGeoDescription(this.this$1.mContext, cw.number);
                    long duration = SystemClock.elapsedRealtime() - startTimeMillis;
                    if (duration > 500L) {
                        // empty if block
                    }
                }
                Message reply = args.handler.obtainMessage(msg.what);
                reply.obj = args;
                reply.arg1 = msg.arg1;
                reply.sendToTarget();
            }

            private void __constructor__(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Looper looper) {
                this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$__constructor__(callerInfoAsyncQueryHandler, looper);
            }

            public CallerInfoWorkerHandler(CallerInfoAsyncQueryHandler callerInfoAsyncQueryHandler, Looper looper) {
                this.this$1 = callerInfoAsyncQueryHandler;
                super(callerInfoAsyncQueryHandler, looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$__constructor__(com.android.internal.telephony.CallerInfoAsyncQuery$CallerInfoAsyncQueryHandler android.os.Looper ), 0, this, callerInfoAsyncQueryHandler, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            private void handleGeoDescription(Message message) {
                InvokeDynamicSupport.bootstrap("handleGeoDescription", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CallerInfoAsyncQueryHandler_CallerInfoWorkerHandler$handleGeoDescription(android.os.Message ), 0, this, message);
            }

            public /* synthetic */ CallerInfoWorkerHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallerInfoWorkerHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class QueryPoolException
    extends SQLException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_QueryPoolException$__constructor__(String error) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_QueryPoolException$__constructor__(string2);
        }

        public QueryPoolException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_QueryPoolException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ QueryPoolException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (QueryPoolException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CookieWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public OnQueryCompleteListener listener;
        public Object cookie;
        public int event;
        public String number;
        public String geoDescription;
        public int subId;

        private void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CookieWrapper$__constructor__() {
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CookieWrapper$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CookieWrapper$__constructor__();
        }

        private CookieWrapper() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CookieWrapper$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_CallerInfoAsyncQuery_CookieWrapper$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CookieWrapper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnQueryCompleteListener
    extends InstrumentedInterface {
        public void onQueryComplete(int var1, Object var2, CallerInfo var3);
    }
}

