/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.SystemConfig;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CarrierAppUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "CarrierAppUtils";
    private static boolean DEBUG = false;

    private void $$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__() {
    }

    private static final synchronized void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int userId) {
        SystemConfig config = SystemConfig.getInstance();
        ArraySet<String> systemCarrierAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierApps();
        ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, telephonyManager, contentResolver, userId, systemCarrierAppsDisabledUntilUsed, systemCarrierAssociatedAppsDisabledUntilUsed);
    }

    private static final synchronized void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, ContentResolver contentResolver, int userId) {
        SystemConfig config = SystemConfig.getInstance();
        ArraySet<String> systemCarrierAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierApps();
        ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed = config.getDisabledUntilUsedPreinstalledCarrierAssociatedApps();
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, null, contentResolver, userId, systemCarrierAppsDisabledUntilUsed, systemCarrierAssociatedAppsDisabledUntilUsed);
    }

    @VisibleForTesting
    private static final void $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int userId, ArraySet<String> systemCarrierAppsDisabledUntilUsed, ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        Map<String, List<ApplicationInfo>> associatedApps = CarrierAppUtils.getDefaultCarrierAssociatedAppsHelper(packageManager, userId, systemCarrierAssociatedAppsDisabledUntilUsed);
        ArrayList<String> enabledCarrierPackages = new ArrayList<String>();
        boolean hasRunOnce = Settings.Secure.getIntForUser(contentResolver, "carrier_apps_handled", 0, userId) == 1;
        try {
            for (ApplicationInfo ai : candidates) {
                String packageName = ai.packageName;
                boolean hasPrivileges = telephonyManager != null && telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
                packageManager.setSystemAppHiddenUntilInstalled(packageName, true);
                List<ApplicationInfo> associatedAppList = associatedApps.get(packageName);
                if (associatedAppList != null) {
                    for (ApplicationInfo associatedApp : associatedAppList) {
                        packageManager.setSystemAppHiddenUntilInstalled(associatedApp.packageName, true);
                    }
                }
                if (hasPrivileges) {
                    if (!(ai.isUpdatedSystemApp() || ai.enabledSetting != 0 && ai.enabledSetting != 4 && (ai.flags & 0x800000) != 0)) {
                        Slog.i("CarrierAppUtils", "Update state(" + packageName + "): ENABLED for user " + userId);
                        packageManager.setSystemAppInstallState(packageName, true, userId);
                        packageManager.setApplicationEnabledSetting(packageName, 1, 1, userId, callingPackage);
                    }
                    if (associatedAppList != null) {
                        for (ApplicationInfo associatedApp : associatedAppList) {
                            if (associatedApp.enabledSetting != 0 && associatedApp.enabledSetting != 4 && (associatedApp.flags & 0x800000) != 0) continue;
                            Slog.i("CarrierAppUtils", "Update associated state(" + associatedApp.packageName + "): ENABLED for user " + userId);
                            packageManager.setSystemAppInstallState(associatedApp.packageName, true, userId);
                            packageManager.setApplicationEnabledSetting(associatedApp.packageName, 1, 1, userId, callingPackage);
                        }
                    }
                    enabledCarrierPackages.add(ai.packageName);
                    continue;
                }
                if (!ai.isUpdatedSystemApp() && ai.enabledSetting == 0 && (ai.flags & 0x800000) != 0) {
                    Slog.i("CarrierAppUtils", "Update state(" + packageName + "): DISABLED_UNTIL_USED for user " + userId);
                    packageManager.setSystemAppInstallState(packageName, false, userId);
                }
                if (hasRunOnce || associatedAppList == null) continue;
                for (ApplicationInfo associatedApp : associatedAppList) {
                    if (associatedApp.enabledSetting != 0 || (associatedApp.flags & 0x800000) == 0) continue;
                    Slog.i("CarrierAppUtils", "Update associated state(" + associatedApp.packageName + "): DISABLED_UNTIL_USED for user " + userId);
                    packageManager.setSystemAppInstallState(associatedApp.packageName, false, userId);
                }
            }
            if (!hasRunOnce) {
                Settings.Secure.putIntForUser(contentResolver, "carrier_apps_handled", 1, userId);
            }
            if (!enabledCarrierPackages.isEmpty()) {
                String[] packageNames = new String[enabledCarrierPackages.size()];
                enabledCarrierPackages.toArray(packageNames);
                packageManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w("CarrierAppUtils", "Could not reach PackageManager", e);
        }
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierApps(IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidates(packageManager, userId);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            boolean hasPrivileges;
            ApplicationInfo ai = candidates.get(i);
            String packageName = ai.packageName;
            boolean bl = hasPrivileges = telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
            if (hasPrivileges) continue;
            candidates.remove(i);
        }
        return candidates;
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidates(IPackageManager packageManager, int userId) {
        ArraySet<String> systemCarrierAppsDisabledUntilUsed = SystemConfig.getInstance().getDisabledUntilUsedPreinstalledCarrierApps();
        return CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static final List<ApplicationInfo> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidatesHelper(IPackageManager packageManager, int userId, ArraySet<String> systemCarrierAppsDisabledUntilUsed) {
        if (systemCarrierAppsDisabledUntilUsed == null) {
            return null;
        }
        int size = systemCarrierAppsDisabledUntilUsed.size();
        if (size == 0) {
            return null;
        }
        ArrayList<ApplicationInfo> apps = new ArrayList<ApplicationInfo>(size);
        for (int i = 0; i < size; ++i) {
            String packageName = systemCarrierAppsDisabledUntilUsed.valueAt(i);
            ApplicationInfo ai = CarrierAppUtils.getApplicationInfoIfSystemApp(packageManager, userId, packageName);
            if (ai == null) continue;
            apps.add(ai);
        }
        return apps;
    }

    private static final Map<String, List<ApplicationInfo>> $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAssociatedAppsHelper(IPackageManager packageManager, int userId, ArrayMap<String, List<String>> systemCarrierAssociatedAppsDisabledUntilUsed) {
        int size = systemCarrierAssociatedAppsDisabledUntilUsed.size();
        ArrayMap<String, List<ApplicationInfo>> associatedApps = new ArrayMap<String, List<ApplicationInfo>>(size);
        for (int i = 0; i < size; ++i) {
            String carrierAppPackage = systemCarrierAssociatedAppsDisabledUntilUsed.keyAt(i);
            List<String> associatedAppPackages = systemCarrierAssociatedAppsDisabledUntilUsed.valueAt(i);
            for (int j = 0; j < associatedAppPackages.size(); ++j) {
                ApplicationInfo ai = CarrierAppUtils.getApplicationInfoIfSystemApp(packageManager, userId, associatedAppPackages.get(j));
                if (ai == null || ai.isUpdatedSystemApp()) continue;
                ArrayList<ApplicationInfo> appList = (ArrayList<ApplicationInfo>)associatedApps.get(carrierAppPackage);
                if (appList == null) {
                    appList = new ArrayList<ApplicationInfo>();
                    associatedApps.put(carrierAppPackage, appList);
                }
                appList.add(ai);
            }
        }
        return associatedApps;
    }

    private static final ApplicationInfo $$robo$$com_android_internal_telephony_CarrierAppUtils$getApplicationInfoIfSystemApp(IPackageManager packageManager, int userId, String packageName) {
        try {
            ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 0x20008000, userId);
            if (ai != null && ai.isSystemApp()) {
                return ai;
            }
        }
        catch (RemoteException e) {
            Slog.w("CarrierAppUtils", "Could not reach PackageManager", e);
        }
        return null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__();
    }

    private CarrierAppUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierAppUtils$__constructor__(), 0, this);
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int n) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager android.telephony.TelephonyManager android.content.ContentResolver int ), 0, (String)string2, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (ContentResolver)contentResolver, (int)n);
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, ContentResolver contentResolver, int n) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager android.content.ContentResolver int ), 0, (String)string2, (IPackageManager)iPackageManager, (ContentResolver)contentResolver, (int)n);
    }

    public static void disableCarrierAppsUntilPrivileged(String string2, IPackageManager iPackageManager, TelephonyManager telephonyManager, ContentResolver contentResolver, int n, ArraySet<String> arraySet, ArrayMap<String, List<String>> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("disableCarrierAppsUntilPrivileged", $$robo$$com_android_internal_telephony_CarrierAppUtils$disableCarrierAppsUntilPrivileged(java.lang.String android.content.pm.IPackageManager android.telephony.TelephonyManager android.content.ContentResolver int android.util.ArraySet<java.lang.String> android.util.ArrayMap<java.lang.String, java.util.List<java.lang.String>> ), 0, (String)string2, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (ContentResolver)contentResolver, (int)n, arraySet, arrayMap);
    }

    public static List<ApplicationInfo> getDefaultCarrierApps(IPackageManager iPackageManager, TelephonyManager telephonyManager, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierApps", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierApps(android.content.pm.IPackageManager android.telephony.TelephonyManager int ), 0, (IPackageManager)iPackageManager, (TelephonyManager)telephonyManager, (int)n);
    }

    public static List<ApplicationInfo> getDefaultCarrierAppCandidates(IPackageManager iPackageManager, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierAppCandidates", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidates(android.content.pm.IPackageManager int ), 0, (IPackageManager)iPackageManager, (int)n);
    }

    private static List<ApplicationInfo> getDefaultCarrierAppCandidatesHelper(IPackageManager iPackageManager, int n, ArraySet<String> arraySet) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierAppCandidatesHelper", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAppCandidatesHelper(android.content.pm.IPackageManager int android.util.ArraySet<java.lang.String> ), 0, (IPackageManager)iPackageManager, (int)n, arraySet);
    }

    private static Map<String, List<ApplicationInfo>> getDefaultCarrierAssociatedAppsHelper(IPackageManager iPackageManager, int n, ArrayMap<String, List<String>> arrayMap) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultCarrierAssociatedAppsHelper", $$robo$$com_android_internal_telephony_CarrierAppUtils$getDefaultCarrierAssociatedAppsHelper(android.content.pm.IPackageManager int android.util.ArrayMap<java.lang.String, java.util.List<java.lang.String>> ), 0, (IPackageManager)iPackageManager, (int)n, arrayMap);
    }

    private static ApplicationInfo getApplicationInfoIfSystemApp(IPackageManager iPackageManager, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationInfoIfSystemApp", $$robo$$com_android_internal_telephony_CarrierAppUtils$getApplicationInfoIfSystemApp(android.content.pm.IPackageManager int java.lang.String ), 0, (IPackageManager)iPackageManager, (int)n, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierAppUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

