/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccProfile;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierIdentifier
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private static boolean DBG = true;
    private static boolean VDBG;
    private static int SIM_LOAD_EVENT = 1;
    private static int SIM_ABSENT_EVENT = 2;
    private static int SPN_OVERRIDE_EVENT = 3;
    private static int ICC_CHANGED_EVENT = 4;
    private static int PREFER_APN_UPDATE_EVENT = 5;
    private static int CARRIER_ID_DB_UPDATE_EVENT = 6;
    private static Uri CONTENT_URL_PREFER_APN;
    private static String OPERATOR_BRAND_OVERRIDE_PREFIX = "operator_branding_";
    private List<CarrierMatchingRule> mCarrierMatchingRulesOnMccMnc;
    private int mCarrierId;
    private String mCarrierName;
    private String mPreferApn;
    private String mSpn;
    private Context mContext;
    private Phone mPhone;
    private IccRecords mIccRecords;
    private UiccProfile mUiccProfile;
    private LocalLog mCarrierIdLocalLog;
    private TelephonyManager mTelephonyMgr;
    private SubscriptionsChangedListener mOnSubscriptionsChangedListener;
    private ContentObserver mContentObserver;

    private void $$robo$$com_android_internal_telephony_CarrierIdentifier$__constructor__(Phone phone) {
        this.mCarrierMatchingRulesOnMccMnc = new ArrayList<CarrierMatchingRule>();
        this.mCarrierId = -1;
        this.mSpn = "";
        this.mCarrierIdLocalLog = new LocalLog(20);
        this.mOnSubscriptionsChangedListener = new SubscriptionsChangedListener(this);
        this.mContentObserver = new ShadowedObject(this, this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierIdentifier this$0;

            private void $$robo$$com_android_internal_telephony_CarrierIdentifier_1$__constructor__(CarrierIdentifier this$0, Handler x0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierIdentifier_1$onChange(boolean selfChange, Uri uri) {
                if (CONTENT_URL_PREFER_APN.equals(uri.getLastPathSegment())) {
                    CarrierIdentifier.logd("onChange URI: " + uri);
                    this.this$0.sendEmptyMessage(5);
                } else if (Telephony.CarrierId.All.CONTENT_URI.equals(uri)) {
                    CarrierIdentifier.logd("onChange URI: " + uri);
                    this.this$0.sendEmptyMessage(6);
                }
            }

            private void __constructor__(CarrierIdentifier carrierIdentifier, Handler handler) {
                this.$$robo$$com_android_internal_telephony_CarrierIdentifier_1$__constructor__(carrierIdentifier, handler);
            }
            {
                this.this$0 = carrierIdentifier;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierIdentifier_1$__constructor__(com.android.internal.telephony.CarrierIdentifier android.os.Handler ), 0, this, carrierIdentifier, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_CarrierIdentifier_1$onChange(boolean android.net.Uri ), 0, this, bl, uri);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CarrierIdentifier.logd("Creating CarrierIdentifier[" + phone.getPhoneId() + "]");
        this.mContext = phone.getContext();
        this.mPhone = phone;
        this.mTelephonyMgr = TelephonyManager.from(this.mContext);
        this.mContext.getContentResolver().registerContentObserver(CONTENT_URL_PREFER_APN, false, this.mContentObserver);
        this.mContext.getContentResolver().registerContentObserver(Telephony.CarrierId.All.CONTENT_URI, false, this.mContentObserver);
        SubscriptionManager.from(this.mContext).addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        UiccController.getInstance().registerForIccChanged(this, 4, null);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierIdentifier$handleMessage(Message msg) {
        if (VDBG) {
            CarrierIdentifier.logd("handleMessage: " + msg.what);
        }
        switch (msg.what) {
            case 1: 
            case 6: {
                this.mSpn = this.mTelephonyMgr.getSimOperatorNameForPhone(this.mPhone.getPhoneId());
                this.mPreferApn = this.getPreferApn();
                this.loadCarrierMatchingRulesOnMccMnc();
                break;
            }
            case 2: {
                this.mCarrierMatchingRulesOnMccMnc.clear();
                this.mSpn = null;
                this.mPreferApn = null;
                this.updateCarrierIdAndName(-1, null);
                break;
            }
            case 5: {
                String preferApn = this.getPreferApn();
                if (CarrierIdentifier.equals(this.mPreferApn, preferApn, true)) break;
                CarrierIdentifier.logd("[updatePreferApn] from:" + this.mPreferApn + " to:" + preferApn);
                this.mPreferApn = preferApn;
                this.matchCarrier();
                break;
            }
            case 3: {
                String spn = this.mTelephonyMgr.getSimOperatorNameForPhone(this.mPhone.getPhoneId());
                if (CarrierIdentifier.equals(this.mSpn, spn, true)) break;
                CarrierIdentifier.logd("[updateSpn] from:" + this.mSpn + " to:" + spn);
                this.mSpn = spn;
                this.matchCarrier();
                break;
            }
            case 4: {
                UiccProfile uiccProfile;
                IccRecords newIccRecords = UiccController.getInstance().getIccRecords(this.mPhone.getPhoneId(), 1);
                if (this.mIccRecords != newIccRecords) {
                    if (this.mIccRecords != null) {
                        CarrierIdentifier.logd("Removing stale icc objects.");
                        this.mIccRecords.unregisterForRecordsLoaded(this);
                        this.mIccRecords.unregisterForRecordsOverride(this);
                        this.mIccRecords = null;
                    }
                    if (newIccRecords != null) {
                        CarrierIdentifier.logd("new Icc object");
                        newIccRecords.registerForRecordsLoaded(this, 1, null);
                        newIccRecords.registerForRecordsOverride(this, 1, null);
                        this.mIccRecords = newIccRecords;
                    }
                }
                if (this.mUiccProfile == (uiccProfile = UiccController.getInstance().getUiccProfileForPhone(this.mPhone.getPhoneId()))) break;
                if (this.mUiccProfile != null) {
                    CarrierIdentifier.logd("unregister operatorBrandOverride");
                    this.mUiccProfile.unregisterForOperatorBrandOverride(this);
                    this.mUiccProfile = null;
                }
                if (uiccProfile == null) break;
                CarrierIdentifier.logd("register operatorBrandOverride");
                uiccProfile.registerForOpertorBrandOverride(this, 3, null);
                this.mUiccProfile = uiccProfile;
                break;
            }
            default: {
                CarrierIdentifier.loge("invalid msg: " + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierIdentifier$loadCarrierMatchingRulesOnMccMnc() {
        try {
            String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
            try (Cursor cursor = this.mContext.getContentResolver().query(Telephony.CarrierId.All.CONTENT_URI, null, "mccmnc=?", new String[]{mccmnc}, null);){
                if (cursor != null) {
                    if (VDBG) {
                        CarrierIdentifier.logd("[loadCarrierMatchingRules]- " + cursor.getCount() + " Records(s) in DB mccmnc: " + mccmnc);
                    }
                    this.mCarrierMatchingRulesOnMccMnc.clear();
                    while (cursor.moveToNext()) {
                        this.mCarrierMatchingRulesOnMccMnc.add(this.makeCarrierMatchingRule(cursor));
                    }
                    this.matchCarrier();
                }
            }
        }
        catch (Exception ex) {
            CarrierIdentifier.loge("[loadCarrierMatchingRules]- ex: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_CarrierIdentifier$getPreferApn() {
        try (Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn/subId/" + this.mPhone.getSubId()), new String[]{"apn"}, null, null, null);){
            if (cursor != null) {
                if (VDBG) {
                    CarrierIdentifier.logd("[getPreferApn]- " + cursor.getCount() + " Records(s) in DB");
                }
                if (cursor.moveToNext()) {
                    String apn = cursor.getString(cursor.getColumnIndexOrThrow("apn"));
                    CarrierIdentifier.logd("[getPreferApn]- " + apn);
                    String string2 = apn;
                    return string2;
                }
            }
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierIdentifier$updateCarrierIdAndName(int cid, String name) {
        boolean update = false;
        if (!CarrierIdentifier.equals(name, this.mCarrierName, true)) {
            CarrierIdentifier.logd("[updateCarrierName] from:" + this.mCarrierName + " to:" + name);
            this.mCarrierName = name;
            update = true;
        }
        if (cid != this.mCarrierId) {
            CarrierIdentifier.logd("[updateCarrierId] from:" + this.mCarrierId + " to:" + cid);
            this.mCarrierId = cid;
            update = true;
        }
        if (update) {
            this.mCarrierIdLocalLog.log("[updateCarrierIdAndName] cid:" + this.mCarrierId + " name:" + this.mCarrierName);
            Intent intent = new Intent("android.telephony.action.SUBSCRIPTION_CARRIER_IDENTITY_CHANGED");
            intent.putExtra("android.telephony.extra.CARRIER_ID", this.mCarrierId);
            intent.putExtra("android.telephony.extra.CARRIER_NAME", this.mCarrierName);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_ID", this.mPhone.getSubId());
            this.mContext.sendBroadcast(intent);
            ContentValues cv = new ContentValues();
            cv.put("carrier_id", this.mCarrierId);
            cv.put("carrier_name", this.mCarrierName);
            this.mContext.getContentResolver().update(Uri.withAppendedPath(Telephony.CarrierId.CONTENT_URI, Integer.toString(this.mPhone.getSubId())), cv, null, null);
        }
    }

    private final CarrierMatchingRule $$robo$$com_android_internal_telephony_CarrierIdentifier$makeCarrierMatchingRule(Cursor cursor) {
        return new CarrierMatchingRule(cursor.getString(cursor.getColumnIndexOrThrow("mccmnc")), cursor.getString(cursor.getColumnIndexOrThrow("imsi_prefix_xpattern")), cursor.getString(cursor.getColumnIndexOrThrow("iccid_prefix")), cursor.getString(cursor.getColumnIndexOrThrow("gid1")), cursor.getString(cursor.getColumnIndexOrThrow("gid2")), cursor.getString(cursor.getColumnIndexOrThrow("plmn")), cursor.getString(cursor.getColumnIndexOrThrow("spn")), cursor.getString(cursor.getColumnIndexOrThrow("apn")), cursor.getInt(cursor.getColumnIndexOrThrow("carrier_id")), cursor.getString(cursor.getColumnIndexOrThrow("carrier_name")));
    }

    private final void $$robo$$com_android_internal_telephony_CarrierIdentifier$matchCarrier() {
        if (!SubscriptionManager.isValidSubscriptionId(this.mPhone.getSubId())) {
            CarrierIdentifier.logd("[matchCarrier]skip before sim records loaded");
            return;
        }
        String mccmnc = this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        String iccid = this.mPhone.getIccSerialNumber();
        String gid1 = this.mPhone.getGroupIdLevel1();
        String gid2 = this.mPhone.getGroupIdLevel2();
        String imsi = this.mPhone.getSubscriberId();
        String plmn = this.mPhone.getPlmn();
        String spn = this.mSpn;
        String apn = this.mPreferApn;
        if (VDBG) {
            CarrierIdentifier.logd("[matchCarrier] mnnmnc:" + mccmnc + " gid1: " + gid1 + " gid2: " + gid2 + " imsi: " + Rlog.pii(LOG_TAG, (Object)imsi) + " iccid: " + Rlog.pii(LOG_TAG, (Object)iccid) + " plmn: " + plmn + " spn: " + spn + " apn: " + apn);
        }
        CarrierMatchingRule subscriptionRule = new CarrierMatchingRule(mccmnc, imsi, iccid, gid1, gid2, plmn, spn, apn, -1, null);
        int maxScore = -1;
        CarrierMatchingRule maxRule = null;
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            rule.match(subscriptionRule);
            if (rule.mScore <= maxScore) continue;
            maxScore = rule.mScore;
            maxRule = rule;
        }
        if (maxScore == -1) {
            CarrierIdentifier.logd("[matchCarrier - no match] cid: -1 name: " + null);
            this.updateCarrierIdAndName(-1, null);
        } else {
            CarrierIdentifier.logd("[matchCarrier] cid: " + maxRule.mCid + " name: " + maxRule.mName);
            this.updateCarrierIdAndName(maxRule.mCid, maxRule.mName);
        }
        String unknownGid1ToLog = (maxScore & 0x10) == 0 && !TextUtils.isEmpty(subscriptionRule.mGid1) ? subscriptionRule.mGid1 : null;
        String unknownMccmncToLog = (maxScore == -1 || (maxScore & 0x10) == 0) && !TextUtils.isEmpty(subscriptionRule.mMccMnc) ? subscriptionRule.mMccMnc : null;
        TelephonyMetrics.getInstance().writeCarrierIdMatchingEvent(this.mPhone.getPhoneId(), this.getCarrierListVersion(), this.mCarrierId, unknownMccmncToLog, unknownGid1ToLog);
    }

    private final int $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierListVersion() {
        Cursor cursor = this.mContext.getContentResolver().query(Uri.withAppendedPath(Telephony.CarrierId.All.CONTENT_URI, "get_version"), null, null, null);
        cursor.moveToFirst();
        return cursor.getInt(0);
    }

    private final int $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierId() {
        return this.mCarrierId;
    }

    private final String $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierName() {
        return this.mCarrierName;
    }

    private static final boolean $$robo$$com_android_internal_telephony_CarrierIdentifier$equals(String a, String b, boolean ignoreCase) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return ignoreCase ? a.equalsIgnoreCase(b) : a.equals(b);
        }
        return false;
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierIdentifier$logd(String str) {
        Rlog.d(LOG_TAG, str);
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierIdentifier$loge(String str) {
        Rlog.e(LOG_TAG, str);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierIdentifier$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.println("mCarrierIdLocalLogs:");
        ipw.increaseIndent();
        this.mCarrierIdLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
        ipw.println("mCarrierId: " + this.mCarrierId);
        ipw.println("mCarrierName: " + this.mCarrierName);
        ipw.println("version: " + this.getCarrierListVersion());
        ipw.println("mCarrierMatchingRules on mccmnc: " + this.mTelephonyMgr.getSimOperatorNumericForPhone(this.mPhone.getPhoneId()));
        ipw.increaseIndent();
        for (CarrierMatchingRule rule : this.mCarrierMatchingRulesOnMccMnc) {
            ipw.println(rule.toString());
        }
        ipw.decreaseIndent();
        ipw.println("mSpn: " + this.mSpn);
        ipw.println("mPreferApn: " + this.mPreferApn);
        ipw.flush();
    }

    static void __staticInitializer__() {
        LOG_TAG = CarrierIdentifier.class.getSimpleName();
        VDBG = Rlog.isLoggable(LOG_TAG, 2);
        CONTENT_URL_PREFER_APN = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "preferapn");
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_CarrierIdentifier$__constructor__(phone);
    }

    public CarrierIdentifier(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierIdentifier$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierIdentifier$handleMessage(android.os.Message ), 0, this, message);
    }

    private void loadCarrierMatchingRulesOnMccMnc() {
        InvokeDynamicSupport.bootstrap("loadCarrierMatchingRulesOnMccMnc", $$robo$$com_android_internal_telephony_CarrierIdentifier$loadCarrierMatchingRulesOnMccMnc(), 0, this);
    }

    private String getPreferApn() {
        return InvokeDynamicSupport.bootstrap("getPreferApn", $$robo$$com_android_internal_telephony_CarrierIdentifier$getPreferApn(), 0, this);
    }

    private void updateCarrierIdAndName(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateCarrierIdAndName", $$robo$$com_android_internal_telephony_CarrierIdentifier$updateCarrierIdAndName(int java.lang.String ), 0, this, n, string2);
    }

    private CarrierMatchingRule makeCarrierMatchingRule(Cursor cursor) {
        return InvokeDynamicSupport.bootstrap("makeCarrierMatchingRule", $$robo$$com_android_internal_telephony_CarrierIdentifier$makeCarrierMatchingRule(android.database.Cursor ), 0, this, cursor);
    }

    private void matchCarrier() {
        InvokeDynamicSupport.bootstrap("matchCarrier", $$robo$$com_android_internal_telephony_CarrierIdentifier$matchCarrier(), 0, this);
    }

    public int getCarrierListVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierListVersion", $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierListVersion(), 0, this);
    }

    public int getCarrierId() {
        return (int)InvokeDynamicSupport.bootstrap("getCarrierId", $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierId(), 0, this);
    }

    public String getCarrierName() {
        return InvokeDynamicSupport.bootstrap("getCarrierName", $$robo$$com_android_internal_telephony_CarrierIdentifier$getCarrierName(), 0, this);
    }

    private static boolean equals(String string2, String string3, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$com_android_internal_telephony_CarrierIdentifier$equals(java.lang.String java.lang.String boolean ), 0, (String)string2, (String)string3, (boolean)bl);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_CarrierIdentifier$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_CarrierIdentifier$loge(java.lang.String ), 0, (String)string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_CarrierIdentifier$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(CarrierIdentifier.class);
    }

    public /* synthetic */ CarrierIdentifier() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierIdentifier)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CarrierMatchingRule
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SCORE_MCCMNC = 128;
        private static int SCORE_IMSI_PREFIX = 64;
        private static int SCORE_ICCID_PREFIX = 32;
        private static int SCORE_GID1 = 16;
        private static int SCORE_GID2 = 8;
        private static int SCORE_PLMN = 4;
        private static int SCORE_SPN = 2;
        private static int SCORE_APN = 1;
        private static int SCORE_INVALID = -1;
        private String mMccMnc;
        private String mImsiPrefixPattern;
        private String mIccidPrefix;
        private String mGid1;
        private String mGid2;
        private String mPlmn;
        private String mSpn;
        private String mApn;
        private String mName;
        private int mCid;
        private int mScore;

        private void $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$__constructor__(String mccmnc, String imsiPrefixPattern, String iccidPrefix, String gid1, String gid2, String plmn, String spn, String apn, int cid, String name) {
            this.mScore = 0;
            this.mMccMnc = mccmnc;
            this.mImsiPrefixPattern = imsiPrefixPattern;
            this.mIccidPrefix = iccidPrefix;
            this.mGid1 = gid1;
            this.mGid2 = gid2;
            this.mPlmn = plmn;
            this.mSpn = spn;
            this.mApn = apn;
            this.mCid = cid;
            this.mName = name;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$match(CarrierMatchingRule subscriptionRule) {
            this.mScore = 0;
            if (this.mMccMnc != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mMccMnc, this.mMccMnc, false)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 128;
            }
            if (this.mImsiPrefixPattern != null) {
                if (!this.imsiPrefixMatch(subscriptionRule.mImsiPrefixPattern, this.mImsiPrefixPattern)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 64;
            }
            if (this.mIccidPrefix != null) {
                if (!this.iccidPrefixMatch(subscriptionRule.mIccidPrefix, this.mIccidPrefix)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 32;
            }
            if (this.mGid1 != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mGid1, this.mGid1, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 16;
            }
            if (this.mGid2 != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mGid2, this.mGid2, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 8;
            }
            if (this.mPlmn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mPlmn, this.mPlmn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 4;
            }
            if (this.mSpn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mSpn, this.mSpn, true)) {
                    this.mScore = -1;
                    return;
                }
                this.mScore += 2;
            }
            if (this.mApn != null) {
                if (!CarrierIdentifier.equals(subscriptionRule.mApn, this.mApn, true)) {
                    this.mScore = -1;
                    return;
                }
                ++this.mScore;
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$imsiPrefixMatch(String imsi, String prefixXPattern) {
            if (TextUtils.isEmpty(prefixXPattern)) {
                return true;
            }
            if (TextUtils.isEmpty(imsi)) {
                return false;
            }
            if (imsi.length() < prefixXPattern.length()) {
                return false;
            }
            for (int i = 0; i < prefixXPattern.length(); ++i) {
                if (prefixXPattern.charAt(i) == 'x' || prefixXPattern.charAt(i) == 'X' || prefixXPattern.charAt(i) == imsi.charAt(i)) continue;
                return false;
            }
            return true;
        }

        private final boolean $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$iccidPrefixMatch(String iccid, String prefix) {
            if (iccid == null || prefix == null) {
                return false;
            }
            return iccid.startsWith(prefix);
        }

        private final String $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$toString() {
            return "[CarrierMatchingRule] - mccmnc: " + this.mMccMnc + " gid1: " + this.mGid1 + " gid2: " + this.mGid2 + " plmn: " + this.mPlmn + " imsi_prefix: " + this.mImsiPrefixPattern + " iccid_prefix" + this.mIccidPrefix + " spn: " + this.mSpn + " apn: " + this.mApn + " name: " + this.mName + " cid: " + this.mCid + " score: " + this.mScore;
        }

        private void __constructor__(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, String string10) {
            this.$$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$__constructor__(string2, string3, string4, string5, string6, string7, string8, string9, n, string10);
        }

        CarrierMatchingRule(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, String string10) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int java.lang.String ), 0, this, string2, string3, string4, string5, string6, string7, string8, string9, n, string10);
        }

        public void match(CarrierMatchingRule carrierMatchingRule) {
            InvokeDynamicSupport.bootstrap("match", $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$match(com.android.internal.telephony.CarrierIdentifier$CarrierMatchingRule ), 0, this, carrierMatchingRule);
        }

        private boolean imsiPrefixMatch(String string2, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("imsiPrefixMatch", $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$imsiPrefixMatch(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private boolean iccidPrefixMatch(String string2, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("iccidPrefixMatch", $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$iccidPrefixMatch(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_CarrierIdentifier_CarrierMatchingRule$toString(), 0, this);
        }

        public /* synthetic */ CarrierMatchingRule() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierMatchingRule)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        AtomicInteger mPreviousSubId;
        /* synthetic */ CarrierIdentifier this$0;

        private void $$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$__constructor__(CarrierIdentifier carrierIdentifier) {
            this.mPreviousSubId = new AtomicInteger(-1);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$onSubscriptionsChanged() {
            int subId = this.this$0.mPhone.getSubId();
            if (this.mPreviousSubId.getAndSet(subId) != subId) {
                CarrierIdentifier.logd("SubscriptionListener.onSubscriptionInfoChanged subId: " + this.mPreviousSubId);
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    this.this$0.sendEmptyMessage(1);
                } else {
                    this.this$0.sendEmptyMessage(2);
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$__constructor__(CarrierIdentifier x0, 1 x1) {
        }

        private void __constructor__(CarrierIdentifier carrierIdentifier) {
            this.$$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$__constructor__(carrierIdentifier);
        }

        private SubscriptionsChangedListener(CarrierIdentifier carrierIdentifier) {
            this.this$0 = carrierIdentifier;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$__constructor__(com.android.internal.telephony.CarrierIdentifier ), 0, this, carrierIdentifier);
        }

        @Override
        public void onSubscriptionsChanged() {
            InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$onSubscriptionsChanged(), 0, this);
        }

        private /* synthetic */ void __constructor__(CarrierIdentifier carrierIdentifier, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_CarrierIdentifier_SubscriptionsChangedListener$__constructor__(carrierIdentifier, var2_2);
        }

        public /* synthetic */ SubscriptionsChangedListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionsChangedListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

