/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlarmManager;
import android.app.DownloadManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.PersistableBundle;
import android.preference.PreferenceManager;
import android.telephony.CarrierConfigManager;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.org.bouncycastle.util.io.pem.PemReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierKeyDownloadManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierKeyDownloadManager";
    private static String MCC_MNC_PREF_TAG = "CARRIER_KEY_DM_MCC_MNC";
    private static int DAY_IN_MILLIS = 86400000;
    private static int START_RENEWAL_WINDOW_DAYS = 21;
    private static int END_RENEWAL_WINDOW_DAYS = 7;
    private static String INTENT_KEY_RENEWAL_ALARM_PREFIX = "com.android.internal.telephony.carrier_key_download_alarm";
    @VisibleForTesting
    public int mKeyAvailability;
    public static String MNC = "MNC";
    public static String MCC = "MCC";
    private static String SEPARATOR = ":";
    private static String JSON_CERTIFICATE = "certificate";
    private static String JSON_CERTIFICATE_ALTERNATE = "public-key";
    private static String JSON_TYPE = "key-type";
    private static String JSON_IDENTIFIER = "key-identifier";
    private static String JSON_CARRIER_KEYS = "carrier-keys";
    private static String JSON_TYPE_VALUE_WLAN = "WLAN";
    private static String JSON_TYPE_VALUE_EPDG = "EPDG";
    private static int[] CARRIER_KEY_TYPES;
    private static int UNINITIALIZED_KEY_TYPE = -1;
    private Phone mPhone;
    private Context mContext;
    public DownloadManager mDownloadManager;
    private String mURL;
    private BroadcastReceiver mBroadcastReceiver;

    private void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$__constructor__(Phone phone) {
        this.mKeyAvailability = 0;
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierKeyDownloadManager this$0;

            private void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager_1$__constructor__(CarrierKeyDownloadManager this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                int slotId = this.this$0.mPhone.getPhoneId();
                if (action.equals("com.android.internal.telephony.carrier_key_download_alarm" + slotId)) {
                    Log.d("CarrierKeyDownloadManager", "Handling key renewal alarm: " + action);
                    this.this$0.handleAlarmOrConfigChange();
                } else if (action.equals("com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD")) {
                    if (slotId == intent.getIntExtra("phone", -1)) {
                        Log.d("CarrierKeyDownloadManager", "Handling reset intent: " + action);
                        this.this$0.handleAlarmOrConfigChange();
                    }
                } else if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    if (slotId == intent.getIntExtra("phone", -1)) {
                        Log.d("CarrierKeyDownloadManager", "Carrier Config changed: " + action);
                        this.this$0.handleAlarmOrConfigChange();
                    }
                } else if (action.equals("android.intent.action.DOWNLOAD_COMPLETE")) {
                    Log.d("CarrierKeyDownloadManager", "Download Complete");
                    long carrierKeyDownloadIdentifier = intent.getLongExtra("extra_download_id", 0L);
                    String mccMnc = this.this$0.getMccMncSetFromPref();
                    if (this.this$0.isValidDownload(mccMnc)) {
                        this.this$0.onDownloadComplete(carrierKeyDownloadIdentifier, mccMnc);
                        this.this$0.onPostDownloadProcessing(carrierKeyDownloadIdentifier);
                    }
                }
            }

            private void __constructor__(CarrierKeyDownloadManager carrierKeyDownloadManager) {
                this.$$robo$$com_android_internal_telephony_CarrierKeyDownloadManager_1$__constructor__(carrierKeyDownloadManager);
            }
            {
                this.this$0 = carrierKeyDownloadManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager_1$__constructor__(com.android.internal.telephony.CarrierKeyDownloadManager ), 0, this, carrierKeyDownloadManager);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mContext = phone.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        filter.addAction("android.intent.action.DOWNLOAD_COMPLETE");
        filter.addAction("com.android.internal.telephony.carrier_key_download_alarm" + this.mPhone.getPhoneId());
        filter.addAction("com.android.internal.telephony.ACTION_CARRIER_CERTIFICATE_DOWNLOAD");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, null, phone);
        this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
    }

    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$onPostDownloadProcessing(long carrierKeyDownloadIdentifier) {
        this.resetRenewalAlarm();
        this.cleanupDownloadPreferences(carrierKeyDownloadIdentifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$handleAlarmOrConfigChange() {
        if (this.carrierUsesKeys()) {
            if (!this.areCarrierKeysAbsentOrExpiring()) return;
            boolean downloadStartedSuccessfully = this.downloadKey();
            if (downloadStartedSuccessfully) return;
            this.resetRenewalAlarm();
            return;
        } else {
            this.cleanupRenewalAlarms();
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$cleanupDownloadPreferences(long carrierKeyDownloadIdentifier) {
        Log.d("CarrierKeyDownloadManager", "Cleaning up download preferences: " + carrierKeyDownloadIdentifier);
        SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        editor.remove(String.valueOf(carrierKeyDownloadIdentifier));
        editor.commit();
    }

    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$cleanupRenewalAlarms() {
        Log.d("CarrierKeyDownloadManager", "Cleaning up existing renewal alarms");
        int slotId = this.mPhone.getPhoneId();
        Intent intent = new Intent("com.android.internal.telephony.carrier_key_download_alarm" + slotId);
        PendingIntent carrierKeyDownloadIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.cancel(carrierKeyDownloadIntent);
    }

    @VisibleForTesting
    private final long $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getExpirationDate() {
        long minExpirationDate = Long.MAX_VALUE;
        for (int key_type : CARRIER_KEY_TYPES) {
            ImsiEncryptionInfo imsiEncryptionInfo;
            if (!this.isKeyEnabled(key_type) || (imsiEncryptionInfo = this.mPhone.getCarrierInfoForImsiEncryption(key_type)) == null || imsiEncryptionInfo.getExpirationTime() == null || minExpirationDate <= imsiEncryptionInfo.getExpirationTime().getTime()) continue;
            minExpirationDate = imsiEncryptionInfo.getExpirationTime().getTime();
        }
        if (minExpirationDate == Long.MAX_VALUE || minExpirationDate < InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") + 604800000L) {
            minExpirationDate = (long)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") + 86400000L);
        } else {
            Random random = new Random();
            int max = 1814400000;
            int min = 604800000;
            int randomTime = random.nextInt(max - min) + min;
            minExpirationDate -= (long)randomTime;
        }
        return minExpirationDate;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$resetRenewalAlarm() {
        this.cleanupRenewalAlarms();
        int slotId = this.mPhone.getPhoneId();
        long minExpirationDate = this.getExpirationDate();
        Log.d("CarrierKeyDownloadManager", "minExpirationDate: " + new Date(minExpirationDate));
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent("com.android.internal.telephony.carrier_key_download_alarm" + slotId);
        PendingIntent carrierKeyDownloadIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
        alarmManager.set(2, minExpirationDate, carrierKeyDownloadIntent);
        Log.d("CarrierKeyDownloadManager", "setRenewelAlarm: action=" + intent.getAction() + " time=" + new Date(minExpirationDate));
    }

    private final String $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getMccMncSetFromPref() {
        int slotId = this.mPhone.getPhoneId();
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        return preferences.getString("CARRIER_KEY_DM_MCC_MNC" + slotId, null);
    }

    @VisibleForTesting
    private final String $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getSimOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        return telephonyManager.getSimOperator(this.mPhone.getSubId());
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$isValidDownload(String mccMnc) {
        String mccCurrent = "";
        String mncCurrent = "";
        String mccSource = "";
        String mncSource = "";
        String simOperator = this.getSimOperator();
        if (TextUtils.isEmpty(simOperator) || TextUtils.isEmpty(mccMnc)) {
            Log.e("CarrierKeyDownloadManager", "simOperator or mcc/mnc is empty");
            return false;
        }
        String[] splitValue = mccMnc.split(":");
        mccSource = splitValue[0];
        mncSource = splitValue[1];
        Log.d("CarrierKeyDownloadManager", "values from sharedPrefs mcc, mnc: " + mccSource + "," + mncSource);
        mccCurrent = simOperator.substring(0, 3);
        mncCurrent = simOperator.substring(3);
        Log.d("CarrierKeyDownloadManager", "using values for mcc, mnc: " + mccCurrent + "," + mncCurrent);
        return TextUtils.equals(mncSource, mncCurrent) && TextUtils.equals(mccSource, mccCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$onDownloadComplete(long carrierKeyDownloadIdentifier, String mccMnc) {
        Cursor cursor;
        block12: {
            block13: {
                Log.d("CarrierKeyDownloadManager", "onDownloadComplete: " + carrierKeyDownloadIdentifier);
                DownloadManager.Query query = new DownloadManager.Query();
                query.setFilterById(carrierKeyDownloadIdentifier);
                cursor = this.mDownloadManager.query(query);
                FileInputStream source = null;
                if (cursor == null) {
                    return;
                }
                if (!cursor.moveToFirst()) break block12;
                int columnIndex = cursor.getColumnIndex("status");
                if (8 == cursor.getInt(columnIndex)) {
                    source = new FileInputStream(this.mDownloadManager.openDownloadedFile(carrierKeyDownloadIdentifier).getFileDescriptor());
                    String jsonStr = CarrierKeyDownloadManager.convertToString(source);
                    this.parseJsonAndPersistKey(jsonStr, mccMnc);
                    this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                    try {
                        ((InputStream)source).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block13;
                    catch (Exception e) {
                        try {
                            Log.e("CarrierKeyDownloadManager", "Error in download:" + carrierKeyDownloadIdentifier + ". " + e);
                        }
                        catch (Throwable throwable) {
                            this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                            try {
                                ((InputStream)source).close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            throw throwable;
                        }
                        this.mDownloadManager.remove(carrierKeyDownloadIdentifier);
                        try {
                            ((InputStream)source).close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            Log.d("CarrierKeyDownloadManager", "Completed downloading keys");
        }
        cursor.close();
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$carrierUsesKeys() {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (carrierConfigManager == null) {
            return false;
        }
        int subId = this.mPhone.getSubId();
        PersistableBundle b = carrierConfigManager.getConfigForSubId(subId);
        if (b == null) {
            return false;
        }
        this.mKeyAvailability = b.getInt("imsi_key_availability_int");
        this.mURL = b.getString("imsi_key_download_url_string");
        if (TextUtils.isEmpty(this.mURL) || this.mKeyAvailability == 0) {
            Log.d("CarrierKeyDownloadManager", "Carrier not enabled or invalid values");
            return false;
        }
        for (int key_type : CARRIER_KEY_TYPES) {
            if (!this.isKeyEnabled(key_type)) continue;
            return true;
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$convertToString(InputStream is) {
        try {
            String line;
            GZIPInputStream gunzip = new GZIPInputStream(is);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gunzip, StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$parseJsonAndPersistKey(String jsonStr, String mccMnc) {
        if (TextUtils.isEmpty(jsonStr) || TextUtils.isEmpty(mccMnc)) {
            Log.e("CarrierKeyDownloadManager", "jsonStr or mcc, mnc: is empty");
            return;
        }
        PemReader reader = null;
        try {
            String mcc = "";
            String mnc = "";
            String[] splitValue = mccMnc.split(":");
            mcc = splitValue[0];
            mnc = splitValue[1];
            JSONObject jsonObj = new JSONObject(jsonStr);
            JSONArray keys = jsonObj.getJSONArray("carrier-keys");
            for (int i = 0; i < keys.length(); ++i) {
                JSONObject key = keys.getJSONObject(i);
                String cert = null;
                cert = key.has("certificate") ? key.getString("certificate") : key.getString("public-key");
                String typeString = key.getString("key-type");
                int type = -1;
                if (typeString.equals("WLAN")) {
                    type = 2;
                } else if (typeString.equals("EPDG")) {
                    type = 1;
                }
                String identifier = key.getString("key-identifier");
                ByteArrayInputStream inStream = new ByteArrayInputStream(cert.getBytes());
                BufferedReader fReader = new BufferedReader(new InputStreamReader(inStream));
                reader = new PemReader((Reader)fReader);
                Pair<PublicKey, Long> keyInfo = CarrierKeyDownloadManager.getKeyInformation(reader.readPemObject().getContent());
                reader.close();
                this.savePublicKey((PublicKey)keyInfo.first, type, identifier, (Long)keyInfo.second, mcc, mnc);
            }
        }
        catch (JSONException e) {
            Log.e("CarrierKeyDownloadManager", "Json parsing error: " + e.getMessage());
        }
        catch (Exception e) {
            Log.e("CarrierKeyDownloadManager", "Exception getting certificate: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                Log.e("CarrierKeyDownloadManager", "Exception getting certificate: " + e);
            }
        }
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$isKeyEnabled(int keyType) {
        int returnValue = this.mKeyAvailability >> keyType - 1 & 1;
        return returnValue == 1;
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$areCarrierKeysAbsentOrExpiring() {
        for (int key_type : CARRIER_KEY_TYPES) {
            if (!this.isKeyEnabled(key_type)) continue;
            ImsiEncryptionInfo imsiEncryptionInfo = this.mPhone.getCarrierInfoForImsiEncryption(key_type);
            if (imsiEncryptionInfo == null) {
                Log.d("CarrierKeyDownloadManager", "Key not found for: " + key_type);
                return true;
            }
            Date imsiDate = imsiEncryptionInfo.getExpirationTime();
            long timeToExpire = imsiDate.getTime() - InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            return timeToExpire < 1814400000L;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$downloadKey() {
        Log.d("CarrierKeyDownloadManager", "starting download from: " + this.mURL);
        String mcc = "";
        String mnc = "";
        String simOperator = this.getSimOperator();
        if (TextUtils.isEmpty(simOperator)) {
            Log.e("CarrierKeyDownloadManager", "mcc, mnc: is empty");
            return false;
        }
        mcc = simOperator.substring(0, 3);
        mnc = simOperator.substring(3);
        Log.d("CarrierKeyDownloadManager", "using values for mcc, mnc: " + mcc + "," + mnc);
        try {
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse(this.mURL));
            request.setAllowedOverMetered(false);
            request.setVisibleInDownloadsUi(false);
            request.setNotificationVisibility(2);
            Long carrierKeyDownloadRequestId = this.mDownloadManager.enqueue(request);
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
            String mccMnc = mcc + ":" + mnc;
            int slotId = this.mPhone.getPhoneId();
            Log.d("CarrierKeyDownloadManager", "storing values in sharedpref mcc, mnc, days: " + mcc + "," + mnc + "," + carrierKeyDownloadRequestId);
            editor.putString("CARRIER_KEY_DM_MCC_MNC" + slotId, mccMnc);
            editor.commit();
        }
        catch (Exception e) {
            Log.e("CarrierKeyDownloadManager", "exception trying to dowload key from url: " + this.mURL);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    private static final Pair<PublicKey, Long> $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getKeyInformation(byte[] certificate) throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        Pair<PublicKey, Long> keyInformation = new Pair<PublicKey, Long>(cert.getPublicKey(), cert.getNotAfter().getTime());
        return keyInformation;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$savePublicKey(PublicKey publicKey, int type, String identifier, long expirationDate, String mcc, String mnc) {
        ImsiEncryptionInfo imsiEncryptionInfo = new ImsiEncryptionInfo(mcc, mnc, type, identifier, publicKey, new Date(expirationDate));
        this.mPhone.setCarrierInfoForImsiEncryption(imsiEncryptionInfo);
    }

    static void __staticInitializer__() {
        CARRIER_KEY_TYPES = new int[]{1, 2};
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$__constructor__(phone);
    }

    public CarrierKeyDownloadManager(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    private void onPostDownloadProcessing(long l) {
        InvokeDynamicSupport.bootstrap("onPostDownloadProcessing", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$onPostDownloadProcessing(long ), 0, this, l);
    }

    private void handleAlarmOrConfigChange() {
        InvokeDynamicSupport.bootstrap("handleAlarmOrConfigChange", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$handleAlarmOrConfigChange(), 0, this);
    }

    private void cleanupDownloadPreferences(long l) {
        InvokeDynamicSupport.bootstrap("cleanupDownloadPreferences", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$cleanupDownloadPreferences(long ), 0, this, l);
    }

    private void cleanupRenewalAlarms() {
        InvokeDynamicSupport.bootstrap("cleanupRenewalAlarms", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$cleanupRenewalAlarms(), 0, this);
    }

    public long getExpirationDate() {
        return (long)InvokeDynamicSupport.bootstrap("getExpirationDate", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getExpirationDate(), 0, this);
    }

    public void resetRenewalAlarm() {
        InvokeDynamicSupport.bootstrap("resetRenewalAlarm", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$resetRenewalAlarm(), 0, this);
    }

    private String getMccMncSetFromPref() {
        return InvokeDynamicSupport.bootstrap("getMccMncSetFromPref", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getMccMncSetFromPref(), 0, this);
    }

    public String getSimOperator() {
        return InvokeDynamicSupport.bootstrap("getSimOperator", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getSimOperator(), 0, this);
    }

    public boolean isValidDownload(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDownload", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$isValidDownload(java.lang.String ), 0, this, string2);
    }

    private void onDownloadComplete(long l, String string2) {
        InvokeDynamicSupport.bootstrap("onDownloadComplete", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$onDownloadComplete(long java.lang.String ), 0, this, l, string2);
    }

    private boolean carrierUsesKeys() {
        return (boolean)InvokeDynamicSupport.bootstrap("carrierUsesKeys", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$carrierUsesKeys(), 0, this);
    }

    private static String convertToString(InputStream inputStream) {
        return InvokeDynamicSupport.bootstrapStatic("convertToString", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$convertToString(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public void parseJsonAndPersistKey(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("parseJsonAndPersistKey", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$parseJsonAndPersistKey(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean isKeyEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isKeyEnabled", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$isKeyEnabled(int ), 0, this, n);
    }

    public boolean areCarrierKeysAbsentOrExpiring() {
        return (boolean)InvokeDynamicSupport.bootstrap("areCarrierKeysAbsentOrExpiring", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$areCarrierKeysAbsentOrExpiring(), 0, this);
    }

    private boolean downloadKey() {
        return (boolean)InvokeDynamicSupport.bootstrap("downloadKey", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$downloadKey(), 0, this);
    }

    public static Pair<PublicKey, Long> getKeyInformation(byte[] byArray) throws Exception {
        return InvokeDynamicSupport.bootstrapStatic("getKeyInformation", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$getKeyInformation(byte[] ), 0, (byte[])byArray);
    }

    public void savePublicKey(PublicKey publicKey, int n, String string2, long l, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("savePublicKey", $$robo$$com_android_internal_telephony_CarrierKeyDownloadManager$savePublicKey(java.security.PublicKey int java.lang.String long java.lang.String java.lang.String ), 0, this, publicKey, n, string2, l, string3, string4);
    }

    static {
        RobolectricInternals.classInitializing(CarrierKeyDownloadManager.class);
    }

    public /* synthetic */ CarrierKeyDownloadManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierKeyDownloadManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

