/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.content.PackageMonitor;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierServiceBindHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierSvcBindHelper";
    private static int UNBIND_DELAY_MILLIS = 30000;
    private Context mContext;
    private AppBinding[] mBindings;
    private String[] mLastSimState;
    private PackageMonitor mPackageMonitor;
    private BroadcastReceiver mUserUnlockedReceiver;
    private static int EVENT_REBIND = 0;
    private static int EVENT_PERFORM_IMMEDIATE_UNBIND = 1;
    private Handler mHandler;

    private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$__constructor__(Context context) {
        this.mPackageMonitor = new CarrierServicePackageMonitor(this);
        this.mUserUnlockedReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceBindHelper this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_1$__constructor__(CarrierServiceBindHelper this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                CarrierServiceBindHelper.log("Received " + action);
                if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                    for (int phoneId = 0; phoneId < this.this$0.mBindings.length; ++phoneId) {
                        this.this$0.mBindings[phoneId].rebind();
                    }
                }
            }

            private void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_1$__constructor__(carrierServiceBindHelper);
            }
            {
                this.this$0 = carrierServiceBindHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_1$__constructor__(com.android.internal.telephony.CarrierServiceBindHelper ), 0, this, carrierServiceBindHelper);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceBindHelper this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_2$__constructor__(CarrierServiceBindHelper this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_2$handleMessage(Message msg) {
                CarrierServiceBindHelper.log("mHandler: " + msg.what);
                switch (msg.what) {
                    case 0: {
                        AppBinding binding = (AppBinding)msg.obj;
                        CarrierServiceBindHelper.log("Rebinding if necessary for phoneId: " + binding.getPhoneId());
                        binding.rebind();
                        break;
                    }
                    case 1: {
                        AppBinding binding = (AppBinding)msg.obj;
                        binding.performImmediateUnbind();
                    }
                }
            }

            private void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_2$__constructor__(carrierServiceBindHelper);
            }
            {
                this.this$0 = carrierServiceBindHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_2$__constructor__(com.android.internal.telephony.CarrierServiceBindHelper ), 0, this, carrierServiceBindHelper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        int numPhones = TelephonyManager.from(context).getPhoneCount();
        this.mBindings = new AppBinding[numPhones];
        this.mLastSimState = new String[numPhones];
        for (int phoneId = 0; phoneId < numPhones; ++phoneId) {
            this.mBindings[phoneId] = new AppBinding(this, phoneId);
        }
        this.mPackageMonitor.register(context, this.mHandler.getLooper(), UserHandle.ALL, false);
        this.mContext.registerReceiverAsUser(this.mUserUnlockedReceiver, UserHandle.SYSTEM, new IntentFilter("android.intent.action.USER_UNLOCKED"), null, this.mHandler);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$updateForPhoneId(int phoneId, String simState) {
        CarrierServiceBindHelper.log("update binding for phoneId: " + phoneId + " simState: " + simState);
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            return;
        }
        if (TextUtils.isEmpty(simState) || phoneId >= this.mLastSimState.length) {
            return;
        }
        if (simState.equals(this.mLastSimState[phoneId])) {
            return;
        }
        this.mLastSimState[phoneId] = simState;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0, this.mBindings[phoneId]));
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$log(String message) {
        Log.d("CarrierSvcBindHelper", message);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CarrierServiceBindHelper:");
        for (AppBinding binding : this.mBindings) {
            binding.dump(fd, pw, args);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper$__constructor__(context);
    }

    public CarrierServiceBindHelper(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$__constructor__(android.content.Context ), 0, this, context);
    }

    void updateForPhoneId(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateForPhoneId", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$updateForPhoneId(int java.lang.String ), 0, this, n, string2);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$log(java.lang.String ), 0, (String)string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ CarrierServiceBindHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServiceBindHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CarrierServicePackageMonitor
    extends PackageMonitor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CarrierServiceBindHelper this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$__constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageAdded(String packageName, int reason) {
            this.evaluateBinding(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageRemoved(String packageName, int reason) {
            this.evaluateBinding(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageUpdateFinished(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageModified(String packageName) {
            this.evaluateBinding(packageName, false);
        }

        private final boolean $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.evaluateBinding(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$evaluateBinding(String carrierPackageName, boolean forceUnbind) {
            for (AppBinding appBinding : this.this$0.mBindings) {
                String appBindingPackage = appBinding.getPackage();
                boolean isBindingForPackage = carrierPackageName.equals(appBindingPackage);
                if (isBindingForPackage) {
                    CarrierServiceBindHelper.log(carrierPackageName + " changed and corresponds to a phone. Rebinding.");
                }
                if (appBindingPackage != null && !isBindingForPackage) continue;
                if (forceUnbind) {
                    appBinding.unbind(true);
                }
                appBinding.rebind();
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$__constructor__(CarrierServiceBindHelper x0, 1 x1) {
        }

        private void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$__constructor__(carrierServiceBindHelper);
        }

        private CarrierServicePackageMonitor(CarrierServiceBindHelper carrierServiceBindHelper) {
            this.this$0 = carrierServiceBindHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$__constructor__(com.android.internal.telephony.CarrierServiceBindHelper ), 0, this, carrierServiceBindHelper);
        }

        @Override
        public void onPackageAdded(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageAdded", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageAdded(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageRemoved(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageRemoved", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageRemoved(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageUpdateFinished(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageUpdateFinished", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageUpdateFinished(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageModified(String string2) {
            InvokeDynamicSupport.bootstrap("onPackageModified", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onPackageModified(java.lang.String ), 0, this, string2);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("onHandleForceStop", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$onHandleForceStop(android.content.Intent java.lang.String[] int boolean ), 0, this, intent, stringArray, n, bl);
        }

        private void evaluateBinding(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("evaluateBinding", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$evaluateBinding(java.lang.String boolean ), 0, this, string2, bl);
        }

        private /* synthetic */ void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServicePackageMonitor$__constructor__(carrierServiceBindHelper, var2_2);
        }

        public /* synthetic */ CarrierServicePackageMonitor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServicePackageMonitor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CarrierServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean connected;
        /* synthetic */ CarrierServiceBindHelper this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$__constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            CarrierServiceBindHelper.log("Connected to carrier app: " + name.flattenToString());
            this.connected = true;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$onServiceDisconnected(ComponentName name) {
            CarrierServiceBindHelper.log("Disconnected from carrier app: " + name.flattenToString());
            this.connected = false;
        }

        private final String $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$toString() {
            return "CarrierServiceConnection[connected=" + this.connected + "]";
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$__constructor__(CarrierServiceBindHelper x0, 1 x1) {
        }

        private void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$__constructor__(carrierServiceBindHelper);
        }

        private CarrierServiceConnection(CarrierServiceBindHelper carrierServiceBindHelper) {
            this.this$0 = carrierServiceBindHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$__constructor__(com.android.internal.telephony.CarrierServiceBindHelper ), 0, this, carrierServiceBindHelper);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_CarrierServiceConnection$__constructor__(carrierServiceBindHelper, var2_2);
        }

        public /* synthetic */ CarrierServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AppBinding
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int phoneId;
        private CarrierServiceConnection connection;
        private int bindCount;
        private long lastBindStartMillis;
        private int unbindCount;
        private long lastUnbindMillis;
        private String carrierPackage;
        private String carrierServiceClass;
        private long mUnbindScheduledUptimeMillis;
        /* synthetic */ CarrierServiceBindHelper this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$__constructor__(CarrierServiceBindHelper carrierServiceBindHelper, int phoneId) {
            this.mUnbindScheduledUptimeMillis = -1L;
            this.phoneId = phoneId;
        }

        private final int $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$getPhoneId() {
            return this.phoneId;
        }

        private final String $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$getPackage() {
            return this.carrierPackage;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$rebind() {
            String error;
            List<String> carrierPackageNames = TelephonyManager.from(this.this$0.mContext).getCarrierPackageNamesForIntentAndPhone(new Intent("android.service.carrier.CarrierService"), this.phoneId);
            if (carrierPackageNames == null || carrierPackageNames.size() <= 0) {
                CarrierServiceBindHelper.log("No carrier app for: " + this.phoneId);
                this.unbind(false);
                return;
            }
            CarrierServiceBindHelper.log("Found carrier app: " + carrierPackageNames);
            String candidateCarrierPackage = carrierPackageNames.get(0);
            if (!TextUtils.equals(this.carrierPackage, candidateCarrierPackage)) {
                this.unbind(true);
            }
            Intent carrierService = new Intent("android.service.carrier.CarrierService");
            carrierService.setPackage(candidateCarrierPackage);
            ResolveInfo carrierResolveInfo = this.this$0.mContext.getPackageManager().resolveService(carrierService, 128);
            Bundle metadata = null;
            String candidateServiceClass = null;
            if (carrierResolveInfo != null) {
                metadata = carrierResolveInfo.serviceInfo.metaData;
                candidateServiceClass = carrierResolveInfo.getComponentInfo().getComponentName().getClassName();
            }
            if (metadata == null || !metadata.getBoolean("android.service.carrier.LONG_LIVED_BINDING", false)) {
                CarrierServiceBindHelper.log("Carrier app does not want a long lived binding");
                this.unbind(true);
                return;
            }
            if (!TextUtils.equals(this.carrierServiceClass, candidateServiceClass)) {
                this.unbind(true);
            } else if (this.connection != null) {
                this.cancelScheduledUnbind();
                return;
            }
            this.carrierPackage = candidateCarrierPackage;
            this.carrierServiceClass = candidateServiceClass;
            CarrierServiceBindHelper.log("Binding to " + this.carrierPackage + " for phone " + this.phoneId);
            ++this.bindCount;
            this.lastBindStartMillis = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.connection = new CarrierServiceConnection(this.this$0);
            try {
                if (this.this$0.mContext.bindServiceAsUser(carrierService, this.connection, 0x4000001, this.this$0.mHandler, Process.myUserHandle())) {
                    return;
                }
                error = "bindService returned false";
            }
            catch (SecurityException ex) {
                error = ex.getMessage();
            }
            CarrierServiceBindHelper.log("Unable to bind to " + this.carrierPackage + " for phone " + this.phoneId + ". Error: " + error);
            this.unbind(true);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$unbind(boolean immediate) {
            if (this.connection == null) {
                return;
            }
            if (immediate || !this.connection.connected) {
                this.cancelScheduledUnbind();
                this.performImmediateUnbind();
            } else if (this.mUnbindScheduledUptimeMillis == -1L) {
                long currentUptimeMillis = SystemClock.uptimeMillis();
                this.mUnbindScheduledUptimeMillis = currentUptimeMillis + 30000L;
                CarrierServiceBindHelper.log("Scheduling unbind in 30000 millis");
                this.this$0.mHandler.sendMessageAtTime(this.this$0.mHandler.obtainMessage(1, this), this.mUnbindScheduledUptimeMillis);
            }
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$performImmediateUnbind() {
            ++this.unbindCount;
            this.lastUnbindMillis = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.carrierPackage = null;
            this.carrierServiceClass = null;
            CarrierServiceBindHelper.log("Unbinding from carrier app");
            this.this$0.mContext.unbindService(this.connection);
            this.connection = null;
            this.mUnbindScheduledUptimeMillis = -1L;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$cancelScheduledUnbind() {
            this.this$0.mHandler.removeMessages(1);
            this.mUnbindScheduledUptimeMillis = -1L;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            pw.println("Carrier app binding for phone " + this.phoneId);
            pw.println("  connection: " + this.connection);
            pw.println("  bindCount: " + this.bindCount);
            pw.println("  lastBindStartMillis: " + this.lastBindStartMillis);
            pw.println("  unbindCount: " + this.unbindCount);
            pw.println("  lastUnbindMillis: " + this.lastUnbindMillis);
            pw.println("  mUnbindScheduledUptimeMillis: " + this.mUnbindScheduledUptimeMillis);
            pw.println();
        }

        private void __constructor__(CarrierServiceBindHelper carrierServiceBindHelper, int n) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$__constructor__(carrierServiceBindHelper, n);
        }

        public AppBinding(CarrierServiceBindHelper carrierServiceBindHelper, int n) {
            this.this$0 = carrierServiceBindHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$__constructor__(com.android.internal.telephony.CarrierServiceBindHelper int ), 0, this, carrierServiceBindHelper, n);
        }

        public int getPhoneId() {
            return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$getPhoneId(), 0, this);
        }

        public String getPackage() {
            return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$getPackage(), 0, this);
        }

        void rebind() {
            InvokeDynamicSupport.bootstrap("rebind", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$rebind(), 0, this);
        }

        void unbind(boolean bl) {
            InvokeDynamicSupport.bootstrap("unbind", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$unbind(boolean ), 0, this, bl);
        }

        private void performImmediateUnbind() {
            InvokeDynamicSupport.bootstrap("performImmediateUnbind", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$performImmediateUnbind(), 0, this);
        }

        private void cancelScheduledUnbind() {
            InvokeDynamicSupport.bootstrap("cancelScheduledUnbind", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$cancelScheduledUnbind(), 0, this);
        }

        public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_CarrierServiceBindHelper_AppBinding$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
        }

        public /* synthetic */ AppBinding() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppBinding)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

