/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierServiceStateTracker
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CSST";
    protected static int CARRIER_EVENT_BASE = 100;
    protected static int CARRIER_EVENT_VOICE_REGISTRATION = 101;
    protected static int CARRIER_EVENT_VOICE_DEREGISTRATION = 102;
    protected static int CARRIER_EVENT_DATA_REGISTRATION = 103;
    protected static int CARRIER_EVENT_DATA_DEREGISTRATION = 104;
    private static int UNINITIALIZED_DELAY_VALUE = -1;
    private Phone mPhone;
    private ServiceStateTracker mSST;
    private Map<Integer, NotificationType> mNotificationTypeMap;
    private int mPreviousSubId;
    public static int NOTIFICATION_PREF_NETWORK = 1000;
    public static int NOTIFICATION_EMERGENCY_NETWORK = 1001;
    private ContentObserver mPrefNetworkModeObserver;
    private BroadcastReceiver mBroadcastReceiver;

    private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(Phone phone, ServiceStateTracker sst) {
        this.mNotificationTypeMap = new HashMap<Integer, NotificationType>();
        this.mPreviousSubId = -1;
        this.mPrefNetworkModeObserver = new ShadowedObject(this, this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceStateTracker this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_2$__constructor__(CarrierServiceStateTracker this$0, Handler x0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_2$onChange(boolean selfChange) {
                this.this$0.handlePrefNetworkModeChanged();
            }

            private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker, Handler handler) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_2$__constructor__(carrierServiceStateTracker, handler);
            }
            {
                this.this$0 = carrierServiceStateTracker;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_2$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker android.os.Handler ), 0, this, carrierServiceStateTracker, handler);
            }

            @Override
            public void onChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_2$onChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceStateTracker this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_3$__constructor__(CarrierServiceStateTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_3$onReceive(Context context, Intent intent) {
                CarrierConfigManager carrierConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
                PersistableBundle b = carrierConfigManager.getConfigForSubId(this.this$0.mPhone.getSubId());
                for (Map.Entry entry : this.this$0.mNotificationTypeMap.entrySet()) {
                    NotificationType notificationType = (NotificationType)entry.getValue();
                    notificationType.setDelay(b);
                }
                this.this$0.handleConfigChanges();
            }

            private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_3$__constructor__(carrierServiceStateTracker);
            }
            {
                this.this$0 = carrierServiceStateTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_3$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker ), 0, this, carrierServiceStateTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_3$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mSST = sst;
        phone.getContext().registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        SubscriptionManager.from(this.mPhone.getContext()).addOnSubscriptionsChangedListener((SubscriptionManager.OnSubscriptionsChangedListener)new ShadowedObject(this, this.getLooper()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceStateTracker this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(CarrierServiceStateTracker this$0, Looper x0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$onSubscriptionsChanged() {
                int subId = this.this$0.mPhone.getSubId();
                if (this.this$0.mPreviousSubId != subId) {
                    this.this$0.mPreviousSubId = subId;
                    this.this$0.registerPrefNetworkModeObserver();
                }
            }

            private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker, Looper looper) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(carrierServiceStateTracker, looper);
            }
            {
                this.this$0 = carrierServiceStateTracker;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker android.os.Looper ), 0, this, carrierServiceStateTracker, looper);
            }

            @Override
            public void onSubscriptionsChanged() {
                InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$onSubscriptionsChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.registerNotificationTypes();
        this.registerPrefNetworkModeObserver();
    }

    @VisibleForTesting
    private final ContentObserver $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getContentObserver() {
        return this.mPrefNetworkModeObserver;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$registerPrefNetworkModeObserver() {
        int subId = this.mPhone.getSubId();
        this.unregisterPrefNetworkModeObserver();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            this.mPhone.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("preferred_network_mode" + subId), true, this.mPrefNetworkModeObserver);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$unregisterPrefNetworkModeObserver() {
        this.mPhone.getContext().getContentResolver().unregisterContentObserver(this.mPrefNetworkModeObserver);
    }

    @VisibleForTesting
    private final Map<Integer, NotificationType> $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationTypeMap() {
        return this.mNotificationTypeMap;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$registerNotificationTypes() {
        this.mNotificationTypeMap.put(1000, new PrefNetworkNotification(this, 1000));
        this.mNotificationTypeMap.put(1001, new EmergencyNetworkNotification(this, 1001));
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleMessage(Message msg) {
        switch (msg.what) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                this.handleConfigChanges();
                break;
            }
            case 1000: 
            case 1001: {
                Rlog.d("CSST", "sending notification after delay: " + msg.what);
                NotificationType notificationType = this.mNotificationTypeMap.get(msg.what);
                if (notificationType == null) break;
                this.sendNotification(notificationType);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneStillRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0 || this.mSST.mSS.getDataRegState() == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneVoiceRegistered() {
        if (this.mSST.mSS == null) {
            return true;
        }
        return this.mSST.mSS.getVoiceRegState() == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneRegisteredForWifiCalling() {
        Rlog.d("CSST", "isPhoneRegisteredForWifiCalling: " + this.mPhone.isWifiCallingEnabled());
        return this.mPhone.isWifiCallingEnabled();
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isRadioOffOrAirplaneMode() {
        Context context = this.mPhone.getContext();
        int airplaneMode = -1;
        try {
            airplaneMode = Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0);
        }
        catch (Exception e) {
            Rlog.e("CSST", "Unable to get AIRPLACE_MODE_ON.");
            return true;
        }
        return !this.mSST.isRadioOn() || airplaneMode != 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isGlobalMode() {
        Context context = this.mPhone.getContext();
        int preferredNetworkSetting = -1;
        try {
            preferredNetworkSetting = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + this.mPhone.getSubId(), Phone.PREFERRED_NT_MODE);
        }
        catch (Exception e) {
            Rlog.e("CSST", "Unable to get PREFERRED_NETWORK_MODE.");
            return true;
        }
        return preferredNetworkSetting == 10;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleConfigChanges() {
        for (Map.Entry<Integer, NotificationType> entry : this.mNotificationTypeMap.entrySet()) {
            NotificationType notificationType = entry.getValue();
            this.evaluateSendingMessageOrCancelNotification(notificationType);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handlePrefNetworkModeChanged() {
        NotificationType notificationType = this.mNotificationTypeMap.get(1000);
        if (notificationType != null) {
            this.evaluateSendingMessageOrCancelNotification(notificationType);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$evaluateSendingMessageOrCancelNotification(NotificationType notificationType) {
        if (this.evaluateSendingMessage(notificationType)) {
            Message notificationMsg = this.obtainMessage(notificationType.getTypeId(), null);
            Rlog.i("CSST", "starting timer for notifications." + notificationType.getTypeId());
            this.sendMessageDelayed(notificationMsg, this.getDelay(notificationType));
        } else {
            this.cancelNotification(notificationType.getTypeId());
            Rlog.i("CSST", "canceling notifications: " + notificationType.getTypeId());
        }
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$evaluateSendingMessage(NotificationType notificationType) {
        return notificationType.sendMessage();
    }

    @VisibleForTesting
    private final int $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getDelay(NotificationType notificationType) {
        return notificationType.getDelay();
    }

    @VisibleForTesting
    private final Notification.Builder $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationBuilder(NotificationType notificationType) {
        return notificationType.getNotificationBuilder();
    }

    @VisibleForTesting
    private final NotificationManager $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$sendNotification(NotificationType notificationType) {
        if (!this.evaluateSendingMessage(notificationType)) {
            return;
        }
        Context context = this.mPhone.getContext();
        Notification.Builder builder = this.getNotificationBuilder(notificationType);
        builder.setWhen((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")).setAutoCancel(true).setSmallIcon(17301642).setColor(context.getResources().getColor(17170774));
        this.getNotificationManager(context).notify(notificationType.getTypeId(), builder.build());
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$cancelNotification(int notificationId) {
        Context context = this.mPhone.getContext();
        this.removeMessages(notificationId);
        this.getNotificationManager(context).cancel(notificationId);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$dispose() {
        this.unregisterPrefNetworkModeObserver();
    }

    private void __constructor__(Phone phone, ServiceStateTracker serviceStateTracker) {
        this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(phone, serviceStateTracker);
    }

    public CarrierServiceStateTracker(Phone phone, ServiceStateTracker serviceStateTracker) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.ServiceStateTracker ), 0, this, phone, serviceStateTracker);
    }

    public ContentObserver getContentObserver() {
        return InvokeDynamicSupport.bootstrap("getContentObserver", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getContentObserver(), 0, this);
    }

    private void registerPrefNetworkModeObserver() {
        InvokeDynamicSupport.bootstrap("registerPrefNetworkModeObserver", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$registerPrefNetworkModeObserver(), 0, this);
    }

    private void unregisterPrefNetworkModeObserver() {
        InvokeDynamicSupport.bootstrap("unregisterPrefNetworkModeObserver", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$unregisterPrefNetworkModeObserver(), 0, this);
    }

    public Map<Integer, NotificationType> getNotificationTypeMap() {
        return InvokeDynamicSupport.bootstrap("getNotificationTypeMap", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationTypeMap(), 0, this);
    }

    private void registerNotificationTypes() {
        InvokeDynamicSupport.bootstrap("registerNotificationTypes", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$registerNotificationTypes(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    private boolean isPhoneStillRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneStillRegistered", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneStillRegistered(), 0, this);
    }

    private boolean isPhoneVoiceRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneVoiceRegistered", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneVoiceRegistered(), 0, this);
    }

    private boolean isPhoneRegisteredForWifiCalling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneRegisteredForWifiCalling", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isPhoneRegisteredForWifiCalling(), 0, this);
    }

    public boolean isRadioOffOrAirplaneMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioOffOrAirplaneMode", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isRadioOffOrAirplaneMode(), 0, this);
    }

    private boolean isGlobalMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalMode", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isGlobalMode(), 0, this);
    }

    private void handleConfigChanges() {
        InvokeDynamicSupport.bootstrap("handleConfigChanges", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleConfigChanges(), 0, this);
    }

    private void handlePrefNetworkModeChanged() {
        InvokeDynamicSupport.bootstrap("handlePrefNetworkModeChanged", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handlePrefNetworkModeChanged(), 0, this);
    }

    private void evaluateSendingMessageOrCancelNotification(NotificationType notificationType) {
        InvokeDynamicSupport.bootstrap("evaluateSendingMessageOrCancelNotification", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$evaluateSendingMessageOrCancelNotification(com.android.internal.telephony.CarrierServiceStateTracker$NotificationType ), 0, this, notificationType);
    }

    public boolean evaluateSendingMessage(NotificationType notificationType) {
        return (boolean)InvokeDynamicSupport.bootstrap("evaluateSendingMessage", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$evaluateSendingMessage(com.android.internal.telephony.CarrierServiceStateTracker$NotificationType ), 0, this, notificationType);
    }

    public int getDelay(NotificationType notificationType) {
        return (int)InvokeDynamicSupport.bootstrap("getDelay", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getDelay(com.android.internal.telephony.CarrierServiceStateTracker$NotificationType ), 0, this, notificationType);
    }

    public Notification.Builder getNotificationBuilder(NotificationType notificationType) {
        return InvokeDynamicSupport.bootstrap("getNotificationBuilder", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationBuilder(com.android.internal.telephony.CarrierServiceStateTracker$NotificationType ), 0, this, notificationType);
    }

    public NotificationManager getNotificationManager(Context context) {
        return InvokeDynamicSupport.bootstrap("getNotificationManager", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$getNotificationManager(android.content.Context ), 0, this, context);
    }

    public void sendNotification(NotificationType notificationType) {
        InvokeDynamicSupport.bootstrap("sendNotification", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$sendNotification(com.android.internal.telephony.CarrierServiceStateTracker$NotificationType ), 0, this, notificationType);
    }

    public void cancelNotification(int n) {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$cancelNotification(int ), 0, this, n);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$dispose(), 0, this);
    }

    public /* synthetic */ CarrierServiceStateTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServiceStateTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class EmergencyNetworkNotification
    implements NotificationType,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTypeId;
        private int mDelay;
        /* synthetic */ CarrierServiceStateTracker this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$__constructor__(CarrierServiceStateTracker this$0, int typeId) {
            this.mDelay = -1;
            this.mTypeId = typeId;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e("CSST", "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("emergency_notification_delay_int");
            Rlog.i("CSST", "reading time to delay notification emergency: " + this.mDelay);
        }

        private final int $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getDelay() {
            return this.mDelay;
        }

        private final int $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getTypeId() {
            return this.mTypeId;
        }

        private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$sendMessage() {
            Rlog.i("CSST", "EmergencyNetworkNotification: sendMessage() w/values: ," + this.this$0.isPhoneVoiceRegistered() + "," + this.mDelay + "," + this.this$0.isPhoneRegisteredForWifiCalling() + "," + this.this$0.mSST.isRadioOn());
            return this.mDelay != -1 && !this.this$0.isPhoneVoiceRegistered() && this.this$0.isPhoneRegisteredForWifiCalling();
        }

        private final Notification.Builder $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getNotificationBuilder() {
            Context context = this.this$0.mPhone.getContext();
            CharSequence title = context.getText(17039404);
            CharSequence details = context.getText(17039403);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("wfc");
        }

        private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker, int n) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$__constructor__(carrierServiceStateTracker, n);
        }

        EmergencyNetworkNotification(CarrierServiceStateTracker carrierServiceStateTracker, int n) {
            this.this$0 = carrierServiceStateTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker int ), 0, this, carrierServiceStateTracker, n);
        }

        @Override
        public void setDelay(PersistableBundle persistableBundle) {
            InvokeDynamicSupport.bootstrap("setDelay", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$setDelay(android.os.PersistableBundle ), 0, this, persistableBundle);
        }

        @Override
        public int getDelay() {
            return (int)InvokeDynamicSupport.bootstrap("getDelay", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getDelay(), 0, this);
        }

        @Override
        public int getTypeId() {
            return (int)InvokeDynamicSupport.bootstrap("getTypeId", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getTypeId(), 0, this);
        }

        @Override
        public boolean sendMessage() {
            return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$sendMessage(), 0, this);
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            return InvokeDynamicSupport.bootstrap("getNotificationBuilder", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_EmergencyNetworkNotification$getNotificationBuilder(), 0, this);
        }

        public /* synthetic */ EmergencyNetworkNotification() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EmergencyNetworkNotification)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class PrefNetworkNotification
    implements NotificationType,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTypeId;
        private int mDelay;
        /* synthetic */ CarrierServiceStateTracker this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$__constructor__(CarrierServiceStateTracker this$0, int typeId) {
            this.mDelay = -1;
            this.mTypeId = typeId;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$setDelay(PersistableBundle bundle) {
            if (bundle == null) {
                Rlog.e("CSST", "bundle is null");
                return;
            }
            this.mDelay = bundle.getInt("network_notification_delay_int");
            Rlog.i("CSST", "reading time to delay notification pref network: " + this.mDelay);
        }

        private final int $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getDelay() {
            return this.mDelay;
        }

        private final int $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getTypeId() {
            return this.mTypeId;
        }

        private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$sendMessage() {
            Rlog.i("CSST", "PrefNetworkNotification: sendMessage() w/values: ," + this.this$0.isPhoneStillRegistered() + "," + this.mDelay + "," + this.this$0.isGlobalMode() + "," + this.this$0.mSST.isRadioOn());
            return this.mDelay != -1 && !this.this$0.isPhoneStillRegistered() && !this.this$0.isGlobalMode() && !this.this$0.isRadioOffOrAirplaneMode();
        }

        private final Notification.Builder $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getNotificationBuilder() {
            Context context = this.this$0.mPhone.getContext();
            Intent notificationIntent = new Intent("android.settings.DATA_ROAMING_SETTINGS");
            notificationIntent.putExtra("expandable", true);
            PendingIntent settingsIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0x40000000);
            CharSequence title = context.getText(17039407);
            CharSequence details = context.getText(17039406);
            return new Notification.Builder(context).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("alert").setContentIntent(settingsIntent);
        }

        private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker, int n) {
            this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$__constructor__(carrierServiceStateTracker, n);
        }

        PrefNetworkNotification(CarrierServiceStateTracker carrierServiceStateTracker, int n) {
            this.this$0 = carrierServiceStateTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker int ), 0, this, carrierServiceStateTracker, n);
        }

        @Override
        public void setDelay(PersistableBundle persistableBundle) {
            InvokeDynamicSupport.bootstrap("setDelay", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$setDelay(android.os.PersistableBundle ), 0, this, persistableBundle);
        }

        @Override
        public int getDelay() {
            return (int)InvokeDynamicSupport.bootstrap("getDelay", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getDelay(), 0, this);
        }

        @Override
        public int getTypeId() {
            return (int)InvokeDynamicSupport.bootstrap("getTypeId", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getTypeId(), 0, this);
        }

        @Override
        public boolean sendMessage() {
            return (boolean)InvokeDynamicSupport.bootstrap("sendMessage", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$sendMessage(), 0, this);
        }

        @Override
        public Notification.Builder getNotificationBuilder() {
            return InvokeDynamicSupport.bootstrap("getNotificationBuilder", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_PrefNetworkNotification$getNotificationBuilder(), 0, this);
        }

        public /* synthetic */ PrefNetworkNotification() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrefNetworkNotification)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface NotificationType
    extends InstrumentedInterface {
        public boolean sendMessage();

        public int getDelay();

        public void setDelay(PersistableBundle var1);

        public int getTypeId();

        public Notification.Builder getNotificationBuilder();
    }
}

