/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.RemoteException;
import android.service.carrier.ICarrierMessagingCallback;
import android.service.carrier.ICarrierMessagingService;
import android.service.carrier.MessagePdu;
import android.telephony.CarrierMessagingServiceManager;
import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CarrierSmsUtils;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierServicesSmsFilter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static boolean DBG = true;
    private Context mContext;
    private Phone mPhone;
    private byte[][] mPdus;
    private int mDestPort;
    private String mPduFormat;
    private CarrierServicesSmsFilterCallbackInterface mCarrierServicesSmsFilterCallback;
    private String mLogTag;

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$__constructor__(Context context, Phone phone, byte[][] pdus, int destPort, String pduFormat, CarrierServicesSmsFilterCallbackInterface carrierServicesSmsFilterCallback, String logTag) {
        this.mContext = context;
        this.mPhone = phone;
        this.mPdus = pdus;
        this.mDestPort = destPort;
        this.mPduFormat = pduFormat;
        this.mCarrierServicesSmsFilterCallback = carrierServicesSmsFilterCallback;
        this.mLogTag = logTag;
    }

    @VisibleForTesting
    private final boolean $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$filter() {
        String carrierImsPackage;
        Optional<String> carrierAppForFiltering = this.getCarrierAppPackageForFiltering();
        ArrayList<String> smsFilterPackages = new ArrayList<String>();
        if (carrierAppForFiltering.isPresent()) {
            smsFilterPackages.add(carrierAppForFiltering.get());
        }
        if ((carrierImsPackage = CarrierSmsUtils.getCarrierImsPackageForIntent(this.mContext, this.mPhone, new Intent("android.service.carrier.CarrierMessagingService"))) != null) {
            smsFilterPackages.add(carrierImsPackage);
        }
        FilterAggregator filterAggregator = new FilterAggregator(this, smsFilterPackages.size());
        for (String smsFilterPackage : smsFilterPackages) {
            this.filterWithPackage(smsFilterPackage, filterAggregator);
        }
        boolean handled = smsFilterPackages.size() > 0;
        return handled;
    }

    private final Optional<String> $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$getCarrierAppPackageForFiltering() {
        List<String> carrierPackages = null;
        UiccCard card = UiccController.getInstance().getUiccCard(this.mPhone.getPhoneId());
        if (card != null) {
            carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), new Intent("android.service.carrier.CarrierMessagingService"));
        } else {
            Rlog.e(this.mLogTag, "UiccCard not initialized.");
        }
        if (carrierPackages != null && carrierPackages.size() == 1) {
            this.log("Found carrier package.");
            return Optional.of(carrierPackages.get(0));
        }
        List<String> systemPackages = this.getSystemAppForIntent(new Intent("android.service.carrier.CarrierMessagingService"));
        if (systemPackages != null && systemPackages.size() == 1) {
            this.log("Found system package.");
            return Optional.of(systemPackages.get(0));
        }
        this.logv("Unable to find carrier package: " + carrierPackages + ", nor systemPackages: " + systemPackages);
        return Optional.empty();
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$filterWithPackage(String packageName, FilterAggregator filterAggregator) {
        CarrierSmsFilter smsFilter = new CarrierSmsFilter(this, this.mPdus, this.mDestPort, this.mPduFormat);
        CarrierSmsFilterCallback smsFilterCallback = new CarrierSmsFilterCallback(this, filterAggregator, smsFilter);
        smsFilter.filterSms(packageName, smsFilterCallback);
    }

    private final List<String> $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$getSystemAppForIntent(Intent intent) {
        ArrayList<String> packages = new ArrayList<String>();
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> receivers = packageManager.queryIntentServices(intent, 0);
        String carrierFilterSmsPerm = "android.permission.CARRIER_FILTER_SMS";
        for (ResolveInfo info : receivers) {
            if (info.serviceInfo == null) {
                this.loge("Can't get service information from " + info);
                continue;
            }
            String packageName = info.serviceInfo.packageName;
            if (packageManager.checkPermission(carrierFilterSmsPerm, packageName) != 0) continue;
            packages.add(packageName);
            this.log("getSystemAppForIntent: added package " + packageName);
        }
        return packages;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$log(String message) {
        Rlog.d(this.mLogTag, message);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$loge(String message) {
        Rlog.e(this.mLogTag, message);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$logv(String message) {
        Rlog.e(this.mLogTag, message);
    }

    private void __constructor__(Context context, Phone phone, byte[][] byArray, int n, String string2, CarrierServicesSmsFilterCallbackInterface carrierServicesSmsFilterCallbackInterface, String string3) {
        this.$$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$__constructor__(context, phone, byArray, n, string2, carrierServicesSmsFilterCallbackInterface, string3);
    }

    public CarrierServicesSmsFilter(Context context, Phone phone, byte[][] byArray, int n, String string2, CarrierServicesSmsFilterCallbackInterface carrierServicesSmsFilterCallbackInterface, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$__constructor__(android.content.Context com.android.internal.telephony.Phone byte[][] int java.lang.String com.android.internal.telephony.CarrierServicesSmsFilter$CarrierServicesSmsFilterCallbackInterface java.lang.String ), 0, this, context, phone, byArray, n, string2, carrierServicesSmsFilterCallbackInterface, string3);
    }

    public boolean filter() {
        return (boolean)InvokeDynamicSupport.bootstrap("filter", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$filter(), 0, this);
    }

    private Optional<String> getCarrierAppPackageForFiltering() {
        return InvokeDynamicSupport.bootstrap("getCarrierAppPackageForFiltering", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$getCarrierAppPackageForFiltering(), 0, this);
    }

    private void filterWithPackage(String string2, FilterAggregator filterAggregator) {
        InvokeDynamicSupport.bootstrap("filterWithPackage", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$filterWithPackage(java.lang.String com.android.internal.telephony.CarrierServicesSmsFilter$FilterAggregator ), 0, this, string2, filterAggregator);
    }

    private List<String> getSystemAppForIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getSystemAppForIntent", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$getSystemAppForIntent(android.content.Intent ), 0, this, intent);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$loge(java.lang.String ), 0, this, string2);
    }

    private void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter$logv(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ CarrierServicesSmsFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServicesSmsFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class FilterAggregator
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Object mFilterLock;
        private int mNumPendingFilters;
        private int mFilterResult;
        /* synthetic */ CarrierServicesSmsFilter this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$__constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, int numFilters) {
            this.mFilterLock = new Object();
            this.mNumPendingFilters = numFilters;
            this.mFilterResult = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$onFilterComplete(int result) {
            Object object = this.mFilterLock;
            synchronized (object) {
                --this.mNumPendingFilters;
                this.combine(result);
                if (this.mNumPendingFilters == 0) {
                    long token = Binder.clearCallingIdentity();
                    try {
                        this.this$0.mCarrierServicesSmsFilterCallback.onFilterComplete(this.mFilterResult);
                    }
                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$combine(int result) {
            this.mFilterResult |= result;
        }

        private void __constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, int n) {
            this.$$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$__constructor__(carrierServicesSmsFilter, n);
        }

        FilterAggregator(CarrierServicesSmsFilter carrierServicesSmsFilter, int n) {
            this.this$0 = carrierServicesSmsFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$__constructor__(com.android.internal.telephony.CarrierServicesSmsFilter int ), 0, this, carrierServicesSmsFilter, n);
        }

        void onFilterComplete(int n) {
            InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$onFilterComplete(int ), 0, this, n);
        }

        private void combine(int n) {
            InvokeDynamicSupport.bootstrap("combine", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_FilterAggregator$combine(int ), 0, this, n);
        }

        public /* synthetic */ FilterAggregator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FilterAggregator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CarrierSmsFilterCallback
    extends ICarrierMessagingCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FilterAggregator mFilterAggregator;
        private CarrierMessagingServiceManager mCarrierMessagingServiceManager;
        /* synthetic */ CarrierServicesSmsFilter this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$__constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, FilterAggregator filterAggregator, CarrierMessagingServiceManager carrierMessagingServiceManager) {
            this.mFilterAggregator = filterAggregator;
            this.mCarrierMessagingServiceManager = carrierMessagingServiceManager;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onFilterComplete(int result) {
            this.mCarrierMessagingServiceManager.disposeConnection(this.this$0.mContext);
            this.mFilterAggregator.onFilterComplete(result);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendSmsComplete(int result, int messageRef) {
            this.this$0.loge("Unexpected onSendSmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendMultipartSmsComplete(int result, int[] messageRefs) {
            this.this$0.loge("Unexpected onSendMultipartSmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendMmsComplete(int result, byte[] sendConfPdu) {
            this.this$0.loge("Unexpected onSendMmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onDownloadMmsComplete(int result) {
            this.this$0.loge("Unexpected onDownloadMmsComplete call with result: " + result);
        }

        private void __constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, FilterAggregator filterAggregator, CarrierMessagingServiceManager carrierMessagingServiceManager) {
            this.$$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$__constructor__(carrierServicesSmsFilter, filterAggregator, carrierMessagingServiceManager);
        }

        CarrierSmsFilterCallback(CarrierServicesSmsFilter carrierServicesSmsFilter, FilterAggregator filterAggregator, CarrierMessagingServiceManager carrierMessagingServiceManager) {
            this.this$0 = carrierServicesSmsFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$__constructor__(com.android.internal.telephony.CarrierServicesSmsFilter com.android.internal.telephony.CarrierServicesSmsFilter$FilterAggregator android.telephony.CarrierMessagingServiceManager ), 0, this, carrierServicesSmsFilter, filterAggregator, carrierMessagingServiceManager);
        }

        @Override
        public void onFilterComplete(int n) {
            InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onFilterComplete(int ), 0, this, n);
        }

        @Override
        public void onSendSmsComplete(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSendSmsComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendSmsComplete(int int ), 0, this, n, n2);
        }

        @Override
        public void onSendMultipartSmsComplete(int n, int[] nArray) {
            InvokeDynamicSupport.bootstrap("onSendMultipartSmsComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendMultipartSmsComplete(int int[] ), 0, this, n, nArray);
        }

        @Override
        public void onSendMmsComplete(int n, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSendMmsComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onSendMmsComplete(int byte[] ), 0, this, n, byArray);
        }

        @Override
        public void onDownloadMmsComplete(int n) {
            InvokeDynamicSupport.bootstrap("onDownloadMmsComplete", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilterCallback$onDownloadMmsComplete(int ), 0, this, n);
        }

        public /* synthetic */ CarrierSmsFilterCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierSmsFilterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CarrierSmsFilter
    extends CarrierMessagingServiceManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[][] mPdus;
        private int mDestPort;
        private String mSmsFormat;
        private volatile CarrierSmsFilterCallback mSmsFilterCallback;
        /* synthetic */ CarrierServicesSmsFilter this$0;

        private void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$__constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, byte[][] pdus, int destPort, String smsFormat) {
            this.mPdus = pdus;
            this.mDestPort = destPort;
            this.mSmsFormat = smsFormat;
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$filterSms(String carrierPackageName, CarrierSmsFilterCallback smsFilterCallback) {
            this.mSmsFilterCallback = smsFilterCallback;
            if (!this.bindToCarrierMessagingService(this.this$0.mContext, carrierPackageName)) {
                this.this$0.loge("bindService() for carrier messaging service failed");
                smsFilterCallback.onFilterComplete(0);
            } else {
                this.this$0.logv("bindService() for carrier messaging service succeeded");
            }
        }

        private final void $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$onServiceReady(ICarrierMessagingService carrierMessagingService) {
            try {
                carrierMessagingService.filterSms(new MessagePdu(Arrays.asList(this.mPdus)), this.mSmsFormat, this.mDestPort, this.this$0.mPhone.getSubId(), this.mSmsFilterCallback);
            }
            catch (RemoteException e) {
                this.this$0.loge("Exception filtering the SMS: " + e);
                this.mSmsFilterCallback.onFilterComplete(0);
            }
        }

        private void __constructor__(CarrierServicesSmsFilter carrierServicesSmsFilter, byte[][] byArray, int n, String string2) {
            this.$$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$__constructor__(carrierServicesSmsFilter, byArray, n, string2);
        }

        CarrierSmsFilter(CarrierServicesSmsFilter carrierServicesSmsFilter, byte[][] byArray, int n, String string2) {
            this.this$0 = carrierServicesSmsFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$__constructor__(com.android.internal.telephony.CarrierServicesSmsFilter byte[][] int java.lang.String ), 0, this, carrierServicesSmsFilter, byArray, n, string2);
        }

        void filterSms(String string2, CarrierSmsFilterCallback carrierSmsFilterCallback) {
            InvokeDynamicSupport.bootstrap("filterSms", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$filterSms(java.lang.String com.android.internal.telephony.CarrierServicesSmsFilter$CarrierSmsFilterCallback ), 0, this, string2, carrierSmsFilterCallback);
        }

        @Override
        protected void onServiceReady(ICarrierMessagingService iCarrierMessagingService) {
            InvokeDynamicSupport.bootstrap("onServiceReady", $$robo$$com_android_internal_telephony_CarrierServicesSmsFilter_CarrierSmsFilter$onServiceReady(android.service.carrier.ICarrierMessagingService ), 0, this, iCarrierMessagingService);
        }

        public /* synthetic */ CarrierSmsFilter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierSmsFilter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public static interface CarrierServicesSmsFilterCallbackInterface
    extends InstrumentedInterface {
        public void onFilterComplete(int var1);
    }
}

