/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierSignalAgent
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private static boolean DBG = true;
    private static boolean VDBG;
    private static boolean WAKE = true;
    private static boolean NO_WAKE = false;
    private static String COMPONENT_NAME_DELIMITER = "\\s*:\\s*";
    private static String CARRIER_SIGNAL_DELIMITER = "\\s*,\\s*";
    private Phone mPhone;
    private boolean mDefaultNetworkAvail;
    private Map<String, Set<ComponentName>> mCachedWakeSignalConfigs;
    private Map<String, Set<ComponentName>> mCachedNoWakeSignalConfigs;
    private static int EVENT_REGISTER_DEFAULT_NETWORK_AVAIL = 0;
    private Set<String> mCarrierSignalList;
    private LocalLog mErrorLocalLog;
    private BroadcastReceiver mReceiver;
    private ConnectivityManager.NetworkCallback mNetworkCallback;

    private void $$robo$$com_android_internal_telephony_CarrierSignalAgent$__constructor__(Phone phone) {
        this.mCachedWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
        this.mCachedNoWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
        this.mCarrierSignalList = new HashSet<String>(Arrays.asList("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE", "com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED", "com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED", "com.android.internal.telephony.CARRIER_SIGNAL_RESET", "com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE"));
        this.mErrorLocalLog = new LocalLog(20);
        this.mReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierSignalAgent this$0;

            private void $$robo$$com_android_internal_telephony_CarrierSignalAgent_1$__constructor__(CarrierSignalAgent this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                this.this$0.log("CarrierSignalAgent receiver action: " + action);
                if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    this.this$0.loadCarrierConfig();
                }
            }

            private void __constructor__(CarrierSignalAgent carrierSignalAgent) {
                this.$$robo$$com_android_internal_telephony_CarrierSignalAgent_1$__constructor__(carrierSignalAgent);
            }
            {
                this.this$0 = carrierSignalAgent;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierSignalAgent_1$__constructor__(com.android.internal.telephony.CarrierSignalAgent ), 0, this, carrierSignalAgent);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierSignalAgent_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.loadCarrierConfig();
        this.mPhone.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        this.mPhone.getCarrierActionAgent().registerForCarrierAction(3, this, 0, null, false);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.e(LOG_TAG, "Register default network exception: " + ar.exception);
                    return;
                }
                ConnectivityManager connectivityMgr = ConnectivityManager.from(this.mPhone.getContext());
                if (((Boolean)ar.result).booleanValue()) {
                    this.mNetworkCallback = new ShadowedObject(this){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ CarrierSignalAgent this$0;

                        private void $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$__constructor__(CarrierSignalAgent this$0) {
                        }

                        private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$onAvailable(Network network) {
                            if (!this.this$0.mDefaultNetworkAvail) {
                                this.this$0.log("Default network available: " + network);
                                Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE");
                                intent.putExtra("defaultNetworkAvailable", true);
                                this.this$0.notifyCarrierSignalReceivers(intent);
                                this.this$0.mDefaultNetworkAvail = true;
                            }
                        }

                        private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$onLost(Network network) {
                            this.this$0.log("Default network lost: " + network);
                            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE");
                            intent.putExtra("defaultNetworkAvailable", false);
                            this.this$0.notifyCarrierSignalReceivers(intent);
                            this.this$0.mDefaultNetworkAvail = false;
                        }

                        private void __constructor__(CarrierSignalAgent carrierSignalAgent) {
                            this.$$robo$$com_android_internal_telephony_CarrierSignalAgent_2$__constructor__(carrierSignalAgent);
                        }
                        {
                            this.this$0 = carrierSignalAgent;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$__constructor__(com.android.internal.telephony.CarrierSignalAgent ), 0, this, carrierSignalAgent);
                        }

                        @Override
                        public void onAvailable(Network network) {
                            InvokeDynamicSupport.bootstrap("onAvailable", $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$onAvailable(android.net.Network ), 0, this, network);
                        }

                        @Override
                        public void onLost(Network network) {
                            InvokeDynamicSupport.bootstrap("onLost", $$robo$$com_android_internal_telephony_CarrierSignalAgent_2$onLost(android.net.Network ), 0, this, network);
                        }
                        {
                            this.$$robo$init();
                        }

                        @Override
                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        @Override
                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    };
                    connectivityMgr.registerDefaultNetworkCallback(this.mNetworkCallback, this.mPhone);
                    this.log("Register default network");
                    break;
                }
                if (this.mNetworkCallback == null) break;
                connectivityMgr.unregisterNetworkCallback(this.mNetworkCallback);
                this.mNetworkCallback = null;
                this.mDefaultNetworkAvail = false;
                this.log("unregister default network");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$loadCarrierConfig() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        PersistableBundle b = null;
        if (configManager != null) {
            b = configManager.getConfig();
        }
        if (b != null) {
            Map<String, Set<ComponentName>> config;
            Map<String, Set<ComponentName>> map = this.mCachedWakeSignalConfigs;
            synchronized (map) {
                this.log("Loading carrier config: carrier_app_wake_signal_config");
                config = this.parseAndCache(b.getStringArray("carrier_app_wake_signal_config"));
                if (!this.mCachedWakeSignalConfigs.isEmpty() && !config.equals(this.mCachedWakeSignalConfigs)) {
                    if (VDBG) {
                        this.log("carrier config changed, reset receivers from old config");
                    }
                    this.mPhone.getCarrierActionAgent().sendEmptyMessage(2);
                }
                this.mCachedWakeSignalConfigs = config;
            }
            map = this.mCachedNoWakeSignalConfigs;
            synchronized (map) {
                this.log("Loading carrier config: carrier_app_no_wake_signal_config");
                config = this.parseAndCache(b.getStringArray("carrier_app_no_wake_signal_config"));
                if (!this.mCachedNoWakeSignalConfigs.isEmpty() && !config.equals(this.mCachedNoWakeSignalConfigs)) {
                    if (VDBG) {
                        this.log("carrier config changed, reset receivers from old config");
                    }
                    this.mPhone.getCarrierActionAgent().sendEmptyMessage(2);
                }
                this.mCachedNoWakeSignalConfigs = config;
            }
        }
    }

    private final Map<String, Set<ComponentName>> $$robo$$com_android_internal_telephony_CarrierSignalAgent$parseAndCache(String[] configs) {
        HashMap<String, Set<ComponentName>> newCachedWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
        if (!ArrayUtils.isEmpty(configs)) {
            for (String config : configs) {
                if (TextUtils.isEmpty(config)) continue;
                String[] splitStr = config.trim().split("\\s*:\\s*", 2);
                if (splitStr.length == 2) {
                    String[] signals;
                    ComponentName componentName = ComponentName.unflattenFromString(splitStr[0]);
                    if (componentName == null) {
                        this.loge("Invalid component name: " + splitStr[0]);
                        continue;
                    }
                    for (String s : signals = splitStr[1].split("\\s*,\\s*")) {
                        if (!this.mCarrierSignalList.contains(s)) {
                            this.loge("Invalid signal name: " + s);
                            continue;
                        }
                        HashSet<ComponentName> componentList = (HashSet<ComponentName>)newCachedWakeSignalConfigs.get(s);
                        if (componentList == null) {
                            componentList = new HashSet<ComponentName>();
                            newCachedWakeSignalConfigs.put(s, componentList);
                        }
                        componentList.add(componentName);
                        if (!VDBG) continue;
                        this.logv("Add config {signal: " + s + " componentName: " + componentName + "}");
                    }
                    continue;
                }
                this.loge("invalid config format: " + config);
            }
        }
        return newCachedWakeSignalConfigs;
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierSignalAgent$hasRegisteredReceivers(String action) {
        return this.mCachedWakeSignalConfigs.containsKey(action) || this.mCachedNoWakeSignalConfigs.containsKey(action);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$broadcast(Intent intent, Set<ComponentName> receivers, boolean wakeup) {
        PackageManager packageManager = this.mPhone.getContext().getPackageManager();
        for (ComponentName name : receivers) {
            Intent signal = new Intent(intent);
            signal.setComponent(name);
            if (wakeup && packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Carrier signal receivers are configured but unavailable: " + signal.getComponent());
                return;
            }
            if (!wakeup && !packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Runtime signals shouldn't be configured in Manifest: " + signal.getComponent());
                return;
            }
            signal.putExtra("subscription", this.mPhone.getSubId());
            signal.addFlags(0x10000000);
            if (!wakeup) {
                signal.setFlags(16);
            }
            try {
                this.mPhone.getContext().sendBroadcast(signal);
                this.log("Sending signal " + signal.getAction() + (signal.getComponent() != null ? " to the carrier signal receiver: " + signal.getComponent() : ""));
            }
            catch (ActivityNotFoundException e) {
                this.loge("Send broadcast failed: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$notifyCarrierSignalReceivers(Intent intent) {
        Set<ComponentName> receiverSet;
        Map<String, Set<ComponentName>> map = this.mCachedWakeSignalConfigs;
        synchronized (map) {
            receiverSet = this.mCachedWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverSet)) {
                this.broadcast(intent, receiverSet, true);
            }
        }
        map = this.mCachedNoWakeSignalConfigs;
        synchronized (map) {
            receiverSet = this.mCachedNoWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverSet)) {
                this.broadcast(intent, receiverSet, false);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$loge(String s) {
        this.mErrorLocalLog.log(s);
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$logv(String s) {
        Rlog.v(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierSignalAgent$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println("mCachedWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, Set<ComponentName>> entry : this.mCachedWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("mCachedNoWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, Set<ComponentName>> entry : this.mCachedNoWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("mDefaultNetworkAvail: " + this.mDefaultNetworkAvail);
        pw.println("error log:");
        ipw.increaseIndent();
        this.mErrorLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
    }

    static void __staticInitializer__() {
        LOG_TAG = CarrierSignalAgent.class.getSimpleName();
        VDBG = Rlog.isLoggable(LOG_TAG, 2);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_CarrierSignalAgent$__constructor__(phone);
    }

    public CarrierSignalAgent(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierSignalAgent$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierSignalAgent$handleMessage(android.os.Message ), 0, this, message);
    }

    private void loadCarrierConfig() {
        InvokeDynamicSupport.bootstrap("loadCarrierConfig", $$robo$$com_android_internal_telephony_CarrierSignalAgent$loadCarrierConfig(), 0, this);
    }

    private Map<String, Set<ComponentName>> parseAndCache(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("parseAndCache", $$robo$$com_android_internal_telephony_CarrierSignalAgent$parseAndCache(java.lang.String[] ), 0, this, stringArray);
    }

    public boolean hasRegisteredReceivers(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRegisteredReceivers", $$robo$$com_android_internal_telephony_CarrierSignalAgent$hasRegisteredReceivers(java.lang.String ), 0, this, string2);
    }

    private void broadcast(Intent intent, Set<ComponentName> set, boolean bl) {
        InvokeDynamicSupport.bootstrap("broadcast", $$robo$$com_android_internal_telephony_CarrierSignalAgent$broadcast(android.content.Intent java.util.Set<android.content.ComponentName> boolean ), 0, this, intent, set, bl);
    }

    public void notifyCarrierSignalReceivers(Intent intent) {
        InvokeDynamicSupport.bootstrap("notifyCarrierSignalReceivers", $$robo$$com_android_internal_telephony_CarrierSignalAgent$notifyCarrierSignalReceivers(android.content.Intent ), 0, this, intent);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_CarrierSignalAgent$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_CarrierSignalAgent$loge(java.lang.String ), 0, this, string2);
    }

    private void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_CarrierSignalAgent$logv(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_CarrierSignalAgent$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(CarrierSignalAgent.class);
    }

    public /* synthetic */ CarrierSignalAgent() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierSignalAgent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

