/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.CellIdentity;
import android.hardware.radio.V1_0.CellIdentityLte;
import android.hardware.radio.V1_2.CellIdentityGsm;
import android.hardware.radio.V1_2.CellIdentityWcdma;
import android.hardware.radio.V1_2.DataRegStateResult;
import android.hardware.radio.V1_2.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellIdentityCdma;
import android.telephony.CellIdentityTdscdma;
import android.telephony.NetworkRegistrationState;
import android.telephony.NetworkService;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CellularNetworkService
extends NetworkService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG;
    private static int GET_CS_REGISTRATION_STATE_DONE = 1;
    private static int GET_PS_REGISTRATION_STATE_DONE = 2;
    private static int NETWORK_REGISTRATION_STATE_CHANGED = 3;

    private void $$robo$$com_android_internal_telephony_CellularNetworkService$__constructor__() {
    }

    private final NetworkService.NetworkServiceProvider $$robo$$com_android_internal_telephony_CellularNetworkService$createNetworkServiceProvider(int slotId) {
        if (!SubscriptionManager.isValidSlotIndex(slotId)) {
            this.loge("Tried to Cellular network service with invalid slotId " + slotId);
            return null;
        }
        return new CellularNetworkServiceProvider(this, slotId);
    }

    private final void $$robo$$com_android_internal_telephony_CellularNetworkService$log(String s) {
        Rlog.d(TAG, s);
    }

    private final void $$robo$$com_android_internal_telephony_CellularNetworkService$loge(String s) {
        Rlog.e(TAG, s);
    }

    static void __staticInitializer__() {
        TAG = CellularNetworkService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CellularNetworkService$__constructor__();
    }

    public CellularNetworkService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CellularNetworkService$__constructor__(), 0, this);
    }

    @Override
    protected NetworkService.NetworkServiceProvider createNetworkServiceProvider(int n) {
        return InvokeDynamicSupport.bootstrap("createNetworkServiceProvider", $$robo$$com_android_internal_telephony_CellularNetworkService$createNetworkServiceProvider(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_CellularNetworkService$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_CellularNetworkService$loge(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(CellularNetworkService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularNetworkService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CellularNetworkServiceProvider
    extends NetworkService.NetworkServiceProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ConcurrentHashMap<Message, NetworkServiceCallback> mCallbackMap;
        private Looper mLooper;
        private HandlerThread mHandlerThread;
        private Handler mHandler;
        private Phone mPhone;
        /* synthetic */ CellularNetworkService this$0;

        private void $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$__constructor__(CellularNetworkService cellularNetworkService, int slotId) {
            this.mCallbackMap = new ConcurrentHashMap();
            this.mPhone = PhoneFactory.getPhone(this.getSlotId());
            this.mHandlerThread = new HandlerThread(CellularNetworkService.class.getSimpleName());
            this.mHandlerThread.start();
            this.mLooper = this.mHandlerThread.getLooper();
            this.mHandler = new ShadowedObject(this, this.mLooper, cellularNetworkService){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ CellularNetworkService val$this$0;
                /* synthetic */ CellularNetworkServiceProvider this$1;

                private void $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider_1$__constructor__(CellularNetworkServiceProvider this$1, Looper x0, CellularNetworkService cellularNetworkService) {
                }

                private final void $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider_1$handleMessage(Message message) {
                    NetworkServiceCallback callback = (NetworkServiceCallback)this.this$1.mCallbackMap.remove(message);
                    switch (message.what) {
                        case 1: 
                        case 2: {
                            if (callback == null) {
                                return;
                            }
                            AsyncResult ar = (AsyncResult)message.obj;
                            int domain = message.what == 1 ? 1 : 2;
                            NetworkRegistrationState netState = this.this$1.getRegistrationStateFromResult(ar.result, domain);
                            int resultCode = ar.exception != null || netState == null ? 5 : 0;
                            try {
                                callback.onGetNetworkRegistrationStateComplete(resultCode, netState);
                            }
                            catch (Exception e) {
                                this.this$1.this$0.loge("Exception: " + e);
                            }
                            break;
                        }
                        case 3: {
                            this.this$1.notifyNetworkRegistrationStateChanged();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }

                private void __constructor__(CellularNetworkServiceProvider cellularNetworkServiceProvider, Looper looper, CellularNetworkService cellularNetworkService) {
                    this.$$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider_1$__constructor__(cellularNetworkServiceProvider, looper, cellularNetworkService);
                }
                {
                    this.this$1 = cellularNetworkServiceProvider;
                    this.val$this$0 = cellularNetworkService;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider_1$__constructor__(com.android.internal.telephony.CellularNetworkService$CellularNetworkServiceProvider android.os.Looper com.android.internal.telephony.CellularNetworkService ), 0, this, cellularNetworkServiceProvider, looper, cellularNetworkService);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mPhone.mCi.registerForNetworkStateChanged(this.mHandler, 3, null);
        }

        private final int $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getRegStateFromHalRegState(int halRegState) {
            switch (halRegState) {
                case 0: 
                case 10: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: 
                case 12: {
                    return 2;
                }
                case 3: 
                case 13: {
                    return 3;
                }
                case 4: 
                case 14: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return 0;
        }

        private final boolean $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$isEmergencyOnly(int halRegState) {
            switch (halRegState) {
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    return true;
                }
            }
            return false;
        }

        private final int[] $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getAvailableServices(int regState, int domain, boolean emergencyOnly) {
            int[] availableServices = null;
            if (emergencyOnly) {
                availableServices = new int[]{5};
            } else if (regState == 5 || regState == 1) {
                if (domain == 2) {
                    availableServices = new int[]{2};
                } else if (domain == 1) {
                    availableServices = new int[]{1, 3, 4};
                }
            }
            return availableServices;
        }

        private final int $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getAccessNetworkTechnologyFromRat(int rilRat) {
            return ServiceState.rilRadioTechnologyToNetworkType(rilRat);
        }

        private final NetworkRegistrationState $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getRegistrationStateFromResult(Object result, int domain) {
            if (result == null) {
                return null;
            }
            if (domain == 1) {
                return this.createRegistrationStateFromVoiceRegState(result);
            }
            if (domain == 2) {
                return this.createRegistrationStateFromDataRegState(result);
            }
            return null;
        }

        private final NetworkRegistrationState $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$createRegistrationStateFromVoiceRegState(Object result) {
            int transportType = 1;
            int domain = 1;
            if (result instanceof android.hardware.radio.V1_0.VoiceRegStateResult) {
                android.hardware.radio.V1_0.VoiceRegStateResult voiceRegState = (android.hardware.radio.V1_0.VoiceRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(voiceRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(voiceRegState.rat);
                int reasonForDenial = voiceRegState.reasonForDenial;
                boolean emergencyOnly = this.isEmergencyOnly(voiceRegState.regState);
                boolean cssSupported = voiceRegState.cssSupported;
                int roamingIndicator = voiceRegState.roamingIndicator;
                int systemIsInPrl = voiceRegState.systemIsInPrl;
                int defaultRoamingIndicator = voiceRegState.defaultRoamingIndicator;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(voiceRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
            }
            if (result instanceof VoiceRegStateResult) {
                VoiceRegStateResult voiceRegState = (VoiceRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(voiceRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(voiceRegState.rat);
                int reasonForDenial = voiceRegState.reasonForDenial;
                boolean emergencyOnly = this.isEmergencyOnly(voiceRegState.regState);
                boolean cssSupported = voiceRegState.cssSupported;
                int roamingIndicator = voiceRegState.roamingIndicator;
                int systemIsInPrl = voiceRegState.systemIsInPrl;
                int defaultRoamingIndicator = voiceRegState.defaultRoamingIndicator;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(voiceRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
            }
            return null;
        }

        private final NetworkRegistrationState $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$createRegistrationStateFromDataRegState(Object result) {
            int transportType = 1;
            int domain = 2;
            if (result instanceof android.hardware.radio.V1_0.DataRegStateResult) {
                android.hardware.radio.V1_0.DataRegStateResult dataRegState = (android.hardware.radio.V1_0.DataRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(dataRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(dataRegState.rat);
                int reasonForDenial = dataRegState.reasonDataDenied;
                boolean emergencyOnly = this.isEmergencyOnly(dataRegState.regState);
                int maxDataCalls = dataRegState.maxDataCalls;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(dataRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, maxDataCalls);
            }
            if (result instanceof DataRegStateResult) {
                DataRegStateResult dataRegState = (DataRegStateResult)result;
                int regState = this.getRegStateFromHalRegState(dataRegState.regState);
                int accessNetworkTechnology = this.getAccessNetworkTechnologyFromRat(dataRegState.rat);
                int reasonForDenial = dataRegState.reasonDataDenied;
                boolean emergencyOnly = this.isEmergencyOnly(dataRegState.regState);
                int maxDataCalls = dataRegState.maxDataCalls;
                int[] availableServices = this.getAvailableServices(regState, domain, emergencyOnly);
                android.telephony.CellIdentity cellIdentity = this.convertHalCellIdentityToCellIdentity(dataRegState.cellIdentity);
                return new NetworkRegistrationState(transportType, domain, regState, accessNetworkTechnology, reasonForDenial, emergencyOnly, availableServices, cellIdentity, maxDataCalls);
            }
            return null;
        }

        private final android.telephony.CellIdentity $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$convertHalCellIdentityToCellIdentity(CellIdentity cellIdentity) {
            if (cellIdentity == null) {
                return null;
            }
            android.telephony.CellIdentity result = null;
            switch (cellIdentity.cellInfoType) {
                case 1: {
                    if (cellIdentity.cellIdentityGsm.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityGsm cellIdentityGsm = cellIdentity.cellIdentityGsm.get(0);
                    result = new android.telephony.CellIdentityGsm(cellIdentityGsm.lac, cellIdentityGsm.cid, cellIdentityGsm.arfcn, cellIdentityGsm.bsic, cellIdentityGsm.mcc, cellIdentityGsm.mnc, null, null);
                    break;
                }
                case 4: {
                    if (cellIdentity.cellIdentityWcdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityWcdma cellIdentityWcdma = cellIdentity.cellIdentityWcdma.get(0);
                    result = new android.telephony.CellIdentityWcdma(cellIdentityWcdma.lac, cellIdentityWcdma.cid, cellIdentityWcdma.psc, cellIdentityWcdma.uarfcn, cellIdentityWcdma.mcc, cellIdentityWcdma.mnc, null, null);
                    break;
                }
                case 5: {
                    if (cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityTdscdma cellIdentityTdscdma = cellIdentity.cellIdentityTdscdma.get(0);
                    result = new CellIdentityTdscdma(cellIdentityTdscdma.mcc, cellIdentityTdscdma.mnc, cellIdentityTdscdma.lac, cellIdentityTdscdma.cid, cellIdentityTdscdma.cpid);
                    break;
                }
                case 3: {
                    if (cellIdentity.cellIdentityLte.size() != 1) break;
                    CellIdentityLte cellIdentityLte = cellIdentity.cellIdentityLte.get(0);
                    result = new android.telephony.CellIdentityLte(cellIdentityLte.ci, cellIdentityLte.pci, cellIdentityLte.tac, cellIdentityLte.earfcn, Integer.MAX_VALUE, cellIdentityLte.mcc, cellIdentityLte.mnc, null, null);
                    break;
                }
                case 2: {
                    if (cellIdentity.cellIdentityCdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityCdma cellIdentityCdma = cellIdentity.cellIdentityCdma.get(0);
                    result = new CellIdentityCdma(cellIdentityCdma.networkId, cellIdentityCdma.systemId, cellIdentityCdma.baseStationId, cellIdentityCdma.longitude, cellIdentityCdma.latitude);
                    break;
                }
            }
            return result;
        }

        private final android.telephony.CellIdentity $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$convertHalCellIdentityToCellIdentity(android.hardware.radio.V1_2.CellIdentity cellIdentity) {
            if (cellIdentity == null) {
                return null;
            }
            android.telephony.CellIdentity result = null;
            switch (cellIdentity.cellInfoType) {
                case 1: {
                    if (cellIdentity.cellIdentityGsm.size() != 1) break;
                    CellIdentityGsm cellIdentityGsm = cellIdentity.cellIdentityGsm.get(0);
                    result = new android.telephony.CellIdentityGsm(cellIdentityGsm.base.lac, cellIdentityGsm.base.cid, cellIdentityGsm.base.arfcn, cellIdentityGsm.base.bsic, cellIdentityGsm.base.mcc, cellIdentityGsm.base.mnc, cellIdentityGsm.operatorNames.alphaLong, cellIdentityGsm.operatorNames.alphaShort);
                    break;
                }
                case 4: {
                    if (cellIdentity.cellIdentityWcdma.size() != 1) break;
                    CellIdentityWcdma cellIdentityWcdma = cellIdentity.cellIdentityWcdma.get(0);
                    result = new android.telephony.CellIdentityWcdma(cellIdentityWcdma.base.lac, cellIdentityWcdma.base.cid, cellIdentityWcdma.base.psc, cellIdentityWcdma.base.uarfcn, cellIdentityWcdma.base.mcc, cellIdentityWcdma.base.mnc, cellIdentityWcdma.operatorNames.alphaLong, cellIdentityWcdma.operatorNames.alphaShort);
                    break;
                }
                case 5: {
                    if (cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityTdscdma cellIdentityTdscdma = cellIdentity.cellIdentityTdscdma.get(0);
                    result = new CellIdentityTdscdma(cellIdentityTdscdma.base.mcc, cellIdentityTdscdma.base.mnc, cellIdentityTdscdma.base.lac, cellIdentityTdscdma.base.cid, cellIdentityTdscdma.base.cpid, cellIdentityTdscdma.operatorNames.alphaLong, cellIdentityTdscdma.operatorNames.alphaShort);
                    break;
                }
                case 3: {
                    if (cellIdentity.cellIdentityLte.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityLte cellIdentityLte = cellIdentity.cellIdentityLte.get(0);
                    result = new android.telephony.CellIdentityLte(cellIdentityLte.base.ci, cellIdentityLte.base.pci, cellIdentityLte.base.tac, cellIdentityLte.base.earfcn, cellIdentityLte.bandwidth, cellIdentityLte.base.mcc, cellIdentityLte.base.mnc, cellIdentityLte.operatorNames.alphaLong, cellIdentityLte.operatorNames.alphaShort);
                    break;
                }
                case 2: {
                    if (cellIdentity.cellIdentityCdma.size() != 1) break;
                    android.hardware.radio.V1_2.CellIdentityCdma cellIdentityCdma = cellIdentity.cellIdentityCdma.get(0);
                    result = new CellIdentityCdma(cellIdentityCdma.base.networkId, cellIdentityCdma.base.systemId, cellIdentityCdma.base.baseStationId, cellIdentityCdma.base.longitude, cellIdentityCdma.base.latitude, cellIdentityCdma.operatorNames.alphaLong, cellIdentityCdma.operatorNames.alphaShort);
                    break;
                }
            }
            return result;
        }

        private final void $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getNetworkRegistrationState(int domain, NetworkServiceCallback callback) {
            Message message = null;
            if (domain == 1) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getVoiceRegistrationState(message);
            } else if (domain == 2) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
                this.mPhone.mCi.getDataRegistrationState(message);
            } else {
                this.this$0.loge("getNetworkRegistrationState invalid domain " + domain);
                callback.onGetNetworkRegistrationStateComplete(2, null);
            }
        }

        private final void $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$onDestroy() {
            super.onDestroy();
            this.mCallbackMap.clear();
            this.mHandlerThread.quit();
            this.mPhone.mCi.unregisterForNetworkStateChanged(this.mHandler);
        }

        private void __constructor__(CellularNetworkService cellularNetworkService, int n) {
            this.$$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$__constructor__(cellularNetworkService, n);
        }

        CellularNetworkServiceProvider(CellularNetworkService cellularNetworkService, int n) {
            this.this$0 = cellularNetworkService;
            super(cellularNetworkService, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$__constructor__(com.android.internal.telephony.CellularNetworkService int ), 0, this, cellularNetworkService, n);
        }

        private int getRegStateFromHalRegState(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getRegStateFromHalRegState", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getRegStateFromHalRegState(int ), 0, this, n);
        }

        private boolean isEmergencyOnly(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyOnly", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$isEmergencyOnly(int ), 0, this, n);
        }

        private int[] getAvailableServices(int n, int n2, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getAvailableServices", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getAvailableServices(int int boolean ), 0, this, n, n2, bl);
        }

        private int getAccessNetworkTechnologyFromRat(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getAccessNetworkTechnologyFromRat", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getAccessNetworkTechnologyFromRat(int ), 0, this, n);
        }

        private NetworkRegistrationState getRegistrationStateFromResult(Object object, int n) {
            return InvokeDynamicSupport.bootstrap("getRegistrationStateFromResult", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getRegistrationStateFromResult(java.lang.Object int ), 0, this, object, n);
        }

        private NetworkRegistrationState createRegistrationStateFromVoiceRegState(Object object) {
            return InvokeDynamicSupport.bootstrap("createRegistrationStateFromVoiceRegState", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$createRegistrationStateFromVoiceRegState(java.lang.Object ), 0, this, object);
        }

        private NetworkRegistrationState createRegistrationStateFromDataRegState(Object object) {
            return InvokeDynamicSupport.bootstrap("createRegistrationStateFromDataRegState", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$createRegistrationStateFromDataRegState(java.lang.Object ), 0, this, object);
        }

        private android.telephony.CellIdentity convertHalCellIdentityToCellIdentity(CellIdentity cellIdentity) {
            return InvokeDynamicSupport.bootstrap("convertHalCellIdentityToCellIdentity", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$convertHalCellIdentityToCellIdentity(android.hardware.radio.V1_0.CellIdentity ), 0, this, cellIdentity);
        }

        private android.telephony.CellIdentity convertHalCellIdentityToCellIdentity(android.hardware.radio.V1_2.CellIdentity cellIdentity) {
            return InvokeDynamicSupport.bootstrap("convertHalCellIdentityToCellIdentity", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$convertHalCellIdentityToCellIdentity(android.hardware.radio.V1_2.CellIdentity ), 0, this, cellIdentity);
        }

        @Override
        public void getNetworkRegistrationState(int n, NetworkServiceCallback networkServiceCallback) {
            InvokeDynamicSupport.bootstrap("getNetworkRegistrationState", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$getNetworkRegistrationState(int android.telephony.NetworkServiceCallback ), 0, this, n, networkServiceCallback);
        }

        @Override
        protected void onDestroy() {
            InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$com_android_internal_telephony_CellularNetworkService_CellularNetworkServiceProvider$onDestroy(), 0, this);
        }

        public /* synthetic */ CellularNetworkServiceProvider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularNetworkServiceProvider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

