/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CellInfo;
import android.telephony.PhysicalChannelConfig;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.VoLteServiceState;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstantConversions;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultPhoneNotifier
implements PhoneNotifier,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "DefaultPhoneNotifier";
    private static boolean DBG = false;
    protected ITelephonyRegistry mRegistry;

    private void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$__constructor__() {
        this.mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPhoneState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        int subId = sender.getSubId();
        int phoneId = sender.getPhoneId();
        String incomingNumber = "";
        if (ringingCall != null && ringingCall.getEarliestConnection() != null) {
            incomingNumber = ringingCall.getEarliestConnection().getAddress();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCallStateForPhoneId(phoneId, subId, PhoneConstantConversions.convertCallState(sender.getState()), incomingNumber);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyServiceState(Phone sender) {
        ServiceState ss = sender.getServiceState();
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        Rlog.d("DefaultPhoneNotifier", "nofityServiceState: mRegistry=" + this.mRegistry + " ss=" + ss + " sender=" + sender + " phondId=" + phoneId + " subId=" + subId);
        if (ss == null) {
            ss = new ServiceState();
            ss.setStateOutOfService();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyServiceStateForPhoneId(phoneId, subId, ss);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifySignalStrength(Phone sender) {
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifySignalStrengthForPhoneId(phoneId, subId, sender.getSignalStrength());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyMessageWaitingChanged(Phone sender) {
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyMessageWaitingChangedForPhoneId(phoneId, subId, sender.getMessageWaitingIndicator());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCallForwardingChanged(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                Rlog.d("DefaultPhoneNotifier", "notifyCallForwardingChanged: subId=" + subId + ", isCFActive=" + sender.getCallForwardingIndicator());
                this.mRegistry.notifyCallForwardingChangedForSubscriber(subId, sender.getCallForwardingIndicator());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataActivity(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataActivityForSubscriber(subId, DefaultPhoneNotifier.convertDataActivityState(sender.getDataActivityState()));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        this.doNotifyDataConnection(sender, reason, apnType, state);
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$doNotifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        ServiceState ss;
        int subId = sender.getSubId();
        long dds = SubscriptionManager.getDefaultDataSubscriptionId();
        TelephonyManager telephony = TelephonyManager.getDefault();
        LinkProperties linkProperties = null;
        NetworkCapabilities networkCapabilities = null;
        boolean roaming = false;
        if (state == PhoneConstants.DataState.CONNECTED) {
            linkProperties = sender.getLinkProperties(apnType);
            networkCapabilities = sender.getNetworkCapabilities(apnType);
        }
        if ((ss = sender.getServiceState()) != null) {
            roaming = ss.getDataRoaming();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionForSubscriber(subId, PhoneConstantConversions.convertDataState(state), sender.isDataAllowed(), reason, sender.getActiveApnHost(apnType), apnType, linkProperties, networkCapabilities, telephony != null ? telephony.getDataNetworkType(subId) : 0, roaming);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataConnectionFailed(Phone sender, String reason, String apnType) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionFailedForSubscriber(subId, reason, apnType);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCellLocation(Phone sender) {
        int subId = sender.getSubId();
        Bundle data = new Bundle();
        sender.getCellLocation().fillInNotifierBundle(data);
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellLocationForSubscriber(subId, data);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCellInfo(Phone sender, List<CellInfo> cellInfo) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPhysicalChannelConfiguration(Phone sender, List<PhysicalChannelConfig> configs) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyPhysicalChannelConfigurationForSubscriber(subId, configs);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyOtaspChanged(Phone sender, int otaspMode) {
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyOtaspChanged(otaspMode);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPreciseCallState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        Call foregroundCall = sender.getForegroundCall();
        Call backgroundCall = sender.getBackgroundCall();
        if (ringingCall != null && foregroundCall != null && backgroundCall != null) {
            try {
                this.mRegistry.notifyPreciseCallState(DefaultPhoneNotifier.convertPreciseCallState(ringingCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(foregroundCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(backgroundCall.getState()));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDisconnectCause(int cause, int preciseCause) {
        try {
            this.mRegistry.notifyDisconnectCause(cause, preciseCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPreciseDataConnectionFailed(Phone sender, String reason, String apnType, String apn, String failCause) {
        try {
            this.mRegistry.notifyPreciseDataConnectionFailed(reason, apnType, apn, failCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyVoLteServiceStateChanged(Phone sender, VoLteServiceState lteState) {
        try {
            this.mRegistry.notifyVoLteServiceStateChanged(lteState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataActivationStateChanged(Phone sender, int activationState) {
        try {
            this.mRegistry.notifySimActivationStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), 1, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyVoiceActivationStateChanged(Phone sender, int activationState) {
        try {
            this.mRegistry.notifySimActivationStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), 0, activationState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyUserMobileDataStateChanged(Phone sender, boolean state) {
        try {
            this.mRegistry.notifyUserMobileDataStateChangedForPhoneId(sender.getPhoneId(), sender.getSubId(), state);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyOemHookRawEventForSubscriber(int subId, byte[] rawData) {
        try {
            this.mRegistry.notifyOemHookRawEventForSubscriber(subId, rawData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final int $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$convertDataActivityState(PhoneInternalInterface.DataActivityState state) {
        switch (1.$SwitchMap$com$android$internal$telephony$PhoneInternalInterface$DataActivityState[state.ordinal()]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    private static final int $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$convertPreciseCallState(Call.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$Call$State[state.ordinal()]) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$log(String s) {
        Rlog.d("DefaultPhoneNotifier", s);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_DefaultPhoneNotifier$__constructor__();
    }

    public DefaultPhoneNotifier() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$__constructor__(), 0, this);
    }

    @Override
    public void notifyPhoneState(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyPhoneState", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPhoneState(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyServiceState(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyServiceState", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyServiceState(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifySignalStrength(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifySignalStrength", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifySignalStrength(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyMessageWaitingChanged(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyMessageWaitingChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyMessageWaitingChanged(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyCallForwardingChanged(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyCallForwardingChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCallForwardingChanged(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyDataActivity(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyDataActivity", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataActivity(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyDataConnection(Phone phone, String string2, String string3, PhoneConstants.DataState dataState) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataConnection(com.android.internal.telephony.Phone java.lang.String java.lang.String com.android.internal.telephony.PhoneConstants$DataState ), 0, this, phone, string2, string3, dataState);
    }

    private void doNotifyDataConnection(Phone phone, String string2, String string3, PhoneConstants.DataState dataState) {
        InvokeDynamicSupport.bootstrap("doNotifyDataConnection", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$doNotifyDataConnection(com.android.internal.telephony.Phone java.lang.String java.lang.String com.android.internal.telephony.PhoneConstants$DataState ), 0, this, phone, string2, string3, dataState);
    }

    @Override
    public void notifyDataConnectionFailed(Phone phone, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("notifyDataConnectionFailed", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataConnectionFailed(com.android.internal.telephony.Phone java.lang.String java.lang.String ), 0, this, phone, string2, string3);
    }

    @Override
    public void notifyCellLocation(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyCellLocation", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCellLocation(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyCellInfo(Phone phone, List<CellInfo> list) {
        InvokeDynamicSupport.bootstrap("notifyCellInfo", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyCellInfo(com.android.internal.telephony.Phone java.util.List<android.telephony.CellInfo> ), 0, this, phone, list);
    }

    @Override
    public void notifyPhysicalChannelConfiguration(Phone phone, List<PhysicalChannelConfig> list) {
        InvokeDynamicSupport.bootstrap("notifyPhysicalChannelConfiguration", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPhysicalChannelConfiguration(com.android.internal.telephony.Phone java.util.List<android.telephony.PhysicalChannelConfig> ), 0, this, phone, list);
    }

    @Override
    public void notifyOtaspChanged(Phone phone, int n) {
        InvokeDynamicSupport.bootstrap("notifyOtaspChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyOtaspChanged(com.android.internal.telephony.Phone int ), 0, this, phone, n);
    }

    @Override
    public void notifyPreciseCallState(Phone phone) {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallState", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPreciseCallState(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    @Override
    public void notifyDisconnectCause(int n, int n2) {
        InvokeDynamicSupport.bootstrap("notifyDisconnectCause", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDisconnectCause(int int ), 0, this, n, n2);
    }

    @Override
    public void notifyPreciseDataConnectionFailed(Phone phone, String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("notifyPreciseDataConnectionFailed", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyPreciseDataConnectionFailed(com.android.internal.telephony.Phone java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, phone, string2, string3, string4, string5);
    }

    @Override
    public void notifyVoLteServiceStateChanged(Phone phone, VoLteServiceState voLteServiceState) {
        InvokeDynamicSupport.bootstrap("notifyVoLteServiceStateChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyVoLteServiceStateChanged(com.android.internal.telephony.Phone android.telephony.VoLteServiceState ), 0, this, phone, voLteServiceState);
    }

    @Override
    public void notifyDataActivationStateChanged(Phone phone, int n) {
        InvokeDynamicSupport.bootstrap("notifyDataActivationStateChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyDataActivationStateChanged(com.android.internal.telephony.Phone int ), 0, this, phone, n);
    }

    @Override
    public void notifyVoiceActivationStateChanged(Phone phone, int n) {
        InvokeDynamicSupport.bootstrap("notifyVoiceActivationStateChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyVoiceActivationStateChanged(com.android.internal.telephony.Phone int ), 0, this, phone, n);
    }

    @Override
    public void notifyUserMobileDataStateChanged(Phone phone, boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyUserMobileDataStateChanged", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyUserMobileDataStateChanged(com.android.internal.telephony.Phone boolean ), 0, this, phone, bl);
    }

    @Override
    public void notifyOemHookRawEventForSubscriber(int n, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("notifyOemHookRawEventForSubscriber", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$notifyOemHookRawEventForSubscriber(int byte[] ), 0, this, n, byArray);
    }

    public static int convertDataActivityState(PhoneInternalInterface.DataActivityState dataActivityState) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertDataActivityState", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$convertDataActivityState(com.android.internal.telephony.PhoneInternalInterface$DataActivityState ), 0, (PhoneInternalInterface.DataActivityState)dataActivityState);
    }

    public static int convertPreciseCallState(Call.State state) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertPreciseCallState", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$convertPreciseCallState(com.android.internal.telephony.Call$State ), 0, (Call.State)state);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_DefaultPhoneNotifier$log(java.lang.String ), 0, this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultPhoneNotifier)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

