/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import com.android.internal.telephony.IIccPhoneBook;
import com.android.internal.telephony.uicc.AdnRecord;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IccProvider
extends ContentProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "IccProvider";
    private static boolean DBG = true;
    private static String[] ADDRESS_BOOK_COLUMN_NAMES;
    protected static int ADN = 1;
    protected static int ADN_SUB = 2;
    protected static int FDN = 3;
    protected static int FDN_SUB = 4;
    protected static int SDN = 5;
    protected static int SDN_SUB = 6;
    protected static int ADN_ALL = 7;
    protected static String STR_TAG = "tag";
    protected static String STR_NUMBER = "number";
    protected static String STR_EMAILS = "emails";
    protected static String STR_PIN2 = "pin2";
    private static UriMatcher URL_MATCHER;
    private SubscriptionManager mSubscriptionManager;

    private void $$robo$$com_android_internal_telephony_IccProvider$__constructor__() {
    }

    private final boolean $$robo$$com_android_internal_telephony_IccProvider$onCreate() {
        this.mSubscriptionManager = SubscriptionManager.from(this.getContext());
        return true;
    }

    private final Cursor $$robo$$com_android_internal_telephony_IccProvider$query(Uri url, String[] projection, String selection, String[] selectionArgs, String sort) {
        this.log("query");
        switch (URL_MATCHER.match(url)) {
            case 1: {
                return this.loadFromEf(28474, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 2: {
                return this.loadFromEf(28474, this.getRequestSubId(url));
            }
            case 3: {
                return this.loadFromEf(28475, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 4: {
                return this.loadFromEf(28475, this.getRequestSubId(url));
            }
            case 5: {
                return this.loadFromEf(28489, SubscriptionManager.getDefaultSubscriptionId());
            }
            case 6: {
                return this.loadFromEf(28489, this.getRequestSubId(url));
            }
            case 7: {
                return this.loadAllSimContacts(28474);
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    private final Cursor $$robo$$com_android_internal_telephony_IccProvider$loadAllSimContacts(int efType) {
        Cursor[] result;
        List<SubscriptionInfo> subInfoList = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        if (subInfoList == null || subInfoList.size() == 0) {
            result = new Cursor[]{};
        } else {
            int subIdCount = subInfoList.size();
            result = new Cursor[subIdCount];
            for (int i = 0; i < subIdCount; ++i) {
                int subId = subInfoList.get(i).getSubscriptionId();
                result[i] = this.loadFromEf(efType, subId);
                Rlog.i("IccProvider", "ADN Records loaded for Subscription ::" + subId);
            }
        }
        return new MergeCursor(result);
    }

    private final String $$robo$$com_android_internal_telephony_IccProvider$getType(Uri url) {
        switch (URL_MATCHER.match(url)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "vnd.android.cursor.dir/sim-contact";
            }
        }
        throw new IllegalArgumentException("Unknown URL " + url);
    }

    private final Uri $$robo$$com_android_internal_telephony_IccProvider$insert(Uri url, ContentValues initialValues) {
        int subId;
        int efType;
        String pin2 = null;
        this.log("insert");
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                pin2 = initialValues.getAsString("pin2");
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                pin2 = initialValues.getAsString("pin2");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = initialValues.getAsString("tag");
        String number = initialValues.getAsString("number");
        boolean success = this.addIccRecordToEf(efType, tag, number, null, pin2, subId);
        if (!success) {
            return null;
        }
        StringBuilder buf = new StringBuilder("content://icc/");
        switch (match) {
            case 1: {
                buf.append("adn/");
                break;
            }
            case 2: {
                buf.append("adn/subId/");
                break;
            }
            case 3: {
                buf.append("fdn/");
                break;
            }
            case 4: {
                buf.append("fdn/subId/");
            }
        }
        buf.append(0);
        Uri resultUri = Uri.parse(buf.toString());
        this.getContext().getContentResolver().notifyChange(url, null);
        return resultUri;
    }

    private final String $$robo$$com_android_internal_telephony_IccProvider$normalizeValue(String inVal) {
        int len = inVal.length();
        if (len == 0) {
            this.log("len of input String is 0");
            return inVal;
        }
        String retVal = inVal;
        if (inVal.charAt(0) == '\'' && inVal.charAt(len - 1) == '\'') {
            retVal = inVal.substring(1, len - 1);
        }
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_IccProvider$delete(Uri url, String where, String[] whereArgs) {
        int subId;
        int efType;
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        this.log("delete");
        String tag = null;
        String number = null;
        Object emails = null;
        String pin2 = null;
        String[] tokens = where.split("AND");
        int n = tokens.length;
        while (--n >= 0) {
            String param = tokens[n];
            this.log("parsing '" + param + "'");
            String[] pair = param.split("=", 2);
            if (pair.length != 2) {
                Rlog.e("IccProvider", "resolve: bad whereClause parameter: " + param);
                continue;
            }
            String key = pair[0].trim();
            String val = pair[1].trim();
            if ("tag".equals(key)) {
                tag = this.normalizeValue(val);
                continue;
            }
            if ("number".equals(key)) {
                number = this.normalizeValue(val);
                continue;
            }
            if ("emails".equals(key)) {
                emails = null;
                continue;
            }
            if (!"pin2".equals(key)) continue;
            pin2 = this.normalizeValue(val);
        }
        if (efType == 3 && TextUtils.isEmpty(pin2)) {
            return 0;
        }
        boolean success = this.deleteIccRecordFromEf(efType, tag, number, emails, pin2, subId);
        if (!success) {
            return 0;
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return 1;
    }

    private final int $$robo$$com_android_internal_telephony_IccProvider$update(Uri url, ContentValues values, String where, String[] whereArgs) {
        int subId;
        int efType;
        String pin2 = null;
        this.log("update");
        int match = URL_MATCHER.match(url);
        switch (match) {
            case 1: {
                efType = 28474;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                break;
            }
            case 2: {
                efType = 28474;
                subId = this.getRequestSubId(url);
                break;
            }
            case 3: {
                efType = 28475;
                subId = SubscriptionManager.getDefaultSubscriptionId();
                pin2 = values.getAsString("pin2");
                break;
            }
            case 4: {
                efType = 28475;
                subId = this.getRequestSubId(url);
                pin2 = values.getAsString("pin2");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot insert into URL: " + url);
            }
        }
        String tag = values.getAsString("tag");
        String number = values.getAsString("number");
        Object emails = null;
        String newTag = values.getAsString("newTag");
        String newNumber = values.getAsString("newNumber");
        Object newEmails = null;
        boolean success = this.updateIccRecordInEf(efType, tag, number, newTag, newNumber, pin2, subId);
        if (!success) {
            return 0;
        }
        this.getContext().getContentResolver().notifyChange(url, null);
        return 1;
    }

    private final MatrixCursor $$robo$$com_android_internal_telephony_IccProvider$loadFromEf(int efType, int subId) {
        this.log("loadFromEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", subscription=" + subId);
        List<AdnRecord> adnRecords = null;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                adnRecords = iccIpb.getAdnRecordsInEfForSubscriber(subId, efType);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        if (adnRecords != null) {
            int N = adnRecords.size();
            MatrixCursor cursor = new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES, N);
            this.log("adnRecords.size=" + N);
            for (int i = 0; i < N; ++i) {
                this.loadRecord(adnRecords.get(i), cursor, i);
            }
            return cursor;
        }
        Rlog.w("IccProvider", "Cannot load ADN records");
        return new MatrixCursor(ADDRESS_BOOK_COLUMN_NAMES);
    }

    private final boolean $$robo$$com_android_internal_telephony_IccProvider$addIccRecordToEf(int efType, String name, String number, String[] emails, String pin2, int subId) {
        this.log("addIccRecordToEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", name=" + Rlog.pii("IccProvider", (Object)name) + ", number=" + Rlog.pii("IccProvider", (Object)number) + ", emails=" + Rlog.pii("IccProvider", (Object)emails) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, "", "", name, number, pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("addIccRecordToEf: " + success);
        return success;
    }

    private final boolean $$robo$$com_android_internal_telephony_IccProvider$updateIccRecordInEf(int efType, String oldName, String oldNumber, String newName, String newNumber, String pin2, int subId) {
        this.log("updateIccRecordInEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", oldname=" + Rlog.pii("IccProvider", (Object)oldName) + ", oldnumber=" + Rlog.pii("IccProvider", (Object)oldNumber) + ", newname=" + Rlog.pii("IccProvider", (Object)newName) + ", newnumber=" + Rlog.pii("IccProvider", (Object)newName) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, oldName, oldNumber, newName, newNumber, pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("updateIccRecordInEf: " + success);
        return success;
    }

    private final boolean $$robo$$com_android_internal_telephony_IccProvider$deleteIccRecordFromEf(int efType, String name, String number, String[] emails, String pin2, int subId) {
        this.log("deleteIccRecordFromEf: efType=0x" + Integer.toHexString(efType).toUpperCase() + ", name=" + Rlog.pii("IccProvider", (Object)name) + ", number=" + Rlog.pii("IccProvider", (Object)number) + ", emails=" + Rlog.pii("IccProvider", (Object)emails) + ", pin2=" + Rlog.pii("IccProvider", (Object)pin2) + ", subscription=" + subId);
        boolean success = false;
        try {
            IIccPhoneBook iccIpb = IIccPhoneBook.Stub.asInterface(ServiceManager.getService("simphonebook"));
            if (iccIpb != null) {
                success = iccIpb.updateAdnRecordsInEfBySearchForSubscriber(subId, efType, name, number, "", "", pin2);
            }
        }
        catch (RemoteException iccIpb) {
        }
        catch (SecurityException ex) {
            this.log(ex.toString());
        }
        this.log("deleteIccRecordFromEf: " + success);
        return success;
    }

    private final void $$robo$$com_android_internal_telephony_IccProvider$loadRecord(AdnRecord record, MatrixCursor cursor, int id2) {
        if (!record.isEmpty()) {
            Object[] contact = new Object[4];
            String alphaTag = record.getAlphaTag();
            String number = record.getNumber();
            this.log("loadRecord: " + alphaTag + ", " + Rlog.pii("IccProvider", (Object)number));
            contact[0] = alphaTag;
            contact[1] = number;
            String[] emails = record.getEmails();
            if (emails != null) {
                StringBuilder emailString = new StringBuilder();
                for (String email : emails) {
                    this.log("Adding email:" + Rlog.pii("IccProvider", (Object)email));
                    emailString.append(email);
                    emailString.append(",");
                }
                contact[2] = emailString.toString();
            }
            contact[3] = id2;
            cursor.addRow(contact);
        }
    }

    private final void $$robo$$com_android_internal_telephony_IccProvider$log(String msg) {
        Rlog.d("IccProvider", "[IccProvider] " + msg);
    }

    private final int $$robo$$com_android_internal_telephony_IccProvider$getRequestSubId(Uri url) {
        this.log("getRequestSubId url: " + url);
        try {
            return Integer.parseInt(url.getLastPathSegment());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Unknown URL " + url);
        }
    }

    static void __staticInitializer__() {
        ADDRESS_BOOK_COLUMN_NAMES = new String[]{"name", "number", "emails", "_id"};
        URL_MATCHER = new UriMatcher(-1);
        URL_MATCHER.addURI("icc", "adn", 1);
        URL_MATCHER.addURI("icc", "adn/subId/#", 2);
        URL_MATCHER.addURI("icc", "fdn", 3);
        URL_MATCHER.addURI("icc", "fdn/subId/#", 4);
        URL_MATCHER.addURI("icc", "sdn", 5);
        URL_MATCHER.addURI("icc", "sdn/subId/#", 6);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_IccProvider$__constructor__();
    }

    public IccProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_IccProvider$__constructor__(), 0, this);
    }

    @Override
    public boolean onCreate() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_telephony_IccProvider$onCreate(), 0, this);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$com_android_internal_telephony_IccProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    private Cursor loadAllSimContacts(int n) {
        return InvokeDynamicSupport.bootstrap("loadAllSimContacts", $$robo$$com_android_internal_telephony_IccProvider$loadAllSimContacts(int ), 0, this, n);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$com_android_internal_telephony_IccProvider$getType(android.net.Uri ), 0, this, uri);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$com_android_internal_telephony_IccProvider$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    private String normalizeValue(String string2) {
        return InvokeDynamicSupport.bootstrap("normalizeValue", $$robo$$com_android_internal_telephony_IccProvider$normalizeValue(java.lang.String ), 0, this, string2);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$com_android_internal_telephony_IccProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_telephony_IccProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    private MatrixCursor loadFromEf(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("loadFromEf", $$robo$$com_android_internal_telephony_IccProvider$loadFromEf(int int ), 0, this, n, n2);
    }

    private boolean addIccRecordToEf(int n, String string2, String string3, String[] stringArray, String string4, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("addIccRecordToEf", $$robo$$com_android_internal_telephony_IccProvider$addIccRecordToEf(int java.lang.String java.lang.String java.lang.String[] java.lang.String int ), 0, this, n, string2, string3, stringArray, string4, n2);
    }

    private boolean updateIccRecordInEf(int n, String string2, String string3, String string4, String string5, String string6, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateIccRecordInEf", $$robo$$com_android_internal_telephony_IccProvider$updateIccRecordInEf(int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String int ), 0, this, n, string2, string3, string4, string5, string6, n2);
    }

    private boolean deleteIccRecordFromEf(int n, String string2, String string3, String[] stringArray, String string4, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteIccRecordFromEf", $$robo$$com_android_internal_telephony_IccProvider$deleteIccRecordFromEf(int java.lang.String java.lang.String java.lang.String[] java.lang.String int ), 0, this, n, string2, string3, stringArray, string4, n2);
    }

    private void loadRecord(AdnRecord adnRecord, MatrixCursor matrixCursor, int n) {
        InvokeDynamicSupport.bootstrap("loadRecord", $$robo$$com_android_internal_telephony_IccProvider$loadRecord(com.android.internal.telephony.uicc.AdnRecord android.database.MatrixCursor int ), 0, this, adnRecord, matrixCursor, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_IccProvider$log(java.lang.String ), 0, this, string2);
    }

    private int getRequestSubId(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("getRequestSubId", $$robo$$com_android_internal_telephony_IccProvider$getRequestSubId(android.net.Uri ), 0, this, uri);
    }

    static {
        RobolectricInternals.classInitializing(IccProvider.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

