/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.RemoteException;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.Pair;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.util.SMSDispatcherUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsSmsDispatcher
extends SMSDispatcher
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsSmsDispacher";
    @VisibleForTesting
    public Map<Integer, SMSDispatcher.SmsTracker> mTrackers;
    @VisibleForTesting
    public AtomicInteger mNextToken;
    private Object mLock;
    private volatile boolean mIsSmsCapable;
    private volatile boolean mIsImsServiceUp;
    private volatile boolean mIsRegistered;
    private ImsManager.Connector mImsManagerConnector;
    private ImsRegistrationImplBase.Callback mRegistrationCallback;
    private ImsFeature.CapabilityCallback mCapabilityCallback;
    private IImsSmsListener mImsSmsListener;

    private void $$robo$$com_android_internal_telephony_ImsSmsDispatcher$__constructor__(Phone phone, SmsDispatchersController smsDispatchersController) {
        this.mTrackers = new ConcurrentHashMap<Integer, SMSDispatcher.SmsTracker>();
        this.mNextToken = new AtomicInteger();
        this.mLock = new Object();
        this.mRegistrationCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsSmsDispatcher this$0;

            private void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$__constructor__(ImsSmsDispatcher this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onRegistered(int imsRadioTech) {
                Rlog.d("ImsSmsDispacher", "onImsConnected imsRadioTech=" + imsRadioTech);
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mIsRegistered = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onRegistering(int imsRadioTech) {
                Rlog.d("ImsSmsDispacher", "onImsProgressing imsRadioTech=" + imsRadioTech);
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mIsRegistered = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onDeregistered(ImsReasonInfo info) {
                Rlog.d("ImsSmsDispacher", "onImsDisconnected imsReasonInfo=" + info);
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mIsRegistered = false;
                }
            }

            private void __constructor__(ImsSmsDispatcher imsSmsDispatcher) {
                this.$$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$__constructor__(imsSmsDispatcher);
            }
            {
                this.this$0 = imsSmsDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$__constructor__(com.android.internal.telephony.ImsSmsDispatcher ), 0, this, imsSmsDispatcher);
            }

            @Override
            public void onRegistered(int n) {
                InvokeDynamicSupport.bootstrap("onRegistered", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onRegistered(int ), 0, this, n);
            }

            @Override
            public void onRegistering(int n) {
                InvokeDynamicSupport.bootstrap("onRegistering", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onRegistering(int ), 0, this, n);
            }

            @Override
            public void onDeregistered(ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onDeregistered", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_1$onDeregistered(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCapabilityCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsSmsDispatcher this$0;

            private void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_2$__constructor__(ImsSmsDispatcher this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_2$onCapabilitiesStatusChanged(ImsFeature.Capabilities config) {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mIsSmsCapable = config.isCapable(8);
                }
            }

            private void __constructor__(ImsSmsDispatcher imsSmsDispatcher) {
                this.$$robo$$com_android_internal_telephony_ImsSmsDispatcher_2$__constructor__(imsSmsDispatcher);
            }
            {
                this.this$0 = imsSmsDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_2$__constructor__(com.android.internal.telephony.ImsSmsDispatcher ), 0, this, imsSmsDispatcher);
            }

            @Override
            public void onCapabilitiesStatusChanged(ImsFeature.Capabilities capabilities) {
                InvokeDynamicSupport.bootstrap("onCapabilitiesStatusChanged", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_2$onCapabilitiesStatusChanged(android.telephony.ims.feature.ImsFeature$Capabilities ), 0, this, capabilities);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsSmsListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsSmsDispatcher this$0;

            private void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$__constructor__(ImsSmsDispatcher this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSendSmsResult(int token, int messageRef, int status, int reason) throws RemoteException {
                Rlog.d("ImsSmsDispacher", "onSendSmsResult token=" + token + " messageRef=" + messageRef + " status=" + status + " reason=" + reason);
                SMSDispatcher.SmsTracker tracker = this.this$0.mTrackers.get(token);
                if (tracker == null) {
                    throw new IllegalArgumentException("Invalid token.");
                }
                tracker.mMessageRef = messageRef;
                switch (status) {
                    case 1: {
                        tracker.onSent(this.this$0.mContext);
                        break;
                    }
                    case 2: {
                        tracker.onFailed(this.this$0.mContext, reason, 0);
                        this.this$0.mTrackers.remove(token);
                        break;
                    }
                    case 3: {
                        ++tracker.mRetryCount;
                        this.this$0.sendSms(tracker);
                        break;
                    }
                    case 4: {
                        this.this$0.fallbackToPstn(token, tracker);
                        break;
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSmsStatusReportReceived(int token, int messageRef, String format, byte[] pdu) throws RemoteException {
                Rlog.d("ImsSmsDispacher", "Status report received.");
                SMSDispatcher.SmsTracker tracker = this.this$0.mTrackers.get(token);
                if (tracker == null) {
                    throw new RemoteException("Invalid token.");
                }
                Pair<Boolean, Boolean> result = this.this$0.mSmsDispatchersController.handleSmsStatusReport(tracker, format, pdu);
                Rlog.d("ImsSmsDispacher", "Status report handle result, success: " + result.first + "complete: " + result.second);
                try {
                    this.this$0.getImsManager().acknowledgeSmsReport(token, messageRef, (Boolean)result.first != false ? 1 : 2);
                }
                catch (ImsException e) {
                    Rlog.e("ImsSmsDispacher", "Failed to acknowledgeSmsReport(). Error: " + e.getMessage());
                }
                if (((Boolean)result.second).booleanValue()) {
                    this.this$0.mTrackers.remove(token);
                }
            }

            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSmsReceived(int token, String format, byte[] pdu) throws RemoteException {
                Rlog.d("ImsSmsDispacher", "SMS received.");
                SmsMessage message = SmsMessage.createFromPdu(pdu, format);
                this.this$0.mSmsDispatchersController.injectSmsPdu(message, format, result -> {
                    int mappedResult;
                    Rlog.d("ImsSmsDispacher", "SMS handled result: " + result);
                    switch (result) {
                        case 1: {
                            mappedResult = 1;
                            break;
                        }
                        case 3: {
                            mappedResult = 3;
                            break;
                        }
                        case 4: {
                            mappedResult = 4;
                            break;
                        }
                        default: {
                            mappedResult = 2;
                        }
                    }
                    try {
                        if (message != null && message.mWrappedSmsMessage != null) {
                            this.this$0.getImsManager().acknowledgeSms(token, message.mWrappedSmsMessage.mMessageRef, mappedResult);
                        } else {
                            Rlog.w("ImsSmsDispacher", "SMS Received with a PDU that could not be parsed.");
                            this.this$0.getImsManager().acknowledgeSms(token, 0, mappedResult);
                        }
                    }
                    catch (ImsException e) {
                        Rlog.e("ImsSmsDispacher", "Failed to acknowledgeSms(). Error: " + e.getMessage());
                    }
                }, true);
            }

            private void __constructor__(ImsSmsDispatcher imsSmsDispatcher) {
                this.$$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$__constructor__(imsSmsDispatcher);
            }
            {
                this.this$0 = imsSmsDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$__constructor__(com.android.internal.telephony.ImsSmsDispatcher ), 0, this, imsSmsDispatcher);
            }

            @Override
            public void onSendSmsResult(int n, int n2, int n3, int n4) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onSendSmsResult", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSendSmsResult(int int int int ), 0, this, n, n2, n3, n4);
            }

            @Override
            public void onSmsStatusReportReceived(int n, int n2, String string2, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onSmsStatusReportReceived", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSmsStatusReportReceived(int int java.lang.String byte[] ), 0, this, n, n2, string2, byArray);
            }

            @Override
            public void onSmsReceived(int n, String string2, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onSmsReceived", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_3$onSmsReceived(int java.lang.String byte[] ), 0, this, n, string2, byArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsManagerConnector = new ImsManager.Connector(this.mContext, this.mPhone.getPhoneId(), new ImsManager.Connector.Listener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsSmsDispatcher this$0;

            private void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$__constructor__(ImsSmsDispatcher this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$connectionReady(ImsManager manager) throws ImsException {
                Rlog.d("ImsSmsDispacher", "ImsManager: connection ready.");
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.setListeners();
                    this.this$0.mIsImsServiceUp = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$connectionUnavailable() {
                Rlog.d("ImsSmsDispacher", "ImsManager: connection unavailable.");
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mIsImsServiceUp = false;
                }
            }

            private void __constructor__(ImsSmsDispatcher imsSmsDispatcher) {
                this.$$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$__constructor__(imsSmsDispatcher);
            }
            {
                this.this$0 = imsSmsDispatcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$__constructor__(com.android.internal.telephony.ImsSmsDispatcher ), 0, this, imsSmsDispatcher);
            }

            @Override
            public void connectionReady(ImsManager imsManager) throws ImsException {
                InvokeDynamicSupport.bootstrap("connectionReady", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$connectionReady(com.android.ims.ImsManager ), 0, this, imsManager);
            }

            @Override
            public void connectionUnavailable() {
                InvokeDynamicSupport.bootstrap("connectionUnavailable", $$robo$$com_android_internal_telephony_ImsSmsDispatcher_4$connectionUnavailable(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mImsManagerConnector.connect();
    }

    private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher$setListeners() throws ImsException {
        this.getImsManager().addRegistrationCallback(this.mRegistrationCallback);
        this.getImsManager().addCapabilitiesCallback(this.mCapabilityCallback);
        this.getImsManager().setSmsListener(this.mImsSmsListener);
        this.getImsManager().onSmsReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ImsSmsDispatcher$isAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            Rlog.d("ImsSmsDispacher", "isAvailable: up=" + this.mIsImsServiceUp + ", reg= " + this.mIsRegistered + ", cap= " + this.mIsSmsCapable);
            return this.mIsImsServiceUp && this.mIsRegistered && this.mIsSmsCapable;
        }
    }

    private final String $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getFormat() {
        try {
            return this.getImsManager().getSmsFormat();
        }
        catch (ImsException e) {
            Rlog.e("ImsSmsDispacher", "Failed to get sms format. Error: " + e.getMessage());
            return "unknown";
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_ImsSmsDispatcher$shouldBlockSmsForEcbm() {
        return false;
    }

    private final SmsMessageBase.SubmitPduBase $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader, int priority, int validityPeriod) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, message, statusReportRequested, smsHeader, priority, validityPeriod);
    }

    private final SmsMessageBase.SubmitPduBase $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] message, boolean statusReportRequested) {
        return SMSDispatcherUtil.getSubmitPdu(this.isCdmaMo(), scAddr, destAddr, destPort, message, statusReportRequested);
    }

    private final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_ImsSmsDispatcher$calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SMSDispatcherUtil.calculateLength(this.isCdmaMo(), messageBody, use7bitOnly);
    }

    private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher$sendSms(SMSDispatcher.SmsTracker tracker) {
        boolean isRetry;
        Rlog.d("ImsSmsDispacher", "sendSms:  mRetryCount=" + tracker.mRetryCount + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        tracker.mUsesImsServiceForIms = true;
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        byte[] smsc = (byte[])map.get("smsc");
        boolean bl = isRetry = tracker.mRetryCount > 0;
        if ("3gpp".equals(this.getFormat()) && tracker.mRetryCount > 0 && (1 & pdu[0]) == 1) {
            pdu[0] = (byte)(pdu[0] | 4);
            pdu[1] = (byte)tracker.mMessageRef;
        }
        int token = this.mNextToken.incrementAndGet();
        this.mTrackers.put(token, tracker);
        try {
            this.getImsManager().sendSms(token, tracker.mMessageRef, this.getFormat(), smsc != null ? new String(smsc) : null, isRetry, pdu);
        }
        catch (ImsException e) {
            Rlog.e("ImsSmsDispacher", "sendSms failed. Falling back to PSTN. Error: " + e.getMessage());
            this.fallbackToPstn(token, tracker);
        }
    }

    private final ImsManager $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getImsManager() {
        return ImsManager.getInstance(this.mContext, this.mPhone.getPhoneId());
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_ImsSmsDispatcher$fallbackToPstn(int token, SMSDispatcher.SmsTracker tracker) {
        this.mSmsDispatchersController.sendRetrySms(tracker);
        this.mTrackers.remove(token);
    }

    private final boolean $$robo$$com_android_internal_telephony_ImsSmsDispatcher$isCdmaMo() {
        return this.mSmsDispatchersController.isCdmaFormat(this.getFormat());
    }

    private void __constructor__(Phone phone, SmsDispatchersController smsDispatchersController) {
        this.$$robo$$com_android_internal_telephony_ImsSmsDispatcher$__constructor__(phone, smsDispatchersController);
    }

    public ImsSmsDispatcher(Phone phone, SmsDispatchersController smsDispatchersController) {
        super(phone, smsDispatchersController);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsDispatchersController ), 0, this, phone, smsDispatchersController);
    }

    private void setListeners() throws ImsException {
        InvokeDynamicSupport.bootstrap("setListeners", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$setListeners(), 0, this);
    }

    public boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$isAvailable(), 0, this);
    }

    @Override
    protected String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getFormat(), 0, this);
    }

    @Override
    protected boolean shouldBlockSmsForEcbm() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldBlockSmsForEcbm", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$shouldBlockSmsForEcbm(), 0, this);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String string2, String string3, String string4, boolean bl, SmsHeader smsHeader, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSubmitPdu", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean com.android.internal.telephony.SmsHeader int int ), 0, this, string2, string3, string4, bl, smsHeader, n, n2);
    }

    @Override
    protected SmsMessageBase.SubmitPduBase getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getSubmitPdu", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getSubmitPdu(java.lang.String java.lang.String int byte[] boolean ), 0, this, string2, string3, n, byArray, bl);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateLength", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$calculateLength(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSms", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$sendSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private ImsManager getImsManager() {
        return InvokeDynamicSupport.bootstrap("getImsManager", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$getImsManager(), 0, this);
    }

    public void fallbackToPstn(int n, SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("fallbackToPstn", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$fallbackToPstn(int com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, n, smsTracker);
    }

    @Override
    protected boolean isCdmaMo() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaMo", $$robo$$com_android_internal_telephony_ImsSmsDispatcher$isCdmaMo(), 0, this);
    }

    public /* synthetic */ ImsSmsDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsSmsDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

