/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleTracker
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static String TAG;
    private static int EVENT_GET_CELL_INFO = 1;
    private static int EVENT_UPDATE_OPERATOR_NUMERIC = 2;
    private static int EVENT_SERVICE_STATE_CHANGED = 3;
    private static long CELL_INFO_MIN_DELAY_MS = 2000L;
    private static long CELL_INFO_MAX_DELAY_MS = 600000L;
    private static long CELL_INFO_PERIODIC_POLLING_DELAY_MS = 600000L;
    private Phone mPhone;
    private int mSimState;
    private String mOperatorNumeric;
    private List<CellInfo> mCellInfo;
    private int mFailCellInfoCount;
    private String mCurrentCountryIso;
    private int mLastServiceState;
    private LocalLog mLocalLog;
    private BroadcastReceiver mBroadcastReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_LocaleTracker$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                LocaleTracker localeTracker = this;
                synchronized (localeTracker) {
                    this.getCellInfo();
                    this.updateLocale();
                    break;
                }
            }
            case 2: {
                this.updateOperatorNumericSync((String)msg.obj);
                break;
            }
            case 3: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onServiceStateChanged((ServiceState)ar.result);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected message arrives. msg = " + msg.what);
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_LocaleTracker$__constructor__(Phone phone, Looper looper) {
        this.mLastServiceState = -1;
        this.mLocalLog = new LocalLog(50);
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ LocaleTracker this$0;

            private void $$robo$$com_android_internal_telephony_LocaleTracker_1$__constructor__(LocaleTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_LocaleTracker_1$onReceive(Context context, Intent intent) {
                int phoneId;
                if ("android.telephony.action.SIM_CARD_STATE_CHANGED".equals(intent.getAction()) && (phoneId = intent.getIntExtra("phone", 0)) == this.this$0.mPhone.getPhoneId()) {
                    this.this$0.onSimCardStateChanged(intent.getIntExtra("android.telephony.extra.SIM_STATE", 0));
                }
            }

            private void __constructor__(LocaleTracker localeTracker) {
                this.$$robo$$com_android_internal_telephony_LocaleTracker_1$__constructor__(localeTracker);
            }
            {
                this.this$0 = localeTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_LocaleTracker_1$__constructor__(com.android.internal.telephony.LocaleTracker ), 0, this, localeTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_LocaleTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mSimState = 0;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.telephony.action.SIM_CARD_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mBroadcastReceiver, filter);
        this.mPhone.registerForServiceStateChanged(this, 3, null);
    }

    private final synchronized String $$robo$$com_android_internal_telephony_LocaleTracker$getCurrentCountry() {
        return this.mCurrentCountryIso != null ? this.mCurrentCountryIso : "";
    }

    private final String $$robo$$com_android_internal_telephony_LocaleTracker$getMccFromCellInfo() {
        String selectedMcc = null;
        if (this.mCellInfo != null) {
            HashMap<String, Integer> countryCodeMap = new HashMap<String, Integer>();
            int maxCount = 0;
            for (CellInfo cellInfo : this.mCellInfo) {
                String mcc = null;
                if (cellInfo instanceof CellInfoGsm) {
                    mcc = ((CellInfoGsm)cellInfo).getCellIdentity().getMccString();
                } else if (cellInfo instanceof CellInfoLte) {
                    mcc = ((CellInfoLte)cellInfo).getCellIdentity().getMccString();
                } else if (cellInfo instanceof CellInfoWcdma) {
                    mcc = ((CellInfoWcdma)cellInfo).getCellIdentity().getMccString();
                }
                if (mcc == null) continue;
                int count = 1;
                if (countryCodeMap.containsKey(mcc)) {
                    count = (Integer)countryCodeMap.get(mcc) + 1;
                }
                countryCodeMap.put(mcc, count);
                if (count <= maxCount) continue;
                maxCount = count;
                selectedMcc = mcc;
            }
        }
        return selectedMcc;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_LocaleTracker$onSimCardStateChanged(int state) {
        if (this.mSimState != state && state == 1) {
            this.log("Sim absent. Get latest cell info from the modem.");
            this.getCellInfo();
            this.updateLocale();
        }
        this.mSimState = state;
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$onServiceStateChanged(ServiceState serviceState) {
        int state = serviceState.getState();
        if (state != this.mLastServiceState) {
            if (state != 3 && TextUtils.isEmpty(this.mOperatorNumeric)) {
                String msg = "Service state " + ServiceState.rilServiceStateToString(state) + ". Get cell info now.";
                this.log(msg);
                this.mLocalLog.log(msg);
                this.getCellInfo();
            } else if (state == 3) {
                if (this.mCellInfo != null) {
                    this.mCellInfo.clear();
                }
                this.stopCellInfoRetry();
            }
            this.updateLocale();
            this.mLastServiceState = state;
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_LocaleTracker$updateOperatorNumericSync(String operatorNumeric) {
        this.log("updateOperatorNumericSync. mcc/mnc=" + operatorNumeric);
        if (!Objects.equals(this.mOperatorNumeric, operatorNumeric)) {
            String msg = "Operator numeric changes to " + operatorNumeric;
            this.log(msg);
            this.mLocalLog.log(msg);
            this.mOperatorNumeric = operatorNumeric;
            if (TextUtils.isEmpty(this.mOperatorNumeric)) {
                this.log("Operator numeric unavailable. Get latest cell info from the modem.");
                this.getCellInfo();
            } else {
                if (this.mCellInfo != null) {
                    this.mCellInfo.clear();
                }
                this.stopCellInfoRetry();
            }
            this.updateLocale();
        }
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$updateOperatorNumericAsync(String operatorNumeric) {
        this.log("updateOperatorNumericAsync. mcc/mnc=" + operatorNumeric);
        this.sendMessage(this.obtainMessage(2, operatorNumeric));
    }

    private final long $$robo$$com_android_internal_telephony_LocaleTracker$getCellInfoDelayTime(int failCount) {
        long delay = 2000L * (long)Math.pow(2.0, failCount - 1);
        if (delay < 2000L) {
            delay = 2000L;
        } else if (delay > 600000L) {
            delay = 600000L;
        }
        return delay;
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$stopCellInfoRetry() {
        this.mFailCellInfoCount = 0;
        this.removeMessages(1);
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$getCellInfo() {
        if (!this.mPhone.getServiceStateTracker().getDesiredPowerState()) {
            String msg = "Radio is off. Stopped cell info retry. Cleared the previous cached cell info.";
            if (this.mCellInfo != null) {
                this.mCellInfo.clear();
            }
            this.log(msg);
            this.mLocalLog.log(msg);
            this.stopCellInfoRetry();
            return;
        }
        this.mCellInfo = this.mPhone.getAllCellInfo(null);
        String msg = "getCellInfo: cell info=" + this.mCellInfo;
        this.log(msg);
        this.mLocalLog.log(msg);
        if (CollectionUtils.isEmpty(this.mCellInfo)) {
            long delay = this.getCellInfoDelayTime(++this.mFailCellInfoCount);
            this.log("Can't get cell info. Try again in " + delay / 1000L + " secs.");
            this.removeMessages(1);
            this.sendMessageDelayed(this.obtainMessage(1), delay);
        } else {
            this.stopCellInfoRetry();
            this.sendMessageDelayed(this.obtainMessage(1), 600000L);
        }
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$updateLocale() {
        String mcc = null;
        String countryIso = "";
        if (!TextUtils.isEmpty(this.mOperatorNumeric)) {
            try {
                mcc = this.mOperatorNumeric.substring(0, 3);
                countryIso = MccTable.countryCodeForMcc(Integer.parseInt(mcc));
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException ex) {
                this.loge("updateLocale: Can't get country from operator numeric. mcc = " + mcc + ". ex=" + ex);
            }
        }
        if (TextUtils.isEmpty(countryIso) && !TextUtils.isEmpty(mcc = this.getMccFromCellInfo())) {
            try {
                countryIso = MccTable.countryCodeForMcc(Integer.parseInt(mcc));
            }
            catch (NumberFormatException ex) {
                this.loge("updateLocale: Can't get country from cell info. mcc = " + mcc + ". ex=" + ex);
            }
        }
        String msg = "updateLocale: mcc = " + mcc + ", country = " + countryIso;
        this.log(msg);
        this.mLocalLog.log(msg);
        if (!Objects.equals(countryIso, this.mCurrentCountryIso)) {
            msg = "updateLocale: Change the current country to " + countryIso;
            this.log(msg);
            this.mLocalLog.log(msg);
            this.mCurrentCountryIso = countryIso;
            TelephonyManager.setTelephonyProperty(this.mPhone.getPhoneId(), "gsm.operator.iso-country", this.mCurrentCountryIso);
            ((WifiManager)this.mPhone.getContext().getSystemService("wifi")).setCountryCode(countryIso);
        }
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$log(String msg) {
        Rlog.d(TAG, msg);
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$loge(String msg) {
        Rlog.e(TAG, msg);
    }

    private final void $$robo$$com_android_internal_telephony_LocaleTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println("LocaleTracker:");
        ipw.increaseIndent();
        ipw.println("mOperatorNumeric = " + this.mOperatorNumeric);
        ipw.println("mSimState = " + this.mSimState);
        ipw.println("mCellInfo = " + this.mCellInfo);
        ipw.println("mCurrentCountryIso = " + this.mCurrentCountryIso);
        ipw.println("mFailCellInfoCount = " + this.mFailCellInfoCount);
        ipw.println("Local logs:");
        ipw.increaseIndent();
        this.mLocalLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.decreaseIndent();
        ipw.flush();
    }

    static void __staticInitializer__() {
        TAG = LocaleTracker.class.getSimpleName();
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_LocaleTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    private void __constructor__(Phone phone, Looper looper) {
        this.$$robo$$com_android_internal_telephony_LocaleTracker$__constructor__(phone, looper);
    }

    public LocaleTracker(Phone phone, Looper looper) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_LocaleTracker$__constructor__(com.android.internal.telephony.Phone android.os.Looper ), 0, this, phone, looper);
    }

    public synchronized String getCurrentCountry() {
        return InvokeDynamicSupport.bootstrap("getCurrentCountry", $$robo$$com_android_internal_telephony_LocaleTracker$getCurrentCountry(), 0, this);
    }

    private String getMccFromCellInfo() {
        return InvokeDynamicSupport.bootstrap("getMccFromCellInfo", $$robo$$com_android_internal_telephony_LocaleTracker$getMccFromCellInfo(), 0, this);
    }

    private synchronized void onSimCardStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onSimCardStateChanged", $$robo$$com_android_internal_telephony_LocaleTracker$onSimCardStateChanged(int ), 0, this, n);
    }

    private void onServiceStateChanged(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("onServiceStateChanged", $$robo$$com_android_internal_telephony_LocaleTracker$onServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
    }

    public synchronized void updateOperatorNumericSync(String string2) {
        InvokeDynamicSupport.bootstrap("updateOperatorNumericSync", $$robo$$com_android_internal_telephony_LocaleTracker$updateOperatorNumericSync(java.lang.String ), 0, this, string2);
    }

    public void updateOperatorNumericAsync(String string2) {
        InvokeDynamicSupport.bootstrap("updateOperatorNumericAsync", $$robo$$com_android_internal_telephony_LocaleTracker$updateOperatorNumericAsync(java.lang.String ), 0, this, string2);
    }

    private long getCellInfoDelayTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getCellInfoDelayTime", $$robo$$com_android_internal_telephony_LocaleTracker$getCellInfoDelayTime(int ), 0, this, n);
    }

    private void stopCellInfoRetry() {
        InvokeDynamicSupport.bootstrap("stopCellInfoRetry", $$robo$$com_android_internal_telephony_LocaleTracker$stopCellInfoRetry(), 0, this);
    }

    private void getCellInfo() {
        InvokeDynamicSupport.bootstrap("getCellInfo", $$robo$$com_android_internal_telephony_LocaleTracker$getCellInfo(), 0, this);
    }

    private void updateLocale() {
        InvokeDynamicSupport.bootstrap("updateLocale", $$robo$$com_android_internal_telephony_LocaleTracker$updateLocale(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_LocaleTracker$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_LocaleTracker$loge(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_LocaleTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(LocaleTracker.class);
    }

    public /* synthetic */ LocaleTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

