/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.CarrierConfigManager;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkRegistrationState;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import java.util.Hashtable;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkRegistrationManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private int mTransportType;
    private Phone mPhone;
    private CarrierConfigManager mCarrierConfigManager;
    private RegistrantList mRegStateChangeRegistrants;
    private INetworkService.Stub mServiceBinder;
    private RegManagerDeathRecipient mDeathRecipient;
    private Map<NetworkRegStateCallback, Message> mCallbackTable;

    private void $$robo$$com_android_internal_telephony_NetworkRegistrationManager$__constructor__(int transportType, Phone phone) {
        this.mRegStateChangeRegistrants = new RegistrantList();
        this.mCallbackTable = new Hashtable<NetworkRegStateCallback, Message>();
        this.mTransportType = transportType;
        this.mPhone = phone;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        this.bindService();
    }

    private final boolean $$robo$$com_android_internal_telephony_NetworkRegistrationManager$isServiceConnected() {
        return this.mServiceBinder != null && this.mServiceBinder.isBinderAlive();
    }

    private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager$unregisterForNetworkRegistrationStateChanged(Handler h) {
        this.mRegStateChangeRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager$registerForNetworkRegistrationStateChanged(Handler h, int what, Object obj) {
        NetworkRegistrationManager.logd("registerForNetworkRegistrationStateChanged");
        Registrant r = new Registrant(h, what, obj);
        this.mRegStateChangeRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager$getNetworkRegistrationState(int domain, Message onCompleteMessage) {
        if (onCompleteMessage == null) {
            return;
        }
        NetworkRegistrationManager.logd("getNetworkRegistrationState domain " + domain);
        if (!this.isServiceConnected()) {
            NetworkRegistrationManager.logd("service not connected.");
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, new IllegalStateException("Service not connected."));
            onCompleteMessage.sendToTarget();
            return;
        }
        NetworkRegStateCallback callback = new NetworkRegStateCallback(this);
        try {
            this.mCallbackTable.put(callback, onCompleteMessage);
            this.mServiceBinder.getNetworkRegistrationState(this.mPhone.getPhoneId(), domain, callback);
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "getNetworkRegistrationState RemoteException " + e);
            this.mCallbackTable.remove(callback);
            onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, null, e);
            onCompleteMessage.sendToTarget();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_NetworkRegistrationManager$bindService() {
        Intent intent = new Intent("android.telephony.NetworkService");
        intent.setPackage(this.getPackageName());
        try {
            return this.mPhone.getContext().bindService(intent, new NetworkServiceConnection(this), 1);
        }
        catch (SecurityException e) {
            NetworkRegistrationManager.loge("bindService failed " + e);
            return false;
        }
    }

    private final String $$robo$$com_android_internal_telephony_NetworkRegistrationManager$getPackageName() {
        String carrierConfig;
        int resourceId;
        switch (this.mTransportType) {
            case 1: {
                resourceId = 17039729;
                carrierConfig = "carrier_network_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039727;
                carrierConfig = "carrier_network_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + this.mTransportType);
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null) {
            packageName = b.getString(carrierConfig, packageName);
        }
        NetworkRegistrationManager.logd("Binding to packageName " + packageName + " for transport type" + this.mTransportType);
        return packageName;
    }

    private static final int $$robo$$com_android_internal_telephony_NetworkRegistrationManager$logd(String msg) {
        return Rlog.d(TAG, msg);
    }

    private static final int $$robo$$com_android_internal_telephony_NetworkRegistrationManager$loge(String msg) {
        return Rlog.e(TAG, msg);
    }

    static void __staticInitializer__() {
        TAG = NetworkRegistrationManager.class.getSimpleName();
    }

    private void __constructor__(int n, Phone phone) {
        this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager$__constructor__(n, phone);
    }

    public NetworkRegistrationManager(int n, Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$__constructor__(int com.android.internal.telephony.Phone ), 0, this, n, phone);
    }

    public boolean isServiceConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceConnected", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$isServiceConnected(), 0, this);
    }

    public void unregisterForNetworkRegistrationStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNetworkRegistrationStateChanged", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$unregisterForNetworkRegistrationStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForNetworkRegistrationStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNetworkRegistrationStateChanged", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$registerForNetworkRegistrationStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void getNetworkRegistrationState(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getNetworkRegistrationState", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$getNetworkRegistrationState(int android.os.Message ), 0, this, n, message);
    }

    private boolean bindService() {
        return (boolean)InvokeDynamicSupport.bootstrap("bindService", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$bindService(), 0, this);
    }

    private String getPackageName() {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$getPackageName(), 0, this);
    }

    private static int logd(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$logd(java.lang.String ), 0, (String)string2);
    }

    private static int loge(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_NetworkRegistrationManager$loge(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkRegistrationManager.class);
    }

    public /* synthetic */ NetworkRegistrationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkRegistrationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NetworkRegStateCallback
    extends INetworkServiceCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NetworkRegistrationManager this$0;

        private void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$__constructor__(NetworkRegistrationManager networkRegistrationManager) {
        }

        private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$onGetNetworkRegistrationStateComplete(int result, NetworkRegistrationState state) {
            NetworkRegistrationManager.logd("onGetNetworkRegistrationStateComplete result " + result + " state " + state);
            Message onCompleteMessage = (Message)this.this$0.mCallbackTable.remove(this);
            if (onCompleteMessage != null) {
                onCompleteMessage.arg1 = result;
                onCompleteMessage.obj = new AsyncResult(onCompleteMessage.obj, state, null);
                onCompleteMessage.sendToTarget();
            } else {
                NetworkRegistrationManager.loge("onCompleteMessage is null");
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$onNetworkStateChanged() {
            NetworkRegistrationManager.logd("onNetworkStateChanged");
            this.this$0.mRegStateChangeRegistrants.notifyRegistrants();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$__constructor__(NetworkRegistrationManager x0, 1 x1) {
        }

        private void __constructor__(NetworkRegistrationManager networkRegistrationManager) {
            this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$__constructor__(networkRegistrationManager);
        }

        private NetworkRegStateCallback(NetworkRegistrationManager networkRegistrationManager) {
            this.this$0 = networkRegistrationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$__constructor__(com.android.internal.telephony.NetworkRegistrationManager ), 0, this, networkRegistrationManager);
        }

        @Override
        public void onGetNetworkRegistrationStateComplete(int n, NetworkRegistrationState networkRegistrationState) {
            InvokeDynamicSupport.bootstrap("onGetNetworkRegistrationStateComplete", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$onGetNetworkRegistrationStateComplete(int android.telephony.NetworkRegistrationState ), 0, this, n, networkRegistrationState);
        }

        @Override
        public void onNetworkStateChanged() {
            InvokeDynamicSupport.bootstrap("onNetworkStateChanged", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$onNetworkStateChanged(), 0, this);
        }

        private /* synthetic */ void __constructor__(NetworkRegistrationManager networkRegistrationManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkRegStateCallback$__constructor__(networkRegistrationManager, var2_2);
        }

        public /* synthetic */ NetworkRegStateCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkRegStateCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NetworkServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NetworkRegistrationManager this$0;

        private void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$__constructor__(NetworkRegistrationManager networkRegistrationManager) {
        }

        private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            NetworkRegistrationManager.logd("service connected.");
            this.this$0.mServiceBinder = (INetworkService.Stub)service;
            this.this$0.mDeathRecipient = new RegManagerDeathRecipient(this.this$0, name);
            try {
                this.this$0.mServiceBinder.linkToDeath(this.this$0.mDeathRecipient, 0);
                this.this$0.mServiceBinder.createNetworkServiceProvider(this.this$0.mPhone.getPhoneId());
                this.this$0.mServiceBinder.registerForNetworkRegistrationStateChanged(this.this$0.mPhone.getPhoneId(), new NetworkRegStateCallback(this.this$0));
            }
            catch (RemoteException exception) {
                this.this$0.mDeathRecipient.binderDied();
                NetworkRegistrationManager.logd("RemoteException " + exception);
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$onServiceDisconnected(ComponentName name) {
            NetworkRegistrationManager.logd("onServiceDisconnected " + name);
            if (this.this$0.mServiceBinder != null) {
                this.this$0.mServiceBinder.unlinkToDeath(this.this$0.mDeathRecipient, 0);
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$__constructor__(NetworkRegistrationManager x0, 1 x1) {
        }

        private void __constructor__(NetworkRegistrationManager networkRegistrationManager) {
            this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$__constructor__(networkRegistrationManager);
        }

        private NetworkServiceConnection(NetworkRegistrationManager networkRegistrationManager) {
            this.this$0 = networkRegistrationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$__constructor__(com.android.internal.telephony.NetworkRegistrationManager ), 0, this, networkRegistrationManager);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        private /* synthetic */ void __constructor__(NetworkRegistrationManager networkRegistrationManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager_NetworkServiceConnection$__constructor__(networkRegistrationManager, var2_2);
        }

        public /* synthetic */ NetworkServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class RegManagerDeathRecipient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ComponentName mComponentName;
        /* synthetic */ NetworkRegistrationManager this$0;

        private void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_RegManagerDeathRecipient$__constructor__(NetworkRegistrationManager networkRegistrationManager, ComponentName name) {
            this.mComponentName = name;
        }

        private final void $$robo$$com_android_internal_telephony_NetworkRegistrationManager_RegManagerDeathRecipient$binderDied() {
            NetworkRegistrationManager.logd("NetworkService(" + this.mComponentName + " transport type " + this.this$0.mTransportType + ") died.");
        }

        private void __constructor__(NetworkRegistrationManager networkRegistrationManager, ComponentName componentName) {
            this.$$robo$$com_android_internal_telephony_NetworkRegistrationManager_RegManagerDeathRecipient$__constructor__(networkRegistrationManager, componentName);
        }

        RegManagerDeathRecipient(NetworkRegistrationManager networkRegistrationManager, ComponentName componentName) {
            this.this$0 = networkRegistrationManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_RegManagerDeathRecipient$__constructor__(com.android.internal.telephony.NetworkRegistrationManager android.content.ComponentName ), 0, this, networkRegistrationManager, componentName);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_telephony_NetworkRegistrationManager_RegManagerDeathRecipient$binderDied(), 0, this);
        }

        public /* synthetic */ RegManagerDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegManagerDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

