/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.telephony.Rlog;
import com.android.internal.annotations.VisibleForTesting;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Calendar;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class NitzData
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SST";
    private static int MS_PER_QUARTER_HOUR = 900000;
    private static int MAX_NITZ_YEAR = 2037;
    private String mOriginalString;
    private int mZoneOffset;
    private Integer mDstOffset;
    private long mCurrentTimeMillis;
    private TimeZone mEmulatorHostTimeZone;

    private void $$robo$$com_android_internal_telephony_NitzData$__constructor__(String originalString, int zoneOffsetMillis, Integer dstOffsetMillis, long utcTimeMillis, TimeZone emulatorHostTimeZone) {
        if (originalString == null) {
            throw new NullPointerException("originalString==null");
        }
        this.mOriginalString = originalString;
        this.mZoneOffset = zoneOffsetMillis;
        this.mDstOffset = dstOffsetMillis;
        this.mCurrentTimeMillis = utcTimeMillis;
        this.mEmulatorHostTimeZone = emulatorHostTimeZone;
    }

    private static final NitzData $$robo$$com_android_internal_telephony_NitzData$parse(String nitz) {
        try {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.clear();
            c.set(16, 0);
            String[] nitzSubs = nitz.split("[/:,+-]");
            int year = 2000 + Integer.parseInt(nitzSubs[0]);
            if (year > 2037) {
                Rlog.e("SST", "NITZ year: " + year + " exceeds limit, skip NITZ time update");
                return null;
            }
            c.set(1, year);
            int month = Integer.parseInt(nitzSubs[1]) - 1;
            c.set(2, month);
            int date = Integer.parseInt(nitzSubs[2]);
            c.set(5, date);
            int hour = Integer.parseInt(nitzSubs[3]);
            c.set(10, hour);
            int minute = Integer.parseInt(nitzSubs[4]);
            c.set(12, minute);
            int second = Integer.parseInt(nitzSubs[5]);
            c.set(13, second);
            boolean sign = nitz.indexOf(45) == -1;
            int totalUtcOffsetQuarterHours = Integer.parseInt(nitzSubs[6]);
            int totalUtcOffsetMillis = (sign ? 1 : -1) * totalUtcOffsetQuarterHours * 900000;
            Integer dstAdjustmentQuarterHours = nitzSubs.length >= 8 ? Integer.valueOf(Integer.parseInt(nitzSubs[7])) : null;
            Integer dstAdjustmentMillis = null;
            if (dstAdjustmentQuarterHours != null) {
                dstAdjustmentMillis = dstAdjustmentQuarterHours * 900000;
            }
            TimeZone zone = null;
            if (nitzSubs.length >= 9) {
                String tzname = nitzSubs[8].replace('!', '/');
                zone = TimeZone.getTimeZone(tzname);
            }
            return new NitzData(nitz, totalUtcOffsetMillis, dstAdjustmentMillis, c.getTimeInMillis(), zone);
        }
        catch (RuntimeException ex) {
            Rlog.e("SST", "NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
            return null;
        }
    }

    private static final NitzData $$robo$$com_android_internal_telephony_NitzData$createForTests(int zoneOffsetMillis, Integer dstOffsetMillis, long utcTimeMillis, TimeZone emulatorHostTimeZone) {
        return new NitzData("Test data", zoneOffsetMillis, dstOffsetMillis, utcTimeMillis, emulatorHostTimeZone);
    }

    private final long $$robo$$com_android_internal_telephony_NitzData$getCurrentTimeInMillis() {
        return this.mCurrentTimeMillis;
    }

    private final int $$robo$$com_android_internal_telephony_NitzData$getLocalOffsetMillis() {
        return this.mZoneOffset;
    }

    private final Integer $$robo$$com_android_internal_telephony_NitzData$getDstAdjustmentMillis() {
        return this.mDstOffset;
    }

    private final boolean $$robo$$com_android_internal_telephony_NitzData$isDst() {
        return this.mDstOffset != null && this.mDstOffset != 0;
    }

    private final TimeZone $$robo$$com_android_internal_telephony_NitzData$getEmulatorHostTimeZone() {
        return this.mEmulatorHostTimeZone;
    }

    private final boolean $$robo$$com_android_internal_telephony_NitzData$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NitzData nitzData = (NitzData)o;
        if (this.mZoneOffset != nitzData.mZoneOffset) {
            return false;
        }
        if (this.mCurrentTimeMillis != nitzData.mCurrentTimeMillis) {
            return false;
        }
        if (!this.mOriginalString.equals(nitzData.mOriginalString)) {
            return false;
        }
        if (this.mDstOffset != null ? !this.mDstOffset.equals(nitzData.mDstOffset) : nitzData.mDstOffset != null) {
            return false;
        }
        return this.mEmulatorHostTimeZone != null ? this.mEmulatorHostTimeZone.equals(nitzData.mEmulatorHostTimeZone) : nitzData.mEmulatorHostTimeZone == null;
    }

    private final int $$robo$$com_android_internal_telephony_NitzData$hashCode() {
        int result = this.mOriginalString.hashCode();
        result = 31 * result + this.mZoneOffset;
        result = 31 * result + (this.mDstOffset != null ? this.mDstOffset.hashCode() : 0);
        result = 31 * result + (int)(this.mCurrentTimeMillis ^ this.mCurrentTimeMillis >>> 32);
        result = 31 * result + (this.mEmulatorHostTimeZone != null ? this.mEmulatorHostTimeZone.hashCode() : 0);
        return result;
    }

    private final String $$robo$$com_android_internal_telephony_NitzData$toString() {
        return "NitzData{mOriginalString=" + this.mOriginalString + ", mZoneOffset=" + this.mZoneOffset + ", mDstOffset=" + this.mDstOffset + ", mCurrentTimeMillis=" + this.mCurrentTimeMillis + ", mEmulatorHostTimeZone=" + this.mEmulatorHostTimeZone + '}';
    }

    private void __constructor__(String string2, int n, Integer n2, long l, TimeZone timeZone) {
        this.$$robo$$com_android_internal_telephony_NitzData$__constructor__(string2, n, n2, l, timeZone);
    }

    private NitzData(String string2, int n, Integer n2, long l, TimeZone timeZone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NitzData$__constructor__(java.lang.String int java.lang.Integer long java.util.TimeZone ), 0, this, string2, n, n2, l, timeZone);
    }

    public static NitzData parse(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$com_android_internal_telephony_NitzData$parse(java.lang.String ), 0, (String)string2);
    }

    public static NitzData createForTests(int n, Integer n2, long l, TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrapStatic("createForTests", $$robo$$com_android_internal_telephony_NitzData$createForTests(int java.lang.Integer long java.util.TimeZone ), 0, (int)n, (Integer)n2, (long)l, (TimeZone)timeZone);
    }

    public long getCurrentTimeInMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentTimeInMillis", $$robo$$com_android_internal_telephony_NitzData$getCurrentTimeInMillis(), 0, this);
    }

    public int getLocalOffsetMillis() {
        return (int)InvokeDynamicSupport.bootstrap("getLocalOffsetMillis", $$robo$$com_android_internal_telephony_NitzData$getLocalOffsetMillis(), 0, this);
    }

    public Integer getDstAdjustmentMillis() {
        return InvokeDynamicSupport.bootstrap("getDstAdjustmentMillis", $$robo$$com_android_internal_telephony_NitzData$getDstAdjustmentMillis(), 0, this);
    }

    public boolean isDst() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDst", $$robo$$com_android_internal_telephony_NitzData$isDst(), 0, this);
    }

    public TimeZone getEmulatorHostTimeZone() {
        return InvokeDynamicSupport.bootstrap("getEmulatorHostTimeZone", $$robo$$com_android_internal_telephony_NitzData$getEmulatorHostTimeZone(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_NitzData$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_NitzData$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_NitzData$toString(), 0, this);
    }

    public /* synthetic */ NitzData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NitzData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

