/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.config.V1_0.IRadioConfig;
import android.hardware.radio.config.V1_0.SimSlotStatus;
import android.net.ConnectivityManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Message;
import android.os.Registrant;
import android.os.RemoteException;
import android.os.WorkSource;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioConfigIndication;
import com.android.internal.telephony.RadioConfigResponse;
import com.android.internal.telephony.uicc.IccSlotStatus;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadioConfig
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RadioConfig";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int EVENT_SERVICE_DEAD = 1;
    private boolean mIsMobileNetworkSupported;
    private volatile IRadioConfig mRadioConfigProxy;
    private ServiceDeathRecipient mServiceDeathRecipient;
    private AtomicLong mRadioConfigProxyCookie;
    private RadioConfigResponse mRadioConfigResponse;
    private RadioConfigIndication mRadioConfigIndication;
    private SparseArray<RILRequest> mRequestList;
    private WorkSource mDefaultWorkSource;
    private static RadioConfig sRadioConfig;
    protected Registrant mSimSlotStatusRegistrant;

    private void $$robo$$com_android_internal_telephony_RadioConfig$__constructor__(Context context) {
        this.mRadioConfigProxy = null;
        this.mRadioConfigProxyCookie = new AtomicLong(0L);
        this.mRequestList = new SparseArray();
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mIsMobileNetworkSupported = cm.isNetworkSupported(0);
        this.mRadioConfigResponse = new RadioConfigResponse(this);
        this.mRadioConfigIndication = new RadioConfigIndication(this);
        this.mServiceDeathRecipient = new ServiceDeathRecipient(this);
        this.mDefaultWorkSource = new WorkSource(context.getApplicationInfo().uid, context.getPackageName());
    }

    private static final RadioConfig $$robo$$com_android_internal_telephony_RadioConfig$getInstance(Context context) {
        if (sRadioConfig == null) {
            sRadioConfig = new RadioConfig(context);
        }
        return sRadioConfig;
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                RadioConfig.logd("handleMessage: EVENT_SERVICE_DEAD cookie = " + message.obj + " mRadioConfigProxyCookie = " + this.mRadioConfigProxyCookie.get());
                if (((Long)message.obj).longValue() != this.mRadioConfigProxyCookie.get()) break;
                this.resetProxyAndRequestList("EVENT_SERVICE_DEAD", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RadioConfig$clearRequestList(int error, boolean loggable) {
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            int count = this.mRequestList.size();
            if (loggable) {
                RadioConfig.logd("clearRequestList: mRequestList=" + count);
            }
            for (int i = 0; i < count; ++i) {
                RILRequest rr = this.mRequestList.valueAt(i);
                if (loggable) {
                    RadioConfig.logd(i + ": [" + rr.mSerial + "] " + RadioConfig.requestToString(rr.mRequest));
                }
                rr.onError(error, null);
                rr.release();
            }
            this.mRequestList.clear();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$resetProxyAndRequestList(String caller, Exception e) {
        RadioConfig.loge(caller + ": " + e);
        this.mRadioConfigProxy = null;
        this.mRadioConfigProxyCookie.incrementAndGet();
        RILRequest.resetSerial();
        this.clearRequestList(1, false);
        this.getRadioConfigProxy(null);
    }

    private final IRadioConfig $$robo$$com_android_internal_telephony_RadioConfig$getRadioConfigProxy(Message result) {
        if (!this.mIsMobileNetworkSupported) {
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
            return null;
        }
        if (this.mRadioConfigProxy != null) {
            return this.mRadioConfigProxy;
        }
        try {
            this.mRadioConfigProxy = IRadioConfig.getService(true);
            if (this.mRadioConfigProxy != null) {
                this.mRadioConfigProxy.linkToDeath(this.mServiceDeathRecipient, this.mRadioConfigProxyCookie.incrementAndGet());
                this.mRadioConfigProxy.setResponseFunctions(this.mRadioConfigResponse, this.mRadioConfigIndication);
            } else {
                RadioConfig.loge("getRadioConfigProxy: mRadioConfigProxy == null");
            }
        }
        catch (RemoteException | RuntimeException e) {
            this.mRadioConfigProxy = null;
            RadioConfig.loge("getRadioConfigProxy: RadioConfigProxy getService/setResponseFunctions: " + e);
        }
        if (this.mRadioConfigProxy == null) {
            RadioConfig.loge("getRadioConfigProxy: mRadioConfigProxy == null");
            if (result != null) {
                AsyncResult.forMessage(result, null, CommandException.fromRilErrno(1));
                result.sendToTarget();
            }
        }
        return this.mRadioConfigProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RILRequest $$robo$$com_android_internal_telephony_RadioConfig$obtainRequest(int request, Message result, WorkSource workSource) {
        RILRequest rr = RILRequest.obtain(request, result, workSource);
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            this.mRequestList.append(rr.mSerial, rr);
        }
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RILRequest $$robo$$com_android_internal_telephony_RadioConfig$findAndRemoveRequestFromList(int serial) {
        RILRequest rr;
        SparseArray<RILRequest> sparseArray = this.mRequestList;
        synchronized (sparseArray) {
            rr = this.mRequestList.get(serial);
            if (rr != null) {
                this.mRequestList.remove(serial);
            }
        }
        return rr;
    }

    private final RILRequest $$robo$$com_android_internal_telephony_RadioConfig$processResponse(RadioResponseInfo responseInfo) {
        RILRequest rr;
        int serial = responseInfo.serial;
        int error = responseInfo.error;
        int type = responseInfo.type;
        if (type != 0) {
            RadioConfig.loge("processResponse: Unexpected response type " + type);
        }
        if ((rr = this.findAndRemoveRequestFromList(serial)) == null) {
            RadioConfig.loge("processResponse: Unexpected response! serial: " + serial + " error: " + error);
            return null;
        }
        return rr;
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$getSimSlotsStatus(Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(result);
        if (radioConfigProxy != null) {
            RILRequest rr = this.obtainRequest(144, result, this.mDefaultWorkSource);
            RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest));
            try {
                radioConfigProxy.getSimSlotsStatus(rr.mSerial);
            }
            catch (RemoteException | RuntimeException e) {
                this.resetProxyAndRequestList("getSimSlotsStatus", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$setSimSlotsMapping(int[] physicalSlots, Message result) {
        IRadioConfig radioConfigProxy = this.getRadioConfigProxy(result);
        if (radioConfigProxy != null) {
            RILRequest rr = this.obtainRequest(145, result, this.mDefaultWorkSource);
            RadioConfig.logd(rr.serialString() + "> " + RadioConfig.requestToString(rr.mRequest) + " " + Arrays.toString(physicalSlots));
            try {
                radioConfigProxy.setSimSlotsMapping(rr.mSerial, RadioConfig.primitiveArrayToArrayList(physicalSlots));
            }
            catch (RemoteException | RuntimeException e) {
                this.resetProxyAndRequestList("setSimSlotsMapping", e);
            }
        }
    }

    private static final ArrayList<Integer> $$robo$$com_android_internal_telephony_RadioConfig$primitiveArrayToArrayList(int[] arr) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(arr.length);
        for (int i : arr) {
            arrayList.add(i);
        }
        return arrayList;
    }

    private static final String $$robo$$com_android_internal_telephony_RadioConfig$requestToString(int request) {
        switch (request) {
            case 144: {
                return "GET_SLOT_STATUS";
            }
            case 145: {
                return "SET_LOGICAL_TO_PHYSICAL_SLOT_MAPPING";
            }
        }
        return "<unknown request>";
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$registerForSimSlotStatusChanged(Handler h, int what, Object obj) {
        this.mSimSlotStatusRegistrant = new Registrant(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_RadioConfig$unregisterForSimSlotStatusChanged(Handler h) {
        if (this.mSimSlotStatusRegistrant != null && this.mSimSlotStatusRegistrant.getHandler() == h) {
            this.mSimSlotStatusRegistrant.clear();
            this.mSimSlotStatusRegistrant = null;
        }
    }

    private static final ArrayList<IccSlotStatus> $$robo$$com_android_internal_telephony_RadioConfig$convertHalSlotStatus(ArrayList<SimSlotStatus> halSlotStatusList) {
        ArrayList<IccSlotStatus> response = new ArrayList<IccSlotStatus>(halSlotStatusList.size());
        for (SimSlotStatus slotStatus : halSlotStatusList) {
            IccSlotStatus iccSlotStatus = new IccSlotStatus();
            iccSlotStatus.setCardState(slotStatus.cardState);
            iccSlotStatus.setSlotState(slotStatus.slotState);
            iccSlotStatus.logicalSlotIndex = slotStatus.logicalSlotId;
            iccSlotStatus.atr = slotStatus.atr;
            iccSlotStatus.iccid = slotStatus.iccid;
            response.add(iccSlotStatus);
        }
        return response;
    }

    private static final void $$robo$$com_android_internal_telephony_RadioConfig$logd(String log) {
        Rlog.d("RadioConfig", log);
    }

    private static final void $$robo$$com_android_internal_telephony_RadioConfig$loge(String log) {
        Rlog.e("RadioConfig", log);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_RadioConfig$__constructor__(context);
    }

    private RadioConfig(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RadioConfig$__constructor__(android.content.Context ), 0, this, context);
    }

    public static RadioConfig getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_RadioConfig$getInstance(android.content.Context ), 0, (Context)context);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_RadioConfig$handleMessage(android.os.Message ), 0, this, message);
    }

    private void clearRequestList(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("clearRequestList", $$robo$$com_android_internal_telephony_RadioConfig$clearRequestList(int boolean ), 0, this, n, bl);
    }

    private void resetProxyAndRequestList(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("resetProxyAndRequestList", $$robo$$com_android_internal_telephony_RadioConfig$resetProxyAndRequestList(java.lang.String java.lang.Exception ), 0, this, string2, exception);
    }

    public IRadioConfig getRadioConfigProxy(Message message) {
        return InvokeDynamicSupport.bootstrap("getRadioConfigProxy", $$robo$$com_android_internal_telephony_RadioConfig$getRadioConfigProxy(android.os.Message ), 0, this, message);
    }

    private RILRequest obtainRequest(int n, Message message, WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("obtainRequest", $$robo$$com_android_internal_telephony_RadioConfig$obtainRequest(int android.os.Message android.os.WorkSource ), 0, this, n, message, workSource);
    }

    private RILRequest findAndRemoveRequestFromList(int n) {
        return InvokeDynamicSupport.bootstrap("findAndRemoveRequestFromList", $$robo$$com_android_internal_telephony_RadioConfig$findAndRemoveRequestFromList(int ), 0, this, n);
    }

    public RILRequest processResponse(RadioResponseInfo radioResponseInfo) {
        return InvokeDynamicSupport.bootstrap("processResponse", $$robo$$com_android_internal_telephony_RadioConfig$processResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    public void getSimSlotsStatus(Message message) {
        InvokeDynamicSupport.bootstrap("getSimSlotsStatus", $$robo$$com_android_internal_telephony_RadioConfig$getSimSlotsStatus(android.os.Message ), 0, this, message);
    }

    public void setSimSlotsMapping(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setSimSlotsMapping", $$robo$$com_android_internal_telephony_RadioConfig$setSimSlotsMapping(int[] android.os.Message ), 0, this, nArray, message);
    }

    private static ArrayList<Integer> primitiveArrayToArrayList(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("primitiveArrayToArrayList", $$robo$$com_android_internal_telephony_RadioConfig$primitiveArrayToArrayList(int[] ), 0, (int[])nArray);
    }

    static String requestToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("requestToString", $$robo$$com_android_internal_telephony_RadioConfig$requestToString(int ), 0, (int)n);
    }

    public void registerForSimSlotStatusChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimSlotStatusChanged", $$robo$$com_android_internal_telephony_RadioConfig$registerForSimSlotStatusChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSimSlotStatusChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimSlotStatusChanged", $$robo$$com_android_internal_telephony_RadioConfig$unregisterForSimSlotStatusChanged(android.os.Handler ), 0, this, handler);
    }

    static ArrayList<IccSlotStatus> convertHalSlotStatus(ArrayList<SimSlotStatus> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("convertHalSlotStatus", $$robo$$com_android_internal_telephony_RadioConfig$convertHalSlotStatus(java.util.ArrayList<android.hardware.radio.config.V1_0.SimSlotStatus> ), 0, arrayList);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_RadioConfig$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_RadioConfig$loge(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ RadioConfig() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioConfig)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class ServiceDeathRecipient
    implements IHwBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RadioConfig this$0;

        private void $$robo$$com_android_internal_telephony_RadioConfig_ServiceDeathRecipient$__constructor__(RadioConfig this$0) {
        }

        private final void $$robo$$com_android_internal_telephony_RadioConfig_ServiceDeathRecipient$serviceDied(long cookie) {
            RadioConfig.logd("serviceDied");
            this.this$0.sendMessage(this.this$0.obtainMessage(1, cookie));
        }

        private void __constructor__(RadioConfig radioConfig) {
            this.$$robo$$com_android_internal_telephony_RadioConfig_ServiceDeathRecipient$__constructor__(radioConfig);
        }

        ServiceDeathRecipient(RadioConfig radioConfig) {
            this.this$0 = radioConfig;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RadioConfig_ServiceDeathRecipient$__constructor__(com.android.internal.telephony.RadioConfig ), 0, this, radioConfig);
        }

        @Override
        public void serviceDied(long l) {
            InvokeDynamicSupport.bootstrap("serviceDied", $$robo$$com_android_internal_telephony_RadioConfig_ServiceDeathRecipient$serviceDied(long ), 0, this, l);
        }

        public /* synthetic */ ServiceDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

