/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.Phone;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RatRatcheter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "RilRatcheter";
    private SparseArray<SparseIntArray> mRatFamilyMap;
    private Phone mPhone;
    private boolean mVoiceRatchetEnabled;
    private boolean mDataRatchetEnabled;
    private BroadcastReceiver mConfigChangedReceiver;

    private static final boolean $$robo$$com_android_internal_telephony_RatRatcheter$updateBandwidths(int[] bandwidths, ServiceState serviceState) {
        if (bandwidths == null) {
            return false;
        }
        int ssAggregateBandwidth = Arrays.stream(serviceState.getCellBandwidths()).sum();
        int newAggregateBandwidth = Arrays.stream(bandwidths).sum();
        if (newAggregateBandwidth > ssAggregateBandwidth) {
            serviceState.setCellBandwidths(bandwidths);
            return true;
        }
        return false;
    }

    private void $$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(Phone phone) {
        this.mRatFamilyMap = new SparseArray();
        this.mVoiceRatchetEnabled = true;
        this.mDataRatchetEnabled = true;
        this.mConfigChangedReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RatRatcheter this$0;

            private void $$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(RatRatcheter this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_RatRatcheter_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action)) {
                    this.this$0.resetRatFamilyMap();
                }
            }

            private void __constructor__(RatRatcheter ratRatcheter) {
                this.$$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(ratRatcheter);
            }
            {
                this.this$0 = ratRatcheter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RatRatcheter_1$__constructor__(com.android.internal.telephony.RatRatcheter ), 0, this, ratRatcheter);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_RatRatcheter_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mConfigChangedReceiver, UserHandle.ALL, intentFilter, null, null);
        this.resetRatFamilyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(int oldRat, int newRat) {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            int newRatRank;
            SparseIntArray oldFamily = this.mRatFamilyMap.get(oldRat);
            if (oldFamily == null) {
                return newRat;
            }
            SparseIntArray newFamily = this.mRatFamilyMap.get(newRat);
            if (newFamily != oldFamily) {
                return newRat;
            }
            int oldRatRank = newFamily.get(oldRat, -1);
            int n = oldRatRank > (newRatRank = newFamily.get(newRat, -1)) ? oldRat : newRat;
            return n;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RatRatcheter$ratchet(ServiceState oldSS, ServiceState newSS, boolean locationChange) {
        if (!locationChange && this.isSameRatFamily(oldSS, newSS)) {
            RatRatcheter.updateBandwidths(oldSS.getCellBandwidths(), newSS);
        }
        if (locationChange) {
            this.mVoiceRatchetEnabled = false;
            this.mDataRatchetEnabled = false;
            return;
        }
        if (this.mVoiceRatchetEnabled) {
            int newVoiceRat = this.ratchetRat(oldSS.getRilVoiceRadioTechnology(), newSS.getRilVoiceRadioTechnology());
            newSS.setRilVoiceRadioTechnology(newVoiceRat);
        } else if (oldSS.getRilVoiceRadioTechnology() != newSS.getRilVoiceRadioTechnology()) {
            this.mVoiceRatchetEnabled = true;
        }
        if (this.mDataRatchetEnabled) {
            int newDataRat = this.ratchetRat(oldSS.getRilDataRadioTechnology(), newSS.getRilDataRadioTechnology());
            newSS.setRilDataRadioTechnology(newDataRat);
        } else if (oldSS.getRilDataRadioTechnology() != newSS.getRilDataRadioTechnology()) {
            this.mDataRatchetEnabled = true;
        }
        boolean newUsingCA = oldSS.isUsingCarrierAggregation() || newSS.isUsingCarrierAggregation() || newSS.getCellBandwidths().length > 1;
        newSS.setIsUsingCarrierAggregation(newUsingCA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_RatRatcheter$isSameRatFamily(ServiceState ss1, ServiceState ss2) {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            if (ss1.getRilDataRadioTechnology() == ss2.getRilDataRadioTechnology()) {
                return true;
            }
            if (this.mRatFamilyMap.get(ss1.getRilDataRadioTechnology()) == null) {
                return false;
            }
            return this.mRatFamilyMap.get(ss1.getRilDataRadioTechnology()) == this.mRatFamilyMap.get(ss2.getRilDataRadioTechnology());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_RatRatcheter$resetRatFamilyMap() {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            this.mRatFamilyMap.clear();
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configManager == null) {
                return;
            }
            PersistableBundle b = configManager.getConfig();
            if (b == null) {
                return;
            }
            String[] ratFamilies = b.getStringArray("ratchet_rat_families");
            if (ratFamilies == null) {
                return;
            }
            block5: for (String ratFamily : ratFamilies) {
                String[] rats = ratFamily.split(",");
                if (rats.length < 2) continue;
                SparseIntArray currentFamily = new SparseIntArray(rats.length);
                int pos = 0;
                for (String ratString : rats) {
                    int ratInt;
                    try {
                        ratInt = Integer.parseInt(ratString.trim());
                    }
                    catch (NumberFormatException e) {
                        Rlog.e("RilRatcheter", "NumberFormatException on " + ratString);
                        continue block5;
                    }
                    if (this.mRatFamilyMap.get(ratInt) != null) {
                        Rlog.e("RilRatcheter", "RAT listed twice: " + ratString);
                        continue block5;
                    }
                    currentFamily.put(ratInt, pos++);
                    this.mRatFamilyMap.put(ratInt, currentFamily);
                }
            }
        }
    }

    public static boolean updateBandwidths(int[] nArray, ServiceState serviceState) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("updateBandwidths", $$robo$$com_android_internal_telephony_RatRatcheter$updateBandwidths(int[] android.telephony.ServiceState ), 0, (int[])nArray, (ServiceState)serviceState);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(phone);
    }

    public RatRatcheter(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RatRatcheter$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    private int ratchetRat(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("ratchetRat", $$robo$$com_android_internal_telephony_RatRatcheter$ratchetRat(int int ), 0, this, n, n2);
    }

    public void ratchet(ServiceState serviceState, ServiceState serviceState2, boolean bl) {
        InvokeDynamicSupport.bootstrap("ratchet", $$robo$$com_android_internal_telephony_RatRatcheter$ratchet(android.telephony.ServiceState android.telephony.ServiceState boolean ), 0, this, serviceState, serviceState2, bl);
    }

    private boolean isSameRatFamily(ServiceState serviceState, ServiceState serviceState2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameRatFamily", $$robo$$com_android_internal_telephony_RatRatcheter$isSameRatFamily(android.telephony.ServiceState android.telephony.ServiceState ), 0, this, serviceState, serviceState2);
    }

    private void resetRatFamilyMap() {
        InvokeDynamicSupport.bootstrap("resetRatFamilyMap", $$robo$$com_android_internal_telephony_RatRatcheter$resetRatFamilyMap(), 0, this);
    }

    public /* synthetic */ RatRatcheter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RatRatcheter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

