/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.provider.Telephony;
import android.service.carrier.ICarrierMessagingCallback;
import android.service.carrier.ICarrierMessagingService;
import android.telephony.CarrierMessagingServiceManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.EventLog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.AsyncEmergencyContactNotifier;
import com.android.internal.telephony.CarrierSmsUtils;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsDispatchersController;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.telephony.gsm.SmsMessage;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SMSDispatcher
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "SMSDispatcher";
    static boolean DBG = false;
    private static String SEND_NEXT_MSG_EXTRA = "SendNextMsg";
    protected static String MAP_KEY_PDU = "pdu";
    protected static String MAP_KEY_SMSC = "smsc";
    protected static String MAP_KEY_DEST_ADDR = "destAddr";
    protected static String MAP_KEY_SC_ADDR = "scAddr";
    protected static String MAP_KEY_DEST_PORT = "destPort";
    protected static String MAP_KEY_DATA = "data";
    protected static String MAP_KEY_TEXT = "text";
    private static int PREMIUM_RULE_USE_SIM = 1;
    private static int PREMIUM_RULE_USE_NETWORK = 2;
    private static int PREMIUM_RULE_USE_BOTH = 3;
    private AtomicInteger mPremiumSmsRule;
    private SettingsObserver mSettingsObserver;
    protected static int EVENT_SEND_SMS_COMPLETE = 2;
    private static int EVENT_SEND_RETRY = 3;
    private static int EVENT_SEND_LIMIT_REACHED_CONFIRMATION = 4;
    static int EVENT_SEND_CONFIRMED_SMS = 5;
    static int EVENT_STOP_SENDING = 7;
    private static int EVENT_CONFIRM_SEND_TO_POSSIBLE_PREMIUM_SHORT_CODE = 8;
    private static int EVENT_CONFIRM_SEND_TO_PREMIUM_SHORT_CODE = 9;
    protected static int EVENT_HANDLE_STATUS_REPORT = 10;
    protected static int EVENT_NEW_ICC_SMS = 14;
    protected static int EVENT_ICC_CHANGED = 15;
    protected static int EVENT_GET_IMS_SERVICE = 16;
    protected Phone mPhone;
    protected Context mContext;
    protected ContentResolver mResolver;
    protected CommandsInterface mCi;
    protected TelephonyManager mTelephonyManager;
    private static int MAX_SEND_RETRIES = 3;
    private static int SEND_RETRY_DELAY = 2000;
    private static int SINGLE_PART_SMS = 1;
    private static int MO_MSG_QUEUE_LIMIT = 5;
    private static int sConcatenatedRef;
    protected SmsDispatchersController mSmsDispatchersController;
    private int mPendingTrackerCount;
    protected boolean mSmsCapable;
    protected boolean mSmsSendDisabled;
    protected ArrayList<SmsTracker> deliveryPendingList;

    private static final int $$robo$$com_android_internal_telephony_SMSDispatcher$getNextConcatenatedRef() {
        return ++sConcatenatedRef;
    }

    private void $$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(Phone phone, SmsDispatchersController smsDispatchersController) {
        this.mPremiumSmsRule = new AtomicInteger(1);
        this.mSmsCapable = true;
        this.deliveryPendingList = new ArrayList();
        this.mPhone = phone;
        this.mSmsDispatchersController = smsDispatchersController;
        this.mContext = phone.getContext();
        this.mResolver = this.mContext.getContentResolver();
        this.mCi = phone.mCi;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mSettingsObserver = new SettingsObserver(this, this.mPremiumSmsRule, this.mContext);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("sms_short_code_rule"), false, this.mSettingsObserver);
        this.mSmsCapable = this.mContext.getResources().getBoolean(17957028);
        this.mSmsSendDisabled = !this.mTelephonyManager.getSmsSendCapableForPhone(this.mPhone.getPhoneId(), this.mSmsCapable);
        Rlog.d("SMSDispatcher", "SMSDispatcher: ctor mSmsCapable=" + this.mSmsCapable + " format=" + this.getFormat() + " mSmsSendDisabled=" + this.mSmsSendDisabled);
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$updatePhoneObject(Phone phone) {
        this.mPhone = phone;
        Rlog.d("SMSDispatcher", "Active phone changed to " + this.mPhone.getPhoneName());
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$dispose() {
        this.mContext.getContentResolver().unregisterContentObserver(this.mSettingsObserver);
    }

    protected abstract String getFormat();

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleStatusReport(Object o) {
        Rlog.d("SMSDispatcher", "handleStatusReport() called with no subclass.");
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                this.handleSendComplete((AsyncResult)msg.obj);
                break;
            }
            case 3: {
                Rlog.d("SMSDispatcher", "SMS retry..");
                this.sendRetrySms((SmsTracker)msg.obj);
                break;
            }
            case 4: {
                this.handleReachSentLimit((SmsTracker)msg.obj);
                break;
            }
            case 8: {
                this.handleConfirmShortCode(false, (SmsTracker)msg.obj);
                break;
            }
            case 9: {
                this.handleConfirmShortCode(true, (SmsTracker)msg.obj);
                break;
            }
            case 5: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (tracker.isMultipart()) {
                    this.sendMultipartSms(tracker);
                } else {
                    tracker.mExpectMore = this.mPendingTrackerCount > 1;
                    this.sendSms(tracker);
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 7: {
                SmsTracker tracker = (SmsTracker)msg.obj;
                if (msg.arg1 == 0) {
                    if (msg.arg2 == 1) {
                        tracker.onFailed(this.mContext, 8, 0);
                        Rlog.d("SMSDispatcher", "SMSDispatcher: EVENT_STOP_SENDING - sending SHORT_CODE_NEVER_ALLOWED error code.");
                    } else {
                        tracker.onFailed(this.mContext, 7, 0);
                        Rlog.d("SMSDispatcher", "SMSDispatcher: EVENT_STOP_SENDING - sending SHORT_CODE_NOT_ALLOWED error code.");
                    }
                } else if (msg.arg1 == 1) {
                    tracker.onFailed(this.mContext, 5, 0);
                    Rlog.d("SMSDispatcher", "SMSDispatcher: EVENT_STOP_SENDING - sending LIMIT_EXCEEDED error code.");
                } else {
                    Rlog.e("SMSDispatcher", "SMSDispatcher: EVENT_STOP_SENDING - unexpected cases.");
                }
                --this.mPendingTrackerCount;
                break;
            }
            case 10: {
                this.handleStatusReport(msg.obj);
                break;
            }
            default: {
                Rlog.e("SMSDispatcher", "handleMessage() ignoring message of unexpected type " + msg.what);
            }
        }
    }

    private static final int $$robo$$com_android_internal_telephony_SMSDispatcher$getSendSmsFlag(PendingIntent deliveryIntent) {
        if (deliveryIntent == null) {
            return 0;
        }
        return 1;
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$processSendSmsResponse(SmsTracker tracker, int result, int messageRef) {
        if (tracker == null) {
            Rlog.e("SMSDispatcher", "processSendSmsResponse: null tracker");
            return;
        }
        SmsResponse smsResponse = new SmsResponse(messageRef, null, -1);
        switch (result) {
            case 0: {
                Rlog.d("SMSDispatcher", "Sending SMS by IP succeeded.");
                this.sendMessage(this.obtainMessage(2, new AsyncResult(tracker, smsResponse, null)));
                break;
            }
            case 2: {
                Rlog.d("SMSDispatcher", "Sending SMS by IP failed.");
                this.sendMessage(this.obtainMessage(2, new AsyncResult(tracker, smsResponse, new CommandException(CommandException.Error.GENERIC_FAILURE))));
                break;
            }
            case 1: {
                Rlog.d("SMSDispatcher", "Sending SMS by IP failed. Retry on carrier network.");
                this.sendSubmitPdu(tracker);
                break;
            }
            default: {
                Rlog.d("SMSDispatcher", "Unknown result " + result + " Retry on carrier network.");
                this.sendSubmitPdu(tracker);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendSubmitPdu(SmsTracker tracker) {
        if (this.shouldBlockSmsForEcbm()) {
            Rlog.d("SMSDispatcher", "Block SMS in Emergency Callback mode");
            tracker.onFailed(this.mContext, 4, 0);
        } else {
            this.sendRawPdu(tracker);
        }
    }

    protected abstract boolean shouldBlockSmsForEcbm();

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleSendComplete(AsyncResult ar) {
        SmsTracker tracker = (SmsTracker)ar.userObj;
        PendingIntent sentIntent = tracker.mSentIntent;
        if (ar.result != null) {
            tracker.mMessageRef = ((SmsResponse)ar.result).mMessageRef;
        } else {
            Rlog.d("SMSDispatcher", "SmsResponse was null");
        }
        if (ar.exception == null) {
            if (tracker.mDeliveryIntent != null) {
                this.deliveryPendingList.add(tracker);
            }
            tracker.onSent(this.mContext);
        } else {
            int ss = this.mPhone.getServiceState().getState();
            if (tracker.mImsRetry > 0 && ss != 0) {
                tracker.mRetryCount = 3;
                Rlog.d("SMSDispatcher", "handleSendComplete: Skipping retry:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS= " + this.mPhone.getServiceState().getState());
            }
            if (!this.isIms() && ss != 0) {
                tracker.onFailed(this.mContext, SMSDispatcher.getNotInServiceError(ss), 0);
            } else if (((CommandException)ar.exception).getCommandError() == CommandException.Error.SMS_FAIL_RETRY && tracker.mRetryCount < 3) {
                ++tracker.mRetryCount;
                Message retryMsg = this.obtainMessage(3, tracker);
                this.sendMessageDelayed(retryMsg, 2000L);
            } else {
                int errorCode = 0;
                if (ar.result != null) {
                    errorCode = ((SmsResponse)ar.result).mErrorCode;
                }
                int error = 1;
                if (((CommandException)ar.exception).getCommandError() == CommandException.Error.FDN_CHECK_FAILURE) {
                    error = 6;
                }
                tracker.onFailed(this.mContext, error, errorCode);
            }
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleNotInService(int ss, PendingIntent sentIntent) {
        if (sentIntent != null) {
            try {
                if (ss == 3) {
                    sentIntent.send(2);
                } else {
                    sentIntent.send(4);
                }
            }
            catch (PendingIntent.CanceledException ex) {
                Rlog.e("SMSDispatcher", "Failed to send result");
            }
        }
    }

    private static final int $$robo$$com_android_internal_telephony_SMSDispatcher$getNotInServiceError(int ss) {
        if (ss == 3) {
            return 2;
        }
        return 4;
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessageBase.SubmitPduBase pdu = this.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, destPort, data, pdu);
            SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), null, false, null, false, true);
            if (!this.sendSmsByCarrierApp(true, tracker)) {
                this.sendSubmitPdu(tracker);
            }
        } else {
            Rlog.e("SMSDispatcher", "SMSDispatcher.sendData(): getSubmitPdu() returned null");
            this.triggerSentIntentForFailure(sentIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        Rlog.d("SMSDispatcher", "sendText");
        SmsMessageBase.SubmitPduBase pdu = this.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null, priority, validityPeriod);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, text, pdu);
            SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), messageUri, expectMore, text, true, persistMessage, priority, validityPeriod);
            if (!this.sendSmsByCarrierApp(false, tracker)) {
                this.sendSubmitPdu(tracker);
            }
        } else {
            Rlog.e("SMSDispatcher", "SmsDispatcher.sendText(): getSubmitPdu() returned null");
            this.triggerSentIntentForFailure(sentIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$triggerSentIntentForFailure(PendingIntent sentIntent) {
        if (sentIntent != null) {
            try {
                sentIntent.send(1);
            }
            catch (PendingIntent.CanceledException ex) {
                Rlog.e("SMSDispatcher", "Intent has been canceled!");
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$sendSmsByCarrierApp(boolean isDataSms, SmsTracker tracker) {
        String carrierPackage = this.getCarrierAppPackageName();
        if (carrierPackage != null) {
            Rlog.d("SMSDispatcher", "Found carrier package.");
            SmsSender smsSender = isDataSms ? new DataSmsSender(this, tracker) : new TextSmsSender(this, tracker);
            smsSender.sendSmsByCarrierApp(carrierPackage, new SmsSenderCallback(this, smsSender));
            return true;
        }
        return false;
    }

    protected abstract SmsMessageBase.SubmitPduBase getSubmitPdu(String var1, String var2, String var3, boolean var4, SmsHeader var5, int var6, int var7);

    protected abstract SmsMessageBase.SubmitPduBase getSubmitPdu(String var1, String var2, int var3, byte[] var4, boolean var5);

    protected abstract GsmAlphabet.TextEncodingDetails calculateLength(CharSequence var1, boolean var2);

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        String fullMessageText = this.getMultipartMessageText(parts);
        int refNumber = SMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        GsmAlphabet.TextEncodingDetails[] encodingForParts = new GsmAlphabet.TextEncodingDetails[msgCount];
        for (int i = 0; i < msgCount; ++i) {
            GsmAlphabet.TextEncodingDetails details = this.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        SmsTracker[] trackers = new SmsTracker[msgCount];
        AtomicInteger unsentPartCount = new AtomicInteger(msgCount);
        AtomicBoolean anyPartFailed = new AtomicBoolean(false);
        for (int i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            trackers[i] = this.getNewSubmitPduTracker(destAddr, scAddr, parts.get(i), smsHeader, encoding, sentIntent, deliveryIntent, i == msgCount - 1, unsentPartCount, anyPartFailed, messageUri, fullMessageText, priority, expectMore, validityPeriod);
            trackers[i].mPersistMessage = persistMessage;
        }
        if (parts == null || trackers == null || trackers.length == 0 || trackers[0] == null) {
            Rlog.e("SMSDispatcher", "Cannot send multipart text. parts=" + parts + " trackers=" + trackers);
            return;
        }
        String carrierPackage = this.getCarrierAppPackageName();
        if (carrierPackage != null) {
            Rlog.d("SMSDispatcher", "Found carrier package.");
            MultipartSmsSender smsSender = new MultipartSmsSender(this, parts, trackers);
            smsSender.sendSmsByCarrierApp(carrierPackage, new MultipartSmsSenderCallback(this, smsSender));
        } else {
            Rlog.v("SMSDispatcher", "No carrier package.");
            for (SmsTracker tracker : trackers) {
                if (tracker != null) {
                    this.sendSubmitPdu(tracker);
                    continue;
                }
                Rlog.e("SMSDispatcher", "Null tracker.");
            }
        }
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getNewSubmitPduTracker(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, String fullMessageText, int priority, boolean expectMore, int validityPeriod) {
        if (this.isCdmaMo()) {
            UserData uData = new UserData();
            uData.payloadStr = message;
            uData.userDataHeader = smsHeader;
            uData.msgEncoding = encoding == 1 ? 9 : 4;
            uData.msgEncodingSet = true;
            SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destinationAddress, uData, deliveryIntent != null && lastPart, priority);
            HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, submitPdu);
            return this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), unsentPartCount, anyPartFailed, messageUri, smsHeader, !lastPart || expectMore, fullMessageText, true, true, priority, validityPeriod);
        }
        SmsMessage.SubmitPdu pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, deliveryIntent != null, SmsHeader.toByteArray(smsHeader), encoding, smsHeader.languageTable, smsHeader.languageShiftTable, validityPeriod);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, pdu);
            return this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), unsentPartCount, anyPartFailed, messageUri, smsHeader, !lastPart || expectMore, fullMessageText, true, false, priority, validityPeriod);
        }
        Rlog.e("SMSDispatcher", "GsmSMSDispatcher.sendNewSubmitPdu(): getSubmitPdu() returned null");
        return null;
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendRawPdu(SmsTracker tracker) {
        PackageInfo appInfo;
        HashMap<String, Object> map = tracker.getData();
        byte[] pdu = (byte[])map.get("pdu");
        if (this.mSmsSendDisabled) {
            Rlog.e("SMSDispatcher", "Device does not support sending sms.");
            tracker.onFailed(this.mContext, 4, 0);
            return;
        }
        if (pdu == null) {
            Rlog.e("SMSDispatcher", "Empty PDU");
            tracker.onFailed(this.mContext, 3, 0);
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        if (packageNames == null || packageNames.length == 0) {
            Rlog.e("SMSDispatcher", "Can't get calling app package name: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        try {
            appInfo = pm.getPackageInfoAsUser(packageNames[0], 64, tracker.mUserId);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e("SMSDispatcher", "Can't get calling app package info: refusing to send SMS");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        if (this.checkDestination(tracker)) {
            if (!this.mSmsDispatchersController.getUsageMonitor().check(appInfo.packageName, 1)) {
                this.sendMessage(this.obtainMessage(4, tracker));
                return;
            }
            this.sendSms(tracker);
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(this.mContext, tracker.mDestAddress)) {
            new AsyncEmergencyContactNotifier(this.mContext).execute(new Void[0]);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$checkDestination(SmsTracker tracker) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.SEND_SMS_NO_CONFIRMATION") == 0) {
            return true;
        }
        int rule = this.mPremiumSmsRule.get();
        int smsCategory = 0;
        if (rule == 1 || rule == 3) {
            String simCountryIso = this.mTelephonyManager.getSimCountryIso();
            if (simCountryIso == null || simCountryIso.length() != 2) {
                Rlog.e("SMSDispatcher", "Can't get SIM country Iso: trying network country Iso");
                simCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            }
            smsCategory = this.mSmsDispatchersController.getUsageMonitor().checkDestination(tracker.mDestAddress, simCountryIso);
        }
        if (rule == 2 || rule == 3) {
            String networkCountryIso = this.mTelephonyManager.getNetworkCountryIso();
            if (networkCountryIso == null || networkCountryIso.length() != 2) {
                Rlog.e("SMSDispatcher", "Can't get Network country Iso: trying SIM country Iso");
                networkCountryIso = this.mTelephonyManager.getSimCountryIso();
            }
            smsCategory = SmsUsageMonitor.mergeShortCodeCategories(smsCategory, this.mSmsDispatchersController.getUsageMonitor().checkDestination(tracker.mDestAddress, networkCountryIso));
        }
        if (smsCategory == 0 || smsCategory == 1 || smsCategory == 2) {
            return true;
        }
        if (Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0) {
            Rlog.e("SMSDispatcher", "Can't send premium sms during Setup Wizard");
            return false;
        }
        int premiumSmsPermission = this.mSmsDispatchersController.getUsageMonitor().getPremiumSmsPermission(tracker.getAppPackageName());
        if (premiumSmsPermission == 0) {
            premiumSmsPermission = 1;
        }
        switch (premiumSmsPermission) {
            case 3: {
                Rlog.d("SMSDispatcher", "User approved this app to send to premium SMS");
                return true;
            }
            case 2: {
                Rlog.w("SMSDispatcher", "User denied this app from sending to premium SMS");
                Message msg = this.obtainMessage(7, tracker);
                msg.arg1 = 0;
                msg.arg2 = 1;
                this.sendMessage(msg);
                return false;
            }
        }
        int event = smsCategory == 3 ? 8 : 9;
        this.sendMessage(this.obtainMessage(event, tracker));
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$denyIfQueueLimitReached(SmsTracker tracker) {
        if (this.mPendingTrackerCount >= 5) {
            Rlog.e("SMSDispatcher", "Denied because queue limit reached");
            tracker.onFailed(this.mContext, 5, 0);
            return true;
        }
        ++this.mPendingTrackerCount;
        return false;
    }

    private final CharSequence $$robo$$com_android_internal_telephony_SMSDispatcher$getAppLabel(String appPackage, int userId) {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfoAsUser(appPackage, 0, userId);
            return appInfo.loadSafeLabel(pm);
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e("SMSDispatcher", "PackageManager Name Not Found for package " + appPackage);
            return appPackage;
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleReachSentLimit(SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        CharSequence appLabel = this.getAppLabel(tracker.getAppPackageName(), tracker.mUserId);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040887, appLabel));
        ConfirmDialogListener listener = new ConfirmDialogListener(this, tracker, null, 1);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setTitle(17040889).setIcon(17301642).setMessage(messageText).setPositiveButton(r.getString(17040890), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040888), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$handleConfirmShortCode(boolean isPremium, SmsTracker tracker) {
        if (this.denyIfQueueLimitReached(tracker)) {
            return;
        }
        int detailsId = isPremium ? 17040892 : 17040898;
        CharSequence appLabel = this.getAppLabel(tracker.getAppPackageName(), tracker.mUserId);
        Resources r = Resources.getSystem();
        Spanned messageText = Html.fromHtml(r.getString(17040896, appLabel, tracker.mDestAddress));
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View layout2 = inflater.inflate(17367290, null);
        ConfirmDialogListener listener = new ConfirmDialogListener(this, tracker, (TextView)layout2.findViewById(16909325), 0);
        TextView messageView = (TextView)layout2.findViewById(16909320);
        messageView.setText(messageText);
        ViewGroup detailsLayout = (ViewGroup)layout2.findViewById(16909321);
        TextView detailsView = (TextView)detailsLayout.findViewById(16909322);
        detailsView.setText(detailsId);
        CheckBox rememberChoice = (CheckBox)layout2.findViewById(16909323);
        rememberChoice.setOnCheckedChangeListener(listener);
        AlertDialog d = new AlertDialog.Builder(this.mContext).setView(layout2).setPositiveButton(r.getString(17040893), (DialogInterface.OnClickListener)listener).setNegativeButton(r.getString(17040895), (DialogInterface.OnClickListener)listener).setOnCancelListener(listener).create();
        d.getWindow().setType(2003);
        d.show();
        listener.setPositiveButton(d.getButton(-1));
        listener.setNegativeButton(d.getButton(-2));
    }

    protected abstract void sendSms(SmsTracker var1);

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendRetrySms(SmsTracker tracker) {
        if (this.mSmsDispatchersController != null) {
            this.mSmsDispatchersController.sendRetrySms(tracker);
        } else {
            Rlog.e("SMSDispatcher", this.mSmsDispatchersController + " is null. Retry failed");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartSms(SmsTracker tracker) {
        HashMap<String, Object> map = tracker.getData();
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            int count = parts.size();
            for (int i = 0; i < count; ++i) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i) {
                    sentIntent = (PendingIntent)sentIntents.get(i);
                }
                SMSDispatcher.handleNotInService(ss, sentIntent);
            }
            return;
        }
        this.sendMultipartText(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, null, null, tracker.mPersistMessage, tracker.mPriority, tracker.mExpectMore, tracker.mValidityPeriod);
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean expectMore, String fullMessageText, boolean isText, boolean persistMessage, int priority, int validityPeriod) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] packageNames = pm.getPackagesForUid(Binder.getCallingUid());
        int userId = UserHandle.getCallingUserId();
        PackageInfo appInfo = null;
        if (packageNames != null && packageNames.length > 0) {
            try {
                appInfo = pm.getPackageInfoAsUser(packageNames[0], 64, userId);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        String destAddr = PhoneNumberUtils.extractNetworkPortion((String)data.get("destAddr"));
        return new SmsTracker(data, sentIntent, deliveryIntent, appInfo, destAddr, format, unsentPartCount, anyPartFailed, messageUri, smsHeader, expectMore, fullMessageText, this.getSubId(), isText, persistMessage, userId, priority, validityPeriod);
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, Uri messageUri, boolean expectMore, String fullMessageText, boolean isText, boolean persistMessage) {
        return this.getSmsTracker(data, sentIntent, deliveryIntent, format, null, null, messageUri, null, expectMore, fullMessageText, isText, persistMessage, -1, -1);
    }

    private final SmsTracker $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, String format, Uri messageUri, boolean expectMore, String fullMessageText, boolean isText, boolean persistMessage, int priority, int validityPeriod) {
        return this.getSmsTracker(data, sentIntent, deliveryIntent, format, null, null, messageUri, null, expectMore, fullMessageText, isText, persistMessage, priority, validityPeriod);
    }

    private final HashMap<String, Object> $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(String destAddr, String scAddr, String text, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("text", text);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    private final HashMap<String, Object> $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(String destAddr, String scAddr, int destPort, byte[] data, SmsMessageBase.SubmitPduBase pdu) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destAddr", destAddr);
        map.put("scAddr", scAddr);
        map.put("destPort", destPort);
        map.put("data", data);
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        return map;
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$isIms() {
        if (this.mSmsDispatchersController != null) {
            return this.mSmsDispatchersController.isIms();
        }
        Rlog.e("SMSDispatcher", "mSmsDispatchersController  is null");
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_SMSDispatcher$getMultipartMessageText(ArrayList<String> parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part == null) continue;
            sb.append(part);
        }
        return sb.toString();
    }

    private final String $$robo$$com_android_internal_telephony_SMSDispatcher$getCarrierAppPackageName() {
        UiccCard card = UiccController.getInstance().getUiccCard(this.mPhone.getPhoneId());
        if (card == null) {
            return null;
        }
        List<String> carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), new Intent("android.service.carrier.CarrierMessagingService"));
        if (carrierPackages != null && carrierPackages.size() == 1) {
            return carrierPackages.get(0);
        }
        return CarrierSmsUtils.getCarrierImsPackageForIntent(this.mContext, this.mPhone, new Intent("android.service.carrier.CarrierMessagingService"));
    }

    private final int $$robo$$com_android_internal_telephony_SMSDispatcher$getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhone.getPhoneId());
    }

    private final void $$robo$$com_android_internal_telephony_SMSDispatcher$checkCallerIsPhoneOrCarrierApp() {
        int uid = Binder.getCallingUid();
        int appId = UserHandle.getAppId(uid);
        if (appId == 1001 || uid == 0) {
            return;
        }
        try {
            PackageManager pm = this.mContext.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(this.getCarrierAppPackageName(), 0);
            if (!UserHandle.isSameApp(ai.uid, Binder.getCallingUid())) {
                throw new SecurityException("Caller is not phone or carrier app!");
            }
        }
        catch (PackageManager.NameNotFoundException re) {
            throw new SecurityException("Caller is not phone or carrier app!");
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher$isCdmaMo() {
        return this.mSmsDispatchersController.isCdmaMo();
    }

    static void __staticInitializer__() {
        sConcatenatedRef = new Random().nextInt(256);
    }

    protected static int getNextConcatenatedRef() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNextConcatenatedRef", $$robo$$com_android_internal_telephony_SMSDispatcher$getNextConcatenatedRef(), 0);
    }

    private void __constructor__(Phone phone, SmsDispatchersController smsDispatchersController) {
        this.$$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(phone, smsDispatchersController);
    }

    protected SMSDispatcher(Phone phone, SmsDispatchersController smsDispatchersController) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsDispatchersController ), 0, this, phone, smsDispatchersController);
    }

    protected void updatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_SMSDispatcher$updatePhoneObject(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SMSDispatcher$dispose(), 0, this);
    }

    protected void handleStatusReport(Object object) {
        InvokeDynamicSupport.bootstrap("handleStatusReport", $$robo$$com_android_internal_telephony_SMSDispatcher$handleStatusReport(java.lang.Object ), 0, this, object);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SMSDispatcher$handleMessage(android.os.Message ), 0, this, message);
    }

    private static int getSendSmsFlag(PendingIntent pendingIntent) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSendSmsFlag", $$robo$$com_android_internal_telephony_SMSDispatcher$getSendSmsFlag(android.app.PendingIntent ), 0, (PendingIntent)pendingIntent);
    }

    private void processSendSmsResponse(SmsTracker smsTracker, int n, int n2) {
        InvokeDynamicSupport.bootstrap("processSendSmsResponse", $$robo$$com_android_internal_telephony_SMSDispatcher$processSendSmsResponse(com.android.internal.telephony.SMSDispatcher$SmsTracker int int ), 0, this, smsTracker, n, n2);
    }

    private void sendSubmitPdu(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSubmitPdu", $$robo$$com_android_internal_telephony_SMSDispatcher$sendSubmitPdu(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected void handleSendComplete(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleSendComplete", $$robo$$com_android_internal_telephony_SMSDispatcher$handleSendComplete(android.os.AsyncResult ), 0, this, asyncResult);
    }

    protected static void handleNotInService(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrapStatic("handleNotInService", $$robo$$com_android_internal_telephony_SMSDispatcher$handleNotInService(int android.app.PendingIntent ), 0, (int)n, (PendingIntent)pendingIntent);
    }

    protected static int getNotInServiceError(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNotInServiceError", $$robo$$com_android_internal_telephony_SMSDispatcher$getNotInServiceError(int ), 0, (int)n);
    }

    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_SMSDispatcher$sendData(java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2, Uri uri, String string5, boolean bl, int n, boolean bl2, int n2) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_SMSDispatcher$sendText(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent android.net.Uri java.lang.String boolean int boolean int ), 0, this, string2, string3, string4, pendingIntent, pendingIntent2, uri, string5, bl, n, bl2, n2);
    }

    private void triggerSentIntentForFailure(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("triggerSentIntentForFailure", $$robo$$com_android_internal_telephony_SMSDispatcher$triggerSentIntentForFailure(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    private boolean sendSmsByCarrierApp(boolean bl, SmsTracker smsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendSmsByCarrierApp", $$robo$$com_android_internal_telephony_SMSDispatcher$sendSmsByCarrierApp(boolean com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, bl, smsTracker);
    }

    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3, Uri uri, String string4, boolean bl, int n, boolean bl2, int n2) {
        InvokeDynamicSupport.bootstrap("sendMultipartText", $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartText(java.lang.String java.lang.String java.util.ArrayList<java.lang.String> java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> android.net.Uri java.lang.String boolean int boolean int ), 0, this, string2, string3, arrayList, arrayList2, arrayList3, uri, string4, bl, n, bl2, n2);
    }

    private SmsTracker getNewSubmitPduTracker(String string2, String string3, String string4, SmsHeader smsHeader, int n, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, String string5, int n2, boolean bl2, int n3) {
        return InvokeDynamicSupport.bootstrap("getNewSubmitPduTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getNewSubmitPduTracker(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsHeader int android.app.PendingIntent android.app.PendingIntent boolean java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri java.lang.String int boolean int ), 0, this, string2, string3, string4, smsHeader, n, pendingIntent, pendingIntent2, bl, atomicInteger, atomicBoolean, uri, string5, n2, bl2, n3);
    }

    public void sendRawPdu(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRawPdu", $$robo$$com_android_internal_telephony_SMSDispatcher$sendRawPdu(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    boolean checkDestination(SmsTracker smsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkDestination", $$robo$$com_android_internal_telephony_SMSDispatcher$checkDestination(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private boolean denyIfQueueLimitReached(SmsTracker smsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("denyIfQueueLimitReached", $$robo$$com_android_internal_telephony_SMSDispatcher$denyIfQueueLimitReached(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private CharSequence getAppLabel(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getAppLabel", $$robo$$com_android_internal_telephony_SMSDispatcher$getAppLabel(java.lang.String int ), 0, this, string2, n);
    }

    protected void handleReachSentLimit(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("handleReachSentLimit", $$robo$$com_android_internal_telephony_SMSDispatcher$handleReachSentLimit(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected void handleConfirmShortCode(boolean bl, SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("handleConfirmShortCode", $$robo$$com_android_internal_telephony_SMSDispatcher$handleConfirmShortCode(boolean com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, bl, smsTracker);
    }

    public void sendRetrySms(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRetrySms", $$robo$$com_android_internal_telephony_SMSDispatcher$sendRetrySms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    private void sendMultipartSms(SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendMultipartSms", $$robo$$com_android_internal_telephony_SMSDispatcher$sendMultipartSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string2, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl, String string3, boolean bl2, boolean bl3, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSmsTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent java.lang.String java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri com.android.internal.telephony.SmsHeader boolean java.lang.String boolean boolean int int ), 0, this, hashMap, pendingIntent, pendingIntent2, string2, atomicInteger, atomicBoolean, uri, smsHeader, bl, string3, bl2, bl3, n, n2);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string2, Uri uri, boolean bl, String string3, boolean bl2, boolean bl3) {
        return InvokeDynamicSupport.bootstrap("getSmsTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent java.lang.String android.net.Uri boolean java.lang.String boolean boolean ), 0, this, hashMap, pendingIntent, pendingIntent2, string2, uri, bl, string3, bl2, bl3);
    }

    protected SmsTracker getSmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string2, Uri uri, boolean bl, String string3, boolean bl2, boolean bl3, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getSmsTracker", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTracker(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent java.lang.String android.net.Uri boolean java.lang.String boolean boolean int int ), 0, this, hashMap, pendingIntent, pendingIntent2, string2, uri, bl, string3, bl2, bl3, n, n2);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String string2, String string3, String string4, SmsMessageBase.SubmitPduBase submitPduBase) {
        return InvokeDynamicSupport.bootstrap("getSmsTrackerMap", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsMessageBase$SubmitPduBase ), 0, this, string2, string3, string4, submitPduBase);
    }

    protected HashMap<String, Object> getSmsTrackerMap(String string2, String string3, int n, byte[] byArray, SmsMessageBase.SubmitPduBase submitPduBase) {
        return InvokeDynamicSupport.bootstrap("getSmsTrackerMap", $$robo$$com_android_internal_telephony_SMSDispatcher$getSmsTrackerMap(java.lang.String java.lang.String int byte[] com.android.internal.telephony.SmsMessageBase$SubmitPduBase ), 0, this, string2, string3, n, byArray, submitPduBase);
    }

    public boolean isIms() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIms", $$robo$$com_android_internal_telephony_SMSDispatcher$isIms(), 0, this);
    }

    private String getMultipartMessageText(ArrayList<String> arrayList) {
        return InvokeDynamicSupport.bootstrap("getMultipartMessageText", $$robo$$com_android_internal_telephony_SMSDispatcher$getMultipartMessageText(java.util.ArrayList<java.lang.String> ), 0, this, arrayList);
    }

    protected String getCarrierAppPackageName() {
        return InvokeDynamicSupport.bootstrap("getCarrierAppPackageName", $$robo$$com_android_internal_telephony_SMSDispatcher$getCarrierAppPackageName(), 0, this);
    }

    protected int getSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_SMSDispatcher$getSubId(), 0, this);
    }

    private void checkCallerIsPhoneOrCarrierApp() {
        InvokeDynamicSupport.bootstrap("checkCallerIsPhoneOrCarrierApp", $$robo$$com_android_internal_telephony_SMSDispatcher$checkCallerIsPhoneOrCarrierApp(), 0, this);
    }

    protected boolean isCdmaMo() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaMo", $$robo$$com_android_internal_telephony_SMSDispatcher$isCdmaMo(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SMSDispatcher.class);
    }

    public /* synthetic */ SMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ConfirmDialogListener
    implements DialogInterface.OnClickListener,
    DialogInterface.OnCancelListener,
    CompoundButton.OnCheckedChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SmsTracker mTracker;
        private Button mPositiveButton;
        private Button mNegativeButton;
        private boolean mRememberChoice;
        private TextView mRememberUndoInstruction;
        private int mConfirmationType;
        private static int SHORT_CODE_MSG = 0;
        private static int RATE_LIMIT = 1;
        private static int NEVER_ALLOW = 1;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(SMSDispatcher sMSDispatcher, SmsTracker tracker, TextView textView, int confirmationType) {
            this.mTracker = tracker;
            this.mRememberUndoInstruction = textView;
            this.mConfirmationType = confirmationType;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setPositiveButton(Button button) {
            this.mPositiveButton = button;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setNegativeButton(Button button) {
            this.mNegativeButton = button;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onClick(DialogInterface dialog, int which) {
            int newSmsPermission = 1;
            if (which == -1) {
                Rlog.d("SMSDispatcher", "CONFIRM sending SMS");
                EventLog.writeEvent(50128, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                this.this$0.sendMessage(this.this$0.obtainMessage(5, this.mTracker));
                if (this.mRememberChoice) {
                    newSmsPermission = 3;
                }
            } else if (which == -2) {
                Rlog.d("SMSDispatcher", "DENY sending SMS");
                EventLog.writeEvent(50125, this.mTracker.mAppInfo.applicationInfo == null ? -1 : this.mTracker.mAppInfo.applicationInfo.uid);
                Message msg = this.this$0.obtainMessage(7, this.mTracker);
                msg.arg1 = this.mConfirmationType;
                if (this.mRememberChoice) {
                    newSmsPermission = 2;
                    msg.arg2 = 1;
                }
                this.this$0.sendMessage(msg);
            }
            this.this$0.mSmsDispatchersController.setPremiumSmsPermission(this.mTracker.getAppPackageName(), newSmsPermission);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCancel(DialogInterface dialog) {
            Rlog.d("SMSDispatcher", "dialog dismissed: don't send SMS");
            Message msg = this.this$0.obtainMessage(7, this.mTracker);
            msg.arg1 = this.mConfirmationType;
            this.this$0.sendMessage(msg);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            Rlog.d("SMSDispatcher", "remember this choice: " + isChecked);
            this.mRememberChoice = isChecked;
            if (isChecked) {
                this.mPositiveButton.setText(17040894);
                this.mNegativeButton.setText(17040897);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText(17040900);
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 32);
                }
            } else {
                this.mPositiveButton.setText(17040893);
                this.mNegativeButton.setText(17040895);
                if (this.mRememberUndoInstruction != null) {
                    this.mRememberUndoInstruction.setText("");
                    this.mRememberUndoInstruction.setPadding(0, 0, 0, 0);
                }
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker, TextView textView, int n) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(sMSDispatcher, smsTracker, textView, n);
        }

        ConfirmDialogListener(SMSDispatcher sMSDispatcher, SmsTracker smsTracker, TextView textView, int n) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker android.widget.TextView int ), 0, this, sMSDispatcher, smsTracker, textView, n);
        }

        void setPositiveButton(Button button) {
            InvokeDynamicSupport.bootstrap("setPositiveButton", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setPositiveButton(android.widget.Button ), 0, this, button);
        }

        void setNegativeButton(Button button) {
            InvokeDynamicSupport.bootstrap("setNegativeButton", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$setNegativeButton(android.widget.Button ), 0, this, button);
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
        }

        @Override
        public void onCancel(DialogInterface dialogInterface) {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCancel(android.content.DialogInterface ), 0, this, dialogInterface);
        }

        @Override
        public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
            InvokeDynamicSupport.bootstrap("onCheckedChanged", $$robo$$com_android_internal_telephony_SMSDispatcher_ConfirmDialogListener$onCheckedChanged(android.widget.CompoundButton boolean ), 0, this, compoundButton, bl);
        }

        public /* synthetic */ ConfirmDialogListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfirmDialogListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SmsTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private HashMap<String, Object> mData;
        public int mRetryCount;
        public int mImsRetry;
        public boolean mUsesImsServiceForIms;
        public int mMessageRef;
        public boolean mExpectMore;
        public int mValidityPeriod;
        public int mPriority;
        String mFormat;
        public PendingIntent mSentIntent;
        public PendingIntent mDeliveryIntent;
        public PackageInfo mAppInfo;
        public String mDestAddress;
        public SmsHeader mSmsHeader;
        private long mTimestamp;
        public Uri mMessageUri;
        private AtomicInteger mUnsentPartCount;
        private AtomicBoolean mAnyPartFailed;
        private String mFullMessageText;
        private int mSubId;
        private boolean mIsText;
        private boolean mPersistMessage;
        private int mUserId;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(HashMap<String, Object> data, PendingIntent sentIntent, PendingIntent deliveryIntent, PackageInfo appInfo, String destAddr, String format, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, SmsHeader smsHeader, boolean expectMore, String fullMessageText, int subId, boolean isText, boolean persistMessage, int userId, int priority, int validityPeriod) {
            this.mTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            this.mData = data;
            this.mSentIntent = sentIntent;
            this.mDeliveryIntent = deliveryIntent;
            this.mRetryCount = 0;
            this.mAppInfo = appInfo;
            this.mDestAddress = destAddr;
            this.mFormat = format;
            this.mExpectMore = expectMore;
            this.mImsRetry = 0;
            this.mUsesImsServiceForIms = false;
            this.mMessageRef = 0;
            this.mUnsentPartCount = unsentPartCount;
            this.mAnyPartFailed = anyPartFailed;
            this.mMessageUri = messageUri;
            this.mSmsHeader = smsHeader;
            this.mFullMessageText = fullMessageText;
            this.mSubId = subId;
            this.mIsText = isText;
            this.mPersistMessage = persistMessage;
            this.mUserId = userId;
            this.mPriority = priority;
            this.mValidityPeriod = validityPeriod;
        }

        private final boolean $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$isMultipart() {
            return this.mData.containsKey("parts");
        }

        private final HashMap<String, Object> $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$getData() {
            return this.mData;
        }

        private final String $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$getAppPackageName() {
            return this.mAppInfo != null ? this.mAppInfo.packageName : null;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateSentMessageStatus(Context context, int status) {
            if (this.mMessageUri != null) {
                ContentValues values = new ContentValues(1);
                values.put("status", status);
                SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateMessageState(Context context, int messageType, int errorCode) {
            if (this.mMessageUri == null) {
                return;
            }
            ContentValues values = new ContentValues(2);
            values.put("type", messageType);
            values.put("error_code", errorCode);
            long identity = Binder.clearCallingIdentity();
            try {
                if (SqliteWrapper.update(context, context.getContentResolver(), this.mMessageUri, values, null, null) != 1) {
                    Rlog.e("SMSDispatcher", "Failed to move message to " + messageType);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Uri $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$persistSentMessageIfRequired(Context context, int messageType, int errorCode) {
            String creator;
            if (!(this.mIsText && this.mPersistMessage && SmsApplication.shouldWriteMessageForPackage(this.mAppInfo.packageName, context))) {
                return null;
            }
            Rlog.d("SMSDispatcher", "Persist SMS into " + (messageType == 5 ? "FAILED" : "SENT"));
            ContentValues values = new ContentValues();
            values.put("sub_id", this.mSubId);
            values.put("address", this.mDestAddress);
            values.put("body", this.mFullMessageText);
            values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
            values.put("seen", 1);
            values.put("read", 1);
            String string2 = creator = this.mAppInfo != null ? this.mAppInfo.packageName : null;
            if (!TextUtils.isEmpty(creator)) {
                values.put("creator", creator);
            }
            if (this.mDeliveryIntent != null) {
                values.put("status", 32);
            }
            if (errorCode != 0) {
                values.put("error_code", errorCode);
            }
            long identity = Binder.clearCallingIdentity();
            ContentResolver resolver = context.getContentResolver();
            try {
                Uri uri = resolver.insert(Telephony.Sms.Sent.CONTENT_URI, values);
                if (uri != null && messageType == 5) {
                    ContentValues updateValues = new ContentValues(1);
                    updateValues.put("type", 5);
                    resolver.update(uri, updateValues, null, null);
                }
                Uri uri2 = uri;
                return uri2;
            }
            catch (Exception e) {
                Rlog.e("SMSDispatcher", "writeOutboxMessage: Failed to persist outbox message", e);
                Uri uri = null;
                return uri;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$persistOrUpdateMessage(Context context, int messageType, int errorCode) {
            if (this.mMessageUri != null) {
                this.updateMessageState(context, messageType, errorCode);
            } else {
                this.mMessageUri = this.persistSentMessageIfRequired(context, messageType, errorCode);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onFailed(Context context, int error, int errorCode) {
            if (this.mAnyPartFailed != null) {
                this.mAnyPartFailed.set(true);
            }
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (isSinglePartOrLastPart) {
                this.persistOrUpdateMessage(context, 5, errorCode);
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (errorCode != 0) {
                        fillIn.putExtra("errorCode", errorCode);
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra("SendNextMsg", true);
                    }
                    this.mSentIntent.send(context, error, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("SMSDispatcher", "Failed to send result");
                }
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onSent(Context context) {
            boolean isSinglePartOrLastPart = true;
            if (this.mUnsentPartCount != null) {
                boolean bl = isSinglePartOrLastPart = this.mUnsentPartCount.decrementAndGet() == 0;
            }
            if (isSinglePartOrLastPart) {
                int messageType = 2;
                if (this.mAnyPartFailed != null && this.mAnyPartFailed.get()) {
                    messageType = 5;
                }
                this.persistOrUpdateMessage(context, messageType, 0);
            }
            if (this.mSentIntent != null) {
                try {
                    Intent fillIn = new Intent();
                    if (this.mMessageUri != null) {
                        fillIn.putExtra("uri", this.mMessageUri.toString());
                    }
                    if (this.mUnsentPartCount != null && isSinglePartOrLastPart) {
                        fillIn.putExtra("SendNextMsg", true);
                    }
                    this.mSentIntent.send(context, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("SMSDispatcher", "Failed to send result");
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(HashMap x0, PendingIntent x1, PendingIntent x2, PackageInfo x3, String x4, String x5, AtomicInteger x6, AtomicBoolean x7, Uri x8, SmsHeader x9, boolean x10, String x11, int x12, boolean x13, boolean x14, int x15, int x16, int x17, 1 x18) {
        }

        private void __constructor__(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl, String string4, int n, boolean bl2, boolean bl3, int n2, int n3, int n4) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl, string4, n, bl2, bl3, n2, n3, n4);
        }

        private SmsTracker(HashMap<String, Object> hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl, String string4, int n, boolean bl2, boolean bl3, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(java.util.HashMap<java.lang.String, java.lang.Object> android.app.PendingIntent android.app.PendingIntent android.content.pm.PackageInfo java.lang.String java.lang.String java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri com.android.internal.telephony.SmsHeader boolean java.lang.String int boolean boolean int int int ), 0, this, hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl, string4, n, bl2, bl3, n2, n3, n4);
        }

        boolean isMultipart() {
            return (boolean)InvokeDynamicSupport.bootstrap("isMultipart", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$isMultipart(), 0, this);
        }

        public HashMap<String, Object> getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$getData(), 0, this);
        }

        public String getAppPackageName() {
            return InvokeDynamicSupport.bootstrap("getAppPackageName", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$getAppPackageName(), 0, this);
        }

        public void updateSentMessageStatus(Context context, int n) {
            InvokeDynamicSupport.bootstrap("updateSentMessageStatus", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateSentMessageStatus(android.content.Context int ), 0, this, context, n);
        }

        private void updateMessageState(Context context, int n, int n2) {
            InvokeDynamicSupport.bootstrap("updateMessageState", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$updateMessageState(android.content.Context int int ), 0, this, context, n, n2);
        }

        private Uri persistSentMessageIfRequired(Context context, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("persistSentMessageIfRequired", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$persistSentMessageIfRequired(android.content.Context int int ), 0, this, context, n, n2);
        }

        private void persistOrUpdateMessage(Context context, int n, int n2) {
            InvokeDynamicSupport.bootstrap("persistOrUpdateMessage", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$persistOrUpdateMessage(android.content.Context int int ), 0, this, context, n, n2);
        }

        public void onFailed(Context context, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onFailed", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onFailed(android.content.Context int int ), 0, this, context, n, n2);
        }

        public void onSent(Context context) {
            InvokeDynamicSupport.bootstrap("onSent", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$onSent(android.content.Context ), 0, this, context);
        }

        private /* synthetic */ void __constructor__(HashMap hashMap, PendingIntent pendingIntent, PendingIntent pendingIntent2, PackageInfo packageInfo, String string2, String string3, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, SmsHeader smsHeader, boolean bl, String string4, int n, boolean bl2, boolean bl3, int n2, int n3, int n4, 1 var19_19) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsTracker$__constructor__(hashMap, pendingIntent, pendingIntent2, packageInfo, string2, string3, atomicInteger, atomicBoolean, uri, smsHeader, bl, string4, n, bl2, bl3, n2, n3, n4, var19_19);
        }

        public /* synthetic */ SmsTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MultipartSmsSenderCallback
    extends ICarrierMessagingCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MultipartSmsSender mSmsSender;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$__constructor__(SMSDispatcher sMSDispatcher, MultipartSmsSender smsSender) {
            this.mSmsSender = smsSender;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendSmsComplete(int result, int messageRef) {
            Rlog.e("SMSDispatcher", "Unexpected onSendSmsComplete call with result: " + result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendMultipartSmsComplete(int result, int[] messageRefs) {
            this.mSmsSender.disposeConnection(this.this$0.mContext);
            if (this.mSmsSender.mTrackers == null) {
                Rlog.e("SMSDispatcher", "Unexpected onSendMultipartSmsComplete call with null trackers.");
                return;
            }
            this.this$0.checkCallerIsPhoneOrCarrierApp();
            long identity = Binder.clearCallingIdentity();
            try {
                for (int i = 0; i < this.mSmsSender.mTrackers.length; ++i) {
                    int messageRef = 0;
                    if (messageRefs != null && messageRefs.length > i) {
                        messageRef = messageRefs[i];
                    }
                    this.this$0.processSendSmsResponse(this.mSmsSender.mTrackers[i], result, messageRef);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onFilterComplete(int result) {
            Rlog.e("SMSDispatcher", "Unexpected onFilterComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendMmsComplete(int result, byte[] sendConfPdu) {
            Rlog.e("SMSDispatcher", "Unexpected onSendMmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onDownloadMmsComplete(int result) {
            Rlog.e("SMSDispatcher", "Unexpected onDownloadMmsComplete call with result: " + result);
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, MultipartSmsSender multipartSmsSender) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$__constructor__(sMSDispatcher, multipartSmsSender);
        }

        MultipartSmsSenderCallback(SMSDispatcher sMSDispatcher, MultipartSmsSender multipartSmsSender) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$MultipartSmsSender ), 0, this, sMSDispatcher, multipartSmsSender);
        }

        @Override
        public void onSendSmsComplete(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSendSmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendSmsComplete(int int ), 0, this, n, n2);
        }

        @Override
        public void onSendMultipartSmsComplete(int n, int[] nArray) {
            InvokeDynamicSupport.bootstrap("onSendMultipartSmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendMultipartSmsComplete(int int[] ), 0, this, n, nArray);
        }

        @Override
        public void onFilterComplete(int n) {
            InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onFilterComplete(int ), 0, this, n);
        }

        @Override
        public void onSendMmsComplete(int n, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSendMmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onSendMmsComplete(int byte[] ), 0, this, n, byArray);
        }

        @Override
        public void onDownloadMmsComplete(int n) {
            InvokeDynamicSupport.bootstrap("onDownloadMmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSenderCallback$onDownloadMmsComplete(int ), 0, this, n);
        }

        public /* synthetic */ MultipartSmsSenderCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultipartSmsSenderCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MultipartSmsSender
    extends CarrierMessagingServiceManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<String> mParts;
        public SmsTracker[] mTrackers;
        private volatile MultipartSmsSenderCallback mSenderCallback;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$__constructor__(SMSDispatcher sMSDispatcher, ArrayList<String> parts, SmsTracker[] trackers) {
            this.mParts = parts;
            this.mTrackers = trackers;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$sendSmsByCarrierApp(String carrierPackageName, MultipartSmsSenderCallback senderCallback) {
            this.mSenderCallback = senderCallback;
            if (!this.bindToCarrierMessagingService(this.this$0.mContext, carrierPackageName)) {
                Rlog.e("SMSDispatcher", "bindService() for carrier messaging service failed");
                this.mSenderCallback.onSendMultipartSmsComplete(1, null);
            } else {
                Rlog.d("SMSDispatcher", "bindService() for carrier messaging service succeeded");
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$onServiceReady(ICarrierMessagingService carrierMessagingService) {
            try {
                carrierMessagingService.sendMultipartTextSms(this.mParts, this.this$0.getSubId(), this.mTrackers[0].mDestAddress, SMSDispatcher.getSendSmsFlag(this.mTrackers[0].mDeliveryIntent), this.mSenderCallback);
            }
            catch (RemoteException e) {
                Rlog.e("SMSDispatcher", "Exception sending the SMS: " + e);
                this.mSenderCallback.onSendMultipartSmsComplete(1, null);
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, ArrayList<String> arrayList, SmsTracker[] smsTrackerArray) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$__constructor__(sMSDispatcher, arrayList, smsTrackerArray);
        }

        MultipartSmsSender(SMSDispatcher sMSDispatcher, ArrayList<String> arrayList, SmsTracker[] smsTrackerArray) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$__constructor__(com.android.internal.telephony.SMSDispatcher java.util.ArrayList<java.lang.String> com.android.internal.telephony.SMSDispatcher$SmsTracker[] ), 0, this, sMSDispatcher, arrayList, smsTrackerArray);
        }

        void sendSmsByCarrierApp(String string2, MultipartSmsSenderCallback multipartSmsSenderCallback) {
            InvokeDynamicSupport.bootstrap("sendSmsByCarrierApp", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$sendSmsByCarrierApp(java.lang.String com.android.internal.telephony.SMSDispatcher$MultipartSmsSenderCallback ), 0, this, string2, multipartSmsSenderCallback);
        }

        @Override
        protected void onServiceReady(ICarrierMessagingService iCarrierMessagingService) {
            InvokeDynamicSupport.bootstrap("onServiceReady", $$robo$$com_android_internal_telephony_SMSDispatcher_MultipartSmsSender$onServiceReady(android.service.carrier.ICarrierMessagingService ), 0, this, iCarrierMessagingService);
        }

        public /* synthetic */ MultipartSmsSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultipartSmsSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    protected final class SmsSenderCallback
    extends ICarrierMessagingCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SmsSender mSmsSender;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$__constructor__(SMSDispatcher this$0, SmsSender smsSender) {
            this.mSmsSender = smsSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendSmsComplete(int result, int messageRef) {
            this.this$0.checkCallerIsPhoneOrCarrierApp();
            long identity = Binder.clearCallingIdentity();
            try {
                this.mSmsSender.disposeConnection(this.this$0.mContext);
                this.this$0.processSendSmsResponse(this.mSmsSender.mTracker, result, messageRef);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendMultipartSmsComplete(int result, int[] messageRefs) {
            Rlog.e("SMSDispatcher", "Unexpected onSendMultipartSmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onFilterComplete(int result) {
            Rlog.e("SMSDispatcher", "Unexpected onFilterComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendMmsComplete(int result, byte[] sendConfPdu) {
            Rlog.e("SMSDispatcher", "Unexpected onSendMmsComplete call with result: " + result);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onDownloadMmsComplete(int result) {
            Rlog.e("SMSDispatcher", "Unexpected onDownloadMmsComplete call with result: " + result);
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsSender smsSender) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$__constructor__(sMSDispatcher, smsSender);
        }

        public SmsSenderCallback(SMSDispatcher sMSDispatcher, SmsSender smsSender) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsSender ), 0, this, sMSDispatcher, smsSender);
        }

        @Override
        public void onSendSmsComplete(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSendSmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendSmsComplete(int int ), 0, this, n, n2);
        }

        @Override
        public void onSendMultipartSmsComplete(int n, int[] nArray) {
            InvokeDynamicSupport.bootstrap("onSendMultipartSmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendMultipartSmsComplete(int int[] ), 0, this, n, nArray);
        }

        @Override
        public void onFilterComplete(int n) {
            InvokeDynamicSupport.bootstrap("onFilterComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onFilterComplete(int ), 0, this, n);
        }

        @Override
        public void onSendMmsComplete(int n, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("onSendMmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onSendMmsComplete(int byte[] ), 0, this, n, byArray);
        }

        @Override
        public void onDownloadMmsComplete(int n) {
            InvokeDynamicSupport.bootstrap("onDownloadMmsComplete", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSenderCallback$onDownloadMmsComplete(int ), 0, this, n);
        }

        public /* synthetic */ SmsSenderCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsSenderCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    protected final class DataSmsSender
    extends SmsSender
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_DataSmsSender$__constructor__(SMSDispatcher this$0, SmsTracker tracker) {
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_DataSmsSender$onServiceReady(ICarrierMessagingService carrierMessagingService) {
            HashMap<String, Object> map = this.mTracker.getData();
            byte[] data = (byte[])map.get("data");
            int destPort = (Integer)map.get("destPort");
            if (data != null) {
                try {
                    carrierMessagingService.sendDataSms(data, this.this$0.getSubId(), this.mTracker.mDestAddress, destPort, SMSDispatcher.getSendSmsFlag(this.mTracker.mDeliveryIntent), this.mSenderCallback);
                }
                catch (RemoteException e) {
                    Rlog.e("SMSDispatcher", "Exception sending the SMS: " + e);
                    this.mSenderCallback.onSendSmsComplete(1, 0);
                }
            } else {
                this.mSenderCallback.onSendSmsComplete(1, 0);
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_DataSmsSender$__constructor__(sMSDispatcher, smsTracker);
        }

        public DataSmsSender(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.this$0 = sMSDispatcher;
            super(sMSDispatcher, smsTracker);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_DataSmsSender$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, sMSDispatcher, smsTracker);
        }

        @Override
        protected void onServiceReady(ICarrierMessagingService iCarrierMessagingService) {
            InvokeDynamicSupport.bootstrap("onServiceReady", $$robo$$com_android_internal_telephony_SMSDispatcher_DataSmsSender$onServiceReady(android.service.carrier.ICarrierMessagingService ), 0, this, iCarrierMessagingService);
        }

        public /* synthetic */ DataSmsSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataSmsSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    protected final class TextSmsSender
    extends SmsSender
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_TextSmsSender$__constructor__(SMSDispatcher this$0, SmsTracker tracker) {
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_TextSmsSender$onServiceReady(ICarrierMessagingService carrierMessagingService) {
            HashMap<String, Object> map = this.mTracker.getData();
            String text = (String)map.get("text");
            if (text != null) {
                try {
                    carrierMessagingService.sendTextSms(text, this.this$0.getSubId(), this.mTracker.mDestAddress, SMSDispatcher.getSendSmsFlag(this.mTracker.mDeliveryIntent), this.mSenderCallback);
                }
                catch (RemoteException e) {
                    Rlog.e("SMSDispatcher", "Exception sending the SMS: " + e);
                    this.mSenderCallback.onSendSmsComplete(1, 0);
                }
            } else {
                this.mSenderCallback.onSendSmsComplete(1, 0);
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_TextSmsSender$__constructor__(sMSDispatcher, smsTracker);
        }

        public TextSmsSender(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.this$0 = sMSDispatcher;
            super(sMSDispatcher, smsTracker);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_TextSmsSender$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, sMSDispatcher, smsTracker);
        }

        @Override
        protected void onServiceReady(ICarrierMessagingService iCarrierMessagingService) {
            InvokeDynamicSupport.bootstrap("onServiceReady", $$robo$$com_android_internal_telephony_SMSDispatcher_TextSmsSender$onServiceReady(android.service.carrier.ICarrierMessagingService ), 0, this, iCarrierMessagingService);
        }

        public /* synthetic */ TextSmsSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextSmsSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected abstract class SmsSender
    extends CarrierMessagingServiceManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected SmsTracker mTracker;
        protected volatile SmsSenderCallback mSenderCallback;
        /* synthetic */ SMSDispatcher this$0;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSender$__constructor__(SMSDispatcher this$0, SmsTracker tracker) {
            this.mTracker = tracker;
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSender$sendSmsByCarrierApp(String carrierPackageName, SmsSenderCallback senderCallback) {
            this.mSenderCallback = senderCallback;
            if (!this.bindToCarrierMessagingService(this.this$0.mContext, carrierPackageName)) {
                Rlog.e("SMSDispatcher", "bindService() for carrier messaging service failed");
                this.mSenderCallback.onSendSmsComplete(1, 0);
            } else {
                Rlog.d("SMSDispatcher", "bindService() for carrier messaging service succeeded");
            }
        }

        private void __constructor__(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SmsSender$__constructor__(sMSDispatcher, smsTracker);
        }

        protected SmsSender(SMSDispatcher sMSDispatcher, SmsTracker smsTracker) {
            this.this$0 = sMSDispatcher;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSender$__constructor__(com.android.internal.telephony.SMSDispatcher com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, sMSDispatcher, smsTracker);
        }

        public void sendSmsByCarrierApp(String string2, SmsSenderCallback smsSenderCallback) {
            InvokeDynamicSupport.bootstrap("sendSmsByCarrierApp", $$robo$$com_android_internal_telephony_SMSDispatcher_SmsSender$sendSmsByCarrierApp(java.lang.String com.android.internal.telephony.SMSDispatcher$SmsSenderCallback ), 0, this, string2, smsSenderCallback);
        }

        public /* synthetic */ SmsSender() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsSender)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AtomicInteger mPremiumSmsRule;
        private Context mContext;

        private void $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(Handler handler, AtomicInteger premiumSmsRule, Context context) {
            this.mPremiumSmsRule = premiumSmsRule;
            this.mContext = context;
            this.onChange(false);
        }

        private final void $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$onChange(boolean selfChange) {
            this.mPremiumSmsRule.set(Settings.Global.getInt(this.mContext.getContentResolver(), "sms_short_code_rule", 1));
        }

        private void __constructor__(Handler handler, AtomicInteger atomicInteger, Context context) {
            this.$$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(handler, atomicInteger, context);
        }

        SettingsObserver(Handler handler, AtomicInteger atomicInteger, Context context) {
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$__constructor__(android.os.Handler java.util.concurrent.atomic.AtomicInteger android.content.Context ), 0, this, handler, atomicInteger, context);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_SMSDispatcher_SettingsObserver$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

