/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.SQLException;
import android.os.PersistableBundle;
import android.os.UserManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsBroadcastUndelivered
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SmsBroadcastUndelivered";
    private static boolean DBG = true;
    static long DEFAULT_PARTIAL_SEGMENT_EXPIRE_AGE = 2592000000L;
    private static String[] PDU_PENDING_MESSAGE_PROJECTION;
    private static SmsBroadcastUndelivered instance;
    private ContentResolver mResolver;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private CdmaInboundSmsHandler mCdmaInboundSmsHandler;
    private BroadcastReceiver mBroadcastReceiver;

    private static final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$initialize(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        if (instance == null) {
            instance = new SmsBroadcastUndelivered(context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
        }
        if (gsmInboundSmsHandler != null) {
            gsmInboundSmsHandler.sendMessage(6);
        }
        if (cdmaInboundSmsHandler != null) {
            cdmaInboundSmsHandler.sendMessage(6);
        }
    }

    private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SmsBroadcastUndelivered this$0;

            private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_1$__constructor__(SmsBroadcastUndelivered this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_1$onReceive(Context context, Intent intent) {
                Rlog.d("SmsBroadcastUndelivered", "Received broadcast " + intent.getAction());
                if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                    new ScanRawTableThread(this.this$0, context).start();
                }
            }

            private void __constructor__(SmsBroadcastUndelivered smsBroadcastUndelivered) {
                this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_1$__constructor__(smsBroadcastUndelivered);
            }
            {
                this.this$0 = smsBroadcastUndelivered;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_1$__constructor__(com.android.internal.telephony.SmsBroadcastUndelivered ), 0, this, smsBroadcastUndelivered);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mResolver = context.getContentResolver();
        this.mGsmInboundSmsHandler = gsmInboundSmsHandler;
        this.mCdmaInboundSmsHandler = cdmaInboundSmsHandler;
        UserManager userManager = (UserManager)context.getSystemService("user");
        if (userManager.isUserUnlocked()) {
            new ScanRawTableThread(this, context).start();
        } else {
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_UNLOCKED");
            context.registerReceiver(this.mBroadcastReceiver, userFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$scanRawTable(Context context) {
        Rlog.d("SmsBroadcastUndelivered", "scanning raw table for undelivered messages");
        CallSite startTime = InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        HashMap<SmsReferenceKey, Integer> multiPartReceivedCount = new HashMap<SmsReferenceKey, Integer>(4);
        HashSet<SmsReferenceKey> oldMultiPartMessages = new HashSet<SmsReferenceKey>(4);
        Cursor cursor = null;
        try {
            cursor = this.mResolver.query(InboundSmsHandler.sRawUri, PDU_PENDING_MESSAGE_PROJECTION, "deleted = 0", null, null);
            if (cursor == null) {
                Rlog.e("SmsBroadcastUndelivered", "error getting pending message cursor");
                return;
            }
            boolean isCurrentFormat3gpp2 = InboundSmsHandler.isCurrentFormat3gpp2();
            while (cursor.moveToNext()) {
                InboundSmsTracker tracker;
                try {
                    tracker = TelephonyComponentFactory.getInstance().makeInboundSmsTracker(cursor, isCurrentFormat3gpp2);
                }
                catch (IllegalArgumentException e) {
                    Rlog.e("SmsBroadcastUndelivered", "error loading SmsTracker: " + e);
                    continue;
                }
                if (tracker.getMessageCount() == 1) {
                    this.broadcastSms(tracker);
                    continue;
                }
                SmsReferenceKey reference = new SmsReferenceKey(tracker);
                Integer receivedCount = (Integer)multiPartReceivedCount.get(reference);
                if (receivedCount == null) {
                    multiPartReceivedCount.put(reference, 1);
                    long expirationTime = this.getUndeliveredSmsExpirationTime(context);
                    if (tracker.getTimestamp() >= InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - expirationTime) continue;
                    oldMultiPartMessages.add(reference);
                    continue;
                }
                int newCount = receivedCount + 1;
                if (newCount == tracker.getMessageCount()) {
                    Rlog.d("SmsBroadcastUndelivered", "found complete multi-part message");
                    this.broadcastSms(tracker);
                    oldMultiPartMessages.remove(reference);
                    continue;
                }
                multiPartReceivedCount.put(reference, newCount);
            }
            for (SmsReferenceKey message : oldMultiPartMessages) {
                int rows = this.mResolver.delete(InboundSmsHandler.sRawUriPermanentDelete, message.getDeleteWhere(), message.getDeleteWhereArgs());
                if (rows == 0) {
                    Rlog.e("SmsBroadcastUndelivered", "No rows were deleted from raw table!");
                    continue;
                }
                Rlog.d("SmsBroadcastUndelivered", "Deleted " + rows + " rows from raw table for incomplete " + message.mMessageCount + " part message");
            }
        }
        catch (SQLException e) {
            Rlog.e("SmsBroadcastUndelivered", "error reading pending SMS messages", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Rlog.d("SmsBroadcastUndelivered", "finished scanning raw table in " + (long)((InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - startTime) / 1000000L) + " ms");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$broadcastSms(InboundSmsTracker tracker) {
        InboundSmsHandler handler = tracker.is3gpp2() ? this.mCdmaInboundSmsHandler : this.mGsmInboundSmsHandler;
        if (handler != null) {
            handler.sendMessage(2, tracker);
        } else {
            Rlog.e("SmsBroadcastUndelivered", "null handler for " + tracker.getFormat() + " format, can't deliver.");
        }
    }

    private final long $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$getUndeliveredSmsExpirationTime(Context context) {
        int subId = SubscriptionManager.getDefaultSmsSubscriptionId();
        CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        PersistableBundle bundle = configManager.getConfigForSubId(subId);
        if (bundle != null) {
            return bundle.getLong("undelivered_sms_message_expiration_time", 2592000000L);
        }
        return 2592000000L;
    }

    static void __staticInitializer__() {
        PDU_PENDING_MESSAGE_PROJECTION = new String[]{"pdu", "sequence", "destination_port", "date", "reference_number", "count", "address", "_id", "message_body", "display_originating_addr"};
    }

    public static void initialize(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        InvokeDynamicSupport.bootstrapStatic("initialize", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$initialize(android.content.Context com.android.internal.telephony.gsm.GsmInboundSmsHandler com.android.internal.telephony.cdma.CdmaInboundSmsHandler ), 0, (Context)context, (GsmInboundSmsHandler)gsmInboundSmsHandler, (CdmaInboundSmsHandler)cdmaInboundSmsHandler);
    }

    private void __constructor__(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
    }

    private SmsBroadcastUndelivered(Context context, GsmInboundSmsHandler gsmInboundSmsHandler, CdmaInboundSmsHandler cdmaInboundSmsHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$__constructor__(android.content.Context com.android.internal.telephony.gsm.GsmInboundSmsHandler com.android.internal.telephony.cdma.CdmaInboundSmsHandler ), 0, this, context, gsmInboundSmsHandler, cdmaInboundSmsHandler);
    }

    private void scanRawTable(Context context) {
        InvokeDynamicSupport.bootstrap("scanRawTable", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$scanRawTable(android.content.Context ), 0, this, context);
    }

    private void broadcastSms(InboundSmsTracker inboundSmsTracker) {
        InvokeDynamicSupport.bootstrap("broadcastSms", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$broadcastSms(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
    }

    private long getUndeliveredSmsExpirationTime(Context context) {
        return (long)InvokeDynamicSupport.bootstrap("getUndeliveredSmsExpirationTime", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered$getUndeliveredSmsExpirationTime(android.content.Context ), 0, this, context);
    }

    static {
        RobolectricInternals.classInitializing(SmsBroadcastUndelivered.class);
    }

    public /* synthetic */ SmsBroadcastUndelivered() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsBroadcastUndelivered)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SmsReferenceKey
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mAddress;
        int mReferenceNumber;
        int mMessageCount;
        String mQuery;

        private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(InboundSmsTracker tracker) {
            this.mAddress = tracker.getAddress();
            this.mReferenceNumber = tracker.getReferenceNumber();
            this.mMessageCount = tracker.getMessageCount();
            this.mQuery = tracker.getQueryForSegments();
        }

        private final String[] $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhereArgs() {
            return new String[]{this.mAddress, Integer.toString(this.mReferenceNumber), Integer.toString(this.mMessageCount)};
        }

        private final String $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhere() {
            return this.mQuery;
        }

        private final int $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$hashCode() {
            return (this.mReferenceNumber * 31 + this.mMessageCount) * 31 + this.mAddress.hashCode();
        }

        private final boolean $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$equals(Object o) {
            if (o instanceof SmsReferenceKey) {
                SmsReferenceKey other = (SmsReferenceKey)o;
                return other.mAddress.equals(this.mAddress) && other.mReferenceNumber == this.mReferenceNumber && other.mMessageCount == this.mMessageCount;
            }
            return false;
        }

        private void __constructor__(InboundSmsTracker inboundSmsTracker) {
            this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(inboundSmsTracker);
        }

        SmsReferenceKey(InboundSmsTracker inboundSmsTracker) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$__constructor__(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
        }

        String[] getDeleteWhereArgs() {
            return InvokeDynamicSupport.bootstrap("getDeleteWhereArgs", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhereArgs(), 0, this);
        }

        String getDeleteWhere() {
            return InvokeDynamicSupport.bootstrap("getDeleteWhere", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$getDeleteWhere(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_SmsReferenceKey$equals(java.lang.Object ), 0, this, object);
        }

        public /* synthetic */ SmsReferenceKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsReferenceKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ScanRawTableThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context context;
        /* synthetic */ SmsBroadcastUndelivered this$0;

        private void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$__constructor__(SmsBroadcastUndelivered smsBroadcastUndelivered, Context context) {
            this.context = context;
        }

        private final void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$run() {
            this.this$0.scanRawTable(this.context);
            InboundSmsHandler.cancelNewMessageNotification(this.context);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$__constructor__(SmsBroadcastUndelivered x0, Context x1, 1 x2) {
        }

        private void __constructor__(SmsBroadcastUndelivered smsBroadcastUndelivered, Context context) {
            this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$__constructor__(smsBroadcastUndelivered, context);
        }

        private ScanRawTableThread(SmsBroadcastUndelivered smsBroadcastUndelivered, Context context) {
            this.this$0 = smsBroadcastUndelivered;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$__constructor__(com.android.internal.telephony.SmsBroadcastUndelivered android.content.Context ), 0, this, smsBroadcastUndelivered, context);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(SmsBroadcastUndelivered smsBroadcastUndelivered, Context context, 1 var3_3) {
            this.$$robo$$com_android_internal_telephony_SmsBroadcastUndelivered_ScanRawTableThread$__constructor__(smsBroadcastUndelivered, context, var3_3);
        }

        public /* synthetic */ ScanRawTableThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanRawTableThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

