/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ImsSmsDispatcher;
import com.android.internal.telephony.InboundSmsHandler;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsBroadcastUndelivered;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsDispatchersController
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SmsDispatchersController";
    private static int EVENT_RADIO_ON = 11;
    private static int EVENT_IMS_STATE_CHANGED = 12;
    private static int EVENT_IMS_STATE_DONE = 13;
    private SMSDispatcher mCdmaDispatcher;
    private SMSDispatcher mGsmDispatcher;
    private ImsSmsDispatcher mImsSmsDispatcher;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private CdmaInboundSmsHandler mCdmaInboundSmsHandler;
    private Phone mPhone;
    private SmsUsageMonitor mUsageMonitor;
    private CommandsInterface mCi;
    private Context mContext;
    private boolean mIms;
    private String mImsSmsFormat;

    private void $$robo$$com_android_internal_telephony_SmsDispatchersController$__constructor__(Phone phone, SmsStorageMonitor storageMonitor, SmsUsageMonitor usageMonitor) {
        this.mIms = false;
        this.mImsSmsFormat = "unknown";
        Rlog.d("SmsDispatchersController", "SmsDispatchersController created");
        this.mContext = phone.getContext();
        this.mUsageMonitor = usageMonitor;
        this.mCi = phone.mCi;
        this.mPhone = phone;
        this.mImsSmsDispatcher = new ImsSmsDispatcher(phone, this);
        this.mCdmaDispatcher = new CdmaSMSDispatcher(phone, this);
        this.mGsmInboundSmsHandler = GsmInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone);
        this.mCdmaInboundSmsHandler = CdmaInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone, (CdmaSMSDispatcher)this.mCdmaDispatcher);
        this.mGsmDispatcher = new GsmSMSDispatcher(phone, this, this.mGsmInboundSmsHandler);
        SmsBroadcastUndelivered.initialize(phone.getContext(), this.mGsmInboundSmsHandler, this.mCdmaInboundSmsHandler);
        InboundSmsHandler.registerNewMessageNotificationActionHandler(phone.getContext());
        this.mCi.registerForOn(this, 11, null);
        this.mCi.registerForImsNetworkStateChanged(this, 12, null);
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$updatePhoneObject(Phone phone) {
        Rlog.d("SmsDispatchersController", "In IMS updatePhoneObject ");
        this.mCdmaDispatcher.updatePhoneObject(phone);
        this.mGsmDispatcher.updatePhoneObject(phone);
        this.mGsmInboundSmsHandler.updatePhoneObject(phone);
        this.mCdmaInboundSmsHandler.updatePhoneObject(phone);
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$dispose() {
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForImsNetworkStateChanged(this);
        this.mGsmDispatcher.dispose();
        this.mCdmaDispatcher.dispose();
        this.mGsmInboundSmsHandler.dispose();
        this.mCdmaInboundSmsHandler.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$handleMessage(Message msg) {
        switch (msg.what) {
            case 11: 
            case 12: {
                this.mCi.getImsRegistrationState(this.obtainMessage(13));
                break;
            }
            case 13: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.updateImsInfo(ar);
                    break;
                }
                Rlog.e("SmsDispatchersController", "IMS State query failed with exp " + ar.exception);
                break;
            }
            default: {
                if (this.isCdmaMo()) {
                    this.mCdmaDispatcher.handleMessage(msg);
                    break;
                }
                this.mGsmDispatcher.handleMessage(msg);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$setImsSmsFormat(int format) {
        switch (format) {
            case 1: {
                this.mImsSmsFormat = "3gpp";
                break;
            }
            case 2: {
                this.mImsSmsFormat = "3gpp2";
                break;
            }
            default: {
                this.mImsSmsFormat = "unknown";
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$updateImsInfo(AsyncResult ar) {
        int[] responseArray = (int[])ar.result;
        this.setImsSmsFormat(responseArray[1]);
        this.mIms = responseArray[0] == 1 && !"unknown".equals(this.mImsSmsFormat);
        Rlog.d("SmsDispatchersController", "IMS registration state: " + this.mIms + " format: " + this.mImsSmsFormat);
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$injectSmsPdu(byte[] pdu, String format, SmsInjectionCallback callback) {
        android.telephony.SmsMessage msg = android.telephony.SmsMessage.createFromPdu(pdu, format);
        this.injectSmsPdu(msg, format, callback, false);
    }

    @VisibleForTesting
    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$injectSmsPdu(android.telephony.SmsMessage msg, String format, SmsInjectionCallback callback, boolean ignoreClass) {
        Rlog.d("SmsDispatchersController", "SmsDispatchersController:injectSmsPdu");
        try {
            if (msg == null) {
                Rlog.e("SmsDispatchersController", "injectSmsPdu: createFromPdu returned null");
                callback.onSmsInjectedResult(2);
                return;
            }
            if (!ignoreClass && msg.getMessageClass() != SmsMessage.MessageClass.CLASS_1) {
                Rlog.e("SmsDispatchersController", "injectSmsPdu: not class 1");
                callback.onSmsInjectedResult(2);
                return;
            }
            AsyncResult ar = new AsyncResult(callback, msg, null);
            if (format.equals("3gpp")) {
                Rlog.i("SmsDispatchersController", "SmsDispatchersController:injectSmsText Sending msg=" + msg + ", format=" + format + "to mGsmInboundSmsHandler");
                this.mGsmInboundSmsHandler.sendMessage(8, ar);
            } else if (format.equals("3gpp2")) {
                Rlog.i("SmsDispatchersController", "SmsDispatchersController:injectSmsText Sending msg=" + msg + ", format=" + format + "to mCdmaInboundSmsHandler");
                this.mCdmaInboundSmsHandler.sendMessage(8, ar);
            } else {
                Rlog.e("SmsDispatchersController", "Invalid pdu format: " + format);
                callback.onSmsInjectedResult(2);
            }
        }
        catch (Exception e) {
            Rlog.e("SmsDispatchersController", "injectSmsPdu failed: ", e);
            callback.onSmsInjectedResult(2);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$sendRetrySms(SMSDispatcher.SmsTracker tracker) {
        String newFormat;
        String oldFormat = tracker.mFormat;
        String string2 = newFormat = 2 == this.mPhone.getPhoneType() ? this.mCdmaDispatcher.getFormat() : this.mGsmDispatcher.getFormat();
        if (oldFormat.equals(newFormat)) {
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("SmsDispatchersController", "old format matched new format (cdma)");
                this.mCdmaDispatcher.sendSms(tracker);
                return;
            }
            Rlog.d("SmsDispatchersController", "old format matched new format (gsm)");
            this.mGsmDispatcher.sendSms(tracker);
            return;
        }
        HashMap<String, Object> map = tracker.getData();
        if (!(map.containsKey("scAddr") && map.containsKey("destAddr") && (map.containsKey("text") || map.containsKey("data") && map.containsKey("destPort")))) {
            Rlog.e("SmsDispatchersController", "sendRetrySms failed to re-encode per missing fields!");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        String scAddr = (String)map.get("scAddr");
        String destAddr = (String)map.get("destAddr");
        SmsMessageBase.SubmitPduBase pdu = null;
        if (map.containsKey("text")) {
            Rlog.d("SmsDispatchersController", "sms failed was text");
            String text = (String)map.get("text");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("SmsDispatchersController", "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            } else {
                Rlog.d("SmsDispatchersController", "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            }
        } else if (map.containsKey("data")) {
            Rlog.d("SmsDispatchersController", "sms failed was data");
            byte[] data = (byte[])map.get("data");
            Integer destPort = (Integer)map.get("destPort");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("SmsDispatchersController", "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            } else {
                Rlog.d("SmsDispatchersController", "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            }
        }
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        SMSDispatcher dispatcher = this.isCdmaFormat(newFormat) ? this.mCdmaDispatcher : this.mGsmDispatcher;
        tracker.mFormat = dispatcher.getFormat();
        dispatcher.sendSms(tracker);
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsDispatchersController$isIms() {
        return this.mIms;
    }

    private final String $$robo$$com_android_internal_telephony_SmsDispatchersController$getImsSmsFormat() {
        return this.mImsSmsFormat;
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsDispatchersController$isCdmaMo() {
        if (!this.isIms()) {
            return 2 == this.mPhone.getPhoneType();
        }
        return this.isCdmaFormat(this.mImsSmsFormat);
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsDispatchersController$isCdmaFormat(String format) {
        return this.mCdmaDispatcher.getFormat().equals(format);
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (this.mImsSmsDispatcher.isAvailable()) {
            this.mImsSmsDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        } else {
            this.mGsmDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        if (this.mImsSmsDispatcher.isAvailable()) {
            this.mImsSmsDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, -1, false, -1);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        } else {
            this.mGsmDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        }
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg, boolean persistMessage, int priority, boolean expectMore, int validityPeriod) {
        if (this.mImsSmsDispatcher.isAvailable()) {
            this.mImsSmsDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, -1, false, -1);
        } else if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        } else {
            this.mGsmDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg, persistMessage, priority, expectMore, validityPeriod);
        }
    }

    private final int $$robo$$com_android_internal_telephony_SmsDispatchersController$getPremiumSmsPermission(String packageName) {
        return this.mUsageMonitor.getPremiumSmsPermission(packageName);
    }

    private final void $$robo$$com_android_internal_telephony_SmsDispatchersController$setPremiumSmsPermission(String packageName, int permission2) {
        this.mUsageMonitor.setPremiumSmsPermission(packageName, permission2);
    }

    private final SmsUsageMonitor $$robo$$com_android_internal_telephony_SmsDispatchersController$getUsageMonitor() {
        return this.mUsageMonitor;
    }

    private final Pair<Boolean, Boolean> $$robo$$com_android_internal_telephony_SmsDispatchersController$handleSmsStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        if (this.isCdmaFormat(format)) {
            return this.handleCdmaStatusReport(tracker, format, pdu);
        }
        return this.handleGsmStatusReport(tracker, format, pdu);
    }

    private final Pair<Boolean, Boolean> $$robo$$com_android_internal_telephony_SmsDispatchersController$handleCdmaStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        tracker.updateSentMessageStatus(this.mContext, 0);
        boolean success = this.triggerDeliveryIntent(tracker, format, pdu);
        return new Pair<Boolean, Boolean>(success, true);
    }

    private final Pair<Boolean, Boolean> $$robo$$com_android_internal_telephony_SmsDispatchersController$handleGsmStatusReport(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        com.android.internal.telephony.gsm.SmsMessage sms = com.android.internal.telephony.gsm.SmsMessage.newFromCDS(pdu);
        boolean complete = false;
        boolean success = false;
        if (sms != null) {
            int tpStatus = sms.getStatus();
            if (tpStatus >= 64 || tpStatus < 32) {
                tracker.updateSentMessageStatus(this.mContext, tpStatus);
                complete = true;
            }
            success = this.triggerDeliveryIntent(tracker, format, pdu);
        }
        return new Pair<Boolean, Boolean>(success, complete);
    }

    private final boolean $$robo$$com_android_internal_telephony_SmsDispatchersController$triggerDeliveryIntent(SMSDispatcher.SmsTracker tracker, String format, byte[] pdu) {
        PendingIntent intent = tracker.mDeliveryIntent;
        Intent fillIn = new Intent();
        fillIn.putExtra("pdu", pdu);
        fillIn.putExtra("format", format);
        try {
            intent.send(this.mContext, -1, fillIn);
            return true;
        }
        catch (PendingIntent.CanceledException ex) {
            return false;
        }
    }

    private void __constructor__(Phone phone, SmsStorageMonitor smsStorageMonitor, SmsUsageMonitor smsUsageMonitor) {
        this.$$robo$$com_android_internal_telephony_SmsDispatchersController$__constructor__(phone, smsStorageMonitor, smsUsageMonitor);
    }

    public SmsDispatchersController(Phone phone, SmsStorageMonitor smsStorageMonitor, SmsUsageMonitor smsUsageMonitor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsDispatchersController$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.SmsUsageMonitor ), 0, this, phone, smsStorageMonitor, smsUsageMonitor);
    }

    protected void updatePhoneObject(Phone phone) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_SmsDispatchersController$updatePhoneObject(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SmsDispatchersController$dispose(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SmsDispatchersController$handleMessage(android.os.Message ), 0, this, message);
    }

    private void setImsSmsFormat(int n) {
        InvokeDynamicSupport.bootstrap("setImsSmsFormat", $$robo$$com_android_internal_telephony_SmsDispatchersController$setImsSmsFormat(int ), 0, this, n);
    }

    private void updateImsInfo(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("updateImsInfo", $$robo$$com_android_internal_telephony_SmsDispatchersController$updateImsInfo(android.os.AsyncResult ), 0, this, asyncResult);
    }

    public void injectSmsPdu(byte[] byArray, String string2, SmsInjectionCallback smsInjectionCallback) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_SmsDispatchersController$injectSmsPdu(byte[] java.lang.String com.android.internal.telephony.SmsDispatchersController$SmsInjectionCallback ), 0, this, byArray, string2, smsInjectionCallback);
    }

    public void injectSmsPdu(android.telephony.SmsMessage smsMessage, String string2, SmsInjectionCallback smsInjectionCallback, boolean bl) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_SmsDispatchersController$injectSmsPdu(android.telephony.SmsMessage java.lang.String com.android.internal.telephony.SmsDispatchersController$SmsInjectionCallback boolean ), 0, this, smsMessage, string2, smsInjectionCallback, bl);
    }

    public void sendRetrySms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRetrySms", $$robo$$com_android_internal_telephony_SmsDispatchersController$sendRetrySms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    public boolean isIms() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIms", $$robo$$com_android_internal_telephony_SmsDispatchersController$isIms(), 0, this);
    }

    public String getImsSmsFormat() {
        return InvokeDynamicSupport.bootstrap("getImsSmsFormat", $$robo$$com_android_internal_telephony_SmsDispatchersController$getImsSmsFormat(), 0, this);
    }

    protected boolean isCdmaMo() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaMo", $$robo$$com_android_internal_telephony_SmsDispatchersController$isCdmaMo(), 0, this);
    }

    public boolean isCdmaFormat(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaFormat", $$robo$$com_android_internal_telephony_SmsDispatchersController$isCdmaFormat(java.lang.String ), 0, this, string2);
    }

    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_SmsDispatchersController$sendData(java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2, Uri uri, String string5, boolean bl, int n, boolean bl2, int n2) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_SmsDispatchersController$sendText(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent android.net.Uri java.lang.String boolean int boolean int ), 0, this, string2, string3, string4, pendingIntent, pendingIntent2, uri, string5, bl, n, bl2, n2);
    }

    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3, Uri uri, String string4, boolean bl, int n, boolean bl2, int n2) {
        InvokeDynamicSupport.bootstrap("sendMultipartText", $$robo$$com_android_internal_telephony_SmsDispatchersController$sendMultipartText(java.lang.String java.lang.String java.util.ArrayList<java.lang.String> java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> android.net.Uri java.lang.String boolean int boolean int ), 0, this, string2, string3, arrayList, arrayList2, arrayList3, uri, string4, bl, n, bl2, n2);
    }

    public int getPremiumSmsPermission(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPremiumSmsPermission", $$robo$$com_android_internal_telephony_SmsDispatchersController$getPremiumSmsPermission(java.lang.String ), 0, this, string2);
    }

    public void setPremiumSmsPermission(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPremiumSmsPermission", $$robo$$com_android_internal_telephony_SmsDispatchersController$setPremiumSmsPermission(java.lang.String int ), 0, this, string2, n);
    }

    public SmsUsageMonitor getUsageMonitor() {
        return InvokeDynamicSupport.bootstrap("getUsageMonitor", $$robo$$com_android_internal_telephony_SmsDispatchersController$getUsageMonitor(), 0, this);
    }

    public Pair<Boolean, Boolean> handleSmsStatusReport(SMSDispatcher.SmsTracker smsTracker, String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("handleSmsStatusReport", $$robo$$com_android_internal_telephony_SmsDispatchersController$handleSmsStatusReport(com.android.internal.telephony.SMSDispatcher$SmsTracker java.lang.String byte[] ), 0, this, smsTracker, string2, byArray);
    }

    private Pair<Boolean, Boolean> handleCdmaStatusReport(SMSDispatcher.SmsTracker smsTracker, String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("handleCdmaStatusReport", $$robo$$com_android_internal_telephony_SmsDispatchersController$handleCdmaStatusReport(com.android.internal.telephony.SMSDispatcher$SmsTracker java.lang.String byte[] ), 0, this, smsTracker, string2, byArray);
    }

    private Pair<Boolean, Boolean> handleGsmStatusReport(SMSDispatcher.SmsTracker smsTracker, String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("handleGsmStatusReport", $$robo$$com_android_internal_telephony_SmsDispatchersController$handleGsmStatusReport(com.android.internal.telephony.SMSDispatcher$SmsTracker java.lang.String byte[] ), 0, this, smsTracker, string2, byArray);
    }

    private boolean triggerDeliveryIntent(SMSDispatcher.SmsTracker smsTracker, String string2, byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("triggerDeliveryIntent", $$robo$$com_android_internal_telephony_SmsDispatchersController$triggerDeliveryIntent(com.android.internal.telephony.SMSDispatcher$SmsTracker java.lang.String byte[] ), 0, this, smsTracker, string2, byArray);
    }

    public /* synthetic */ SmsDispatchersController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsDispatchersController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface SmsInjectionCallback
    extends InstrumentedInterface {
        public void onSmsInjectedResult(int var1);
    }
}

