/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.app.IUserSwitchObserver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.IPackageManager;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.service.euicc.EuiccProfileInfo;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UiccAccessRule;
import android.telephony.euicc.EuiccManager;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.CarrierAppUtils;
import com.android.internal.telephony.CarrierServiceBindHelper;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IntentBroadcaster;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccController;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionInfoUpdater
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SubscriptionInfoUpdater";
    private static int PROJECT_SIM_NUM;
    private static int EVENT_INVALID = -1;
    private static int EVENT_GET_NETWORK_SELECTION_MODE_DONE = 2;
    private static int EVENT_SIM_LOADED = 3;
    private static int EVENT_SIM_ABSENT = 4;
    private static int EVENT_SIM_LOCKED = 5;
    private static int EVENT_SIM_IO_ERROR = 6;
    private static int EVENT_SIM_UNKNOWN = 7;
    private static int EVENT_SIM_RESTRICTED = 8;
    private static int EVENT_SIM_NOT_READY = 9;
    private static int EVENT_SIM_READY = 10;
    private static int EVENT_SIM_IMSI = 11;
    private static int EVENT_REFRESH_EMBEDDED_SUBSCRIPTIONS = 12;
    private static String ICCID_STRING_FOR_NO_SIM = "";
    public static int SIM_NOT_CHANGE = 0;
    public static int SIM_CHANGED = -1;
    public static int SIM_NEW = -2;
    public static int SIM_REPOSITION = -3;
    public static int SIM_NOT_INSERT = -99;
    public static int STATUS_NO_SIM_INSERTED = 0;
    public static int STATUS_SIM1_INSERTED = 1;
    public static int STATUS_SIM2_INSERTED = 2;
    public static int STATUS_SIM3_INSERTED = 4;
    public static int STATUS_SIM4_INSERTED = 8;
    public static String CURR_SUBID = "curr_subid";
    private static Phone[] mPhone;
    private static Context mContext;
    private static String[] mIccId;
    private static int[] mInsertSimState;
    private static int[] sSimCardState;
    private static int[] sSimApplicationState;
    private SubscriptionManager mSubscriptionManager;
    private EuiccManager mEuiccManager;
    private IPackageManager mPackageManager;
    private int mCurrentlyActiveUserId;
    private CarrierServiceBindHelper mCarrierServiceBindHelper;

    private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(Looper looper, Context context, Phone[] phone, CommandsInterface[] ci) {
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(Looper looper, Context context, Phone[] phone, CommandsInterface[] ci, IPackageManager packageMgr) {
        this.mSubscriptionManager = null;
        this.logd("Constructor invoked");
        mContext = context;
        mPhone = phone;
        this.mSubscriptionManager = SubscriptionManager.from(mContext);
        this.mEuiccManager = (EuiccManager)mContext.getSystemService("euicc");
        this.mPackageManager = packageMgr;
        this.mCarrierServiceBindHelper = new CarrierServiceBindHelper(mContext);
        this.initializeCarrierApps();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$initializeCarrierApps() {
        this.mCurrentlyActiveUserId = 0;
        try {
            ActivityManager.getService().registerUserSwitchObserver((IUserSwitchObserver)new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SubscriptionInfoUpdater this$0;

                private void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(SubscriptionInfoUpdater this$0) {
                }

                private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitching(int newUserId, IRemoteCallback reply) throws RemoteException {
                    this.this$0.mCurrentlyActiveUserId = newUserId;
                    CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.this$0.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.this$0.mCurrentlyActiveUserId);
                    if (reply != null) {
                        try {
                            reply.sendResult(null);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                private void __constructor__(SubscriptionInfoUpdater subscriptionInfoUpdater) {
                    this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(subscriptionInfoUpdater);
                }
                {
                    this.this$0 = subscriptionInfoUpdater;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$__constructor__(com.android.internal.telephony.SubscriptionInfoUpdater ), 0, this, subscriptionInfoUpdater);
                }

                @Override
                public void onUserSwitching(int n, IRemoteCallback iRemoteCallback) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onUserSwitching", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater_1$onUserSwitching(int android.os.IRemoteCallback ), 0, this, n, iRemoteCallback);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }, "SubscriptionInfoUpdater");
            this.mCurrentlyActiveUserId = ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            this.logd("Couldn't get current user ID; guessing it's 0: " + e.getMessage());
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateInternalIccState(String simStatus, String reason, int slotId) {
        this.logd("updateInternalIccState to simStatus " + simStatus + " reason " + reason + " slotId " + slotId);
        int message = this.internalIccStateToMessage(simStatus);
        if (message != -1) {
            this.sendMessage(this.obtainMessage(message, slotId, -1, reason));
        }
    }

    private final int $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$internalIccStateToMessage(String simStatus) {
        switch (simStatus) {
            case "ABSENT": {
                return 4;
            }
            case "UNKNOWN": {
                return 7;
            }
            case "CARD_IO_ERROR": {
                return 6;
            }
            case "CARD_RESTRICTED": {
                return 8;
            }
            case "NOT_READY": {
                return 9;
            }
            case "LOCKED": {
                return 5;
            }
            case "LOADED": {
                return 3;
            }
            case "READY": {
                return 10;
            }
            case "IMSI": {
                return 11;
            }
        }
        this.logd("Ignoring simStatus: " + simStatus);
        return -1;
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isAllIccIdQueryDone() {
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mIccId[i] != null) continue;
            this.logd("Wait for SIM" + (i + 1) + " IccId");
            return false;
        }
        this.logd("All IccIds query complete");
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleMessage(Message msg) {
        switch (msg.what) {
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Integer slotId = (Integer)ar.userObj;
                if (ar.exception == null && ar.result != null) {
                    int[] modes = (int[])ar.result;
                    if (modes[0] != 1) break;
                    mPhone[slotId].setNetworkSelectionModeAutomatic(null);
                    break;
                }
                this.logd("EVENT_GET_NETWORK_SELECTION_MODE_DONE: error getting network mode.");
                break;
            }
            case 3: {
                this.handleSimLoaded(msg.arg1);
                break;
            }
            case 4: {
                this.handleSimAbsent(msg.arg1);
                break;
            }
            case 5: {
                this.handleSimLocked(msg.arg1, (String)msg.obj);
                break;
            }
            case 7: {
                this.updateCarrierServices(msg.arg1, "UNKNOWN");
                this.broadcastSimStateChanged(msg.arg1, "UNKNOWN", null);
                this.broadcastSimCardStateChanged(msg.arg1, 0);
                this.broadcastSimApplicationStateChanged(msg.arg1, 0);
                break;
            }
            case 6: {
                this.handleSimError(msg.arg1);
                break;
            }
            case 8: {
                this.updateCarrierServices(msg.arg1, "CARD_RESTRICTED");
                this.broadcastSimStateChanged(msg.arg1, "CARD_RESTRICTED", "CARD_RESTRICTED");
                this.broadcastSimCardStateChanged(msg.arg1, 9);
                this.broadcastSimApplicationStateChanged(msg.arg1, 6);
                break;
            }
            case 10: {
                this.broadcastSimStateChanged(msg.arg1, "READY", null);
                this.broadcastSimCardStateChanged(msg.arg1, 11);
                this.broadcastSimApplicationStateChanged(msg.arg1, 6);
                break;
            }
            case 11: {
                this.broadcastSimStateChanged(msg.arg1, "IMSI", null);
                break;
            }
            case 9: {
                this.broadcastSimStateChanged(msg.arg1, "NOT_READY", null);
                this.broadcastSimCardStateChanged(msg.arg1, 11);
                this.broadcastSimApplicationStateChanged(msg.arg1, 6);
            }
            case 12: {
                if (this.updateEmbeddedSubscriptions()) {
                    SubscriptionController.getInstance().notifySubscriptionInfoChanged();
                }
                if (msg.obj == null) break;
                ((Runnable)msg.obj).run();
                break;
            }
            default: {
                this.logd("Unknown msg:" + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$requestEmbeddedSubscriptionInfoListRefresh(Runnable callback) {
        this.sendMessage(this.obtainMessage(12, callback));
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLocked(int slotId, String reason) {
        String iccId;
        if (mIccId[slotId] != null && mIccId[slotId].equals("")) {
            this.logd("SIM" + (slotId + 1) + " hot plug in");
            SubscriptionInfoUpdater.mIccId[slotId] = null;
        }
        if ((iccId = mIccId[slotId]) == null) {
            IccCard iccCard = mPhone[slotId].getIccCard();
            if (iccCard == null) {
                this.logd("handleSimLocked: IccCard null");
                return;
            }
            IccRecords records = iccCard.getIccRecords();
            if (records == null) {
                this.logd("handleSimLocked: IccRecords null");
                return;
            }
            if (IccUtils.stripTrailingFs(records.getFullIccId()) == null) {
                this.logd("handleSimLocked: IccID null");
                return;
            }
            SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.stripTrailingFs(records.getFullIccId());
        } else {
            this.logd("NOT Querying IccId its already set sIccid[" + slotId + "]=" + iccId);
        }
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        this.updateCarrierServices(slotId, "LOCKED");
        this.broadcastSimStateChanged(slotId, "LOCKED", reason);
        this.broadcastSimCardStateChanged(slotId, 11);
        this.broadcastSimApplicationStateChanged(slotId, SubscriptionInfoUpdater.getSimStateFromLockedReason(reason));
    }

    private static final int $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$getSimStateFromLockedReason(String lockedReason) {
        switch (lockedReason) {
            case "PIN": {
                return 2;
            }
            case "PUK": {
                return 3;
            }
            case "NETWORK": {
                return 4;
            }
            case "PERM_DISABLED": {
                return 7;
            }
        }
        Rlog.e("SubscriptionInfoUpdater", "Unexpected SIM locked reason " + lockedReason);
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLoaded(int slotId) {
        this.logd("handleSimLoaded: slotId: " + slotId);
        int loadedSlotId = slotId;
        IccCard iccCard = mPhone[slotId].getIccCard();
        if (iccCard == null) {
            this.logd("handleSimLoaded: IccCard null");
            return;
        }
        IccRecords records = iccCard.getIccRecords();
        if (records == null) {
            this.logd("handleSimLoaded: IccRecords null");
            return;
        }
        if (IccUtils.stripTrailingFs(records.getFullIccId()) == null) {
            this.logd("handleSimLoaded: IccID null");
            return;
        }
        SubscriptionInfoUpdater.mIccId[slotId] = IccUtils.stripTrailingFs(records.getFullIccId());
        if (this.isAllIccIdQueryDone()) {
            int[] subIds;
            this.updateSubscriptionInfoByIccId();
            for (int subId : subIds = this.mSubscriptionManager.getActiveSubscriptionIdList()) {
                SharedPreferences sp;
                int storedSubId;
                TelephonyManager tm = TelephonyManager.getDefault();
                String operator = tm.getSimOperatorNumeric(subId);
                slotId = SubscriptionController.getInstance().getPhoneId(subId);
                if (!TextUtils.isEmpty(operator)) {
                    if (subId == SubscriptionController.getInstance().getDefaultSubId()) {
                        MccTable.updateMccMncConfiguration(mContext, operator, false);
                    }
                    SubscriptionController.getInstance().setMccMnc(operator, subId);
                } else {
                    this.logd("EVENT_RECORDS_LOADED Operator name is null");
                }
                String msisdn = tm.getLine1Number(subId);
                ContentResolver contentResolver = mContext.getContentResolver();
                if (msisdn != null) {
                    SubscriptionController.getInstance().setDisplayNumber(msisdn, subId);
                }
                SubscriptionInfo subInfo = this.mSubscriptionManager.getActiveSubscriptionInfo(subId);
                String simCarrierName = tm.getSimOperatorName(subId);
                if (subInfo != null && subInfo.getNameSource() != 2) {
                    String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotId + 1);
                    this.logd("sim name = " + nameToSet);
                    SubscriptionController.getInstance().setDisplayName(nameToSet, subId);
                }
                if ((storedSubId = (sp = PreferenceManager.getDefaultSharedPreferences(mContext)).getInt("curr_subid" + slotId, -1)) == subId) continue;
                int networkType = Settings.Global.getInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, -1);
                if (networkType == -1) {
                    networkType = RILConstants.PREFERRED_NETWORK_MODE;
                    try {
                        networkType = TelephonyManager.getIntAtIndex(mContext.getContentResolver(), "preferred_network_mode", slotId);
                    }
                    catch (Settings.SettingNotFoundException retrySnfe) {
                        Rlog.e("SubscriptionInfoUpdater", "Settings Exception Reading Value At Index for Settings.Global.PREFERRED_NETWORK_MODE");
                    }
                    Settings.Global.putInt(mPhone[slotId].getContext().getContentResolver(), "preferred_network_mode" + subId, networkType);
                }
                mPhone[slotId].setPreferredNetworkType(networkType, null);
                mPhone[slotId].getNetworkSelectionMode(this.obtainMessage(2, new Integer(slotId)));
                SharedPreferences.Editor editor = sp.edit();
                editor.putInt("curr_subid" + slotId, subId);
                editor.apply();
            }
        }
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(mContext.getOpPackageName(), this.mPackageManager, TelephonyManager.getDefault(), mContext.getContentResolver(), this.mCurrentlyActiveUserId);
        this.broadcastSimStateChanged(loadedSlotId, "LOADED", null);
        this.broadcastSimCardStateChanged(loadedSlotId, 11);
        this.broadcastSimApplicationStateChanged(loadedSlotId, 10);
        this.updateCarrierServices(loadedSlotId, "LOADED");
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateCarrierServices(int slotId, String simState) {
        CarrierConfigManager configManager = (CarrierConfigManager)mContext.getSystemService("carrier_config");
        configManager.updateConfigForPhoneId(slotId, simState);
        this.mCarrierServiceBindHelper.updateForPhoneId(slotId, simState);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimAbsent(int slotId) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals("")) {
            this.logd("SIM" + (slotId + 1) + " hot plug out");
        }
        SubscriptionInfoUpdater.mIccId[slotId] = "";
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        this.updateCarrierServices(slotId, "ABSENT");
        this.broadcastSimStateChanged(slotId, "ABSENT", null);
        this.broadcastSimCardStateChanged(slotId, 1);
        this.broadcastSimApplicationStateChanged(slotId, 6);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimError(int slotId) {
        if (mIccId[slotId] != null && !mIccId[slotId].equals("")) {
            this.logd("SIM" + (slotId + 1) + " Error ");
        }
        SubscriptionInfoUpdater.mIccId[slotId] = "";
        if (this.isAllIccIdQueryDone()) {
            this.updateSubscriptionInfoByIccId();
        }
        this.updateCarrierServices(slotId, "CARD_IO_ERROR");
        this.broadcastSimStateChanged(slotId, "CARD_IO_ERROR", "CARD_IO_ERROR");
        this.broadcastSimCardStateChanged(slotId, 8);
        this.broadcastSimApplicationStateChanged(slotId, 6);
    }

    private final synchronized void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateSubscriptionInfoByIccId() {
        int i;
        int i2;
        this.logd("updateSubscriptionInfoByIccId:+ Start");
        for (int i3 = 0; i3 < PROJECT_SIM_NUM; ++i3) {
            SubscriptionInfoUpdater.mInsertSimState[i3] = 0;
        }
        int insertedSimCount = PROJECT_SIM_NUM;
        for (int i4 = 0; i4 < PROJECT_SIM_NUM; ++i4) {
            if (!"".equals(mIccId[i4])) continue;
            --insertedSimCount;
            SubscriptionInfoUpdater.mInsertSimState[i4] = -99;
        }
        this.logd("insertedSimCount = " + insertedSimCount);
        if (SubscriptionController.getInstance().getActiveSubIdList().length > insertedSimCount) {
            SubscriptionController.getInstance().clearSubInfo();
        }
        int index = 0;
        for (int i5 = 0; i5 < PROJECT_SIM_NUM; ++i5) {
            if (mInsertSimState[i5] == -99) continue;
            index = 2;
            for (int j = i5 + 1; j < PROJECT_SIM_NUM; ++j) {
                if (mInsertSimState[j] != 0 || !mIccId[i5].equals(mIccId[j])) continue;
                SubscriptionInfoUpdater.mInsertSimState[i5] = 1;
                SubscriptionInfoUpdater.mInsertSimState[j] = index++;
            }
        }
        ContentResolver contentResolver = mContext.getContentResolver();
        String[] oldIccId = new String[PROJECT_SIM_NUM];
        String[] decIccId = new String[PROJECT_SIM_NUM];
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            oldIccId[i2] = null;
            List<SubscriptionInfo> oldSubInfo = SubscriptionController.getInstance().getSubInfoUsingSlotIndexPrivileged(i2, false);
            decIccId[i2] = IccUtils.getDecimalSubstring(mIccId[i2]);
            if (oldSubInfo != null && oldSubInfo.size() > 0) {
                oldIccId[i2] = oldSubInfo.get(0).getIccId();
                this.logd("updateSubscriptionInfoByIccId: oldSubId = " + oldSubInfo.get(0).getSubscriptionId());
                if (!(mInsertSimState[i2] != 0 || mIccId[i2].equals(oldIccId[i2]) || decIccId[i2] != null && decIccId[i2].equals(oldIccId[i2]))) {
                    SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
                }
                if (mInsertSimState[i2] == 0) continue;
                ContentValues value = new ContentValues(1);
                value.put("sim_id", -1);
                contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(oldSubInfo.get(0).getSubscriptionId()), null);
                SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
                continue;
            }
            if (mInsertSimState[i2] == 0) {
                SubscriptionInfoUpdater.mInsertSimState[i2] = -1;
            }
            oldIccId[i2] = "";
            this.logd("updateSubscriptionInfoByIccId: No SIM in slot " + i2 + " last time");
        }
        for (i2 = 0; i2 < PROJECT_SIM_NUM; ++i2) {
            this.logd("updateSubscriptionInfoByIccId: oldIccId[" + i2 + "] = " + oldIccId[i2] + ", sIccId[" + i2 + "] = " + mIccId[i2]);
        }
        int nNewCardCount = 0;
        int nNewSimStatus = 0;
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -99) {
                this.logd("updateSubscriptionInfoByIccId: No SIM inserted in slot " + i + " this time");
                continue;
            }
            if (mInsertSimState[i] > 0) {
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i] + Integer.toString(mInsertSimState[i]), i);
                this.logd("SUB" + (i + 1) + " has invalid IccId");
            } else {
                this.logd("updateSubscriptionInfoByIccId: adding subscription info record: iccid: " + mIccId[i] + "slot: " + i);
                this.mSubscriptionManager.addSubscriptionInfoRecord(mIccId[i], i);
            }
            if (!this.isNewSim(mIccId[i], decIccId[i], oldIccId)) continue;
            ++nNewCardCount;
            switch (i) {
                case 0: {
                    nNewSimStatus |= 1;
                    break;
                }
                case 1: {
                    nNewSimStatus |= 2;
                    break;
                }
                case 2: {
                    nNewSimStatus |= 4;
                }
            }
            SubscriptionInfoUpdater.mInsertSimState[i] = -2;
        }
        for (i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (mInsertSimState[i] == -1) {
                SubscriptionInfoUpdater.mInsertSimState[i] = -3;
            }
            this.logd("updateSubscriptionInfoByIccId: sInsertSimState[" + i + "] = " + mInsertSimState[i]);
        }
        List<SubscriptionInfo> subInfos = this.mSubscriptionManager.getActiveSubscriptionInfoList();
        int nSubCount = subInfos == null ? 0 : subInfos.size();
        this.logd("updateSubscriptionInfoByIccId: nSubCount = " + nSubCount);
        for (int i6 = 0; i6 < nSubCount; ++i6) {
            SubscriptionInfo temp = subInfos.get(i6);
            String msisdn = TelephonyManager.getDefault().getLine1Number(temp.getSubscriptionId());
            if (msisdn == null) continue;
            ContentValues value = new ContentValues(1);
            value.put("number", msisdn);
            contentResolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(temp.getSubscriptionId()), null);
            SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
        }
        SubscriptionInfoUpdater subscriptionInfoUpdater = this;
        this.mSubscriptionManager.setDefaultDataSubId(subscriptionInfoUpdater.mSubscriptionManager.getDefaultDataSubscriptionId());
        this.updateEmbeddedSubscriptions();
        SubscriptionController.getInstance().notifySubscriptionInfoChanged();
        this.logd("updateSubscriptionInfoByIccId:- SubscriptionInfo update complete");
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final boolean $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateEmbeddedSubscriptions() {
        EuiccProfileInfo[] embeddedProfiles;
        if (!this.mEuiccManager.isEnabled()) {
            return false;
        }
        GetEuiccProfileInfoListResult result = EuiccController.get().blockingGetEuiccProfileInfoList();
        if (result == null) {
            return false;
        }
        if (result.getResult() == 0) {
            List<EuiccProfileInfo> list = result.getProfiles();
            embeddedProfiles = list == null || list.size() == 0 ? new EuiccProfileInfo[]{} : list.toArray(new EuiccProfileInfo[list.size()]);
        } else {
            this.logd("updatedEmbeddedSubscriptions: error " + result.getResult() + " listing profiles");
            embeddedProfiles = new EuiccProfileInfo[]{};
        }
        boolean isRemovable = result.getIsRemovable();
        String[] embeddedIccids = new String[embeddedProfiles.length];
        for (int i = 0; i < embeddedProfiles.length; ++i) {
            embeddedIccids[i] = embeddedProfiles[i].getIccid();
        }
        boolean hasChanges = false;
        List<SubscriptionInfo> existingSubscriptions = SubscriptionController.getInstance().getSubscriptionInfoListForEmbeddedSubscriptionUpdate(embeddedIccids, isRemovable);
        ContentResolver contentResolver = mContext.getContentResolver();
        for (EuiccProfileInfo embeddedProfile : embeddedProfiles) {
            int index = SubscriptionInfoUpdater.findSubscriptionInfoForIccid(existingSubscriptions, embeddedProfile.getIccid());
            if (index < 0) {
                SubscriptionController.getInstance().insertEmptySubInfoRecord(embeddedProfile.getIccid(), -1);
            } else {
                existingSubscriptions.remove(index);
            }
            ContentValues values = new ContentValues();
            values.put("is_embedded", 1);
            List<UiccAccessRule> ruleList = embeddedProfile.getUiccAccessRules();
            boolean isRuleListEmpty = false;
            if (ruleList == null || ruleList.size() == 0) {
                isRuleListEmpty = true;
            }
            values.put("access_rules", isRuleListEmpty ? null : UiccAccessRule.encodeRules(ruleList.toArray(new UiccAccessRule[ruleList.size()])));
            values.put("is_removable", isRemovable);
            values.put("display_name", embeddedProfile.getNickname());
            values.put("name_source", 2);
            hasChanges = true;
            contentResolver.update(SubscriptionManager.CONTENT_URI, values, "icc_id=\"" + embeddedProfile.getIccid() + "\"", null);
            SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
        }
        if (!existingSubscriptions.isEmpty()) {
            ArrayList<String> iccidsToRemove = new ArrayList<String>();
            for (int i = 0; i < existingSubscriptions.size(); ++i) {
                SubscriptionInfo info = existingSubscriptions.get(i);
                if (!info.isEmbedded()) continue;
                iccidsToRemove.add("\"" + info.getIccId() + "\"");
            }
            String whereClause = "icc_id IN (" + TextUtils.join((CharSequence)",", iccidsToRemove) + ")";
            ContentValues values = new ContentValues();
            values.put("is_embedded", 0);
            hasChanges = true;
            contentResolver.update(SubscriptionManager.CONTENT_URI, values, whereClause, null);
            SubscriptionController.getInstance().refreshCachedActiveSubscriptionInfoList();
        }
        return hasChanges;
    }

    private static final int $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$findSubscriptionInfoForIccid(List<SubscriptionInfo> list, String iccid) {
        for (int i = 0; i < list.size(); ++i) {
            if (!TextUtils.equals(iccid, list.get(i).getIccId())) continue;
            return i;
        }
        return -1;
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isNewSim(String iccId, String decIccId, String[] oldIccId) {
        boolean newSim = true;
        for (int i = 0; i < PROJECT_SIM_NUM; ++i) {
            if (iccId.equals(oldIccId[i])) {
                newSim = false;
                break;
            }
            if (decIccId == null || !decIccId.equals(oldIccId[i])) continue;
            newSim = false;
            break;
        }
        this.logd("newSim = " + newSim);
        return newSim;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimStateChanged(int slotId, String state, String reason) {
        Intent i = new Intent("android.intent.action.SIM_STATE_CHANGED");
        i.addFlags(0x4000000);
        i.putExtra("phoneName", "Phone");
        i.putExtra("ss", state);
        i.putExtra("reason", reason);
        SubscriptionManager.putPhoneIdAndSubIdExtra(i, slotId);
        this.logd("Broadcasting intent ACTION_SIM_STATE_CHANGED " + state + " reason " + reason + " for mCardIndex: " + slotId);
        IntentBroadcaster.getInstance().broadcastStickyIntent(i, slotId);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimCardStateChanged(int phoneId, int state) {
        if (state != sSimCardState[phoneId]) {
            SubscriptionInfoUpdater.sSimCardState[phoneId] = state;
            Intent i = new Intent("android.telephony.action.SIM_CARD_STATE_CHANGED");
            i.addFlags(0x4000000);
            i.addFlags(0x1000000);
            i.putExtra("android.telephony.extra.SIM_STATE", state);
            SubscriptionManager.putPhoneIdAndSubIdExtra(i, phoneId);
            this.logd("Broadcasting intent ACTION_SIM_CARD_STATE_CHANGED " + SubscriptionInfoUpdater.simStateString(state) + " for phone: " + phoneId);
            mContext.sendBroadcast(i, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        }
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimApplicationStateChanged(int phoneId, int state) {
        if (state != sSimApplicationState[phoneId] && (state != 6 || sSimApplicationState[phoneId] != 0)) {
            SubscriptionInfoUpdater.sSimApplicationState[phoneId] = state;
            Intent i = new Intent("android.telephony.action.SIM_APPLICATION_STATE_CHANGED");
            i.addFlags(0x1000000);
            i.addFlags(0x4000000);
            i.putExtra("android.telephony.extra.SIM_STATE", state);
            SubscriptionManager.putPhoneIdAndSubIdExtra(i, phoneId);
            this.logd("Broadcasting intent ACTION_SIM_APPLICATION_STATE_CHANGED " + SubscriptionInfoUpdater.simStateString(state) + " for phone: " + phoneId);
            mContext.sendBroadcast(i, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        }
    }

    private static final String $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$simStateString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ABSENT";
            }
            case 2: {
                return "PIN_REQUIRED";
            }
            case 3: {
                return "PUK_REQUIRED";
            }
            case 4: {
                return "NETWORK_LOCKED";
            }
            case 5: {
                return "READY";
            }
            case 6: {
                return "NOT_READY";
            }
            case 7: {
                return "PERM_DISABLED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
            case 10: {
                return "LOADED";
            }
            case 11: {
                return "PRESENT";
            }
        }
        return "INVALID";
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$logd(String message) {
        Rlog.d("SubscriptionInfoUpdater", message);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("SubscriptionInfoUpdater:");
        this.mCarrierServiceBindHelper.dump(fd, pw, args);
    }

    static void __staticInitializer__() {
        PROJECT_SIM_NUM = TelephonyManager.getDefault().getPhoneCount();
        mContext = null;
        mIccId = new String[PROJECT_SIM_NUM];
        mInsertSimState = new int[PROJECT_SIM_NUM];
        sSimCardState = new int[PROJECT_SIM_NUM];
        sSimApplicationState = new int[PROJECT_SIM_NUM];
    }

    private void __constructor__(Looper looper, Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray) {
        this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(looper, context, phoneArray, commandsInterfaceArray);
    }

    public SubscriptionInfoUpdater(Looper looper, Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray) {
        this(looper, context, phoneArray, commandsInterfaceArray, IPackageManager.Stub.asInterface(ServiceManager.getService("package")));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(android.os.Looper android.content.Context com.android.internal.telephony.Phone[] com.android.internal.telephony.CommandsInterface[] ), 0, this, looper, context, phoneArray, commandsInterfaceArray);
    }

    private void __constructor__(Looper looper, Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray, IPackageManager iPackageManager) {
        this.$$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(looper, context, phoneArray, commandsInterfaceArray, iPackageManager);
    }

    public SubscriptionInfoUpdater(Looper looper, Context context, Phone[] phoneArray, CommandsInterface[] commandsInterfaceArray, IPackageManager iPackageManager) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$__constructor__(android.os.Looper android.content.Context com.android.internal.telephony.Phone[] com.android.internal.telephony.CommandsInterface[] android.content.pm.IPackageManager ), 0, this, looper, context, phoneArray, commandsInterfaceArray, iPackageManager);
    }

    private void initializeCarrierApps() {
        InvokeDynamicSupport.bootstrap("initializeCarrierApps", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$initializeCarrierApps(), 0, this);
    }

    public void updateInternalIccState(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("updateInternalIccState", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateInternalIccState(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    private int internalIccStateToMessage(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("internalIccStateToMessage", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$internalIccStateToMessage(java.lang.String ), 0, this, string2);
    }

    private boolean isAllIccIdQueryDone() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAllIccIdQueryDone", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isAllIccIdQueryDone(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleMessage(android.os.Message ), 0, this, message);
    }

    void requestEmbeddedSubscriptionInfoListRefresh(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("requestEmbeddedSubscriptionInfoListRefresh", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$requestEmbeddedSubscriptionInfoListRefresh(java.lang.Runnable ), 0, this, runnable);
    }

    private void handleSimLocked(int n, String string2) {
        InvokeDynamicSupport.bootstrap("handleSimLocked", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLocked(int java.lang.String ), 0, this, n, string2);
    }

    private static int getSimStateFromLockedReason(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSimStateFromLockedReason", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$getSimStateFromLockedReason(java.lang.String ), 0, (String)string2);
    }

    private void handleSimLoaded(int n) {
        InvokeDynamicSupport.bootstrap("handleSimLoaded", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimLoaded(int ), 0, this, n);
    }

    private void updateCarrierServices(int n, String string2) {
        InvokeDynamicSupport.bootstrap("updateCarrierServices", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateCarrierServices(int java.lang.String ), 0, this, n, string2);
    }

    private void handleSimAbsent(int n) {
        InvokeDynamicSupport.bootstrap("handleSimAbsent", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimAbsent(int ), 0, this, n);
    }

    private void handleSimError(int n) {
        InvokeDynamicSupport.bootstrap("handleSimError", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$handleSimError(int ), 0, this, n);
    }

    private synchronized void updateSubscriptionInfoByIccId() {
        InvokeDynamicSupport.bootstrap("updateSubscriptionInfoByIccId", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateSubscriptionInfoByIccId(), 0, this);
    }

    public boolean updateEmbeddedSubscriptions() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateEmbeddedSubscriptions", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$updateEmbeddedSubscriptions(), 0, this);
    }

    private static int findSubscriptionInfoForIccid(List<SubscriptionInfo> list, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findSubscriptionInfoForIccid", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$findSubscriptionInfoForIccid(java.util.List<android.telephony.SubscriptionInfo> java.lang.String ), 0, list, (String)string2);
    }

    private boolean isNewSim(String string2, String string3, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNewSim", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$isNewSim(java.lang.String java.lang.String java.lang.String[] ), 0, this, string2, string3, stringArray);
    }

    private void broadcastSimStateChanged(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("broadcastSimStateChanged", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimStateChanged(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    private void broadcastSimCardStateChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("broadcastSimCardStateChanged", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimCardStateChanged(int int ), 0, this, n, n2);
    }

    private void broadcastSimApplicationStateChanged(int n, int n2) {
        InvokeDynamicSupport.bootstrap("broadcastSimApplicationStateChanged", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$broadcastSimApplicationStateChanged(int int ), 0, this, n, n2);
    }

    private static String simStateString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("simStateString", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$simStateString(int ), 0, (int)n);
    }

    private void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$logd(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionInfoUpdater$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionInfoUpdater.class);
    }

    public /* synthetic */ SubscriptionInfoUpdater() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionInfoUpdater)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

