/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.SubscriptionController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionMonitor
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private RegistrantList[] mSubscriptionsChangedRegistrants;
    private RegistrantList[] mDefaultDataSubChangedRegistrants;
    private SubscriptionController mSubscriptionController;
    private Context mContext;
    private int[] mPhoneSubId;
    private int mDefaultDataSubId;
    private int mDefaultDataPhoneId;
    private Object mLock;
    private static boolean VDBG = true;
    private static String LOG_TAG = "SubscriptionMonitor";
    private static int MAX_LOGLINES = 100;
    private LocalLog mLocalLog;
    private IOnSubscriptionsChangedListener mSubscriptionsChangedListener;
    private BroadcastReceiver mDefaultDataSubscriptionChangedReceiver;

    private void $$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__(ITelephonyRegistry tr, Context context, SubscriptionController subscriptionController, int numPhones) {
        this.mLock = new Object();
        this.mLocalLog = new LocalLog(100);
        this.mSubscriptionsChangedListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubscriptionMonitor this$0;

            private void $$robo$$com_android_internal_telephony_SubscriptionMonitor_1$__constructor__(SubscriptionMonitor this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor_1$onSubscriptionsChanged() {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    int newDefaultDataPhoneId = -1;
                    for (int phoneId = 0; phoneId < this.this$0.mPhoneSubId.length; ++phoneId) {
                        int newSubId = this.this$0.mSubscriptionController.getSubIdUsingPhoneId(phoneId);
                        int oldSubId = this.this$0.mPhoneSubId[phoneId];
                        if (oldSubId != newSubId) {
                            this.this$0.log("Phone[" + phoneId + "] subId changed " + oldSubId + "->" + newSubId + ", " + this.this$0.mSubscriptionsChangedRegistrants[phoneId].size() + " registrants");
                            ((SubscriptionMonitor)this.this$0).mPhoneSubId[phoneId] = newSubId;
                            this.this$0.mSubscriptionsChangedRegistrants[phoneId].notifyRegistrants();
                            if (this.this$0.mDefaultDataSubId == -1) continue;
                            if (newSubId == this.this$0.mDefaultDataSubId || oldSubId == this.this$0.mDefaultDataSubId) {
                                this.this$0.log("mDefaultDataSubId = " + this.this$0.mDefaultDataSubId + ", " + this.this$0.mDefaultDataSubChangedRegistrants[phoneId].size() + " registrants");
                                this.this$0.mDefaultDataSubChangedRegistrants[phoneId].notifyRegistrants();
                            }
                        }
                        if (newSubId != this.this$0.mDefaultDataSubId) continue;
                        newDefaultDataPhoneId = phoneId;
                    }
                    this.this$0.mDefaultDataPhoneId = newDefaultDataPhoneId;
                }
            }

            private void __constructor__(SubscriptionMonitor subscriptionMonitor) {
                this.$$robo$$com_android_internal_telephony_SubscriptionMonitor_1$__constructor__(subscriptionMonitor);
            }
            {
                this.this$0 = subscriptionMonitor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionMonitor_1$__constructor__(com.android.internal.telephony.SubscriptionMonitor ), 0, this, subscriptionMonitor);
            }

            @Override
            public void onSubscriptionsChanged() {
                InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$com_android_internal_telephony_SubscriptionMonitor_1$onSubscriptionsChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDefaultDataSubscriptionChangedReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SubscriptionMonitor this$0;

            private void $$robo$$com_android_internal_telephony_SubscriptionMonitor_2$__constructor__(SubscriptionMonitor this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor_2$onReceive(Context context, Intent intent) {
                int newDefaultDataSubId = this.this$0.mSubscriptionController.getDefaultDataSubId();
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mDefaultDataSubId != newDefaultDataSubId) {
                        this.this$0.log("Default changed " + this.this$0.mDefaultDataSubId + "->" + newDefaultDataSubId);
                        int oldDefaultDataSubId = this.this$0.mDefaultDataSubId;
                        int oldDefaultDataPhoneId = this.this$0.mDefaultDataPhoneId;
                        this.this$0.mDefaultDataSubId = newDefaultDataSubId;
                        int newDefaultDataPhoneId = this.this$0.mSubscriptionController.getPhoneId(-1);
                        if (newDefaultDataSubId != -1) {
                            for (int phoneId = 0; phoneId < this.this$0.mPhoneSubId.length; ++phoneId) {
                                if (this.this$0.mPhoneSubId[phoneId] != newDefaultDataSubId) continue;
                                newDefaultDataPhoneId = phoneId;
                                this.this$0.log("newDefaultDataPhoneId=" + newDefaultDataPhoneId);
                                break;
                            }
                        }
                        if (newDefaultDataPhoneId != oldDefaultDataPhoneId) {
                            this.this$0.log("Default phoneId changed " + oldDefaultDataPhoneId + "->" + newDefaultDataPhoneId + ", " + (this.this$0.invalidPhoneId(oldDefaultDataPhoneId) ? 0 : this.this$0.mDefaultDataSubChangedRegistrants[oldDefaultDataPhoneId].size()) + "," + (this.this$0.invalidPhoneId(newDefaultDataPhoneId) ? 0 : this.this$0.mDefaultDataSubChangedRegistrants[newDefaultDataPhoneId].size()) + " registrants");
                            this.this$0.mDefaultDataPhoneId = newDefaultDataPhoneId;
                            if (!this.this$0.invalidPhoneId(oldDefaultDataPhoneId)) {
                                this.this$0.mDefaultDataSubChangedRegistrants[oldDefaultDataPhoneId].notifyRegistrants();
                            }
                            if (!this.this$0.invalidPhoneId(newDefaultDataPhoneId)) {
                                this.this$0.mDefaultDataSubChangedRegistrants[newDefaultDataPhoneId].notifyRegistrants();
                            }
                        }
                    }
                }
            }

            private void __constructor__(SubscriptionMonitor subscriptionMonitor) {
                this.$$robo$$com_android_internal_telephony_SubscriptionMonitor_2$__constructor__(subscriptionMonitor);
            }
            {
                this.this$0 = subscriptionMonitor;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionMonitor_2$__constructor__(com.android.internal.telephony.SubscriptionMonitor ), 0, this, subscriptionMonitor);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SubscriptionMonitor_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            tr.addOnSubscriptionsChangedListener(context.getOpPackageName(), this.mSubscriptionsChangedListener);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mSubscriptionController = subscriptionController;
        this.mContext = context;
        this.mSubscriptionsChangedRegistrants = new RegistrantList[numPhones];
        this.mDefaultDataSubChangedRegistrants = new RegistrantList[numPhones];
        this.mPhoneSubId = new int[numPhones];
        this.mDefaultDataSubId = this.mSubscriptionController.getDefaultDataSubId();
        this.mDefaultDataPhoneId = this.mSubscriptionController.getPhoneId(this.mDefaultDataSubId);
        for (int phoneId = 0; phoneId < numPhones; ++phoneId) {
            this.mSubscriptionsChangedRegistrants[phoneId] = new RegistrantList();
            this.mDefaultDataSubChangedRegistrants[phoneId] = new RegistrantList();
            this.mPhoneSubId[phoneId] = this.mSubscriptionController.getSubIdUsingPhoneId(phoneId);
        }
        this.mContext.registerReceiver(this.mDefaultDataSubscriptionChangedReceiver, new IntentFilter("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED"));
    }

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__() {
        this.mLock = new Object();
        this.mLocalLog = new LocalLog(100);
        this.mSubscriptionsChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mDefaultDataSubscriptionChangedReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mSubscriptionsChangedRegistrants = null;
        this.mDefaultDataSubChangedRegistrants = null;
        this.mSubscriptionController = null;
        this.mContext = null;
        this.mPhoneSubId = null;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$registerForSubscriptionChanged(int phoneId, Handler h, int what, Object o) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        Registrant r = new Registrant(h, what, o);
        this.mSubscriptionsChangedRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$unregisterForSubscriptionChanged(int phoneId, Handler h) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        this.mSubscriptionsChangedRegistrants[phoneId].remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$registerForDefaultDataSubscriptionChanged(int phoneId, Handler h, int what, Object o) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        Registrant r = new Registrant(h, what, o);
        this.mDefaultDataSubChangedRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$unregisterForDefaultDataSubscriptionChanged(int phoneId, Handler h) {
        if (this.invalidPhoneId(phoneId)) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
        this.mDefaultDataSubChangedRegistrants[phoneId].remove(h);
    }

    private final boolean $$robo$$com_android_internal_telephony_SubscriptionMonitor$invalidPhoneId(int phoneId) {
        return phoneId < 0 || phoneId >= this.mPhoneSubId.length;
    }

    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$log(String s) {
        Rlog.d("SubscriptionMonitor", s);
        this.mLocalLog.log(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_SubscriptionMonitor$dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalLog.dump(fd, printWriter, args);
        }
    }

    private void __constructor__(ITelephonyRegistry iTelephonyRegistry, Context context, SubscriptionController subscriptionController, int n) {
        this.$$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__(iTelephonyRegistry, context, subscriptionController, n);
    }

    public SubscriptionMonitor(ITelephonyRegistry iTelephonyRegistry, Context context, SubscriptionController subscriptionController, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__(com.android.internal.telephony.ITelephonyRegistry android.content.Context com.android.internal.telephony.SubscriptionController int ), 0, this, iTelephonyRegistry, context, subscriptionController, n);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__();
    }

    public SubscriptionMonitor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SubscriptionMonitor$__constructor__(), 0, this);
    }

    public void registerForSubscriptionChanged(int n, Handler handler, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionChanged", $$robo$$com_android_internal_telephony_SubscriptionMonitor$registerForSubscriptionChanged(int android.os.Handler int java.lang.Object ), 0, this, n, handler, n2, object);
    }

    public void unregisterForSubscriptionChanged(int n, Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionChanged", $$robo$$com_android_internal_telephony_SubscriptionMonitor$unregisterForSubscriptionChanged(int android.os.Handler ), 0, this, n, handler);
    }

    public void registerForDefaultDataSubscriptionChanged(int n, Handler handler, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDefaultDataSubscriptionChanged", $$robo$$com_android_internal_telephony_SubscriptionMonitor$registerForDefaultDataSubscriptionChanged(int android.os.Handler int java.lang.Object ), 0, this, n, handler, n2, object);
    }

    public void unregisterForDefaultDataSubscriptionChanged(int n, Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDefaultDataSubscriptionChanged", $$robo$$com_android_internal_telephony_SubscriptionMonitor$unregisterForDefaultDataSubscriptionChanged(int android.os.Handler ), 0, this, n, handler);
    }

    private boolean invalidPhoneId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("invalidPhoneId", $$robo$$com_android_internal_telephony_SubscriptionMonitor$invalidPhoneId(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_SubscriptionMonitor$log(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SubscriptionMonitor$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionMonitor)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

