/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.HardwareConfig;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyDevController
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TDC";
    private static boolean DBG = true;
    private static Object mLock;
    private static int EVENT_HARDWARE_CONFIG_CHANGED = 1;
    private static TelephonyDevController sTelephonyDevController;
    private static ArrayList<HardwareConfig> mModems;
    private static ArrayList<HardwareConfig> mSims;
    private static Message sRilHardwareConfig;

    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$logd(String s) {
        Rlog.d("TDC", s);
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$loge(String s) {
        Rlog.e("TDC", s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TelephonyDevController $$robo$$com_android_internal_telephony_TelephonyDevController$create() {
        Object object = mLock;
        synchronized (object) {
            if (sTelephonyDevController != null) {
                throw new RuntimeException("TelephonyDevController already created!?!");
            }
            sTelephonyDevController = new TelephonyDevController();
            return sTelephonyDevController;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TelephonyDevController $$robo$$com_android_internal_telephony_TelephonyDevController$getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (sTelephonyDevController == null) {
                throw new RuntimeException("TelephonyDevController not yet created!?!");
            }
            return sTelephonyDevController;
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyDevController$initFromResource() {
        Resources resource = Resources.getSystem();
        String[] hwStrings = resource.getStringArray(17236042);
        if (hwStrings != null) {
            for (String hwString : hwStrings) {
                HardwareConfig hw = new HardwareConfig(hwString);
                if (hw == null) continue;
                if (hw.type == 0) {
                    TelephonyDevController.updateOrInsert(hw, mModems);
                    continue;
                }
                if (hw.type != 1) continue;
                TelephonyDevController.updateOrInsert(hw, mSims);
            }
        }
    }

    private void $$robo$$com_android_internal_telephony_TelephonyDevController$__constructor__() {
        this.initFromResource();
        mModems.trimToSize();
        mSims.trimToSize();
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$registerRIL(CommandsInterface cmdsIf) {
        cmdsIf.getHardwareConfig(sRilHardwareConfig);
        if (sRilHardwareConfig != null) {
            AsyncResult ar = (AsyncResult)TelephonyDevController.sRilHardwareConfig.obj;
            if (ar.exception == null) {
                TelephonyDevController.handleGetHardwareConfigChanged(ar);
            }
        }
        cmdsIf.registerForHardwareConfigChanged(sTelephonyDevController, 1, null);
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$unregisterRIL(CommandsInterface cmdsIf) {
        cmdsIf.unregisterForHardwareConfigChanged(sTelephonyDevController);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyDevController$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                TelephonyDevController.logd("handleMessage: received EVENT_HARDWARE_CONFIG_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                TelephonyDevController.handleGetHardwareConfigChanged(ar);
                break;
            }
            default: {
                TelephonyDevController.loge("handleMessage: Unknown Event " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$updateOrInsert(HardwareConfig hw, ArrayList<HardwareConfig> list) {
        Object object = mLock;
        synchronized (object) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                HardwareConfig item = list.get(i);
                if (item.uuid.compareTo(hw.uuid) != 0) continue;
                TelephonyDevController.logd("updateOrInsert: removing: " + item);
                list.remove(i);
                break;
            }
            TelephonyDevController.logd("updateOrInsert: inserting: " + hw);
            list.add(hw);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyDevController$handleGetHardwareConfigChanged(AsyncResult ar) {
        if (ar.exception == null && ar.result != null) {
            List hwcfg = (List)ar.result;
            for (int i = 0; i < hwcfg.size(); ++i) {
                HardwareConfig hw = null;
                hw = (HardwareConfig)hwcfg.get(i);
                if (hw == null) continue;
                if (hw.type == 0) {
                    TelephonyDevController.updateOrInsert(hw, mModems);
                    continue;
                }
                if (hw.type != 1) continue;
                TelephonyDevController.updateOrInsert(hw, mSims);
            }
        } else {
            TelephonyDevController.loge("handleGetHardwareConfigChanged - returned an error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$com_android_internal_telephony_TelephonyDevController$getModemCount() {
        Object object = mLock;
        synchronized (object) {
            int count = mModems.size();
            TelephonyDevController.logd("getModemCount: " + count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HardwareConfig $$robo$$com_android_internal_telephony_TelephonyDevController$getModem(int index) {
        Object object = mLock;
        synchronized (object) {
            if (mModems.isEmpty()) {
                TelephonyDevController.loge("getModem: no registered modem device?!?");
                return null;
            }
            if (index > TelephonyDevController.getModemCount()) {
                TelephonyDevController.loge("getModem: out-of-bounds access for modem device " + index + " max: " + TelephonyDevController.getModemCount());
                return null;
            }
            TelephonyDevController.logd("getModem: " + index);
            return mModems.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_TelephonyDevController$getSimCount() {
        Object object = mLock;
        synchronized (object) {
            int count = mSims.size();
            TelephonyDevController.logd("getSimCount: " + count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HardwareConfig $$robo$$com_android_internal_telephony_TelephonyDevController$getSim(int index) {
        Object object = mLock;
        synchronized (object) {
            if (mSims.isEmpty()) {
                TelephonyDevController.loge("getSim: no registered sim device?!?");
                return null;
            }
            if (index > this.getSimCount()) {
                TelephonyDevController.loge("getSim: out-of-bounds access for sim device " + index + " max: " + this.getSimCount());
                return null;
            }
            TelephonyDevController.logd("getSim: " + index);
            return mSims.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HardwareConfig $$robo$$com_android_internal_telephony_TelephonyDevController$getModemForSim(int simIndex) {
        Object object = mLock;
        synchronized (object) {
            if (mModems.isEmpty() || mSims.isEmpty()) {
                TelephonyDevController.loge("getModemForSim: no registered modem/sim device?!?");
                return null;
            }
            if (simIndex > this.getSimCount()) {
                TelephonyDevController.loge("getModemForSim: out-of-bounds access for sim device " + simIndex + " max: " + this.getSimCount());
                return null;
            }
            TelephonyDevController.logd("getModemForSim " + simIndex);
            HardwareConfig sim = this.getSim(simIndex);
            for (HardwareConfig modem : mModems) {
                if (!modem.uuid.equals(sim.modemUuid)) continue;
                return modem;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<HardwareConfig> $$robo$$com_android_internal_telephony_TelephonyDevController$getAllSimsForModem(int modemIndex) {
        Object object = mLock;
        synchronized (object) {
            if (mSims.isEmpty()) {
                TelephonyDevController.loge("getAllSimsForModem: no registered sim device?!?");
                return null;
            }
            if (modemIndex > TelephonyDevController.getModemCount()) {
                TelephonyDevController.loge("getAllSimsForModem: out-of-bounds access for modem device " + modemIndex + " max: " + TelephonyDevController.getModemCount());
                return null;
            }
            TelephonyDevController.logd("getAllSimsForModem " + modemIndex);
            ArrayList<HardwareConfig> result = new ArrayList<HardwareConfig>();
            HardwareConfig modem = this.getModem(modemIndex);
            for (HardwareConfig sim : mSims) {
                if (!sim.modemUuid.equals(modem.uuid)) continue;
                result.add(sim);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<HardwareConfig> $$robo$$com_android_internal_telephony_TelephonyDevController$getAllModems() {
        Object object = mLock;
        synchronized (object) {
            ArrayList<HardwareConfig> modems = new ArrayList<HardwareConfig>();
            if (mModems.isEmpty()) {
                TelephonyDevController.logd("getAllModems: empty list.");
            } else {
                for (HardwareConfig modem : mModems) {
                    modems.add(modem);
                }
            }
            return modems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<HardwareConfig> $$robo$$com_android_internal_telephony_TelephonyDevController$getAllSims() {
        Object object = mLock;
        synchronized (object) {
            ArrayList<HardwareConfig> sims = new ArrayList<HardwareConfig>();
            if (mSims.isEmpty()) {
                TelephonyDevController.logd("getAllSims: empty list.");
            } else {
                for (HardwareConfig sim : mSims) {
                    sims.add(sim);
                }
            }
            return sims;
        }
    }

    static void __staticInitializer__() {
        mLock = new Object();
        mModems = new ArrayList();
        mSims = new ArrayList();
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$com_android_internal_telephony_TelephonyDevController$logd(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_TelephonyDevController$loge(java.lang.String ), 0, (String)string2);
    }

    public static TelephonyDevController create() {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_telephony_TelephonyDevController$create(), 0);
    }

    public static TelephonyDevController getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_TelephonyDevController$getInstance(), 0);
    }

    private void initFromResource() {
        InvokeDynamicSupport.bootstrap("initFromResource", $$robo$$com_android_internal_telephony_TelephonyDevController$initFromResource(), 0, this);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_TelephonyDevController$__constructor__();
    }

    private TelephonyDevController() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyDevController$__constructor__(), 0, this);
    }

    public static void registerRIL(CommandsInterface commandsInterface) {
        InvokeDynamicSupport.bootstrapStatic("registerRIL", $$robo$$com_android_internal_telephony_TelephonyDevController$registerRIL(com.android.internal.telephony.CommandsInterface ), 0, (CommandsInterface)commandsInterface);
    }

    public static void unregisterRIL(CommandsInterface commandsInterface) {
        InvokeDynamicSupport.bootstrapStatic("unregisterRIL", $$robo$$com_android_internal_telephony_TelephonyDevController$unregisterRIL(com.android.internal.telephony.CommandsInterface ), 0, (CommandsInterface)commandsInterface);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_TelephonyDevController$handleMessage(android.os.Message ), 0, this, message);
    }

    private static void updateOrInsert(HardwareConfig hardwareConfig, ArrayList<HardwareConfig> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("updateOrInsert", $$robo$$com_android_internal_telephony_TelephonyDevController$updateOrInsert(com.android.internal.telephony.HardwareConfig java.util.ArrayList<com.android.internal.telephony.HardwareConfig> ), 0, (HardwareConfig)hardwareConfig, arrayList);
    }

    private static void handleGetHardwareConfigChanged(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrapStatic("handleGetHardwareConfigChanged", $$robo$$com_android_internal_telephony_TelephonyDevController$handleGetHardwareConfigChanged(android.os.AsyncResult ), 0, (AsyncResult)asyncResult);
    }

    public static int getModemCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getModemCount", $$robo$$com_android_internal_telephony_TelephonyDevController$getModemCount(), 0);
    }

    public HardwareConfig getModem(int n) {
        return InvokeDynamicSupport.bootstrap("getModem", $$robo$$com_android_internal_telephony_TelephonyDevController$getModem(int ), 0, this, n);
    }

    public int getSimCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSimCount", $$robo$$com_android_internal_telephony_TelephonyDevController$getSimCount(), 0, this);
    }

    public HardwareConfig getSim(int n) {
        return InvokeDynamicSupport.bootstrap("getSim", $$robo$$com_android_internal_telephony_TelephonyDevController$getSim(int ), 0, this, n);
    }

    public HardwareConfig getModemForSim(int n) {
        return InvokeDynamicSupport.bootstrap("getModemForSim", $$robo$$com_android_internal_telephony_TelephonyDevController$getModemForSim(int ), 0, this, n);
    }

    public ArrayList<HardwareConfig> getAllSimsForModem(int n) {
        return InvokeDynamicSupport.bootstrap("getAllSimsForModem", $$robo$$com_android_internal_telephony_TelephonyDevController$getAllSimsForModem(int ), 0, this, n);
    }

    public ArrayList<HardwareConfig> getAllModems() {
        return InvokeDynamicSupport.bootstrap("getAllModems", $$robo$$com_android_internal_telephony_TelephonyDevController$getAllModems(), 0, this);
    }

    public ArrayList<HardwareConfig> getAllSims() {
        return InvokeDynamicSupport.bootstrap("getAllSims", $$robo$$com_android_internal_telephony_TelephonyDevController$getAllSims(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyDevController.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyDevController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

