/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.SubscriptionManager;
import android.telephony.cdma.CdmaSmsCbProgramData;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.WakeLockStateMachine;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.BearerData;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CdmaServiceCategoryProgramHandler
extends WakeLockStateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    CommandsInterface mCi;
    private BroadcastReceiver mScpResultsReceiver;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$__constructor__(Context context, CommandsInterface commandsInterface) {
        this.mScpResultsReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CdmaServiceCategoryProgramHandler this$0;

            private void $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$__constructor__(CdmaServiceCategoryProgramHandler this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$onReceive(Context context, Intent intent) {
                this.sendScpResults();
                this.this$0.log("mScpResultsReceiver finished");
                this.this$0.sendMessage(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$sendScpResults() {
                int resultCode = this.getResultCode();
                if (resultCode != -1 && resultCode != 1) {
                    this.this$0.loge("SCP results error: result code = " + resultCode);
                    return;
                }
                Bundle extras = this.getResultExtras(false);
                if (extras == null) {
                    this.this$0.loge("SCP results error: missing extras");
                    return;
                }
                String sender = extras.getString("sender");
                if (sender == null) {
                    this.this$0.loge("SCP results error: missing sender extra.");
                    return;
                }
                ArrayList results = extras.getParcelableArrayList("results");
                if (results == null) {
                    this.this$0.loge("SCP results error: missing results extra.");
                    return;
                }
                BearerData bData = new BearerData();
                bData.messageType = 2;
                bData.messageId = SmsMessage.getNextMessageId();
                bData.serviceCategoryProgramResults = results;
                byte[] encodedBearerData = BearerData.encode(bData);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
                DataOutputStream dos = new DataOutputStream(baos);
                try {
                    dos.writeInt(4102);
                    dos.writeInt(0);
                    dos.writeInt(0);
                    CdmaSmsAddress destAddr = CdmaSmsAddress.parse(PhoneNumberUtils.cdmaCheckAndProcessPlusCodeForSms(sender));
                    dos.write(destAddr.digitMode);
                    dos.write(destAddr.numberMode);
                    dos.write(destAddr.ton);
                    dos.write(destAddr.numberPlan);
                    dos.write(destAddr.numberOfDigits);
                    dos.write(destAddr.origBytes, 0, destAddr.origBytes.length);
                    dos.write(0);
                    dos.write(0);
                    dos.write(0);
                    dos.write(encodedBearerData.length);
                    dos.write(encodedBearerData, 0, encodedBearerData.length);
                    this.this$0.mCi.sendCdmaSms(baos.toByteArray(), null);
                }
                catch (IOException e) {
                    this.this$0.loge("exception creating SCP results PDU", e);
                }
                finally {
                    try {
                        dos.close();
                    }
                    catch (IOException iOException) {}
                }
            }

            private void __constructor__(CdmaServiceCategoryProgramHandler cdmaServiceCategoryProgramHandler) {
                this.$$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$__constructor__(cdmaServiceCategoryProgramHandler);
            }
            {
                this.this$0 = cdmaServiceCategoryProgramHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$__constructor__(com.android.internal.telephony.cdma.CdmaServiceCategoryProgramHandler ), 0, this, cdmaServiceCategoryProgramHandler);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }

            private void sendScpResults() {
                InvokeDynamicSupport.bootstrap("sendScpResults", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler_1$sendScpResults(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mCi = commandsInterface;
    }

    private static final CdmaServiceCategoryProgramHandler $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$makeScpHandler(Context context, CommandsInterface commandsInterface) {
        CdmaServiceCategoryProgramHandler handler = new CdmaServiceCategoryProgramHandler(context, commandsInterface);
        handler.start();
        return handler;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$handleSmsMessage(Message message) {
        if (message.obj instanceof SmsMessage) {
            return this.handleServiceCategoryProgramData((SmsMessage)message.obj);
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$handleServiceCategoryProgramData(SmsMessage sms) {
        ArrayList<CdmaSmsCbProgramData> programDataList = sms.getSmsCbProgramData();
        if (programDataList == null) {
            this.loge("handleServiceCategoryProgramData: program data list is null!");
            return false;
        }
        Intent intent = new Intent("android.provider.Telephony.SMS_SERVICE_CATEGORY_PROGRAM_DATA_RECEIVED");
        intent.setPackage(this.mContext.getResources().getString(17039652));
        intent.putExtra("sender", sms.getOriginatingAddress());
        intent.putParcelableArrayListExtra("program_data", programDataList);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        this.mContext.sendOrderedBroadcast(intent, "android.permission.RECEIVE_SMS", 16, this.mScpResultsReceiver, this.getHandler(), -1, null, null);
        return true;
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$__constructor__(context, commandsInterface);
    }

    CdmaServiceCategoryProgramHandler(Context context, CommandsInterface commandsInterface) {
        super("CdmaServiceCategoryProgramHandler", context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, context, commandsInterface);
    }

    static CdmaServiceCategoryProgramHandler makeScpHandler(Context context, CommandsInterface commandsInterface) {
        return InvokeDynamicSupport.bootstrapStatic("makeScpHandler", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$makeScpHandler(android.content.Context com.android.internal.telephony.CommandsInterface ), 0, (Context)context, (CommandsInterface)commandsInterface);
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleSmsMessage", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$handleSmsMessage(android.os.Message ), 0, this, message);
    }

    private boolean handleServiceCategoryProgramData(SmsMessage smsMessage) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleServiceCategoryProgramData", $$robo$$com_android_internal_telephony_cdma_CdmaServiceCategoryProgramHandler$handleServiceCategoryProgramData(com.android.internal.telephony.cdma.SmsMessage ), 0, this, smsMessage);
    }

    public /* synthetic */ CdmaServiceCategoryProgramHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaServiceCategoryProgramHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

