/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.provider.Settings;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CdmaSubscriptionSourceManager
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "CdmaSSM";
    private static int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 1;
    private static int EVENT_GET_CDMA_SUBSCRIPTION_SOURCE = 2;
    private static int EVENT_RADIO_ON = 3;
    private static int EVENT_SUBSCRIPTION_STATUS_CHANGED = 4;
    private static int SUBSCRIPTION_ACTIVATED = 1;
    public static int SUBSCRIPTION_SOURCE_UNKNOWN = -1;
    public static int SUBSCRIPTION_FROM_RUIM = 0;
    public static int SUBSCRIPTION_FROM_NV = 1;
    private static CdmaSubscriptionSourceManager sInstance;
    private static Object sReferenceCountMonitor;
    private static int sReferenceCount;
    private CommandsInterface mCi;
    private RegistrantList mCdmaSubscriptionSourceChangedRegistrants;
    private AtomicInteger mCdmaSubscriptionSource;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$__constructor__(Context context, CommandsInterface ci) {
        this.mCdmaSubscriptionSourceChangedRegistrants = new RegistrantList();
        this.mCdmaSubscriptionSource = new AtomicInteger(0);
        this.mCi = ci;
        this.mCi.registerForCdmaSubscriptionChanged(this, 1, null);
        this.mCi.registerForOn(this, 3, null);
        int subscriptionSource = CdmaSubscriptionSourceManager.getDefault(context);
        this.log("cdmaSSM constructor: " + subscriptionSource);
        this.mCdmaSubscriptionSource.set(subscriptionSource);
        this.mCi.registerForSubscriptionStatusChanged(this, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CdmaSubscriptionSourceManager $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getInstance(Context context, CommandsInterface ci, Handler h, int what, Object obj) {
        Object object = sReferenceCountMonitor;
        synchronized (object) {
            if (null == sInstance) {
                sInstance = new CdmaSubscriptionSourceManager(context, ci);
            }
            ++sReferenceCount;
        }
        sInstance.registerForCdmaSubscriptionSourceChanged(h, what, obj);
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$dispose(Handler h) {
        this.mCdmaSubscriptionSourceChangedRegistrants.remove(h);
        Object object = sReferenceCountMonitor;
        synchronized (object) {
            if (--sReferenceCount <= 0) {
                this.mCi.unregisterForCdmaSubscriptionChanged(this);
                this.mCi.unregisterForOn(this);
                this.mCi.unregisterForSubscriptionStatusChanged(this);
                sInstance = null;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: 
            case 2: {
                this.log("CDMA_SUBSCRIPTION_SOURCE event = " + msg.what);
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handleGetCdmaSubscriptionSource(ar);
                break;
            }
            case 3: {
                this.mCi.getCdmaSubscriptionSource(this.obtainMessage(2));
                break;
            }
            case 4: {
                this.log("EVENT_SUBSCRIPTION_STATUS_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    int actStatus = ((int[])ar.result)[0];
                    this.log("actStatus = " + actStatus);
                    if (actStatus != 1) break;
                    Rlog.v("CdmaSSM", "get Cdma Subscription Source");
                    this.mCi.getCdmaSubscriptionSource(this.obtainMessage(2));
                    break;
                }
                this.logw("EVENT_SUBSCRIPTION_STATUS_CHANGED, Exception:" + ar.exception);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getCdmaSubscriptionSource() {
        this.log("getcdmasubscriptionSource: " + this.mCdmaSubscriptionSource.get());
        return this.mCdmaSubscriptionSource.get();
    }

    private static final int $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getDefault(Context context) {
        int subscriptionSource = Settings.Global.getInt(context.getContentResolver(), "subscription_mode", 0);
        Rlog.d("CdmaSSM", "subscriptionSource from settings: " + subscriptionSource);
        return subscriptionSource;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$registerForCdmaSubscriptionSourceChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCdmaSubscriptionSourceChangedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$handleGetCdmaSubscriptionSource(AsyncResult ar) {
        if (ar.exception == null && ar.result != null) {
            int newSubscriptionSource = ((int[])ar.result)[0];
            if (newSubscriptionSource != this.mCdmaSubscriptionSource.get()) {
                this.log("Subscription Source Changed : " + this.mCdmaSubscriptionSource + " >> " + newSubscriptionSource);
                this.mCdmaSubscriptionSource.set(newSubscriptionSource);
                this.mCdmaSubscriptionSourceChangedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
            }
        } else {
            this.logw("Unable to get CDMA Subscription Source, Exception: " + ar.exception + ", result: " + ar.result);
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$log(String s) {
        Rlog.d("CdmaSSM", s);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$logw(String s) {
        Rlog.w("CdmaSSM", s);
    }

    static void __staticInitializer__() {
        sReferenceCountMonitor = new Object();
        sReferenceCount = 0;
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$__constructor__(context, commandsInterface);
    }

    private CdmaSubscriptionSourceManager(Context context, CommandsInterface commandsInterface) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface ), 0, this, context, commandsInterface);
    }

    public static CdmaSubscriptionSourceManager getInstance(Context context, CommandsInterface commandsInterface, Handler handler, int n, Object object) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getInstance(android.content.Context com.android.internal.telephony.CommandsInterface android.os.Handler int java.lang.Object ), 0, (Context)context, (CommandsInterface)commandsInterface, (Handler)handler, (int)n, (Object)object);
    }

    public void dispose(Handler handler) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$dispose(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$handleMessage(android.os.Message ), 0, this, message);
    }

    public int getCdmaSubscriptionSource() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getCdmaSubscriptionSource(), 0, this);
    }

    public static int getDefault(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$getDefault(android.content.Context ), 0, (Context)context);
    }

    private void registerForCdmaSubscriptionSourceChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaSubscriptionSourceChanged", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$registerForCdmaSubscriptionSourceChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    private void handleGetCdmaSubscriptionSource(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleGetCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$handleGetCdmaSubscriptionSource(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$log(java.lang.String ), 0, this, string2);
    }

    private void logw(String string2) {
        InvokeDynamicSupport.bootstrap("logw", $$robo$$com_android_internal_telephony_cdma_CdmaSubscriptionSourceManager$logw(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(CdmaSubscriptionSourceManager.class);
    }

    public /* synthetic */ CdmaSubscriptionSourceManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaSubscriptionSourceManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

