/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseIntArray;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApnContext
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public String LOG_TAG;
    private static String SLOG_TAG = "ApnContext";
    protected static boolean DBG = false;
    private Phone mPhone;
    private String mApnType;
    private DctConstants.State mState;
    public int priority;
    private ApnSetting mApnSetting;
    DcAsyncChannel mDcAc;
    String mReason;
    PendingIntent mReconnectAlarmIntent;
    AtomicBoolean mDataEnabled;
    private Object mRefCountLock;
    private int mRefCount;
    AtomicBoolean mDependencyMet;
    private DcTracker mDcTracker;
    private boolean mConcurrentVoiceAndDataAllowed;
    private AtomicInteger mConnectionGeneration;
    private RetryManager mRetryManager;
    private ArrayList<LocalLog> mLocalLogs;
    private ArrayList<NetworkRequest> mNetworkRequests;
    private LocalLog mStateLocalLog;
    private SparseIntArray mRetriesLeftPerErrorCode;

    private void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$__constructor__(Phone phone, String apnType, String logTag, NetworkConfig config, DcTracker tracker) {
        this.mRefCountLock = new Object();
        this.mRefCount = 0;
        this.mConnectionGeneration = new AtomicInteger(0);
        this.mLocalLogs = new ArrayList();
        this.mNetworkRequests = new ArrayList();
        this.mStateLocalLog = new LocalLog(50);
        this.mRetriesLeftPerErrorCode = new SparseIntArray();
        this.mPhone = phone;
        this.mApnType = apnType;
        this.mState = DctConstants.State.IDLE;
        this.setReason("dataEnabled");
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(config.dependencyMet);
        this.priority = config.priority;
        this.LOG_TAG = logTag;
        this.mDcTracker = tracker;
        this.mRetryManager = new RetryManager(phone, apnType);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getApnType() {
        return this.mApnType;
    }

    private final synchronized DcAsyncChannel $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDcAc() {
        return this.mDcAc;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setDataConnectionAc(DcAsyncChannel dcac) {
        this.mDcAc = dcac;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$releaseDataConnection(String reason) {
        if (this.mDcAc != null) {
            this.mDcAc.tearDown(this, reason, null);
            this.mDcAc = null;
        }
        this.setState(DctConstants.State.IDLE);
    }

    private final synchronized PendingIntent $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getReconnectIntent() {
        return this.mReconnectAlarmIntent;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setReconnectIntent(PendingIntent intent) {
        this.mReconnectAlarmIntent = intent;
    }

    private final synchronized ApnSetting $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getApnSetting() {
        return this.mApnSetting;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setApnSetting(ApnSetting apnSetting) {
        this.mApnSetting = apnSetting;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mRetryManager.setWaitingApns(waitingApns);
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getNextApnSetting() {
        return this.mRetryManager.getNextApnSetting();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setModemSuggestedDelay(long delay) {
        this.mRetryManager.setModemSuggestedDelay(delay);
    }

    private final long $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDelayForNextApn(boolean failFastEnabled) {
        return this.mRetryManager.getDelayForNextApn(failFastEnabled || this.isFastRetryReason());
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$markApnPermanentFailed(ApnSetting apn) {
        this.mRetryManager.markApnPermanentFailed(apn);
    }

    private final ArrayList<ApnSetting> $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getWaitingApns() {
        return this.mRetryManager.getWaitingApns();
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setConcurrentVoiceAndDataAllowed(boolean allowed) {
        this.mConcurrentVoiceAndDataAllowed = allowed;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConcurrentVoiceAndDataAllowed() {
        return this.mConcurrentVoiceAndDataAllowed;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setState(DctConstants.State s) {
        if (this.mState != s) {
            this.mStateLocalLog.log("State changed from " + (Object)((Object)this.mState) + " to " + (Object)((Object)s));
            this.mState = s;
        }
        if (this.mState == DctConstants.State.FAILED && this.mRetryManager.getWaitingApns() != null) {
            this.mRetryManager.getWaitingApns().clear();
        }
    }

    private final synchronized DctConstants.State $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getState() {
        return this.mState;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isDisconnected() {
        DctConstants.State currentState = this.getState();
        return currentState == DctConstants.State.IDLE || currentState == DctConstants.State.FAILED;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setReason(String reason) {
        this.mReason = reason;
    }

    private final synchronized String $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getReason() {
        return this.mReason;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConnectable() {
        return this.isReady() && (this.mState == DctConstants.State.IDLE || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING || this.mState == DctConstants.State.FAILED);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isFastRetryReason() {
        return "nwTypeChanged".equals(this.mReason) || "apnChanged".equals(this.mReason);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConnectedOrConnecting() {
        return this.isReady() && (this.mState == DctConstants.State.CONNECTED || this.mState == DctConstants.State.CONNECTING || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setEnabled(boolean enabled) {
        this.mDataEnabled.set(enabled);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isEnabled() {
        return this.mDataEnabled.get();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setDependencyMet(boolean met) {
        this.mDependencyMet.set(met);
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDependencyMet() {
        return this.mDependencyMet.get();
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isProvisioningApn() {
        String provisioningApn = this.mPhone.getContext().getResources().getString(17040324);
        if (!TextUtils.isEmpty(provisioningApn) && this.mApnSetting != null && this.mApnSetting.apn != null) {
            return this.mApnSetting.apn.equals(provisioningApn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$requestLog(String str) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (LocalLog l : this.mLocalLogs) {
                l.log(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$requestNetwork(NetworkRequest networkRequest, LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (this.mLocalLogs.contains(log) || this.mNetworkRequests.contains(networkRequest)) {
                log.log("ApnContext.requestNetwork has duplicate add - " + this.mNetworkRequests.size());
            } else {
                this.mLocalLogs.add(log);
                this.mNetworkRequests.add(networkRequest);
                this.mDcTracker.setEnabled(ApnContext.apnIdForApnName(this.mApnType), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$releaseNetwork(NetworkRequest networkRequest, LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (!this.mLocalLogs.contains(log)) {
                log.log("ApnContext.releaseNetwork can't find this log");
            } else {
                this.mLocalLogs.remove(log);
            }
            if (!this.mNetworkRequests.contains(networkRequest)) {
                log.log("ApnContext.releaseNetwork can't find this request (" + networkRequest + ")");
            } else {
                this.mNetworkRequests.remove(networkRequest);
                log.log("ApnContext.releaseNetwork left with " + this.mNetworkRequests.size() + " requests.");
                if (this.mNetworkRequests.size() == 0) {
                    this.mDcTracker.setEnabled(ApnContext.apnIdForApnName(this.mApnType), false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<NetworkRequest> $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getNetworkRequests() {
        Object object = this.mRefCountLock;
        synchronized (object) {
            return new ArrayList<NetworkRequest>(this.mNetworkRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$hasNoRestrictedRequests(boolean excludeDun) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (NetworkRequest nr : this.mNetworkRequests) {
                if (excludeDun && nr.networkCapabilities.hasCapability(2) || nr.networkCapabilities.hasCapability(13)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$resetErrorCodeRetries() {
        this.requestLog("ApnContext.resetErrorCodeRetries");
        String[] config = this.mPhone.getContext().getResources().getStringArray(17235995);
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            this.mRetriesLeftPerErrorCode.clear();
            for (String c : config) {
                String[] errorValue = c.split(",");
                if (errorValue != null && errorValue.length == 2) {
                    int count = 0;
                    int errorCode = 0;
                    try {
                        errorCode = Integer.parseInt(errorValue[0]);
                        count = Integer.parseInt(errorValue[1]);
                    }
                    catch (NumberFormatException e) {
                        this.log("Exception parsing config_retries_per_error_code: " + e);
                        continue;
                    }
                    if (count <= 0 || errorCode <= 0) continue;
                    this.mRetriesLeftPerErrorCode.put(errorCode, count);
                    continue;
                }
                this.log("Exception parsing config_retries_per_error_code: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_dataconnection_ApnContext$restartOnError(int errorCode) {
        boolean result = false;
        int retriesLeft = 0;
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            retriesLeft = this.mRetriesLeftPerErrorCode.get(errorCode);
            switch (retriesLeft) {
                case 0: {
                    break;
                }
                case 1: {
                    this.resetErrorCodeRetries();
                    result = true;
                    break;
                }
                default: {
                    this.mRetriesLeftPerErrorCode.put(errorCode, retriesLeft - 1);
                    result = false;
                }
            }
        }
        String str = "ApnContext.restartOnError(" + errorCode + ") found " + retriesLeft + " and returned " + result;
        this.requestLog(str);
        return result;
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_ApnContext$incAndGetConnectionGeneration() {
        return this.mConnectionGeneration.incrementAndGet();
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getConnectionGeneration() {
        return this.mConnectionGeneration.get();
    }

    private final long $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getRetryAfterDisconnectDelay() {
        return this.mRetryManager.getRetryAfterDisconnectDelay();
    }

    private static final int $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForType(int networkType) {
        switch (networkType) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 7;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return -1;
    }

    private static final int $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return -1;
        }
        int apnId = -1;
        boolean error = false;
        if (nc.hasCapability(12)) {
            apnId = 0;
        }
        if (nc.hasCapability(0)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 1;
        }
        if (nc.hasCapability(1)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 2;
        }
        if (nc.hasCapability(2)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 3;
        }
        if (nc.hasCapability(3)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 6;
        }
        if (nc.hasCapability(4)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 5;
        }
        if (nc.hasCapability(5)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 7;
        }
        if (nc.hasCapability(7)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 8;
        }
        if (nc.hasCapability(8)) {
            if (apnId != -1) {
                error = true;
            }
            Rlog.d("ApnContext", "RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (apnId != -1) {
                error = true;
            }
            Rlog.d("ApnContext", "XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 9;
        }
        if (error) {
            Rlog.d("ApnContext", "Multiple apn types specified in request - result is unspecified!");
        }
        if (apnId == -1) {
            Rlog.d("ApnContext", "Unsupported NetworkRequest in Telephony: nr=" + nr);
        }
        return apnId;
    }

    private static final int $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForApnName(String type) {
        switch (type) {
            case "default": {
                return 0;
            }
            case "mms": {
                return 1;
            }
            case "supl": {
                return 2;
            }
            case "dun": {
                return 3;
            }
            case "hipri": {
                return 4;
            }
            case "ims": {
                return 5;
            }
            case "fota": {
                return 6;
            }
            case "cbs": {
                return 7;
            }
            case "ia": {
                return 8;
            }
            case "emergency": {
                return 9;
            }
        }
        return -1;
    }

    private static final String $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnNameForApnId(int id2) {
        switch (id2) {
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: {
                return "hipri";
            }
            case 5: {
                return "ims";
            }
            case 6: {
                return "fota";
            }
            case 7: {
                return "cbs";
            }
            case 8: {
                return "ia";
            }
            case 9: {
                return "emergency";
            }
        }
        Rlog.d("ApnContext", "Unknown id (" + id2 + ") in apnIdToType");
        return "default";
    }

    private final synchronized String $$robo$$com_android_internal_telephony_dataconnection_ApnContext$toString() {
        return "{mApnType=" + this.mApnType + " mState=" + (Object)((Object)this.getState()) + " mWaitingApns={" + this.mRetryManager.getWaitingApns() + "} mApnSetting={" + this.mApnSetting + "} mReason=" + this.mReason + " mDataEnabled=" + this.mDataEnabled + " mDependencyMet=" + this.mDependencyMet + "}";
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$log(String s) {
        Rlog.d(this.LOG_TAG, "[ApnContext:" + this.mApnType + "] " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_dataconnection_ApnContext$dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        Object object = this.mRefCountLock;
        synchronized (object) {
            pw.println(this.toString());
            if (this.mNetworkRequests.size() > 0) {
                pw.println("NetworkRequests:");
                pw.increaseIndent();
                for (NetworkRequest nr : this.mNetworkRequests) {
                    pw.println(nr);
                }
                pw.decreaseIndent();
            }
            pw.increaseIndent();
            for (LocalLog l : this.mLocalLogs) {
                l.dump(fd, pw, args);
                pw.println("-----");
            }
            pw.decreaseIndent();
            pw.println("Historical APN state:");
            pw.increaseIndent();
            this.mStateLocalLog.dump(fd, pw, args);
            pw.decreaseIndent();
            pw.println(this.mRetryManager);
            pw.println("--------------------------");
        }
    }

    private void __constructor__(Phone phone, String string2, String string3, NetworkConfig networkConfig, DcTracker dcTracker) {
        this.$$robo$$com_android_internal_telephony_dataconnection_ApnContext$__constructor__(phone, string2, string3, networkConfig, dcTracker);
    }

    public ApnContext(Phone phone, String string2, String string3, NetworkConfig networkConfig, DcTracker dcTracker) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$__constructor__(com.android.internal.telephony.Phone java.lang.String java.lang.String android.net.NetworkConfig com.android.internal.telephony.dataconnection.DcTracker ), 0, this, phone, string2, string3, networkConfig, dcTracker);
    }

    public String getApnType() {
        return InvokeDynamicSupport.bootstrap("getApnType", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getApnType(), 0, this);
    }

    public synchronized DcAsyncChannel getDcAc() {
        return InvokeDynamicSupport.bootstrap("getDcAc", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDcAc(), 0, this);
    }

    public synchronized void setDataConnectionAc(DcAsyncChannel dcAsyncChannel) {
        InvokeDynamicSupport.bootstrap("setDataConnectionAc", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setDataConnectionAc(com.android.internal.telephony.dataconnection.DcAsyncChannel ), 0, this, dcAsyncChannel);
    }

    public synchronized void releaseDataConnection(String string2) {
        InvokeDynamicSupport.bootstrap("releaseDataConnection", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$releaseDataConnection(java.lang.String ), 0, this, string2);
    }

    public synchronized PendingIntent getReconnectIntent() {
        return InvokeDynamicSupport.bootstrap("getReconnectIntent", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getReconnectIntent(), 0, this);
    }

    public synchronized void setReconnectIntent(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setReconnectIntent", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setReconnectIntent(android.app.PendingIntent ), 0, this, pendingIntent);
    }

    public synchronized ApnSetting getApnSetting() {
        return InvokeDynamicSupport.bootstrap("getApnSetting", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getApnSetting(), 0, this);
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        InvokeDynamicSupport.bootstrap("setApnSetting", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setApnSetting(com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting);
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> arrayList) {
        InvokeDynamicSupport.bootstrap("setWaitingApns", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setWaitingApns(java.util.ArrayList<com.android.internal.telephony.dataconnection.ApnSetting> ), 0, this, arrayList);
    }

    public ApnSetting getNextApnSetting() {
        return InvokeDynamicSupport.bootstrap("getNextApnSetting", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getNextApnSetting(), 0, this);
    }

    public void setModemSuggestedDelay(long l) {
        InvokeDynamicSupport.bootstrap("setModemSuggestedDelay", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setModemSuggestedDelay(long ), 0, this, l);
    }

    public long getDelayForNextApn(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getDelayForNextApn", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDelayForNextApn(boolean ), 0, this, bl);
    }

    public void markApnPermanentFailed(ApnSetting apnSetting) {
        InvokeDynamicSupport.bootstrap("markApnPermanentFailed", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$markApnPermanentFailed(com.android.internal.telephony.dataconnection.ApnSetting ), 0, this, apnSetting);
    }

    public ArrayList<ApnSetting> getWaitingApns() {
        return InvokeDynamicSupport.bootstrap("getWaitingApns", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getWaitingApns(), 0, this);
    }

    public synchronized void setConcurrentVoiceAndDataAllowed(boolean bl) {
        InvokeDynamicSupport.bootstrap("setConcurrentVoiceAndDataAllowed", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setConcurrentVoiceAndDataAllowed(boolean ), 0, this, bl);
    }

    public synchronized boolean isConcurrentVoiceAndDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConcurrentVoiceAndDataAllowed", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConcurrentVoiceAndDataAllowed(), 0, this);
    }

    public synchronized void setState(DctConstants.State state) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setState(com.android.internal.telephony.DctConstants$State ), 0, this, state);
    }

    public synchronized DctConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getState(), 0, this);
    }

    public boolean isDisconnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisconnected", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isDisconnected(), 0, this);
    }

    public synchronized void setReason(String string2) {
        InvokeDynamicSupport.bootstrap("setReason", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setReason(java.lang.String ), 0, this, string2);
    }

    public synchronized String getReason() {
        return InvokeDynamicSupport.bootstrap("getReason", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getReason(), 0, this);
    }

    public boolean isReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReady", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isReady(), 0, this);
    }

    public boolean isConnectable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectable", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConnectable(), 0, this);
    }

    private boolean isFastRetryReason() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFastRetryReason", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isFastRetryReason(), 0, this);
    }

    public boolean isConnectedOrConnecting() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedOrConnecting", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isConnectedOrConnecting(), 0, this);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setEnabled(boolean ), 0, this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isEnabled(), 0, this);
    }

    public void setDependencyMet(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDependencyMet", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$setDependencyMet(boolean ), 0, this, bl);
    }

    public boolean getDependencyMet() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDependencyMet", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getDependencyMet(), 0, this);
    }

    public boolean isProvisioningApn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioningApn", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$isProvisioningApn(), 0, this);
    }

    public void requestLog(String string2) {
        InvokeDynamicSupport.bootstrap("requestLog", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$requestLog(java.lang.String ), 0, this, string2);
    }

    public void requestNetwork(NetworkRequest networkRequest, LocalLog localLog) {
        InvokeDynamicSupport.bootstrap("requestNetwork", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$requestNetwork(android.net.NetworkRequest android.util.LocalLog ), 0, this, networkRequest, localLog);
    }

    public void releaseNetwork(NetworkRequest networkRequest, LocalLog localLog) {
        InvokeDynamicSupport.bootstrap("releaseNetwork", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$releaseNetwork(android.net.NetworkRequest android.util.LocalLog ), 0, this, networkRequest, localLog);
    }

    public List<NetworkRequest> getNetworkRequests() {
        return InvokeDynamicSupport.bootstrap("getNetworkRequests", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getNetworkRequests(), 0, this);
    }

    public boolean hasNoRestrictedRequests(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNoRestrictedRequests", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$hasNoRestrictedRequests(boolean ), 0, this, bl);
    }

    public void resetErrorCodeRetries() {
        InvokeDynamicSupport.bootstrap("resetErrorCodeRetries", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$resetErrorCodeRetries(), 0, this);
    }

    public boolean restartOnError(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("restartOnError", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$restartOnError(int ), 0, this, n);
    }

    public int incAndGetConnectionGeneration() {
        return (int)InvokeDynamicSupport.bootstrap("incAndGetConnectionGeneration", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$incAndGetConnectionGeneration(), 0, this);
    }

    public int getConnectionGeneration() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionGeneration", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getConnectionGeneration(), 0, this);
    }

    long getRetryAfterDisconnectDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getRetryAfterDisconnectDelay", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$getRetryAfterDisconnectDelay(), 0, this);
    }

    public static int apnIdForType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("apnIdForType", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForType(int ), 0, (int)n);
    }

    public static int apnIdForNetworkRequest(NetworkRequest networkRequest) {
        return (int)InvokeDynamicSupport.bootstrapStatic("apnIdForNetworkRequest", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForNetworkRequest(android.net.NetworkRequest ), 0, (NetworkRequest)networkRequest);
    }

    public static int apnIdForApnName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("apnIdForApnName", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnIdForApnName(java.lang.String ), 0, (String)string2);
    }

    private static String apnNameForApnId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("apnNameForApnId", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$apnNameForApnId(int ), 0, (int)n);
    }

    public synchronized String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$toString(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$log(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_ApnContext$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ ApnContext() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApnContext)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

