/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.hardware.radio.V1_0.SetupDataCallResult;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.DataService;
import android.telephony.data.DataServiceCallback;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CellularDataService
extends DataService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    private static int SETUP_DATA_CALL_COMPLETE = 1;
    private static int DEACTIVATE_DATA_ALL_COMPLETE = 2;
    private static int SET_INITIAL_ATTACH_APN_COMPLETE = 3;
    private static int SET_DATA_PROFILE_COMPLETE = 4;
    private static int GET_DATA_CALL_LIST_COMPLETE = 5;
    private static int DATA_CALL_LIST_CHANGED = 6;

    private void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$__constructor__() {
    }

    private final DataService.DataServiceProvider $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$createDataServiceProvider(int slotId) {
        this.log("Cellular data service created for slot " + slotId);
        if (!SubscriptionManager.isValidSlotIndex(slotId)) {
            this.loge("Tried to cellular data service with invalid slotId " + slotId);
            return null;
        }
        return new CellularDataServiceProvider(this, slotId);
    }

    @VisibleForTesting
    private final DataCallResponse $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$convertDataCallResult(SetupDataCallResult dcResult) {
        if (dcResult == null) {
            return null;
        }
        String[] addresses = null;
        if (!TextUtils.isEmpty(dcResult.addresses)) {
            addresses = dcResult.addresses.split("\\s+");
        }
        ArrayList<LinkAddress> laList = new ArrayList<LinkAddress>();
        if (addresses != null) {
            for (String address : addresses) {
                if ((address = address.trim()).isEmpty()) continue;
                try {
                    InetAddress ia;
                    LinkAddress la = address.split("/").length == 2 ? new LinkAddress(address) : new LinkAddress(ia, (ia = NetworkUtils.numericToInetAddress(address)) instanceof Inet4Address ? 32 : 128);
                    laList.add(la);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown address: " + address + ", exception = " + e);
                }
            }
        }
        String[] dnses = null;
        if (!TextUtils.isEmpty(dcResult.dnses)) {
            dnses = dcResult.dnses.split("\\s+");
        }
        ArrayList<InetAddress> dnsList = new ArrayList<InetAddress>();
        if (dnses != null) {
            for (String dns : dnses) {
                dns = dns.trim();
                try {
                    InetAddress ia = NetworkUtils.numericToInetAddress(dns);
                    dnsList.add(ia);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown dns: " + dns + ", exception = " + e);
                }
            }
        }
        String[] gateways = null;
        if (!TextUtils.isEmpty(dcResult.gateways)) {
            gateways = dcResult.gateways.split("\\s+");
        }
        ArrayList<InetAddress> gatewayList = new ArrayList<InetAddress>();
        if (gateways != null) {
            for (String gateway : gateways) {
                gateway = gateway.trim();
                try {
                    InetAddress ia = NetworkUtils.numericToInetAddress(gateway);
                    gatewayList.add(ia);
                }
                catch (IllegalArgumentException e) {
                    this.loge("Unknown gateway: " + gateway + ", exception = " + e);
                }
            }
        }
        return new DataCallResponse(dcResult.status, dcResult.suggestedRetryTime, dcResult.cid, dcResult.active, dcResult.type, dcResult.ifname, laList, dnsList, gatewayList, new ArrayList<String>(Arrays.asList(dcResult.pcscf.trim().split("\\s+"))), dcResult.mtu);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$log(String s) {
        Rlog.d(TAG, s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$loge(String s) {
        Rlog.e(TAG, s);
    }

    static void __staticInitializer__() {
        TAG = CellularDataService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_dataconnection_CellularDataService$__constructor__();
    }

    public CellularDataService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$__constructor__(), 0, this);
    }

    @Override
    public DataService.DataServiceProvider createDataServiceProvider(int n) {
        return InvokeDynamicSupport.bootstrap("createDataServiceProvider", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$createDataServiceProvider(int ), 0, this, n);
    }

    public DataCallResponse convertDataCallResult(SetupDataCallResult setupDataCallResult) {
        return InvokeDynamicSupport.bootstrap("convertDataCallResult", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$convertDataCallResult(android.hardware.radio.V1_0.SetupDataCallResult ), 0, this, setupDataCallResult);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService$loge(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(CellularDataService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularDataService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CellularDataServiceProvider
    extends DataService.DataServiceProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Map<Message, DataServiceCallback> mCallbackMap;
        private Looper mLooper;
        private Handler mHandler;
        private Phone mPhone;
        /* synthetic */ CellularDataService this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$__constructor__(CellularDataService cellularDataService, int slotId) {
            this.mCallbackMap = new HashMap<Message, DataServiceCallback>();
            this.mPhone = PhoneFactory.getPhone(this.getSlotId());
            HandlerThread thread = new HandlerThread(CellularDataService.class.getSimpleName());
            thread.start();
            this.mLooper = thread.getLooper();
            this.mHandler = new ShadowedObject(this, this.mLooper, cellularDataService){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ CellularDataService val$this$0;
                /* synthetic */ CellularDataServiceProvider this$1;

                private void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider_1$__constructor__(CellularDataServiceProvider this$1, Looper x0, CellularDataService cellularDataService) {
                }

                private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider_1$handleMessage(Message message) {
                    DataServiceCallback callback = (DataServiceCallback)this.this$1.mCallbackMap.remove(message);
                    AsyncResult ar = (AsyncResult)message.obj;
                    switch (message.what) {
                        case 1: {
                            SetupDataCallResult result = (SetupDataCallResult)ar.result;
                            callback.onSetupDataCallComplete(ar.exception != null ? 4 : 0, this.this$1.this$0.convertDataCallResult(result));
                            break;
                        }
                        case 2: {
                            callback.onDeactivateDataCallComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 3: {
                            callback.onSetInitialAttachApnComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 4: {
                            callback.onSetDataProfileComplete(ar.exception != null ? 4 : 0);
                            break;
                        }
                        case 5: {
                            callback.onGetDataCallListComplete(ar.exception != null ? 4 : 0, ar.exception != null ? null : this.this$1.getDataCallList((List)ar.result));
                            break;
                        }
                        case 6: {
                            this.this$1.notifyDataCallListChanged(this.this$1.getDataCallList((List)ar.result));
                            break;
                        }
                        default: {
                            this.this$1.this$0.loge("Unexpected event: " + message.what);
                            return;
                        }
                    }
                }

                private void __constructor__(CellularDataServiceProvider cellularDataServiceProvider, Looper looper, CellularDataService cellularDataService) {
                    this.$$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider_1$__constructor__(cellularDataServiceProvider, looper, cellularDataService);
                }
                {
                    this.this$1 = cellularDataServiceProvider;
                    this.val$this$0 = cellularDataService;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider_1$__constructor__(com.android.internal.telephony.dataconnection.CellularDataService$CellularDataServiceProvider android.os.Looper com.android.internal.telephony.dataconnection.CellularDataService ), 0, this, cellularDataServiceProvider, looper, cellularDataService);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mPhone.mCi.registerForDataCallListChanged(this.mHandler, 6, null);
        }

        private final List<DataCallResponse> $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$getDataCallList(List<SetupDataCallResult> dcList) {
            ArrayList<DataCallResponse> dcResponseList = new ArrayList<DataCallResponse>();
            for (SetupDataCallResult dcResult : dcList) {
                dcResponseList.add(this.this$0.convertDataCallResult(dcResult));
            }
            return dcResponseList;
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setupDataCall(int radioTechnology, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 1);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setupDataCall(radioTechnology, dataProfile, isRoaming, allowRoaming, reason, linkProperties, message);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$deactivateDataCall(int cid, int reason, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 2);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.deactivateDataCall(cid, reason, message);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 3);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setInitialAttachApn(dataProfile, isRoaming, message);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setDataProfile(List<DataProfile> dps, boolean isRoaming, DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 4);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.setDataProfile(dps.toArray(new DataProfile[dps.size()]), isRoaming, message);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$getDataCallList(DataServiceCallback callback) {
            Message message = null;
            if (callback != null) {
                message = Message.obtain(this.mHandler, 5);
                this.mCallbackMap.put(message, callback);
            }
            this.mPhone.mCi.getDataCallList(message);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$__constructor__(CellularDataService x0, int x1, 1 x2) {
        }

        private void __constructor__(CellularDataService cellularDataService, int n) {
            this.$$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$__constructor__(cellularDataService, n);
        }

        private CellularDataServiceProvider(CellularDataService cellularDataService, int n) {
            this.this$0 = cellularDataService;
            super(cellularDataService, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$__constructor__(com.android.internal.telephony.dataconnection.CellularDataService int ), 0, this, cellularDataService, n);
        }

        private List<DataCallResponse> getDataCallList(List<SetupDataCallResult> list) {
            return InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$getDataCallList(java.util.List<android.hardware.radio.V1_0.SetupDataCallResult> ), 0, this, list);
        }

        @Override
        public void setupDataCall(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setupDataCall(int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.telephony.data.DataServiceCallback ), 0, this, n, dataProfile, bl, bl2, n2, linkProperties, dataServiceCallback);
        }

        @Override
        public void deactivateDataCall(int n, int n2, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$deactivateDataCall(int int android.telephony.data.DataServiceCallback ), 0, this, n, n2, dataServiceCallback);
        }

        @Override
        public void setInitialAttachApn(DataProfile dataProfile, boolean bl, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setInitialAttachApn(android.telephony.data.DataProfile boolean android.telephony.data.DataServiceCallback ), 0, this, dataProfile, bl, dataServiceCallback);
        }

        @Override
        public void setDataProfile(List<DataProfile> list, boolean bl, DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$setDataProfile(java.util.List<android.telephony.data.DataProfile> boolean android.telephony.data.DataServiceCallback ), 0, this, list, bl, dataServiceCallback);
        }

        @Override
        public void getDataCallList(DataServiceCallback dataServiceCallback) {
            InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$getDataCallList(android.telephony.data.DataServiceCallback ), 0, this, dataServiceCallback);
        }

        private /* synthetic */ void __constructor__(CellularDataService cellularDataService, int n, 1 var3_3) {
            this.$$robo$$com_android_internal_telephony_dataconnection_CellularDataService_CellularDataServiceProvider$__constructor__(cellularDataService, n, var3_3);
        }

        public /* synthetic */ CellularDataServiceProvider() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularDataServiceProvider)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

