/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.ContentResolver;
import android.os.Handler;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import android.util.Pair;
import com.android.internal.telephony.Phone;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DataEnabledSettings
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "DataEnabledSettings";
    public static int REASON_REGISTERED = 0;
    public static int REASON_INTERNAL_DATA_ENABLED = 1;
    public static int REASON_USER_DATA_ENABLED = 2;
    public static int REASON_POLICY_DATA_ENABLED = 3;
    public static int REASON_DATA_ENABLED_BY_CARRIER = 4;
    private boolean mInternalDataEnabled;
    private boolean mPolicyDataEnabled;
    private boolean mCarrierDataEnabled;
    private Phone mPhone;
    private ContentResolver mResolver;
    private RegistrantList mDataEnabledChangedRegistrants;
    private LocalLog mSettingChangeLocalLog;

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$toString() {
        return "[mInternalDataEnabled=" + this.mInternalDataEnabled + ", isUserDataEnabled=" + this.isUserDataEnabled() + ", isProvisioningDataEnabled=" + this.isProvisioningDataEnabled() + ", mPolicyDataEnabled=" + this.mPolicyDataEnabled + ", mCarrierDataEnabled=" + this.mCarrierDataEnabled + "]";
    }

    private void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$__constructor__(Phone phone) {
        this.mInternalDataEnabled = true;
        this.mPolicyDataEnabled = true;
        this.mCarrierDataEnabled = true;
        this.mPhone = null;
        this.mResolver = null;
        this.mDataEnabledChangedRegistrants = new RegistrantList();
        this.mSettingChangeLocalLog = new LocalLog(50);
        this.mPhone = phone;
        this.mResolver = this.mPhone.getContext().getContentResolver();
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setInternalDataEnabled(boolean enabled) {
        this.localLog("InternalDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mInternalDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 1);
        }
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isInternalDataEnabled() {
        return this.mInternalDataEnabled;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setUserDataEnabled(boolean enabled) {
        this.localLog("UserDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        Settings.Global.putInt(this.mResolver, this.getMobileDataSettingName(), enabled ? 1 : 0);
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 2);
        }
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isUserDataEnabled() {
        boolean defaultVal = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true"));
        return Settings.Global.getInt(this.mResolver, this.getMobileDataSettingName(), defaultVal ? 1 : 0) != 0;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$getMobileDataSettingName() {
        int subId = this.mPhone.getSubId();
        if (TelephonyManager.getDefault().getSimCount() == 1 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            return "mobile_data";
        }
        return "mobile_data" + this.mPhone.getSubId();
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setPolicyDataEnabled(boolean enabled) {
        this.localLog("PolicyDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mPolicyDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 3);
        }
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isPolicyDataEnabled() {
        return this.mPolicyDataEnabled;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setCarrierDataEnabled(boolean enabled) {
        this.localLog("CarrierDataEnabled", enabled);
        boolean prevDataEnabled = this.isDataEnabled();
        this.mCarrierDataEnabled = enabled;
        if (prevDataEnabled != this.isDataEnabled()) {
            this.notifyDataEnabledChanged(!prevDataEnabled, 4);
        }
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isCarrierDataEnabled() {
        return this.mCarrierDataEnabled;
    }

    private final synchronized boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isDataEnabled() {
        if (this.isProvisioning()) {
            return this.isProvisioningDataEnabled();
        }
        return this.mInternalDataEnabled && this.isUserDataEnabled() && this.mPolicyDataEnabled && this.mCarrierDataEnabled;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isProvisioning() {
        return Settings.Global.getInt(this.mResolver, "device_provisioned", 0) == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isProvisioningDataEnabled() {
        String prov_property = SystemProperties.get("ro.com.android.prov_mobiledata", "false");
        boolean retVal = "true".equalsIgnoreCase(prov_property);
        int prov_mobile_data = Settings.Global.getInt(this.mResolver, "device_provisioning_mobile_data", retVal ? 1 : 0);
        retVal = prov_mobile_data != 0;
        this.log("getDataEnabled during provisioning retVal=" + retVal + " - (" + prov_property + ", " + prov_mobile_data + ")");
        return retVal;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$notifyDataEnabledChanged(boolean enabled, int reason) {
        this.mDataEnabledChangedRegistrants.notifyResult(new Pair<Boolean, Integer>(enabled, reason));
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mDataEnabledChangedRegistrants.addUnique(h, what, obj);
        this.notifyDataEnabledChanged(this.isDataEnabled(), 0);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$unregisterForDataEnabledChanged(Handler h) {
        this.mDataEnabledChangedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$log(String s) {
        Rlog.d("DataEnabledSettings", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$localLog(String name, boolean value) {
        this.mSettingChangeLocalLog.log(name + " change to " + value);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(" DataEnabledSettings=");
        this.mSettingChangeLocalLog.dump(fd, pw, args);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$toString(), 0, this);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$__constructor__(phone);
    }

    public DataEnabledSettings(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public synchronized void setInternalDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setInternalDataEnabled(boolean ), 0, this, bl);
    }

    public synchronized boolean isInternalDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInternalDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isInternalDataEnabled(), 0, this);
    }

    public synchronized void setUserDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUserDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setUserDataEnabled(boolean ), 0, this, bl);
    }

    public synchronized boolean isUserDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isUserDataEnabled(), 0, this);
    }

    private String getMobileDataSettingName() {
        return InvokeDynamicSupport.bootstrap("getMobileDataSettingName", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$getMobileDataSettingName(), 0, this);
    }

    public synchronized void setPolicyDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPolicyDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setPolicyDataEnabled(boolean ), 0, this, bl);
    }

    public synchronized boolean isPolicyDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPolicyDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isPolicyDataEnabled(), 0, this);
    }

    public synchronized void setCarrierDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCarrierDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$setCarrierDataEnabled(boolean ), 0, this, bl);
    }

    public synchronized boolean isCarrierDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCarrierDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isCarrierDataEnabled(), 0, this);
    }

    public synchronized boolean isDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isDataEnabled(), 0, this);
    }

    public boolean isProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioning", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isProvisioning(), 0, this);
    }

    public boolean isProvisioningDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProvisioningDataEnabled", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$isProvisioningDataEnabled(), 0, this);
    }

    private void notifyDataEnabledChanged(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("notifyDataEnabledChanged", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$notifyDataEnabledChanged(boolean int ), 0, this, bl, n);
    }

    public void registerForDataEnabledChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDataEnabledChanged", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$registerForDataEnabledChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDataEnabledChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataEnabledChanged", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$unregisterForDataEnabledChanged(android.os.Handler ), 0, this, handler);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$log(java.lang.String ), 0, this, string2);
    }

    private void localLog(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("localLog", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$localLog(java.lang.String boolean ), 0, this, string2, bl);
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_dataconnection_DataEnabledSettings$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ DataEnabledSettings() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataEnabledSettings)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

