/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.data.DataCallResponse;
import android.telephony.data.DataProfile;
import android.telephony.data.IDataService;
import android.telephony.data.IDataServiceCallback;
import android.text.TextUtils;
import com.android.internal.telephony.Phone;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DataServiceManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    static String DATA_CALL_RESPONSE = "data_call_response";
    private Phone mPhone;
    private CarrierConfigManager mCarrierConfigManager;
    private AppOpsManager mAppOps;
    private IPackageManager mPackageManager;
    private int mTransportType;
    private boolean mBound;
    private IDataService mIDataService;
    private DataServiceManagerDeathRecipient mDeathRecipient;
    private RegistrantList mServiceBindingChangedRegistrants;
    private Map<IBinder, Message> mMessageMap;
    private RegistrantList mDataCallListChangedRegistrants;
    private ComponentName mComponentName;

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$grantPermissionsToService(String packageName) {
        String[] pkgToGrant = new String[]{packageName};
        try {
            this.mPackageManager.grantDefaultPermissionsToEnabledTelephonyDataServices(pkgToGrant, this.mPhone.getContext().getUserId());
            this.mAppOps.setMode(75, this.mPhone.getContext().getUserId(), pkgToGrant[0], 0);
        }
        catch (RemoteException e) {
            this.loge("Binder to package manager died, permission grant for DataService failed.");
            throw e.rethrowAsRuntimeException();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$revokePermissionsFromUnusedDataServices() {
        Set<String> dataServices = this.getAllDataServicePackageNames();
        for (int transportType : new int[]{1, 2}) {
            dataServices.remove(this.getDataServicePackageName(transportType));
        }
        try {
            String[] dataServicesArray = new String[dataServices.size()];
            dataServices.toArray(dataServicesArray);
            this.mPackageManager.revokeDefaultPermissionsFromDisabledTelephonyDataServices(dataServicesArray, this.mPhone.getContext().getUserId());
            for (String pkg : dataServices) {
                this.mAppOps.setMode(75, this.mPhone.getContext().getUserId(), pkg, 2);
            }
        }
        catch (RemoteException e) {
            this.loge("Binder to package manager died; failed to revoke DataService permissions.");
            throw e.rethrowAsRuntimeException();
        }
    }

    private void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$__constructor__(Phone phone, int transportType) {
        this.mServiceBindingChangedRegistrants = new RegistrantList();
        this.mMessageMap = new ConcurrentHashMap<IBinder, Message>();
        this.mDataCallListChangedRegistrants = new RegistrantList();
        this.mPhone = phone;
        this.mTransportType = transportType;
        this.mBound = false;
        this.mCarrierConfigManager = (CarrierConfigManager)phone.getContext().getSystemService("carrier_config");
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mAppOps = (AppOpsManager)phone.getContext().getSystemService("appops");
        this.bindDataService();
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$bindDataService() {
        this.revokePermissionsFromUnusedDataServices();
        String packageName = this.getDataServicePackageName();
        if (TextUtils.isEmpty(packageName)) {
            this.loge("Can't find the binding package");
            return;
        }
        this.grantPermissionsToService(packageName);
        try {
            if (!this.mPhone.getContext().bindService(new Intent("android.telephony.data.DataService").setPackage(packageName), new CellularDataServiceConnection(this), 1)) {
                this.loge("Cannot bind to the data service.");
            }
        }
        catch (Exception e) {
            this.loge("Cannot bind to the data service. Exception: " + e);
        }
    }

    private final Set<String> $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getAllDataServicePackageNames() {
        List<ResolveInfo> dataPackages = this.mPhone.getContext().getPackageManager().queryIntentServices(new Intent("android.telephony.data.DataService"), 0x100000);
        HashSet<String> packageNames = new HashSet<String>();
        for (ResolveInfo info : dataPackages) {
            if (info.serviceInfo == null) continue;
            packageNames.add(info.serviceInfo.packageName);
        }
        return packageNames;
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataServicePackageName() {
        return this.getDataServicePackageName(this.mTransportType);
    }

    private final String $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataServicePackageName(int transportType) {
        String carrierConfig;
        int resourceId;
        switch (transportType) {
            case 1: {
                resourceId = 17039728;
                carrierConfig = "carrier_data_service_wwan_package_override_string";
                break;
            }
            case 2: {
                resourceId = 17039726;
                carrierConfig = "carrier_data_service_wlan_package_override_string";
                break;
            }
            default: {
                throw new IllegalStateException("Transport type not WWAN or WLAN. type=" + this.mTransportType);
            }
        }
        String packageName = this.mPhone.getContext().getResources().getString(resourceId);
        PersistableBundle b = this.mCarrierConfigManager.getConfigForSubId(this.mPhone.getSubId());
        if (b != null) {
            packageName = b.getString(carrierConfig, packageName);
        }
        return packageName;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$sendCompleteMessage(Message msg, int code) {
        if (msg != null) {
            msg.arg1 = code;
            msg.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setupDataCall(int accessNetworkType, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, int reason, LinkProperties linkProperties, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback(this);
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setupDataCall(this.mPhone.getPhoneId(), accessNetworkType, dataProfile, isRoaming, allowRoaming, reason, linkProperties, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setupDataCall on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$deactivateDataCall(int cid, int reason, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback(this);
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.deactivateDataCall(this.mPhone.getPhoneId(), cid, reason, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke deactivateDataCall on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback(this);
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setInitialAttachApn(this.mPhone.getPhoneId(), dataProfile, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setInitialAttachApn on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setDataProfile(List<DataProfile> dps, boolean isRoaming, Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback(this);
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.setDataProfile(this.mPhone.getPhoneId(), dps, isRoaming, callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke setDataProfile on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataCallList(Message onCompleteMessage) {
        if (!this.mBound) {
            this.loge("Data service not bound.");
            this.sendCompleteMessage(onCompleteMessage, 4);
            return;
        }
        CellularDataServiceCallback callback = null;
        if (onCompleteMessage != null) {
            callback = new CellularDataServiceCallback(this);
            this.mMessageMap.put(callback.asBinder(), onCompleteMessage);
        }
        try {
            this.mIDataService.getDataCallList(this.mPhone.getPhoneId(), callback);
        }
        catch (RemoteException e) {
            this.loge("Cannot invoke getDataCallList on data service.");
            if (callback != null) {
                this.mMessageMap.remove(callback.asBinder());
            }
            this.sendCompleteMessage(onCompleteMessage, 4);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$registerForDataCallListChanged(Handler h, int what) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.addUnique(h, what, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$unregisterForDataCallListChanged(Handler h) {
        if (h != null) {
            this.mDataCallListChangedRegistrants.remove(h);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$registerForServiceBindingChanged(Handler h, int what, Object obj) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.addUnique(h, what, obj);
        }
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$unregisterForServiceBindingChanged(Handler h) {
        if (h != null) {
            this.mServiceBindingChangedRegistrants.remove(h);
        }
    }

    private final int $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getTransportType() {
        return this.mTransportType;
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$log(String s) {
        Rlog.d(TAG, s);
    }

    private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$loge(String s) {
        Rlog.e(TAG, s);
    }

    static void __staticInitializer__() {
        TAG = DataServiceManager.class.getSimpleName();
    }

    private void grantPermissionsToService(String string2) {
        InvokeDynamicSupport.bootstrap("grantPermissionsToService", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$grantPermissionsToService(java.lang.String ), 0, this, string2);
    }

    private void revokePermissionsFromUnusedDataServices() {
        InvokeDynamicSupport.bootstrap("revokePermissionsFromUnusedDataServices", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$revokePermissionsFromUnusedDataServices(), 0, this);
    }

    private void __constructor__(Phone phone, int n) {
        this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$__constructor__(phone, n);
    }

    public DataServiceManager(Phone phone, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$__constructor__(com.android.internal.telephony.Phone int ), 0, this, phone, n);
    }

    private void bindDataService() {
        InvokeDynamicSupport.bootstrap("bindDataService", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$bindDataService(), 0, this);
    }

    private Set<String> getAllDataServicePackageNames() {
        return InvokeDynamicSupport.bootstrap("getAllDataServicePackageNames", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getAllDataServicePackageNames(), 0, this);
    }

    private String getDataServicePackageName() {
        return InvokeDynamicSupport.bootstrap("getDataServicePackageName", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataServicePackageName(), 0, this);
    }

    private String getDataServicePackageName(int n) {
        return InvokeDynamicSupport.bootstrap("getDataServicePackageName", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataServicePackageName(int ), 0, this, n);
    }

    private void sendCompleteMessage(Message message, int n) {
        InvokeDynamicSupport.bootstrap("sendCompleteMessage", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$sendCompleteMessage(android.os.Message int ), 0, this, message, n);
    }

    public void setupDataCall(int n, DataProfile dataProfile, boolean bl, boolean bl2, int n2, LinkProperties linkProperties, Message message) {
        InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setupDataCall(int android.telephony.data.DataProfile boolean boolean int android.net.LinkProperties android.os.Message ), 0, this, n, dataProfile, bl, bl2, n2, linkProperties, message);
    }

    public void deactivateDataCall(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$deactivateDataCall(int int android.os.Message ), 0, this, n, n2, message);
    }

    public void setInitialAttachApn(DataProfile dataProfile, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setInitialAttachApn(android.telephony.data.DataProfile boolean android.os.Message ), 0, this, dataProfile, bl, message);
    }

    public void setDataProfile(List<DataProfile> list, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$setDataProfile(java.util.List<android.telephony.data.DataProfile> boolean android.os.Message ), 0, this, list, bl, message);
    }

    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getDataCallList(android.os.Message ), 0, this, message);
    }

    public void registerForDataCallListChanged(Handler handler, int n) {
        InvokeDynamicSupport.bootstrap("registerForDataCallListChanged", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$registerForDataCallListChanged(android.os.Handler int ), 0, this, handler, n);
    }

    public void unregisterForDataCallListChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataCallListChanged", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$unregisterForDataCallListChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForServiceBindingChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForServiceBindingChanged", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$registerForServiceBindingChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForServiceBindingChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForServiceBindingChanged", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$unregisterForServiceBindingChanged(android.os.Handler ), 0, this, handler);
    }

    public int getTransportType() {
        return (int)InvokeDynamicSupport.bootstrap("getTransportType", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$getTransportType(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager$loge(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(DataServiceManager.class);
    }

    public /* synthetic */ DataServiceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataServiceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CellularDataServiceCallback
    extends IDataServiceCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataServiceManager this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$__constructor__(DataServiceManager dataServiceManager) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetupDataCallComplete(int resultCode, DataCallResponse response) {
            Message msg = (Message)this.this$0.mMessageMap.remove(this.asBinder());
            if (msg != null) {
                msg.getData().putParcelable("data_call_response", response);
                this.this$0.sendCompleteMessage(msg, resultCode);
            } else {
                this.this$0.loge("Unable to find the message for setup call response.");
            }
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onDeactivateDataCallComplete(int resultCode) {
            Message msg = (Message)this.this$0.mMessageMap.remove(this.asBinder());
            this.this$0.sendCompleteMessage(msg, resultCode);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetInitialAttachApnComplete(int resultCode) {
            Message msg = (Message)this.this$0.mMessageMap.remove(this.asBinder());
            this.this$0.sendCompleteMessage(msg, resultCode);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetDataProfileComplete(int resultCode) {
            Message msg = (Message)this.this$0.mMessageMap.remove(this.asBinder());
            this.this$0.sendCompleteMessage(msg, resultCode);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onGetDataCallListComplete(int resultCode, List<DataCallResponse> dataCallList) {
            Message msg = (Message)this.this$0.mMessageMap.remove(this.asBinder());
            this.this$0.sendCompleteMessage(msg, resultCode);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onDataCallListChanged(List<DataCallResponse> dataCallList) {
            this.this$0.mDataCallListChangedRegistrants.notifyRegistrants(new AsyncResult(null, dataCallList, null));
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$__constructor__(DataServiceManager x0, 1 x1) {
        }

        private void __constructor__(DataServiceManager dataServiceManager) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$__constructor__(dataServiceManager);
        }

        private CellularDataServiceCallback(DataServiceManager dataServiceManager) {
            this.this$0 = dataServiceManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$__constructor__(com.android.internal.telephony.dataconnection.DataServiceManager ), 0, this, dataServiceManager);
        }

        @Override
        public void onSetupDataCallComplete(int n, DataCallResponse dataCallResponse) {
            InvokeDynamicSupport.bootstrap("onSetupDataCallComplete", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetupDataCallComplete(int android.telephony.data.DataCallResponse ), 0, this, n, dataCallResponse);
        }

        @Override
        public void onDeactivateDataCallComplete(int n) {
            InvokeDynamicSupport.bootstrap("onDeactivateDataCallComplete", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onDeactivateDataCallComplete(int ), 0, this, n);
        }

        @Override
        public void onSetInitialAttachApnComplete(int n) {
            InvokeDynamicSupport.bootstrap("onSetInitialAttachApnComplete", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetInitialAttachApnComplete(int ), 0, this, n);
        }

        @Override
        public void onSetDataProfileComplete(int n) {
            InvokeDynamicSupport.bootstrap("onSetDataProfileComplete", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onSetDataProfileComplete(int ), 0, this, n);
        }

        @Override
        public void onGetDataCallListComplete(int n, List<DataCallResponse> list) {
            InvokeDynamicSupport.bootstrap("onGetDataCallListComplete", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onGetDataCallListComplete(int java.util.List<android.telephony.data.DataCallResponse> ), 0, this, n, list);
        }

        @Override
        public void onDataCallListChanged(List<DataCallResponse> list) {
            InvokeDynamicSupport.bootstrap("onDataCallListChanged", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$onDataCallListChanged(java.util.List<android.telephony.data.DataCallResponse> ), 0, this, list);
        }

        private /* synthetic */ void __constructor__(DataServiceManager dataServiceManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceCallback$__constructor__(dataServiceManager, var2_2);
        }

        public /* synthetic */ CellularDataServiceCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularDataServiceCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class CellularDataServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataServiceManager this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$__constructor__(DataServiceManager dataServiceManager) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            this.this$0.mComponentName = name;
            this.this$0.mIDataService = IDataService.Stub.asInterface(service);
            this.this$0.mDeathRecipient = new DataServiceManagerDeathRecipient(this.this$0);
            this.this$0.mBound = true;
            try {
                service.linkToDeath(this.this$0.mDeathRecipient, 0);
                this.this$0.mIDataService.createDataServiceProvider(this.this$0.mPhone.getPhoneId());
                this.this$0.mIDataService.registerForDataCallListChanged(this.this$0.mPhone.getPhoneId(), new CellularDataServiceCallback(this.this$0));
            }
            catch (RemoteException e) {
                this.this$0.mDeathRecipient.binderDied();
                this.this$0.loge("Remote exception. " + e);
                return;
            }
            this.this$0.mServiceBindingChangedRegistrants.notifyResult(true);
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$onServiceDisconnected(ComponentName name) {
            this.this$0.mIDataService.asBinder().unlinkToDeath(this.this$0.mDeathRecipient, 0);
            this.this$0.mIDataService = null;
            this.this$0.mBound = false;
            this.this$0.mServiceBindingChangedRegistrants.notifyResult(false);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$__constructor__(DataServiceManager x0, 1 x1) {
        }

        private void __constructor__(DataServiceManager dataServiceManager) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$__constructor__(dataServiceManager);
        }

        private CellularDataServiceConnection(DataServiceManager dataServiceManager) {
            this.this$0 = dataServiceManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$__constructor__(com.android.internal.telephony.dataconnection.DataServiceManager ), 0, this, dataServiceManager);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        private /* synthetic */ void __constructor__(DataServiceManager dataServiceManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_CellularDataServiceConnection$__constructor__(dataServiceManager, var2_2);
        }

        public /* synthetic */ CellularDataServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellularDataServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DataServiceManagerDeathRecipient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DataServiceManager this$0;

        private void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$__constructor__(DataServiceManager dataServiceManager) {
        }

        private final void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$binderDied() {
            this.this$0.loge("DataService(" + this.this$0.mComponentName + " transport type " + this.this$0.mTransportType + ") died.");
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$__constructor__(DataServiceManager x0, 1 x1) {
        }

        private void __constructor__(DataServiceManager dataServiceManager) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$__constructor__(dataServiceManager);
        }

        private DataServiceManagerDeathRecipient(DataServiceManager dataServiceManager) {
            this.this$0 = dataServiceManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$__constructor__(com.android.internal.telephony.dataconnection.DataServiceManager ), 0, this, dataServiceManager);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$binderDied(), 0, this);
        }

        private /* synthetic */ void __constructor__(DataServiceManager dataServiceManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_dataconnection_DataServiceManager_DataServiceManagerDeathRecipient$__constructor__(dataServiceManager, var2_2);
        }

        public /* synthetic */ DataServiceManagerDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataServiceManagerDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

