/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ComponentInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.service.euicc.EuiccProfileInfo;
import android.telephony.euicc.EuiccNotification;
import android.telephony.euicc.EuiccRulesAuthTable;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.euicc.EuiccConnector;
import com.android.internal.telephony.euicc.EuiccController;
import com.android.internal.telephony.euicc.IAuthenticateServerCallback;
import com.android.internal.telephony.euicc.ICancelSessionCallback;
import com.android.internal.telephony.euicc.IDeleteProfileCallback;
import com.android.internal.telephony.euicc.IDisableProfileCallback;
import com.android.internal.telephony.euicc.IEuiccCardController;
import com.android.internal.telephony.euicc.IGetAllProfilesCallback;
import com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.IGetEuiccChallengeCallback;
import com.android.internal.telephony.euicc.IGetEuiccInfo1Callback;
import com.android.internal.telephony.euicc.IGetEuiccInfo2Callback;
import com.android.internal.telephony.euicc.IGetProfileCallback;
import com.android.internal.telephony.euicc.IGetRulesAuthTableCallback;
import com.android.internal.telephony.euicc.IGetSmdsAddressCallback;
import com.android.internal.telephony.euicc.IListNotificationsCallback;
import com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback;
import com.android.internal.telephony.euicc.IPrepareDownloadCallback;
import com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback;
import com.android.internal.telephony.euicc.IResetMemoryCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationCallback;
import com.android.internal.telephony.euicc.IRetrieveNotificationListCallback;
import com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback;
import com.android.internal.telephony.euicc.ISetNicknameCallback;
import com.android.internal.telephony.euicc.ISwitchToProfileCallback;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UiccSlot;
import com.android.internal.telephony.uicc.euicc.EuiccCard;
import com.android.internal.telephony.uicc.euicc.EuiccCardErrorException;
import com.android.internal.telephony.uicc.euicc.async.AsyncResultCallback;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EuiccCardController
extends IEuiccCardController.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "EuiccCardController";
    private static String KEY_LAST_BOOT_COUNT = "last_boot_count";
    private Context mContext;
    private AppOpsManager mAppOps;
    private String mCallingPackage;
    private ComponentInfo mBestComponent;
    private Handler mEuiccMainThreadHandler;
    private SimSlotStatusChangedBroadcastReceiver mSimSlotStatusChangeReceiver;
    private EuiccController mEuiccController;
    private UiccController mUiccController;
    private static EuiccCardController sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final EuiccCardController $$robo$$com_android_internal_telephony_euicc_EuiccCardController$init(Context context) {
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance == null) {
                sInstance = new EuiccCardController(context);
            } else {
                Log.wtf("EuiccCardController", "init() called multiple times! sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final EuiccCardController $$robo$$com_android_internal_telephony_euicc_EuiccCardController$get() {
        if (sInstance != null) return sInstance;
        Class<EuiccCardController> clazz = EuiccCardController.class;
        synchronized (EuiccCardController.class) {
            if (sInstance != null) return sInstance;
            throw new IllegalStateException("get() called before init()");
        }
    }

    private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(Context context) {
        ServiceManager.addService("euicc_card_controller", this);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(Context context, Handler handler, EuiccController euiccController, UiccController uiccController) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mEuiccMainThreadHandler = handler;
        this.mUiccController = uiccController;
        this.mEuiccController = euiccController;
        if (EuiccCardController.isBootUp(this.mContext)) {
            this.mSimSlotStatusChangeReceiver = new SimSlotStatusChangedBroadcastReceiver(this);
            this.mContext.registerReceiver(this.mSimSlotStatusChangeReceiver, new IntentFilter("android.telephony.action.SIM_SLOT_STATUS_CHANGED"));
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private static final boolean $$robo$$com_android_internal_telephony_euicc_EuiccCardController$isBootUp(Context context) {
        int bootCount = Settings.Global.getInt(context.getContentResolver(), "boot_count", -1);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        int lastBootCount = sp.getInt("last_boot_count", -1);
        if (bootCount == -1 || lastBootCount == -1 || bootCount != lastBootCount) {
            sp.edit().putInt("last_boot_count", bootCount).apply();
            return true;
        }
        return false;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccCardController$isEmbeddedSlotActivated() {
        UiccSlot[] slots = this.mUiccController.getUiccSlots();
        if (slots == null) {
            return false;
        }
        for (int i = 0; i < slots.length; ++i) {
            UiccSlot slotInfo = slots[i];
            if (!slotInfo.isEuicc() || !slotInfo.isActive()) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$checkCallingPackage(String callingPackage) {
        this.mAppOps.checkPackage(Binder.getCallingUid(), callingPackage);
        this.mCallingPackage = callingPackage;
        this.mBestComponent = EuiccConnector.findBestComponent(this.mContext.getPackageManager());
        if (this.mBestComponent == null || !TextUtils.equals(this.mCallingPackage, this.mBestComponent.packageName)) {
            throw new SecurityException("The calling package can only be LPA.");
        }
    }

    private final EuiccCard $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccCard(String cardId) {
        UiccSlot slot;
        UiccController controller = UiccController.getInstance();
        int slotId = controller.getUiccSlotForCardId(cardId);
        if (slotId != -1 && (slot = controller.getUiccSlot(slotId)).isEuicc()) {
            return (EuiccCard)controller.getUiccCardForSlot(slotId);
        }
        EuiccCardController.loge("EuiccCard is null. CardId : " + cardId);
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getResultCode(Throwable e) {
        if (e instanceof EuiccCardErrorException) {
            return ((EuiccCardErrorException)e).getErrorCode();
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getAllProfiles(String callingPackage, String cardId, IGetAllProfilesCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getAllProfiles callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo[]> cardCb = new AsyncResultCallback<EuiccProfileInfo[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetAllProfilesCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$__constructor__(EuiccCardController this$0, IGetAllProfilesCallback iGetAllProfilesCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$onResult(EuiccProfileInfo[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getAllProfiles callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getAllProfiles callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getAllProfiles callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetAllProfilesCallback iGetAllProfilesCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$__constructor__(euiccCardController, iGetAllProfilesCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetAllProfilesCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetAllProfilesCallback ), 0, this, euiccCardController, iGetAllProfilesCallback);
            }

            @Override
            public void onResult(EuiccProfileInfo[] euiccProfileInfoArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$onResult(android.service.euicc.EuiccProfileInfo[] ), 0, this, euiccProfileInfoArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_1$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getAllProfiles(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getProfile(String callingPackage, String cardId, String iccid, IGetProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo> cardCb = new AsyncResultCallback<EuiccProfileInfo>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetProfileCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$__constructor__(EuiccCardController this$0, IGetProfileCallback iGetProfileCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$onResult(EuiccProfileInfo result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getProfile callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getProfile callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getProfile callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetProfileCallback iGetProfileCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$__constructor__(euiccCardController, iGetProfileCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetProfileCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetProfileCallback ), 0, this, euiccCardController, iGetProfileCallback);
            }

            @Override
            public void onResult(EuiccProfileInfo euiccProfileInfo) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$onResult(android.service.euicc.EuiccProfileInfo ), 0, this, euiccProfileInfo);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_2$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$disableProfile(String callingPackage, String cardId, String iccid, boolean refresh, IDisableProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("disableProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IDisableProfileCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$__constructor__(EuiccCardController this$0, IDisableProfileCallback iDisableProfileCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$onResult(Void result) {
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("disableProfile callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$onException(Throwable e) {
                try {
                    EuiccCardController.loge("disableProfile callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("disableProfile callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IDisableProfileCallback iDisableProfileCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$__constructor__(euiccCardController, iDisableProfileCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iDisableProfileCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IDisableProfileCallback ), 0, this, euiccCardController, iDisableProfileCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_3$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.disableProfile(iccid, refresh, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$switchToProfile(String callingPackage, String cardId, String iccid, boolean refresh, ISwitchToProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("switchToProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccProfileInfo> profileCb = new AsyncResultCallback<EuiccProfileInfo>(this, callback, card, iccid, refresh){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ISwitchToProfileCallback val$callback;
            /* synthetic */ EuiccCard val$card;
            /* synthetic */ String val$iccid;
            /* synthetic */ boolean val$refresh;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$__constructor__(EuiccCardController this$0, ISwitchToProfileCallback iSwitchToProfileCallback, EuiccCard euiccCard, String string2, boolean bl) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$onResult(EuiccProfileInfo profile) {
                AsyncResultCallback<Void> switchCb = new AsyncResultCallback<Void>(this, profile){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ EuiccProfileInfo val$profile;
                    /* synthetic */ 4 this$1;

                    private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$__constructor__(4 this$1, EuiccProfileInfo euiccProfileInfo) {
                    }

                    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$onResult(Void result) {
                        try {
                            this.this$1.val$callback.onComplete(0, this.val$profile);
                        }
                        catch (RemoteException exception) {
                            EuiccCardController.loge("switchToProfile callback failure.", exception);
                        }
                    }

                    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$onException(Throwable e) {
                        try {
                            EuiccCardController.loge("switchToProfile callback onException: ", e);
                            this.this$1.val$callback.onComplete(this.this$1.this$0.getResultCode(e), this.val$profile);
                        }
                        catch (RemoteException exception) {
                            EuiccCardController.loge("switchToProfile callback failure.", exception);
                        }
                    }

                    private void __constructor__(4 var1_1, EuiccProfileInfo euiccProfileInfo) {
                        this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$__constructor__(var1_1, euiccProfileInfo);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$profile = euiccProfileInfo;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$__constructor__(com.android.internal.telephony.euicc.EuiccCardController$4 android.service.euicc.EuiccProfileInfo ), 0, this, var1_1, euiccProfileInfo);
                    }

                    @Override
                    public void onResult(Void void_) {
                        InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$onResult(java.lang.Void ), 0, this, void_);
                    }

                    @Override
                    public void onException(Throwable throwable) {
                        InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4_1$onException(java.lang.Throwable ), 0, this, throwable);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                this.val$card.switchToProfile(this.val$iccid, this.val$refresh, switchCb, this.this$0.mEuiccMainThreadHandler);
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getProfile in switchToProfile callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("switchToProfile callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, ISwitchToProfileCallback iSwitchToProfileCallback, EuiccCard euiccCard, String string2, boolean bl) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$__constructor__(euiccCardController, iSwitchToProfileCallback, euiccCard, string2, bl);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iSwitchToProfileCallback;
                this.val$card = euiccCard;
                this.val$iccid = string2;
                this.val$refresh = bl;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.ISwitchToProfileCallback com.android.internal.telephony.uicc.euicc.EuiccCard java.lang.String boolean ), 0, this, euiccCardController, iSwitchToProfileCallback, euiccCard, string2, bl);
            }

            @Override
            public void onResult(EuiccProfileInfo euiccProfileInfo) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$onResult(android.service.euicc.EuiccProfileInfo ), 0, this, euiccProfileInfo);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_4$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getProfile(iccid, profileCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$setNickname(String callingPackage, String cardId, String iccid, String nickname, ISetNicknameCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("setNickname callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ISetNicknameCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$__constructor__(EuiccCardController this$0, ISetNicknameCallback iSetNicknameCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$onResult(Void result) {
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setNickname callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$onException(Throwable e) {
                try {
                    EuiccCardController.loge("setNickname callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setNickname callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, ISetNicknameCallback iSetNicknameCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$__constructor__(euiccCardController, iSetNicknameCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iSetNicknameCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.ISetNicknameCallback ), 0, this, euiccCardController, iSetNicknameCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_5$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.setNickname(iccid, nickname, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$deleteProfile(String callingPackage, String cardId, String iccid, IDeleteProfileCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("deleteProfile callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IDeleteProfileCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$__constructor__(EuiccCardController this$0, IDeleteProfileCallback iDeleteProfileCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$onResult(Void result) {
                Log.i("EuiccCardController", "Request subscription info list refresh after delete.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh();
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("deleteProfile callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$onException(Throwable e) {
                try {
                    EuiccCardController.loge("deleteProfile callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("deleteProfile callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IDeleteProfileCallback iDeleteProfileCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$__constructor__(euiccCardController, iDeleteProfileCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iDeleteProfileCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IDeleteProfileCallback ), 0, this, euiccCardController, iDeleteProfileCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_6$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.deleteProfile(iccid, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$resetMemory(String callingPackage, String cardId, int options, IResetMemoryCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("resetMemory callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IResetMemoryCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$__constructor__(EuiccCardController this$0, IResetMemoryCallback iResetMemoryCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$onResult(Void result) {
                Log.i("EuiccCardController", "Request subscription info list refresh after reset memory.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh();
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("resetMemory callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$onException(Throwable e) {
                try {
                    EuiccCardController.loge("resetMemory callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("resetMemory callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IResetMemoryCallback iResetMemoryCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$__constructor__(euiccCardController, iResetMemoryCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iResetMemoryCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IResetMemoryCallback ), 0, this, euiccCardController, iResetMemoryCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_7$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.resetMemory(options, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getDefaultSmdpAddress(String callingPackage, String cardId, IGetDefaultSmdpAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetDefaultSmdpAddressCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$__constructor__(EuiccCardController this$0, IGetDefaultSmdpAddressCallback iGetDefaultSmdpAddressCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$onResult(String result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getDefaultSmdpAddress callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getDefaultSmdpAddress callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetDefaultSmdpAddressCallback iGetDefaultSmdpAddressCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$__constructor__(euiccCardController, iGetDefaultSmdpAddressCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetDefaultSmdpAddressCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback ), 0, this, euiccCardController, iGetDefaultSmdpAddressCallback);
            }

            @Override
            public void onResult(String string2) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$onResult(java.lang.String ), 0, this, string2);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_8$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getDefaultSmdpAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getSmdsAddress(String callingPackage, String cardId, IGetSmdsAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getSmdsAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<String> cardCb = new AsyncResultCallback<String>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetSmdsAddressCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$__constructor__(EuiccCardController this$0, IGetSmdsAddressCallback iGetSmdsAddressCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$onResult(String result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getSmdsAddress callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getSmdsAddress callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getSmdsAddress callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetSmdsAddressCallback iGetSmdsAddressCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$__constructor__(euiccCardController, iGetSmdsAddressCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetSmdsAddressCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetSmdsAddressCallback ), 0, this, euiccCardController, iGetSmdsAddressCallback);
            }

            @Override
            public void onResult(String string2) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$onResult(java.lang.String ), 0, this, string2);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_9$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getSmdsAddress(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$setDefaultSmdpAddress(String callingPackage, String cardId, String address, ISetDefaultSmdpAddressCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ISetDefaultSmdpAddressCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$__constructor__(EuiccCardController this$0, ISetDefaultSmdpAddressCallback iSetDefaultSmdpAddressCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$onResult(Void result) {
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$onException(Throwable e) {
                try {
                    EuiccCardController.loge("setDefaultSmdpAddress callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("setDefaultSmdpAddress callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, ISetDefaultSmdpAddressCallback iSetDefaultSmdpAddressCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$__constructor__(euiccCardController, iSetDefaultSmdpAddressCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iSetDefaultSmdpAddressCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback ), 0, this, euiccCardController, iSetDefaultSmdpAddressCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_10$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.setDefaultSmdpAddress(address, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getRulesAuthTable(String callingPackage, String cardId, IGetRulesAuthTableCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccRulesAuthTable> cardCb = new AsyncResultCallback<EuiccRulesAuthTable>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetRulesAuthTableCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$__constructor__(EuiccCardController this$0, IGetRulesAuthTableCallback iGetRulesAuthTableCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$onResult(EuiccRulesAuthTable result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getRulesAuthTable callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getRulesAuthTable callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetRulesAuthTableCallback iGetRulesAuthTableCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$__constructor__(euiccCardController, iGetRulesAuthTableCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetRulesAuthTableCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetRulesAuthTableCallback ), 0, this, euiccCardController, iGetRulesAuthTableCallback);
            }

            @Override
            public void onResult(EuiccRulesAuthTable euiccRulesAuthTable) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$onResult(android.telephony.euicc.EuiccRulesAuthTable ), 0, this, euiccRulesAuthTable);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_11$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getRulesAuthTable(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccChallenge(String callingPackage, String cardId, IGetEuiccChallengeCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetEuiccChallengeCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$__constructor__(EuiccCardController this$0, IGetEuiccChallengeCallback iGetEuiccChallengeCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccChallenge callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccChallenge callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetEuiccChallengeCallback iGetEuiccChallengeCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$__constructor__(euiccCardController, iGetEuiccChallengeCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetEuiccChallengeCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetEuiccChallengeCallback ), 0, this, euiccCardController, iGetEuiccChallengeCallback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_12$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getEuiccChallenge(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccInfo1(String callingPackage, String cardId, IGetEuiccInfo1Callback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetEuiccInfo1Callback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$__constructor__(EuiccCardController this$0, IGetEuiccInfo1Callback iGetEuiccInfo1Callback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccInfo1 callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo1 callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetEuiccInfo1Callback iGetEuiccInfo1Callback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$__constructor__(euiccCardController, iGetEuiccInfo1Callback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetEuiccInfo1Callback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetEuiccInfo1Callback ), 0, this, euiccCardController, iGetEuiccInfo1Callback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_13$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getEuiccInfo1(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccInfo2(String callingPackage, String cardId, IGetEuiccInfo2Callback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IGetEuiccInfo2Callback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$__constructor__(EuiccCardController this$0, IGetEuiccInfo2Callback iGetEuiccInfo2Callback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$onException(Throwable e) {
                try {
                    EuiccCardController.loge("getEuiccInfo2 callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("getEuiccInfo2 callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IGetEuiccInfo2Callback iGetEuiccInfo2Callback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$__constructor__(euiccCardController, iGetEuiccInfo2Callback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iGetEuiccInfo2Callback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IGetEuiccInfo2Callback ), 0, this, euiccCardController, iGetEuiccInfo2Callback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_14$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.getEuiccInfo2(cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$authenticateServer(String callingPackage, String cardId, String matchingId, byte[] serverSigned1, byte[] serverSignature1, byte[] euiccCiPkIdToBeUsed, byte[] serverCertificate, IAuthenticateServerCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("authenticateServer callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IAuthenticateServerCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$__constructor__(EuiccCardController this$0, IAuthenticateServerCallback iAuthenticateServerCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("authenticateServer callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$onException(Throwable e) {
                try {
                    EuiccCardController.loge("authenticateServer callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("authenticateServer callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IAuthenticateServerCallback iAuthenticateServerCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$__constructor__(euiccCardController, iAuthenticateServerCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iAuthenticateServerCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IAuthenticateServerCallback ), 0, this, euiccCardController, iAuthenticateServerCallback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_15$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.authenticateServer(matchingId, serverSigned1, serverSignature1, euiccCiPkIdToBeUsed, serverCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$prepareDownload(String callingPackage, String cardId, byte[] hashCc, byte[] smdpSigned2, byte[] smdpSignature2, byte[] smdpCertificate, IPrepareDownloadCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("prepareDownload callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IPrepareDownloadCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$__constructor__(EuiccCardController this$0, IPrepareDownloadCallback iPrepareDownloadCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("prepareDownload callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$onException(Throwable e) {
                try {
                    EuiccCardController.loge("prepareDownload callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("prepareDownload callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IPrepareDownloadCallback iPrepareDownloadCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$__constructor__(euiccCardController, iPrepareDownloadCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iPrepareDownloadCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IPrepareDownloadCallback ), 0, this, euiccCardController, iPrepareDownloadCallback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_16$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.prepareDownload(hashCc, smdpSigned2, smdpSignature2, smdpCertificate, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loadBoundProfilePackage(String callingPackage, String cardId, byte[] boundProfilePackage, ILoadBoundProfilePackageCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ILoadBoundProfilePackageCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$__constructor__(EuiccCardController this$0, ILoadBoundProfilePackageCallback iLoadBoundProfilePackageCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$onResult(byte[] result) {
                Log.i("EuiccCardController", "Request subscription info list refresh after install.");
                SubscriptionController.getInstance().requestEmbeddedSubscriptionInfoListRefresh();
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$onException(Throwable e) {
                try {
                    EuiccCardController.loge("loadBoundProfilePackage callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("loadBoundProfilePackage callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, ILoadBoundProfilePackageCallback iLoadBoundProfilePackageCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$__constructor__(euiccCardController, iLoadBoundProfilePackageCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iLoadBoundProfilePackageCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback ), 0, this, euiccCardController, iLoadBoundProfilePackageCallback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_17$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.loadBoundProfilePackage(boundProfilePackage, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$cancelSession(String callingPackage, String cardId, byte[] transactionId, int reason, ICancelSessionCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("cancelSession callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<byte[]> cardCb = new AsyncResultCallback<byte[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ICancelSessionCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$__constructor__(EuiccCardController this$0, ICancelSessionCallback iCancelSessionCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$onResult(byte[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("cancelSession callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$onException(Throwable e) {
                try {
                    EuiccCardController.loge("cancelSession callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("cancelSession callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, ICancelSessionCallback iCancelSessionCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$__constructor__(euiccCardController, iCancelSessionCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iCancelSessionCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.ICancelSessionCallback ), 0, this, euiccCardController, iCancelSessionCallback);
            }

            @Override
            public void onResult(byte[] byArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$onResult(byte[] ), 0, this, byArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_18$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.cancelSession(transactionId, reason, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$listNotifications(String callingPackage, String cardId, int events, IListNotificationsCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("listNotifications callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IListNotificationsCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$__constructor__(EuiccCardController this$0, IListNotificationsCallback iListNotificationsCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$onResult(EuiccNotification[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("listNotifications callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$onException(Throwable e) {
                try {
                    EuiccCardController.loge("listNotifications callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("listNotifications callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IListNotificationsCallback iListNotificationsCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$__constructor__(euiccCardController, iListNotificationsCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iListNotificationsCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IListNotificationsCallback ), 0, this, euiccCardController, iListNotificationsCallback);
            }

            @Override
            public void onResult(EuiccNotification[] euiccNotificationArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$onResult(android.telephony.euicc.EuiccNotification[] ), 0, this, euiccNotificationArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_19$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.listNotifications(events, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$retrieveNotificationList(String callingPackage, String cardId, int events, IRetrieveNotificationListCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification[]> cardCb = new AsyncResultCallback<EuiccNotification[]>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IRetrieveNotificationListCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$__constructor__(EuiccCardController this$0, IRetrieveNotificationListCallback iRetrieveNotificationListCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$onResult(EuiccNotification[] result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$onException(Throwable e) {
                try {
                    EuiccCardController.loge("retrieveNotificationList callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotificationList callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IRetrieveNotificationListCallback iRetrieveNotificationListCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$__constructor__(euiccCardController, iRetrieveNotificationListCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iRetrieveNotificationListCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IRetrieveNotificationListCallback ), 0, this, euiccCardController, iRetrieveNotificationListCallback);
            }

            @Override
            public void onResult(EuiccNotification[] euiccNotificationArray) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$onResult(android.telephony.euicc.EuiccNotification[] ), 0, this, euiccNotificationArray);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_20$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.retrieveNotificationList(events, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$retrieveNotification(String callingPackage, String cardId, int seqNumber, IRetrieveNotificationCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2, null);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("retrieveNotification callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<EuiccNotification> cardCb = new AsyncResultCallback<EuiccNotification>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IRetrieveNotificationCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$__constructor__(EuiccCardController this$0, IRetrieveNotificationCallback iRetrieveNotificationCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$onResult(EuiccNotification result) {
                try {
                    this.val$callback.onComplete(0, result);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotification callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$onException(Throwable e) {
                try {
                    EuiccCardController.loge("retrieveNotification callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e), null);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("retrieveNotification callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IRetrieveNotificationCallback iRetrieveNotificationCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$__constructor__(euiccCardController, iRetrieveNotificationCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iRetrieveNotificationCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IRetrieveNotificationCallback ), 0, this, euiccCardController, iRetrieveNotificationCallback);
            }

            @Override
            public void onResult(EuiccNotification euiccNotification) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$onResult(android.telephony.euicc.EuiccNotification ), 0, this, euiccNotification);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_21$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.retrieveNotification(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$removeNotificationFromList(String callingPackage, String cardId, int seqNumber, IRemoveNotificationFromListCallback callback) {
        this.checkCallingPackage(callingPackage);
        EuiccCard card = this.getEuiccCard(cardId);
        if (card == null) {
            try {
                callback.onComplete(-2);
            }
            catch (RemoteException exception) {
                EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
            }
            return;
        }
        AsyncResultCallback<Void> cardCb = new AsyncResultCallback<Void>(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IRemoveNotificationFromListCallback val$callback;
            /* synthetic */ EuiccCardController this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$__constructor__(EuiccCardController this$0, IRemoveNotificationFromListCallback iRemoveNotificationFromListCallback) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$onResult(Void result) {
                try {
                    this.val$callback.onComplete(0);
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
                }
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$onException(Throwable e) {
                try {
                    EuiccCardController.loge("removeNotificationFromList callback onException: ", e);
                    this.val$callback.onComplete(this.this$0.getResultCode(e));
                }
                catch (RemoteException exception) {
                    EuiccCardController.loge("removeNotificationFromList callback failure.", exception);
                }
            }

            private void __constructor__(EuiccCardController euiccCardController, IRemoveNotificationFromListCallback iRemoveNotificationFromListCallback) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$__constructor__(euiccCardController, iRemoveNotificationFromListCallback);
            }
            {
                this.this$0 = euiccCardController;
                this.val$callback = iRemoveNotificationFromListCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$__constructor__(com.android.internal.telephony.euicc.EuiccCardController com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback ), 0, this, euiccCardController, iRemoveNotificationFromListCallback);
            }

            @Override
            public void onResult(Void void_) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$onResult(java.lang.Void ), 0, this, void_);
            }

            @Override
            public void onException(Throwable throwable) {
                InvokeDynamicSupport.bootstrap("onException", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_22$onException(java.lang.Throwable ), 0, this, throwable);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        card.removeNotificationFromList(seqNumber, cardCb, this.mEuiccMainThreadHandler);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        super.dump(fd, pw, args);
        pw.println("mCallingPackage=" + this.mCallingPackage);
        pw.println("mBestComponent=" + this.mBestComponent);
        Binder.restoreCallingIdentity(token);
    }

    private static final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loge(String message) {
        Log.e("EuiccCardController", message);
    }

    private static final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loge(String message, Throwable tr) {
        Log.e("EuiccCardController", message, tr);
    }

    public static EuiccCardController init(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("init", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$init(android.content.Context ), 0, (Context)context);
    }

    public static EuiccCardController get() {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$get(), 0);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(context);
    }

    private EuiccCardController(Context context) {
        this(context, new Handler(), EuiccController.get(), UiccController.getInstance());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, Handler handler, EuiccController euiccController, UiccController uiccController) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(context, handler, euiccController, uiccController);
    }

    public EuiccCardController(Context context, Handler handler, EuiccController euiccController, UiccController uiccController) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$__constructor__(android.content.Context android.os.Handler com.android.internal.telephony.euicc.EuiccController com.android.internal.telephony.uicc.UiccController ), 0, this, context, handler, euiccController, uiccController);
    }

    public static boolean isBootUp(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBootUp", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$isBootUp(android.content.Context ), 0, (Context)context);
    }

    public boolean isEmbeddedSlotActivated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmbeddedSlotActivated", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$isEmbeddedSlotActivated(), 0, this);
    }

    private void checkCallingPackage(String string2) {
        InvokeDynamicSupport.bootstrap("checkCallingPackage", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$checkCallingPackage(java.lang.String ), 0, this, string2);
    }

    private EuiccCard getEuiccCard(String string2) {
        return InvokeDynamicSupport.bootstrap("getEuiccCard", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccCard(java.lang.String ), 0, this, string2);
    }

    private int getResultCode(Throwable throwable) {
        return (int)InvokeDynamicSupport.bootstrap("getResultCode", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getResultCode(java.lang.Throwable ), 0, this, throwable);
    }

    @Override
    public void getAllProfiles(String string2, String string3, IGetAllProfilesCallback iGetAllProfilesCallback) {
        InvokeDynamicSupport.bootstrap("getAllProfiles", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getAllProfiles(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetAllProfilesCallback ), 0, this, string2, string3, iGetAllProfilesCallback);
    }

    @Override
    public void getProfile(String string2, String string3, String string4, IGetProfileCallback iGetProfileCallback) {
        InvokeDynamicSupport.bootstrap("getProfile", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getProfile(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetProfileCallback ), 0, this, string2, string3, string4, iGetProfileCallback);
    }

    @Override
    public void disableProfile(String string2, String string3, String string4, boolean bl, IDisableProfileCallback iDisableProfileCallback) {
        InvokeDynamicSupport.bootstrap("disableProfile", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$disableProfile(java.lang.String java.lang.String java.lang.String boolean com.android.internal.telephony.euicc.IDisableProfileCallback ), 0, this, string2, string3, string4, bl, iDisableProfileCallback);
    }

    @Override
    public void switchToProfile(String string2, String string3, String string4, boolean bl, ISwitchToProfileCallback iSwitchToProfileCallback) {
        InvokeDynamicSupport.bootstrap("switchToProfile", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$switchToProfile(java.lang.String java.lang.String java.lang.String boolean com.android.internal.telephony.euicc.ISwitchToProfileCallback ), 0, this, string2, string3, string4, bl, iSwitchToProfileCallback);
    }

    @Override
    public void setNickname(String string2, String string3, String string4, String string5, ISetNicknameCallback iSetNicknameCallback) {
        InvokeDynamicSupport.bootstrap("setNickname", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$setNickname(java.lang.String java.lang.String java.lang.String java.lang.String com.android.internal.telephony.euicc.ISetNicknameCallback ), 0, this, string2, string3, string4, string5, iSetNicknameCallback);
    }

    @Override
    public void deleteProfile(String string2, String string3, String string4, IDeleteProfileCallback iDeleteProfileCallback) {
        InvokeDynamicSupport.bootstrap("deleteProfile", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$deleteProfile(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.euicc.IDeleteProfileCallback ), 0, this, string2, string3, string4, iDeleteProfileCallback);
    }

    @Override
    public void resetMemory(String string2, String string3, int n, IResetMemoryCallback iResetMemoryCallback) {
        InvokeDynamicSupport.bootstrap("resetMemory", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$resetMemory(java.lang.String java.lang.String int com.android.internal.telephony.euicc.IResetMemoryCallback ), 0, this, string2, string3, n, iResetMemoryCallback);
    }

    @Override
    public void getDefaultSmdpAddress(String string2, String string3, IGetDefaultSmdpAddressCallback iGetDefaultSmdpAddressCallback) {
        InvokeDynamicSupport.bootstrap("getDefaultSmdpAddress", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getDefaultSmdpAddress(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetDefaultSmdpAddressCallback ), 0, this, string2, string3, iGetDefaultSmdpAddressCallback);
    }

    @Override
    public void getSmdsAddress(String string2, String string3, IGetSmdsAddressCallback iGetSmdsAddressCallback) {
        InvokeDynamicSupport.bootstrap("getSmdsAddress", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getSmdsAddress(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetSmdsAddressCallback ), 0, this, string2, string3, iGetSmdsAddressCallback);
    }

    @Override
    public void setDefaultSmdpAddress(String string2, String string3, String string4, ISetDefaultSmdpAddressCallback iSetDefaultSmdpAddressCallback) {
        InvokeDynamicSupport.bootstrap("setDefaultSmdpAddress", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$setDefaultSmdpAddress(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.euicc.ISetDefaultSmdpAddressCallback ), 0, this, string2, string3, string4, iSetDefaultSmdpAddressCallback);
    }

    @Override
    public void getRulesAuthTable(String string2, String string3, IGetRulesAuthTableCallback iGetRulesAuthTableCallback) {
        InvokeDynamicSupport.bootstrap("getRulesAuthTable", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getRulesAuthTable(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetRulesAuthTableCallback ), 0, this, string2, string3, iGetRulesAuthTableCallback);
    }

    @Override
    public void getEuiccChallenge(String string2, String string3, IGetEuiccChallengeCallback iGetEuiccChallengeCallback) {
        InvokeDynamicSupport.bootstrap("getEuiccChallenge", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccChallenge(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetEuiccChallengeCallback ), 0, this, string2, string3, iGetEuiccChallengeCallback);
    }

    @Override
    public void getEuiccInfo1(String string2, String string3, IGetEuiccInfo1Callback iGetEuiccInfo1Callback) {
        InvokeDynamicSupport.bootstrap("getEuiccInfo1", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccInfo1(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetEuiccInfo1Callback ), 0, this, string2, string3, iGetEuiccInfo1Callback);
    }

    @Override
    public void getEuiccInfo2(String string2, String string3, IGetEuiccInfo2Callback iGetEuiccInfo2Callback) {
        InvokeDynamicSupport.bootstrap("getEuiccInfo2", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$getEuiccInfo2(java.lang.String java.lang.String com.android.internal.telephony.euicc.IGetEuiccInfo2Callback ), 0, this, string2, string3, iGetEuiccInfo2Callback);
    }

    @Override
    public void authenticateServer(String string2, String string3, String string4, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, IAuthenticateServerCallback iAuthenticateServerCallback) {
        InvokeDynamicSupport.bootstrap("authenticateServer", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$authenticateServer(java.lang.String java.lang.String java.lang.String byte[] byte[] byte[] byte[] com.android.internal.telephony.euicc.IAuthenticateServerCallback ), 0, this, string2, string3, string4, byArray, byArray2, byArray3, byArray4, iAuthenticateServerCallback);
    }

    @Override
    public void prepareDownload(String string2, String string3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, IPrepareDownloadCallback iPrepareDownloadCallback) {
        InvokeDynamicSupport.bootstrap("prepareDownload", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$prepareDownload(java.lang.String java.lang.String byte[] byte[] byte[] byte[] com.android.internal.telephony.euicc.IPrepareDownloadCallback ), 0, this, string2, string3, byArray, byArray2, byArray3, byArray4, iPrepareDownloadCallback);
    }

    @Override
    public void loadBoundProfilePackage(String string2, String string3, byte[] byArray, ILoadBoundProfilePackageCallback iLoadBoundProfilePackageCallback) {
        InvokeDynamicSupport.bootstrap("loadBoundProfilePackage", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loadBoundProfilePackage(java.lang.String java.lang.String byte[] com.android.internal.telephony.euicc.ILoadBoundProfilePackageCallback ), 0, this, string2, string3, byArray, iLoadBoundProfilePackageCallback);
    }

    @Override
    public void cancelSession(String string2, String string3, byte[] byArray, int n, ICancelSessionCallback iCancelSessionCallback) {
        InvokeDynamicSupport.bootstrap("cancelSession", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$cancelSession(java.lang.String java.lang.String byte[] int com.android.internal.telephony.euicc.ICancelSessionCallback ), 0, this, string2, string3, byArray, n, iCancelSessionCallback);
    }

    @Override
    public void listNotifications(String string2, String string3, int n, IListNotificationsCallback iListNotificationsCallback) {
        InvokeDynamicSupport.bootstrap("listNotifications", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$listNotifications(java.lang.String java.lang.String int com.android.internal.telephony.euicc.IListNotificationsCallback ), 0, this, string2, string3, n, iListNotificationsCallback);
    }

    @Override
    public void retrieveNotificationList(String string2, String string3, int n, IRetrieveNotificationListCallback iRetrieveNotificationListCallback) {
        InvokeDynamicSupport.bootstrap("retrieveNotificationList", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$retrieveNotificationList(java.lang.String java.lang.String int com.android.internal.telephony.euicc.IRetrieveNotificationListCallback ), 0, this, string2, string3, n, iRetrieveNotificationListCallback);
    }

    @Override
    public void retrieveNotification(String string2, String string3, int n, IRetrieveNotificationCallback iRetrieveNotificationCallback) {
        InvokeDynamicSupport.bootstrap("retrieveNotification", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$retrieveNotification(java.lang.String java.lang.String int com.android.internal.telephony.euicc.IRetrieveNotificationCallback ), 0, this, string2, string3, n, iRetrieveNotificationCallback);
    }

    @Override
    public void removeNotificationFromList(String string2, String string3, int n, IRemoveNotificationFromListCallback iRemoveNotificationFromListCallback) {
        InvokeDynamicSupport.bootstrap("removeNotificationFromList", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$removeNotificationFromList(java.lang.String java.lang.String int com.android.internal.telephony.euicc.IRemoveNotificationFromListCallback ), 0, this, string2, string3, n, iRemoveNotificationFromListCallback);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private static void loge(String string2) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loge(java.lang.String ), 0, (String)string2);
    }

    private static void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("loge", $$robo$$com_android_internal_telephony_euicc_EuiccCardController$loge(java.lang.String java.lang.Throwable ), 0, (String)string2, (Throwable)throwable);
    }

    public /* synthetic */ EuiccCardController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccCardController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SimSlotStatusChangedBroadcastReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccCardController this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$__constructor__(EuiccCardController euiccCardController) {
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$onReceive(Context context, Intent intent) {
            if ("android.telephony.action.SIM_SLOT_STATUS_CHANGED".equals(intent.getAction())) {
                if (this.this$0.isEmbeddedSlotActivated()) {
                    this.this$0.mEuiccController.startOtaUpdatingIfNecessary();
                }
                this.this$0.mContext.unregisterReceiver(this.this$0.mSimSlotStatusChangeReceiver);
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$__constructor__(EuiccCardController x0, 1 x1) {
        }

        private void __constructor__(EuiccCardController euiccCardController) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$__constructor__(euiccCardController);
        }

        private SimSlotStatusChangedBroadcastReceiver(EuiccCardController euiccCardController) {
            this.this$0 = euiccCardController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$__constructor__(com.android.internal.telephony.euicc.EuiccCardController ), 0, this, euiccCardController);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        private /* synthetic */ void __constructor__(EuiccCardController euiccCardController, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccCardController_SimSlotStatusChangedBroadcastReceiver$__constructor__(euiccCardController, var2_2);
        }

        public /* synthetic */ SimSlotStatusChangedBroadcastReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimSlotStatusChangedBroadcastReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

