/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.euicc;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.euicc.GetDefaultDownloadableSubscriptionListResult;
import android.service.euicc.GetDownloadableSubscriptionMetadataResult;
import android.service.euicc.GetEuiccProfileInfoListResult;
import android.service.euicc.IDeleteSubscriptionCallback;
import android.service.euicc.IDownloadSubscriptionCallback;
import android.service.euicc.IEraseSubscriptionsCallback;
import android.service.euicc.IEuiccService;
import android.service.euicc.IGetDefaultDownloadableSubscriptionListCallback;
import android.service.euicc.IGetDownloadableSubscriptionMetadataCallback;
import android.service.euicc.IGetEidCallback;
import android.service.euicc.IGetEuiccInfoCallback;
import android.service.euicc.IGetEuiccProfileInfoListCallback;
import android.service.euicc.IGetOtaStatusCallback;
import android.service.euicc.IOtaStatusChangedCallback;
import android.service.euicc.IRetainSubscriptionsForFactoryResetCallback;
import android.service.euicc.ISwitchToSubscriptionCallback;
import android.service.euicc.IUpdateSubscriptionNicknameCallback;
import android.telephony.euicc.DownloadableSubscription;
import android.telephony.euicc.EuiccInfo;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.content.PackageMonitor;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EuiccConnector
extends StateMachine
implements ServiceConnection,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "EuiccConnector";
    private static int BIND_TIMEOUT_MILLIS = 30000;
    @VisibleForTesting
    static int LINGER_TIMEOUT_MILLIS = 60000;
    private static int CMD_PACKAGE_CHANGE = 1;
    private static int CMD_CONNECT_TIMEOUT = 2;
    private static int CMD_LINGER_TIMEOUT = 3;
    private static int CMD_SERVICE_CONNECTED = 4;
    private static int CMD_SERVICE_DISCONNECTED = 5;
    private static int CMD_COMMAND_COMPLETE = 6;
    private static int CMD_GET_EID = 100;
    private static int CMD_GET_DOWNLOADABLE_SUBSCRIPTION_METADATA = 101;
    private static int CMD_DOWNLOAD_SUBSCRIPTION = 102;
    private static int CMD_GET_EUICC_PROFILE_INFO_LIST = 103;
    private static int CMD_GET_DEFAULT_DOWNLOADABLE_SUBSCRIPTION_LIST = 104;
    private static int CMD_GET_EUICC_INFO = 105;
    private static int CMD_DELETE_SUBSCRIPTION = 106;
    private static int CMD_SWITCH_TO_SUBSCRIPTION = 107;
    private static int CMD_UPDATE_SUBSCRIPTION_NICKNAME = 108;
    private static int CMD_ERASE_SUBSCRIPTIONS = 109;
    private static int CMD_RETAIN_SUBSCRIPTIONS = 110;
    private static int CMD_GET_OTA_STATUS = 111;
    private static int CMD_START_OTA_IF_NECESSARY = 112;
    private static int EUICC_QUERY_FLAGS = 0x10100040;
    private Context mContext;
    private PackageManager mPm;
    private PackageMonitor mPackageMonitor;
    private BroadcastReceiver mUserUnlockedReceiver;
    private ServiceInfo mSelectedComponent;
    private IEuiccService mEuiccService;
    private Set<BaseEuiccCommandCallback> mActiveCommandCallbacks;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public UnavailableState mUnavailableState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public AvailableState mAvailableState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public BindingState mBindingState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public DisconnectedState mDisconnectedState;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public ConnectedState mConnectedState;

    private static final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector$isEuiccCommand(int what) {
        return what >= 100;
    }

    private static final ActivityInfo $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestActivity(PackageManager packageManager, Intent intent) {
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivities(intent, 0x10100040);
        ActivityInfo bestComponent = (ActivityInfo)EuiccConnector.findBestComponent(packageManager, resolveInfoList);
        if (bestComponent == null) {
            Log.w("EuiccConnector", "No valid component found for intent: " + intent);
        }
        return bestComponent;
    }

    private static final ComponentInfo $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent(PackageManager packageManager) {
        Intent intent = new Intent("android.service.euicc.EuiccService");
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentServices(intent, 0x10100040);
        ComponentInfo bestComponent = EuiccConnector.findBestComponent(packageManager, resolveInfoList);
        if (bestComponent == null) {
            Log.w("EuiccConnector", "No valid EuiccService implementation found");
        }
        return bestComponent;
    }

    private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(Context context) {
        this.mPackageMonitor = new EuiccPackageMonitor(this);
        this.mUserUnlockedReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ EuiccConnector this$0;

            private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_1$__constructor__(EuiccConnector this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_1$onReceive(Context context, Intent intent) {
                if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
                    this.this$0.sendMessage(1);
                }
            }

            private void __constructor__(EuiccConnector euiccConnector) {
                this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_1$__constructor__(euiccConnector);
            }
            {
                this.this$0 = euiccConnector;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_1$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mActiveCommandCallbacks = new ArraySet<BaseEuiccCommandCallback>();
        this.init(context);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(Context context, Looper looper) {
        this.mPackageMonitor = new EuiccPackageMonitor(this);
        this.mUserUnlockedReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mActiveCommandCallbacks = new ArraySet<BaseEuiccCommandCallback>();
        this.init(context);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$init(Context context) {
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUnavailableState = new UnavailableState(this);
        this.addState(this.mUnavailableState);
        this.mAvailableState = new AvailableState(this);
        this.addState(this.mAvailableState, this.mUnavailableState);
        this.mBindingState = new BindingState(this);
        this.addState(this.mBindingState);
        this.mDisconnectedState = new DisconnectedState(this);
        this.addState(this.mDisconnectedState);
        this.mConnectedState = new ConnectedState(this);
        this.addState(this.mConnectedState, this.mDisconnectedState);
        this.mSelectedComponent = this.findBestComponent();
        this.setInitialState(this.mSelectedComponent != null ? this.mAvailableState : this.mUnavailableState);
        this.mPackageMonitor.register(this.mContext, null, false);
        this.mContext.registerReceiver(this.mUserUnlockedReceiver, new IntentFilter("android.intent.action.USER_UNLOCKED"));
        this.start();
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onHalting() {
        this.mPackageMonitor.unregister();
        this.mContext.unregisterReceiver(this.mUserUnlockedReceiver);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEid(GetEidCommandCallback callback) {
        this.sendMessage(100, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getOtaStatus(GetOtaStatusCommandCallback callback) {
        this.sendMessage(111, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$startOtaIfNecessary(OtaStatusChangedCallback callback) {
        this.sendMessage(112, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getDownloadableSubscriptionMetadata(DownloadableSubscription subscription, boolean forceDeactivateSim, GetMetadataCommandCallback callback) {
        GetMetadataRequest request = new GetMetadataRequest();
        request.mSubscription = subscription;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(101, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$downloadSubscription(DownloadableSubscription subscription, boolean switchAfterDownload, boolean forceDeactivateSim, DownloadCommandCallback callback) {
        DownloadRequest request = new DownloadRequest();
        request.mSubscription = subscription;
        request.mSwitchAfterDownload = switchAfterDownload;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(102, request);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEuiccProfileInfoList(GetEuiccProfileInfoListCommandCallback callback) {
        this.sendMessage(103, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getDefaultDownloadableSubscriptionList(boolean forceDeactivateSim, GetDefaultListCommandCallback callback) {
        GetDefaultListRequest request = new GetDefaultListRequest();
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(104, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEuiccInfo(GetEuiccInfoCommandCallback callback) {
        this.sendMessage(105, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$deleteSubscription(String iccid, DeleteCommandCallback callback) {
        DeleteRequest request = new DeleteRequest();
        request.mIccid = iccid;
        request.mCallback = callback;
        this.sendMessage(106, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$switchToSubscription(String iccid, boolean forceDeactivateSim, SwitchCommandCallback callback) {
        SwitchRequest request = new SwitchRequest();
        request.mIccid = iccid;
        request.mForceDeactivateSim = forceDeactivateSim;
        request.mCallback = callback;
        this.sendMessage(107, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$updateSubscriptionNickname(String iccid, String nickname, UpdateNicknameCommandCallback callback) {
        UpdateNicknameRequest request = new UpdateNicknameRequest();
        request.mIccid = iccid;
        request.mNickname = nickname;
        request.mCallback = callback;
        this.sendMessage(108, request);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$eraseSubscriptions(EraseCommandCallback callback) {
        this.sendMessage(109, callback);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$retainSubscriptions(RetainSubscriptionsCommandCallback callback) {
        this.sendMessage(110, callback);
    }

    private static final BaseEuiccCommandCallback $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getCallback(Message message) {
        switch (message.what) {
            case 100: 
            case 103: 
            case 105: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return (BaseEuiccCommandCallback)message.obj;
            }
            case 101: {
                return ((GetMetadataRequest)message.obj).mCallback;
            }
            case 102: {
                return ((DownloadRequest)message.obj).mCallback;
            }
            case 104: {
                return ((GetDefaultListRequest)message.obj).mCallback;
            }
            case 106: {
                return ((DeleteRequest)message.obj).mCallback;
            }
            case 107: {
                return ((SwitchRequest)message.obj).mCallback;
            }
            case 108: {
                return ((UpdateNicknameRequest)message.obj).mCallback;
            }
        }
        throw new IllegalArgumentException("Unsupported message: " + message.what);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onCommandStart(BaseEuiccCommandCallback callback) {
        this.mActiveCommandCallbacks.add(callback);
        this.removeMessages(3);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onCommandEnd(BaseEuiccCommandCallback callback) {
        if (!this.mActiveCommandCallbacks.remove(callback)) {
            Log.wtf("EuiccConnector", "Callback already removed from mActiveCommandCallbacks");
        }
        if (this.mActiveCommandCallbacks.isEmpty()) {
            this.sendMessageDelayed(3, 60000L);
        }
    }

    private final ServiceInfo $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent() {
        return (ServiceInfo)EuiccConnector.findBestComponent(this.mPm);
    }

    private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector$createBinding() {
        if (this.mSelectedComponent == null) {
            Log.wtf("EuiccConnector", "Attempting to create binding but no component is selected");
            return false;
        }
        Intent intent = new Intent("android.service.euicc.EuiccService");
        intent.setComponent(this.mSelectedComponent.getComponentName());
        return this.mContext.bindService(intent, this, 0x4000001);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$unbind() {
        this.mEuiccService = null;
        this.mContext.unbindService(this);
    }

    private static final ComponentInfo $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent(PackageManager packageManager, List<ResolveInfo> resolveInfoList) {
        int bestPriority = Integer.MIN_VALUE;
        ComponentInfo bestComponent = null;
        if (resolveInfoList != null) {
            for (ResolveInfo resolveInfo : resolveInfoList) {
                if (!EuiccConnector.isValidEuiccComponent(packageManager, resolveInfo) || resolveInfo.filter.getPriority() <= bestPriority) continue;
                bestPriority = resolveInfo.filter.getPriority();
                bestComponent = resolveInfo.getComponentInfo();
            }
        }
        return bestComponent;
    }

    private static final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector$isValidEuiccComponent(PackageManager packageManager, ResolveInfo resolveInfo) {
        String permission2;
        ComponentInfo componentInfo = resolveInfo.getComponentInfo();
        String packageName = componentInfo.getComponentName().getPackageName();
        if (packageManager.checkPermission("android.permission.WRITE_EMBEDDED_SUBSCRIPTIONS", packageName) != 0) {
            Log.wtf("EuiccConnector", "Package " + packageName + " does not declare WRITE_EMBEDDED_SUBSCRIPTIONS");
            return false;
        }
        if (componentInfo instanceof ServiceInfo) {
            permission2 = ((ServiceInfo)componentInfo).permission;
        } else if (componentInfo instanceof ActivityInfo) {
            permission2 = ((ActivityInfo)componentInfo).permission;
        } else {
            throw new IllegalArgumentException("Can only verify services/activities");
        }
        if (!TextUtils.equals(permission2, "android.permission.BIND_EUICC_SERVICE")) {
            Log.wtf("EuiccConnector", "Package " + packageName + " does not require the BIND_EUICC_SERVICE permission");
            return false;
        }
        if (resolveInfo.filter == null || resolveInfo.filter.getPriority() == 0) {
            Log.wtf("EuiccConnector", "Package " + packageName + " does not specify a priority");
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onServiceConnected(ComponentName name, IBinder service) {
        IEuiccService euiccService = IEuiccService.Stub.asInterface(service);
        this.sendMessage(4, euiccService);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onServiceDisconnected(ComponentName name) {
        this.sendMessage(5);
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$unhandledMessage(Message msg) {
        IState state = this.getCurrentState();
        Log.wtf("EuiccConnector", "Unhandled message " + msg.what + " in state " + (state == null ? "null" : state.getName()));
    }

    private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        super.dump(fd, pw, args);
        pw.println("mSelectedComponent=" + this.mSelectedComponent);
        pw.println("mEuiccService=" + this.mEuiccService);
        pw.println("mActiveCommandCount=" + this.mActiveCommandCallbacks.size());
    }

    private static boolean isEuiccCommand(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEuiccCommand", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$isEuiccCommand(int ), 0, (int)n);
    }

    public static ActivityInfo findBestActivity(PackageManager packageManager, Intent intent) {
        return InvokeDynamicSupport.bootstrapStatic("findBestActivity", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestActivity(android.content.pm.PackageManager android.content.Intent ), 0, (PackageManager)packageManager, (Intent)intent);
    }

    public static ComponentInfo findBestComponent(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrapStatic("findBestComponent", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent(android.content.pm.PackageManager ), 0, (PackageManager)packageManager);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(context);
    }

    EuiccConnector(Context context) {
        super("EuiccConnector");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(context, looper);
    }

    public EuiccConnector(Context context, Looper looper) {
        super("EuiccConnector", looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$__constructor__(android.content.Context android.os.Looper ), 0, this, context, looper);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$init(android.content.Context ), 0, this, context);
    }

    @Override
    public void onHalting() {
        InvokeDynamicSupport.bootstrap("onHalting", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onHalting(), 0, this);
    }

    public void getEid(GetEidCommandCallback getEidCommandCallback) {
        InvokeDynamicSupport.bootstrap("getEid", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEid(com.android.internal.telephony.euicc.EuiccConnector$GetEidCommandCallback ), 0, this, getEidCommandCallback);
    }

    public void getOtaStatus(GetOtaStatusCommandCallback getOtaStatusCommandCallback) {
        InvokeDynamicSupport.bootstrap("getOtaStatus", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getOtaStatus(com.android.internal.telephony.euicc.EuiccConnector$GetOtaStatusCommandCallback ), 0, this, getOtaStatusCommandCallback);
    }

    public void startOtaIfNecessary(OtaStatusChangedCallback otaStatusChangedCallback) {
        InvokeDynamicSupport.bootstrap("startOtaIfNecessary", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$startOtaIfNecessary(com.android.internal.telephony.euicc.EuiccConnector$OtaStatusChangedCallback ), 0, this, otaStatusChangedCallback);
    }

    public void getDownloadableSubscriptionMetadata(DownloadableSubscription downloadableSubscription, boolean bl, GetMetadataCommandCallback getMetadataCommandCallback) {
        InvokeDynamicSupport.bootstrap("getDownloadableSubscriptionMetadata", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getDownloadableSubscriptionMetadata(android.telephony.euicc.DownloadableSubscription boolean com.android.internal.telephony.euicc.EuiccConnector$GetMetadataCommandCallback ), 0, this, downloadableSubscription, bl, getMetadataCommandCallback);
    }

    public void downloadSubscription(DownloadableSubscription downloadableSubscription, boolean bl, boolean bl2, DownloadCommandCallback downloadCommandCallback) {
        InvokeDynamicSupport.bootstrap("downloadSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$downloadSubscription(android.telephony.euicc.DownloadableSubscription boolean boolean com.android.internal.telephony.euicc.EuiccConnector$DownloadCommandCallback ), 0, this, downloadableSubscription, bl, bl2, downloadCommandCallback);
    }

    void getEuiccProfileInfoList(GetEuiccProfileInfoListCommandCallback getEuiccProfileInfoListCommandCallback) {
        InvokeDynamicSupport.bootstrap("getEuiccProfileInfoList", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEuiccProfileInfoList(com.android.internal.telephony.euicc.EuiccConnector$GetEuiccProfileInfoListCommandCallback ), 0, this, getEuiccProfileInfoListCommandCallback);
    }

    public void getDefaultDownloadableSubscriptionList(boolean bl, GetDefaultListCommandCallback getDefaultListCommandCallback) {
        InvokeDynamicSupport.bootstrap("getDefaultDownloadableSubscriptionList", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getDefaultDownloadableSubscriptionList(boolean com.android.internal.telephony.euicc.EuiccConnector$GetDefaultListCommandCallback ), 0, this, bl, getDefaultListCommandCallback);
    }

    public void getEuiccInfo(GetEuiccInfoCommandCallback getEuiccInfoCommandCallback) {
        InvokeDynamicSupport.bootstrap("getEuiccInfo", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getEuiccInfo(com.android.internal.telephony.euicc.EuiccConnector$GetEuiccInfoCommandCallback ), 0, this, getEuiccInfoCommandCallback);
    }

    public void deleteSubscription(String string2, DeleteCommandCallback deleteCommandCallback) {
        InvokeDynamicSupport.bootstrap("deleteSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$deleteSubscription(java.lang.String com.android.internal.telephony.euicc.EuiccConnector$DeleteCommandCallback ), 0, this, string2, deleteCommandCallback);
    }

    public void switchToSubscription(String string2, boolean bl, SwitchCommandCallback switchCommandCallback) {
        InvokeDynamicSupport.bootstrap("switchToSubscription", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$switchToSubscription(java.lang.String boolean com.android.internal.telephony.euicc.EuiccConnector$SwitchCommandCallback ), 0, this, string2, bl, switchCommandCallback);
    }

    public void updateSubscriptionNickname(String string2, String string3, UpdateNicknameCommandCallback updateNicknameCommandCallback) {
        InvokeDynamicSupport.bootstrap("updateSubscriptionNickname", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$updateSubscriptionNickname(java.lang.String java.lang.String com.android.internal.telephony.euicc.EuiccConnector$UpdateNicknameCommandCallback ), 0, this, string2, string3, updateNicknameCommandCallback);
    }

    public void eraseSubscriptions(EraseCommandCallback eraseCommandCallback) {
        InvokeDynamicSupport.bootstrap("eraseSubscriptions", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$eraseSubscriptions(com.android.internal.telephony.euicc.EuiccConnector$EraseCommandCallback ), 0, this, eraseCommandCallback);
    }

    public void retainSubscriptions(RetainSubscriptionsCommandCallback retainSubscriptionsCommandCallback) {
        InvokeDynamicSupport.bootstrap("retainSubscriptions", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$retainSubscriptions(com.android.internal.telephony.euicc.EuiccConnector$RetainSubscriptionsCommandCallback ), 0, this, retainSubscriptionsCommandCallback);
    }

    private static BaseEuiccCommandCallback getCallback(Message message) {
        return InvokeDynamicSupport.bootstrapStatic("getCallback", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$getCallback(android.os.Message ), 0, (Message)message);
    }

    private void onCommandStart(BaseEuiccCommandCallback baseEuiccCommandCallback) {
        InvokeDynamicSupport.bootstrap("onCommandStart", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onCommandStart(com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, baseEuiccCommandCallback);
    }

    private void onCommandEnd(BaseEuiccCommandCallback baseEuiccCommandCallback) {
        InvokeDynamicSupport.bootstrap("onCommandEnd", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onCommandEnd(com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, baseEuiccCommandCallback);
    }

    private ServiceInfo findBestComponent() {
        return InvokeDynamicSupport.bootstrap("findBestComponent", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent(), 0, this);
    }

    private boolean createBinding() {
        return (boolean)InvokeDynamicSupport.bootstrap("createBinding", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$createBinding(), 0, this);
    }

    private void unbind() {
        InvokeDynamicSupport.bootstrap("unbind", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$unbind(), 0, this);
    }

    private static ComponentInfo findBestComponent(PackageManager packageManager, List<ResolveInfo> list) {
        return InvokeDynamicSupport.bootstrapStatic("findBestComponent", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$findBestComponent(android.content.pm.PackageManager java.util.List<android.content.pm.ResolveInfo> ), 0, (PackageManager)packageManager, list);
    }

    private static boolean isValidEuiccComponent(PackageManager packageManager, ResolveInfo resolveInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidEuiccComponent", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$isValidEuiccComponent(android.content.pm.PackageManager android.content.pm.ResolveInfo ), 0, (PackageManager)packageManager, (ResolveInfo)resolveInfo);
    }

    @Override
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
    }

    @Override
    public void onServiceDisconnected(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
    }

    @Override
    protected void unhandledMessage(Message message) {
        InvokeDynamicSupport.bootstrap("unhandledMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$unhandledMessage(android.os.Message ), 0, this, message);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_euicc_EuiccConnector$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ EuiccConnector() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccConnector)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class EuiccPackageMonitor
    extends PackageMonitor
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$__constructor__(EuiccConnector euiccConnector) {
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageAdded(String packageName, int reason) {
            this.sendPackageChange(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageRemoved(String packageName, int reason) {
            this.sendPackageChange(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageUpdateFinished(String packageName, int uid) {
            this.sendPackageChange(packageName, true);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageModified(String packageName) {
            this.sendPackageChange(packageName, false);
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.sendPackageChange(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$sendPackageChange(String packageName, boolean forceUnbindForThisPackage) {
            this.this$0.sendMessage(1, forceUnbindForThisPackage ? packageName : null);
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$__constructor__(euiccConnector);
        }

        private EuiccPackageMonitor(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public void onPackageAdded(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageAdded", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageAdded(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageRemoved(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageRemoved", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageRemoved(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageUpdateFinished(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageUpdateFinished", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageUpdateFinished(java.lang.String int ), 0, this, string2, n);
        }

        @Override
        public void onPackageModified(String string2) {
            InvokeDynamicSupport.bootstrap("onPackageModified", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onPackageModified(java.lang.String ), 0, this, string2);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("onHandleForceStop", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$onHandleForceStop(android.content.Intent java.lang.String[] int boolean ), 0, this, intent, stringArray, n, bl);
        }

        private void sendPackageChange(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("sendPackageChange", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$sendPackageChange(java.lang.String boolean ), 0, this, string2, bl);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_EuiccPackageMonitor$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ EuiccPackageMonitor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccPackageMonitor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ConnectedState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$__constructor__(EuiccConnector euiccConnector) {
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$enter() {
            this.this$0.removeMessages(2);
            this.this$0.sendMessageDelayed(3, 60000L);
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$processMessage(Message message) {
            if (message.what == 5) {
                this.this$0.mEuiccService = null;
                this.this$0.transitionTo(this.this$0.mDisconnectedState);
                return true;
            }
            if (message.what == 3) {
                this.this$0.unbind();
                this.this$0.transitionTo(this.this$0.mAvailableState);
                return true;
            }
            if (message.what == 6) {
                Runnable runnable = (Runnable)message.obj;
                runnable.run();
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                BaseEuiccCommandCallback callback = EuiccConnector.getCallback(message);
                this.this$0.onCommandStart(callback);
                int slotId = -1;
                try {
                    switch (message.what) {
                        case 100: {
                            this.this$0.mEuiccService.getEid(slotId, (IGetEidCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_1$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_1$onSuccess(String eid) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetEidCommandCallback)this.val$callback).onGetEidComplete(eid);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_1$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_1$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onSuccess(String string2) {
                                    InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_1$onSuccess(java.lang.String ), 0, this, string2);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 101: {
                            GetMetadataRequest request = (GetMetadataRequest)message.obj;
                            this.this$0.mEuiccService.getDownloadableSubscriptionMetadata(slotId, request.mSubscription, request.mForceDeactivateSim, (IGetDownloadableSubscriptionMetadataCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_2$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_2$onComplete(GetDownloadableSubscriptionMetadataResult result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetMetadataCommandCallback)this.val$callback).onGetMetadataComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_2$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_2$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(GetDownloadableSubscriptionMetadataResult getDownloadableSubscriptionMetadataResult) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_2$onComplete(android.service.euicc.GetDownloadableSubscriptionMetadataResult ), 0, this, getDownloadableSubscriptionMetadataResult);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 102: {
                            DownloadRequest request = (DownloadRequest)message.obj;
                            this.this$0.mEuiccService.downloadSubscription(slotId, request.mSubscription, request.mSwitchAfterDownload, request.mForceDeactivateSim, (IDownloadSubscriptionCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_3$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_3$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((DownloadCommandCallback)this.val$callback).onDownloadComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_3$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_3$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_3$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 103: {
                            this.this$0.mEuiccService.getEuiccProfileInfoList(slotId, (IGetEuiccProfileInfoListCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_4$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_4$onComplete(GetEuiccProfileInfoListResult result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetEuiccProfileInfoListCommandCallback)this.val$callback).onListComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_4$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_4$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(GetEuiccProfileInfoListResult getEuiccProfileInfoListResult) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_4$onComplete(android.service.euicc.GetEuiccProfileInfoListResult ), 0, this, getEuiccProfileInfoListResult);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 104: {
                            GetDefaultListRequest request = (GetDefaultListRequest)message.obj;
                            this.this$0.mEuiccService.getDefaultDownloadableSubscriptionList(slotId, request.mForceDeactivateSim, (IGetDefaultDownloadableSubscriptionListCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_5$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_5$onComplete(GetDefaultDownloadableSubscriptionListResult result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetDefaultListCommandCallback)this.val$callback).onGetDefaultListComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_5$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_5$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(GetDefaultDownloadableSubscriptionListResult getDefaultDownloadableSubscriptionListResult) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_5$onComplete(android.service.euicc.GetDefaultDownloadableSubscriptionListResult ), 0, this, getDefaultDownloadableSubscriptionListResult);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 105: {
                            this.this$0.mEuiccService.getEuiccInfo(slotId, (IGetEuiccInfoCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_6$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_6$onSuccess(EuiccInfo euiccInfo) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetEuiccInfoCommandCallback)this.val$callback).onGetEuiccInfoComplete(euiccInfo);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_6$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_6$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onSuccess(EuiccInfo euiccInfo) {
                                    InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_6$onSuccess(android.telephony.euicc.EuiccInfo ), 0, this, euiccInfo);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 106: {
                            DeleteRequest request = (DeleteRequest)message.obj;
                            this.this$0.mEuiccService.deleteSubscription(slotId, request.mIccid, (IDeleteSubscriptionCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_7$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_7$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((DeleteCommandCallback)this.val$callback).onDeleteComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_7$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_7$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_7$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 107: {
                            SwitchRequest request = (SwitchRequest)message.obj;
                            this.this$0.mEuiccService.switchToSubscription(slotId, request.mIccid, request.mForceDeactivateSim, (ISwitchToSubscriptionCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_8$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_8$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((SwitchCommandCallback)this.val$callback).onSwitchComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_8$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_8$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_8$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 108: {
                            UpdateNicknameRequest request = (UpdateNicknameRequest)message.obj;
                            this.this$0.mEuiccService.updateSubscriptionNickname(slotId, request.mIccid, request.mNickname, (IUpdateSubscriptionNicknameCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_9$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_9$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((UpdateNicknameCommandCallback)this.val$callback).onUpdateNicknameComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_9$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_9$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_9$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 109: {
                            this.this$0.mEuiccService.eraseSubscriptions(slotId, (IEraseSubscriptionsCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_10$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_10$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((EraseCommandCallback)this.val$callback).onEraseComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_10$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_10$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_10$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 110: {
                            this.this$0.mEuiccService.retainSubscriptionsForFactoryReset(slotId, (IRetainSubscriptionsForFactoryResetCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_11$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_11$onComplete(int result) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((RetainSubscriptionsCommandCallback)this.val$callback).onRetainSubscriptionsComplete(result);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_11$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_11$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onComplete(int n) {
                                    InvokeDynamicSupport.bootstrap("onComplete", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_11$onComplete(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 111: {
                            this.this$0.mEuiccService.getOtaStatus(slotId, (IGetOtaStatusCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_12$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_12$onSuccess(int status) {
                                    this.this$1.this$0.sendMessage(6, () -> {
                                        ((GetOtaStatusCommandCallback)this.val$callback).onGetOtaStatusComplete(status);
                                        this.this$1.this$0.onCommandEnd(this.val$callback);
                                    });
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_12$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_12$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onSuccess(int n) {
                                    InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_12$onSuccess(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        case 112: {
                            this.this$0.mEuiccService.startOtaIfNecessary(slotId, (IOtaStatusChangedCallback)new ShadowedObject(this, callback){
                                public transient /* synthetic */ Object __robo_data__;
                                /* synthetic */ BaseEuiccCommandCallback val$callback;
                                /* synthetic */ ConnectedState this$1;

                                private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_13$__constructor__(ConnectedState this$1, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                }

                                private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_13$onOtaStatusChanged(int status) throws RemoteException {
                                    if (status == 1) {
                                        this.this$1.this$0.sendMessage(6, () -> ((OtaStatusChangedCallback)this.val$callback).onOtaStatusChanged(status));
                                    } else {
                                        this.this$1.this$0.sendMessage(6, () -> {
                                            ((OtaStatusChangedCallback)this.val$callback).onOtaStatusChanged(status);
                                            this.this$1.this$0.onCommandEnd(this.val$callback);
                                        });
                                    }
                                }

                                private void __constructor__(ConnectedState connectedState, BaseEuiccCommandCallback baseEuiccCommandCallback) {
                                    this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_13$__constructor__(connectedState, baseEuiccCommandCallback);
                                }
                                {
                                    this.this$1 = connectedState;
                                    this.val$callback = baseEuiccCommandCallback;
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_13$__constructor__(com.android.internal.telephony.euicc.EuiccConnector$ConnectedState com.android.internal.telephony.euicc.EuiccConnector$BaseEuiccCommandCallback ), 0, this, connectedState, baseEuiccCommandCallback);
                                }

                                @Override
                                public void onOtaStatusChanged(int n) throws RemoteException {
                                    InvokeDynamicSupport.bootstrap("onOtaStatusChanged", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState_13$onOtaStatusChanged(int ), 0, this, n);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            break;
                        }
                        default: {
                            Log.wtf("EuiccConnector", "Unimplemented eUICC command: " + message.what);
                            callback.onEuiccServiceUnavailable();
                            this.this$0.onCommandEnd(callback);
                            return true;
                        }
                    }
                }
                catch (Exception e) {
                    Log.w("EuiccConnector", "Exception making binder call to EuiccService", e);
                    callback.onEuiccServiceUnavailable();
                    this.this$0.onCommandEnd(callback);
                }
                return true;
            }
            return false;
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$exit() {
            this.this$0.removeMessages(3);
            for (BaseEuiccCommandCallback callback : this.this$0.mActiveCommandCallbacks) {
                callback.onEuiccServiceUnavailable();
            }
            this.this$0.mActiveCommandCallbacks.clear();
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$__constructor__(euiccConnector);
        }

        private ConnectedState(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$processMessage(android.os.Message ), 0, this, message);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$exit(), 0, this);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_ConnectedState$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ ConnectedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DisconnectedState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$__constructor__(EuiccConnector euiccConnector) {
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$enter() {
            this.this$0.sendMessageDelayed(2, 30000L);
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$processMessage(Message message) {
            if (message.what == 4) {
                this.this$0.mEuiccService = (IEuiccService)message.obj;
                this.this$0.transitionTo(this.this$0.mConnectedState);
                return true;
            }
            if (message.what == 1) {
                boolean forceRebind;
                ServiceInfo bestComponent = this.this$0.findBestComponent();
                String affectedPackage = (String)message.obj;
                boolean isSameComponent = bestComponent == null ? this.this$0.mSelectedComponent != null : this.this$0.mSelectedComponent == null || Objects.equals(bestComponent.getComponentName(), this.this$0.mSelectedComponent.getComponentName());
                boolean bl = forceRebind = bestComponent != null && Objects.equals(bestComponent.packageName, affectedPackage);
                if (!isSameComponent || forceRebind) {
                    this.this$0.unbind();
                    this.this$0.mSelectedComponent = bestComponent;
                    if (this.this$0.mSelectedComponent == null) {
                        this.this$0.transitionTo(this.this$0.mUnavailableState);
                    } else {
                        this.this$0.transitionTo(this.this$0.mBindingState);
                    }
                }
                return true;
            }
            if (message.what == 2) {
                this.this$0.transitionTo(this.this$0.mAvailableState);
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                this.this$0.deferMessage(message);
                return true;
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$__constructor__(euiccConnector);
        }

        private DisconnectedState(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_DisconnectedState$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ DisconnectedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisconnectedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BindingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$__constructor__(EuiccConnector euiccConnector) {
        }

        private final void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$enter() {
            if (this.this$0.createBinding()) {
                this.this$0.transitionTo(this.this$0.mDisconnectedState);
            } else {
                this.this$0.transitionTo(this.this$0.mAvailableState);
            }
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$processMessage(Message message) {
            this.this$0.deferMessage(message);
            return true;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$__constructor__(euiccConnector);
        }

        private BindingState(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_BindingState$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ BindingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BindingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AvailableState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$__constructor__(EuiccConnector euiccConnector) {
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$processMessage(Message message) {
            if (EuiccConnector.isEuiccCommand(message.what)) {
                this.this$0.deferMessage(message);
                this.this$0.transitionTo(this.this$0.mBindingState);
                return true;
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$__constructor__(euiccConnector);
        }

        private AvailableState(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_AvailableState$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ AvailableState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AvailableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class UnavailableState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ EuiccConnector this$0;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$__constructor__(EuiccConnector euiccConnector) {
        }

        private final boolean $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$processMessage(Message message) {
            if (message.what == 1) {
                this.this$0.mSelectedComponent = this.this$0.findBestComponent();
                if (this.this$0.mSelectedComponent != null) {
                    this.this$0.transitionTo(this.this$0.mAvailableState);
                } else if (this.this$0.getCurrentState() != this.this$0.mUnavailableState) {
                    this.this$0.transitionTo(this.this$0.mUnavailableState);
                }
                return true;
            }
            if (EuiccConnector.isEuiccCommand(message.what)) {
                BaseEuiccCommandCallback callback = EuiccConnector.getCallback(message);
                callback.onEuiccServiceUnavailable();
                return true;
            }
            return false;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$__constructor__(EuiccConnector x0, 1 x1) {
        }

        private void __constructor__(EuiccConnector euiccConnector) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$__constructor__(euiccConnector);
        }

        private UnavailableState(EuiccConnector euiccConnector) {
            this.this$0 = euiccConnector;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$__constructor__(com.android.internal.telephony.euicc.EuiccConnector ), 0, this, euiccConnector);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$processMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(EuiccConnector euiccConnector, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_UnavailableState$__constructor__(euiccConnector, var2_2);
        }

        public /* synthetic */ UnavailableState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnavailableState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface RetainSubscriptionsCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onRetainSubscriptionsComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface EraseCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onEraseComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface UpdateNicknameCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onUpdateNicknameComplete(int var1);
    }

    public static class UpdateNicknameRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mIccid;
        String mNickname;
        UpdateNicknameCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UpdateNicknameRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_UpdateNicknameRequest$__constructor__();
        }

        UpdateNicknameRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_UpdateNicknameRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UpdateNicknameRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface SwitchCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onSwitchComplete(int var1);
    }

    public static class SwitchRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mIccid;
        boolean mForceDeactivateSim;
        SwitchCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_SwitchRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_SwitchRequest$__constructor__();
        }

        SwitchRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_SwitchRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SwitchRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface DeleteCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onDeleteComplete(int var1);
    }

    public static class DeleteRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mIccid;
        DeleteCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DeleteRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_DeleteRequest$__constructor__();
        }

        DeleteRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DeleteRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeleteRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetEuiccInfoCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onGetEuiccInfoComplete(EuiccInfo var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetDefaultListCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onGetDefaultListComplete(GetDefaultDownloadableSubscriptionListResult var1);
    }

    public static class GetDefaultListRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean mForceDeactivateSim;
        GetDefaultListCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetDefaultListRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetDefaultListRequest$__constructor__();
        }

        GetDefaultListRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetDefaultListRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetDefaultListRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface GetEuiccProfileInfoListCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onListComplete(GetEuiccProfileInfoListResult var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface DownloadCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onDownloadComplete(int var1);
    }

    public static class DownloadRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        DownloadableSubscription mSubscription;
        boolean mSwitchAfterDownload;
        boolean mForceDeactivateSim;
        DownloadCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DownloadRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_DownloadRequest$__constructor__();
        }

        DownloadRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_DownloadRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DownloadRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetMetadataCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onGetMetadataComplete(GetDownloadableSubscriptionMetadataResult var1);
    }

    public static class GetMetadataRequest
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        DownloadableSubscription mSubscription;
        boolean mForceDeactivateSim;
        GetMetadataCommandCallback mCallback;

        private void $$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetMetadataRequest$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetMetadataRequest$__constructor__();
        }

        GetMetadataRequest() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_euicc_EuiccConnector_GetMetadataRequest$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GetMetadataRequest)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface OtaStatusChangedCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onOtaStatusChanged(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetOtaStatusCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onGetOtaStatusComplete(int var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface GetEidCommandCallback
    extends BaseEuiccCommandCallback,
    InstrumentedInterface {
        public void onGetEidComplete(String var1);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static interface BaseEuiccCommandCallback
    extends InstrumentedInterface {
        public void onEuiccServiceUnavailable();
    }
}

