/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.SmsCbCmasInfo;
import android.telephony.SmsCbEtwsInfo;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsCbHeader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int PDU_HEADER_LENGTH = 6;
    static int FORMAT_GSM = 1;
    static int FORMAT_UMTS = 2;
    static int FORMAT_ETWS_PRIMARY = 3;
    private static int MESSAGE_TYPE_CBS_MESSAGE = 1;
    private static int PDU_LENGTH_GSM = 88;
    private static int PDU_LENGTH_ETWS = 56;
    private int mGeographicalScope;
    private int mSerialNumber;
    private int mMessageIdentifier;
    private int mDataCodingScheme;
    private int mPageIndex;
    private int mNrOfPages;
    private int mFormat;
    private SmsCbEtwsInfo mEtwsInfo;
    private SmsCbCmasInfo mCmasInfo;

    private void $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$__constructor__(byte[] pdu) throws IllegalArgumentException {
        if (pdu == null || pdu.length < 6) {
            throw new IllegalArgumentException("Illegal PDU");
        }
        if (pdu.length <= 88) {
            this.mGeographicalScope = (pdu[0] & 0xC0) >>> 6;
            this.mSerialNumber = (pdu[0] & 0xFF) << 8 | pdu[1] & 0xFF;
            this.mMessageIdentifier = (pdu[2] & 0xFF) << 8 | pdu[3] & 0xFF;
            if (this.isEtwsMessage() && pdu.length <= 56) {
                this.mFormat = 3;
                this.mDataCodingScheme = -1;
                this.mPageIndex = -1;
                this.mNrOfPages = -1;
                boolean emergencyUserAlert = (pdu[4] & 1) != 0;
                boolean activatePopup = (pdu[5] & 0x80) != 0;
                int warningType = (pdu[4] & 0xFE) >>> 1;
                byte[] warningSecurityInfo = pdu.length > 6 ? Arrays.copyOfRange(pdu, 6, pdu.length) : null;
                this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, true, warningSecurityInfo);
                this.mCmasInfo = null;
                return;
            }
            this.mFormat = 1;
            this.mDataCodingScheme = pdu[4] & 0xFF;
            int pageIndex = (pdu[5] & 0xF0) >>> 4;
            int nrOfPages = pdu[5] & 0xF;
            if (pageIndex == 0 || nrOfPages == 0 || pageIndex > nrOfPages) {
                pageIndex = 1;
                nrOfPages = 1;
            }
            this.mPageIndex = pageIndex;
            this.mNrOfPages = nrOfPages;
        } else {
            this.mFormat = 2;
            byte messageType = pdu[0];
            if (messageType != 1) {
                throw new IllegalArgumentException("Unsupported message type " + messageType);
            }
            this.mMessageIdentifier = (pdu[1] & 0xFF) << 8 | pdu[2] & 0xFF;
            this.mGeographicalScope = (pdu[3] & 0xC0) >>> 6;
            this.mSerialNumber = (pdu[3] & 0xFF) << 8 | pdu[4] & 0xFF;
            this.mDataCodingScheme = pdu[5] & 0xFF;
            this.mPageIndex = 1;
            this.mNrOfPages = 1;
        }
        if (this.isEtwsMessage()) {
            boolean emergencyUserAlert = this.isEtwsEmergencyUserAlert();
            boolean activatePopup = this.isEtwsPopupAlert();
            int warningType = this.getEtwsWarningType();
            this.mEtwsInfo = new SmsCbEtwsInfo(warningType, emergencyUserAlert, activatePopup, false, null);
            this.mCmasInfo = null;
        } else if (this.isCmasMessage()) {
            int messageClass = this.getCmasMessageClass();
            int severity = this.getCmasSeverity();
            int urgency = this.getCmasUrgency();
            int certainty = this.getCmasCertainty();
            this.mEtwsInfo = null;
            this.mCmasInfo = new SmsCbCmasInfo(messageClass, -1, -1, severity, urgency, certainty);
        } else {
            this.mEtwsInfo = null;
            this.mCmasInfo = null;
        }
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getGeographicalScope() {
        return this.mGeographicalScope;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getSerialNumber() {
        return this.mSerialNumber;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getServiceCategory() {
        return this.mMessageIdentifier;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getDataCodingScheme() {
        return this.mDataCodingScheme;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getPageIndex() {
        return this.mPageIndex;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getNumberOfPages() {
        return this.mNrOfPages;
    }

    private final SmsCbEtwsInfo $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getEtwsInfo() {
        return this.mEtwsInfo;
    }

    private final SmsCbCmasInfo $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasInfo() {
        return this.mCmasInfo;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEmergencyMessage() {
        return this.mMessageIdentifier >= 4352 && this.mMessageIdentifier <= 6399;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsMessage() {
        return (this.mMessageIdentifier & 0xFFF8) == 4352;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsPrimaryNotification() {
        return this.mFormat == 3;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isUmtsFormat() {
        return this.mFormat == 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isCmasMessage() {
        return this.mMessageIdentifier >= 4370 && this.mMessageIdentifier <= 4399;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsPopupAlert() {
        return (this.mSerialNumber & 0x1000) != 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsEmergencyUserAlert() {
        return (this.mSerialNumber & 0x2000) != 0;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getEtwsWarningType() {
        return this.mMessageIdentifier - 4352;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasMessageClass() {
        switch (this.mMessageIdentifier) {
            case 4370: 
            case 4383: {
                return 0;
            }
            case 4371: 
            case 4372: 
            case 4384: 
            case 4385: {
                return 1;
            }
            case 4373: 
            case 4374: 
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: 
            case 4386: 
            case 4387: 
            case 4388: 
            case 4389: 
            case 4390: 
            case 4391: {
                return 2;
            }
            case 4379: 
            case 4392: {
                return 3;
            }
            case 4380: 
            case 4393: {
                return 4;
            }
            case 4381: 
            case 4394: {
                return 5;
            }
            case 4382: 
            case 4395: {
                return 6;
            }
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasSeverity() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4372: 
            case 4373: 
            case 4374: 
            case 4384: 
            case 4385: 
            case 4386: 
            case 4387: {
                return 0;
            }
            case 4375: 
            case 4376: 
            case 4377: 
            case 4378: 
            case 4388: 
            case 4389: 
            case 4390: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasUrgency() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4372: 
            case 4375: 
            case 4376: 
            case 4384: 
            case 4385: 
            case 4388: 
            case 4389: {
                return 0;
            }
            case 4373: 
            case 4374: 
            case 4377: 
            case 4378: 
            case 4386: 
            case 4387: 
            case 4390: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasCertainty() {
        switch (this.mMessageIdentifier) {
            case 4371: 
            case 4373: 
            case 4375: 
            case 4377: 
            case 4384: 
            case 4386: 
            case 4388: 
            case 4390: {
                return 0;
            }
            case 4372: 
            case 4374: 
            case 4376: 
            case 4378: 
            case 4385: 
            case 4387: 
            case 4389: 
            case 4391: {
                return 1;
            }
        }
        return -1;
    }

    private final String $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$toString() {
        return "SmsCbHeader{GS=" + this.mGeographicalScope + ", serialNumber=0x" + Integer.toHexString(this.mSerialNumber) + ", messageIdentifier=0x" + Integer.toHexString(this.mMessageIdentifier) + ", format=" + this.mFormat + ", DCS=0x" + Integer.toHexString(this.mDataCodingScheme) + ", page " + this.mPageIndex + " of " + this.mNrOfPages + '}';
    }

    private void __constructor__(byte[] byArray) throws IllegalArgumentException {
        this.$$robo$$com_android_internal_telephony_gsm_SmsCbHeader$__constructor__(byArray);
    }

    public SmsCbHeader(byte[] byArray) throws IllegalArgumentException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$__constructor__(byte[] ), 0, this, byArray);
    }

    int getGeographicalScope() {
        return (int)InvokeDynamicSupport.bootstrap("getGeographicalScope", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getGeographicalScope(), 0, this);
    }

    int getSerialNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getSerialNumber", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getSerialNumber(), 0, this);
    }

    int getServiceCategory() {
        return (int)InvokeDynamicSupport.bootstrap("getServiceCategory", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getServiceCategory(), 0, this);
    }

    int getDataCodingScheme() {
        return (int)InvokeDynamicSupport.bootstrap("getDataCodingScheme", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getDataCodingScheme(), 0, this);
    }

    int getPageIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getPageIndex", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getPageIndex(), 0, this);
    }

    int getNumberOfPages() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfPages", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getNumberOfPages(), 0, this);
    }

    SmsCbEtwsInfo getEtwsInfo() {
        return InvokeDynamicSupport.bootstrap("getEtwsInfo", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getEtwsInfo(), 0, this);
    }

    SmsCbCmasInfo getCmasInfo() {
        return InvokeDynamicSupport.bootstrap("getCmasInfo", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasInfo(), 0, this);
    }

    boolean isEmergencyMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyMessage", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEmergencyMessage(), 0, this);
    }

    private boolean isEtwsMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEtwsMessage", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsMessage(), 0, this);
    }

    boolean isEtwsPrimaryNotification() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEtwsPrimaryNotification", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsPrimaryNotification(), 0, this);
    }

    boolean isUmtsFormat() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUmtsFormat", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isUmtsFormat(), 0, this);
    }

    private boolean isCmasMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCmasMessage", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isCmasMessage(), 0, this);
    }

    private boolean isEtwsPopupAlert() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEtwsPopupAlert", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsPopupAlert(), 0, this);
    }

    private boolean isEtwsEmergencyUserAlert() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEtwsEmergencyUserAlert", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$isEtwsEmergencyUserAlert(), 0, this);
    }

    private int getEtwsWarningType() {
        return (int)InvokeDynamicSupport.bootstrap("getEtwsWarningType", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getEtwsWarningType(), 0, this);
    }

    private int getCmasMessageClass() {
        return (int)InvokeDynamicSupport.bootstrap("getCmasMessageClass", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasMessageClass(), 0, this);
    }

    private int getCmasSeverity() {
        return (int)InvokeDynamicSupport.bootstrap("getCmasSeverity", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasSeverity(), 0, this);
    }

    private int getCmasUrgency() {
        return (int)InvokeDynamicSupport.bootstrap("getCmasUrgency", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasUrgency(), 0, this);
    }

    private int getCmasCertainty() {
        return (int)InvokeDynamicSupport.bootstrap("getCmasCertainty", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$getCmasCertainty(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_gsm_SmsCbHeader$toString(), 0, this);
    }

    public /* synthetic */ SmsCbHeader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsCbHeader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

