/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UsimPhoneBookManager
extends Handler
implements IccConstants,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "UsimPhoneBookManager";
    private static boolean DBG = true;
    private ArrayList<PbrRecord> mPbrRecords;
    private Boolean mIsPbrPresent;
    private IccFileHandler mFh;
    private AdnRecordCache mAdnCache;
    private Object mLock;
    private ArrayList<AdnRecord> mPhoneBookRecords;
    private ArrayList<byte[]> mIapFileRecord;
    private ArrayList<byte[]> mEmailFileRecord;
    private SparseArray<ArrayList<String>> mEmailsForAdnRec;
    private SparseIntArray mSfiEfidTable;
    private boolean mRefreshCache;
    private static int EVENT_PBR_LOAD_DONE = 1;
    private static int EVENT_USIM_ADN_LOAD_DONE = 2;
    private static int EVENT_IAP_LOAD_DONE = 3;
    private static int EVENT_EMAIL_LOAD_DONE = 4;
    private static int USIM_TYPE1_TAG = 168;
    private static int USIM_TYPE2_TAG = 169;
    private static int USIM_TYPE3_TAG = 170;
    private static int USIM_EFADN_TAG = 192;
    private static int USIM_EFIAP_TAG = 193;
    private static int USIM_EFEXT1_TAG = 194;
    private static int USIM_EFSNE_TAG = 195;
    private static int USIM_EFANR_TAG = 196;
    private static int USIM_EFPBC_TAG = 197;
    private static int USIM_EFGRP_TAG = 198;
    private static int USIM_EFAAS_TAG = 199;
    private static int USIM_EFGSD_TAG = 200;
    private static int USIM_EFUID_TAG = 201;
    private static int USIM_EFEMAIL_TAG = 202;
    private static int USIM_EFCCP1_TAG = 203;
    private static int INVALID_SFI = -1;
    private static byte INVALID_BYTE = -1;

    private void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(IccFileHandler fh, AdnRecordCache cache) {
        this.mLock = new Object();
        this.mRefreshCache = false;
        this.mFh = fh;
        this.mPhoneBookRecords = new ArrayList();
        this.mPbrRecords = null;
        this.mIsPbrPresent = true;
        this.mAdnCache = cache;
        this.mEmailsForAdnRec = new SparseArray();
        this.mSfiEfidTable = new SparseIntArray();
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$reset() {
        this.mPhoneBookRecords.clear();
        this.mIapFileRecord = null;
        this.mEmailFileRecord = null;
        this.mPbrRecords = null;
        this.mIsPbrPresent = true;
        this.mRefreshCache = false;
        this.mEmailsForAdnRec.clear();
        this.mSfiEfidTable.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ArrayList<AdnRecord> $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$loadEfFilesFromUsim() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPhoneBookRecords.isEmpty()) {
                if (this.mRefreshCache) {
                    this.mRefreshCache = false;
                    this.refreshCache();
                }
                return this.mPhoneBookRecords;
            }
            if (!this.mIsPbrPresent.booleanValue()) {
                return null;
            }
            if (this.mPbrRecords == null) {
                this.readPbrFileAndWait();
            }
            if (this.mPbrRecords == null) {
                return null;
            }
            int numRecs = this.mPbrRecords.size();
            this.log("loadEfFilesFromUsim: Loading adn and emails");
            for (int i = 0; i < numRecs; ++i) {
                this.readAdnFileAndWait(i);
                this.readEmailFileAndWait(i);
            }
            this.updatePhoneAdnRecord();
        }
        return this.mPhoneBookRecords;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$refreshCache() {
        if (this.mPbrRecords == null) {
            return;
        }
        this.mPhoneBookRecords.clear();
        int numRecs = this.mPbrRecords.size();
        for (int i = 0; i < numRecs; ++i) {
            this.readAdnFileAndWait(i);
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$invalidateCache() {
        this.mRefreshCache = true;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readPbrFileAndWait() {
        this.mFh.loadEFLinearFixedAll(20272, this.obtainMessage(1));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readAdnFileAndWait");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailFileAndWait(int recId) {
        SparseArray files = this.mPbrRecords.get(recId).mFileIds;
        if (files == null) {
            return;
        }
        File email = (File)files.get(202);
        if (email != null) {
            if (email.getParentTag() == 169) {
                if (files.get(193) == null) {
                    Rlog.e("UsimPhoneBookManager", "Can't locate EF_IAP in EF_PBR.");
                    return;
                }
                this.log("EF_IAP exists. Loading EF_IAP to retrieve the index.");
                this.readIapFileAndWait(((File)files.get(193)).getEfid());
                if (this.mIapFileRecord == null) {
                    Rlog.e("UsimPhoneBookManager", "Error: IAP file is empty");
                    return;
                }
                this.log("EF_EMAIL order in PBR record: " + email.getIndex());
            }
            int emailEfid = email.getEfid();
            this.log("EF_EMAIL exists in PBR. efid = 0x" + Integer.toHexString(emailEfid).toUpperCase());
            for (int i = 0; i < recId; ++i) {
                File id2;
                SparseArray previousFileIds;
                if (this.mPbrRecords.get(i) == null || (previousFileIds = this.mPbrRecords.get(i).mFileIds) == null || (id2 = (File)previousFileIds.get(202)) == null || id2.getEfid() != emailEfid) continue;
                this.log("Skipped this EF_EMAIL which was loaded earlier");
                return;
            }
            this.mFh.loadEFLinearFixedAll(emailEfid, this.obtainMessage(4));
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readEmailFileAndWait");
            }
            if (this.mEmailFileRecord == null) {
                Rlog.e("UsimPhoneBookManager", "Error: Email file is empty");
                return;
            }
            if (email.getParentTag() == 169 && this.mIapFileRecord != null) {
                this.buildType2EmailList(recId);
            } else {
                this.buildType1EmailList(recId);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$buildType1EmailList(int recId) {
        if (this.mPbrRecords.get(recId) == null) {
            return;
        }
        int numRecs = this.mPbrRecords.get(recId).mMasterFileRecordNum;
        this.log("Building type 1 email list. recId = " + recId + ", numRecs = " + numRecs);
        for (int i = 0; i < numRecs; ++i) {
            byte[] emailRec;
            try {
                emailRec = this.mEmailFileRecord.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                Rlog.e("UsimPhoneBookManager", "Error: Improper ICC card: No email record for ADN, continuing");
                break;
            }
            byte sfi = emailRec[emailRec.length - 2];
            byte adnRecId = emailRec[emailRec.length - 1];
            String email = this.readEmailRecord(i);
            if (email == null || email.equals("")) continue;
            int adnEfid = 0;
            if (sfi == -1 || this.mSfiEfidTable.get(sfi) == 0) {
                File file = (File)this.mPbrRecords.get(recId).mFileIds.get(192);
                if (file == null) continue;
                adnEfid = file.getEfid();
            } else {
                adnEfid = this.mSfiEfidTable.get(sfi);
            }
            int index = (adnEfid & 0xFFFF) << 8 | adnRecId - 1 & 0xFF;
            ArrayList<String> emailList = this.mEmailsForAdnRec.get(index);
            if (emailList == null) {
                emailList = new ArrayList();
            }
            this.log("Adding email #" + i + " list to index 0x" + Integer.toHexString(index).toUpperCase());
            emailList.add(email);
            this.mEmailsForAdnRec.put(index, emailList);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$buildType2EmailList(int recId) {
        if (this.mPbrRecords.get(recId) == null) {
            return false;
        }
        int numRecs = this.mPbrRecords.get(recId).mMasterFileRecordNum;
        this.log("Building type 2 email list. recId = " + recId + ", numRecs = " + numRecs);
        File adnFile = (File)this.mPbrRecords.get(recId).mFileIds.get(192);
        if (adnFile == null) {
            Rlog.e("UsimPhoneBookManager", "Error: Improper ICC card: EF_ADN does not exist in PBR files");
            return false;
        }
        int adnEfid = adnFile.getEfid();
        for (int i = 0; i < numRecs; ++i) {
            byte emailRecId;
            try {
                byte[] record = this.mIapFileRecord.get(i);
                emailRecId = record[((File)this.mPbrRecords.get(recId).mFileIds.get(202)).getIndex()];
            }
            catch (IndexOutOfBoundsException e) {
                Rlog.e("UsimPhoneBookManager", "Error: Improper ICC card: Corrupted EF_IAP");
                continue;
            }
            String email = this.readEmailRecord(emailRecId - 1);
            if (email == null || email.equals("")) continue;
            int index = (adnEfid & 0xFFFF) << 8 | i & 0xFF;
            ArrayList<String> emailList = this.mEmailsForAdnRec.get(index);
            if (emailList == null) {
                emailList = new ArrayList();
            }
            emailList.add(email);
            this.log("Adding email list to index 0x" + Integer.toHexString(index).toUpperCase());
            this.mEmailsForAdnRec.put(index, emailList);
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readIapFileAndWait(int efid) {
        this.mFh.loadEFLinearFixedAll(efid, this.obtainMessage(3));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readIapFileAndWait");
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$updatePhoneAdnRecord() {
        int numAdnRecs = this.mPhoneBookRecords.size();
        for (int i = 0; i < numAdnRecs; ++i) {
            ArrayList<String> emailList;
            AdnRecord rec = this.mPhoneBookRecords.get(i);
            int adnEfid = rec.getEfid();
            int adnRecId = rec.getRecId();
            int index = (adnEfid & 0xFFFF) << 8 | adnRecId - 1 & 0xFF;
            try {
                emailList = this.mEmailsForAdnRec.get(index);
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            if (emailList == null) continue;
            String[] emails = new String[emailList.size()];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)emailList.toArray(), (int)0, (Object)emails, (int)0, (int)emailList.size());
            rec.setEmails(emails);
            this.log("Adding email list to ADN (0x" + Integer.toHexString(this.mPhoneBookRecords.get(i).getEfid()).toUpperCase() + ") record #" + this.mPhoneBookRecords.get(i).getRecId());
            this.mPhoneBookRecords.set(i, rec);
        }
    }

    private final String $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailRecord(int recId) {
        byte[] emailRec;
        try {
            emailRec = this.mEmailFileRecord.get(recId);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return IccUtils.adnStringFieldToString(emailRec, 0, emailRec.length - 2);
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readAdnFileAndWait(int recId) {
        SparseArray files = this.mPbrRecords.get(recId).mFileIds;
        if (files == null || files.size() == 0) {
            return;
        }
        int extEf = 0;
        if (files.get(194) != null) {
            extEf = ((File)files.get(194)).getEfid();
        }
        if (files.get(192) == null) {
            return;
        }
        int previousSize = this.mPhoneBookRecords.size();
        this.mAdnCache.requestLoadAllAdnLike(((File)files.get(192)).getEfid(), extEf, this.obtainMessage(2));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e("UsimPhoneBookManager", "Interrupted Exception in readAdnFileAndWait");
        }
        this.mPbrRecords.get(recId).mMasterFileRecordNum = this.mPhoneBookRecords.size() - previousSize;
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$createPbrFile(ArrayList<byte[]> records) {
        if (records == null) {
            this.mPbrRecords = null;
            this.mIsPbrPresent = false;
            return;
        }
        this.mPbrRecords = new ArrayList();
        for (int i = 0; i < records.size(); ++i) {
            if (records.get(i)[0] == -1) continue;
            this.mPbrRecords.add(new PbrRecord(this, records.get(i)));
        }
        for (PbrRecord record : this.mPbrRecords) {
            int sfi;
            File file = (File)record.mFileIds.get(192);
            if (file == null || (sfi = file.getSfi()) == -1) continue;
            this.mSfiEfidTable.put(sfi, ((File)record.mFileIds.get(192)).getEfid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.log("Loading PBR records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.createPbrFile((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 2: {
                this.log("Loading USIM ADN records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mPhoneBookRecords.addAll((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 3: {
                this.log("Loading USIM IAP records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mIapFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 4: {
                this.log("Loading USIM Email records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mEmailFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$log(String msg) {
        Rlog.d("UsimPhoneBookManager", msg);
    }

    private void __constructor__(IccFileHandler iccFileHandler, AdnRecordCache adnRecordCache) {
        this.$$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(iccFileHandler, adnRecordCache);
    }

    public UsimPhoneBookManager(IccFileHandler iccFileHandler, AdnRecordCache adnRecordCache) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$__constructor__(com.android.internal.telephony.uicc.IccFileHandler com.android.internal.telephony.uicc.AdnRecordCache ), 0, this, iccFileHandler, adnRecordCache);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$reset(), 0, this);
    }

    public ArrayList<AdnRecord> loadEfFilesFromUsim() {
        return InvokeDynamicSupport.bootstrap("loadEfFilesFromUsim", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$loadEfFilesFromUsim(), 0, this);
    }

    private void refreshCache() {
        InvokeDynamicSupport.bootstrap("refreshCache", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$refreshCache(), 0, this);
    }

    public void invalidateCache() {
        InvokeDynamicSupport.bootstrap("invalidateCache", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$invalidateCache(), 0, this);
    }

    private void readPbrFileAndWait() {
        InvokeDynamicSupport.bootstrap("readPbrFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readPbrFileAndWait(), 0, this);
    }

    private void readEmailFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readEmailFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailFileAndWait(int ), 0, this, n);
    }

    private void buildType1EmailList(int n) {
        InvokeDynamicSupport.bootstrap("buildType1EmailList", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$buildType1EmailList(int ), 0, this, n);
    }

    private boolean buildType2EmailList(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("buildType2EmailList", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$buildType2EmailList(int ), 0, this, n);
    }

    private void readIapFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readIapFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readIapFileAndWait(int ), 0, this, n);
    }

    private void updatePhoneAdnRecord() {
        InvokeDynamicSupport.bootstrap("updatePhoneAdnRecord", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$updatePhoneAdnRecord(), 0, this);
    }

    private String readEmailRecord(int n) {
        return InvokeDynamicSupport.bootstrap("readEmailRecord", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readEmailRecord(int ), 0, this, n);
    }

    private void readAdnFileAndWait(int n) {
        InvokeDynamicSupport.bootstrap("readAdnFileAndWait", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$readAdnFileAndWait(int ), 0, this, n);
    }

    private void createPbrFile(ArrayList<byte[]> arrayList) {
        InvokeDynamicSupport.bootstrap("createPbrFile", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$createPbrFile(java.util.ArrayList<byte[]> ), 0, this, arrayList);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$handleMessage(android.os.Message ), 0, this, message);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager$log(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ UsimPhoneBookManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsimPhoneBookManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PbrRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseArray<File> mFileIds;
        private int mMasterFileRecordNum;
        /* synthetic */ UsimPhoneBookManager this$0;

        private void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$__constructor__(UsimPhoneBookManager usimPhoneBookManager, byte[] record) {
            this.mFileIds = new SparseArray();
            usimPhoneBookManager.log("PBR rec: " + IccUtils.bytesToHexString(record));
            SimTlv recTlv = new SimTlv(record, 0, record.length);
            this.parseTag(recTlv);
        }

        private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$parseTag(SimTlv tlv) {
            do {
                int tag = tlv.getTag();
                switch (tag) {
                    case 168: 
                    case 169: 
                    case 170: {
                        byte[] data = tlv.getData();
                        SimTlv tlvEfSfi = new SimTlv(data, 0, data.length);
                        this.parseEfAndSFI(tlvEfSfi, tag);
                    }
                }
            } while (tlv.nextObject());
        }

        private final void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$parseEfAndSFI(SimTlv tlv, int parentTag) {
            int tagNumberWithinParentTag = 0;
            do {
                int tag = tlv.getTag();
                switch (tag) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: {
                        int sfi = -1;
                        byte[] data = tlv.getData();
                        if (data.length < 2 || data.length > 3) {
                            this.this$0.log("Invalid TLV length: " + data.length);
                            break;
                        }
                        if (data.length == 3) {
                            sfi = data[2] & 0xFF;
                        }
                        int efid = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
                        this.mFileIds.put(tag, new File(this.this$0, parentTag, efid, sfi, tagNumberWithinParentTag));
                    }
                }
                ++tagNumberWithinParentTag;
            } while (tlv.nextObject());
        }

        private void __constructor__(UsimPhoneBookManager usimPhoneBookManager, byte[] byArray) {
            this.$$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$__constructor__(usimPhoneBookManager, byArray);
        }

        PbrRecord(UsimPhoneBookManager usimPhoneBookManager, byte[] byArray) {
            this.this$0 = usimPhoneBookManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$__constructor__(com.android.internal.telephony.gsm.UsimPhoneBookManager byte[] ), 0, this, usimPhoneBookManager, byArray);
        }

        void parseTag(SimTlv simTlv) {
            InvokeDynamicSupport.bootstrap("parseTag", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$parseTag(com.android.internal.telephony.gsm.SimTlv ), 0, this, simTlv);
        }

        void parseEfAndSFI(SimTlv simTlv, int n) {
            InvokeDynamicSupport.bootstrap("parseEfAndSFI", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_PbrRecord$parseEfAndSFI(com.android.internal.telephony.gsm.SimTlv int ), 0, this, simTlv, n);
        }

        public /* synthetic */ PbrRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PbrRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class File
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mParentTag;
        private int mEfid;
        private int mSfi;
        private int mIndex;
        /* synthetic */ UsimPhoneBookManager this$0;

        private void $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$__constructor__(UsimPhoneBookManager usimPhoneBookManager, int parentTag, int efid, int sfi, int index) {
            this.mParentTag = parentTag;
            this.mEfid = efid;
            this.mSfi = sfi;
            this.mIndex = index;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getParentTag() {
            return this.mParentTag;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getEfid() {
            return this.mEfid;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getSfi() {
            return this.mSfi;
        }

        private final int $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getIndex() {
            return this.mIndex;
        }

        private void __constructor__(UsimPhoneBookManager usimPhoneBookManager, int n, int n2, int n3, int n4) {
            this.$$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$__constructor__(usimPhoneBookManager, n, n2, n3, n4);
        }

        File(UsimPhoneBookManager usimPhoneBookManager, int n, int n2, int n3, int n4) {
            this.this$0 = usimPhoneBookManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$__constructor__(com.android.internal.telephony.gsm.UsimPhoneBookManager int int int int ), 0, this, usimPhoneBookManager, n, n2, n3, n4);
        }

        public int getParentTag() {
            return (int)InvokeDynamicSupport.bootstrap("getParentTag", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getParentTag(), 0, this);
        }

        public int getEfid() {
            return (int)InvokeDynamicSupport.bootstrap("getEfid", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getEfid(), 0, this);
        }

        public int getSfi() {
            return (int)InvokeDynamicSupport.bootstrap("getSfi", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getSfi(), 0, this);
        }

        public int getIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getIndex", $$robo$$com_android_internal_telephony_gsm_UsimPhoneBookManager_File$getIndex(), 0, this);
        }

        public /* synthetic */ File() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (File)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

