/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsMMTelFeature;
import com.android.ims.internal.IImsServiceController;
import com.android.internal.telephony.ims.ImsConfigCompatAdapter;
import com.android.internal.telephony.ims.ImsRegistrationCompatAdapter;
import com.android.internal.telephony.ims.ImsServiceController;
import com.android.internal.telephony.ims.MmTelFeatureCompatAdapter;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsServiceControllerCompat
extends ImsServiceController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImsSCCompat";
    private IImsServiceController mServiceController;
    private SparseArray<MmTelFeatureCompatAdapter> mMmTelCompatAdapters;
    private SparseArray<ImsConfigCompatAdapter> mConfigCompatAdapters;
    private SparseArray<ImsRegistrationCompatAdapter> mRegCompatAdapters;

    private void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$__constructor__(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks callbacks) {
        this.mMmTelCompatAdapters = new SparseArray();
        this.mConfigCompatAdapters = new SparseArray();
        this.mRegCompatAdapters = new SparseArray();
    }

    private final String $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getServiceInterface() {
        return "android.telephony.ims.compat.ImsService";
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$enableIms(int slotId) {
        MmTelFeatureCompatAdapter adapter = this.mMmTelCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w("ImsSCCompat", "enableIms: adapter null for slot :" + slotId);
            return;
        }
        try {
            adapter.enableIms();
        }
        catch (RemoteException e) {
            Log.w("ImsSCCompat", "Couldn't enable IMS: " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$disableIms(int slotId) {
        MmTelFeatureCompatAdapter adapter = this.mMmTelCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w("ImsSCCompat", "enableIms: adapter null for slot :" + slotId);
            return;
        }
        try {
            adapter.disableIms();
        }
        catch (RemoteException e) {
            Log.w("ImsSCCompat", "Couldn't enable IMS: " + e.getMessage());
        }
    }

    private final IImsRegistration $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getRegistration(int slotId) throws RemoteException {
        ImsRegistrationCompatAdapter adapter = this.mRegCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w("ImsSCCompat", "getRegistration: Registration does not exist for slot " + slotId);
            return null;
        }
        return adapter.getBinder();
    }

    private final IImsConfig $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getConfig(int slotId) throws RemoteException {
        ImsConfigCompatAdapter adapter = this.mConfigCompatAdapters.get(slotId);
        if (adapter == null) {
            Log.w("ImsSCCompat", "getConfig: Config does not exist for slot " + slotId);
            return null;
        }
        return adapter.getIImsConfig();
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$notifyImsServiceReady() throws RemoteException {
        Log.d("ImsSCCompat", "notifyImsServiceReady");
    }

    private final IInterface $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        switch (featureType) {
            case 1: {
                return this.createMMTelCompat(slotId, c);
            }
            case 2: {
                return this.createRcsFeature(slotId, c);
            }
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) throws RemoteException {
        if (featureType == 1) {
            this.mMmTelCompatAdapters.remove(slotId);
            this.mRegCompatAdapters.remove(slotId);
            this.mConfigCompatAdapters.remove(slotId);
        }
        this.mServiceController.removeImsFeature(slotId, featureType, c);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$setServiceController(IBinder serviceController) {
        this.mServiceController = IImsServiceController.Stub.asInterface(serviceController);
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$isServiceControllerAvailable() {
        return this.mServiceController != null;
    }

    private final MmTelInterfaceAdapter $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getInterface(int slotId, IImsFeatureStatusCallback c) throws RemoteException {
        IImsMMTelFeature feature = this.mServiceController.createMMTelFeature(slotId, c);
        if (feature == null) {
            Log.w("ImsSCCompat", "createMMTelCompat: createMMTelFeature returned null.");
            return null;
        }
        return new MmTelInterfaceAdapter(slotId, feature.asBinder());
    }

    private final IImsMmTelFeature $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createMMTelCompat(int slotId, IImsFeatureStatusCallback c) throws RemoteException {
        MmTelInterfaceAdapter interfaceAdapter = this.getInterface(slotId, c);
        MmTelFeatureCompatAdapter mmTelAdapter = new MmTelFeatureCompatAdapter(this.mContext, slotId, interfaceAdapter);
        this.mMmTelCompatAdapters.put(slotId, mmTelAdapter);
        ImsRegistrationCompatAdapter regAdapter = new ImsRegistrationCompatAdapter();
        mmTelAdapter.addRegistrationAdapter(regAdapter);
        this.mRegCompatAdapters.put(slotId, regAdapter);
        this.mConfigCompatAdapters.put(slotId, new ImsConfigCompatAdapter(mmTelAdapter.getOldConfigInterface()));
        return mmTelAdapter.getBinder();
    }

    private final IImsRcsFeature $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createRcsFeature(int slotId, IImsFeatureStatusCallback c) {
        return null;
    }

    private void __constructor__(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$__constructor__(context, componentName, imsServiceControllerCallbacks);
    }

    public ImsServiceControllerCompat(Context context, ComponentName componentName, ImsServiceController.ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        super(context, componentName, imsServiceControllerCallbacks);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$__constructor__(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), 0, this, context, componentName, imsServiceControllerCallbacks);
    }

    @Override
    protected String getServiceInterface() {
        return InvokeDynamicSupport.bootstrap("getServiceInterface", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getServiceInterface(), 0, this);
    }

    @Override
    public void enableIms(int n) {
        InvokeDynamicSupport.bootstrap("enableIms", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$enableIms(int ), 0, this, n);
    }

    @Override
    public void disableIms(int n) {
        InvokeDynamicSupport.bootstrap("disableIms", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$disableIms(int ), 0, this, n);
    }

    @Override
    public IImsRegistration getRegistration(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getRegistration", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getRegistration(int ), 0, this, n);
    }

    @Override
    public IImsConfig getConfig(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getConfig(int ), 0, this, n);
    }

    @Override
    protected void notifyImsServiceReady() throws RemoteException {
        InvokeDynamicSupport.bootstrap("notifyImsServiceReady", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$notifyImsServiceReady(), 0, this);
    }

    @Override
    protected IInterface createImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createImsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
    }

    @Override
    protected void removeImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        InvokeDynamicSupport.bootstrap("removeImsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$removeImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, n2, iImsFeatureStatusCallback);
    }

    @Override
    protected void setServiceController(IBinder iBinder) {
        InvokeDynamicSupport.bootstrap("setServiceController", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$setServiceController(android.os.IBinder ), 0, this, iBinder);
    }

    @Override
    protected boolean isServiceControllerAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isServiceControllerAvailable", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$isServiceControllerAvailable(), 0, this);
    }

    protected MmTelInterfaceAdapter getInterface(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$getInterface(int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, iImsFeatureStatusCallback);
    }

    private IImsMmTelFeature createMMTelCompat(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createMMTelCompat", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createMMTelCompat(int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, iImsFeatureStatusCallback);
    }

    private IImsRcsFeature createRcsFeature(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        return InvokeDynamicSupport.bootstrap("createRcsFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceControllerCompat$createRcsFeature(int com.android.ims.internal.IImsFeatureStatusCallback ), 0, this, n, iImsFeatureStatusCallback);
    }

    public /* synthetic */ ImsServiceControllerCompat() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceControllerCompat)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

