/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.util.Log;
import com.android.ims.ImsConfigListener;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsUt;
import com.android.internal.telephony.ims.ImsRegistrationCompatAdapter;
import com.android.internal.telephony.ims.MmTelInterfaceAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MmTelFeatureCompatAdapter
extends MmTelFeature
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MmTelFeatureCompat";
    public static String ACTION_IMS_INCOMING_CALL = "com.android.ims.IMS_INCOMING_CALL";
    private static int WAIT_TIMEOUT_MS = 2000;
    private MmTelInterfaceAdapter mCompatFeature;
    private ImsRegistrationCompatAdapter mRegCompatAdapter;
    private int mSessionId;
    private static Map<Integer, Integer> REG_TECH_TO_NET_TYPE;
    public static int FEATURE_TYPE_UNKNOWN = -1;
    public static int FEATURE_TYPE_VOICE_OVER_LTE = 0;
    public static int FEATURE_TYPE_VIDEO_OVER_LTE = 1;
    public static int FEATURE_TYPE_VOICE_OVER_WIFI = 2;
    public static int FEATURE_TYPE_VIDEO_OVER_WIFI = 3;
    public static int FEATURE_TYPE_UT_OVER_LTE = 4;
    public static int FEATURE_TYPE_UT_OVER_WIFI = 5;
    public static int FEATURE_UNKNOWN = -1;
    public static int FEATURE_DISABLED = 0;
    public static int FEATURE_ENABLED = 1;
    private IImsRegistrationListener mListener;
    private BroadcastReceiver mReceiver;

    private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$__constructor__(Context context, int slotId, MmTelInterfaceAdapter compatFeature) {
        this.mSessionId = -1;
        this.mListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MmTelFeatureCompatAdapter this$0;

            private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$__constructor__(MmTelFeatureCompatAdapter this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationConnected() throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationProgressing() throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationConnectedWithRadioTech(int imsRadioTech) throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationProgressingWithRadioTech(int imsRadioTech) throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
                Log.i("MmTelFeatureCompat", "registrationDisconnected: resetting MMTEL capabilities.");
                this.this$0.notifyCapabilitiesStatusChanged(new MmTelFeature.MmTelCapabilities());
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationResumed() throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationSuspended() throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationServiceCapabilityChanged(int serviceClass, int event) throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) throws RemoteException {
                this.this$0.notifyCapabilitiesStatusChanged(this.this$0.convertCapabilities(enabledFeatures));
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$voiceMessageCountUpdate(int count) throws RemoteException {
                this.this$0.notifyVoiceMessageCountUpdate(count);
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationAssociatedUriChanged(Uri[] uris) throws RemoteException {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) throws RemoteException {
            }

            private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter) {
                this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$__constructor__(mmTelFeatureCompatAdapter);
            }
            {
                this.this$0 = mmTelFeatureCompatAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter ), 0, this, mmTelFeatureCompatAdapter);
            }

            @Override
            public void registrationConnected() throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationConnected", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationConnected(), 0, this);
            }

            @Override
            public void registrationProgressing() throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationProgressing", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationProgressing(), 0, this);
            }

            @Override
            public void registrationConnectedWithRadioTech(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationConnectedWithRadioTech", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationConnectedWithRadioTech(int ), 0, this, n);
            }

            @Override
            public void registrationProgressingWithRadioTech(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationProgressingWithRadioTech", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationProgressingWithRadioTech(int ), 0, this, n);
            }

            @Override
            public void registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationDisconnected", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationDisconnected(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
            }

            @Override
            public void registrationResumed() throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationResumed", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationResumed(), 0, this);
            }

            @Override
            public void registrationSuspended() throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationSuspended", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationSuspended(), 0, this);
            }

            @Override
            public void registrationServiceCapabilityChanged(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationServiceCapabilityChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationServiceCapabilityChanged(int int ), 0, this, n, n2);
            }

            @Override
            public void registrationFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationFeatureCapabilityChanged(int int[] int[] ), 0, this, n, nArray, nArray2);
            }

            @Override
            public void voiceMessageCountUpdate(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("voiceMessageCountUpdate", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$voiceMessageCountUpdate(int ), 0, this, n);
            }

            @Override
            public void registrationAssociatedUriChanged(Uri[] uriArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationAssociatedUriChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationAssociatedUriChanged(android.net.Uri[] ), 0, this, uriArray);
            }

            @Override
            public void registrationChangeFailed(int n, ImsReasonInfo imsReasonInfo) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registrationChangeFailed", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_1$registrationChangeFailed(int android.telephony.ims.ImsReasonInfo ), 0, this, n, imsReasonInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MmTelFeatureCompatAdapter this$0;

            private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_2$__constructor__(MmTelFeatureCompatAdapter this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_2$onReceive(Context context, Intent intent) {
                Log.i("MmTelFeatureCompat", "onReceive");
                if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                    Log.i("MmTelFeatureCompat", "onReceive : incoming call intent.");
                    String callId = intent.getStringExtra("android:imsCallID");
                    try {
                        IImsCallSession session = this.this$0.mCompatFeature.getPendingCallSession(this.this$0.mSessionId, callId);
                        this.this$0.notifyIncomingCallSession(session, intent.getExtras());
                    }
                    catch (RemoteException e) {
                        Log.w("MmTelFeatureCompat", "onReceive: Couldn't get Incoming call session.");
                    }
                }
            }

            private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter) {
                this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_2$__constructor__(mmTelFeatureCompatAdapter);
            }
            {
                this.this$0 = mmTelFeatureCompatAdapter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_2$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter ), 0, this, mmTelFeatureCompatAdapter);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.initialize(context, slotId);
        this.mCompatFeature = compatFeature;
    }

    private final boolean $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$queryCapabilityConfiguration(int capability, int radioTech) {
        int capConverted = this.convertCapability(capability, radioTech);
        CountDownLatch latch = new CountDownLatch(1);
        int[] returnValue = new int[]{-1};
        int regTech = REG_TECH_TO_NET_TYPE.getOrDefault(radioTech, -1);
        try {
            this.mCompatFeature.getConfigInterface().getFeatureValue(capConverted, regTech, (ImsConfigListener)new ShadowedObject(this, capConverted, regTech, latch, returnValue){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int[] val$returnValue;
                /* synthetic */ MmTelFeatureCompatAdapter this$0;

                private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_3$__constructor__(MmTelFeatureCompatAdapter this$0, int capability, int tech, CountDownLatch latch, int[] nArray) {
                }

                private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_3$getFeatureValueReceived(int value) {
                    this.val$returnValue[0] = value;
                }

                private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter, int n, int n2, CountDownLatch countDownLatch, int[] nArray) {
                    this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_3$__constructor__(mmTelFeatureCompatAdapter, n, n2, countDownLatch, nArray);
                }
                {
                    this.this$0 = mmTelFeatureCompatAdapter;
                    this.val$returnValue = nArray;
                    super(n, n2, countDownLatch);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_3$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter int int java.util.concurrent.CountDownLatch int[] ), 0, this, mmTelFeatureCompatAdapter, n, n2, countDownLatch, nArray);
                }

                @Override
                public void getFeatureValueReceived(int n) {
                    InvokeDynamicSupport.bootstrap("getFeatureValueReceived", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_3$getFeatureValueReceived(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        catch (RemoteException e) {
            Log.w("MmTelFeatureCompat", "queryCapabilityConfiguration");
        }
        try {
            latch.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Log.w("MmTelFeatureCompat", "queryCapabilityConfiguration - error waiting: " + e.getMessage());
        }
        return returnValue[0] == 1;
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$changeEnabledCapabilities(CapabilityChangeRequest request, ImsFeature.CapabilityCallbackProxy c) {
        if (request == null) {
            return;
        }
        try {
            int radioTechConverted;
            int capConverted;
            CountDownLatch latch;
            IImsConfig imsConfig = this.mCompatFeature.getConfigInterface();
            for (CapabilityChangeRequest.CapabilityPair cap : request.getCapabilitiesToDisable()) {
                latch = new CountDownLatch(1);
                capConverted = this.convertCapability(cap.getCapability(), cap.getRadioTech());
                radioTechConverted = REG_TECH_TO_NET_TYPE.getOrDefault(cap.getRadioTech(), -1);
                Log.i("MmTelFeatureCompat", "changeEnabledCapabilities - cap: " + capConverted + " radioTech: " + radioTechConverted + " disabled");
                imsConfig.setFeatureValue(capConverted, radioTechConverted, 0, (ImsConfigListener)new ShadowedObject(this, capConverted, radioTechConverted, latch, c, cap){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ImsFeature.CapabilityCallbackProxy val$c;
                    /* synthetic */ CapabilityChangeRequest.CapabilityPair val$cap;
                    /* synthetic */ MmTelFeatureCompatAdapter this$0;

                    private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_4$__constructor__(MmTelFeatureCompatAdapter this$0, int capability, int tech, CountDownLatch latch, ImsFeature.CapabilityCallbackProxy capabilityCallbackProxy, CapabilityChangeRequest.CapabilityPair capabilityPair) {
                    }

                    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_4$setFeatureValueReceived(int value) {
                        if (value != 0) {
                            if (this.val$c == null) {
                                return;
                            }
                            this.val$c.onChangeCapabilityConfigurationError(this.val$cap.getCapability(), this.val$cap.getRadioTech(), -1);
                        }
                        Log.i("MmTelFeatureCompat", "changeEnabledCapabilities - setFeatureValueReceived with value " + value);
                    }

                    private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter, int n, int n2, CountDownLatch countDownLatch, ImsFeature.CapabilityCallbackProxy capabilityCallbackProxy, CapabilityChangeRequest.CapabilityPair capabilityPair) {
                        this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_4$__constructor__(mmTelFeatureCompatAdapter, n, n2, countDownLatch, capabilityCallbackProxy, capabilityPair);
                    }
                    {
                        this.this$0 = mmTelFeatureCompatAdapter;
                        this.val$c = capabilityCallbackProxy;
                        this.val$cap = capabilityPair;
                        super(n, n2, countDownLatch);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_4$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter int int java.util.concurrent.CountDownLatch android.telephony.ims.feature.ImsFeature$CapabilityCallbackProxy android.telephony.ims.feature.CapabilityChangeRequest$CapabilityPair ), 0, this, mmTelFeatureCompatAdapter, n, n2, countDownLatch, capabilityCallbackProxy, capabilityPair);
                    }

                    @Override
                    public void setFeatureValueReceived(int n) {
                        InvokeDynamicSupport.bootstrap("setFeatureValueReceived", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_4$setFeatureValueReceived(int ), 0, this, n);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
            for (CapabilityChangeRequest.CapabilityPair cap : request.getCapabilitiesToEnable()) {
                latch = new CountDownLatch(1);
                capConverted = this.convertCapability(cap.getCapability(), cap.getRadioTech());
                radioTechConverted = REG_TECH_TO_NET_TYPE.getOrDefault(cap.getRadioTech(), -1);
                Log.i("MmTelFeatureCompat", "changeEnabledCapabilities - cap: " + capConverted + " radioTech: " + radioTechConverted + " enabled");
                imsConfig.setFeatureValue(capConverted, radioTechConverted, 1, (ImsConfigListener)new ShadowedObject(this, capConverted, radioTechConverted, latch, c, cap){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ImsFeature.CapabilityCallbackProxy val$c;
                    /* synthetic */ CapabilityChangeRequest.CapabilityPair val$cap;
                    /* synthetic */ MmTelFeatureCompatAdapter this$0;

                    private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_5$__constructor__(MmTelFeatureCompatAdapter this$0, int capability, int tech, CountDownLatch latch, ImsFeature.CapabilityCallbackProxy capabilityCallbackProxy, CapabilityChangeRequest.CapabilityPair capabilityPair) {
                    }

                    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_5$setFeatureValueReceived(int value) {
                        if (value != 1) {
                            if (this.val$c == null) {
                                return;
                            }
                            this.val$c.onChangeCapabilityConfigurationError(this.val$cap.getCapability(), this.val$cap.getRadioTech(), -1);
                        }
                        Log.i("MmTelFeatureCompat", "changeEnabledCapabilities - setFeatureValueReceived with value " + value);
                    }

                    private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter, int n, int n2, CountDownLatch countDownLatch, ImsFeature.CapabilityCallbackProxy capabilityCallbackProxy, CapabilityChangeRequest.CapabilityPair capabilityPair) {
                        this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_5$__constructor__(mmTelFeatureCompatAdapter, n, n2, countDownLatch, capabilityCallbackProxy, capabilityPair);
                    }
                    {
                        this.this$0 = mmTelFeatureCompatAdapter;
                        this.val$c = capabilityCallbackProxy;
                        this.val$cap = capabilityPair;
                        super(n, n2, countDownLatch);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_5$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter int int java.util.concurrent.CountDownLatch android.telephony.ims.feature.ImsFeature$CapabilityCallbackProxy android.telephony.ims.feature.CapabilityChangeRequest$CapabilityPair ), 0, this, mmTelFeatureCompatAdapter, n, n2, countDownLatch, capabilityCallbackProxy, capabilityPair);
                    }

                    @Override
                    public void setFeatureValueReceived(int n) {
                        InvokeDynamicSupport.bootstrap("setFeatureValueReceived", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_5$setFeatureValueReceived(int ), 0, this, n);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                latch.await(2000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (RemoteException | InterruptedException e) {
            Log.w("MmTelFeatureCompat", "changeEnabledCapabilities: Error processing: " + e.getMessage());
        }
    }

    private final ImsCallProfile $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createCallProfile(int callSessionType, int callType) {
        try {
            return this.mCompatFeature.createCallProfile(this.mSessionId, callSessionType, callType);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private final IImsCallSession $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createCallSessionInterface(ImsCallProfile profile) throws RemoteException {
        return this.mCompatFeature.createCallSession(this.mSessionId, profile);
    }

    private final IImsUt $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getUtInterface() throws RemoteException {
        return this.mCompatFeature.getUtInterface();
    }

    private final IImsEcbm $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getEcbmInterface() throws RemoteException {
        return this.mCompatFeature.getEcbmInterface();
    }

    private final IImsMultiEndpoint $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getMultiEndpointInterface() throws RemoteException {
        return this.mCompatFeature.getMultiEndpointInterface();
    }

    private final int $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getFeatureState() {
        try {
            return this.mCompatFeature.getFeatureState();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$setUiTtyMode(int mode, Message onCompleteMessage) {
        try {
            this.mCompatFeature.setUiTTYMode(mode, onCompleteMessage);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$onFeatureRemoved() {
        this.mContext.unregisterReceiver(this.mReceiver);
        try {
            this.mCompatFeature.endSession(this.mSessionId);
            this.mCompatFeature.removeRegistrationListener(this.mListener);
            if (this.mRegCompatAdapter != null) {
                this.mCompatFeature.removeRegistrationListener(this.mRegCompatAdapter.getRegistrationListener());
            }
        }
        catch (RemoteException e) {
            Log.w("MmTelFeatureCompat", "onFeatureRemoved: Couldn't end session: " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$onFeatureReady() {
        Log.i("MmTelFeatureCompat", "onFeatureReady called!");
        IntentFilter intentFilter = new IntentFilter("com.android.ims.IMS_INCOMING_CALL");
        this.mContext.registerReceiver(this.mReceiver, intentFilter);
        try {
            this.mSessionId = this.mCompatFeature.startSession(this.createIncomingCallPendingIntent(), new ImsRegistrationListenerBase(this));
            this.mCompatFeature.addRegistrationListener(this.mListener);
            this.mCompatFeature.addRegistrationListener(this.mRegCompatAdapter.getRegistrationListener());
        }
        catch (RemoteException e) {
            Log.e("MmTelFeatureCompat", "Couldn't start compat feature: " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$enableIms() throws RemoteException {
        this.mCompatFeature.turnOnIms();
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$disableIms() throws RemoteException {
        this.mCompatFeature.turnOffIms();
    }

    private final IImsConfig $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getOldConfigInterface() {
        try {
            return this.mCompatFeature.getConfigInterface();
        }
        catch (RemoteException e) {
            Log.w("MmTelFeatureCompat", "getOldConfigInterface(): " + e.getMessage());
            return null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$addRegistrationAdapter(ImsRegistrationCompatAdapter regCompat) throws RemoteException {
        this.mRegCompatAdapter = regCompat;
    }

    private final MmTelFeature.MmTelCapabilities $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$convertCapabilities(int[] enabledFeatures) {
        boolean[] featuresEnabled = new boolean[enabledFeatures.length];
        for (int i = 0; i <= 5 && i < enabledFeatures.length; ++i) {
            if (enabledFeatures[i] == i) {
                featuresEnabled[i] = true;
                continue;
            }
            if (enabledFeatures[i] != -1) continue;
            featuresEnabled[i] = false;
        }
        MmTelFeature.MmTelCapabilities capabilities = new MmTelFeature.MmTelCapabilities();
        if (featuresEnabled[0] || featuresEnabled[2]) {
            capabilities.addCapabilities(1);
        }
        if (featuresEnabled[1] || featuresEnabled[3]) {
            capabilities.addCapabilities(2);
        }
        if (featuresEnabled[4] || featuresEnabled[5]) {
            capabilities.addCapabilities(4);
        }
        Log.i("MmTelFeatureCompat", "convertCapabilities - capabilities: " + capabilities);
        return capabilities;
    }

    private final PendingIntent $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.setPackage("com.android.phone");
        return PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000);
    }

    private final int $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$convertCapability(int capability, int radioTech) {
        int capConverted = -1;
        if (radioTech == 0) {
            switch (capability) {
                case 1: {
                    capConverted = 0;
                    break;
                }
                case 2: {
                    capConverted = 1;
                    break;
                }
                case 4: {
                    capConverted = 4;
                }
            }
        } else if (radioTech == 1) {
            switch (capability) {
                case 1: {
                    capConverted = 2;
                    break;
                }
                case 2: {
                    capConverted = 3;
                    break;
                }
                case 4: {
                    capConverted = 5;
                }
            }
        }
        return capConverted;
    }

    static void __staticInitializer__() {
        REG_TECH_TO_NET_TYPE = new HashMap<Integer, Integer>(2);
        REG_TECH_TO_NET_TYPE.put(0, 13);
        REG_TECH_TO_NET_TYPE.put(1, 18);
    }

    private void __constructor__(Context context, int n, MmTelInterfaceAdapter mmTelInterfaceAdapter) {
        this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$__constructor__(context, n, mmTelInterfaceAdapter);
    }

    public MmTelFeatureCompatAdapter(Context context, int n, MmTelInterfaceAdapter mmTelInterfaceAdapter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$__constructor__(android.content.Context int com.android.internal.telephony.ims.MmTelInterfaceAdapter ), 0, this, context, n, mmTelInterfaceAdapter);
    }

    @Override
    public boolean queryCapabilityConfiguration(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("queryCapabilityConfiguration", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$queryCapabilityConfiguration(int int ), 0, this, n, n2);
    }

    @Override
    public void changeEnabledCapabilities(CapabilityChangeRequest capabilityChangeRequest, ImsFeature.CapabilityCallbackProxy capabilityCallbackProxy) {
        InvokeDynamicSupport.bootstrap("changeEnabledCapabilities", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$changeEnabledCapabilities(android.telephony.ims.feature.CapabilityChangeRequest android.telephony.ims.feature.ImsFeature$CapabilityCallbackProxy ), 0, this, capabilityChangeRequest, capabilityCallbackProxy);
    }

    @Override
    public ImsCallProfile createCallProfile(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createCallProfile", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createCallProfile(int int ), 0, this, n, n2);
    }

    @Override
    public IImsCallSession createCallSessionInterface(ImsCallProfile imsCallProfile) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("createCallSessionInterface", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createCallSessionInterface(android.telephony.ims.ImsCallProfile ), 0, this, imsCallProfile);
    }

    @Override
    public IImsUt getUtInterface() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getUtInterface", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getUtInterface(), 0, this);
    }

    @Override
    public IImsEcbm getEcbmInterface() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getEcbmInterface", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getEcbmInterface(), 0, this);
    }

    @Override
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getMultiEndpointInterface", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getMultiEndpointInterface(), 0, this);
    }

    @Override
    public int getFeatureState() {
        return (int)InvokeDynamicSupport.bootstrap("getFeatureState", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getFeatureState(), 0, this);
    }

    @Override
    public void setUiTtyMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTtyMode", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$setUiTtyMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void onFeatureRemoved() {
        InvokeDynamicSupport.bootstrap("onFeatureRemoved", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$onFeatureRemoved(), 0, this);
    }

    @Override
    public void onFeatureReady() {
        InvokeDynamicSupport.bootstrap("onFeatureReady", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$onFeatureReady(), 0, this);
    }

    public void enableIms() throws RemoteException {
        InvokeDynamicSupport.bootstrap("enableIms", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$enableIms(), 0, this);
    }

    public void disableIms() throws RemoteException {
        InvokeDynamicSupport.bootstrap("disableIms", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$disableIms(), 0, this);
    }

    public IImsConfig getOldConfigInterface() {
        return InvokeDynamicSupport.bootstrap("getOldConfigInterface", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$getOldConfigInterface(), 0, this);
    }

    public void addRegistrationAdapter(ImsRegistrationCompatAdapter imsRegistrationCompatAdapter) throws RemoteException {
        InvokeDynamicSupport.bootstrap("addRegistrationAdapter", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$addRegistrationAdapter(com.android.internal.telephony.ims.ImsRegistrationCompatAdapter ), 0, this, imsRegistrationCompatAdapter);
    }

    private MmTelFeature.MmTelCapabilities convertCapabilities(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("convertCapabilities", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$convertCapabilities(int[] ), 0, this, nArray);
    }

    private PendingIntent createIncomingCallPendingIntent() {
        return InvokeDynamicSupport.bootstrap("createIncomingCallPendingIntent", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$createIncomingCallPendingIntent(), 0, this);
    }

    private int convertCapability(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("convertCapability", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter$convertCapability(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(MmTelFeatureCompatAdapter.class);
    }

    public /* synthetic */ MmTelFeatureCompatAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MmTelFeatureCompatAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ImsRegistrationListenerBase
    extends IImsRegistrationListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MmTelFeatureCompatAdapter this$0;

        private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$__constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter) {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationConnected() throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationProgressing() throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationConnectedWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationProgressingWithRadioTech(int imsRadioTech) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationResumed() throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationSuspended() throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationServiceCapabilityChanged(int serviceClass, int event) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$voiceMessageCountUpdate(int count) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationAssociatedUriChanged(Uri[] uris) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationChangeFailed(int targetAccessTech, ImsReasonInfo imsReasonInfo) throws RemoteException {
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$__constructor__(MmTelFeatureCompatAdapter x0, 1 x1) {
        }

        private void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter) {
            this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$__constructor__(mmTelFeatureCompatAdapter);
        }

        private ImsRegistrationListenerBase(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter) {
            this.this$0 = mmTelFeatureCompatAdapter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$__constructor__(com.android.internal.telephony.ims.MmTelFeatureCompatAdapter ), 0, this, mmTelFeatureCompatAdapter);
        }

        @Override
        public void registrationConnected() throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationConnected", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationConnected(), 0, this);
        }

        @Override
        public void registrationProgressing() throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationProgressing", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationProgressing(), 0, this);
        }

        @Override
        public void registrationConnectedWithRadioTech(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationConnectedWithRadioTech", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationConnectedWithRadioTech(int ), 0, this, n);
        }

        @Override
        public void registrationProgressingWithRadioTech(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationProgressingWithRadioTech", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationProgressingWithRadioTech(int ), 0, this, n);
        }

        @Override
        public void registrationDisconnected(ImsReasonInfo imsReasonInfo) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationDisconnected", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationDisconnected(android.telephony.ims.ImsReasonInfo ), 0, this, imsReasonInfo);
        }

        @Override
        public void registrationResumed() throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationResumed", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationResumed(), 0, this);
        }

        @Override
        public void registrationSuspended() throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationSuspended", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationSuspended(), 0, this);
        }

        @Override
        public void registrationServiceCapabilityChanged(int n, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationServiceCapabilityChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationServiceCapabilityChanged(int int ), 0, this, n, n2);
        }

        @Override
        public void registrationFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationFeatureCapabilityChanged(int int[] int[] ), 0, this, n, nArray, nArray2);
        }

        @Override
        public void voiceMessageCountUpdate(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("voiceMessageCountUpdate", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$voiceMessageCountUpdate(int ), 0, this, n);
        }

        @Override
        public void registrationAssociatedUriChanged(Uri[] uriArray) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationAssociatedUriChanged", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationAssociatedUriChanged(android.net.Uri[] ), 0, this, uriArray);
        }

        @Override
        public void registrationChangeFailed(int n, ImsReasonInfo imsReasonInfo) throws RemoteException {
            InvokeDynamicSupport.bootstrap("registrationChangeFailed", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$registrationChangeFailed(int android.telephony.ims.ImsReasonInfo ), 0, this, n, imsReasonInfo);
        }

        private /* synthetic */ void __constructor__(MmTelFeatureCompatAdapter mmTelFeatureCompatAdapter, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ImsRegistrationListenerBase$__constructor__(mmTelFeatureCompatAdapter, var2_2);
        }

        public /* synthetic */ ImsRegistrationListenerBase() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsRegistrationListenerBase)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ConfigListener
    extends ImsConfigListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mCapability;
        private int mTech;
        private CountDownLatch mLatch;

        private void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$__constructor__(int capability, int tech, CountDownLatch latch) {
            this.mCapability = capability;
            this.mTech = tech;
            this.mLatch = latch;
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onGetFeatureResponse(int feature, int network, int value, int status) throws RemoteException {
            if (feature == this.mCapability && network == this.mTech) {
                this.mLatch.countDown();
                this.getFeatureValueReceived(value);
            } else {
                Log.i("MmTelFeatureCompat", "onGetFeatureResponse: response different than requested: feature=" + feature + " and network=" + network);
            }
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onSetFeatureResponse(int feature, int network, int value, int status) throws RemoteException {
            if (feature == this.mCapability && network == this.mTech) {
                this.mLatch.countDown();
                this.setFeatureValueReceived(value);
            } else {
                Log.i("MmTelFeatureCompat", "onSetFeatureResponse: response different than requested: feature=" + feature + " and network=" + network);
            }
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onGetVideoQuality(int status, int quality) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onSetVideoQuality(int status) throws RemoteException {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$getFeatureValueReceived(int value) {
        }

        private final void $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$setFeatureValueReceived(int value) {
        }

        private void __constructor__(int n, int n2, CountDownLatch countDownLatch) {
            this.$$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$__constructor__(n, n2, countDownLatch);
        }

        public ConfigListener(int n, int n2, CountDownLatch countDownLatch) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$__constructor__(int int java.util.concurrent.CountDownLatch ), 0, this, n, n2, countDownLatch);
        }

        @Override
        public void onGetFeatureResponse(int n, int n2, int n3, int n4) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onGetFeatureResponse", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onGetFeatureResponse(int int int int ), 0, this, n, n2, n3, n4);
        }

        @Override
        public void onSetFeatureResponse(int n, int n2, int n3, int n4) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onSetFeatureResponse", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onSetFeatureResponse(int int int int ), 0, this, n, n2, n3, n4);
        }

        @Override
        public void onGetVideoQuality(int n, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onGetVideoQuality", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onGetVideoQuality(int int ), 0, this, n, n2);
        }

        @Override
        public void onSetVideoQuality(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onSetVideoQuality", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$onSetVideoQuality(int ), 0, this, n);
        }

        public void getFeatureValueReceived(int n) {
            InvokeDynamicSupport.bootstrap("getFeatureValueReceived", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$getFeatureValueReceived(int ), 0, this, n);
        }

        public void setFeatureValueReceived(int n) {
            InvokeDynamicSupport.bootstrap("setFeatureValueReceived", $$robo$$com_android_internal_telephony_ims_MmTelFeatureCompatAdapter_ConfigListener$setFeatureValueReceived(int ), 0, this, n);
        }

        public /* synthetic */ ConfigListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfigListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

