/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telecom.VideoProfile;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsExternalCallState;
import android.util.ArrayMap;
import android.util.Log;
import com.android.ims.ImsExternalCallStateListener;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.imsphone.ImsExternalConnection;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPullCall;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsExternalCallTracker
implements ImsPhoneCallTracker.PhoneStateListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG = "ImsExternalCallTracker";
    private static int EVENT_VIDEO_CAPABILITIES_CHANGED = 1;
    public static String EXTRA_IMS_EXTERNAL_CALL_ID = "android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID";
    private Map<Integer, ImsExternalConnection> mExternalConnections;
    private Map<Integer, Boolean> mExternalCallPullableState;
    private ImsPhone mPhone;
    private ImsCallNotify mCallStateNotifier;
    private ExternalCallStateListener mExternalCallStateListener;
    private ExternalConnectionListener mExternalConnectionListener;
    private ImsPullCall mCallPuller;
    private boolean mIsVideoCapable;
    private boolean mHasActiveCalls;
    private Handler mHandler;

    @VisibleForTesting
    private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(ImsPhone phone, ImsPullCall callPuller, ImsCallNotify callNotifier) {
        this.mExternalConnections = new ArrayMap<Integer, ImsExternalConnection>();
        this.mExternalCallPullableState = new ArrayMap<Integer, Boolean>();
        this.mExternalConnectionListener = new ExternalConnectionListener(this);
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsExternalCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_1$__constructor__(ImsExternalCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.handleVideoCapabilitiesChanged((AsyncResult)msg.obj);
                        break;
                    }
                }
            }

            private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_1$__constructor__(imsExternalCallTracker);
            }
            {
                this.this$0 = imsExternalCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_1$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mCallStateNotifier = callNotifier;
        this.mExternalCallStateListener = new ExternalCallStateListener(this);
        this.mCallPuller = callPuller;
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(ImsPhone phone) {
        this.mExternalConnections = new ArrayMap<Integer, ImsExternalConnection>();
        this.mExternalCallPullableState = new ArrayMap<Integer, Boolean>();
        this.mExternalConnectionListener = new ExternalConnectionListener(this);
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        this.mPhone = phone;
        this.mCallStateNotifier = new ImsCallNotify(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsExternalCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$__constructor__(ImsExternalCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$notifyUnknownConnection(Connection c) {
                this.this$0.mPhone.notifyUnknownConnection(c);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$notifyPreciseCallStateChanged() {
                this.this$0.mPhone.notifyPreciseCallStateChanged();
            }

            private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$__constructor__(imsExternalCallTracker);
            }
            {
                this.this$0 = imsExternalCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
            }

            @Override
            public void notifyUnknownConnection(Connection connection) {
                InvokeDynamicSupport.bootstrap("notifyUnknownConnection", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$notifyUnknownConnection(com.android.internal.telephony.Connection ), 0, this, connection);
            }

            @Override
            public void notifyPreciseCallStateChanged() {
                InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_2$notifyPreciseCallStateChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mExternalCallStateListener = new ExternalCallStateListener(this);
        this.registerForNotifications();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$tearDown() {
        this.unregisterForNotifications();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$setCallPuller(ImsPullCall callPuller) {
        this.mCallPuller = callPuller;
    }

    private final ExternalCallStateListener $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getExternalCallStateListener() {
        return this.mExternalCallStateListener;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$onPhoneStateChanged(PhoneConstants.State oldState, PhoneConstants.State newState) {
        this.mHasActiveCalls = newState != PhoneConstants.State.IDLE;
        Log.i("ImsExternalCallTracker", "onPhoneStateChanged : hasActiveCalls = " + this.mHasActiveCalls);
        this.refreshCallPullState();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$registerForNotifications() {
        if (this.mPhone != null) {
            Log.d("ImsExternalCallTracker", "Registering: " + this.mPhone);
            this.mPhone.getDefaultPhone().registerForVideoCapabilityChanged(this.mHandler, 1, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$unregisterForNotifications() {
        if (this.mPhone != null) {
            Log.d("ImsExternalCallTracker", "Unregistering: " + this.mPhone);
            this.mPhone.unregisterForVideoCapabilityChanged(this.mHandler);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshExternalCallState(List<ImsExternalCallState> externalCallStates) {
        Log.d("ImsExternalCallTracker", "refreshExternalCallState");
        Iterator<Map.Entry<Integer, ImsExternalConnection>> connectionIterator = this.mExternalConnections.entrySet().iterator();
        boolean wasCallRemoved = false;
        while (connectionIterator.hasNext()) {
            Map.Entry<Integer, ImsExternalConnection> entry = connectionIterator.next();
            int callId = entry.getKey();
            if (this.containsCallId(externalCallStates, callId)) continue;
            ImsExternalConnection externalConnection = entry.getValue();
            externalConnection.setTerminated();
            externalConnection.removeListener(this.mExternalConnectionListener);
            connectionIterator.remove();
            wasCallRemoved = true;
        }
        if (wasCallRemoved) {
            this.mCallStateNotifier.notifyPreciseCallStateChanged();
        }
        if (externalCallStates != null && !externalCallStates.isEmpty()) {
            for (ImsExternalCallState callState : externalCallStates) {
                if (!this.mExternalConnections.containsKey(callState.getCallId())) {
                    Log.d("ImsExternalCallTracker", "refreshExternalCallState: got = " + callState);
                    if (callState.getCallState() != 1) continue;
                    this.createExternalConnection(callState);
                    continue;
                }
                this.updateExistingConnection(this.mExternalConnections.get(callState.getCallId()), callState);
            }
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getConnectionById(int callId) {
        return this.mExternalConnections.get(callId);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$createExternalConnection(ImsExternalCallState state) {
        Log.i("ImsExternalCallTracker", "createExternalConnection : state = " + state);
        int videoState = ImsCallProfile.getVideoStateFromCallType(state.getCallType());
        boolean isCallPullPermitted = this.isCallPullPermitted(state.isCallPullable(), videoState);
        ImsExternalConnection connection = new ImsExternalConnection(this.mPhone, state.getCallId(), state.getAddress(), isCallPullPermitted);
        connection.setVideoState(videoState);
        connection.addListener(this.mExternalConnectionListener);
        Log.d("ImsExternalCallTracker", "createExternalConnection - pullable state : externalCallId = " + connection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + state.isCallPullable() + " ; isVideo = " + VideoProfile.isVideo(videoState) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
        this.mExternalConnections.put(connection.getCallId(), connection);
        this.mExternalCallPullableState.put(connection.getCallId(), state.isCallPullable());
        this.mCallStateNotifier.notifyUnknownConnection(connection);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$updateExistingConnection(ImsExternalConnection connection, ImsExternalCallState state) {
        int newVideoState;
        Call.State newState;
        Log.i("ImsExternalCallTracker", "updateExistingConnection : state = " + state);
        Call.State existingState = connection.getState();
        Call.State state2 = newState = state.getCallState() == 1 ? Call.State.ACTIVE : Call.State.DISCONNECTED;
        if (existingState != newState) {
            if (newState == Call.State.ACTIVE) {
                connection.setActive();
            } else {
                connection.setTerminated();
                connection.removeListener(this.mExternalConnectionListener);
                this.mExternalConnections.remove(connection.getCallId());
                this.mExternalCallPullableState.remove(connection.getCallId());
                this.mCallStateNotifier.notifyPreciseCallStateChanged();
            }
        }
        if ((newVideoState = ImsCallProfile.getVideoStateFromCallType(state.getCallType())) != connection.getVideoState()) {
            connection.setVideoState(newVideoState);
        }
        this.mExternalCallPullableState.put(state.getCallId(), state.isCallPullable());
        boolean isCallPullPermitted = this.isCallPullPermitted(state.isCallPullable(), newVideoState);
        Log.d("ImsExternalCallTracker", "updateExistingConnection - pullable state : externalCallId = " + connection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + state.isCallPullable() + " ; isVideo = " + VideoProfile.isVideo(connection.getVideoState()) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
        connection.setIsPullable(isCallPullPermitted);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshCallPullState() {
        Log.d("ImsExternalCallTracker", "refreshCallPullState");
        for (ImsExternalConnection imsExternalConnection : this.mExternalConnections.values()) {
            boolean isNetworkPullable = this.mExternalCallPullableState.get(imsExternalConnection.getCallId());
            boolean isCallPullPermitted = this.isCallPullPermitted(isNetworkPullable, imsExternalConnection.getVideoState());
            Log.d("ImsExternalCallTracker", "refreshCallPullState : externalCallId = " + imsExternalConnection.getCallId() + " ; isPullable = " + isCallPullPermitted + " ; networkPullable = " + isNetworkPullable + " ; isVideo = " + VideoProfile.isVideo(imsExternalConnection.getVideoState()) + " ; videoEnabled = " + this.mIsVideoCapable + " ; hasActiveCalls = " + this.mHasActiveCalls);
            imsExternalConnection.setIsPullable(isCallPullPermitted);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$containsCallId(List<ImsExternalCallState> externalCallStates, int callId) {
        if (externalCallStates == null) {
            return false;
        }
        for (ImsExternalCallState state : externalCallStates) {
            if (state.getCallId() != callId) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$handleVideoCapabilitiesChanged(AsyncResult ar) {
        this.mIsVideoCapable = (Boolean)ar.result;
        Log.i("ImsExternalCallTracker", "handleVideoCapabilitiesChanged : isVideoCapable = " + this.mIsVideoCapable);
        this.refreshCallPullState();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$isCallPullPermitted(boolean isNetworkPullable, int videoState) {
        if (VideoProfile.isVideo(videoState) && !this.mIsVideoCapable) {
            return false;
        }
        if (this.mHasActiveCalls) {
            return false;
        }
        return isNetworkPullable;
    }

    private void __constructor__(ImsPhone imsPhone, ImsPullCall imsPullCall, ImsCallNotify imsCallNotify) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(imsPhone, imsPullCall, imsCallNotify);
    }

    public ImsExternalCallTracker(ImsPhone imsPhone, ImsPullCall imsPullCall, ImsCallNotify imsCallNotify) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone com.android.internal.telephony.imsphone.ImsPullCall com.android.internal.telephony.imsphone.ImsExternalCallTracker$ImsCallNotify ), 0, this, imsPhone, imsPullCall, imsCallNotify);
    }

    private void __constructor__(ImsPhone imsPhone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(imsPhone);
    }

    public ImsExternalCallTracker(ImsPhone imsPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), 0, this, imsPhone);
    }

    public void tearDown() {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$tearDown(), 0, this);
    }

    public void setCallPuller(ImsPullCall imsPullCall) {
        InvokeDynamicSupport.bootstrap("setCallPuller", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$setCallPuller(com.android.internal.telephony.imsphone.ImsPullCall ), 0, this, imsPullCall);
    }

    public ExternalCallStateListener getExternalCallStateListener() {
        return InvokeDynamicSupport.bootstrap("getExternalCallStateListener", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getExternalCallStateListener(), 0, this);
    }

    @Override
    public void onPhoneStateChanged(PhoneConstants.State state, PhoneConstants.State state2) {
        InvokeDynamicSupport.bootstrap("onPhoneStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$onPhoneStateChanged(com.android.internal.telephony.PhoneConstants$State com.android.internal.telephony.PhoneConstants$State ), 0, this, state, state2);
    }

    private void registerForNotifications() {
        InvokeDynamicSupport.bootstrap("registerForNotifications", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$registerForNotifications(), 0, this);
    }

    private void unregisterForNotifications() {
        InvokeDynamicSupport.bootstrap("unregisterForNotifications", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$unregisterForNotifications(), 0, this);
    }

    public void refreshExternalCallState(List<ImsExternalCallState> list) {
        InvokeDynamicSupport.bootstrap("refreshExternalCallState", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshExternalCallState(java.util.List<android.telephony.ims.ImsExternalCallState> ), 0, this, list);
    }

    public Connection getConnectionById(int n) {
        return InvokeDynamicSupport.bootstrap("getConnectionById", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$getConnectionById(int ), 0, this, n);
    }

    private void createExternalConnection(ImsExternalCallState imsExternalCallState) {
        InvokeDynamicSupport.bootstrap("createExternalConnection", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$createExternalConnection(android.telephony.ims.ImsExternalCallState ), 0, this, imsExternalCallState);
    }

    private void updateExistingConnection(ImsExternalConnection imsExternalConnection, ImsExternalCallState imsExternalCallState) {
        InvokeDynamicSupport.bootstrap("updateExistingConnection", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$updateExistingConnection(com.android.internal.telephony.imsphone.ImsExternalConnection android.telephony.ims.ImsExternalCallState ), 0, this, imsExternalConnection, imsExternalCallState);
    }

    private void refreshCallPullState() {
        InvokeDynamicSupport.bootstrap("refreshCallPullState", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$refreshCallPullState(), 0, this);
    }

    private boolean containsCallId(List<ImsExternalCallState> list, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsCallId", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$containsCallId(java.util.List<android.telephony.ims.ImsExternalCallState> int ), 0, this, list, n);
    }

    private void handleVideoCapabilitiesChanged(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleVideoCapabilitiesChanged", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$handleVideoCapabilitiesChanged(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private boolean isCallPullPermitted(boolean bl, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCallPullPermitted", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker$isCallPullPermitted(boolean int ), 0, this, bl, n);
    }

    public /* synthetic */ ImsExternalCallTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsExternalCallTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class ExternalConnectionListener
    implements ImsExternalConnection.Listener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsExternalCallTracker this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(ImsExternalCallTracker this$0) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$onPullExternalCall(ImsExternalConnection connection) {
            Log.d("ImsExternalCallTracker", "onPullExternalCall: connection = " + connection);
            if (this.this$0.mCallPuller == null) {
                Log.e("ImsExternalCallTracker", "onPullExternalCall : No call puller defined");
                return;
            }
            this.this$0.mCallPuller.pullExternalCall(connection.getAddress(), connection.getVideoState(), connection.getCallId());
        }

        private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(imsExternalCallTracker);
        }

        public ExternalConnectionListener(ImsExternalCallTracker imsExternalCallTracker) {
            this.this$0 = imsExternalCallTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
        }

        @Override
        public void onPullExternalCall(ImsExternalConnection imsExternalConnection) {
            InvokeDynamicSupport.bootstrap("onPullExternalCall", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalConnectionListener$onPullExternalCall(com.android.internal.telephony.imsphone.ImsExternalConnection ), 0, this, imsExternalConnection);
        }

        public /* synthetic */ ExternalConnectionListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalConnectionListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ExternalCallStateListener
    extends ImsExternalCallStateListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsExternalCallTracker this$0;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(ImsExternalCallTracker this$0) {
        }

        private final void $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$onImsExternalCallStateUpdate(List<ImsExternalCallState> externalCallState) {
            this.this$0.refreshExternalCallState(externalCallState);
        }

        private void __constructor__(ImsExternalCallTracker imsExternalCallTracker) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(imsExternalCallTracker);
        }

        public ExternalCallStateListener(ImsExternalCallTracker imsExternalCallTracker) {
            this.this$0 = imsExternalCallTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$__constructor__(com.android.internal.telephony.imsphone.ImsExternalCallTracker ), 0, this, imsExternalCallTracker);
        }

        @Override
        public void onImsExternalCallStateUpdate(List<ImsExternalCallState> list) {
            InvokeDynamicSupport.bootstrap("onImsExternalCallStateUpdate", $$robo$$com_android_internal_telephony_imsphone_ImsExternalCallTracker_ExternalCallStateListener$onImsExternalCallStateUpdate(java.util.List<android.telephony.ims.ImsExternalCallState> ), 0, this, list);
        }

        public /* synthetic */ ExternalCallStateListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalCallStateListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ImsCallNotify
    extends InstrumentedInterface {
        public void notifyUnknownConnection(Connection var1);

        public void notifyPreciseCallStateChanged();
    }
}

